/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.component;

import biweekly.ICalVersion;
import biweekly.component.VFreeBusy;
import biweekly.io.scribe.component.ICalComponentScribe;
import biweekly.property.FreeBusy;
import biweekly.property.ICalProperty;
import biweekly.util.Period;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VFreeBusyScribe
extends ICalComponentScribe<VFreeBusy> {
    public VFreeBusyScribe() {
        super(VFreeBusy.class, "VFREEBUSY");
    }

    @Override
    public List<ICalProperty> getProperties(VFreeBusy component) {
        List<ICalProperty> properties = super.getProperties(component);
        ArrayList<FreeBusy> fb = new ArrayList<FreeBusy>(component.getFreeBusy());
        if (fb.isEmpty()) {
            return properties;
        }
        Collections.sort(fb, new Comparator<FreeBusy>(){

            @Override
            public int compare(FreeBusy one, FreeBusy two) {
                Date oneStart = this.getEarliestStartDate(one);
                Date twoStart = this.getEarliestStartDate(two);
                if (oneStart == null && twoStart == null) {
                    return 0;
                }
                if (oneStart == null) {
                    return 1;
                }
                if (twoStart == null) {
                    return -1;
                }
                return oneStart.compareTo(twoStart);
            }

            private Date getEarliestStartDate(FreeBusy fb) {
                Date date = null;
                for (Period tp : fb.getValues()) {
                    if (tp.getStartDate() == null || date != null && date.compareTo(tp.getStartDate()) <= 0) continue;
                    date = tp.getStartDate();
                }
                return date;
            }
        });
        int index = 0;
        for (ICalProperty prop : properties) {
            if (prop instanceof FreeBusy) break;
            ++index;
        }
        for (FreeBusy f : fb) {
            properties.remove(f);
            properties.add(index++, f);
        }
        return properties;
    }

    @Override
    protected VFreeBusy _newInstance() {
        return new VFreeBusy();
    }

    @Override
    public Set<ICalVersion> getSupportedVersions() {
        return EnumSet.of(ICalVersion.V2_0_DEPRECATED, ICalVersion.V2_0);
    }
}

