/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.jgroups;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.jgroups.Address;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SolverParameterGroup;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.server.InMemoryServer;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.instructor.InstructorSchedulingProxy;
import org.unitime.timetable.solver.jgroups.AbstractSolverServer;
import org.unitime.timetable.solver.jgroups.CourseSolverContainer;
import org.unitime.timetable.solver.jgroups.ExaminationSolverContainer;
import org.unitime.timetable.solver.jgroups.InstructorSchedulingContainer;
import org.unitime.timetable.solver.jgroups.OnlineStudentSchedulingContainer;
import org.unitime.timetable.solver.jgroups.OnlineStudentSchedulingGenericUpdater;
import org.unitime.timetable.solver.jgroups.SolverContainer;
import org.unitime.timetable.solver.jgroups.SolverServer;
import org.unitime.timetable.solver.jgroups.StudentSolverContainer;
import org.unitime.timetable.solver.studentsct.StudentSolverProxy;

public class LocalSolverServer
extends AbstractSolverServer {
    private CourseSolverContainer iCourseSolverContainer = new CourseSolverContainer();
    private ExaminationSolverContainer iExamSolverContainer = new ExaminationSolverContainer();
    private StudentSolverContainer iStudentSolverContainer = new StudentSolverContainer();
    private InstructorSchedulingContainer iInstructorSchedulingContainer = new InstructorSchedulingContainer();
    private OnlineStudentSchedulingContainer iOnlineStudentSchedulingContainer = new OnlineStudentSchedulingContainer();
    private Updater iUpdater = new Updater();

    @Override
    public void start() {
        this.iCourseSolverContainer.start();
        this.iExamSolverContainer.start();
        this.iStudentSolverContainer.start();
        this.iInstructorSchedulingContainer.start();
        this.iOnlineStudentSchedulingContainer.start();
        this.iUpdater.start();
        super.start();
    }

    @Override
    public void stop() {
        super.stop();
        this.iCourseSolverContainer.stop();
        this.iExamSolverContainer.stop();
        this.iStudentSolverContainer.stop();
        this.iInstructorSchedulingContainer.stop();
        this.iOnlineStudentSchedulingContainer.stop();
        this.iUpdater.stopUpdating();
    }

    @Override
    public void shutdown() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getUsage() {
        int ret = super.getUsage();
        ret += this.iCourseSolverContainer.getUsage();
        ret += this.iExamSolverContainer.getUsage();
        ret += this.iStudentSolverContainer.getUsage();
        ret += this.iInstructorSchedulingContainer.getUsage();
        return ret += this.iOnlineStudentSchedulingContainer.getUsage();
    }

    @Override
    public List<SolverServer> getServers(boolean onlyAvailable) {
        ArrayList<SolverServer> servers = new ArrayList<SolverServer>();
        if (!onlyAvailable || this.isActive()) {
            servers.add(this);
        }
        return servers;
    }

    @Override
    public SolverServer crateServerProxy(Address address) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SolverContainer<SolverProxy> getCourseSolverContainer() {
        return this.iCourseSolverContainer;
    }

    @Override
    public SolverContainer<ExamSolverProxy> getExamSolverContainer() {
        return this.iExamSolverContainer;
    }

    @Override
    public SolverContainer<StudentSolverProxy> getStudentSolverContainer() {
        return this.iStudentSolverContainer;
    }

    @Override
    public SolverContainer<InstructorSchedulingProxy> getInstructorSchedulingContainer() {
        return this.iInstructorSchedulingContainer;
    }

    @Override
    public SolverContainer<OnlineSectioningServer> getOnlineStudentSchedulingContainer() {
        return this.iOnlineStudentSchedulingContainer;
    }

    @Override
    public void unloadSolver(SolverParameterGroup.SolverType type, String id) {
        switch (type) {
            case COURSE: {
                this.getCourseSolverContainer().unloadSolver(id);
                break;
            }
            case EXAM: {
                this.getExamSolverContainer().unloadSolver(id);
                break;
            }
            case INSTRUCTOR: {
                this.getInstructorSchedulingContainer().unloadSolver(id);
                break;
            }
            case STUDENT: {
                this.getStudentSolverContainer().unloadSolver(id);
            }
        }
    }

    public class Updater
    extends Thread {
        private Logger iLog;
        private long iSleepTimeInSeconds = 5L;
        private boolean iRun = true;
        private boolean iPause = false;

        public Updater() {
            this.setDaemon(true);
            this.setName("Updater[generic]");
            this.iSleepTimeInSeconds = ApplicationProperty.OnlineSchedulingQueueLoadInterval.intValue().intValue();
            this.iLog = Logger.getLogger((String)(OnlineStudentSchedulingGenericUpdater.class + ".updater[generic]"));
        }

        @Override
        public void run() {
            try {
                this.iLog.info((Object)"Generic updater started.");
                while (this.iRun) {
                    try {
                        Updater.sleep(this.iSleepTimeInSeconds * 1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (!this.iRun || this.iPause) continue;
                    this.checkForNewServers();
                }
                this.iLog.info((Object)"Generic updater stopped.");
            }
            catch (Exception e) {
                this.iLog.error((Object)("Generic updater failed, " + e.getMessage()), (Throwable)e);
            }
        }

        public synchronized void pauseUpading() {
            this.iPause = true;
            this.iLog.info((Object)"Generic updater paused.");
        }

        public synchronized void resumeUpading() {
            this.interrupt();
            this.iPause = false;
            this.iLog.info((Object)"Generic updater resumed.");
        }

        public void stopUpdating() {
            this.iRun = false;
            this.interrupt();
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void checkForNewServers() {
            if (!SessionDAO.isConfigured()) {
                this.iLog.info((Object)"Hibernate is not yet configured, waiting...");
                return;
            }
            try (org.hibernate.Session hibSession = SessionDAO.getInstance().getSession();){
                HashSet<String> solvers = new HashSet<String>(LocalSolverServer.this.iOnlineStudentSchedulingContainer.getSolvers());
                for (Session session : SessionDAO.getInstance().findAll(hibSession)) {
                    int nrSolutions;
                    if (solvers.contains(session.getUniqueId().toString()) || session.getStatusType().isTestSession() || !session.getStatusType().canSectionAssistStudents() && !session.getStatusType().canOnlineSectionStudents() || (nrSolutions = ((Number)hibSession.createQuery("select count(s) from Solution s where s.owner.session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).uniqueResult()).intValue()) == 0) continue;
                    Properties properties = ApplicationProperties.getConfigProperties();
                    if (properties.getProperty(ApplicationProperty.OnlineSchedulingServerClass.key()) == null) {
                        properties.setProperty(ApplicationProperty.OnlineSchedulingServerClass.key(), InMemoryServer.class.getName());
                    }
                    try {
                        LocalSolverServer.this.iOnlineStudentSchedulingContainer.createSolver(session.getUniqueId().toString(), null);
                    }
                    catch (Exception e) {
                        this.iLog.fatal((Object)("Unable to upadte session " + session.getAcademicTerm() + " " + session.getAcademicYear() + " (" + session.getAcademicInitiative() + "), reason: " + e.getMessage()), (Throwable)e);
                    }
                }
            }
        }
    }
}

