/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.instructor;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.util.ProblemLoader;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.instructor.constraints.SameInstructorConstraint;
import org.cpsolver.instructor.model.Attribute;
import org.cpsolver.instructor.model.Course;
import org.cpsolver.instructor.model.EnrolledClass;
import org.cpsolver.instructor.model.Instructor;
import org.cpsolver.instructor.model.InstructorSchedulingModel;
import org.cpsolver.instructor.model.Preference;
import org.cpsolver.instructor.model.Section;
import org.cpsolver.instructor.model.TeachingAssignment;
import org.cpsolver.instructor.model.TeachingRequest;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.InstructorAttribute;
import org.unitime.timetable.model.InstructorAttributePref;
import org.unitime.timetable.model.InstructorCoursePref;
import org.unitime.timetable.model.InstructorPref;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.TeachingClassRequest;
import org.unitime.timetable.model.TeachingRequest;
import org.unitime.timetable.model.TimePatternModel;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.base.BaseInstructorAttributePref;
import org.unitime.timetable.model.base.BaseInstructorPref;
import org.unitime.timetable.model.base.BaseStudentClassEnrollment;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.model.dao.TimetableManagerDAO;
import org.unitime.timetable.util.NameFormat;

public class InstructorSchedulingDatabaseLoader
extends ProblemLoader<TeachingRequest.Variable, TeachingAssignment, InstructorSchedulingModel> {
    private Progress iProgress = null;
    private Set<Long> iSolverGroupId = new HashSet<Long>();
    private Long iSessionId = null;
    private String iInstructorFormat;
    private Map<Long, Attribute.Type> iAttributeTypes = new HashMap<Long, Attribute.Type>();
    private Map<Long, Attribute> iAttributes = new HashMap<Long, Attribute>();
    private Map<Long, Attribute> iDepartmentAttribute = new HashMap<Long, Attribute>();
    private Map<Long, Instructor> iInstructors = new HashMap<Long, Instructor>();
    private String iDefaultSameCourse = null;
    private String iDefaultSameCommon = null;
    private boolean iShowClassSuffix = false;
    private boolean iShowConfigName = false;

    public InstructorSchedulingDatabaseLoader(InstructorSchedulingModel model, org.cpsolver.ifs.assignment.Assignment<TeachingRequest.Variable, TeachingAssignment> assignment) {
        super((Model)model, assignment);
        this.iProgress = Progress.getInstance((Object)model);
        this.iSessionId = model.getProperties().getPropertyLong("General.SessionId", (Long)null);
        for (Long id : model.getProperties().getPropertyLongArry("General.SolverGroupId", null)) {
            this.iSolverGroupId.add(id);
        }
        this.iInstructorFormat = ((InstructorSchedulingModel)this.getModel()).getProperties().getProperty("General.InstructorFormat", NameFormat.LAST_FIRST.reference());
        this.iDefaultSameCourse = ((InstructorSchedulingModel)this.getModel()).getProperties().getProperty("Defaults.SameCourse", "R");
        this.iDefaultSameCommon = ((InstructorSchedulingModel)this.getModel()).getProperties().getProperty("Defaults.SameCommon", "R");
        this.iShowClassSuffix = ApplicationProperty.SolverShowClassSufix.isTrue();
        this.iShowConfigName = ApplicationProperty.SolverShowConfiguratioName.isTrue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws Exception {
        ApplicationProperties.setSessionId(this.iSessionId);
        Session hibSession = null;
        Transaction tx = null;
        try {
            hibSession = TimetableManagerDAO.getInstance().createNewSession();
            hibSession.setCacheMode(CacheMode.IGNORE);
            hibSession.setFlushMode(FlushMode.COMMIT);
            tx = hibSession.beginTransaction();
            this.load(hibSession);
            tx.commit();
        }
        catch (Exception e) {
            this.iProgress.fatal("Unable to load input data, reason: " + e.getMessage(), (Throwable)e);
            tx.rollback();
        }
        finally {
            if (hibSession != null && hibSession.isOpen()) {
                hibSession.close();
            }
        }
    }

    protected void load(Session hibSession) throws Exception {
        this.iProgress.setStatus("Loading input data ...");
        List departments = hibSession.createQuery("from Department d where d.solverGroup.uniqueId in :solverGroupId").setParameterList("solverGroupId", this.iSolverGroupId).list();
        if (departments.size() > 1) {
            Attribute.Type dt = new Attribute.Type(-1L, "Department", false, false);
            ((InstructorSchedulingModel)this.getModel()).addAttributeType(dt);
            for (Department d : departments) {
                this.iDepartmentAttribute.put(d.getUniqueId(), new Attribute(-d.getUniqueId().longValue(), d.getDeptCode(), dt));
            }
        }
        this.loadInstructors(hibSession);
        this.loadRequests(hibSession);
        this.createAssignment();
        ((InstructorSchedulingModel)this.getModel()).getProperties().setProperty("Save.Commit", InstructorSchedulingDatabaseLoader.isCommitted(hibSession, this.iSolverGroupId) ? "true" : "false");
    }

    public static boolean isCommitted(Session hibSession, Set<Long> solverGroupIds) {
        Number oc = (Number)DepartmentDAO.getInstance().getSession().createQuery("select count(oc) from OfferingCoordinator oc where oc.teachingRequest is not null and oc.instructor.department.solverGroup.uniqueId in :solverGroupId").setParameterList("solverGroupId", solverGroupIds).setCacheable(true).uniqueResult();
        if (oc.intValue() > 0) {
            return true;
        }
        Number ci = (Number)DepartmentDAO.getInstance().getSession().createQuery("select count(ci) from ClassInstructor ci where ci.teachingRequest is not null and ci.instructor.department.solverGroup.uniqueId in :solverGroupId").setParameterList("solverGroupId", solverGroupIds).setCacheable(true).uniqueResult();
        return ci.intValue() > 0;
    }

    protected Attribute getAttribute(InstructorAttribute a) {
        Attribute attribute = this.iAttributes.get(a.getUniqueId());
        if (attribute == null) {
            Attribute.Type type = this.iAttributeTypes.get(a.getType().getUniqueId());
            if (type == null) {
                type = new Attribute.Type(a.getType().getUniqueId().longValue(), a.getType().getReference(), a.getType().isConjunctive().booleanValue(), a.getType().isRequired().booleanValue());
                this.iAttributeTypes.put(a.getType().getUniqueId(), type);
                ((InstructorSchedulingModel)this.getModel()).addAttributeType(type);
            }
            attribute = new Attribute(a.getUniqueId().longValue(), a.getCode(), type);
            this.iAttributes.put(a.getUniqueId(), attribute);
            if (a.getParentAttribute() != null) {
                attribute.setParentAttribute(this.getAttribute(a.getParentAttribute()));
            }
        }
        return attribute;
    }

    protected void loadDistributionPreferences(Instructor instructor, DistributionPref dp) {
        if ("BTB_TIME".equals(dp.getDistributionType().getReference()) || "BTB".equals(dp.getDistributionType().getReference())) {
            instructor.setBackToBackPreference(Constants.preference2preferenceLevel((String)dp.getPrefLevel().getPrefProlog()));
        } else if ("SAME_DAYS".equals(dp.getDistributionType().getReference())) {
            instructor.setSameDaysPreference(Constants.preference2preferenceLevel((String)dp.getPrefLevel().getPrefProlog()));
        } else if ("SAME_ROOM".equals(dp.getDistributionType().getReference())) {
            instructor.setSameRoomPreference(Constants.preference2preferenceLevel((String)dp.getPrefLevel().getPrefProlog()));
        }
    }

    protected void loadTimePreferences(Instructor instructor, TimePref tp) {
        int j;
        int i;
        TimePatternModel m = tp.getTimePatternModel();
        boolean[][] out = new boolean[m.getNrDays()][m.getNrTimes()];
        for (i = 0; i < m.getNrDays(); ++i) {
            for (j = 0; j < m.getNrTimes(); ++j) {
                out[i][j] = false;
            }
        }
        for (i = 0; i < m.getNrDays(); ++i) {
            for (j = 0; j < m.getNrTimes(); ++j) {
                boolean same;
                if (out[i][j]) continue;
                out[i][j] = true;
                if (PreferenceLevel.sNeutral.equals(m.getPreference(i, j))) continue;
                int endDay = i;
                int endTime = j;
                while (endTime + 1 < m.getNrTimes() && !out[i][endTime + 1] && m.getPreference(i, endTime + 1).equals(m.getPreference(i, j))) {
                    ++endTime;
                }
                if (i == 0) {
                    same = true;
                    int k = i;
                    while (k + 1 < m.getNrDays()) {
                        for (int x = j; x <= endTime; ++x) {
                            if (!out[k + 1][x] && !m.getPreference(i, x).equals(m.getPreference(k + 1, x))) {
                                same = false;
                                break;
                            }
                            if (!same) break;
                        }
                        if (!same) break;
                        ++k;
                    }
                    if (same) {
                        endDay = m.getNrDays() - 1;
                    }
                }
                while (endDay + 1 < m.getNrDays()) {
                    same = true;
                    for (int x = j; x <= endTime; ++x) {
                        if (out[endDay + 1][x] || m.getPreference(i, x).equals(m.getPreference(endDay + 1, x))) continue;
                        same = false;
                        break;
                    }
                    if (!same) break;
                    ++endDay;
                }
                for (int a = i; a <= endDay; ++a) {
                    for (int b = j; b <= endTime; ++b) {
                        out[a][b] = true;
                    }
                }
                int dayCode = 0;
                for (int a = i; a <= endDay; ++a) {
                    dayCode |= m.getDayCode(a);
                }
                TimeLocation time = new TimeLocation(dayCode, m.getStartSlot(j), m.getStartSlot(endTime) - m.getStartSlot(j) + m.getSlotsPerMtg(), 0, 0.0, null, "", null, m.getBreakTime());
                instructor.addTimePreference(new Preference((Object)time, Constants.preference2preferenceLevel((String)m.getPreference(i, j))));
            }
        }
    }

    public static String getClassExternalId(CourseOffering course, Class_ clazz) {
        String section = clazz.getClassSuffix(course == null ? clazz.getSchedulingSubpart().getControllingCourseOffering() : course);
        if (section != null && !section.isEmpty()) {
            return section;
        }
        String extId = clazz.getExternalId(course == null ? clazz.getSchedulingSubpart().getControllingCourseOffering() : course);
        if (extId != null && !extId.isEmpty()) {
            return extId;
        }
        return clazz.getSectionNumberString();
    }

    public static List<EnrolledClass> loadUnavailability(Session hibSession, DepartmentalInstructor di) {
        ArrayList<EnrolledClass> ret = new ArrayList<EnrolledClass>();
        if (di.getExternalUniqueId() != null) {
            List enrollments = hibSession.createQuery("from StudentClassEnrollment e where e.student.session.uniqueId = :sessionId and e.student.externalUniqueId = :externalId and e.clazz.cancelled = false").setLong("sessionId", di.getDepartment().getSessionId().longValue()).setString("externalId", di.getExternalUniqueId()).setCacheable(true).list();
            for (Object enrollment : enrollments) {
                Assignment assignment = ((BaseStudentClassEnrollment)enrollment).getClazz().getCommittedAssignment();
                if (assignment == null) continue;
                String rooms = null;
                for (Location location : assignment.getRooms()) {
                    if (rooms == null) {
                        rooms = location.getLabel();
                        continue;
                    }
                    rooms = rooms + ", " + location.getLabel();
                }
                DatePattern datePattern = assignment.getDatePattern();
                ret.add(new EnrolledClass(((BaseStudentClassEnrollment)enrollment).getCourseOffering().getUniqueId(), ((BaseStudentClassEnrollment)enrollment).getClazz().getUniqueId(), ((BaseStudentClassEnrollment)enrollment).getCourseOffering().getCourseName(), ((BaseStudentClassEnrollment)enrollment).getClazz().getSchedulingSubpart().getItypeDesc().trim(), ((BaseStudentClassEnrollment)enrollment).getClazz().getClassLabel(((BaseStudentClassEnrollment)enrollment).getCourseOffering()), InstructorSchedulingDatabaseLoader.getClassExternalId(((BaseStudentClassEnrollment)enrollment).getCourseOffering(), ((BaseStudentClassEnrollment)enrollment).getClazz()), assignment.getDays().intValue(), assignment.getStartSlot().intValue(), assignment.getSlotPerMtg(), ((BaseStudentClassEnrollment)enrollment).getClazz().getUniqueId(), datePattern == null ? "" : datePattern.getName(), datePattern == null ? new BitSet() : datePattern.getPatternBitSet(), assignment.getBreakTime(), rooms, false));
            }
            List classInstructors = hibSession.createQuery("from ClassInstructor ci where ci.instructor.externalUniqueId = :externalId and ci.instructor.department.session.uniqueId = :sessionId and ci.instructor.department.uniqueId != :departmentId and ci.lead = true and ci.classInstructing.cancelled = false").setLong("sessionId", di.getDepartment().getSessionId().longValue()).setString("externalId", di.getExternalUniqueId()).setLong("departmentId", di.getDepartment().getUniqueId().longValue()).setCacheable(true).list();
            for (ClassInstructor ci : classInstructors) {
                Assignment assignment = ci.getClassInstructing().getCommittedAssignment();
                if (assignment == null) continue;
                String rooms = null;
                for (Location loc : assignment.getRooms()) {
                    if (rooms == null) {
                        rooms = loc.getLabel();
                        continue;
                    }
                    rooms = rooms + ", " + loc.getLabel();
                }
                DatePattern datePattern = assignment.getDatePattern();
                Class_ clazz = ci.getClassInstructing();
                CourseOffering course = clazz.getSchedulingSubpart().getControllingCourseOffering();
                ret.add(new EnrolledClass(course.getUniqueId(), clazz.getUniqueId(), course.getCourseName(), clazz.getSchedulingSubpart().getItypeDesc().trim(), clazz.getClassLabel(course), InstructorSchedulingDatabaseLoader.getClassExternalId(course, clazz), assignment.getDays().intValue(), assignment.getStartSlot().intValue(), assignment.getSlotPerMtg(), ci.getClassInstructing().getUniqueId(), datePattern == null ? "" : datePattern.getName(), datePattern == null ? new BitSet() : datePattern.getPatternBitSet(), assignment.getBreakTime(), rooms, true));
            }
        }
        for (ClassInstructor ci : di.getClasses()) {
            Assignment assignment;
            if (!ci.isLead().booleanValue() || ci.getClassInstructing().isCancelled().booleanValue() || ci.getTeachingRequest() != null || (assignment = ci.getClassInstructing().getCommittedAssignment()) == null) continue;
            String rooms = null;
            for (Location loc : assignment.getRooms()) {
                if (rooms == null) {
                    rooms = loc.getLabel();
                    continue;
                }
                rooms = rooms + ", " + loc.getLabel();
            }
            DatePattern datePattern = assignment.getDatePattern();
            Class_ clazz = ci.getClassInstructing();
            CourseOffering courseOffering = clazz.getSchedulingSubpart().getControllingCourseOffering();
            ret.add(new EnrolledClass(courseOffering.getUniqueId(), clazz.getUniqueId(), courseOffering.getCourseName(), clazz.getSchedulingSubpart().getItypeDesc().trim(), clazz.getClassLabel(courseOffering), InstructorSchedulingDatabaseLoader.getClassExternalId(courseOffering, clazz), assignment.getDays().intValue(), assignment.getStartSlot().intValue(), assignment.getSlotPerMtg(), ci.getClassInstructing().getUniqueId(), datePattern == null ? "" : datePattern.getName(), datePattern == null ? new BitSet() : datePattern.getPatternBitSet(), assignment.getBreakTime(), rooms, true));
        }
        return ret;
    }

    protected void loadInstructors(Session hibSession) throws Exception {
        List list = hibSession.createQuery("select distinct i from DepartmentalInstructor i, SolverGroup g inner join g.departments d where g.uniqueId in :solverGroupId and i.department = d and i.teachingPreference.prefProlog != :prohibited and i.maxLoad > 0.0").setParameterList("solverGroupId", this.iSolverGroupId).setString("prohibited", PreferenceLevel.sProhibited).list();
        this.iProgress.setPhase("Loading instructors...", (long)list.size());
        for (DepartmentalInstructor i : list) {
            Instructor instructor = new Instructor(i.getUniqueId().longValue(), i.getExternalUniqueId(), i.getName(this.iInstructorFormat), Constants.preference2preferenceLevel((String)i.getTeachingPreference().getPrefProlog()), i.getMaxLoad().floatValue());
            for (InstructorAttribute a : i.getAttributes()) {
                instructor.addAttribute(this.getAttribute(a));
            }
            if (!this.iDepartmentAttribute.isEmpty()) {
                instructor.addAttribute(this.iDepartmentAttribute.get(i.getDepartment().getUniqueId()));
            }
            for (org.unitime.timetable.model.Preference p : i.getPreferences()) {
                if (p instanceof InstructorCoursePref) {
                    InstructorCoursePref cp = (InstructorCoursePref)p;
                    instructor.addCoursePreference(new Preference((Object)new Course(cp.getCourse().getUniqueId().longValue(), cp.getCourse().getCourseName()), Constants.preference2preferenceLevel((String)cp.getPrefLevel().getPrefProlog())));
                    continue;
                }
                if (p instanceof DistributionPref) {
                    this.loadDistributionPreferences(instructor, (DistributionPref)p);
                    continue;
                }
                if (!(p instanceof TimePref)) continue;
                this.loadTimePreferences(instructor, (TimePref)p);
            }
            for (EnrolledClass ec : InstructorSchedulingDatabaseLoader.loadUnavailability(hibSession, i)) {
                instructor.addTimePreference(new Preference((Object)ec, Constants.sPreferenceLevelProhibited));
            }
            ((InstructorSchedulingModel)this.getModel()).addInstructor(instructor);
            this.iInstructors.put(i.getUniqueId(), instructor);
            this.iProgress.incProgress();
        }
    }

    protected Section getSection(TeachingClassRequest req) {
        Class_ clazz = req.getTeachingClass();
        CourseOffering course = clazz.getSchedulingSubpart().getControllingCourseOffering();
        String room = null;
        TimeLocation time = null;
        Assignment assignment = clazz.getCommittedAssignment();
        if (assignment != null) {
            time = assignment.getTimeLocation();
            for (Location location : assignment.getRooms()) {
                if (room == null) {
                    room = location.getLabel();
                    continue;
                }
                room = room + ", " + location.getLabel();
            }
        }
        return new Section(clazz.getUniqueId().longValue(), InstructorSchedulingDatabaseLoader.getClassExternalId(course, clazz), clazz.getSchedulingSubpart().getItypeDesc().trim(), clazz.getClassLabel(course), time, room, req.isCanOverlap().booleanValue(), req.isCommon().booleanValue());
    }

    protected String toHtml(Class_ clazz) {
        return "<A href='classDetail.do?cid=" + clazz.getUniqueId() + "'>" + clazz.getClassLabel(this.iShowClassSuffix, this.iShowConfigName) + "</A>";
    }

    protected String toHtml(DepartmentalInstructor instructor) {
        return "<a href='instructorDetail.do?instructorId=" + instructor.getUniqueId() + "&deptId=" + instructor.getDepartment().getUniqueId() + "'>" + instructor.getName(this.iInstructorFormat) + "</a>";
    }

    protected String toHtml(TeachingAssignment assignment) {
        return "<a href='instructorDetail.do?instructorId=" + assignment.getInstructor().getInstructorId() + "'>" + assignment.getInstructor().getName() + "</a>";
    }

    protected String toHtml(TeachingRequest request) {
        String sections = "";
        for (TeachingClassRequest tcr : new TreeSet<TeachingClassRequest>(request.getClassRequests())) {
            sections = sections + (sections.isEmpty() ? "" : ", ") + (tcr.isAssignInstructor() != false ? "" : "<i>") + this.toHtml(tcr.getTeachingClass()) + (tcr.isAssignInstructor() != false ? "" : "</i>");
        }
        return "<a href='instructionalOfferingDetail.do?io=" + request.getOffering().getUniqueId() + "&requestId=" + request.getUniqueId() + "&op=view#instructors'>" + request.getOffering().getCourseName() + "</a> " + sections;
    }

    protected String toHtml(org.cpsolver.instructor.model.TeachingRequest request) {
        return "<a href='instructionalOfferingDetail.do?co=" + request.getCourse().getCourseId() + "&requestId=" + request.getRequestId() + "&op=view#instructors'>" + request.getCourse().getCourseName() + (request.getSections().isEmpty() ? "" : " " + request.getSections()) + "</a>";
    }

    protected String toHtml(TeachingRequest.Variable variable) {
        return "<a href='instructionalOfferingDetail.do?co=" + variable.getCourse().getCourseId() + "&requestId=" + variable.getRequest().getRequestId() + "&op=view#instructors'>" + variable.getRequest().getCourse().getCourseName() + (variable.getRequest().getNrInstructors() != 1 ? "/" + (1 + variable.getInstructorIndex()) : "") + (variable.getRequest().getSections().isEmpty() ? "" : " " + variable.getRequest().getSections()) + "</a>";
    }

    protected void loadRequest(Session hibSession, TeachingRequest r) {
        Course course = new Course(r.getOffering().getControllingCourseOffering().getUniqueId().longValue(), r.getOffering().getCourseName());
        ArrayList<Section> sections = new ArrayList<Section>();
        for (TeachingClassRequest cr : new TreeSet<TeachingClassRequest>(r.getClassRequests())) {
            sections.add(this.getSection(cr));
        }
        org.cpsolver.instructor.model.TeachingRequest request = new org.cpsolver.instructor.model.TeachingRequest(r.getUniqueId().longValue(), r.getNbrInstructors().intValue(), course, r.getTeachingLoad().floatValue(), sections, Constants.preference2preferenceLevel((String)(r.getSameCoursePreference() == null ? this.iDefaultSameCourse : r.getSameCoursePreference().getPrefProlog())), Constants.preference2preferenceLevel((String)(r.getSameCommonPart() == null ? this.iDefaultSameCommon : r.getSameCommonPart().getPrefProlog())));
        for (org.unitime.timetable.model.Preference p : r.getPreferences(InstructorPref.class)) {
            Instructor instructor = this.iInstructors.get(((BaseInstructorPref)p).getInstructor().getUniqueId());
            if (instructor == null) continue;
            request.addInstructorPreference(new Preference((Object)instructor, Constants.preference2preferenceLevel((String)p.getPrefLevel().getPrefProlog())));
        }
        for (org.unitime.timetable.model.Preference p : r.getPreferences(InstructorAttributePref.class)) {
            request.addAttributePreference(new Preference((Object)this.getAttribute(((BaseInstructorAttributePref)p).getAttribute()), Constants.preference2preferenceLevel((String)p.getPrefLevel().getPrefProlog())));
        }
        if (!this.iDepartmentAttribute.isEmpty()) {
            request.addAttributePreference(new Preference((Object)this.iDepartmentAttribute.get(r.getOffering().getControllingCourseOffering().getSubjectArea().getDepartment().getUniqueId()), Constants.sPreferenceLevelRequired));
        }
        ((InstructorSchedulingModel)this.getModel()).addRequest(request);
        int index = 0;
        ArrayList<DepartmentalInstructor> instructors = new ArrayList<DepartmentalInstructor>(r.getAssignedInstructors());
        Collections.sort(instructors);
        for (DepartmentalInstructor di : instructors) {
            Instructor instructor = this.iInstructors.get(di.getUniqueId());
            if (instructor == null || index >= r.getNbrInstructors()) {
                this.iProgress.warn("Instructor " + this.toHtml(di) + " is assigned to " + this.toHtml(r) + ", but not allowed for automatic assignment.");
                continue;
            }
            request.getVariable(index).setInitialAssignment((Value)new TeachingAssignment(request.getVariable(index), instructor));
            ++index;
        }
        if (request.getNrInstructors() > 1) {
            SameInstructorConstraint diffInstructor = new SameInstructorConstraint(r.getUniqueId(), r.getOffering().getCourseName(), "P");
            for (TeachingRequest.Variable var : request.getVariables()) {
                diffInstructor.addVariable((Variable)var);
            }
            ((InstructorSchedulingModel)this.getModel()).addConstraint((Constraint)diffInstructor);
        }
    }

    protected void loadRequests(Session hibSession) throws Exception {
        List requests = hibSession.createQuery("select r from TeachingRequest r inner join r.offering.courseOfferings co where co.isControl = true and co.subjectArea.department.solverGroup.uniqueId in :solverGroupId").setParameterList("solverGroupId", this.iSolverGroupId).list();
        this.iProgress.setPhase("Loading requests...", (long)requests.size());
        for (TeachingRequest request : requests) {
            this.iProgress.incProgress();
            if (request.isCancelled()) continue;
            this.loadRequest(hibSession, request);
        }
    }

    protected void createAssignment() {
        this.iProgress.setPhase("Creating initial assignment...", (long)((InstructorSchedulingModel)this.getModel()).variables().size());
        block0: for (TeachingRequest.Variable request : ((InstructorSchedulingModel)this.getModel()).variables()) {
            this.iProgress.incProgress();
            TeachingAssignment assignment = (TeachingAssignment)request.getInitialAssignment();
            if (assignment == null) continue;
            if (assignment.getInstructor().getTimePreference(request.getRequest()).isProhibited()) {
                this.iProgress.warn("Unable to assign " + this.toHtml(request) + " &larr; " + this.toHtml(assignment) + ": instructor is not available.");
                continue;
            }
            if (assignment.getInstructor().getCoursePreference(request.getCourse()).isProhibited()) {
                this.iProgress.warn("Unable to assign " + this.toHtml(request) + " &larr; " + this.toHtml(assignment) + ": course " + request.getCourse().getCourseName() + " is prohibited.");
                continue;
            }
            if (request.getRequest().getInstructorPreference(assignment.getInstructor()).isProhibited()) {
                this.iProgress.warn("Unable to assign " + this.toHtml(request) + " &larr; " + this.toHtml(assignment) + ": instructor " + assignment.getInstructor().getName() + " is prohibited.");
                continue;
            }
            for (Attribute.Type type : ((InstructorSchedulingModel)this.getModel()).getAttributeTypes()) {
                int pref = request.getRequest().getAttributePreference(assignment.getInstructor(), type);
                if (!"P".equals(Constants.preferenceLevel2preference((int)pref))) continue;
                this.iProgress.warn("Unable to assign " + this.toHtml(request) + " &larr; " + this.toHtml(assignment) + ": probibited by attribute type " + type.getTypeName() + ".");
                continue block0;
            }
            if (!assignment.getInstructor().canTeach(request.getRequest()) || request.getRequest().getAttributePreference(assignment.getInstructor()).isProhibited()) {
                this.iProgress.warn("Unable to assign " + this.toHtml(request) + " &larr; " + this.toHtml(assignment) + ": assignment not valid.");
                continue;
            }
            ((InstructorSchedulingModel)this.getModel()).weaken(this.getAssignment(), (Value)assignment);
            Map conflictConstraints = ((InstructorSchedulingModel)this.getModel()).conflictConstraints(this.getAssignment(), (Value)assignment);
            if (conflictConstraints.isEmpty()) {
                this.getAssignment().assign(0L, (Value)assignment);
                continue;
            }
            String warn = "Unable to assign " + this.toHtml(request) + " &larr; " + this.toHtml(assignment);
            warn = warn + "<br>&nbsp;&nbsp;Reason:";
            for (Constraint c : conflictConstraints.keySet()) {
                Set vals = (Set)conflictConstraints.get(c);
                for (TeachingAssignment v : vals) {
                    warn = warn + "<br>&nbsp;&nbsp;&nbsp;&nbsp;" + this.toHtml((TeachingRequest.Variable)v.variable()) + " = " + this.toHtml(v);
                }
                warn = warn + "<br>&nbsp;&nbsp;&nbsp;&nbsp;    in constraint " + c;
                this.iProgress.warn(warn);
            }
        }
    }
}

