/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.reservation;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.ReservationInterface;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.util.Formats;

@GwtRpcImplements(value=ReservationInterface.ReservationDefaultExpirationDatesRpcRequest.class)
public class ReservationDefaultExpirationDatesBackend
implements GwtRpcImplementation<ReservationInterface.ReservationDefaultExpirationDatesRpcRequest, ReservationInterface.DefaultExpirationDates> {
    private static String[] sTypes = new String[]{"individual", "group", "curriculum", "course"};
    private static Formats.Format<Date> sDF = Formats.getDateFormat("yyyy-MM-dd");

    @Override
    public ReservationInterface.DefaultExpirationDates execute(ReservationInterface.ReservationDefaultExpirationDatesRpcRequest request, SessionContext context) {
        ReservationInterface.DefaultExpirationDates expirations;
        block3: {
            block2: {
                expirations = new ReservationInterface.DefaultExpirationDates();
                if (request.getSessionId() == null) break block2;
                Session session = (Session)SessionDAO.getInstance().get(request.getSessionId());
                for (String type : sTypes) {
                    expirations.setExpirationDate(type, this.getDefaultExpirationDate(session, type));
                    expirations.setStartDate(type, this.getDefaultStartDate(session, type));
                }
                break block3;
            }
            if (context.getUser() == null || context.getUser().getCurrentAcademicSessionId() == null) break block3;
            Session session = (Session)SessionDAO.getInstance().get(context.getUser().getCurrentAcademicSessionId());
            for (String type : sTypes) {
                expirations.setExpirationDate(type, this.getDefaultExpirationDate(session, type));
                expirations.setStartDate(type, this.getDefaultStartDate(session, type));
            }
        }
        return expirations;
    }

    public Date getDefaultExpirationDate(Session session, String type) {
        String expInDaysStr;
        String expirationStr = ApplicationProperty.ReservationExpirationDate.value(type, ApplicationProperty.ReservationExpirationDateGlobal.value());
        Date expiration = null;
        if (expirationStr != null && !expirationStr.isEmpty()) {
            try {
                Calendar cal = Calendar.getInstance(Localization.getJavaLocale());
                cal.setTime(session.getSessionBeginDateTime());
                cal.add(6, Integer.parseInt(expirationStr));
                expiration = cal.getTime();
            }
            catch (NumberFormatException e) {
                try {
                    expiration = sDF.parse(expirationStr);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        if ((expInDaysStr = ApplicationProperty.ReservationExpirationInDays.value(type, ApplicationProperty.ReservationExpirationInDaysGlobal.value())) != null && !expInDaysStr.isEmpty()) {
            try {
                Calendar cal = Calendar.getInstance(Localization.getJavaLocale());
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                cal.add(6, Integer.parseInt(expInDaysStr));
                if (expiration == null || cal.getTime().after(expiration)) {
                    expiration = cal.getTime();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return expiration;
    }

    public Date getDefaultStartDate(Session session, String type) {
        String expInDaysStr;
        String startDateStr = ApplicationProperty.ReservationStartDate.value(type, ApplicationProperty.ReservationStartDateGlobal.value());
        Date startDate = null;
        if (startDateStr != null && !startDateStr.isEmpty()) {
            try {
                Calendar cal = Calendar.getInstance(Localization.getJavaLocale());
                cal.setTime(session.getSessionBeginDateTime());
                cal.add(6, Integer.parseInt(startDateStr));
                startDate = cal.getTime();
            }
            catch (NumberFormatException e) {
                try {
                    startDate = sDF.parse(startDateStr);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        if ((expInDaysStr = ApplicationProperty.ReservationStartInDays.value(type, ApplicationProperty.ReservationStartInDaysGlobal.value())) != null && !expInDaysStr.isEmpty()) {
            try {
                Calendar cal = Calendar.getInstance(Localization.getJavaLocale());
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                cal.add(6, Integer.parseInt(expInDaysStr));
                if (startDate == null || cal.getTime().after(startDate)) {
                    startDate = cal.getTime();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return startDate;
    }
}

