/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports.exam;

import com.lowagie.text.DocumentException;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.cpsolver.ifs.util.ToolBox;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.BuildingPref;
import org.unitime.timetable.model.ClassEvent;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DistributionObject;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamOwner;
import org.unitime.timetable.model.ExamPeriodPref;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalMethod;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.ItypeDesc;
import org.unitime.timetable.model.Meeting;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.RoomFeaturePref;
import org.unitime.timetable.model.RoomGroupPref;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.comparators.CourseOfferingComparator;
import org.unitime.timetable.model.comparators.SchedulingSubpartComparator;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.reports.exam.PdfLegacyExamReport;
import org.unitime.timetable.solver.exam.ui.ExamAssignmentInfo;
import org.unitime.timetable.solver.exam.ui.ExamInfo;
import org.unitime.timetable.solver.exam.ui.ExamRoomInfo;

public class ExamVerificationReport
extends PdfLegacyExamReport {
    protected static Logger sLog = Logger.getLogger(ExamVerificationReport.class);
    private boolean iSkipHoles = true;
    private boolean iSkipSuffixSubparts = ApplicationProperty.ExaminationPdfReportsSkipSuffixSubpart.isTrue();
    private boolean iHasAssignment = false;

    public ExamVerificationReport(int mode, File file, Session session, ExamType examType, Collection<SubjectArea> subjectAreas, Collection<ExamAssignmentInfo> exams) throws IOException, DocumentException {
        super(mode, file, "EXAMINATION VERIFICATION REPORT", session, examType, subjectAreas, exams);
        for (ExamAssignmentInfo exam : exams) {
            if (exam.getPeriod() == null) continue;
            this.iHasAssignment = true;
            break;
        }
    }

    public TreeSet<ExamAssignmentInfo> getExams(CourseOffering course) {
        TreeSet<ExamAssignmentInfo> exams = new TreeSet<ExamAssignmentInfo>();
        for (ExamAssignmentInfo exam : this.getExams()) {
            for (ExamInfo.ExamSectionInfo section : exam.getSectionsIncludeCrosslistedDummies()) {
                if (section.getOwnerType() == 1 && section.getOwnerId().equals(course.getUniqueId())) {
                    exams.add(exam);
                }
                if (section.getOwnerType() != 0 || !section.getOwnerId().equals(course.getInstructionalOffering().getUniqueId())) continue;
                exams.add(exam);
            }
        }
        return exams;
    }

    public TreeSet<ExamAssignmentInfo> getExams(Class_ clazz) {
        TreeSet<ExamAssignmentInfo> exams = new TreeSet<ExamAssignmentInfo>();
        for (ExamAssignmentInfo exam : this.getExams()) {
            for (ExamInfo.ExamSectionInfo section : exam.getSectionsIncludeCrosslistedDummies()) {
                if (section.getOwnerType() == 3 && section.getOwnerId().equals(clazz.getUniqueId())) {
                    exams.add(exam);
                }
                if (section.getOwnerType() != 2 || !section.getOwnerId().equals(clazz.getSchedulingSubpart().getInstrOfferingConfig().getUniqueId())) continue;
                exams.add(exam);
            }
        }
        if (this.iSkipSuffixSubparts && clazz.getChildClasses() != null) {
            for (Class_ child : clazz.getChildClasses()) {
                if (!child.getSchedulingSubpart().getItype().equals(clazz.getSchedulingSubpart().getItype())) continue;
                exams.addAll(this.getExams(child));
            }
        }
        return exams;
    }

    public String genName(String pattern, Class_ clazz) {
        String name = pattern;
        int idx = -1;
        while (name.indexOf(37, idx + 1) >= 0) {
            idx = name.indexOf(37, idx);
            char code = name.charAt(idx + 1);
            String name4code = this.genName(code, clazz);
            name = name.substring(0, idx) + (name4code == null ? "" : name4code) + name.substring(idx + 2);
        }
        return name;
    }

    protected String genName(char code, Class_ clazz) {
        switch (code) {
            case '_': {
                return " ";
            }
            case 's': {
                return clazz.getSchedulingSubpart().getControllingCourseOffering().getSubjectArea().getSubjectAreaAbbreviation();
            }
            case 'c': {
                return clazz.getSchedulingSubpart().getControllingCourseOffering().getCourseNbr();
            }
            case 'T': {
                return clazz.getSchedulingSubpart().getControllingCourseOffering().getTitle();
            }
            case 'i': {
                return clazz.getSchedulingSubpart().getItypeDesc().trim();
            }
            case 'n': {
                return clazz.getSectionNumberString();
            }
            case 'x': {
                return clazz.getSchedulingSubpart().getInstrOfferingConfig().getName();
            }
            case 'D': {
                return clazz.getControllingDept().getDeptCode();
            }
            case 'd': {
                Department d = clazz.getControllingDept();
                return d.getAbbreviation() == null || d.getAbbreviation().length() == 0 ? d.getDeptCode() : d.getAbbreviation();
            }
            case 'a': {
                return clazz.getClassSuffix();
            }
            case 'y': {
                return clazz.getSchedulingSubpart().getSchedulingSubpartSuffix();
            }
            case 'e': {
                return clazz.getExternalUniqueId();
            }
            case 'f': {
                return clazz.getSchedulingSubpart().getControllingCourseOffering().getExternalUniqueId();
            }
            case 'o': {
                return clazz.getSchedulingSubpart().getControllingCourseOffering().getInstructionalOffering().getExternalUniqueId();
            }
            case 't': {
                return "";
            }
            case 'I': {
                return clazz.getSchedulingSubpart().getItype().getItype().toString();
            }
            case 'p': {
                ItypeDesc itype = clazz.getSchedulingSubpart().getItype();
                while (itype.getParent() != null) {
                    itype = itype.getParent();
                }
                return itype.getAbbv();
            }
            case 'P': {
                ItypeDesc itype = clazz.getSchedulingSubpart().getItype();
                while (itype.getParent() != null) {
                    itype = itype.getParent();
                }
                return itype.getItype().toString();
            }
            case 'm': {
                InstructionalMethod im = clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalMethod();
                if (im != null) {
                    return im.getReference();
                }
                return "";
            }
            case 'M': {
                InstructionalMethod im = clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalMethod();
                if (im != null) {
                    return im.getLabel();
                }
                return "";
            }
        }
        return "";
    }

    public String getMeetWith(Class_ clazz, Vector<Class_> exclude) {
        TreeSet<Class_> classes = new TreeSet<Class_>(new Comparator<Class_>(){

            @Override
            public int compare(Class_ c1, Class_ c2) {
                if (c1.getSchedulingSubpart().equals(c2.getSchedulingSubpart())) {
                    String sx2;
                    String sx1 = ExamVerificationReport.this.iUseClassSuffix ? c1.getClassSuffix() : c1.getSectionNumberString();
                    String string = sx2 = ExamVerificationReport.this.iUseClassSuffix ? c2.getClassSuffix() : c2.getSectionNumberString();
                    if (sx1 != null && sx2 != null) {
                        return sx1.compareTo(sx2);
                    }
                    return c1.getSectionNumber().compareTo(c2.getSectionNumber());
                }
                return new SchedulingSubpartComparator().compare(c1.getSchedulingSubpart(), c2.getSchedulingSubpart());
            }
        });
        for (DistributionObject dObj : clazz.getDistributionObjects()) {
            if (!"MEET_WITH".equals(dObj.getDistributionPref().getDistributionType().getReference())) continue;
            for (DistributionObject xObj : dObj.getDistributionPref().getDistributionObjects()) {
                if (exclude != null && exclude.contains(xObj.getPrefGroup())) continue;
                if (xObj.getPrefGroup() instanceof Class_) {
                    classes.add((Class_)xObj.getPrefGroup());
                    continue;
                }
                classes.addAll(((SchedulingSubpart)xObj.getPrefGroup()).getClasses());
            }
        }
        if (classes.isEmpty()) {
            return "";
        }
        Class_ prev = clazz;
        String ret = "";
        for (Class_ c : classes) {
            if (ret.length() == 0) {
                ret = ret + this.genName(ApplicationProperty.ExamNameClass.value(), c);
            } else if (prev.getSchedulingSubpart().getControllingCourseOffering().getSubjectArea().equals(c.getSchedulingSubpart().getControllingCourseOffering().getSubjectArea())) {
                ret = prev.getSchedulingSubpart().getControllingCourseOffering().equals(c.getSchedulingSubpart().getControllingCourseOffering()) ? (prev.getSchedulingSubpart().equals(c.getSchedulingSubpart()) ? ret + this.genName(ApplicationProperty.ExamNameSameSubpartClass.value(), c) : ret + this.genName(ApplicationProperty.ExamNameSameCourseClass.value(), c)) : ret + this.genName(ApplicationProperty.ExamNameSameSubjectClass.value(), c);
            } else {
                ret = ret + this.genName(ApplicationProperty.ExamNameSeparator.value(), prev);
                ret = ret + this.genName(ApplicationProperty.ExamNameClass.value(), c);
            }
            prev = c;
        }
        return ret;
    }

    private String formatSection(Class_ clazz) {
        return !this.iUseClassSuffix || clazz.getClassSuffix() == null || clazz.getClassSuffix().length() == 0 ? clazz.getSectionNumberString() : clazz.getClassSuffix();
    }

    private String formatSection(Vector<Class_> classes) {
        if (classes.isEmpty()) {
            return "";
        }
        if (classes.size() == 1) {
            return this.formatSection(classes.firstElement());
        }
        return this.formatSection(classes.firstElement()) + " - " + this.formatSection(classes.lastElement());
    }

    public String getMessage(Class_ clazz, boolean hasCourseExam, boolean hasSectionExam, Hashtable<Long, ClassEvent> class2event) {
        TreeSet<ExamAssignmentInfo> exams = this.getExams(clazz);
        if (!exams.isEmpty()) {
            return "";
        }
        String message = "** NO EXAM **";
        if (hasCourseExam && !hasSectionExam) {
            message = "";
        }
        if (!hasSectionExam && !clazz.getSchedulingSubpart().getItype().isOrganized().booleanValue()) {
            message = "Not organized instructional type";
        } else {
            ClassEvent event = class2event.get(clazz.getUniqueId());
            if (event == null || event.getMeetings().isEmpty()) {
                message = "Class not organized";
            } else if (!this.isFullTerm(event)) {
                TreeSet<Meeting> meetings = new TreeSet<Meeting>(event.getMeetings());
                Meeting first = meetings.first();
                Meeting last = meetings.last();
                SimpleDateFormat df = new SimpleDateFormat("MM/dd");
                message = "Class not full-term (" + df.format(first.getMeetingDate()) + (first.getMeetingDate().equals(last.getMeetingDate()) ? "" : " - " + df.format(last.getMeetingDate())) + ")";
            }
        }
        return message;
    }

    private void print(Vector<Class_> same, boolean hasCourseExam, boolean hasSectionExam, int minLimit, int maxLimit, int minEnrl, int maxEnrl, Hashtable<Long, ClassEvent> class2event) throws DocumentException {
        String cmw = this.getMeetWith(same.firstElement(), same);
        TreeSet<ExamAssignmentInfo> exams = this.getExams(same.firstElement());
        this.iPeriodPrinted = false;
        if (exams.isEmpty()) {
            boolean mwSeparateLine;
            boolean hasMw;
            boolean hasTitle;
            String message = "** NO EXAM **";
            if (hasCourseExam && !hasSectionExam) {
                message = "";
            }
            if (!hasSectionExam && !same.firstElement().getSchedulingSubpart().getItype().isOrganized().booleanValue()) {
                message = "Not organized instructional type";
            } else {
                ClassEvent classEvent = class2event.get(same.firstElement().getUniqueId());
                if (classEvent == null || classEvent.getMeetings().isEmpty()) {
                    message = "Class not organized";
                } else if (!this.isFullTerm(classEvent)) {
                    TreeSet<Meeting> meetings = new TreeSet<Meeting>(classEvent.getMeetings());
                    Meeting first = meetings.first();
                    Meeting last = meetings.last();
                    SimpleDateFormat df = new SimpleDateFormat("MM/dd");
                    message = "Class not full-term (" + df.format(first.getMeetingDate()) + (first.getMeetingDate().equals(last.getMeetingDate()) ? "" : " - " + df.format(last.getMeetingDate())) + ")";
                }
            }
            String title = this.iDispNote ? same.firstElement().getSchedulePrintNote() : null;
            boolean bl = hasTitle = title != null && title.trim().length() > 0;
            boolean titleSameLine = hasTitle && (" " + title).length() <= (this.iDispLimits ? 28 : 46) - this.formatSection(same).length() - (same.size() > 1 ? " (" + same.size() + ")" : "").length();
            boolean titleSeparateLine = hasTitle && !titleSameLine;
            boolean bl2 = hasMw = cmw.length() > 0;
            boolean mwSameLine = hasMw && !titleSameLine && (" m/w " + cmw).length() <= (this.iDispLimits ? 28 : 46) - this.formatSection(same).length() - (same.size() > 1 ? " (" + same.size() + ")" : "").length();
            boolean bl3 = mwSeparateLine = hasMw && !mwSameLine;
            if ((titleSeparateLine || mwSeparateLine) && this.getLineNumber() + 1 + (titleSeparateLine ? 0 : 1) + (mwSeparateLine ? 1 : 0) > this.iNrLines) {
                this.newPage();
            }
            this.println(this.lpad(this.iITypePrinted ? "" : same.firstElement().getSchedulingSubpart().getItypeDesc().trim(), 13) + " " + this.rpad(this.formatSection(same) + (same.size() > 1 ? " (" + same.size() + ")" : "") + (titleSameLine ? " " + title : "") + (mwSameLine ? " m/w " + cmw : ""), this.iDispLimits ? 28 : 46) + (this.iDispLimits ? this.lpad(maxLimit <= 0 ? "" : (minLimit != maxLimit ? minLimit + "-" + maxLimit : "" + minLimit), 9) + this.lpad(maxEnrl <= 0 ? "" : (minEnrl != maxEnrl ? minEnrl + "-" + maxEnrl : "" + minEnrl), 9) + " " : " ") + "         " + message);
            if (titleSeparateLine) {
                this.println(this.lpad("", 13) + "  " + (title.length() > 118 ? title.substring(0, 115) + "..." : title));
            }
            if (mwSeparateLine) {
                this.println(this.lpad("", 13) + "  Meets with " + (cmw.length() > 107 ? cmw.substring(0, 104) + "..." : cmw));
            }
            this.iITypePrinted = !this.iNewPage;
        } else {
            for (ExamAssignmentInfo exam : exams) {
                boolean mwSecondLine;
                boolean mwSameLine;
                boolean hasMw;
                boolean titleSameLine;
                boolean hasTitle;
                Vector<String> rooms = new Vector<String>();
                Vector<String> times = new Vector<String>();
                if (exam.getPeriod() == null) {
                    times.add(this.rpad(this.iHasAssignment ? " Exam not assigned" : " Section exam", 26));
                    rooms.add(this.rpad("", 23));
                    for (Preference pref : new TreeSet<Preference>(exam.getExam().getPreferences())) {
                        String pf;
                        if (!PreferenceLevel.sRequired.equals(pref.getPrefLevel().getPrefProlog()) && !PreferenceLevel.sProhibited.equals(pref.getPrefLevel().getPrefProlog())) continue;
                        String string = pf = PreferenceLevel.sRequired.equals(pref.getPrefLevel().getPrefProlog()) ? " " : "!";
                        if (pref instanceof ExamPeriodPref) {
                            ExamPeriodPref xp = (ExamPeriodPref)pref;
                            times.add(pf + this.rpad(this.formatPeriod(xp.getExamPeriod(), exam.getLength(), exam.getPrintOffset()), 25));
                            continue;
                        }
                        if (exam.getMaxRooms() <= 0) continue;
                        if (pref instanceof RoomPref) {
                            RoomPref rp = (RoomPref)pref;
                            rooms.add(pf + this.formatRoom(rp.getRoom()) + " " + this.lpad("" + rp.getRoom().getCapacity(), 4) + " " + this.lpad("" + rp.getRoom().getExamCapacity(), 5));
                            continue;
                        }
                        if (pref instanceof BuildingPref) {
                            BuildingPref bp = (BuildingPref)pref;
                            rooms.add(pf + this.rpad(bp.getBuilding().getAbbreviation(), 22));
                            continue;
                        }
                        if (pref instanceof RoomFeaturePref) {
                            RoomFeaturePref fp = (RoomFeaturePref)pref;
                            rooms.add(pf + this.rpad(fp.getRoomFeature().getLabel(), 22));
                            continue;
                        }
                        if (!(pref instanceof RoomGroupPref)) continue;
                        RoomGroupPref gp = (RoomGroupPref)pref;
                        rooms.add(pf + this.rpad(gp.getRoomGroup().getName(), 22));
                    }
                    for (DistributionObject dObj : exam.getExam().getDistributionObjects()) {
                        DistributionPref pref = dObj.getDistributionPref();
                        if (!PreferenceLevel.sRequired.equals(pref.getPrefLevel().getPrefProlog()) && !PreferenceLevel.sProhibited.equals(pref.getPrefLevel().getPrefProlog())) continue;
                        int line = 0;
                        String name = (PreferenceLevel.sRequired.equals(pref.getPrefLevel().getPrefProlog()) ? " " : "!") + pref.getDistributionType().getAbbreviation();
                        if (name.toUpperCase().startsWith("!SAME ")) {
                            name = " Diff" + name.substring(5);
                        }
                        for (DistributionObject xObj : new TreeSet<DistributionObject>(pref.getDistributionObjects())) {
                            if (xObj.equals(dObj)) continue;
                            Exam x = (Exam)xObj.getPrefGroup();
                            for (ExamOwner own : new TreeSet<ExamOwner>(x.getOwners())) {
                                times.add(this.rpad(this.rpad(line > 0 ? "" : name, name.length()) + " " + own.getLabel(), 26));
                                ++line;
                            }
                        }
                    }
                } else {
                    if (exam.getRooms() == null || exam.getRooms().isEmpty()) {
                        rooms.add(" " + this.rpad(this.iNoRoom, 22));
                    } else {
                        for (ExamRoomInfo room : exam.getRooms()) {
                            rooms.add(" " + this.formatRoom(room) + " " + this.lpad("" + room.getCapacity(), 4) + " " + this.lpad("" + room.getExamCapacity(), 5));
                        }
                    }
                    times.add(" " + this.rpad(this.formatPeriod(exam), 25));
                }
                Vector<String> meetsWith = new Vector<String>();
                int cnt = 0;
                int maxCnt = Math.max(4, Math.max(rooms.size(), times.size()) - 1);
                for (ExamInfo.ExamSectionInfo section : exam.getSectionsIncludeCrosslistedDummies()) {
                    if (section.getOwnerType() == 3 && same.contains(section.getOwner().getOwnerObject()) || section.getOwnerType() == 2 && section.getOwnerId().equals(same.firstElement().getSchedulingSubpart().getInstrOfferingConfig().getUniqueId())) continue;
                    if (cnt >= maxCnt) {
                        meetsWith.add(" " + this.rpad("...", 14));
                        break;
                    }
                    if (this.iItype) {
                        meetsWith.add(" " + this.rpad(section.getName(), 14));
                    } else {
                        meetsWith.add(" " + this.rpad(section.getSubject(), 4) + " " + this.rpad(section.getCourseNbr(), 5) + " " + this.rpad(section.getSection(), 3));
                    }
                    ++cnt;
                }
                int nrLines = Math.max(Math.max(rooms.size(), meetsWith.size()), times.size());
                String title = this.iDispNote ? same.firstElement().getSchedulePrintNote() : null;
                boolean bl = hasTitle = !this.iPeriodPrinted && title != null && title.trim().length() > 0;
                boolean bl4 = hasTitle && (" " + title).length() <= (this.iDispLimits ? 28 : 46) - this.formatSection(same).length() - (same.size() > 1 ? " (" + same.size() + ")" : "").length() ? true : (titleSameLine = false);
                boolean titleSecondLine = hasTitle && !titleSameLine && nrLines > 1 && (" " + title).length() <= (this.iDispLimits ? 28 : 46);
                boolean titleSeparateLine = hasTitle && !titleSameLine && !titleSecondLine;
                boolean bl5 = hasMw = !this.iPeriodPrinted && cmw.length() > 0;
                boolean bl6 = hasMw && !titleSameLine && (" m/w " + cmw).length() <= (this.iDispLimits ? 28 : 46) - this.formatSection(same).length() - (same.size() > 1 ? " (" + same.size() + ")" : "").length() ? true : (mwSameLine = false);
                boolean bl7 = hasMw && !mwSameLine && !titleSecondLine && nrLines > 1 && (" Meets with " + cmw).length() <= (this.iDispLimits ? 28 : 46) ? true : (mwSecondLine = false);
                boolean mwThirdLine = hasMw && !mwSameLine && titleSecondLine && nrLines > 2 && (" Meets with " + cmw).length() <= (this.iDispLimits ? 28 : 46);
                boolean mwSeparateLine = hasMw && !mwSameLine && !mwSecondLine && !mwThirdLine;
                if (this.getLineNumber() + nrLines + (mwSeparateLine ? 1 : 0) + (titleSeparateLine ? 1 : 0) > this.iNrLines) {
                    this.newPage();
                }
                for (int idx = 0; idx < nrLines; ++idx) {
                    String room = idx < rooms.size() ? (String)rooms.elementAt(idx) : this.rpad("", 23);
                    String mw = idx < meetsWith.size() ? (String)meetsWith.elementAt(idx) : "";
                    String time = idx < times.size() ? (String)times.elementAt(idx) : this.rpad("", 26);
                    this.println(this.lpad(idx > 0 || this.iITypePrinted ? "" : same.firstElement().getSchedulingSubpart().getItypeDesc().trim(), 13) + " " + this.rpad(this.iPeriodPrinted ? "" : (idx > 0 ? (idx == 1 && mwSecondLine ? " Meets with " + cmw : "") + (idx == 1 && titleSecondLine ? " " + title : "") + (idx == 2 && mwThirdLine ? " Meets with " + cmw : "") : this.formatSection(same) + (same.size() > 1 ? " (" + same.size() + ")" : "") + (titleSameLine ? " " + title : "") + (mwSameLine ? " m/w " + cmw : "")), this.iDispLimits ? 28 : 46) + (this.iDispLimits ? this.lpad(this.iPeriodPrinted || idx > 0 || maxLimit <= 0 ? "" : (minLimit != maxLimit ? minLimit + "-" + maxLimit : "" + minLimit), 9) + this.lpad(this.iPeriodPrinted || idx > 0 || maxEnrl <= 0 ? "" : (minEnrl != maxEnrl ? minEnrl + "-" + maxEnrl : "" + minEnrl), 9) + " " : " ") + this.lpad(idx > 0 ? "" : (exam.getSeatingType() == 1 ? "yes" : "no"), 4) + " " + this.lpad(idx > 0 ? "" : String.valueOf(exam.getLength()), 3) + time + room + mw);
                    if (idx == 0 && titleSeparateLine) {
                        this.println(this.lpad("", 13) + "  " + (title.length() > 118 ? title.substring(0, 115) + "..." : title));
                    }
                    if (idx != 0 || !mwSeparateLine) continue;
                    this.println(this.lpad("", 13) + "  Meets with " + (cmw.length() > 107 ? cmw.substring(0, 104) + "..." : cmw));
                }
                this.iPeriodPrinted = !this.iNewPage;
                this.iITypePrinted = this.iPeriodPrinted;
            }
        }
    }

    @Override
    public void printReport() throws DocumentException {
        sLog.info((Object)"  Loading courses ...");
        TreeSet<CourseOffering> allCourses = new TreeSet<CourseOffering>(new Comparator<CourseOffering>(){

            @Override
            public int compare(CourseOffering co1, CourseOffering co2) {
                int cmp = co1.getSubjectAreaAbbv().compareTo(co2.getSubjectAreaAbbv());
                if (cmp != 0) {
                    return cmp;
                }
                cmp = co1.getCourseNbr().compareTo(co2.getCourseNbr());
                if (cmp != 0) {
                    return cmp;
                }
                return co1.getUniqueId().compareTo(co2.getUniqueId());
            }
        });
        if (this.hasSubjectAreas()) {
            for (SubjectArea subjectArea : this.getSubjectAreas()) {
                allCourses.addAll(new SessionDAO().getSession().createQuery("select co from CourseOffering co where  co.subjectArea.uniqueId=:subjectAreaId").setLong("subjectAreaId", subjectArea.getUniqueId().longValue()).list());
            }
        } else {
            allCourses.addAll(new SessionDAO().getSession().createQuery("select co from CourseOffering co where  co.subjectArea.session.uniqueId=:sessionId").setLong("sessionId", this.getSession().getUniqueId().longValue()).list());
        }
        if (allCourses.isEmpty()) {
            return;
        }
        sLog.info((Object)"  Loading class events...");
        Hashtable<Long, ClassEvent> class2event = new Hashtable<Long, ClassEvent>();
        if (this.hasSubjectAreas()) {
            for (SubjectArea subject : this.getSubjectAreas()) {
                for (Object[] o : new SessionDAO().getSession().createQuery("select c.uniqueId, e from ClassEvent e inner join e.clazz c left join fetch e.meetings m inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co where co.subjectArea.uniqueId=:subjectAreaId").setLong("subjectAreaId", subject.getUniqueId().longValue()).list()) {
                    class2event.put((Long)o[0], (ClassEvent)o[1]);
                }
            }
        } else {
            for (Object[] o : new SessionDAO().getSession().createQuery("select c.uniqueId, e from ClassEvent e inner join e.clazz c left join fetch e.meetings m inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co where co.subjectArea.session.uniqueId=:sessionId").setLong("sessionId", this.getSession().getUniqueId().longValue()).list()) {
                class2event.put((Long)o[0], (ClassEvent)o[1]);
            }
        }
        Hashtable<Long, Integer> hashtable = new Hashtable<Long, Integer>();
        Hashtable<Long, Integer> classLimits = new Hashtable<Long, Integer>();
        if (this.iDispLimits) {
            sLog.info((Object)"  Loading course limits ...");
            if (this.hasSubjectAreas()) {
                for (SubjectArea subject : this.getSubjectAreas()) {
                    for (Object[] o : new SessionDAO().getSession().createQuery("select co.uniqueId, count(distinct s.student.uniqueId) from StudentClassEnrollment s inner join s.courseOffering co where co.subjectArea.uniqueId=:subjectAreaId group by co.uniqueId").setLong("subjectAreaId", subject.getUniqueId().longValue()).list()) {
                        hashtable.put((Long)o[0], ((Number)o[1]).intValue());
                    }
                }
            } else {
                for (Object[] o : new SessionDAO().getSession().createQuery("select co.uniqueId, count(distinct s.student.uniqueId) from StudentClassEnrollment s inner join s.courseOffering co where co.subjectArea.session.uniqueId=:sessionId group by co.uniqueId").setLong("sessionId", this.getSession().getUniqueId().longValue()).list()) {
                    hashtable.put((Long)o[0], ((Number)o[1]).intValue());
                }
            }
            sLog.info((Object)"  Loading class limits ...");
            if (this.hasSubjectAreas()) {
                for (SubjectArea subject : this.getSubjectAreas()) {
                    for (Object[] o : new SessionDAO().getSession().createQuery("select c.uniqueId, count(distinct s.student.uniqueId) from StudentClassEnrollment s inner join s.clazz c inner join s.courseOffering co where co.subjectArea.uniqueId=:subjectAreaId group by c.uniqueId").setLong("subjectAreaId", subject.getUniqueId().longValue()).list()) {
                        classLimits.put((Long)o[0], ((Number)o[1]).intValue());
                    }
                }
            } else {
                for (Object[] o : new SessionDAO().getSession().createQuery("select c.uniqueId, count(distinct s.student.uniqueId) from StudentClassEnrollment s inner join s.clazz c inner join s.courseOffering co where co.subjectArea.session.uniqueId=:sessionId group by c.uniqueId").setLong("sessionId", this.getSession().getUniqueId().longValue()).list()) {
                    classLimits.put((Long)o[0], ((Number)o[1]).intValue());
                }
            }
        }
        sLog.info((Object)"  Printing report ...");
        SubjectArea subject = null;
        this.setHeader(new String[]{"Course        Title                       " + (this.iDispLimits ? "                  " : "                  ") + " Alt  Len                                                  ", "   InsType      Sections                  " + (this.iDispLimits ? " Limit    Enrollmt" : "                  ") + " Seat gth Date & Time               Room         Cap ExCap Exam with", "------------- ----------------------------" + (this.iDispLimits ? " -------- --------" : "------------------") + " ---- --- ------------------------- ----------- ---- ----- --------------"});
        this.printHeader();
        for (CourseOffering co : allCourses) {
            InstructionalOffering io = co.getInstructionalOffering();
            if (io.isNotOffered().booleanValue() || !co.isIsControl().booleanValue() && co.getInstructionalOffering().getControllingCourseOffering().getSubjectArea().equals(co.getSubjectArea())) continue;
            if (subject == null) {
                subject = co.getSubjectArea();
                this.setFooter(subject.getSubjectAreaAbbreviation());
            } else if (!subject.equals(co.getSubjectArea())) {
                subject = co.getSubjectArea();
                this.newPage();
                this.setFooter(subject.getSubjectAreaAbbreviation());
            }
            this.setPageName(co.getCourseName());
            this.setCont(co.getCourseName());
            TreeSet<CourseOffering> courses = new TreeSet<CourseOffering>(new CourseOfferingComparator(2));
            courses.addAll(co.getInstructionalOffering().getCourseOfferings());
            boolean hasCourseExam = false;
            for (CourseOffering course : courses) {
                if (this.getExams(course).isEmpty()) continue;
                hasCourseExam = true;
                break;
            }
            for (CourseOffering course : courses) {
                int courseLimit = -1;
                InstructionalOffering offering = course.getInstructionalOffering();
                boolean unlimited = false;
                if (co.getReservation() != null) {
                    courseLimit = co.getReservation();
                }
                if (courseLimit < 0 && offering.getCourseOfferings().size() == 1 && offering.getLimit() != null) {
                    courseLimit = offering.getLimit();
                }
                for (InstrOfferingConfig config : offering.getInstrOfferingConfigs()) {
                    if (!config.isUnlimitedEnrollment().booleanValue()) continue;
                    unlimited = true;
                }
                Integer enrl = this.iDispLimits ? (Integer)hashtable.get(course.getUniqueId()) : null;
                TreeSet<ExamAssignmentInfo> exams = this.getExams(course);
                String courseName = (course.isIsControl() != false ? "" : " ") + course.getCourseName();
                this.iCoursePrinted = false;
                if (exams.isEmpty()) {
                    this.println(this.rpad(courseName, 14) + this.rpad(course.getTitle() == null ? "" : course.getTitle(), this.iDispLimits ? 28 : 46) + (this.iDispLimits ? this.lpad(courseLimit <= 0 ? (unlimited ? "  inf" : "") : String.valueOf(courseLimit), 9) + this.lpad(enrl == null || enrl <= 0 ? "" : String.valueOf(enrl), 9) + " " : " ") + "         " + (hasCourseExam ? "** NO EXAM**" : ""));
                    continue;
                }
                for (ExamAssignmentInfo exam : exams) {
                    Vector<String> rooms = new Vector<String>();
                    Vector<String> times = new Vector<String>();
                    if (exam.getPeriod() == null) {
                        times.add(this.rpad(this.iHasAssignment ? " Exam not assigned" : " Course Exam", 26));
                        rooms.add(this.rpad("", 23));
                        for (Preference pref : new TreeSet<Preference>(exam.getExam().getPreferences())) {
                            String pf;
                            if (!PreferenceLevel.sRequired.equals(pref.getPrefLevel().getPrefProlog()) && !PreferenceLevel.sProhibited.equals(pref.getPrefLevel().getPrefProlog())) continue;
                            String string = pf = PreferenceLevel.sRequired.equals(pref.getPrefLevel().getPrefProlog()) ? " " : "!";
                            if (pref instanceof ExamPeriodPref) {
                                ExamPeriodPref xp = (ExamPeriodPref)pref;
                                times.add(pf + this.rpad(this.formatPeriod(xp.getExamPeriod(), exam.getLength(), exam.getPrintOffset()), 25));
                                continue;
                            }
                            if (exam.getMaxRooms() <= 0) continue;
                            if (pref instanceof RoomPref) {
                                RoomPref rp = (RoomPref)pref;
                                rooms.add(pf + this.formatRoom(rp.getRoom()) + " " + this.lpad("" + rp.getRoom().getCapacity(), 4) + " " + this.lpad("" + rp.getRoom().getExamCapacity(), 5));
                                continue;
                            }
                            if (pref instanceof BuildingPref) {
                                BuildingPref bp = (BuildingPref)pref;
                                rooms.add(pf + this.rpad(bp.getBuilding().getAbbreviation(), 22));
                                continue;
                            }
                            if (pref instanceof RoomFeaturePref) {
                                RoomFeaturePref fp = (RoomFeaturePref)pref;
                                rooms.add(pf + this.rpad(fp.getRoomFeature().getLabel(), 22));
                                continue;
                            }
                            if (!(pref instanceof RoomGroupPref)) continue;
                            RoomGroupPref gp = (RoomGroupPref)pref;
                            rooms.add(pf + this.rpad(gp.getRoomGroup().getName(), 22));
                        }
                        for (DistributionObject dObj : exam.getExam().getDistributionObjects()) {
                            DistributionPref pref = dObj.getDistributionPref();
                            if (!PreferenceLevel.sRequired.equals(pref.getPrefLevel().getPrefProlog()) && !PreferenceLevel.sProhibited.equals(pref.getPrefLevel().getPrefProlog())) continue;
                            Object name = (PreferenceLevel.sRequired.equals(pref.getPrefLevel().getPrefProlog()) ? " " : "!") + pref.getDistributionType().getAbbreviation();
                            if (((String)name).toUpperCase().startsWith("!SAME ")) {
                                name = " Diff" + ((String)name).substring(5);
                            }
                            int line = 0;
                            for (DistributionObject xObj : new TreeSet<DistributionObject>(pref.getDistributionObjects())) {
                                if (xObj.equals(dObj)) continue;
                                Exam x = (Exam)xObj.getPrefGroup();
                                for (ExamOwner own : new TreeSet<ExamOwner>(x.getOwners())) {
                                    times.add(this.rpad(this.rpad((String)(line > 0 ? "" : name), ((String)name).length()) + " " + own.getLabel(), 26));
                                    ++line;
                                }
                            }
                        }
                    } else {
                        if (exam.getRooms() == null || exam.getRooms().isEmpty()) {
                            rooms.add(" " + this.rpad(this.iNoRoom, 22));
                        } else {
                            for (ExamRoomInfo room : exam.getRooms()) {
                                rooms.add(" " + this.formatRoom(room) + " " + this.lpad("" + room.getCapacity(), 4) + " " + this.lpad("" + room.getExamCapacity(), 5));
                            }
                        }
                        times.add(" " + this.rpad(this.formatPeriod(exam), 25));
                    }
                    Vector<String> meetsWith = new Vector<String>();
                    int cnt = 0;
                    int maxCnt = Math.max(4, Math.max(rooms.size(), times.size()) - 1);
                    for (ExamInfo.ExamSectionInfo section : exam.getSectionsIncludeCrosslistedDummies()) {
                        if (section.getOwnerType() == 1 && course.getUniqueId().equals(section.getOwnerId()) || section.getOwnerType() == 0 && course.getInstructionalOffering().getUniqueId().equals(section.getOwnerId())) continue;
                        if (cnt >= maxCnt) {
                            meetsWith.add(" " + this.rpad("...", 14));
                            break;
                        }
                        if (this.iItype) {
                            meetsWith.add(" " + this.rpad(section.getName(), 14));
                        } else {
                            meetsWith.add(" " + this.rpad(section.getSubject(), 4) + " " + this.rpad(section.getCourseNbr(), 5) + " " + this.rpad(section.getSection(), 3));
                        }
                        ++cnt;
                    }
                    int nrLines = Math.max(Math.max(rooms.size(), meetsWith.size()), times.size());
                    for (int idx = 0; idx < nrLines; ++idx) {
                        String room = idx < rooms.size() ? (String)rooms.elementAt(idx) : this.rpad("", 23);
                        String mw = idx < meetsWith.size() ? (String)meetsWith.elementAt(idx) : "";
                        String time = idx < times.size() ? (String)times.elementAt(idx) : this.rpad("", 26);
                        this.println(this.rpad(idx > 0 || this.iCoursePrinted ? "" : courseName, 14) + this.rpad(idx > 0 || this.iCoursePrinted ? "" : (course.getTitle() == null ? "" : course.getTitle()), this.iDispLimits ? 28 : 46) + (this.iDispLimits ? this.lpad(idx > 0 || this.iCoursePrinted ? "" : (courseLimit <= 0 ? (unlimited ? "  inf" : "") : String.valueOf(courseLimit)), 9) + this.lpad(idx > 0 || this.iCoursePrinted || enrl == null || enrl <= 0 ? "" : String.valueOf(enrl), 9) + " " : " ") + this.lpad(idx > 0 ? "" : (exam.getSeatingType() == 1 ? "yes" : "no"), 4) + " " + this.lpad(idx > 0 ? "" : String.valueOf(exam.getLength()), 3) + time + room + mw);
                    }
                    this.iCoursePrinted = !this.iNewPage;
                }
            }
            TreeSet<SchedulingSubpart> subparts = new TreeSet<SchedulingSubpart>(new SchedulingSubpartComparator());
            for (InstrOfferingConfig cfg : co.getInstructionalOffering().getInstrOfferingConfigs()) {
                subparts.addAll(cfg.getSchedulingSubparts());
            }
            boolean hasSubpartExam = false;
            InstrOfferingConfig cfg = null;
            for (SchedulingSubpart subpart : subparts) {
                if (this.iSkipSuffixSubparts && subpart.getParentSubpart() != null && subpart.getItype().equals(subpart.getParentSubpart().getItype())) continue;
                if (cfg == null) {
                    cfg = subpart.getInstrOfferingConfig();
                } else if (!cfg.equals(subpart.getInstrOfferingConfig())) {
                    cfg = subpart.getInstrOfferingConfig();
                    hasSubpartExam = false;
                }
                this.iITypePrinted = false;
                TreeSet<Class_> classes = new TreeSet<Class_>(new Comparator<Class_>(){

                    @Override
                    public int compare(Class_ c1, Class_ c2) {
                        if (ExamVerificationReport.this.iUseClassSuffix) {
                            String sx1 = c1.getClassSuffix();
                            String sx2 = c2.getClassSuffix();
                            if (sx1 != null && sx2 != null) {
                                return sx1.compareTo(sx2);
                            }
                        }
                        return c1.getSectionNumber().compareTo(c2.getSectionNumber());
                    }
                });
                classes.addAll(subpart.getClasses());
                String mw = null;
                String message = null;
                TreeSet<ExamAssignmentInfo> exams = null;
                int minEnrl = 0;
                int maxEnrl = 0;
                int minLimit = 0;
                int maxLimit = 0;
                Vector<Class_> same = new Vector<Class_>();
                boolean hasSectionExam = false;
                boolean allSectionsHaveExam = true;
                for (Class_ clazz : classes) {
                    if (!this.getExams(clazz).isEmpty()) {
                        hasSectionExam = true;
                        continue;
                    }
                    allSectionsHaveExam = false;
                }
                if (allSectionsHaveExam) {
                    hasSubpartExam = true;
                }
                for (Class_ clazz : classes) {
                    Integer enrl;
                    Integer n = enrl = this.iDispLimits ? (Integer)classLimits.get(clazz.getUniqueId()) : null;
                    if (!same.isEmpty() && (this.iSkipHoles || same.lastElement().getSectionNumber() + 1 == clazz.getSectionNumber()) && (!this.iDispNote || ToolBox.equals((Object)clazz.getSchedulePrintNote(), (Object)same.lastElement().getSchedulePrintNote())) && exams.equals(this.getExams(clazz)) && mw.equals(this.getMeetWith(clazz, null)) && message.equals(this.getMessage(clazz, hasCourseExam || hasSubpartExam, hasSectionExam, class2event))) {
                        minEnrl = Math.min(minEnrl, enrl == null ? 0 : enrl);
                        maxEnrl = Math.max(maxEnrl, enrl == null ? 0 : enrl);
                        minLimit = Math.min(minLimit, clazz.getClassLimit());
                        maxLimit = Math.max(maxLimit, clazz.getClassLimit());
                        message = this.getMessage(clazz, hasCourseExam || hasSubpartExam, hasSectionExam, class2event);
                        same.add(clazz);
                        continue;
                    }
                    if (!same.isEmpty()) {
                        this.print(same, hasCourseExam, hasSectionExam, minLimit, maxLimit, minEnrl, maxEnrl, class2event);
                        same.clear();
                    }
                    exams = this.getExams(clazz);
                    mw = this.getMeetWith(clazz, null);
                    maxEnrl = enrl == null ? 0 : enrl;
                    minEnrl = maxEnrl;
                    minLimit = maxLimit = clazz.getClassLimit();
                    message = this.getMessage(clazz, hasCourseExam || hasSubpartExam, hasSectionExam, class2event);
                    same.add(clazz);
                }
                if (same.isEmpty()) continue;
                this.print(same, hasCourseExam || hasSubpartExam, hasSectionExam, minLimit, maxLimit, minEnrl, maxEnrl, class2event);
            }
            if (this.iNewPage) continue;
            this.println("");
        }
        this.lastPage();
    }
}

