/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.status.db;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cpsolver.studentsct.online.expectations.OverExpectedCriterion;
import org.unitime.commons.NaturalOrderComparator;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.gwt.server.Query;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.model.Advisor;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.ClassEvent;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseCreditUnitConfig;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.FixedCreditUnitConfig;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalMethod;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Meeting;
import org.unitime.timetable.model.Reservation;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentAccomodation;
import org.unitime.timetable.model.StudentAreaClassificationMajor;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.StudentClassPref;
import org.unitime.timetable.model.StudentGroup;
import org.unitime.timetable.model.StudentInstrMthPref;
import org.unitime.timetable.model.StudentSectioningPref;
import org.unitime.timetable.model.base.BaseCourseRequest;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.status.FindEnrollmentInfoAction;
import org.unitime.timetable.onlinesectioning.status.FindStudentInfoAction;
import org.unitime.timetable.onlinesectioning.status.SectioningStatusFilterAction;
import org.unitime.timetable.onlinesectioning.status.StatusPageSuggestionsAction;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.NameFormat;

public class DbFindEnrollmentInfoAction
extends FindEnrollmentInfoAction {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningConstants CONSTANTS = Localization.create(StudentSectioningConstants.class);

    public boolean isMyStudent(Student student) {
        return this.iMyStudents != null && this.iMyStudents.contains(student.getUniqueId());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<ClassAssignmentInterface.EnrollmentInfo> execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        if (this.iFilter == null) {
            return super.execute(server, helper);
        }
        ArrayList<ClassAssignmentInterface.EnrollmentInfo> ret = new ArrayList<ClassAssignmentInterface.EnrollmentInfo>();
        AcademicSessionInfo session = server.getAcademicSession();
        StatusPageSuggestionsAction.CourseLookup lookup = new StatusPageSuggestionsAction.CourseLookup(server.getAcademicSession());
        if (this.courseId() == null) {
            HashSet<Long> students = new HashSet<Long>();
            HashSet<Long> matchingStudents = new HashSet<Long>();
            HashSet<Long> allStudents = new HashSet<Long>();
            int gEnrl = 0;
            int gWait = 0;
            int gRes = 0;
            int gUnasg = 0;
            int gUnasgPrim = 0;
            int gtEnrl = 0;
            int gtWait = 0;
            int gtRes = 0;
            int gtUnasg = 0;
            int gtUnasgPrim = 0;
            int gConNeed = 0;
            int gtConNeed = 0;
            int gOvrNeed = 0;
            int gtOvrNeed = 0;
            DbFindEnrollmentInfoCourseMatcher m = new DbFindEnrollmentInfoCourseMatcher(this.iCoursesIcoordinate, this.iCoursesIcanApprove, this.iSubjectAreas, this.iQuery, lookup);
            HashMap requests = new HashMap();
            for (Object cr : SectioningStatusFilterAction.getCourseQuery(this.iFilter, server, helper).select("distinct cr").query(helper.getHibSession()).list()) {
                void var27_50;
                if (!m.match(((BaseCourseRequest)cr).getCourseOffering())) continue;
                List list = (List)requests.get(((BaseCourseRequest)cr).getCourseOffering());
                if (list == null) {
                    ArrayList arrayList = new ArrayList();
                    requests.put(((BaseCourseRequest)cr).getCourseOffering(), arrayList);
                }
                var27_50.add(cr);
            }
            boolean checkOverrides = !this.query().hasAttribute("override");
            for (Map.Entry entry : requests.entrySet()) {
                Object request22;
                CourseOffering course = (CourseOffering)entry.getKey();
                InstructionalOffering offering = course.getInstructionalOffering();
                boolean isConsentToDoCourse = this.isConsentToDoCourse(course);
                ClassAssignmentInterface.EnrollmentInfo e = new ClassAssignmentInterface.EnrollmentInfo();
                e.setCourseId(course.getUniqueId());
                e.setOfferingId(offering.getUniqueId());
                e.setSubject(course.getSubjectAreaAbbv());
                e.setCourseNbr(course.getCourseNbr());
                e.setTitle(course.getTitle());
                e.setConsent(course.getConsentType() == null ? null : course.getConsentType().getAbbv());
                int match = 0;
                int enrl = 0;
                int wait = 0;
                int res = 0;
                int unasg = 0;
                int unasgPrim = 0;
                int tEnrl = 0;
                int tWait = 0;
                int tRes = 0;
                int tUnasg = 0;
                int tUnasgPrim = 0;
                int conNeed = 0;
                int tConNeed = 0;
                int ovrNeed = 0;
                int tOvrNeed = 0;
                for (Object request22 : helper.getHibSession().createQuery("from CourseRequest where courseOffering.uniqueId = :courseId").setLong("courseId", course.getUniqueId().longValue()).setCacheable(true).list()) {
                    if (checkOverrides && !((CourseRequest)request22).isRequestApproved() && ((CourseRequest)request22).getClassEnrollments().isEmpty()) continue;
                    DbCourseRequestMatcher crm = new DbCourseRequestMatcher(session, (CourseRequest)request22, isConsentToDoCourse, this.isMyStudent(((BaseCourseRequest)request22).getCourseDemand().getStudent()), helper.getStudentNameFormat(), lookup);
                    if (this.query().match(crm)) continue;
                    allStudents.add(crm.student().getUniqueId());
                    if (!crm.enrollment().isEmpty()) {
                        ++tEnrl;
                        if (crm.reservation() != null) {
                            ++tRes;
                        }
                        if (((BaseCourseRequest)request22).getCourseOffering().getConsentType() == null || crm.approval() != null) continue;
                        ++tConNeed;
                        continue;
                    }
                    if (!crm.canAssign()) continue;
                    ++tUnasg;
                    if (((BaseCourseRequest)request22).getCourseDemand().isAlternative().booleanValue() || ((BaseCourseRequest)request22).getOrder() != 0) continue;
                    ++tUnasgPrim;
                    if (!((BaseCourseRequest)request22).getCourseDemand().isWaitlist().booleanValue()) continue;
                    ++tWait;
                }
                HashSet<Long> addedStudents = new HashSet<Long>();
                request22 = ((List)entry.getValue()).iterator();
                while (request22.hasNext()) {
                    CourseRequest request3 = (CourseRequest)request22.next();
                    if (checkOverrides && !request3.isRequestApproved() && request3.getClassEnrollments().isEmpty()) continue;
                    Student student = request3.getCourseDemand().getStudent();
                    if (students.add(student.getUniqueId())) {
                        addedStudents.add(student.getUniqueId());
                    }
                    DbCourseRequestMatcher crm = new DbCourseRequestMatcher(session, request3, isConsentToDoCourse, this.isMyStudent(student), helper.getStudentNameFormat(), lookup);
                    if (this.query().match(crm)) {
                        matchingStudents.add(student.getUniqueId());
                        ++match;
                        if (!crm.enrollment().isEmpty()) {
                            ++enrl;
                            if (crm.reservation() != null) {
                                ++res;
                            }
                            if (request3.getCourseOffering().getConsentType() != null && crm.approval() == null) {
                                ++conNeed;
                            }
                        } else if (crm.canAssign()) {
                            ++unasg;
                            if (!request3.getCourseDemand().isAlternative().booleanValue() && request3.getOrder() == 0) {
                                ++unasgPrim;
                                if (request3.getCourseDemand().isWaitlist().booleanValue()) {
                                    ++wait;
                                }
                            }
                        }
                        if (request3.isRequestPending()) {
                            ++ovrNeed;
                        }
                    }
                    if (allStudents.add(crm.student().getUniqueId())) {
                        if (!crm.enrollment().isEmpty()) {
                            ++tEnrl;
                            if (crm.reservation() != null) {
                                ++tRes;
                            }
                            if (request3.getCourseOffering().getConsentType() != null && crm.approval() == null) {
                                ++tConNeed;
                            }
                        } else if (crm.canAssign()) {
                            ++tUnasg;
                            if (!request3.getCourseDemand().isAlternative().booleanValue() && request3.getOrder() == 0) {
                                ++tUnasgPrim;
                                if (request3.getCourseDemand().isWaitlist().booleanValue()) {
                                    ++tWait;
                                }
                            }
                        }
                    }
                    if (!request3.isRequestPending()) continue;
                    ++tOvrNeed;
                }
                if (match == 0) {
                    students.removeAll(addedStudents);
                    continue;
                }
                gEnrl += enrl;
                gWait += wait;
                gUnasg += unasg;
                gUnasgPrim += unasgPrim;
                gRes += res;
                gConNeed += conNeed;
                gOvrNeed += ovrNeed;
                gtEnrl += tEnrl;
                gtWait += tWait;
                gtUnasg += tUnasg;
                gtUnasgPrim += tUnasgPrim;
                gtRes += tRes;
                gtConNeed += tConNeed;
                gtOvrNeed += tOvrNeed;
                int limit = 0;
                for (InstrOfferingConfig config : offering.getInstrOfferingConfigs()) {
                    if (config.isUnlimitedEnrollment().booleanValue()) {
                        limit = -1;
                        break;
                    }
                    limit += config.getLimit().intValue();
                }
                e.setLimit(course.getReservation() != null ? course.getReservation() : limit);
                e.setProjection(course.getProjectedDemand() != null ? course.getProjectedDemand() : (course.getDemand() != null ? course.getDemand() : 0));
                int av = Math.max(0, offering.getUnreservedSpace());
                if (e.getLimit() >= 0 && av > e.getLimit() - course.getEnrollment()) {
                    av = e.getLimit() - course.getEnrollment();
                }
                if (av == Integer.MAX_VALUE) {
                    av = -1;
                }
                e.setAvailable(av);
                if (av >= 0) {
                    int other = 0;
                    for (CourseOffering c : offering.getCourseOfferings()) {
                        if (c.equals(course)) continue;
                        other += c.getEnrollment().intValue();
                    }
                    e.setOther(Math.min(e.getLimit() - course.getEnrollment() - av, other));
                    int lim = 0;
                    for (InstrOfferingConfig f : offering.getInstrOfferingConfigs()) {
                        if (lim < 0 || f.isUnlimitedEnrollment().booleanValue()) {
                            lim = -1;
                            continue;
                        }
                        lim += f.getLimit().intValue();
                    }
                    if (lim >= 0 && lim < e.getLimit()) {
                        e.setOther(e.getOther() + e.getLimit() - limit);
                    }
                }
                e.setEnrollment(enrl);
                e.setReservation(res);
                e.setWaitlist(wait);
                e.setUnassigned(unasg);
                e.setUnassignedPrimary(unasgPrim);
                e.setTotalEnrollment(tEnrl);
                e.setTotalReservation(tRes);
                e.setTotalWaitlist(tWait);
                e.setTotalUnassigned(tUnasg);
                e.setTotalUnassignedPrimary(tUnasgPrim);
                e.setConsentNeeded(conNeed);
                e.setTotalConsentNeeded(tConNeed);
                e.setOverrideNeeded(ovrNeed);
                e.setTotalOverrideNeeded(tOvrNeed);
                ret.add(e);
                if (this.limit() == null || ret.size() < this.limit()) continue;
                break;
            }
            final NaturalOrderComparator noc = new NaturalOrderComparator();
            Collections.sort(ret, new Comparator<ClassAssignmentInterface.EnrollmentInfo>(){

                @Override
                public int compare(ClassAssignmentInterface.EnrollmentInfo e1, ClassAssignmentInterface.EnrollmentInfo e2) {
                    int cmp = noc.compare(e1.getSubject(), e2.getSubject());
                    if (cmp != 0) {
                        return cmp;
                    }
                    cmp = e1.getCourseNbr().compareTo(e2.getCourseNbr());
                    if (cmp != 0) {
                        return cmp;
                    }
                    return 0;
                }
            });
            ClassAssignmentInterface.EnrollmentInfo enrollmentInfo = new ClassAssignmentInterface.EnrollmentInfo();
            enrollmentInfo.setSubject(MSG.total());
            enrollmentInfo.setCourseNbr("");
            enrollmentInfo.setLimit(students.size());
            enrollmentInfo.setAvailable(matchingStudents.size());
            enrollmentInfo.setEnrollment(gEnrl);
            enrollmentInfo.setReservation(gRes);
            enrollmentInfo.setWaitlist(gWait);
            enrollmentInfo.setUnassigned(gUnasg);
            enrollmentInfo.setUnassignedPrimary(gUnasgPrim);
            enrollmentInfo.setTotalEnrollment(gtEnrl);
            enrollmentInfo.setTotalReservation(gtRes);
            enrollmentInfo.setTotalWaitlist(gtWait);
            enrollmentInfo.setTotalUnassigned(gtUnasg);
            enrollmentInfo.setTotalUnassignedPrimary(gtUnasgPrim);
            enrollmentInfo.setConsentNeeded(gConNeed);
            enrollmentInfo.setTotalConsentNeeded(gtConNeed);
            enrollmentInfo.setOverrideNeeded(gOvrNeed);
            enrollmentInfo.setTotalOverrideNeeded(gtOvrNeed);
            ret.add(enrollmentInfo);
        } else {
            final CourseOffering course = (CourseOffering)CourseOfferingDAO.getInstance().get(this.courseId(), helper.getHibSession());
            if (course == null) {
                return ret;
            }
            InstructionalOffering offering = course.getInstructionalOffering();
            if (offering == null) {
                return ret;
            }
            List requests = helper.getHibSession().createQuery("from CourseRequest where courseOffering.instructionalOffering.uniqueId = :offeringId").setLong("offeringId", offering.getUniqueId().longValue()).setCacheable(true).list();
            OverExpectedCriterion overExp = server.getOverExpectedCriterion();
            boolean isConsentToDoCourse = this.isConsentToDoCourse(course);
            ArrayList<Class_> sections = new ArrayList<Class_>();
            for (InstrOfferingConfig config : offering.getInstrOfferingConfigs()) {
                for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
                    sections.addAll(subpart.getClasses());
                }
            }
            Collections.sort(sections, new Comparator<Class_>(){

                @Override
                public int compare(InstrOfferingConfig c1, InstrOfferingConfig c2) {
                    int cmp = c1.getName().compareToIgnoreCase(c2.getName());
                    if (cmp != 0) {
                        return cmp;
                    }
                    return c1.getUniqueId().compareTo(c2.getUniqueId());
                }

                public boolean isParent(SchedulingSubpart s1, SchedulingSubpart s2) {
                    SchedulingSubpart p1 = s1.getParentSubpart();
                    if (p1 == null) {
                        return false;
                    }
                    if (p1.equals(s2)) {
                        return true;
                    }
                    return this.isParent(p1, s2);
                }

                @Override
                public int compare(SchedulingSubpart s1, SchedulingSubpart s2) {
                    int cmp = this.compare(s1.getInstrOfferingConfig(), s2.getInstrOfferingConfig());
                    if (cmp != 0) {
                        return cmp;
                    }
                    if (this.isParent(s1, s2)) {
                        return 1;
                    }
                    if (this.isParent(s2, s1)) {
                        return -1;
                    }
                    cmp = s1.getItype().compareTo(s2.getItype());
                    if (cmp != 0) {
                        return cmp;
                    }
                    return s1.getUniqueId().compareTo(s2.getUniqueId());
                }

                @Override
                public int compare(Class_ s1, Class_ s2) {
                    Class_ x;
                    if (s1.getSchedulingSubpart().equals(s2.getSchedulingSubpart())) {
                        int cmp;
                        if (s1.getParentClass() != null && (cmp = this.compare(s1.getParentClass(), s2.getParentClass())) != 0) {
                            return cmp;
                        }
                        try {
                            cmp = Integer.valueOf(s1.getClassSuffix(course) == null ? "0" : s1.getClassSuffix(course)).compareTo(Integer.valueOf(s2.getClassSuffix(course) == null ? "0" : s2.getClassSuffix(course)));
                            if (cmp != 0) {
                                return cmp;
                            }
                        }
                        catch (NumberFormatException cmp2) {
                            // empty catch block
                        }
                        cmp = (s1.getClassSuffix(course) == null ? "" : s1.getClassSuffix(course)).compareTo(s2.getClassSuffix(course) == null ? "" : s2.getClassSuffix(course));
                        if (cmp != 0) {
                            return cmp;
                        }
                        return s1.getUniqueId().compareTo(s2.getUniqueId());
                    }
                    for (x = s1; x != null; x = x.getParentClass()) {
                        if (!this.isParent(s2.getSchedulingSubpart(), x.getSchedulingSubpart())) continue;
                        Class_ s = s2.getParentClass();
                        while (!s.getSchedulingSubpart().equals(x.getSchedulingSubpart())) {
                            s = s.getParentClass();
                        }
                        int cmp = this.compare(x, s);
                        return cmp == 0 ? (x.equals(s1) ? -1 : this.compare(x.getSchedulingSubpart(), s.getSchedulingSubpart())) : cmp;
                    }
                    for (x = s2; x != null; x = x.getParentClass()) {
                        if (!this.isParent(s1.getSchedulingSubpart(), x.getSchedulingSubpart())) continue;
                        Class_ s = s1.getParentClass();
                        while (!s.getSchedulingSubpart().equals(x.getSchedulingSubpart())) {
                            s = s.getParentClass();
                        }
                        int cmp = this.compare(s, x);
                        return cmp == 0 ? (x.equals(s2) ? 1 : this.compare(x.getSchedulingSubpart(), x.getSchedulingSubpart())) : cmp;
                    }
                    int cmp = this.compare(s1.getSchedulingSubpart(), s2.getSchedulingSubpart());
                    if (cmp != 0) {
                        return cmp;
                    }
                    try {
                        cmp = Integer.valueOf(s1.getClassSuffix(course) == null ? "0" : s1.getClassSuffix(course)).compareTo(Integer.valueOf(s2.getClassSuffix(course) == null ? "0" : s2.getClassSuffix(course)));
                        if (cmp != 0) {
                            return cmp;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    cmp = (s1.getClassSuffix(course) == null ? "" : s1.getClassSuffix(course)).compareTo(s2.getClassSuffix(course) == null ? "" : s2.getClassSuffix(course));
                    if (cmp != 0) {
                        return cmp;
                    }
                    return s1.getUniqueId().compareTo(s2.getUniqueId());
                }
            });
            boolean checkOverrides = !this.query().hasAttribute("override");
            for (Class_ section : sections) {
                Object m;
                ClassAssignmentInterface.EnrollmentInfo e = new ClassAssignmentInterface.EnrollmentInfo();
                e.setCourseId(course.getUniqueId());
                e.setOfferingId(offering.getUniqueId());
                e.setSubject(course.getSubjectAreaAbbv());
                e.setCourseNbr(course.getCourseNbr());
                e.setTitle(course.getTitle());
                e.setConsent(course.getConsentType() == null ? null : course.getConsentType().getAbbv());
                SchedulingSubpart subpart = section.getSchedulingSubpart();
                InstrOfferingConfig config = subpart.getInstrOfferingConfig();
                e.setConfig(config.getName());
                e.setConfigId(config.getUniqueId());
                e.setSubpart(subpart.getItype().getAbbv().trim());
                if (subpart.getInstrOfferingConfig().getInstructionalMethod() != null) {
                    e.setSubpart(e.getSubpart() + " (" + subpart.getInstrOfferingConfig().getInstructionalMethod().getLabel() + ")");
                }
                e.setSubpartId(subpart.getUniqueId());
                e.setClazz(section.getClassSuffix(course));
                if (e.getClazz() == null) {
                    e.setClazz(section.getSectionNumberString());
                }
                e.setClazzId(section.getUniqueId());
                for (Class_ parent = section.getParentClass(); parent != null; parent = parent.getParentClass()) {
                    e.incLevel();
                }
                int match = 0;
                int enrl = 0;
                int wait = 0;
                int res = 0;
                int unasg = 0;
                int unasgPrim = 0;
                int tEnrl = 0;
                int tWait = 0;
                int n = 0;
                int tUnasg = 0;
                int tUnasgPrim = 0;
                int conNeed = 0;
                int tConNeed = 0;
                int other = 0;
                for (CourseRequest request : requests) {
                    m = new DbCourseRequestMatcher(session, request, isConsentToDoCourse, this.isMyStudent(request.getCourseDemand().getStudent()), helper.getStudentNameFormat(), lookup);
                    boolean contains = false;
                    for (StudentClassEnrollment x : ((DbCourseRequestMatcher)m).enrollment()) {
                        if (!x.getClazz().equals(section)) continue;
                        contains = true;
                        break;
                    }
                    if (!contains) continue;
                    if (!request.getCourseOffering().equals(course)) {
                        ++other;
                        continue;
                    }
                    if (this.query().match((Query.AmbigousTermMatcher)m)) {
                        ++match;
                        ++enrl;
                        if (((DbCourseRequestMatcher)m).reservation() != null) {
                            ++res;
                        }
                        if (course.getConsentType() != null && ((DbCourseRequestMatcher)m).approval() == null) {
                            ++conNeed;
                        }
                    }
                    ++tEnrl;
                    if (((DbCourseRequestMatcher)m).reservation() != null) {
                        ++n;
                    }
                    if (course.getConsentType() == null || ((DbCourseRequestMatcher)m).approval() != null) continue;
                    ++tConNeed;
                }
                for (CourseRequest request : requests) {
                    m = new DbCourseRequestMatcher(session, request, isConsentToDoCourse, this.isMyStudent(request.getCourseDemand().getStudent()), helper.getStudentNameFormat(), lookup);
                    if (!((DbCourseRequestMatcher)m).enrollment().isEmpty() || !request.getCourseOffering().equals(course) || !((DbCourseRequestMatcher)m).canAssign() || checkOverrides && !request.isRequestApproved()) continue;
                    if (this.query().match((Query.AmbigousTermMatcher)m)) {
                        ++match;
                        ++unasg;
                        if (!request.getCourseDemand().isAlternative().booleanValue() && request.getOrder() == 0) {
                            ++unasgPrim;
                            if (request.getCourseDemand().isWaitlist().booleanValue()) {
                                ++wait;
                            }
                        }
                    }
                    ++tUnasg;
                    if (request.getCourseDemand().isAlternative().booleanValue() || request.getOrder() != 0) continue;
                    ++tUnasgPrim;
                    if (!request.getCourseDemand().isWaitlist().booleanValue()) continue;
                    ++tWait;
                }
                if (match == 0) continue;
                e.setLimit(section.getSectioningLimit());
                e.setOther(other);
                e.setAvailable(section.isCancelled() != false || section.isEnabledForStudentScheduling() == false ? 0 : Math.max(0, section.getUnreservedSectionSpace()));
                if (e.getAvailable() == Integer.MAX_VALUE) {
                    e.setAvailable(-1);
                }
                e.setProjection(tEnrl + Math.max(0, (int)Math.round(section.getSectioningInfo() == null ? 0.0 : section.getSectioningInfo().getNbrExpectedStudents())));
                e.setEnrollment(enrl);
                e.setReservation(res);
                e.setWaitlist(wait);
                e.setUnassigned(unasg);
                e.setUnassignedPrimary(unasgPrim);
                e.setTotalEnrollment(tEnrl);
                e.setTotalReservation(n);
                e.setTotalWaitlist(tWait);
                e.setTotalUnassigned(tUnasg);
                e.setTotalUnassignedPrimary(tUnasgPrim);
                e.setConsentNeeded(conNeed);
                e.setTotalConsentNeeded(tConNeed);
                ClassAssignmentInterface.ClassAssignment a = new ClassAssignmentInterface.ClassAssignment();
                a.setClassId(section.getUniqueId());
                a.setSubpart(subpart.getItype().getAbbv().trim());
                if (subpart.getInstrOfferingConfig().getInstructionalMethod() != null) {
                    a.setSubpart(a.getSubpart() + " (" + subpart.getInstrOfferingConfig().getInstructionalMethod().getLabel() + ")");
                }
                a.setClassNumber(section.getClassSuffix() == null ? section.getSectionNumber(helper.getHibSession()) + section.getSchedulingSubpart().getSchedulingSubpartSuffix(helper.getHibSession()) : section.getClassSuffix());
                a.setSection(section.getClassSuffix(course));
                a.setExternalId(section.getExternalId(course));
                a.setCancelled(section.isCancelled());
                a.setLimit(new int[]{section.getEnrollment(), section.getSectioningLimit()});
                Assignment assignment = section.getCommittedAssignment();
                if (assignment != null) {
                    for (DayCode d : DayCode.toDayCodes(assignment.getDays())) {
                        a.addDay(d.getIndex());
                    }
                    a.setStart(assignment.getStartSlot());
                    a.setLength(assignment.getSlotPerMtg());
                    a.setBreakTime(assignment.getBreakTime());
                    a.setDatePattern(assignment.getDatePattern().getName());
                }
                if (assignment != null && !assignment.getRooms().isEmpty()) {
                    for (Location rm : assignment.getRooms()) {
                        a.addRoom(rm.getUniqueId(), rm.getLabelWithDisplayName());
                    }
                }
                if (section.isDisplayInstructor().booleanValue() && !section.getClassInstructors().isEmpty()) {
                    for (ClassInstructor instructor : section.getClassInstructors()) {
                        a.addInstructor(helper.getInstructorNameFormat().format(instructor.getInstructor()));
                        a.addInstructoEmail(instructor.getInstructor().getEmail());
                    }
                }
                if (section.getParentClass() != null) {
                    a.setParentSection(section.getParentClass().getClassSuffix(course));
                }
                a.setSubpartId(section.getSchedulingSubpart().getUniqueId());
                a.addNote(course.getScheduleBookNote());
                a.addNote(section.getSchedulePrintNote());
                if (section.getSchedulingSubpart().getCredit() != null) {
                    a.setCredit(section.getSchedulingSubpart().getCredit().creditAbbv() + "|" + section.getSchedulingSubpart().getCredit().creditText());
                } else if (section.getParentClass() != null && course.getCredit() != null) {
                    a.setCredit(course.getCredit().creditAbbv() + "|" + course.getCredit().creditText());
                }
                Float creditOverride = section.getCredit(course);
                if (creditOverride != null) {
                    a.setCredit(FixedCreditUnitConfig.formatCredit(creditOverride.floatValue()));
                }
                if (a.getParentSection() == null) {
                    String consent;
                    String string = consent = course.getConsentType() == null ? null : course.getConsentType().getLabel();
                    if (consent != null) {
                        a.setParentSection(consent);
                    }
                }
                a.setExpected(overExp.getExpected(section.getSectioningLimit(), section.getSectioningInfo() == null ? 0.0 : section.getSectioningInfo().getNbrExpectedStudents()));
                e.setAssignment(a);
                ret.add(e);
            }
        }
        return ret;
    }

    public boolean isConsentToDoCourse(CourseOffering course) {
        return this.iCoursesIcanApprove != null && course.getConsentType() != null && this.iCoursesIcanApprove.contains(course.getUniqueId());
    }

    public static class DbFindStudentInfoMatcher
    extends FindStudentInfoAction.FindStudentInfoMatcher {
        private static final long serialVersionUID = 1L;
        protected NameFormat iFormat;

        public DbFindStudentInfoMatcher(AcademicSessionInfo session, Query query, NameFormat format, Set<Long> myStudents) {
            super(session, query, myStudents);
            this.iFormat = format;
        }

        public boolean isMyStudent(Student student) {
            return this.iMyStudents != null && this.iMyStudents.contains(student.getUniqueId());
        }

        public boolean match(Student student) {
            return student != null && this.iQuery.match(new DbStudentMatcher(student, this.iDefaultSectioningStatus, this.iFormat, this.isMyStudent(student)));
        }
    }

    public static class DbStudentMatcher
    implements Query.TermMatcher {
        private Student iStudent;
        private String iDefaultStatus;
        private NameFormat iFormat = null;
        private boolean iMyStudent = false;

        public DbStudentMatcher(Student student, String defaultStatus, NameFormat format, boolean myStudent) {
            this.iStudent = student;
            this.iDefaultStatus = defaultStatus;
            this.iFormat = format;
            this.iMyStudent = myStudent;
        }

        public DbStudentMatcher(Student student) {
            this.iStudent = student;
            this.iDefaultStatus = student.getSession().getDefaultSectioningStatus() == null ? null : student.getSession().getDefaultSectioningStatus().getReference();
            this.iFormat = NameFormat.fromReference(ApplicationProperty.OnlineSchedulingStudentNameFormat.value());
        }

        public Student student() {
            return this.iStudent;
        }

        public String status() {
            return this.iStudent.getSectioningStatus() == null ? this.iDefaultStatus : this.iStudent.getSectioningStatus().getReference();
        }

        @Override
        public boolean match(String attr, String term) {
            block82: {
                block86: {
                    block85: {
                        block84: {
                            block83: {
                                block81: {
                                    if (attr == null && term.isEmpty()) {
                                        return true;
                                    }
                                    if ("limit".equals(attr)) {
                                        return true;
                                    }
                                    if (!"area".equals(attr)) break block81;
                                    for (StudentAreaClassificationMajor acm : this.student().getAreaClasfMajors()) {
                                        if (!this.eq(acm.getAcademicArea().getAcademicAreaAbbreviation(), term)) continue;
                                        return true;
                                    }
                                    break block82;
                                }
                                if (!"clasf".equals(attr) && !"classification".equals(attr)) break block83;
                                for (StudentAreaClassificationMajor acm : this.student().getAreaClasfMajors()) {
                                    if (!this.eq(acm.getAcademicClassification().getCode(), term)) continue;
                                    return true;
                                }
                                break block82;
                            }
                            if (!"major".equals(attr)) break block84;
                            for (StudentAreaClassificationMajor acm : this.student().getAreaClasfMajors()) {
                                if (!this.eq(acm.getMajor().getCode(), term)) continue;
                                return true;
                            }
                            break block82;
                        }
                        if (!"group".equals(attr)) break block85;
                        for (StudentGroup group : this.student().getGroups()) {
                            if (!this.eq(group.getGroupAbbreviation(), term)) continue;
                            return true;
                        }
                        break block82;
                    }
                    if (!"accommodation".equals(attr)) break block86;
                    for (StudentAccomodation acc : this.student().getAccomodations()) {
                        if (!this.eq(acc.getAbbreviation(), term)) continue;
                        return true;
                    }
                    break block82;
                }
                if ("student".equals(attr)) {
                    return this.has(this.iFormat.format(this.student()), term) || this.eq(this.student().getExternalUniqueId(), term) || this.eq(this.iFormat.format(this.student()), term);
                }
                if ("advisor".equals(attr)) {
                    for (Advisor a : this.student().getAdvisors()) {
                        if (!this.eq(a.getExternalUniqueId(), term)) continue;
                        return true;
                    }
                    return false;
                }
                if ("registered".equals(attr)) {
                    return !this.eq("true", term) && !this.eq("1", term);
                }
                if ("status".equals(attr)) {
                    if ("default".equalsIgnoreCase(term) || "Not Set".equalsIgnoreCase(term)) {
                        return this.iStudent.getSectioningStatus() == null;
                    }
                    return term.equalsIgnoreCase(this.status());
                }
                if ("credit".equals(attr)) {
                    String im;
                    float max;
                    float min;
                    block80: {
                        Matcher m;
                        block79: {
                            min = 0.0f;
                            max = Float.MAX_VALUE;
                            SectioningStatusFilterAction.Credit prefix = SectioningStatusFilterAction.Credit.eq;
                            String number = term;
                            if (number.startsWith("<=")) {
                                prefix = SectioningStatusFilterAction.Credit.le;
                                number = number.substring(2);
                            } else if (number.startsWith(">=")) {
                                prefix = SectioningStatusFilterAction.Credit.ge;
                                number = number.substring(2);
                            } else if (number.startsWith("<")) {
                                prefix = SectioningStatusFilterAction.Credit.lt;
                                number = number.substring(1);
                            } else if (number.startsWith(">")) {
                                prefix = SectioningStatusFilterAction.Credit.gt;
                                number = number.substring(1);
                            } else if (number.startsWith("=")) {
                                prefix = SectioningStatusFilterAction.Credit.eq;
                                number = number.substring(1);
                            }
                            im = null;
                            try {
                                float a = Float.parseFloat(number);
                                switch (prefix) {
                                    case eq: {
                                        min = max = a;
                                        break;
                                    }
                                    case le: {
                                        max = a;
                                        break;
                                    }
                                    case ge: {
                                        min = a;
                                        break;
                                    }
                                    case lt: {
                                        max = a - 1.0f;
                                        break;
                                    }
                                    case gt: {
                                        min = a + 1.0f;
                                    }
                                }
                            }
                            catch (NumberFormatException e) {
                                m = Pattern.compile("([0-9]+\\.?[0-9]*)([^0-9\\.].*)").matcher(number);
                                if (!m.matches()) break block79;
                                float a = Float.parseFloat(m.group(1));
                                im = m.group(2).trim();
                                switch (prefix) {
                                    case eq: {
                                        min = max = a;
                                        break;
                                    }
                                    case le: {
                                        max = a;
                                        break;
                                    }
                                    case ge: {
                                        min = a;
                                        break;
                                    }
                                    case lt: {
                                        max = a - 1.0f;
                                        break;
                                    }
                                    case gt: {
                                        min = a + 1.0f;
                                    }
                                }
                            }
                        }
                        if (term.contains("..")) {
                            try {
                                String a = term.substring(0, term.indexOf(46));
                                String b = term.substring(term.indexOf("..") + 2);
                                min = Float.parseFloat(a);
                                max = Float.parseFloat(b);
                            }
                            catch (NumberFormatException e) {
                                m = Pattern.compile("([0-9]+\\.?[0-9]*)\\.\\.([0-9]+\\.?[0-9]*)([^0-9].*)").matcher(term);
                                if (!m.matches()) break block80;
                                min = Float.parseFloat(m.group(1));
                                max = Float.parseFloat(m.group(2));
                                im = m.group(3).trim();
                            }
                        }
                    }
                    float credit = 0.0f;
                    HashSet<Long> courseIds = new HashSet<Long>();
                    for (StudentClassEnrollment e : this.student().getClassEnrollments()) {
                        if (!courseIds.add(e.getCourseOffering().getUniqueId())) continue;
                        CourseCreditUnitConfig config = e.getCourseOffering().getCredit();
                        if ("!".equals(im) && e.getClazz().getSchedulingSubpart().getInstrOfferingConfig().getInstructionalMethod() != null || im != null && !"!".equals(im) && (e.getClazz().getSchedulingSubpart().getInstrOfferingConfig().getEffectiveInstructionalMethod() == null || !im.equalsIgnoreCase(e.getClazz().getSchedulingSubpart().getInstrOfferingConfig().getEffectiveInstructionalMethod().getReference())) || config == null) continue;
                        credit += config.getMinCredit();
                    }
                    return min <= credit && credit <= max;
                }
                if ("overlap".equals(attr)) {
                    int min = 0;
                    int max = Integer.MAX_VALUE;
                    SectioningStatusFilterAction.Credit prefix = SectioningStatusFilterAction.Credit.eq;
                    String number = term;
                    if (number.startsWith("<=")) {
                        prefix = SectioningStatusFilterAction.Credit.le;
                        number = number.substring(2);
                    } else if (number.startsWith(">=")) {
                        prefix = SectioningStatusFilterAction.Credit.ge;
                        number = number.substring(2);
                    } else if (number.startsWith("<")) {
                        prefix = SectioningStatusFilterAction.Credit.lt;
                        number = number.substring(1);
                    } else if (number.startsWith(">")) {
                        prefix = SectioningStatusFilterAction.Credit.gt;
                        number = number.substring(1);
                    } else if (number.startsWith("=")) {
                        prefix = SectioningStatusFilterAction.Credit.eq;
                        number = number.substring(1);
                    }
                    try {
                        int a = Integer.parseInt(number);
                        switch (prefix) {
                            case eq: {
                                min = max = a;
                                break;
                            }
                            case le: {
                                max = a;
                                break;
                            }
                            case ge: {
                                min = a;
                                break;
                            }
                            case lt: {
                                max = a - 1;
                                break;
                            }
                            case gt: {
                                min = a + 1;
                            }
                        }
                    }
                    catch (NumberFormatException a) {
                        // empty catch block
                    }
                    if (term.contains("..")) {
                        try {
                            String a = term.substring(0, term.indexOf(46));
                            String b = term.substring(term.indexOf("..") + 2);
                            min = Integer.parseInt(a);
                            max = Integer.parseInt(b);
                        }
                        catch (NumberFormatException a) {
                            // empty catch block
                        }
                    }
                    int share = 0;
                    for (StudentClassEnrollment section : this.student().getClassEnrollments()) {
                        Assignment assignment = section.getClazz().getCommittedAssignment();
                        if (assignment == null) continue;
                        for (StudentClassEnrollment otherSection : this.student().getClassEnrollments()) {
                            Assignment otherAssignment;
                            if (section.equals(otherSection) || (otherAssignment = otherSection.getClazz().getCommittedAssignment()) == null || !assignment.getTimeLocation().hasIntersection(otherAssignment.getTimeLocation()) || section.getClazz().isToIgnoreStudentConflictsWith(otherSection.getClazz()) || section.getClazz().getUniqueId() >= otherSection.getClazz().getUniqueId()) continue;
                            int sh = assignment.getTimeLocation().nrSharedDays(otherAssignment.getTimeLocation()) * assignment.getTimeLocation().nrSharedHours(otherAssignment.getTimeLocation()) * Constants.SLOT_LENGTH_MIN;
                            share += sh;
                        }
                    }
                    return min <= share && share <= max;
                }
                if ("override".equals(attr)) {
                    if ("null".equalsIgnoreCase(term) || "None".equalsIgnoreCase(term)) {
                        for (CourseDemand cd : this.student().getCourseDemands()) {
                            for (CourseRequest cr : cd.getCourseRequests()) {
                                if (cr.getOverrideStatus() != null) continue;
                                return true;
                            }
                        }
                        return false;
                    }
                    CourseRequest.CourseRequestOverrideStatus status = null;
                    for (CourseRequest.CourseRequestOverrideStatus s : CourseRequest.CourseRequestOverrideStatus.values()) {
                        if (!s.name().equalsIgnoreCase(term)) continue;
                        status = s;
                        break;
                    }
                    if (status == null) {
                        return false;
                    }
                    if (this.student().getOverrideStatus() != null && this.student().getOverrideStatus().intValue() == status.ordinal()) {
                        return true;
                    }
                    for (CourseDemand cd : this.student().getCourseDemands()) {
                        for (CourseRequest cr : cd.getCourseRequests()) {
                            if (cr.getOverrideStatus() == null || cr.getOverrideStatus().intValue() != status.ordinal()) continue;
                            return true;
                        }
                    }
                    return false;
                }
                if ("mode".equals(attr)) {
                    if (this.eq("My Students", term)) {
                        return this.iMyStudent;
                    }
                    return true;
                }
                if (attr == null) break block82;
                for (StudentGroup group : this.student().getGroups()) {
                    if (group.getType() == null || !this.eq(group.getType().getReference(), attr.replace('_', ' ')) || !this.eq(group.getGroupAbbreviation(), term)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean eq(String name, String term) {
            if (name == null) {
                return false;
            }
            return name.equalsIgnoreCase(term);
        }

        private boolean has(String name, String term) {
            if (name == null) {
                return false;
            }
            if (this.eq(name, term)) {
                return true;
            }
            for (String t : name.split(" |,")) {
                if (!t.equalsIgnoreCase(term)) continue;
                return true;
            }
            return false;
        }
    }

    public static class DbCourseRequestMatcher
    extends DbCourseInfoMatcher {
        private static final long serialVersionUID = 1L;
        private AcademicSessionInfo iSession;
        private Student iStudent;
        private CourseRequest iRequest;
        private InstructionalOffering iOffering;
        private String iDefaultStatus;
        private List<StudentClassEnrollment> iEnrollment = null;
        private NameFormat iFormat = null;
        private Reservation iReservation = null;
        private boolean iReservationGuessed = false;
        private boolean iMyStudent = false;

        public DbCourseRequestMatcher(AcademicSessionInfo session, CourseRequest request, boolean isConsentToDoCourse, boolean myStudent, NameFormat format, StatusPageSuggestionsAction.CourseLookup lookup) {
            super(request.getCourseOffering(), isConsentToDoCourse, lookup);
            this.iStudent = request.getCourseDemand().getStudent();
            this.iRequest = request;
            this.iDefaultStatus = session.getDefaultSectioningStatus();
            this.iOffering = request.getCourseOffering().getInstructionalOffering();
            this.iFormat = format;
            this.iMyStudent = myStudent;
        }

        public AcademicSessionInfo session() {
            return this.iSession;
        }

        public CourseRequest request() {
            return this.iRequest;
        }

        public List<StudentClassEnrollment> enrollment() {
            if (this.iEnrollment == null) {
                this.iEnrollment = this.iRequest.getClassEnrollments();
            }
            return this.iEnrollment;
        }

        public Student student() {
            return this.iStudent;
        }

        public String status() {
            return this.student().getSectioningStatus() == null ? this.iDefaultStatus : this.student().getSectioningStatus().getReference();
        }

        public InstructionalOffering offering() {
            return this.iOffering;
        }

        public String approval() {
            if (this.enrollment().isEmpty()) {
                return null;
            }
            HashSet<String> approval = new HashSet<String>();
            String ret = "";
            for (StudentClassEnrollment e : this.enrollment()) {
                if (e.getApprovedBy() == null || e.getApprovedDate() == null) {
                    return null;
                }
                if (!approval.add(e.getApprovedBy())) continue;
                ret = ret + (ret.isEmpty() ? "" : "|") + e.getApprovedBy();
            }
            return ret;
        }

        public Reservation reservation() {
            if (!this.iReservationGuessed) {
                this.iReservation = this.guessReservation();
                this.iReservationGuessed = true;
            }
            return this.iReservation;
        }

        protected Reservation guessReservation() {
            List<StudentClassEnrollment> enrollment = this.enrollment();
            if (enrollment.isEmpty()) {
                return null;
            }
            Reservation best = null;
            boolean mustBeUsed = false;
            for (Reservation reservation : this.iOffering.getReservations()) {
                if (!reservation.isApplicable(this.iStudent, this.iRequest) || !reservation.isMatching(enrollment)) continue;
                if (!mustBeUsed && reservation.isMustBeUsed()) {
                    best = null;
                    mustBeUsed = true;
                }
                if (mustBeUsed && !reservation.isMustBeUsed() || best != null && !((double)reservation.compareTo(best) < 0.0)) continue;
                best = reservation;
            }
            return best;
        }

        public boolean canAssign() {
            if (!this.enrollment().isEmpty()) {
                return true;
            }
            int alt = 0;
            for (CourseDemand demand : this.student().getCourseDemands()) {
                boolean waitlist;
                boolean assigned;
                boolean course = !demand.getCourseRequests().isEmpty();
                boolean bl = assigned = !course;
                if (course) {
                    for (CourseRequest request : demand.getCourseRequests()) {
                        if (request.getClassEnrollments().isEmpty()) continue;
                        assigned = true;
                        break;
                    }
                }
                if (demand.equals(this.request().getCourseDemand())) {
                    if (assigned) {
                        return false;
                    }
                    assigned = true;
                }
                boolean bl2 = waitlist = course && demand.isWaitlist() != false;
                if (demand.isAlternative().booleanValue()) {
                    if (!assigned) continue;
                    --alt;
                    continue;
                }
                if (!course || waitlist || assigned) continue;
                ++alt;
            }
            return alt >= 0;
        }

        @Override
        public Boolean match(String attr, String term) {
            if (attr == null || "name".equals(attr) || "title".equals(attr) || "subject".equals(attr) || "number".equals(attr) || "course".equals(attr) || "lookup".equals(attr) || "department".equals(attr) || "registered".equals(attr)) {
                return super.match(attr, term);
            }
            if ("limit".equals(attr)) {
                return true;
            }
            if ("area".equals(attr)) {
                for (StudentAreaClassificationMajor acm : this.student().getAreaClasfMajors()) {
                    if (!this.eq(acm.getAcademicArea().getAcademicAreaAbbreviation(), term)) continue;
                    return true;
                }
            }
            if ("clasf".equals(attr) || "classification".equals(attr)) {
                for (StudentAreaClassificationMajor acm : this.student().getAreaClasfMajors()) {
                    if (!this.eq(acm.getAcademicClassification().getCode(), term)) continue;
                    return true;
                }
            }
            if ("major".equals(attr)) {
                for (StudentAreaClassificationMajor acm : this.student().getAreaClasfMajors()) {
                    if (!this.eq(acm.getMajor().getCode(), term)) continue;
                    return true;
                }
            }
            if ("group".equals(attr)) {
                for (StudentGroup group : this.student().getGroups()) {
                    if (!this.eq(group.getGroupAbbreviation(), term)) continue;
                    return true;
                }
            } else {
                for (StudentGroup group : this.student().getGroups()) {
                    if (group.getType() == null || attr == null || !this.eq(group.getType().getReference(), attr.replace('_', ' ')) || !this.eq(group.getGroupAbbreviation(), term)) continue;
                    return true;
                }
            }
            if ("accommodation".equals(attr)) {
                for (StudentAccomodation acc : this.student().getAccomodations()) {
                    if (!this.eq(acc.getAbbreviation(), term)) continue;
                    return true;
                }
            }
            if ("student".equals(attr)) {
                if (ApplicationProperty.DataExchangeTrimLeadingZerosFromExternalIds.isTrue() && term.startsWith("0")) {
                    return this.has(this.iFormat.format(this.student()), term) || this.eq(this.student().getExternalUniqueId(), term.replaceFirst("^0+(?!$)", "")) || this.eq(this.iFormat.format(this.student()), term);
                }
                return this.has(this.iFormat.format(this.student()), term) || this.eq(this.student().getExternalUniqueId(), term) || this.eq(this.iFormat.format(this.student()), term);
            }
            if ("advisor".equals(attr)) {
                if (ApplicationProperty.DataExchangeTrimLeadingZerosFromExternalIds.isTrue() && term.startsWith("0")) {
                    for (Advisor a : this.student().getAdvisors()) {
                        if (!this.eq(a.getExternalUniqueId(), term.replaceFirst("^0+(?!$)", ""))) continue;
                        return true;
                    }
                } else {
                    for (Advisor a : this.student().getAdvisors()) {
                        if (!this.eq(a.getExternalUniqueId(), term)) continue;
                        return true;
                    }
                }
                return false;
            }
            if ("assignment".equals(attr)) {
                if (this.eq("Assigned", term)) {
                    return !this.enrollment().isEmpty();
                }
                if (this.eq("Reserved", term)) {
                    return !this.enrollment().isEmpty() && this.reservation() != null;
                }
                if (this.eq("Not Assigned", term)) {
                    return this.enrollment().isEmpty();
                }
                if (this.eq("Wait-Listed", term)) {
                    return this.enrollment().isEmpty() && this.request().getCourseDemand().isWaitlist() != false;
                }
                if (this.eq("Critical", term)) {
                    if (this.request().getCourseDemand().isCriticalOverride() != null) {
                        return (boolean)this.request().getCourseDemand().isCriticalOverride();
                    }
                    return this.request().getCourseDemand().isCritical() != null && this.request().getCourseDemand().isCritical() != false;
                }
                if (this.eq("Assigned Critical", term)) {
                    if (this.enrollment().isEmpty()) {
                        return false;
                    }
                    if (this.request().getCourseDemand().isCriticalOverride() != null) {
                        return (boolean)this.request().getCourseDemand().isCriticalOverride();
                    }
                    return this.request().getCourseDemand().isCritical() != null && this.request().getCourseDemand().isCritical() != false;
                }
                if (this.eq("Not Assigned Critical", term)) {
                    if (!this.enrollment().isEmpty()) {
                        return false;
                    }
                    if (this.request().getCourseDemand().isCriticalOverride() != null) {
                        return (boolean)this.request().getCourseDemand().isCriticalOverride();
                    }
                    return this.request().getCourseDemand().isCritical() != null && this.request().getCourseDemand().isCritical() != false;
                }
            }
            if ("assigned".equals(attr) || "scheduled".equals(attr)) {
                if (this.eq("true", term) || this.eq("1", term)) {
                    return !this.enrollment().isEmpty();
                }
                return this.enrollment().isEmpty();
            }
            if ("waitlisted".equals(attr) || "waitlist".equals(attr)) {
                if (this.eq("true", term) || this.eq("1", term)) {
                    return this.enrollment().isEmpty() && this.request().getCourseDemand().isWaitlist() != false;
                }
                return !this.enrollment().isEmpty();
            }
            if ("reservation".equals(attr) || "reserved".equals(attr)) {
                if (this.eq("true", term) || this.eq("1", term)) {
                    return !this.enrollment().isEmpty() && this.reservation() != null;
                }
                return !this.enrollment().isEmpty() && this.reservation() == null;
            }
            if ("consent".equals(attr)) {
                if (this.eq("none", term) || this.eq("No Consent", term)) {
                    return this.course().getConsentType() == null;
                }
                if (this.eq("Required", term) || this.eq("Consent", term)) {
                    return this.course().getConsentType() != null && !this.enrollment().isEmpty();
                }
                if (this.eq("Approved", term)) {
                    return this.course().getConsentType() != null && !this.enrollment().isEmpty() && this.approval() != null;
                }
                if (this.eq("Waiting", term)) {
                    return this.course().getConsentType() != null && !this.enrollment().isEmpty() && this.approval() == null;
                }
                if (this.eq("todo", term) || this.eq("To Do", term)) {
                    return this.isConsentToDoCourse() && this.course().getConsentType() != null && !this.enrollment().isEmpty() && this.approval() == null;
                }
                return this.course().getConsentType() != null && !this.enrollment().isEmpty() && (this.approval() != null && this.has(this.approval(), term) || this.eq(this.course().getConsentType().getAbbv(), term));
            }
            if ("mode".equals(attr)) {
                if (this.eq("My Students", term)) {
                    return this.iMyStudent;
                }
                return true;
            }
            if ("approver".equals(attr)) {
                return this.course().getConsentType() != null && !this.enrollment().isEmpty() && this.approval() != null && this.has(this.approval(), term);
            }
            if ("status".equals(attr)) {
                if ("default".equalsIgnoreCase(term) || "Not Set".equalsIgnoreCase(term)) {
                    return this.student().getSectioningStatus() == null;
                }
                return term.equalsIgnoreCase(this.status());
            }
            if ("credit".equals(attr)) {
                String im;
                float max;
                float min;
                block159: {
                    Matcher m;
                    block158: {
                        min = 0.0f;
                        max = Float.MAX_VALUE;
                        SectioningStatusFilterAction.Credit prefix = SectioningStatusFilterAction.Credit.eq;
                        String number = term;
                        if (number.startsWith("<=")) {
                            prefix = SectioningStatusFilterAction.Credit.le;
                            number = number.substring(2);
                        } else if (number.startsWith(">=")) {
                            prefix = SectioningStatusFilterAction.Credit.ge;
                            number = number.substring(2);
                        } else if (number.startsWith("<")) {
                            prefix = SectioningStatusFilterAction.Credit.lt;
                            number = number.substring(1);
                        } else if (number.startsWith(">")) {
                            prefix = SectioningStatusFilterAction.Credit.gt;
                            number = number.substring(1);
                        } else if (number.startsWith("=")) {
                            prefix = SectioningStatusFilterAction.Credit.eq;
                            number = number.substring(1);
                        }
                        im = null;
                        try {
                            float a = Float.parseFloat(number);
                            switch (prefix) {
                                case eq: {
                                    min = max = a;
                                    break;
                                }
                                case le: {
                                    max = a;
                                    break;
                                }
                                case ge: {
                                    min = a;
                                    break;
                                }
                                case lt: {
                                    max = a - 1.0f;
                                    break;
                                }
                                case gt: {
                                    min = a + 1.0f;
                                }
                            }
                        }
                        catch (NumberFormatException e) {
                            m = Pattern.compile("([0-9]+\\.?[0-9]*)([^0-9\\.].*)").matcher(number);
                            if (!m.matches()) break block158;
                            float a = Float.parseFloat(m.group(1));
                            im = m.group(2).trim();
                            switch (prefix) {
                                case eq: {
                                    min = max = a;
                                    break;
                                }
                                case le: {
                                    max = a;
                                    break;
                                }
                                case ge: {
                                    min = a;
                                    break;
                                }
                                case lt: {
                                    max = a - 1.0f;
                                    break;
                                }
                                case gt: {
                                    min = a + 1.0f;
                                }
                            }
                        }
                    }
                    if (term.contains("..")) {
                        try {
                            String a = term.substring(0, term.indexOf(46));
                            String b = term.substring(term.indexOf("..") + 2);
                            min = Float.parseFloat(a);
                            max = Float.parseFloat(b);
                        }
                        catch (NumberFormatException e) {
                            m = Pattern.compile("([0-9]+\\.?[0-9]*)\\.\\.([0-9]+\\.?[0-9]*)([^0-9].*)").matcher(term);
                            if (!m.matches()) break block159;
                            min = Float.parseFloat(m.group(1));
                            max = Float.parseFloat(m.group(2));
                            im = m.group(3).trim();
                        }
                    }
                }
                float credit = 0.0f;
                HashSet<Long> courseIds = new HashSet<Long>();
                for (StudentClassEnrollment e : this.student().getClassEnrollments()) {
                    if (!courseIds.add(e.getCourseOffering().getUniqueId())) continue;
                    CourseCreditUnitConfig config = e.getCourseOffering().getCredit();
                    if ("!".equals(im) && e.getClazz().getSchedulingSubpart().getInstrOfferingConfig().getInstructionalMethod() != null || im != null && !"!".equals(im) && (e.getClazz().getSchedulingSubpart().getInstrOfferingConfig().getEffectiveInstructionalMethod() == null || !im.equalsIgnoreCase(e.getClazz().getSchedulingSubpart().getInstrOfferingConfig().getEffectiveInstructionalMethod().getReference())) || config == null) continue;
                    credit += config.getMinCredit();
                }
                return min <= credit && credit <= max;
            }
            if ("overlap".equals(attr)) {
                int min = 0;
                int max = Integer.MAX_VALUE;
                SectioningStatusFilterAction.Credit prefix = SectioningStatusFilterAction.Credit.eq;
                String number = term;
                if (number.startsWith("<=")) {
                    prefix = SectioningStatusFilterAction.Credit.le;
                    number = number.substring(2);
                } else if (number.startsWith(">=")) {
                    prefix = SectioningStatusFilterAction.Credit.ge;
                    number = number.substring(2);
                } else if (number.startsWith("<")) {
                    prefix = SectioningStatusFilterAction.Credit.lt;
                    number = number.substring(1);
                } else if (number.startsWith(">")) {
                    prefix = SectioningStatusFilterAction.Credit.gt;
                    number = number.substring(1);
                } else if (number.startsWith("=")) {
                    prefix = SectioningStatusFilterAction.Credit.eq;
                    number = number.substring(1);
                }
                try {
                    int a = Integer.parseInt(number);
                    switch (prefix) {
                        case eq: {
                            min = max = a;
                            break;
                        }
                        case le: {
                            max = a;
                            break;
                        }
                        case ge: {
                            min = a;
                            break;
                        }
                        case lt: {
                            max = a - 1;
                            break;
                        }
                        case gt: {
                            min = a + 1;
                        }
                    }
                }
                catch (NumberFormatException a) {
                    // empty catch block
                }
                if (term.contains("..")) {
                    try {
                        String a = term.substring(0, term.indexOf(46));
                        String b = term.substring(term.indexOf("..") + 2);
                        min = Integer.parseInt(a);
                        max = Integer.parseInt(b);
                    }
                    catch (NumberFormatException a) {
                        // empty catch block
                    }
                }
                int share = 0;
                for (StudentClassEnrollment section : this.student().getClassEnrollments()) {
                    Assignment assignment = section.getClazz().getCommittedAssignment();
                    if (assignment == null) continue;
                    for (StudentClassEnrollment otherSection : this.student().getClassEnrollments()) {
                        Assignment otherAssignment;
                        if (section.equals(otherSection) || (otherAssignment = otherSection.getClazz().getCommittedAssignment()) == null || !assignment.getTimeLocation().hasIntersection(otherAssignment.getTimeLocation()) || section.getClazz().isToIgnoreStudentConflictsWith(otherSection.getClazz()) || section.getClazz().getUniqueId() >= otherSection.getClazz().getUniqueId()) continue;
                        int sh = assignment.getTimeLocation().nrSharedDays(otherAssignment.getTimeLocation()) * assignment.getTimeLocation().nrSharedHours(otherAssignment.getTimeLocation()) * Constants.SLOT_LENGTH_MIN;
                        share += sh;
                    }
                }
                return min <= share && share <= max;
            }
            if ("override".equals(attr)) {
                if ("null".equalsIgnoreCase(term) || "None".equalsIgnoreCase(term)) {
                    return this.request().getOverrideStatus() == null;
                }
                CourseRequest.CourseRequestOverrideStatus status = null;
                for (CourseRequest.CourseRequestOverrideStatus s : CourseRequest.CourseRequestOverrideStatus.values()) {
                    if (!s.name().equalsIgnoreCase(term)) continue;
                    status = s;
                    break;
                }
                if (status == null) {
                    return false;
                }
                if (this.request().getOverrideStatus() != null && this.request().getOverrideStatus().intValue() == status.ordinal()) {
                    return true;
                }
                return false;
            }
            if ("prefer".equals(attr)) {
                if (this.eq("Any Preference", term)) {
                    return !this.request().getPreferences().isEmpty();
                }
                if (this.eq("Met Preference", term) || this.eq("Unmet Preference", term)) {
                    if (this.enrollment() == null || this.enrollment().isEmpty()) {
                        if (this.eq("Unmet Preference", term)) {
                            return !this.request().getPreferences().isEmpty();
                        }
                        return false;
                    }
                    boolean hasPref = false;
                    boolean hasIm = false;
                    boolean im = false;
                    HashSet<String> allSubpart = new HashSet<String>();
                    HashSet<String> selectedSubparts = new HashSet<String>();
                    for (StudentSectioningPref p : this.request().getPreferences()) {
                        hasPref = true;
                        if (p instanceof StudentInstrMthPref) {
                            hasIm = true;
                            StudentInstrMthPref imp = (StudentInstrMthPref)p;
                            InstructionalMethod method = this.enrollment().get(0).getClazz().getSchedulingSubpart().getInstrOfferingConfig().getEffectiveInstructionalMethod();
                            if (method != null && method.equals(imp.getInstructionalMethod())) {
                                im = true;
                            }
                        }
                        if (!(p instanceof StudentClassPref)) continue;
                        StudentClassPref scp = (StudentClassPref)p;
                        allSubpart.add(scp.getClazz().getSchedulingSubpart().getItypeDesc());
                        for (StudentClassEnrollment section : this.enrollment()) {
                            if (!scp.getClazz().equals(section.getClazz())) continue;
                            selectedSubparts.add(scp.getClazz().getSchedulingSubpart().getItypeDesc());
                        }
                    }
                    if (this.eq("Met Preference", term)) {
                        return hasPref && hasIm == im && selectedSubparts.size() == allSubpart.size();
                    }
                    return hasPref && (hasIm != im || selectedSubparts.size() != allSubpart.size());
                }
                for (StudentSectioningPref p : this.request().getPreferences()) {
                    if (!this.eq(p.getLabel(), term)) continue;
                    return true;
                }
                return false;
            }
            if ("require".equals(attr)) {
                if (this.eq("Any Requirement", term)) {
                    for (StudentSectioningPref p : this.request().getPreferences()) {
                        if (!p.isRequired().booleanValue()) continue;
                        return true;
                    }
                    return false;
                }
                if (this.eq("Met Requirement", term)) {
                    if (this.enrollment() == null || this.enrollment().isEmpty()) {
                        return false;
                    }
                    boolean hasPref = false;
                    boolean hasIm = false;
                    boolean im = false;
                    HashSet<String> allSubpart = new HashSet<String>();
                    HashSet<String> selectedSubparts = new HashSet<String>();
                    for (StudentSectioningPref p : this.request().getPreferences()) {
                        if (!p.isRequired().booleanValue()) continue;
                        hasPref = true;
                        if (p instanceof StudentInstrMthPref) {
                            hasIm = true;
                            StudentInstrMthPref imp = (StudentInstrMthPref)p;
                            InstructionalMethod method = this.enrollment().get(0).getClazz().getSchedulingSubpart().getInstrOfferingConfig().getEffectiveInstructionalMethod();
                            if (method != null && method.equals(imp.getInstructionalMethod())) {
                                im = true;
                            }
                        }
                        if (!(p instanceof StudentClassPref)) continue;
                        StudentClassPref scp = (StudentClassPref)p;
                        allSubpart.add(scp.getClazz().getSchedulingSubpart().getItypeDesc());
                        for (StudentClassEnrollment section : this.enrollment()) {
                            if (!scp.getClazz().equals(section.getClazz())) continue;
                            selectedSubparts.add(scp.getClazz().getSchedulingSubpart().getItypeDesc());
                        }
                    }
                    return hasPref && hasIm == im && selectedSubparts.size() == allSubpart.size();
                }
                if (this.eq("Unmet Requirement", term)) {
                    if (this.enrollment() != null) {
                        return false;
                    }
                    for (StudentSectioningPref p : this.request().getPreferences()) {
                        if (!p.isRequired().booleanValue()) continue;
                        return true;
                    }
                    return false;
                }
                for (StudentSectioningPref p : this.request().getPreferences()) {
                    if (!p.isRequired().booleanValue() || !this.eq(p.getLabel(), term)) continue;
                    return true;
                }
                return false;
            }
            if (!this.enrollment().isEmpty()) {
                for (StudentClassEnrollment e : this.enrollment()) {
                    int start;
                    int start2;
                    int end;
                    Assignment assignment;
                    if ((attr == null || attr.equals("crn") || attr.equals("id") || attr.equals("externalId") || attr.equals("exid") || attr.equals("name")) && e.getClazz().getClassSuffix(e.getCourseOffering()).toLowerCase().startsWith(term.toLowerCase())) {
                        return true;
                    }
                    if (attr == null || attr.equals("day")) {
                        int day;
                        Assignment assignment2 = e.getClazz().getCommittedAssignment();
                        if (assignment2 == null && term.equalsIgnoreCase("none")) {
                            return true;
                        }
                        if (assignment2 != null && (day = this.parseDay(term)) > 0 && (assignment2.getDays() & day) == day) {
                            return true;
                        }
                    }
                    if (attr == null || attr.equals("time")) {
                        int start3;
                        Assignment assignment3 = e.getClazz().getCommittedAssignment();
                        if (assignment3 == null && term.equalsIgnoreCase("none")) {
                            return true;
                        }
                        if (assignment3 != null && (start3 = this.parseStart(term)) >= 0 && assignment3.getStartSlot() == start3) {
                            return true;
                        }
                    }
                    if (attr != null && attr.equals("before") && (assignment = e.getClazz().getCommittedAssignment()) != null && (end = this.parseStart(term)) >= 0 && assignment.getStartSlot() + assignment.getSlotPerMtg() - assignment.getBreakTime() / 5 <= end) {
                        return true;
                    }
                    if (attr != null && attr.equals("after") && (assignment = e.getClazz().getCommittedAssignment()) != null && (start2 = this.parseStart(term)) >= 0 && assignment.getStartSlot() >= start2) {
                        return true;
                    }
                    if (attr == null || attr.equals("date")) {
                        ClassEvent event = e.getClazz().getEvent();
                        if (event == null && term.equalsIgnoreCase("none")) {
                            return true;
                        }
                        if (event != null) {
                            Formats.Format<Date> df = Formats.getDateFormat(Formats.Pattern.DATE_PATTERN);
                            for (Meeting m : event.getMeetings()) {
                                if (!this.eq(df.format(m.getMeetingDate()), term)) continue;
                                return true;
                            }
                        }
                    }
                    if (attr == null || attr.equals("room")) {
                        assignment = e.getClazz().getCommittedAssignment();
                        if ((assignment == null || assignment.getRooms().isEmpty()) && term.equalsIgnoreCase("none")) {
                            return true;
                        }
                        if (assignment != null) {
                            for (Location room : assignment.getRooms()) {
                                if (!this.has(room.getLabel(), term)) continue;
                                return true;
                            }
                        }
                    }
                    if (attr == null || attr.equals("instr") || attr.equals("instructor")) {
                        if (attr != null && e.getClazz().getClassInstructors().isEmpty() && term.equalsIgnoreCase("none")) {
                            return true;
                        }
                        for (ClassInstructor instuctor : e.getClazz().getClassInstructors()) {
                            if (this.has(this.iFormat.format(instuctor.getInstructor()), term) || this.eq(instuctor.getInstructor().getExternalUniqueId(), term)) {
                                return true;
                            }
                            if (instuctor.getInstructor().getEmail() == null) continue;
                            String email = instuctor.getInstructor().getEmail();
                            if (email.indexOf(64) >= 0) {
                                email = email.substring(0, email.indexOf(64));
                            }
                            if (!this.eq(email, term)) continue;
                            return true;
                        }
                    }
                    if (attr == null || (start = this.parseStart(attr + ":" + term)) < 0 || e.getClazz().getCommittedAssignment() == null || e.getClazz().getCommittedAssignment().getStartSlot() != start) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean eq(String name, String term) {
            if (name == null) {
                return false;
            }
            return name.equalsIgnoreCase(term);
        }

        private boolean has(String name, String term) {
            if (name == null) {
                return false;
            }
            if (this.eq(name, term)) {
                return true;
            }
            for (String t : name.split(" |,")) {
                if (!t.equalsIgnoreCase(term)) continue;
                return true;
            }
            return false;
        }

        private int parseDay(String token) {
            int days = 0;
            boolean found = false;
            do {
                int i;
                found = false;
                for (i = 0; i < CONSTANTS.longDays().length; ++i) {
                    if (!token.toLowerCase().startsWith(CONSTANTS.longDays()[i].toLowerCase())) continue;
                    days |= DayCode.values()[i].getCode();
                    token = token.substring(CONSTANTS.longDays()[i].length());
                    while (token.startsWith(" ")) {
                        token = token.substring(1);
                    }
                    found = true;
                }
                for (i = 0; i < CONSTANTS.days().length; ++i) {
                    if (!token.toLowerCase().startsWith(CONSTANTS.days()[i].toLowerCase())) continue;
                    days |= DayCode.values()[i].getCode();
                    token = token.substring(CONSTANTS.days()[i].length());
                    while (token.startsWith(" ")) {
                        token = token.substring(1);
                    }
                    found = true;
                }
                for (i = 0; i < CONSTANTS.days().length; ++i) {
                    if (!token.toLowerCase().startsWith(CONSTANTS.days()[i].substring(0, 2).toLowerCase())) continue;
                    days |= DayCode.values()[i].getCode();
                    token = token.substring(2);
                    while (token.startsWith(" ")) {
                        token = token.substring(1);
                    }
                    found = true;
                }
                for (i = 0; i < CONSTANTS.shortDays().length; ++i) {
                    if (!token.toLowerCase().startsWith(CONSTANTS.shortDays()[i].toLowerCase())) continue;
                    days |= DayCode.values()[i].getCode();
                    token = token.substring(CONSTANTS.shortDays()[i].length());
                    while (token.startsWith(" ")) {
                        token = token.substring(1);
                    }
                    found = true;
                }
                for (i = 0; i < CONSTANTS.freeTimeShortDays().length; ++i) {
                    if (!token.toLowerCase().startsWith(CONSTANTS.freeTimeShortDays()[i].toLowerCase())) continue;
                    days |= DayCode.values()[i].getCode();
                    token = token.substring(CONSTANTS.freeTimeShortDays()[i].length());
                    while (token.startsWith(" ")) {
                        token = token.substring(1);
                    }
                    found = true;
                }
            } while (found);
            return token.isEmpty() ? days : 0;
        }

        private int parseStart(String token) {
            int startHour = 0;
            int startMin = 0;
            String number = "";
            while (!token.isEmpty() && token.charAt(0) >= '0' && token.charAt(0) <= '9') {
                number = number + token.substring(0, 1);
                token = token.substring(1);
            }
            if (number.isEmpty()) {
                return -1;
            }
            if (number.length() > 2) {
                startHour = Integer.parseInt(number) / 100;
                startMin = Integer.parseInt(number) % 100;
            } else {
                startHour = Integer.parseInt(number);
            }
            while (token.startsWith(" ")) {
                token = token.substring(1);
            }
            if (token.startsWith(":")) {
                token = token.substring(1);
                while (token.startsWith(" ")) {
                    token = token.substring(1);
                }
                number = "";
                while (!token.isEmpty() && token.charAt(0) >= '0' && token.charAt(0) <= '9') {
                    number = number + token.substring(0, 1);
                    token = token.substring(1);
                }
                if (number.isEmpty()) {
                    return -1;
                }
                startMin = Integer.parseInt(number);
            }
            while (token.startsWith(" ")) {
                token = token.substring(1);
            }
            boolean hasAmOrPm = false;
            if (token.toLowerCase().startsWith("am")) {
                token = token.substring(2);
                hasAmOrPm = true;
            }
            if (token.toLowerCase().startsWith("a")) {
                token = token.substring(1);
                hasAmOrPm = true;
            }
            if (token.toLowerCase().startsWith("pm")) {
                token = token.substring(2);
                hasAmOrPm = true;
                if (startHour < 12) {
                    startHour += 12;
                }
            }
            if (token.toLowerCase().startsWith("p")) {
                token = token.substring(1);
                hasAmOrPm = true;
                if (startHour < 12) {
                    startHour += 12;
                }
            }
            if (startHour < 7 && !hasAmOrPm) {
                startHour += 12;
            }
            if (startMin % 5 != 0) {
                startMin = 5 * ((startMin + 2) / 5);
            }
            if (startHour == 7 && startMin == 0 && !hasAmOrPm) {
                startHour += 12;
            }
            return (60 * startHour + startMin) / 5;
        }
    }

    public static class DbCourseInfoMatcher
    implements Query.AmbigousTermMatcher,
    Serializable {
        private static final long serialVersionUID = 1L;
        private CourseOffering iCourse;
        private boolean iConsentToDoCourse;
        private StatusPageSuggestionsAction.CourseLookup iLookup;

        public DbCourseInfoMatcher(CourseOffering course, boolean isConsentToDoCourse, StatusPageSuggestionsAction.CourseLookup lookup) {
            this.iCourse = course;
            this.iConsentToDoCourse = isConsentToDoCourse;
            this.iLookup = lookup;
        }

        public CourseOffering course() {
            return this.iCourse;
        }

        public boolean isConsentToDoCourse() {
            return this.iConsentToDoCourse;
        }

        @Override
        public Boolean match(String attr, String term) {
            if (term.isEmpty()) {
                return true;
            }
            if ("limit".equals(attr)) {
                return true;
            }
            if ("lookup".equals(attr)) {
                Set<Long> courseIds = this.iLookup.getCourses(term);
                return courseIds != null && courseIds.contains(this.course().getUniqueId());
            }
            if (attr == null || "name".equals(attr) || "course".equals(attr)) {
                return this.course().getSubjectAreaAbbv().equalsIgnoreCase(term) || this.course().getCourseNbr().equalsIgnoreCase(term) || (this.course().getSubjectAreaAbbv() + " " + this.course().getCourseNbr()).equalsIgnoreCase(term);
            }
            if (attr == null && term.length() > 2 || "title".equals(attr)) {
                return (this.course().getTitle() == null ? "" : this.course().getTitle()).toLowerCase().contains(term.toLowerCase());
            }
            if (attr == null || "subject".equals(attr)) {
                return this.course().getSubjectAreaAbbv().equalsIgnoreCase(term);
            }
            if (attr == null || "number".equals(attr)) {
                return this.course().getCourseNbr().equalsIgnoreCase(term);
            }
            if ("department".equals(attr)) {
                return (this.course().getSubjectArea().getDepartment().getDeptCode() == null ? this.course().getSubjectArea().getDepartment().getAbbreviation() : this.course().getSubjectArea().getDepartment().getDeptCode()).equalsIgnoreCase(term);
            }
            if ("consent".equals(attr)) {
                if ("none".equalsIgnoreCase(term) || "No Consent".equalsIgnoreCase(term)) {
                    return this.course().getConsentType() == null;
                }
                if ("todo".equalsIgnoreCase(term) || "To Do".equalsIgnoreCase(term)) {
                    return this.isConsentToDoCourse();
                }
                return this.course().getConsentType() != null;
            }
            if ("mode".equals(attr)) {
                return true;
            }
            if ("registered".equals(attr)) {
                if ("true".equalsIgnoreCase(term) || "1".equalsIgnoreCase(term)) {
                    return true;
                }
                return false;
            }
            return null;
        }
    }

    public static class DbFindEnrollmentInfoCourseMatcher
    extends FindEnrollmentInfoAction.FindEnrollmentInfoCourseMatcher {
        private static final long serialVersionUID = 1L;

        public DbFindEnrollmentInfoCourseMatcher(Set<Long> coursesIcoordinate, Set<Long> coursesIcanApprove, Set<String> subjects, Query query, StatusPageSuggestionsAction.CourseLookup lookup) {
            super(coursesIcoordinate, coursesIcanApprove, subjects, query, lookup);
        }

        public boolean isConsentToDoCourse(CourseOffering co) {
            return this.iCoursesIcanApprove != null && co.getConsentType() != null && this.iCoursesIcanApprove.contains(co.getUniqueId());
        }

        public boolean match(CourseOffering co) {
            return co != null && this.isCourseVisible(co.getUniqueId()) && this.hasMatchingSubjectArea(co.getSubjectAreaAbbv()) && this.iQuery.match(new DbCourseInfoMatcher(co, this.isConsentToDoCourse(co), this.iLookup));
        }
    }
}

