/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.status;

import com.google.protobuf.InvalidProtocolBufferException;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.gwt.server.Query;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.OnlineSectioningLog;
import org.unitime.timetable.model.StudentGroupType;
import org.unitime.timetable.model.dao.StudentGroupTypeDAO;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.CustomCourseLookupHolder;
import org.unitime.timetable.onlinesectioning.model.XAreaClassificationMajor;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XStudentId;
import org.unitime.timetable.util.Constants;

public class FindOnlineSectioningLogAction
implements OnlineSectioningAction<List<ClassAssignmentInterface.SectioningAction>> {
    private static final long serialVersionUID = 1L;
    protected static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    protected static StudentSectioningConstants CONST = Localization.create(StudentSectioningConstants.class);
    private Query iQuery;
    private Integer iLimit = 100;
    protected boolean iCanShowExtIds = false;

    public FindOnlineSectioningLogAction forQuery(String query, boolean canShowExtIds) {
        this.iQuery = new Query(query.isEmpty() ? "limit:100" : query);
        Matcher m = Pattern.compile("limit:[ ]?([0-9]*)", 2).matcher(query);
        if (m.find()) {
            this.iLimit = Integer.parseInt(m.group(1));
        }
        this.iCanShowExtIds = canShowExtIds;
        return this;
    }

    public Query getQuery() {
        return this.iQuery;
    }

    public Integer getLimit() {
        return this.iLimit;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<ClassAssignmentInterface.SectioningAction> execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        helper.beginTransaction();
        try {
            ArrayList<ClassAssignmentInterface.SectioningAction> ret = new ArrayList<ClassAssignmentInterface.SectioningAction>();
            DateFormat df = Localization.getDateFormat(CONST.timeStampFormat());
            NumberFormat nf = Localization.getNumberFormat(CONST.executionTimeFormat());
            AcademicSessionInfo session = server.getAcademicSession();
            SectioningLogQueryFormatter formatter = new SectioningLogQueryFormatter(session, helper);
            String join = "";
            for (String t : formatter.getGroupTypes()) {
                if (!this.getQuery().hasAttribute(t)) continue;
                join = join + "left outer join s.groups G_" + t + " ";
            }
            org.hibernate.Query q = helper.getHibSession().createQuery("select l, s.uniqueId from OnlineSectioningLog l, Student s " + (this.getQuery().hasAttribute("area", "clasf", "classification", "major") ? "left outer join s.areaClasfMajors m " : "") + (this.getQuery().hasAttribute("minor") ? "left outer join s.areaClasfMinors n " : "") + (this.getQuery().hasAttribute("group") ? "left outer join s.groups g " : "") + (this.getQuery().hasAttribute("accommodation") ? "left outer join s.accomodations a " : "") + (this.getQuery().hasAttribute("course") || this.getQuery().hasAttribute("lookup") ? "left outer join s.courseDemands cd left outer join cd.courseRequests cr " : "") + join + "where l.session.uniqueId = :sessionId and l.session = s.session and l.student = s.externalUniqueId and (" + this.getQuery().toString(formatter) + ") " + (this.getQuery().hasAttribute("operation") ? "" : "and (l.result is not null or l.operation not in ('reload-offering', 'check-offering', 'reload-student')) and (l.result != 3 or l.operation not in ('validate-overrides', 'critical-courses', 'banner-update')) ") + "order by l.uniqueId desc");
            q.setLong("sessionId", session.getUniqueId().longValue());
            if (this.getLimit() != null) {
                q.setMaxResults(this.getLimit().intValue());
            }
            HashSet<Long> processedLogIds = new HashSet<Long>();
            for (Object[] o : q.list()) {
                try {
                    OnlineSectioningLog.Property p;
                    Iterator<OnlineSectioningLog.Property> s;
                    OnlineSectioningLog log = (OnlineSectioningLog)o[0];
                    XStudent student = server.getStudent((Long)o[1]);
                    if (student == null || !processedLogIds.add(log.getUniqueId())) continue;
                    ClassAssignmentInterface.Student st = new ClassAssignmentInterface.Student();
                    st.setId(student.getStudentId());
                    st.setSessionId(session.getUniqueId());
                    st.setExternalId(student.getExternalId());
                    st.setCanShowExternalId(this.iCanShowExtIds);
                    st.setName(student.getName());
                    for (XAreaClassificationMajor acm : student.getMajors()) {
                        st.addArea(acm.getArea());
                        st.addClassification(acm.getClassification());
                        st.addMajor(acm.getMajor());
                    }
                    for (String acc : student.getAccomodations()) {
                        st.addAccommodation(acc);
                    }
                    for (XStudent.XGroup gr : student.getGroups()) {
                        st.addGroup(gr.getType(), gr.getAbbreviation(), gr.getTitle());
                    }
                    for (XStudent.XAdvisor a : student.getAdvisors()) {
                        if (a.getName() == null) continue;
                        st.addAdvisor(a.getName());
                    }
                    ClassAssignmentInterface.SectioningAction a = new ClassAssignmentInterface.SectioningAction();
                    a.setStudent(st);
                    a.setTimeStamp(log.getTimeStamp());
                    a.setOperation(Constants.toInitialCase(log.getOperation().replace('-', ' ')));
                    OnlineSectioningLog.Action action = OnlineSectioningLog.Action.parseFrom(log.getAction());
                    if (action.hasCpuTime()) {
                        a.setCpuTime(action.getCpuTime());
                    }
                    if (action.hasStartTime() && action.hasEndTime()) {
                        a.setWallTime(action.getEndTime() - action.getStartTime());
                    }
                    if (action.hasUser()) {
                        a.setUser(action.getUser().getName());
                    }
                    if (action.hasResult()) {
                        a.setResult(Constants.toInitialCase(action.getResult().name()));
                    }
                    String html = "<table class='unitime-ChangeLog'>";
                    html = html + "<tr><td class='unitime-MainTableHeader' colspan='2'>General</td></tr>";
                    html = html + "<tr><td><b>" + MSG.colOperation() + ":</b></td><td>" + Constants.toInitialCase(log.getOperation().replace('-', ' ')) + "</td></tr>";
                    if (action.hasResult()) {
                        html = html + "<tr><td><b>" + MSG.colResult() + ":</b></td><td>" + Constants.toInitialCase(action.getResult().name()) + "</td></tr>";
                    }
                    if (action.hasStudent() && (s = server.getStudent(action.getStudent().getUniqueId())) != null) {
                        html = html + "<tr><td><b>" + MSG.colStudent() + ":</b></td><td>" + ((XStudentId)((Object)s)).getName() + "</td></tr>";
                    }
                    for (OnlineSectioningLog.Entity other : action.getOtherList()) {
                        html = html + "<tr><td><b>" + Constants.toInitialCase(other.getType().name()) + ":</b></td><td>" + other.getName() + "</td></tr>";
                    }
                    html = html + "<tr><td><b>Time Stamp:</b></td><td>" + df.format(log.getTimeStamp()) + "</td></tr>";
                    s = action.getOptionList().iterator();
                    while (s.hasNext()) {
                        p = s.next();
                        if ("student-email".equals(log.getOperation()) && p.getKey().equalsIgnoreCase("email")) continue;
                        html = html + "<tr><td><b>" + Constants.toInitialCase(p.getKey()) + ":</b></td><td><div class='property'>" + (p.hasValue() ? p.getValue() : "") + "</div></td></tr>";
                    }
                    if (action.hasCpuTime()) {
                        html = html + "<tr><td><b>" + MSG.colCpuTime() + ":</b></td><td>" + nf.format(1.0E-9 * (double)action.getCpuTime()) + "</td></tr>";
                    }
                    if (action.hasStartTime() && action.hasEndTime()) {
                        html = html + "<tr><td nowrap><b>" + MSG.colWallTime() + ":</b></td><td>" + nf.format(0.001 * (double)(action.getEndTime() - action.getStartTime())) + "</td></tr>";
                    }
                    if (action.hasApiGetTime()) {
                        html = html + "<tr><td nowrap><b>" + MSG.colApiGetTime() + ":</b></td><td>" + nf.format(0.001 * (double)action.getApiGetTime()) + "</td></tr>";
                    }
                    if (action.hasApiPostTime()) {
                        html = html + "<tr><td nowrap><b>" + MSG.colApiPostTime() + ":</b></td><td>" + nf.format(0.001 * (double)action.getApiPostTime()) + "</td></tr>";
                    }
                    if (action.hasApiException()) {
                        html = html + "<tr><td nowrap><b>" + MSG.colApiException() + ":</b></td><td>" + action.getApiException() + "</td></tr>";
                    }
                    if ("student-email".equals(log.getOperation())) {
                        s = action.getOptionList().iterator();
                        while (s.hasNext()) {
                            p = s.next();
                            if (!"email".equals(p.getKey()) || !p.hasValue()) continue;
                            html = html + "<tr><td class='unitime-MainTableHeader' colspan='2'>Email</td></tr>";
                            html = html + "<tr><td colspan='2'>" + p.getValue() + "</td></tr>";
                        }
                    }
                    if (!action.getRequestList().isEmpty()) {
                        html = html + "<tr><td class='unitime-MainTableHeader' colspan='2'>" + MSG.courseRequestsCourses() + "</td></tr>";
                        html = html + "<tr><td colspan='2'><table cellspacing='0' cellpadding='2'><td class='unitime-TableHeader'>" + MSG.colPriority() + "</td><td class='unitime-TableHeader'>" + MSG.colCourse() + "</td><td class='unitime-TableHeader'>" + MSG.colPreferences() + "</td></tr>";
                    }
                    String request = "";
                    String selected = "";
                    int notAlt = 0;
                    int lastFT = -1;
                    for (OnlineSectioningLog.Request r : action.getRequestList()) {
                        if (!r.getAlternative()) {
                            notAlt = r.getPriority() + 1;
                        }
                        int idx = 0;
                        for (OnlineSectioningLog.Time time : r.getFreeTimeList()) {
                            if (idx == 0) {
                                html = html + (r.getPriority() > 0 && lastFT != r.getPriority() ? "<tr><td class='top-border-dashed'>" : "<tr><td>") + (lastFT == r.getPriority() ? "" : (!r.getAlternative() ? MSG.courseRequestsPriority(1 + r.getPriority()) : MSG.courseRequestsAlternative(1 + r.getPriority() - notAlt))) + "</td>";
                                html = html + (r.getPriority() > 0 && lastFT != r.getPriority() ? "<td class='top-border-dashed' colspan='2'>" : "<td colspan='2'>") + CONST.freePrefix() + " ";
                                request = request + (lastFT == r.getPriority() ? ", " : (request.isEmpty() ? "" : "<br>") + (r.getAlternative() ? "A" + (1 + r.getPriority() - notAlt) : String.valueOf(1 + r.getPriority())) + ". " + CONST.freePrefix() + " ");
                            } else {
                                html = html + ", ";
                                request = request + ", ";
                            }
                            ++idx;
                            html = html + DayCode.toString(time.getDays()) + " " + this.time(time.getStart()) + " - " + this.time(time.getStart() + time.getLength());
                            request = request + DayCode.toString(time.getDays()) + " " + this.time(time.getStart()) + " - " + this.time(time.getStart() + time.getLength());
                            html = html + "</td></tr>";
                            lastFT = r.getPriority();
                        }
                        if (r.getFreeTimeList().isEmpty()) {
                            for (OnlineSectioningLog.Entity entity : r.getCourseList()) {
                                if (idx == 0) {
                                    html = html + (r.getPriority() > 0 ? "<tr><td class='top-border-dashed'>" : "<tr><td>") + (!r.getAlternative() ? MSG.courseRequestsPriority(1 + r.getPriority()) : MSG.courseRequestsAlternative(1 + r.getPriority() - notAlt)) + "</td>";
                                    html = html + (r.getPriority() > 0 ? "<td class='top-border-dashed'>" : "<td>");
                                    request = request + (request.isEmpty() ? "" : "<br>") + (r.getAlternative() ? "A" + (1 + r.getPriority() - notAlt) : String.valueOf(1 + r.getPriority())) + ". ";
                                } else {
                                    html = html + "<tr><td></td><td>";
                                    request = request + ", ";
                                }
                                html = html + entity.getName();
                                request = request + entity.getName();
                                html = html + (r.getPriority() > 0 && ++idx == 1 ? "</td><td class='top-border-dashed'>" : "</td><td>");
                                for (int i = 0; i < entity.getParameterCount(); ++i) {
                                    html = html + (i > 0 ? ", " : "") + entity.getParameter(i).getValue();
                                }
                                html = html + "</td></tr>";
                            }
                        }
                        for (OnlineSectioningLog.Section section : r.getSectionList()) {
                            if (section.getPreference() != OnlineSectioningLog.Section.Preference.SELECTED) continue;
                            if (!selected.isEmpty()) {
                                selected = selected + "<br>";
                            }
                            String loc = "";
                            for (OnlineSectioningLog.Entity entity : section.getLocationList()) {
                                if (!loc.isEmpty()) {
                                    loc = loc + ", ";
                                }
                                loc = loc + entity.getName();
                            }
                            String instr = "";
                            for (OnlineSectioningLog.Entity e4 : section.getInstructorList()) {
                                if (!instr.isEmpty()) {
                                    instr = instr + ", ";
                                }
                                instr = instr + e4.getName();
                            }
                            selected = selected + section.getCourse().getName() + " " + section.getSubpart().getName() + " " + section.getClazz().getName() + " " + (section.hasTime() ? DayCode.toString(section.getTime().getDays()) + " " + this.time(section.getTime().getStart()) + " - " + this.time(section.getTime().getStart() + section.getTime().getLength()) : "") + " " + loc;
                        }
                    }
                    if (!action.getRequestList().isEmpty()) {
                        html = html + "</table></td></tr>";
                    }
                    String enrollment = "";
                    HashMap<OnlineSectioningLog.Enrollment.EnrollmentType, String> enrollmentByType = new HashMap<OnlineSectioningLog.Enrollment.EnrollmentType, String>();
                    for (OnlineSectioningLog.Enrollment e5 : action.getEnrollmentList()) {
                        enrollment = "";
                        html = html + "<tr><td class='unitime-MainTableHeader' colspan='2'>" + (e5.hasType() ? Constants.toInitialCase(e5.getType().name()) + " " : "") + MSG.enrollmentsTable() + "</td></tr>";
                        html = html + "<tr><td colspan='2'><table cellspacing='0' cellpadding='2'><td class='unitime-TableHeader'>" + MSG.colCourse() + "</td><td class='unitime-TableHeader'>" + MSG.colSubject() + "</td><td class='unitime-TableHeader'>" + MSG.colClass() + "</td><td class='unitime-TableHeader'>" + MSG.colDays() + "</td><td class='unitime-TableHeader'>" + MSG.colStart() + "</td><td class='unitime-TableHeader'>" + MSG.colEnd() + "</td><td class='unitime-TableHeader'>" + MSG.colDate() + "</td><td class='unitime-TableHeader'>" + MSG.colRoom() + "</td><td class='unitime-TableHeader'>" + MSG.colInstructor() + "</td></tr>";
                        for (OnlineSectioningLog.Section s3 : e5.getSectionList()) {
                            void var30_46;
                            if (!s3.hasCourse()) continue;
                            if (!enrollment.isEmpty()) {
                                enrollment = enrollment + "<br>";
                            }
                            String loc = "";
                            for (OnlineSectioningLog.Entity r : s3.getLocationList()) {
                                if (!loc.isEmpty()) {
                                    loc = loc + ", ";
                                }
                                loc = loc + r.getName();
                            }
                            String string = "";
                            for (OnlineSectioningLog.Entity r : s3.getInstructorList()) {
                                void var30_48;
                                if (!var30_46.isEmpty()) {
                                    String string2 = (String)var30_46 + ", ";
                                }
                                String string3 = (String)var30_48 + r.getName();
                            }
                            html = html + "<tr><td>" + s3.getCourse().getName() + "</td><td>" + s3.getSubpart().getName() + "</td><td>" + s3.getClazz().getName() + "</td><td>" + (s3.hasTime() ? DayCode.toString(s3.getTime().getDays()) : "") + "</td><td>" + (s3.hasTime() ? this.time(s3.getTime().getStart()) : "") + "</td><td>" + (s3.hasTime() ? this.time(s3.getTime().getStart() + s3.getTime().getLength()) : "") + "</td><td>" + (s3.hasTime() && s3.getTime().hasPattern() ? s3.getTime().getPattern() : "") + "</td><td>" + loc + "</td><td>" + (String)var30_46 + "</td></tr>";
                            enrollment = enrollment + s3.getCourse().getName() + " " + s3.getSubpart().getName() + " " + s3.getClazz().getName() + " " + (s3.hasTime() ? DayCode.toString(s3.getTime().getDays()) + " " + this.time(s3.getTime().getStart()) : "") + " " + loc;
                        }
                        html = html + "</table></td></tr>";
                        enrollmentByType.put(e5.getType(), enrollment);
                    }
                    String message = "";
                    if (!action.getMessageList().isEmpty()) {
                        html = html + "<tr><td class='unitime-MainTableHeader' colspan='2'>" + MSG.tableMessages() + "</td></tr>";
                        for (OnlineSectioningLog.Message message2 : action.getMessageList()) {
                            if (message2.hasText()) {
                                html = html + "<tr><td><b>" + message2.getLevel().name() + ":</b></td><td>" + message2.getText() + "</td></tr>";
                                message = message2.getText();
                            }
                            if (!message2.hasException()) continue;
                            html = html + "<tr><td><b>Exception:</b></td><td>" + message2.getException() + "</td></tr>";
                            message = message2.getException();
                        }
                    }
                    html = html + "<tr><td class='unitime-MainTableHeader' colspan='2'>" + MSG.tableProto() + "</td></tr>";
                    html = html + "<tr><td colspan='2' class='proto'>" + action.toString().replace("<", "&lt;").replace(">", "&gt;").replace(" ", "&nbsp;").replace("\n", "<br>") + "</td></tr>";
                    html = html + "</table>";
                    if (action.hasResult() && OnlineSectioningLog.Action.ResultType.FAILURE.equals((Object)action.getResult()) && !message.isEmpty()) {
                        a.setMessage(message);
                    } else if ("suggestions".equals(log.getOperation())) {
                        a.setMessage(selected.isEmpty() ? message : selected);
                    } else if ("section".equals(log.getOperation())) {
                        a.setMessage(request.isEmpty() ? message : request);
                    } else if (enrollmentByType.containsKey((Object)OnlineSectioningLog.Enrollment.EnrollmentType.REQUESTED)) {
                        a.setMessage((String)enrollmentByType.get((Object)OnlineSectioningLog.Enrollment.EnrollmentType.REQUESTED));
                    } else {
                        a.setMessage(enrollment.isEmpty() ? (request.isEmpty() ? message : request) : enrollment);
                    }
                    a.setProto(html);
                    ret.add(a);
                }
                catch (InvalidProtocolBufferException invalidProtocolBufferException) {}
            }
            helper.commitTransaction();
            Collections.sort(ret);
            return ret;
        }
        catch (Exception e) {
            helper.rollbackTransaction();
            if (e instanceof SectioningException) {
                throw (SectioningException)e;
            }
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
    }

    protected String time(int slot) {
        int h = slot / 12;
        int m = 5 * (slot % 12);
        if (CONST.useAmPm()) {
            return (h > 12 ? h - 12 : h) + ":" + (m < 10 ? "0" : "") + m + (h == 24 ? "a" : (h >= 12 ? "p" : "a"));
        }
        return h + ":" + (m < 10 ? "0" : "") + m;
    }

    @Override
    public String name() {
        return "sectioning-log";
    }

    public static class SectioningLogQueryFormatter
    implements Query.QueryFormatter {
        Set<String> iGroupTypes = new HashSet<String>();
        AcademicSessionInfo iSession = null;
        OnlineSectioningHelper iHelper = null;

        public SectioningLogQueryFormatter(AcademicSessionInfo session, OnlineSectioningHelper helper) {
            this.iSession = session;
            this.iHelper = helper;
            for (StudentGroupType type : StudentGroupTypeDAO.getInstance().findAll(helper.getHibSession())) {
                this.iGroupTypes.add(type.getReference().replace(' ', '_').toLowerCase());
            }
        }

        @Override
        public String format(String attr, String body) {
            if (body != null && !body.isEmpty()) {
                body = StringEscapeUtils.escapeSql((String)body);
            }
            if ("id".equalsIgnoreCase(attr) || "student".equalsIgnoreCase(attr)) {
                if (ApplicationProperty.DataExchangeTrimLeadingZerosFromExternalIds.isTrue() && body.startsWith("0")) {
                    return "s.externalUniqueId = '" + body.replaceFirst("^0+(?!$)", "") + "'";
                }
                return "s.externalUniqueId = '" + body + "'";
            }
            if ("advisor".equalsIgnoreCase(attr)) {
                if (ApplicationProperty.DataExchangeTrimLeadingZerosFromExternalIds.isTrue() && body.startsWith("0")) {
                    return "s.uniqueId in (select ads.uniqueId from Advisor adv inner join adv.students ads where adv.externalUniqueId = '" + body.replaceFirst("^0+(?!$)", "") + "' and adv.session.uniqueId = s.session.uniqueId)";
                }
                return "s.uniqueId in (select ads.uniqueId from Advisor adv inner join adv.students ads where adv.externalUniqueId = '" + body + "' and adv.session.uniqueId = s.session.uniqueId)";
            }
            if ("operation".equalsIgnoreCase(attr) || "op".equalsIgnoreCase(attr)) {
                return "lower(l.operation) = '" + body.toLowerCase() + "'";
            }
            if ("max-age".equalsIgnoreCase(attr) || "age".equalsIgnoreCase(attr)) {
                return HibernateUtil.addDate("l.timeStamp", body) + " > current_date()";
            }
            if ("limit".equalsIgnoreCase(attr)) {
                return "1 = 1";
            }
            if ("area".equalsIgnoreCase(attr)) {
                return "lower(m.academicArea.academicAreaAbbreviation) = '" + body.toLowerCase() + "'";
            }
            if ("clasf".equalsIgnoreCase(attr) || "classification".equalsIgnoreCase(attr)) {
                return "lower(m.academicClassification.code) = '" + body.toLowerCase() + "'";
            }
            if ("major".equalsIgnoreCase(attr)) {
                return "lower(m.major.code) = '" + body.toLowerCase() + "'";
            }
            if ("minor".equalsIgnoreCase(attr)) {
                return "lower(n.minor.code) = '" + body.toLowerCase() + "'";
            }
            if ("group".equalsIgnoreCase(attr)) {
                return "lower(g.groupAbbreviation) = '" + body.toLowerCase() + "'";
            }
            if (attr != null && this.iGroupTypes.contains(attr.toLowerCase())) {
                return "lower(G_" + attr + ".groupAbbreviation) = '" + body.toLowerCase() + "'";
            }
            if ("accommodation".equalsIgnoreCase(attr)) {
                return "lower(a.abbreviation) = '" + body.toLowerCase() + "'";
            }
            if ("user".equalsIgnoreCase(attr)) {
                return "none".equalsIgnoreCase(body) ? "l.user is null" : "l.user = '" + body + "'";
            }
            if ("result".equalsIgnoreCase(attr)) {
                for (OnlineSectioningLog.Action.ResultType t : OnlineSectioningLog.Action.ResultType.values()) {
                    if (!t.name().equalsIgnoreCase(body)) continue;
                    return "l.result = " + t.getNumber();
                }
                if ("none".equalsIgnoreCase(body) || "unknown".equalsIgnoreCase(body)) {
                    return "l.result is null";
                }
                return "1 = 1";
            }
            if ("status".equalsIgnoreCase(attr)) {
                if ("Not Set".equalsIgnoreCase(body)) {
                    return "s.sectioningStatus is null";
                }
                return "lower(s.sectioningStatus.reference) = '" + body.toLowerCase() + "'";
            }
            if ("over".equalsIgnoreCase(attr)) {
                try {
                    return "l.wallTime >= " + 1000 * Integer.parseInt(body.trim());
                }
                catch (Exception e) {
                    return "1 = 1";
                }
            }
            if ("under".equalsIgnoreCase(attr)) {
                try {
                    return "l.wallTime <= " + 1000 * Integer.parseInt(body.trim());
                }
                catch (Exception e) {
                    return "1 = 1";
                }
            }
            if ("api".equalsIgnoreCase(attr)) {
                try {
                    return "l.apiGetTime >= " + 1000 * Integer.parseInt(body.trim()) + "or l.apiPostTime >= " + 1000 * Integer.parseInt(body.trim()) + " or (l.apiGetTime + l.apiPostTime) >= " + 1000 * Integer.parseInt(body.trim());
                }
                catch (Exception e) {
                    return "l.apiException like '%" + body + "%'";
                }
            }
            if ("message".equalsIgnoreCase(attr)) {
                return "l.message like '%" + body + "%' or l.apiException like '%" + body + "%'";
            }
            if ("get".equalsIgnoreCase(attr)) {
                try {
                    return "l.apiGetTime >= " + 1000 * Integer.parseInt(body.trim());
                }
                catch (Exception e) {
                    return "1 = 1";
                }
            }
            if ("post".equalsIgnoreCase(attr)) {
                try {
                    return "l.apiPostTime >= " + 1000 * Integer.parseInt(body.trim());
                }
                catch (Exception e) {
                    return "1 = 1";
                }
            }
            if ("course".equalsIgnoreCase(attr)) {
                return "cr.courseOffering.subjectAreaAbbv = '" + body + "' or (cr.courseOffering.subjectAreaAbbv || ' ' || cr.courseOffering.courseNbr) = '" + body + "'";
            }
            if ("lookup".equalsIgnoreCase(attr)) {
                Set<Long> courseIds;
                if (CustomCourseLookupHolder.hasProvider() && (courseIds = CustomCourseLookupHolder.getProvider().getCourseIds(this.iSession, this.iHelper.getHibSession(), body, true)) != null && !courseIds.isEmpty()) {
                    String ret = "";
                    for (Long courseId : courseIds) {
                        ret = ret + (ret.isEmpty() ? "" : ",") + courseId;
                    }
                    return "cr.courseOffering.uniqueId in (" + ret + ")";
                }
                return "1 = 1";
            }
            if (attr == null && !body.isEmpty()) {
                return "lower(s.firstName || ' ' || s.middleName || ' ' || s.lastName) like '%" + body.toLowerCase() + "%'";
            }
            return "1 = 1";
        }

        public Collection<String> getGroupTypes() {
            return this.iGroupTypes;
        }
    }
}

