/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.status;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.AssignmentMap;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.util.DistanceMetric;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.online.expectations.OverExpectedCriterion;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.client.sectioning.SectioningStatusFilterBox;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.gwt.server.Query;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.model.FixedCreditUnitConfig;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.StudentSectioningStatusDAO;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.model.XAreaClassificationMajor;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XEnrollments;
import org.unitime.timetable.onlinesectioning.model.XExpectations;
import org.unitime.timetable.onlinesectioning.model.XInstructor;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XRoom;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XStudentId;
import org.unitime.timetable.onlinesectioning.model.XSubpart;
import org.unitime.timetable.onlinesectioning.solver.SectioningRequest;
import org.unitime.timetable.onlinesectioning.status.SectioningStatusFilterAction;
import org.unitime.timetable.onlinesectioning.status.StatusPageSuggestionsAction;
import org.unitime.timetable.solver.studentsct.StudentSolver;

public class FindEnrollmentAction
implements OnlineSectioningAction<List<ClassAssignmentInterface.Enrollment>> {
    private static final long serialVersionUID = 1L;
    protected static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    protected Query iQuery;
    protected Long iCourseId;
    protected Long iClassId;
    protected boolean iConsentToDoCourse;
    protected boolean iCanShowExtIds = false;
    protected boolean iCanRegister = false;
    protected boolean iCanUseAssistant = false;
    protected Set<Long> iMyStudents;
    protected boolean iIsAdmin = false;
    protected boolean iIsAdvisor = false;
    protected boolean iCanEditMyStudents = false;
    protected boolean iCanEditOtherStudents = false;
    protected SectioningStatusFilterBox.SectioningStatusFilterRpcRequest iFilter = null;

    public FindEnrollmentAction withParams(String query, Long courseId, Long classId, boolean isConsentToDoCourse, boolean canShowExtIds, boolean canRegister, boolean canUseAssistant, Set<Long> myStudents) {
        this.iQuery = new Query(query);
        this.iCourseId = courseId;
        this.iClassId = classId;
        this.iConsentToDoCourse = isConsentToDoCourse;
        this.iCanShowExtIds = canShowExtIds;
        this.iCanRegister = canRegister;
        this.iCanUseAssistant = canUseAssistant;
        this.iMyStudents = myStudents;
        return this;
    }

    public FindEnrollmentAction withPermissions(boolean isAdmin, boolean isAdvisor, boolean canEditMyStudents, boolean canEditOtherStudents) {
        this.iIsAdmin = isAdmin;
        this.iIsAdvisor = isAdvisor;
        this.iCanEditMyStudents = canEditMyStudents;
        this.iCanEditOtherStudents = canEditOtherStudents;
        return this;
    }

    public FindEnrollmentAction withFilter(SectioningStatusFilterBox.SectioningStatusFilterRpcRequest filter) {
        this.iFilter = filter;
        return this;
    }

    public Query query() {
        return this.iQuery;
    }

    public Long courseId() {
        return this.iCourseId;
    }

    public Long classId() {
        return this.iClassId;
    }

    public boolean isConsentToDoCourse() {
        return this.iConsentToDoCourse;
    }

    public boolean isMyStudent(XStudentId student) {
        return this.iMyStudents != null && this.iMyStudents.contains(student.getStudentId());
    }

    public boolean isCanSelect(XStudentId student) {
        if (this.iIsAdmin) {
            return true;
        }
        return this.iIsAdvisor && (this.iCanEditOtherStudents || this.iCanEditMyStudents && this.isMyStudent(student));
    }

    @Override
    public List<ClassAssignmentInterface.Enrollment> execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        ArrayList<ClassAssignmentInterface.Enrollment> ret = new ArrayList<ClassAssignmentInterface.Enrollment>();
        XCourse course = server.getCourse(this.courseId());
        if (course == null) {
            return ret;
        }
        XOffering offering = server.getOffering(course.getOfferingId());
        if (offering == null) {
            return ret;
        }
        XEnrollments enrollments = server.getEnrollments(course.getOfferingId());
        DistanceMetric m = server.getDistanceMetric();
        XExpectations expectations = server.getExpectations(offering.getOfferingId());
        OverExpectedCriterion overExp = server.getOverExpectedCriterion();
        AcademicSessionInfo session = server.getAcademicSession();
        StatusPageSuggestionsAction.CourseLookup lookup = new StatusPageSuggestionsAction.CourseLookup(session);
        boolean solver = server instanceof StudentSolver;
        Set<Long> studentIds = null;
        if (!solver) {
            studentIds = this.iFilter == null ? null : server.createAction(SectioningStatusFilterAction.class).forRequest(this.iFilter).getStudentIds(server, helper);
        }
        HashSet<String> regStates = new HashSet<String>();
        HashSet<String> assStates = new HashSet<String>();
        Session dbSession = (Session)SessionDAO.getInstance().get(session.getUniqueId());
        for (StudentSectioningStatus status : StudentSectioningStatusDAO.getInstance().findAll(helper.getHibSession())) {
            if (StudentSectioningStatus.hasEffectiveOption(status, dbSession, StudentSectioningStatus.Option.enabled) || this.iIsAdmin && StudentSectioningStatus.hasEffectiveOption(status, dbSession, StudentSectioningStatus.Option.admin) || this.iIsAdvisor && StudentSectioningStatus.hasEffectiveOption(status, dbSession, StudentSectioningStatus.Option.advisor)) {
                assStates.add(status.getReference());
            }
            if (!StudentSectioningStatus.hasEffectiveOption(status, dbSession, StudentSectioningStatus.Option.regenabled) && (!this.iIsAdmin || !StudentSectioningStatus.hasEffectiveOption(status, dbSession, StudentSectioningStatus.Option.regadmin)) && (!this.iIsAdvisor || !StudentSectioningStatus.hasEffectiveOption(status, dbSession, StudentSectioningStatus.Option.regadvisor))) continue;
            regStates.add(status.getReference());
        }
        for (XCourseRequest request : enrollments.getRequests()) {
            XStudent student;
            if (request.getEnrollment() != null && !request.getEnrollment().getCourseId().equals(this.courseId()) || this.classId() != null && request.getEnrollment() != null && !request.getEnrollment().getSectionIds().contains(this.classId()) || request.getEnrollment() == null && !request.getCourseIds().contains(course) || studentIds != null && !studentIds.contains(request.getStudentId()) || (student = server.getStudent(request.getStudentId())) == null || request.getEnrollment() == null && !student.canAssign(request) || !this.query().match(new StatusPageSuggestionsAction.CourseRequestMatcher(session, course, student, offering, request, this.isConsentToDoCourse(), this.isMyStudent(student), lookup, server))) continue;
            if (this.classId() != null && request.getEnrollment() == null) {
                boolean hasEnrollment = false;
                AssignmentMap assignment = new AssignmentMap();
                CourseRequest r = SectioningRequest.convert((Assignment<Request, Enrollment>)assignment, request, server);
                Section s = r.getSection(this.classId().longValue());
                block9: for (Enrollment en : r.values((Assignment)assignment)) {
                    if (!en.getSections().contains(s)) continue;
                    for (Object x : r.getStudent().getRequests()) {
                        Enrollment xe = (Enrollment)assignment.getValue((Variable)x);
                        if (x.equals((Object)r) || xe == null || !xe.isOverlapping(en)) continue;
                        continue block9;
                    }
                    hasEnrollment = true;
                    break;
                }
                if (!hasEnrollment) continue;
            }
            ClassAssignmentInterface.Student st = new ClassAssignmentInterface.Student();
            st.setId(student.getStudentId());
            st.setSessionId(session.getUniqueId());
            st.setExternalId(student.getExternalId());
            st.setCanShowExternalId(this.iCanShowExtIds);
            String status = student.getStatus() == null ? session.getDefaultSectioningStatus() : student.getStatus();
            st.setCanRegister(this.iCanRegister && (status == null || regStates.contains(status)));
            st.setCanUseAssistant(this.iCanUseAssistant && (status == null || assStates.contains(status)));
            st.setCanSelect(this.isCanSelect(student));
            st.setName(student.getName());
            for (XAreaClassificationMajor acm : student.getMajors()) {
                st.addArea(acm.getArea());
                st.addClassification(acm.getClassification());
                st.addMajor(acm.getMajor());
            }
            for (XStudent.XGroup gr : student.getGroups()) {
                st.addGroup(gr.getType(), gr.getAbbreviation(), gr.getTitle());
            }
            for (String acc : student.getAccomodations()) {
                st.addAccommodation(acc);
            }
            for (XStudent.XAdvisor a : student.getAdvisors()) {
                if (a.getName() == null) continue;
                st.addAdvisor(a.getName());
            }
            ClassAssignmentInterface.Enrollment e = new ClassAssignmentInterface.Enrollment();
            e.setStudent(st);
            e.setPriority(1 + request.getPriority());
            ClassAssignmentInterface.CourseAssignment c = new ClassAssignmentInterface.CourseAssignment();
            c.setCourseId(course.getCourseId());
            c.setSubject(course.getSubjectArea());
            c.setCourseNbr(course.getCourseNumber());
            c.setTitle(course.getTitle());
            c.setHasCrossList(offering.hasCrossList());
            e.setCourse(c);
            e.setWaitList(request.isWaitlist());
            if (request.getEnrollment() == null) {
                e.setEnrollmentMessage(request.getEnrollmentMessage());
            }
            if (!request.getCourseIds().get(0).equals(course)) {
                e.setAlternative(request.getCourseIds().get(0).getCourseName());
            }
            if (request.isAlternative()) {
                for (XRequest r : student.getRequests()) {
                    if (!(r instanceof XCourseRequest) || r.isAlternative() || ((XCourseRequest)r).getEnrollment() != null) continue;
                    e.setAlternative(((XCourseRequest)r).getCourseIds().get(0).getCourseName());
                }
            }
            if (request.getTimeStamp() != null) {
                e.setRequestedDate(request.getTimeStamp());
            }
            if (request.getEnrollment() != null) {
                if (request.getEnrollment().getReservation() != null) {
                    switch (request.getEnrollment().getReservation().getType()) {
                        case Individual: {
                            e.setReservation(MSG.reservationIndividual());
                            break;
                        }
                        case Group: {
                            e.setReservation(MSG.reservationGroup());
                            break;
                        }
                        case Course: {
                            e.setReservation(MSG.reservationCourse());
                            break;
                        }
                        case Curriculum: {
                            e.setReservation(MSG.reservationCurriculum());
                            break;
                        }
                        case LearningCommunity: {
                            e.setReservation(MSG.reservationLearningCommunity());
                        }
                    }
                }
                if (request.getEnrollment().getTimeStamp() != null) {
                    e.setEnrolledDate(request.getEnrollment().getTimeStamp());
                }
                if (request.getEnrollment().getApproval() != null) {
                    e.setApprovedDate(request.getEnrollment().getApproval().getTimeStamp());
                    e.setApprovedBy(request.getEnrollment().getApproval().getName());
                }
                for (XSection section : offering.getSections(request.getEnrollment())) {
                    Object x;
                    ClassAssignmentInterface.ClassAssignment a = e.getCourse().addClassAssignment();
                    a.setAlternative(request.isAlternative());
                    a.setClassId(section.getSectionId());
                    a.setSubpart(section.getSubpartName());
                    a.setSection(section.getName(course.getCourseId()));
                    a.setExternalId(section.getExternalId(course.getCourseId()));
                    a.setClassNumber(section.getName(-1L));
                    a.setCancelled(section.isCancelled());
                    a.setLimit(new int[]{enrollments.countEnrollmentsForSection(section.getSectionId()), section.getLimit()});
                    if (section.getTime() != null) {
                        x = DayCode.toDayCodes(section.getTime().getDays()).iterator();
                        while (x.hasNext()) {
                            DayCode d = (DayCode)((Object)x.next());
                            a.addDay(d.getIndex());
                        }
                        a.setStart(section.getTime().getSlot());
                        a.setLength(section.getTime().getLength());
                        a.setBreakTime(section.getTime().getBreakTime());
                        a.setDatePattern(section.getTime().getDatePatternName());
                    }
                    if (section.getNrRooms() > 0) {
                        x = section.getRooms().iterator();
                        while (x.hasNext()) {
                            XRoom rm = (XRoom)x.next();
                            a.addRoom(rm.getUniqueId(), rm.getName());
                        }
                    }
                    if (section.getInstructors() != null) {
                        x = section.getInstructors().iterator();
                        while (x.hasNext()) {
                            XInstructor instructor = (XInstructor)x.next();
                            a.addInstructor(instructor.getName());
                            a.addInstructoEmail(instructor.getEmail());
                        }
                    }
                    if (section.getParentId() != null) {
                        a.setParentSection(offering.getSection(section.getParentId()).getName(course.getCourseId()));
                    }
                    a.setSubpartId(section.getSubpartId());
                    a.addNote(course.getNote());
                    a.addNote(section.getNote());
                    XSubpart subpart = offering.getSubpart(section.getSubpartId());
                    a.setCredit(subpart.getCredit(course.getCourseId()));
                    Float creditOverride = section.getCreditOverride(c.getCourseId());
                    if (creditOverride != null) {
                        a.setCredit(FixedCreditUnitConfig.formatCredit(creditOverride.floatValue()));
                    }
                    int dist = 0;
                    String from = null;
                    TreeSet<String> overlap = new TreeSet<String>();
                    for (XRequest q : student.getRequests()) {
                        XEnrollment otherEnrollment;
                        if (!(q instanceof XCourseRequest) || (otherEnrollment = ((XCourseRequest)q).getEnrollment()) == null) continue;
                        XOffering otherOffering = server.getOffering(otherEnrollment.getOfferingId());
                        for (XSection otherSection : otherOffering.getSections(otherEnrollment)) {
                            if (otherSection.equals(section) || otherSection.getTime() == null) continue;
                            int d = otherSection.getDistanceInMinutes(section, m);
                            if (d > dist) {
                                dist = d;
                                from = "";
                                Iterator<XRoom> k = otherSection.getRooms().iterator();
                                while (k.hasNext()) {
                                    from = from + k.next().getName() + (k.hasNext() ? ", " : "");
                                }
                            }
                            if (otherSection.isDistanceConflict(student, section, m)) {
                                a.setDistanceConflict(true);
                            }
                            if (section.getTime() == null || !section.getTime().hasIntersection(otherSection.getTime()) || section.isToIgnoreStudentConflictsWith(offering.getDistributions(), otherSection.getSectionId())) continue;
                            XCourse otherCourse = otherOffering.getCourse(otherEnrollment.getCourseId());
                            XSubpart otherSubpart = otherOffering.getSubpart(otherSection.getSubpartId());
                            overlap.add(MSG.clazz(otherCourse.getSubjectArea(), otherCourse.getCourseNumber(), otherSubpart.getName(), otherSection.getName(otherCourse.getCourseId())));
                        }
                    }
                    if (!overlap.isEmpty()) {
                        String note = null;
                        Iterator j = overlap.iterator();
                        while (j.hasNext()) {
                            String n = (String)j.next();
                            if (note == null) {
                                note = MSG.noteAllowedOverlapFirst(n);
                                continue;
                            }
                            if (j.hasNext()) {
                                note = note + MSG.noteAllowedOverlapMiddle(n);
                                continue;
                            }
                            note = note + MSG.noteAllowedOverlapLast(n);
                        }
                        a.setOverlapNote(note);
                    }
                    a.setBackToBackDistance(dist);
                    a.setBackToBackRooms(from);
                    a.setSaved(true);
                    if (a.getParentSection() == null) {
                        a.setParentSection(course.getConsentLabel());
                    }
                    a.setExpected(overExp.getExpected(section.getLimit(), expectations.getExpectedSpace(section.getSectionId()).doubleValue()));
                }
            }
            ret.add(e);
        }
        return ret;
    }

    @Override
    public String name() {
        return "find-enrollments";
    }
}

