/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.solver;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.Instructor;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.online.selection.SuggestionsBranchAndBound;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.gwt.server.Query;
import org.unitime.timetable.util.Formats;

public class SuggestionsFilter
implements SuggestionsBranchAndBound.SuggestionFilter {
    private static StudentSectioningConstants CONSTANTS = Localization.create(StudentSectioningConstants.class);
    private Query iFilter = null;
    private Date iFirstDate = null;

    public SuggestionsFilter(String filter, Date firstDate) {
        this.iFilter = new Query(filter);
        this.iFirstDate = firstDate;
    }

    public boolean match(Course course, Section section) {
        return this.iFilter.match(new SectionMatcher(course, section));
    }

    private class SectionMatcher
    implements Query.TermMatcher {
        private Course iCourse;
        private Section iSection;

        public SectionMatcher(Course course, Section section) {
            this.iCourse = course;
            this.iSection = section;
        }

        @Override
        public boolean match(String attr, String term) {
            int end;
            int start;
            if (term.isEmpty()) {
                return true;
            }
            if ((attr == null || attr.equals("crn") || attr.equals("id") || attr.equals("externalId") || attr.equals("exid") || attr.equals("name")) && this.iSection.getName(this.iCourse.getId()) != null && this.iSection.getName(this.iCourse.getId()).toLowerCase().startsWith(term.toLowerCase())) {
                return true;
            }
            if ((attr == null || attr.equals("course")) && this.iCourse.getName().toLowerCase().startsWith(term.toLowerCase())) {
                return true;
            }
            if (attr == null || attr.equals("day")) {
                int day;
                if (this.iSection.getTime() == null && term.equalsIgnoreCase("none")) {
                    return true;
                }
                if (this.iSection.getTime() != null && (day = this.parseDay(term)) > 0 && (this.iSection.getTime().getDayCode() & day) == day) {
                    return true;
                }
            }
            if (attr == null || attr.equals("time")) {
                if (this.iSection.getTime() == null && term.equalsIgnoreCase("none")) {
                    return true;
                }
                if (this.iSection.getTime() != null && (start = this.parseStart(term)) >= 0 && this.iSection.getTime().getStartSlot() == start) {
                    return true;
                }
            }
            if (attr != null && attr.equals("before") && this.iSection.getTime() != null && (end = this.parseStart(term)) >= 0 && this.iSection.getTime().getStartSlot() + this.iSection.getTime().getLength() - this.iSection.getTime().getBreakTime() / 5 <= end) {
                return true;
            }
            if (attr != null && attr.equals("after") && this.iSection.getTime() != null && (start = this.parseStart(term)) >= 0 && this.iSection.getTime().getStartSlot() >= start) {
                return true;
            }
            if (attr == null || attr.equals("date")) {
                if (this.iSection.getTime() == null && term.equalsIgnoreCase("none")) {
                    return true;
                }
                if (this.iSection.getTime() != null && !this.iSection.getTime().getWeekCode().isEmpty()) {
                    Formats.Format<Date> df = Formats.getDateFormat(Formats.Pattern.DATE_PATTERN);
                    Calendar cal = Calendar.getInstance(Locale.US);
                    cal.setLenient(true);
                    cal.setTime(SuggestionsFilter.this.iFirstDate);
                    for (int i = 0; i < this.iSection.getTime().getWeekCode().size(); ++i) {
                        if (this.iSection.getTime().getWeekCode().get(i)) {
                            DayCode day = null;
                            switch (cal.get(7)) {
                                case 2: {
                                    day = DayCode.MON;
                                    break;
                                }
                                case 3: {
                                    day = DayCode.TUE;
                                    break;
                                }
                                case 4: {
                                    day = DayCode.WED;
                                    break;
                                }
                                case 5: {
                                    day = DayCode.THU;
                                    break;
                                }
                                case 6: {
                                    day = DayCode.FRI;
                                    break;
                                }
                                case 7: {
                                    day = DayCode.SAT;
                                    break;
                                }
                                case 1: {
                                    day = DayCode.SUN;
                                }
                            }
                            if ((this.iSection.getTime().getDayCode() & day.getCode()) == day.getCode()) {
                                int d = cal.get(5);
                                int m = cal.get(2) + 1;
                                if (df.format(cal.getTime()).equalsIgnoreCase(term) || this.eq(d + "." + m + ".", term) || this.eq(m + "/" + d, term)) {
                                    return true;
                                }
                            }
                        }
                        cal.add(6, 1);
                    }
                }
            }
            if (attr == null || attr.equals("room")) {
                if ((this.iSection.getRooms() == null || this.iSection.getRooms().isEmpty()) && term.equalsIgnoreCase("none")) {
                    return true;
                }
                if (this.iSection.getRooms() != null) {
                    for (RoomLocation r : this.iSection.getRooms()) {
                        if (!this.has(r.getName(), term)) continue;
                        return true;
                    }
                }
            }
            if (attr == null || attr.equals("instr") || attr.equals("instructor")) {
                if (attr != null && !this.iSection.hasInstructors() && term.equalsIgnoreCase("none")) {
                    return true;
                }
                if (this.iSection.hasInstructors()) {
                    for (Instructor instructor : this.iSection.getInstructors()) {
                        if (this.has(instructor.getName(), term)) {
                            return true;
                        }
                        if (instructor.getEmail() == null) continue;
                        String email = instructor.getEmail();
                        if (email.indexOf(64) >= 0) {
                            email = email.substring(0, email.indexOf(64));
                        }
                        if (!this.eq(email, term)) continue;
                        return true;
                    }
                }
            }
            return attr != null && this.iSection.getTime() != null && (start = this.parseStart(attr + ":" + term)) >= 0 && this.iSection.getTime().getStartSlot() == start;
        }

        private boolean eq(String name, String term) {
            if (name == null) {
                return false;
            }
            return name.equalsIgnoreCase(term);
        }

        private boolean has(String name, String term) {
            if (name == null) {
                return false;
            }
            for (String t : name.split(" ")) {
                if (!t.equalsIgnoreCase(term)) continue;
                return true;
            }
            return false;
        }

        private int parseDay(String token) {
            int days = 0;
            boolean found = false;
            do {
                int i;
                found = false;
                for (i = 0; i < CONSTANTS.longDays().length; ++i) {
                    if (!token.toLowerCase().startsWith(CONSTANTS.longDays()[i].toLowerCase())) continue;
                    days |= DayCode.values()[i].getCode();
                    token = token.substring(CONSTANTS.longDays()[i].length());
                    while (token.startsWith(" ")) {
                        token = token.substring(1);
                    }
                    found = true;
                }
                for (i = 0; i < CONSTANTS.days().length; ++i) {
                    if (!token.toLowerCase().startsWith(CONSTANTS.days()[i].toLowerCase())) continue;
                    days |= DayCode.values()[i].getCode();
                    token = token.substring(CONSTANTS.days()[i].length());
                    while (token.startsWith(" ")) {
                        token = token.substring(1);
                    }
                    found = true;
                }
                for (i = 0; i < CONSTANTS.days().length; ++i) {
                    if (!token.toLowerCase().startsWith(CONSTANTS.days()[i].substring(0, 2).toLowerCase())) continue;
                    days |= DayCode.values()[i].getCode();
                    token = token.substring(2);
                    while (token.startsWith(" ")) {
                        token = token.substring(1);
                    }
                    found = true;
                }
                for (i = 0; i < CONSTANTS.shortDays().length; ++i) {
                    if (!token.toLowerCase().startsWith(CONSTANTS.shortDays()[i].toLowerCase())) continue;
                    days |= DayCode.values()[i].getCode();
                    token = token.substring(CONSTANTS.shortDays()[i].length());
                    while (token.startsWith(" ")) {
                        token = token.substring(1);
                    }
                    found = true;
                }
                for (i = 0; i < CONSTANTS.freeTimeShortDays().length; ++i) {
                    if (!token.toLowerCase().startsWith(CONSTANTS.freeTimeShortDays()[i].toLowerCase())) continue;
                    days |= DayCode.values()[i].getCode();
                    token = token.substring(CONSTANTS.freeTimeShortDays()[i].length());
                    while (token.startsWith(" ")) {
                        token = token.substring(1);
                    }
                    found = true;
                }
            } while (found);
            return token.isEmpty() ? days : 0;
        }

        private int parseStart(String token) {
            int startHour = 0;
            int startMin = 0;
            String number = "";
            while (!token.isEmpty() && token.charAt(0) >= '0' && token.charAt(0) <= '9') {
                number = number + token.substring(0, 1);
                token = token.substring(1);
            }
            if (number.isEmpty()) {
                return -1;
            }
            if (number.length() > 2) {
                startHour = Integer.parseInt(number) / 100;
                startMin = Integer.parseInt(number) % 100;
            } else {
                startHour = Integer.parseInt(number);
            }
            while (token.startsWith(" ")) {
                token = token.substring(1);
            }
            if (token.startsWith(":")) {
                token = token.substring(1);
                while (token.startsWith(" ")) {
                    token = token.substring(1);
                }
                number = "";
                while (!token.isEmpty() && token.charAt(0) >= '0' && token.charAt(0) <= '9') {
                    number = number + token.substring(0, 1);
                    token = token.substring(1);
                }
                if (number.isEmpty()) {
                    return -1;
                }
                startMin = Integer.parseInt(number);
            }
            while (token.startsWith(" ")) {
                token = token.substring(1);
            }
            boolean hasAmOrPm = false;
            if (token.toLowerCase().startsWith("am")) {
                token = token.substring(2);
                hasAmOrPm = true;
            }
            if (token.toLowerCase().startsWith("a")) {
                token = token.substring(1);
                hasAmOrPm = true;
            }
            if (token.toLowerCase().startsWith("pm")) {
                token = token.substring(2);
                hasAmOrPm = true;
                if (startHour < 12) {
                    startHour += 12;
                }
            }
            if (token.toLowerCase().startsWith("p")) {
                token = token.substring(1);
                hasAmOrPm = true;
                if (startHour < 12) {
                    startHour += 12;
                }
            }
            if (startHour < 7 && !hasAmOrPm) {
                startHour += 12;
            }
            if (startMin % 5 != 0) {
                startMin = 5 * ((startMin + 2) / 5);
            }
            if (startHour == 7 && startMin == 0 && !hasAmOrPm) {
                startHour += 12;
            }
            return (60 * startHour + startMin) / 5;
        }
    }
}

