/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.model;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.util.DistanceMetric;
import org.cpsolver.studentsct.constraint.LinkedSections;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.Instructor;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.Subpart;
import org.cpsolver.studentsct.model.Unavailability;
import org.cpsolver.studentsct.online.OnlineConfig;
import org.cpsolver.studentsct.online.OnlineReservation;
import org.cpsolver.studentsct.online.OnlineSection;
import org.cpsolver.studentsct.reservation.DummyReservation;
import org.cpsolver.studentsct.reservation.GroupReservation;
import org.cpsolver.studentsct.reservation.Reservation;
import org.cpsolver.studentsct.reservation.ReservationOverride;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.SerializeWith;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseReservation;
import org.unitime.timetable.model.CurriculumReservation;
import org.unitime.timetable.model.GroupOverrideReservation;
import org.unitime.timetable.model.IndividualOverrideReservation;
import org.unitime.timetable.model.IndividualReservation;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.LearningCommunityReservation;
import org.unitime.timetable.model.OverrideReservation;
import org.unitime.timetable.model.StudentGroupReservation;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.model.XConfig;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XCourseReservation;
import org.unitime.timetable.onlinesectioning.model.XCurriculumReservation;
import org.unitime.timetable.onlinesectioning.model.XDistribution;
import org.unitime.timetable.onlinesectioning.model.XDistributionType;
import org.unitime.timetable.onlinesectioning.model.XDummyReservation;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XEnrollments;
import org.unitime.timetable.onlinesectioning.model.XExpectations;
import org.unitime.timetable.onlinesectioning.model.XGroupReservation;
import org.unitime.timetable.onlinesectioning.model.XIndividualReservation;
import org.unitime.timetable.onlinesectioning.model.XInstructor;
import org.unitime.timetable.onlinesectioning.model.XLearningCommunityReservation;
import org.unitime.timetable.onlinesectioning.model.XReservation;
import org.unitime.timetable.onlinesectioning.model.XReservationId;
import org.unitime.timetable.onlinesectioning.model.XReservationType;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XSubpart;

@SerializeWith(value=XOfferingSerializer.class)
public class XOffering
implements Serializable,
Externalizable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId = null;
    private String iName = null;
    private List<XConfig> iConfigs = new ArrayList<XConfig>();
    private List<XCourse> iCourses = new ArrayList<XCourse>();
    private List<XReservation> iReservations = new ArrayList<XReservation>();
    private List<XDistribution> iDistrubutions = new ArrayList<XDistribution>();

    public XOffering() {
    }

    public XOffering(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal(in);
    }

    public XOffering(InstructionalOffering offering, Collection<XDistribution> distributions, OnlineSectioningHelper helper) {
        this.iUniqueId = offering.getUniqueId();
        this.iName = offering.getCourseName();
        for (CourseOffering course : offering.getCourseOfferings()) {
            if (!course.isAllowStudentScheduling()) continue;
            this.iCourses.add(new XCourse(course, helper));
        }
        for (InstrOfferingConfig config : offering.getInstrOfferingConfigs()) {
            this.iConfigs.add(new XConfig(config, helper));
        }
        for (org.unitime.timetable.model.Reservation reservation : offering.getReservations()) {
            if (reservation instanceof OverrideReservation) {
                this.iReservations.add(new XIndividualReservation(this, (OverrideReservation)reservation));
                continue;
            }
            if (reservation instanceof IndividualOverrideReservation) {
                this.iReservations.add(new XIndividualReservation(this, (IndividualOverrideReservation)reservation));
                continue;
            }
            if (reservation instanceof IndividualReservation) {
                this.iReservations.add(new XIndividualReservation(this, (IndividualReservation)reservation));
                continue;
            }
            if (reservation instanceof GroupOverrideReservation) {
                this.iReservations.add(new XGroupReservation(this, (GroupOverrideReservation)reservation));
                continue;
            }
            if (reservation instanceof LearningCommunityReservation) {
                this.iReservations.add(new XLearningCommunityReservation(this, (LearningCommunityReservation)reservation));
                continue;
            }
            if (reservation instanceof StudentGroupReservation) {
                this.iReservations.add(new XGroupReservation(this, (StudentGroupReservation)reservation));
                continue;
            }
            if (reservation instanceof CurriculumReservation) {
                this.iReservations.add(new XCurriculumReservation(this, (CurriculumReservation)reservation));
                continue;
            }
            if (!(reservation instanceof CourseReservation)) continue;
            this.iReservations.add(new XCourseReservation(this, (CourseReservation)reservation));
        }
        if (offering.isByReservationOnly().booleanValue()) {
            this.iReservations.add(new XDummyReservation(this));
        }
        if (distributions != null) {
            this.iDistrubutions.addAll(distributions);
        }
        Collections.sort(this.iConfigs);
    }

    public XOffering(Offering offering, Collection<LinkedSections> links) {
        this.iUniqueId = offering.getId();
        this.iName = offering.getName();
        for (Course course : offering.getCourses()) {
            this.iCourses.add(new XCourse(course));
        }
        for (Config config : offering.getConfigs()) {
            this.iConfigs.add(new XConfig(config));
        }
        for (Reservation reservation : offering.getReservations()) {
            if (reservation instanceof ReservationOverride) {
                this.iReservations.add(new XIndividualReservation((ReservationOverride)reservation));
                continue;
            }
            if (reservation instanceof org.cpsolver.studentsct.reservation.LearningCommunityReservation) {
                this.iReservations.add(new XLearningCommunityReservation((org.cpsolver.studentsct.reservation.LearningCommunityReservation)reservation));
                continue;
            }
            if (reservation instanceof GroupReservation) {
                this.iReservations.add(new XIndividualReservation((GroupReservation)reservation));
                continue;
            }
            if (reservation instanceof org.cpsolver.studentsct.reservation.IndividualReservation) {
                this.iReservations.add(new XIndividualReservation((org.cpsolver.studentsct.reservation.IndividualReservation)reservation));
                continue;
            }
            if (reservation instanceof org.cpsolver.studentsct.reservation.CurriculumReservation) {
                this.iReservations.add(new XCurriculumReservation((org.cpsolver.studentsct.reservation.CurriculumReservation)reservation));
                continue;
            }
            if (reservation instanceof org.cpsolver.studentsct.reservation.CourseReservation) {
                this.iReservations.add(new XCourseReservation((org.cpsolver.studentsct.reservation.CourseReservation)reservation));
                continue;
            }
            if (!(reservation instanceof DummyReservation)) continue;
            this.iReservations.add(new XDummyReservation(this));
        }
        HashSet<HashSet<Long>> ignConf = new HashSet<HashSet<Long>>();
        long id = 1L;
        if (links != null) {
            for (LinkedSections link : links) {
                if (!link.getOfferings().contains(offering)) continue;
                this.iDistrubutions.add(new XDistribution(link, id++));
            }
        }
        for (Config config : offering.getConfigs()) {
            for (Subpart subpart : config.getSubparts()) {
                for (Section section : subpart.getSections()) {
                    if (section.getIgnoreConflictWithSectionIds() == null) continue;
                    HashSet<Long> ids = new HashSet<Long>(section.getIgnoreConflictWithSectionIds());
                    ids.add(section.getId());
                    if (ids.size() <= 1 || ignConf.add(ids)) continue;
                    this.iDistrubutions.add(new XDistribution(XDistributionType.IngoreConflicts, (Long)id++, offering.getId(), ids));
                }
            }
        }
    }

    public Long getOfferingId() {
        return this.iUniqueId;
    }

    public String getName() {
        return this.iName;
    }

    public List<XConfig> getConfigs() {
        return this.iConfigs;
    }

    public List<XCourse> getCourses() {
        return this.iCourses;
    }

    public boolean hasCrossList() {
        return this.iCourses.size() > 1;
    }

    public XCourse getControllingCourse() {
        for (XCourse course : this.getCourses()) {
            if (!course.isControlling()) continue;
            return course;
        }
        return this.getCourses().isEmpty() ? null : this.getCourses().get(0);
    }

    public XCourse getCourse(Long courseId) {
        if (courseId == null) {
            for (XCourse course : this.getCourses()) {
                if (!course.getCourseName().equals(this.getName())) continue;
                return course;
            }
            return this.getCourses().get(0);
        }
        for (XCourse course : this.getCourses()) {
            if (!course.getCourseId().equals(courseId)) continue;
            return course;
        }
        return null;
    }

    public XCourse getCourse(XCourseId courseId) {
        for (XCourse course : this.getCourses()) {
            if (!course.getCourseId().equals(courseId.getCourseId())) continue;
            return course;
        }
        return null;
    }

    public List<XSection> getSections(XEnrollment enrollment) {
        if (enrollment == null) {
            return null;
        }
        ArrayList<XSection> sections = new ArrayList<XSection>();
        for (XConfig config : this.getConfigs()) {
            for (XSubpart subpart : config.getSubparts()) {
                for (XSection section : subpart.getSections()) {
                    if (!enrollment.getSectionIds().contains(section.getSectionId())) continue;
                    sections.add(section);
                }
            }
        }
        return sections;
    }

    public XSection getSection(Long sectionId) {
        if (sectionId == null) {
            return null;
        }
        for (XConfig config : this.getConfigs()) {
            for (XSubpart subpart : config.getSubparts()) {
                for (XSection section : subpart.getSections()) {
                    if (!section.getSectionId().equals(sectionId)) continue;
                    return section;
                }
            }
        }
        return null;
    }

    public List<XSection> getSections(Long courseId, String externalId) {
        ArrayList<XSection> ret = new ArrayList<XSection>();
        for (XConfig config : this.getConfigs()) {
            for (XSubpart subpart : config.getSubparts()) {
                for (XSection section : subpart.getSections()) {
                    if (!externalId.equals(section.getExternalId(courseId))) continue;
                    ret.add(section);
                }
            }
        }
        return ret;
    }

    public XSubpart getSubpart(Long subpartId) {
        if (subpartId == null) {
            return null;
        }
        for (XConfig config : this.getConfigs()) {
            for (XSubpart subpart : config.getSubparts()) {
                if (!subpart.getSubpartId().equals(subpartId)) continue;
                return subpart;
            }
        }
        return null;
    }

    public XConfig getConfig(Long configId) {
        if (configId == null) {
            return null;
        }
        for (XConfig config : this.getConfigs()) {
            if (!config.getConfigId().equals(configId)) continue;
            return config;
        }
        return null;
    }

    public Set<String> getInstructionalTypes() {
        HashSet<String> instructionalTypes = new HashSet<String>();
        for (XConfig config : this.getConfigs()) {
            for (XSubpart subpart : config.getSubparts()) {
                instructionalTypes.add(subpart.getInstructionalType());
            }
        }
        return instructionalTypes;
    }

    public Set<XSubpart> getSubparts(String instructionalType) {
        HashSet<XSubpart> subparts = new HashSet<XSubpart>();
        for (XConfig config : this.getConfigs()) {
            for (XSubpart subpart : config.getSubparts()) {
                if (!instructionalType.equals(subpart.getInstructionalType())) continue;
                subparts.add(subpart);
            }
        }
        return subparts;
    }

    public String toString() {
        return this.iName;
    }

    public List<XReservation> getReservations() {
        return this.iReservations;
    }

    public List<XReservation> getSectionReservations(Long sectionId) {
        ArrayList<XReservation> ret = new ArrayList<XReservation>();
        for (XReservation reservation : this.iReservations) {
            for (Set<Long> sectionIds : reservation.getSections().values()) {
                if (!sectionIds.contains(sectionId)) continue;
                ret.add(reservation);
            }
        }
        return ret;
    }

    public List<XReservation> getConfigReservations(Long configId) {
        ArrayList<XReservation> ret = new ArrayList<XReservation>();
        for (XReservation reservation : this.iReservations) {
            if (!reservation.getConfigsIds().contains(configId)) continue;
            ret.add(reservation);
        }
        return ret;
    }

    public int getUnreservedSectionSpace(Long sectionId, XEnrollments enrollments) {
        XSection section = this.getSection(sectionId);
        if (section.getLimit() < 0) {
            for (XReservation r : this.getSectionReservations(sectionId)) {
                if (r.isExpired() || !r.hasSectionRestriction(sectionId) || r.getLimit() >= 0) continue;
                return 0;
            }
            return Integer.MAX_VALUE;
        }
        int available = section.getLimit() - enrollments.countEnrollmentsForSection(sectionId);
        for (XReservation r : this.getSectionReservations(sectionId)) {
            if (r.isExpired() || !r.hasSectionRestriction(sectionId)) continue;
            if ((double)r.getLimit() < 0.0) {
                return 0;
            }
            int reserved = r.getReservedAvailableSpace(enrollments);
            available -= Math.max(0, reserved);
        }
        return available;
    }

    public int getUnreservedConfigSpace(Long configId, XEnrollments enrollments) {
        XConfig config = this.getConfig(configId);
        if (config.getLimit() < 0) {
            for (XReservation r : this.getConfigReservations(configId)) {
                if (r.isExpired() || !r.hasConfigRestriction(configId) || r.getLimit() >= 0) continue;
                return 0;
            }
            return Integer.MAX_VALUE;
        }
        int available = config.getLimit() - enrollments.countEnrollmentsForConfig(configId);
        for (XReservation r : this.getConfigReservations(configId)) {
            if (r.isExpired() || !r.hasConfigRestriction(configId)) continue;
            if (r.getLimit() < 0) {
                return 0;
            }
            double reserved = r.getReservedAvailableSpace(enrollments);
            available = (int)((double)available - Math.max(0.0, reserved));
        }
        return available;
    }

    public int getUnreservedSpace(XEnrollments enrollments) {
        int available = 0;
        for (XConfig config : this.getConfigs()) {
            available += config.getLimit() - enrollments.countEnrollmentsForConfig(config.getConfigId());
            if (config.getLimit() >= 0) continue;
            for (XReservation r : this.getReservations()) {
                if (r.isExpired() || r.getLimit() >= 0) continue;
                return 0;
            }
            return Integer.MAX_VALUE;
        }
        int reserved = 0;
        for (XReservation r : this.getReservations()) {
            if (r.isExpired()) continue;
            if (r.getLimit() < 0) {
                return 0;
            }
            reserved = (int)((double)reserved + Math.max(0.0, (double)r.getReservedAvailableSpace(enrollments)));
        }
        return available - reserved;
    }

    private static int min(int l1, int l2) {
        return l1 < 0 ? l2 : (l2 < 0 ? l1 : Math.min(l1, l2));
    }

    private static int add(int l1, int l2) {
        return l1 < 0 ? -1 : (l2 < 0 ? -1 : l1 + l2);
    }

    public int[] getCourseAvailability(Collection<XCourseRequest> requests, XCourse course) {
        int offeringLimit = 0;
        HashSet<Long> hidden = new HashSet<Long>();
        for (XConfig config : this.getConfigs()) {
            Integer configLimit = null;
            for (XSubpart subpart : config.getSubparts()) {
                int subpartLimit = 0;
                for (XSection section : subpart.getSections()) {
                    if (section.isEnabledForScheduling() && !section.isCancelled()) {
                        subpartLimit = XOffering.add(subpartLimit, section.getLimit());
                        continue;
                    }
                    hidden.add(section.getSectionId());
                }
                if (configLimit == null) {
                    configLimit = subpartLimit;
                    continue;
                }
                configLimit = XOffering.min(configLimit, subpartLimit);
            }
            if (configLimit == null) continue;
            offeringLimit = XOffering.add(offeringLimit, XOffering.min(configLimit, config.getLimit()));
        }
        int enrl = 0;
        int req = 0;
        if (requests != null) {
            block3: for (XCourseRequest r : requests) {
                if (r.getEnrollment() != null && r.getEnrollment().getCourseId().equals(course.getCourseId())) {
                    if (!hidden.isEmpty()) {
                        for (Long s : r.getEnrollment().getSectionIds()) {
                            if (!hidden.contains(s)) continue;
                            continue block3;
                        }
                    }
                    ++enrl;
                }
                if (r.isAlternative() || r.getEnrollment() != null || !r.getCourseIds().get(0).equals(course)) continue;
                ++req;
            }
        }
        return new int[]{enrl, XOffering.min(course.getLimit(), offeringLimit), req};
    }

    public boolean hasReservations() {
        return !this.iReservations.isEmpty();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof XOffering)) {
            return false;
        }
        return this.getOfferingId().equals(((XOffering)o).getOfferingId());
    }

    public int hashCode() {
        return (int)(this.getOfferingId() ^ this.getOfferingId() >>> 32);
    }

    public XReservationId guessReservation(Collection<XCourseRequest> other, XStudent student, XEnrollment enrollment) {
        if (!enrollment.getOfferingId().equals(this.getOfferingId())) {
            return null;
        }
        TreeSet<XReservation> reservations = new TreeSet<XReservation>();
        boolean mustBeUsed = false;
        for (XReservation reservation : this.getReservations()) {
            if (!reservation.isApplicable(student, enrollment)) continue;
            if (reservation.equals(enrollment.getReservation()) && reservation.isIncluded(enrollment.getConfigId(), this.getSections(enrollment))) {
                return reservation;
            }
            if (!mustBeUsed && reservation.mustBeUsed()) {
                reservations.clear();
                mustBeUsed = true;
            }
            if (mustBeUsed && !reservation.mustBeUsed()) continue;
            reservations.add(reservation);
        }
        if (reservations.isEmpty()) {
            return null;
        }
        List<XSection> sections = this.getSections(enrollment);
        for (XReservation reservation : reservations) {
            if (!reservation.isIncluded(enrollment.getConfigId(), sections)) continue;
            if ((double)reservation.getLimit() < 0.0 || other == null || mustBeUsed) {
                return new XReservationId(reservation.getType(), this.getOfferingId(), reservation.getReservationId());
            }
            int used = 0;
            for (XCourseRequest r : other) {
                if (r.getEnrollment() == null || !r.getEnrollment().getOfferingId().equals(this.getOfferingId()) || enrollment.getStudentId().equals(r.getStudentId()) || !reservation.equals(r.getEnrollment().getReservation())) continue;
                ++used;
            }
            if (used >= reservation.getLimit()) continue;
            return new XReservationId(reservation.getType(), this.getOfferingId(), reservation.getReservationId());
        }
        return null;
    }

    public boolean hasIndividualReservation(XStudent student, XCourseId course) {
        for (XReservation reservation : this.getReservations()) {
            if (!(reservation instanceof XIndividualReservation) || !reservation.isApplicable(student, course) || !reservation.mustBeUsed() || reservation.isExpired()) continue;
            return true;
        }
        return false;
    }

    public boolean hasGroupReservation(XStudent student, XCourseId course) {
        for (XReservation reservation : this.getReservations()) {
            if (reservation instanceof XGroupReservation && reservation.isApplicable(student, course) && reservation.mustBeUsed() && !reservation.isExpired()) {
                return true;
            }
            if (!(reservation instanceof XLearningCommunityReservation) || !reservation.isApplicable(student, course) || !reservation.mustBeUsed() || reservation.isExpired()) continue;
            return true;
        }
        return false;
    }

    public boolean hasLearningCommunityReservation(XStudent student, XCourseId course) {
        for (XReservation reservation : this.getReservations()) {
            if (!(reservation instanceof XLearningCommunityReservation) || !reservation.isApplicable(student, course) || !reservation.mustBeUsed() || reservation.isExpired()) continue;
            return true;
        }
        return false;
    }

    public int distance(DistanceMetric m, Section s1, Section s2) {
        TimeLocation t2;
        if (s1.getPlacement() == null || s2.getPlacement() == null) {
            return 0;
        }
        TimeLocation t1 = s1.getTime();
        if (!t1.shareDays(t2 = s2.getTime()) || !t1.shareWeeks(t2)) {
            return 0;
        }
        int a1 = t1.getStartSlot();
        int a2 = t2.getStartSlot();
        if (m.doComputeDistanceConflictsBetweenNonBTBClasses()) {
            int dist;
            if (a1 + t1.getNrSlotsPerMeeting() <= a2 && (dist = Placement.getDistanceInMinutes((DistanceMetric)m, (Placement)s1.getPlacement(), (Placement)s2.getPlacement())) > t1.getBreakTime() + Constants.SLOT_LENGTH_MIN * (a2 - a1 - t1.getLength())) {
                return dist;
            }
        } else if (a1 + t1.getNrSlotsPerMeeting() == a2) {
            return Placement.getDistanceInMinutes((DistanceMetric)m, (Placement)s1.getPlacement(), (Placement)s2.getPlacement());
        }
        return 0;
    }

    /*
     * Could not resolve type clashes
     */
    public Course toCourse(Long courseId, XStudent student, XExpectations expectations, Collection<XDistribution> distributions, XEnrollments enrollments) {
        Offering clonedOffering = new Offering(this.getOfferingId().longValue(), this.getName());
        XCourse course = this.getCourse(courseId);
        int courseLimit = course.getLimit();
        if (courseLimit >= 0) {
            if ((courseLimit -= enrollments.countEnrollmentsForCourse(course.getCourseId())) < 0) {
                courseLimit = 0;
            }
            for (XEnrollment enrollment : enrollments.getEnrollmentsForCourse(course.getCourseId())) {
                if (!enrollment.getStudentId().equals(student.getStudentId())) continue;
                ++courseLimit;
                break;
            }
        }
        Course clonedCourse = new Course(course.getCourseId().longValue(), course.getSubjectArea(), course.getCourseNumber(), clonedOffering, courseLimit, course.getProjected());
        clonedCourse.setNote(course.getNote());
        Hashtable<Long, OnlineConfig> configs = new Hashtable<Long, OnlineConfig>();
        Hashtable<Long, Subpart> subparts = new Hashtable<Long, Subpart>();
        Hashtable<Long, OnlineSection> sections = new Hashtable<Long, OnlineSection>();
        for (XConfig config : this.getConfigs()) {
            Object enrollment2;
            int configLimit = config.getLimit();
            int configEnrl = enrollments.countEnrollmentsForConfig(config.getConfigId());
            boolean configStudent = false;
            for (Object enrollment2 : enrollments.getEnrollmentsForConfig(config.getConfigId())) {
                if (!((XEnrollment)enrollment2).getStudentId().equals(student.getStudentId())) continue;
                --configEnrl;
                configStudent = true;
                break;
            }
            if (configLimit >= 0) {
                if ((configLimit -= configEnrl) < 0) {
                    configLimit = 0;
                }
                if (configStudent && configLimit == 0) {
                    configLimit = 1;
                }
            }
            OnlineConfig clonedConfig = new OnlineConfig(config.getConfigId().longValue(), configLimit, config.getName(), clonedOffering);
            if (config.getInstructionalMethod() != null) {
                clonedConfig.setInstructionalMethodId(config.getInstructionalMethod().getUniqueId());
                clonedConfig.setInstructionalMethodName(config.getInstructionalMethod().getLabel());
                clonedConfig.setInstructionalMethodReference(config.getInstructionalMethod().getReference());
            }
            clonedConfig.setEnrollment(configEnrl);
            configs.put(config.getConfigId(), clonedConfig);
            enrollment2 = config.getSubparts().iterator();
            while (enrollment2.hasNext()) {
                XSubpart subpart = (XSubpart)enrollment2.next();
                Subpart clonedSubpart = new Subpart(subpart.getSubpartId().longValue(), subpart.getInstructionalType(), subpart.getName(), (Config)clonedConfig, subpart.getParentId() == null ? null : (Subpart)subparts.get(subpart.getParentId()));
                clonedSubpart.setAllowOverlap(subpart.isAllowOverlap());
                clonedSubpart.setCredit(subpart.getCredit(courseId));
                subparts.put(subpart.getSubpartId(), clonedSubpart);
                for (XSection section : subpart.getSections()) {
                    int limit = section.getLimit();
                    int enrl = enrollments.countEnrollmentsForSection(section.getSectionId());
                    boolean std = false;
                    for (Object enrollment3 : enrollments.getEnrollmentsForSection(section.getSectionId())) {
                        if (!((XEnrollment)enrollment3).getStudentId().equals(student.getStudentId())) continue;
                        --enrl;
                        std = true;
                        break;
                    }
                    if (limit >= 0) {
                        if ((limit -= enrl) < 0) {
                            limit = 0;
                        }
                        if (std && limit == 0) {
                            limit = 1;
                        }
                    }
                    OnlineSection clonedSection = new OnlineSection(section.getSectionId().longValue(), limit, section.getName(course.getCourseId()), clonedSubpart, section.toPlacement(), section.toInstructors(), section.getParentId() == null ? null : (Section)sections.get(section.getParentId()));
                    clonedSection.setName(-1L, section.getName(-1L));
                    clonedSection.setNote(section.getNote());
                    clonedSection.setSpaceExpected(expectations == null ? 0.0 : expectations.getExpectedSpace(section.getSectionId()));
                    clonedSection.setEnrollment(enrl);
                    clonedSection.setCancelled(section.isCancelled());
                    clonedSection.setEnabled(std || section.isEnabledForScheduling());
                    if (distributions != null) {
                        Object enrollment3;
                        enrollment3 = distributions.iterator();
                        while (enrollment3.hasNext()) {
                            XDistribution distribution = (XDistribution)enrollment3.next();
                            if (distribution.getDistributionType() != XDistributionType.IngoreConflicts || !distribution.hasSection(section.getSectionId())) continue;
                            for (Long id : distribution.getSectionIds()) {
                                if (id.equals(section.getSectionId())) continue;
                                clonedSection.addIgnoreConflictWith(id.longValue());
                            }
                        }
                    }
                    if (limit > 0) {
                        double available = Math.round(clonedSection.getSpaceExpected() - (double)limit);
                        clonedSection.setPenalty(available / (double)section.getLimit());
                    }
                    sections.put(section.getSectionId(), clonedSection);
                }
            }
        }
        for (XReservation reservation : this.getReservations()) {
            int reservationLimit = Math.round(reservation.getLimit());
            if (reservationLimit >= 0) {
                if ((reservationLimit -= enrollments.countEnrollmentsForReservation(reservation.getReservationId())) < 0) {
                    reservationLimit = 0;
                }
                for (Object enrollment : enrollments.getEnrollmentsForReservation(reservation.getReservationId())) {
                    if (!((XEnrollment)enrollment).getStudentId().equals(student.getStudentId())) continue;
                    ++reservationLimit;
                    break;
                }
                if (reservationLimit <= 0 && (!reservation.mustBeUsed() || reservation.isExpired())) continue;
            }
            boolean applicable = reservation.isApplicable(student, course);
            if (reservation instanceof XCourseReservation) {
                applicable = ((XCourseReservation)reservation).getCourseId().equals(courseId);
            }
            if (reservation instanceof XDummyReservation) {
                Object enrollment;
                enrollment = enrollments.getEnrollmentsForCourse(courseId).iterator();
                while (enrollment.hasNext()) {
                    XEnrollment enrollment4 = enrollment.next();
                    if (!enrollment4.getStudentId().equals(student.getStudentId())) continue;
                    applicable = true;
                    break;
                }
            }
            if (!applicable && reservation.isExpired()) continue;
            OnlineReservation clonedReservation = new OnlineReservation(reservation.getType().ordinal(), reservation.getReservationId().longValue(), clonedOffering, reservation.getPriority(), reservation.canAssignOverLimit(), reservationLimit, applicable, reservation.mustBeUsed(), reservation.isAllowOverlap(), reservation.isExpired(), reservation.isOverride());
            clonedReservation.setAllowDisabled(reservation.isAllowDisabled());
            for (Long configId : reservation.getConfigsIds()) {
                clonedReservation.addConfig((Config)configs.get(configId));
            }
            for (Map.Entry entry : reservation.getSections().entrySet()) {
                HashSet clonedSections = new HashSet();
                for (Long sectionId : (Set)entry.getValue()) {
                    clonedSections.add(sections.get(sectionId));
                }
                clonedReservation.getSections().put(subparts.get(entry.getKey()), clonedSections);
            }
        }
        return clonedCourse;
    }

    public void addDistribution(XDistribution distribution) {
        this.iDistrubutions.add(distribution);
    }

    public List<XDistribution> getDistributions() {
        return this.iDistrubutions;
    }

    public boolean isAllowOverlap(XEnrollment enrollment) {
        if (enrollment.getReservation() == null) {
            return false;
        }
        for (XReservation reservation : this.getReservations()) {
            if (!reservation.equals(enrollment.getReservation()) || !reservation.isAllowOverlap()) continue;
            return true;
        }
        return false;
    }

    public boolean isAllowOverlap(XStudent student, Long configId, XCourseId course, List<XSection> assignment) {
        for (XReservation reservation : this.getReservations()) {
            if (!reservation.isAllowOverlap() || !reservation.isApplicable(student, course) || !reservation.isIncluded(configId, assignment)) continue;
            return true;
        }
        return false;
    }

    public Set<String> getInstructorExternalIds() {
        HashSet<String> ret = new HashSet<String>();
        for (XConfig config : this.getConfigs()) {
            for (XSubpart subpart : config.getSubparts()) {
                for (XSection section : subpart.getSections()) {
                    for (XInstructor instructor : section.getAllInstructors()) {
                        if (!instructor.hasExternalId()) continue;
                        ret.add(instructor.getExternalId());
                    }
                }
            }
        }
        return ret;
    }

    public void fillInUnavailabilities(Student student) {
        if (student.getExternalId() == null || student.getExternalId().isEmpty()) {
            return;
        }
        HashSet<Long> sections = new HashSet<Long>();
        for (XConfig config : this.getConfigs()) {
            for (XSubpart subpart : config.getSubparts()) {
                for (XSection section : subpart.getSections()) {
                    if (section.getTime() == null || section.isCancelled()) continue;
                    for (XInstructor instructor : section.getAllInstructors()) {
                        if (!student.getExternalId().equals(instructor.getExternalId()) || !sections.add(section.getSectionId())) continue;
                        new Unavailability(student, new Section(section.getSectionId().longValue(), section.getLimit(), this.getName() + " " + subpart.getName() + " " + section.getName(), null, section.toPlacement(), null, new Instructor[0]), instructor.isAllowOverlap());
                    }
                }
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.iUniqueId = in.readLong();
        this.iName = (String)in.readObject();
        int nrConfigs = in.readInt();
        this.iConfigs.clear();
        for (int i = 0; i < nrConfigs; ++i) {
            this.iConfigs.add(new XConfig(in));
        }
        int nrCourses = in.readInt();
        for (int i = 0; i < nrCourses; ++i) {
            this.iCourses.add(new XCourse(in));
        }
        int nrReservations = in.readInt();
        block10: for (int i = 0; i < nrReservations; ++i) {
            switch (XReservationType.values()[in.readInt()]) {
                case Course: {
                    this.iReservations.add(new XCourseReservation(in));
                    continue block10;
                }
                case Curriculum: {
                    this.iReservations.add(new XCurriculumReservation(in));
                    continue block10;
                }
                case Dummy: {
                    this.iReservations.add(new XDummyReservation(in));
                    continue block10;
                }
                case Group: 
                case GroupOverride: {
                    this.iReservations.add(new XGroupReservation(in));
                    continue block10;
                }
                case Individual: 
                case IndividualOverride: {
                    this.iReservations.add(new XIndividualReservation(in));
                    continue block10;
                }
                case LearningCommunity: {
                    this.iReservations.add(new XLearningCommunityReservation(in));
                }
            }
        }
        int nrDistributions = in.readInt();
        for (int i = 0; i < nrDistributions; ++i) {
            this.iDistrubutions.add(new XDistribution(in));
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.iUniqueId);
        out.writeObject(this.iName);
        out.writeInt(this.iConfigs.size());
        for (XConfig config : this.iConfigs) {
            config.writeExternal(out);
        }
        out.writeInt(this.iCourses.size());
        for (XCourse course : this.iCourses) {
            course.writeExternal(out);
        }
        out.writeInt(this.iReservations.size());
        for (XReservation reservation : this.iReservations) {
            out.writeInt(reservation.getType().ordinal());
            reservation.writeExternal(out);
        }
        out.writeInt(this.iDistrubutions.size());
        for (XDistribution distribution : this.iDistrubutions) {
            distribution.writeExternal(out);
        }
    }

    public static class XOfferingSerializer
    implements Externalizer<XOffering> {
        private static final long serialVersionUID = 1L;

        public void writeObject(ObjectOutput output, XOffering object) throws IOException {
            object.writeExternal(output);
        }

        public XOffering readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new XOffering(input);
        }
    }

    public static class EnrollmentSectionComparator
    implements Comparator<Section> {
        public boolean isParent(Section s1, Section s2) {
            Section p1 = s1.getParent();
            if (p1 == null) {
                return false;
            }
            if (p1.equals((Object)s2)) {
                return true;
            }
            return this.isParent(p1, s2);
        }

        @Override
        public int compare(Section a, Section b) {
            if (this.isParent(a, b)) {
                return 1;
            }
            if (this.isParent(b, a)) {
                return -1;
            }
            int cmp = a.getSubpart().getInstructionalType().compareToIgnoreCase(b.getSubpart().getInstructionalType());
            if (cmp != 0) {
                return cmp;
            }
            return Double.compare(a.getId(), b.getId());
        }
    }
}

