/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.model;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.SerializeWith;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;

@SerializeWith(value=XEnrollmentsSerializer.class)
public class XEnrollments
implements Serializable,
Externalizable {
    private static final long serialVersionUID = 1L;
    private Long iOfferingId;
    private List<XCourseRequest> iRequests = new ArrayList<XCourseRequest>();
    private List<XEnrollment> iEnrollments = null;
    private Map<Long, List<XEnrollment>> iConfig2Enrl = null;
    private Map<Long, List<XEnrollment>> iCourse2Enrl = null;
    private Map<Long, List<XEnrollment>> iSection2Enrl = null;
    private Map<Long, List<XEnrollment>> iReservation2Enrl = null;

    public XEnrollments() {
    }

    public XEnrollments(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal(in);
    }

    public XEnrollments(Long offeringId, Collection<XCourseRequest> requests) {
        this.iOfferingId = offeringId;
        if (requests != null) {
            this.iRequests.addAll(requests);
        }
        this.init();
    }

    private void init() {
        this.iEnrollments = new ArrayList<XEnrollment>();
        this.iConfig2Enrl = new HashMap<Long, List<XEnrollment>>();
        this.iCourse2Enrl = new HashMap<Long, List<XEnrollment>>();
        this.iSection2Enrl = new HashMap<Long, List<XEnrollment>>();
        this.iReservation2Enrl = new HashMap<Long, List<XEnrollment>>();
        for (XCourseRequest request : this.iRequests) {
            XEnrollment enrollment = request.getEnrollment();
            if (enrollment == null || !enrollment.getOfferingId().equals(this.iOfferingId)) continue;
            this.iEnrollments.add(enrollment);
            List<XEnrollment> cfgEnrl = this.iConfig2Enrl.get(enrollment.getConfigId());
            if (cfgEnrl == null) {
                cfgEnrl = new ArrayList<XEnrollment>();
                this.iConfig2Enrl.put(enrollment.getConfigId(), cfgEnrl);
            }
            cfgEnrl.add(enrollment);
            List<XEnrollment> coEnrl = this.iCourse2Enrl.get(enrollment.getCourseId());
            if (coEnrl == null) {
                coEnrl = new ArrayList<XEnrollment>();
                this.iCourse2Enrl.put(enrollment.getCourseId(), coEnrl);
            }
            coEnrl.add(enrollment);
            if (enrollment.getReservation() != null) {
                List<XEnrollment> resEnrl = this.iReservation2Enrl.get(enrollment.getReservation().getReservationId());
                if (resEnrl == null) {
                    resEnrl = new ArrayList<XEnrollment>();
                    this.iReservation2Enrl.put(enrollment.getReservation().getReservationId(), resEnrl);
                }
                resEnrl.add(enrollment);
            }
            for (Long sectionId : enrollment.getSectionIds()) {
                List<XEnrollment> enrl = this.iSection2Enrl.get(sectionId);
                if (enrl == null) {
                    enrl = new ArrayList<XEnrollment>();
                    this.iSection2Enrl.put(sectionId, enrl);
                }
                enrl.add(enrollment);
            }
        }
    }

    public List<XCourseRequest> getRequests() {
        return this.iRequests;
    }

    public List<XEnrollment> getEnrollments() {
        return this.iEnrollments;
    }

    public int countEnrollments() {
        return this.iEnrollments == null ? 0 : this.iEnrollments.size();
    }

    public List<XEnrollment> getEnrollmentsForSection(Long sectionId) {
        ArrayList ret = this.iSection2Enrl.get(sectionId);
        return ret == null ? new ArrayList() : ret;
    }

    public List<XEnrollment> getEnrollmentsForCourse(Long courseId) {
        ArrayList ret = this.iCourse2Enrl.get(courseId);
        return ret == null ? new ArrayList() : ret;
    }

    public List<XEnrollment> getEnrollmentsForConfig(Long configId) {
        ArrayList ret = this.iConfig2Enrl.get(configId);
        return ret == null ? new ArrayList() : ret;
    }

    public List<XEnrollment> getEnrollmentsForReservation(Long reservationId) {
        ArrayList ret = this.iReservation2Enrl.get(reservationId);
        return ret == null ? new ArrayList() : ret;
    }

    public int countEnrollmentsForSection(Long sectionId) {
        List<XEnrollment> ret = this.iSection2Enrl.get(sectionId);
        return ret == null ? 0 : ret.size();
    }

    public int countEnrollmentsForCourse(Long courseId) {
        List<XEnrollment> ret = this.iCourse2Enrl.get(courseId);
        return ret == null ? 0 : ret.size();
    }

    public int countEnrollmentsForConfig(Long configId) {
        List<XEnrollment> ret = this.iConfig2Enrl.get(configId);
        return ret == null ? 0 : ret.size();
    }

    public int countEnrollmentsForReservation(Long reservationId) {
        List<XEnrollment> ret = this.iReservation2Enrl.get(reservationId);
        return ret == null ? 0 : ret.size();
    }

    private boolean contain(List<XEnrollment> enrollments, Long studentId) {
        if (studentId == null || enrollments == null) {
            return false;
        }
        for (XEnrollment e : enrollments) {
            if (!e.getStudentId().equals(studentId)) continue;
            return true;
        }
        return false;
    }

    public int countEnrollmentsForSection(Long sectionId, Long excludeStudentId) {
        List<XEnrollment> ret = this.iSection2Enrl.get(sectionId);
        return ret == null ? 0 : (this.contain(ret, excludeStudentId) ? ret.size() - 1 : ret.size());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.iOfferingId = in.readLong();
        int nrRequests = in.readInt();
        this.iRequests.clear();
        for (int i = 0; i < nrRequests; ++i) {
            this.iRequests.add(new XCourseRequest(in));
        }
        this.init();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.iOfferingId);
        out.writeInt(this.iRequests.size());
        for (XCourseRequest request : this.iRequests) {
            request.writeExternal(out);
        }
    }

    public static class XEnrollmentsSerializer
    implements Externalizer<XEnrollments> {
        private static final long serialVersionUID = 1L;

        public void writeObject(ObjectOutput output, XEnrollments object) throws IOException {
            object.writeExternal(output);
        }

        public XEnrollments readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new XEnrollments(input);
        }
    }
}

