/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.model;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Section;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.SerializeWith;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.model.XApproval;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XReservation;
import org.unitime.timetable.onlinesectioning.model.XReservationId;
import org.unitime.timetable.onlinesectioning.model.XSection;

@SerializeWith(value=XEnrollmentSerializer.class)
public class XEnrollment
extends XCourseId
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iStudentId = null;
    private Long iConfigId = null;
    private Set<Long> iSectionIds = new HashSet<Long>();
    private Date iTimeStamp = null;
    private XApproval iApproval = null;
    private XReservationId iReservation = null;

    public XEnrollment() {
    }

    public XEnrollment(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal(in);
    }

    public XEnrollment(Student student, CourseOffering course, OnlineSectioningHelper helper, Collection<StudentClassEnrollment> enrollments) {
        super(course);
        this.iStudentId = student.getUniqueId();
        for (StudentClassEnrollment enrl : enrollments) {
            if (this.iConfigId == null) {
                this.iConfigId = enrl.getClazz().getSchedulingSubpart().getInstrOfferingConfig().getUniqueId();
            }
            this.iSectionIds.add(enrl.getClazz().getUniqueId());
            if (this.iTimeStamp == null || enrl.getTimestamp() != null && enrl.getTimestamp().after(this.iTimeStamp)) {
                this.iTimeStamp = enrl.getTimestamp();
            }
            if (this.iApproval != null || enrl.getApprovedBy() == null || enrl.getApprovedDate() == null) continue;
            this.iApproval = new XApproval(enrl.getApprovedBy(), enrl.getApprovedDate(), helper.getApproverName(enrl.getApprovedBy(), student.getSession().getUniqueId()));
        }
    }

    public XEnrollment(XEnrollment enrollment) {
        super(enrollment);
        this.iStudentId = enrollment.getStudentId();
        this.iConfigId = enrollment.getConfigId();
        this.iSectionIds.addAll(enrollment.getSectionIds());
        this.iTimeStamp = enrollment.getTimeStamp();
        this.iApproval = enrollment.getApproval();
        this.iReservation = enrollment.getReservation();
    }

    public XEnrollment(Enrollment enrollment) {
        super(enrollment.getOffering().getId(), enrollment.getCourse().getId(), enrollment.getCourse().getName());
        this.iStudentId = enrollment.getStudent().getId();
        this.iConfigId = enrollment.getConfig().getId();
        for (Section section : enrollment.getSections()) {
            this.iSectionIds.add(section.getId());
        }
        this.iTimeStamp = enrollment.getTimeStamp() == null ? null : new Date(enrollment.getTimeStamp());
        this.iApproval = enrollment.getApproval() == null ? null : new XApproval(enrollment.getApproval().split(":"));
        this.iReservation = enrollment.getReservation() == null ? null : new XReservationId(enrollment.getReservation());
    }

    public XEnrollment(Student student, XCourseId courseId, Long configId, Collection<Long> sectionIds) {
        super(courseId);
        this.iStudentId = student.getUniqueId();
        this.iConfigId = configId;
        if (sectionIds != null) {
            this.iSectionIds.addAll(sectionIds);
        }
    }

    public Long getStudentId() {
        return this.iStudentId;
    }

    public Long getConfigId() {
        return this.iConfigId;
    }

    public Set<Long> getSectionIds() {
        return this.iSectionIds;
    }

    public Date getTimeStamp() {
        return this.iTimeStamp;
    }

    public XApproval getApproval() {
        return this.iApproval;
    }

    public void setApproval(XApproval approval) {
        this.iApproval = approval;
    }

    public XReservationId getReservation() {
        return this.iReservation;
    }

    public void setReservation(XReservationId reservation) {
        this.iReservation = reservation == null ? null : (reservation instanceof XReservation ? new XReservationId(reservation) : reservation);
    }

    public void setTimeStamp(Date ts) {
        this.iTimeStamp = ts;
    }

    public float getCredit(OnlineSectioningServer server) {
        XOffering offering = server.getOffering(this.getOfferingId());
        if (offering == null) {
            return 0.0f;
        }
        Float sectionCredit = null;
        for (Long sectionId : this.getSectionIds()) {
            XSection section = offering.getSection(sectionId);
            Float credit = section == null ? null : section.getCreditOverride(this.getCourseId());
            if (credit == null) continue;
            sectionCredit = Float.valueOf((sectionCredit == null ? 0.0f : sectionCredit.floatValue()) + credit.floatValue());
        }
        if (sectionCredit != null) {
            return sectionCredit.floatValue();
        }
        XCourse course = offering.getCourse(this.getCourseId());
        if (course != null && course.hasCredit()) {
            return course.getMinCredit().floatValue();
        }
        return 0.0f;
    }

    @Override
    public int compareTo(XCourseId courseId) {
        if (courseId instanceof XEnrollment) {
            XEnrollment enrollment = (XEnrollment)courseId;
            int cmp = this.getTimeStamp().compareTo(enrollment.getTimeStamp());
            if (cmp != 0) {
                return cmp;
            }
            cmp = this.getStudentId().compareTo(enrollment.getStudentId());
            if (cmp != 0) {
                return cmp;
            }
        }
        return super.compareTo(courseId);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof XEnrollment)) {
            if (o instanceof XCourseId) {
                return ((XCourseId)o).equals(this);
            }
            return false;
        }
        XEnrollment e = (XEnrollment)o;
        return this.getCourseId().equals(e.getCourseId()) && this.getConfigId().equals(e.getConfigId()) && this.getSectionIds().equals(e.getSectionIds());
    }

    @Override
    public String toString() {
        return this.getCourseName() + "/" + this.getSectionIds() + (this.getApproval() != null ? (this.getReservation() != null ? " (ar)" : " (a)") : (this.getReservation() != null ? " (r)" : ""));
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.iStudentId = in.readLong();
        this.iConfigId = in.readLong();
        this.iSectionIds.clear();
        int nrSections = in.readInt();
        for (int i = 0; i < nrSections; ++i) {
            this.iSectionIds.add(in.readLong());
        }
        this.iTimeStamp = in.readBoolean() ? new Date(in.readLong()) : null;
        this.iApproval = in.readBoolean() ? new XApproval(in) : null;
        this.iReservation = in.readBoolean() ? new XReservationId(in) : null;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeLong(this.iStudentId);
        out.writeLong(this.iConfigId);
        out.writeInt(this.iSectionIds.size());
        for (Long sectionId : this.iSectionIds) {
            out.writeLong(sectionId);
        }
        out.writeBoolean(this.iTimeStamp != null);
        if (this.iTimeStamp != null) {
            out.writeLong(this.iTimeStamp.getTime());
        }
        out.writeBoolean(this.iApproval != null);
        if (this.iApproval != null) {
            this.iApproval.writeExternal(out);
        }
        out.writeBoolean(this.iReservation != null);
        if (this.iReservation != null) {
            this.iReservation.writeExternal(out);
        }
    }

    public static class XEnrollmentSerializer
    implements Externalizer<XEnrollment> {
        private static final long serialVersionUID = 1L;

        public void writeObject(ObjectOutput output, XEnrollment object) throws IOException {
            object.writeExternal(output);
        }

        public XEnrollment readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new XEnrollment(input);
        }
    }
}

