/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.custom.purdue;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.joda.time.DateTime;

public class SpecialRegistrationInterface {

    public static class SpecialRegistrationAvailableGradeMode {
        public List<String> approvals;
        public String gradingMode;
        public String gradingModeDescription;
    }

    public static class SpecialRegistrationCurrentGradeMode {
        public String crn;
        public String gradingMode;
        public String gradingModeDescription;
        public List<SpecialRegistrationAvailableGradeMode> availableGradingModes;
    }

    public static class SpecialRegistrationCheckGradeModes {
        public String studentId;
        public String term;
        public String campus;
        List<SpecialRegistrationCurrentGradeMode> gradingModes;
    }

    public static class SpecialRegistrationUpdateResponse
    extends Response<String> {
    }

    public static class SpecialRegistrationCheckGradeModesResponse
    extends Response<SpecialRegistrationCheckGradeModes> {
    }

    public static class SpecialRegistrationCancelResponse
    extends Response<String> {
    }

    public static class CheckRestrictionsResponse {
        public List<SpecialRegistration> cancelRegistrationRequests;
        public List<DeniedRequest> deniedRequests;
        public List<DeniedMaxCredit> deniedMaxCreditRequests;
        public SpecialRegistrationEligibility eligible;
        public Float maxCredit;
        public ScheduleRestrictions outJson;
        public ScheduleRestrictions outJsonAlternatives;
        public Set<String> overrides;
        public ResponseStatus status;
        public String message;
    }

    public static class CheckRestrictionsRequest {
        public String studentId;
        public String term;
        public String campus;
        public ApiMode mode;
        public RestrictionsCheckRequest changes;
        public RestrictionsCheckRequest alternatives;
    }

    public static class DeniedMaxCredit {
        public String code;
        public String errorMessage;
        public Float maxCredit;
        public ApiMode mode;
    }

    public static class DeniedRequest {
        public String subject;
        public String courseNbr;
        public String crn;
        public String code;
        public String errorMessage;
        public ApiMode mode;
    }

    public static class RestrictionsCheckRequest {
        public String sisId;
        public String term;
        public String campus;
        public IncludeReg includeReg;
        public ValidationMode mode;
        public Map<ValidationOperation, List<Crn>> actions;
    }

    public static class Crn {
        String crn;
    }

    public static enum ValidationOperation {
        ADD,
        DROP;

    }

    public static enum ValidationMode {
        REG,
        ALT;

    }

    public static enum IncludeReg {
        Y,
        N;

    }

    public static class ScheduleRestrictions {
        public List<Problem> problems;
        public String sisId;
        public ResponseStatus status;
        public String term;
        public Float maxHoursCalc;
        public String message;
    }

    public static class Problem {
        String code;
        String message;
        String crn;
    }

    public static class CheckEligibilityResponse
    extends Response<SpecialRegistrationEligibility> {
        public Set<String> overrides;
        public Float maxCredit;
        public Boolean hasNonCanceledRequest;
    }

    public static class EligibilityProblem {
        String code;
        String message;
    }

    public static class SpecialRegistrationEligibility {
        public String studentId;
        public String term;
        public String campus;
        public Boolean eligible;
        public List<EligibilityProblem> eligibilityProblems;
    }

    public static class SpecialRegistrationMultipleStatusResponse
    extends Response<SpecialRegistrationMultipleStatus> {
    }

    public static class SpecialRegistrationMultipleStatus {
        public List<SpecialRegistrationStatus> students;
    }

    public static class SpecialRegistrationStatusResponse
    extends Response<SpecialRegistrationStatus> {
    }

    public static class SpecialRegistrationStatus {
        public List<SpecialRegistration> requests;
        public Float maxCredit;
        public String studentId;
    }

    public static class SpecialRegistrationResponseList
    extends Response<List<SubmitRegistrationResponse>> {
        public List<CancelledRequest> cancelledRequests;
    }

    public static class SubmitRegistrationResponse
    extends SpecialRegistration {
        public List<CancelledRequest> cancelledRequests;
    }

    public static class CancelledRequest {
        public String subject;
        public String courseNbr;
        public String crn;
        public String regRequestId;
    }

    public static class CourseCredit {
        public String subject;
        public String courseNbr;
        public String title;
        public Float creditHrs;
        public List<CourseCredit> alternatives;
    }

    public static class SpecialRegistrationRequest
    extends SpecialRegistration {
        public String requestorId;
        public RequestorRole requestorRole;
        public List<CourseCredit> courseCreditHrs;
        public List<CourseCredit> alternateCourseCreditHrs;
    }

    public static class ChangeNote {
        public DateTime dateCreated;
        public String fullName;
        public String notes;
        public String purpose;
    }

    public static class ChangeError {
        String code;
        String message;
    }

    public static class Change {
        public String subject;
        public String courseNbr;
        public String crn;
        public ChangeOperation operation;
        public List<ChangeError> errors;
        public ChangeStatus status;
        public List<ChangeNote> notes;
        public String credit;
        public String currentGradeMode;
        public String selectedGradeMode;
        public String selectedGradeModeDescription;
    }

    public static enum ChangeOperation {
        ADD,
        DROP,
        KEEP,
        CHGMODE;

    }

    public static class SpecialRegistration {
        public String regRequestId;
        public String studentId;
        public String term;
        public String campus;
        public ApiMode mode;
        public List<Change> changes;
        public DateTime dateCreated;
        public Float maxCredit;
        public String requestorNotes;
        public CompletionStatus completionStatus;
    }

    public static class Response<T> {
        public T data;
        public String message;
        public ResponseStatus status;
    }

    public static enum ChangeStatus {
        inProgress,
        approved,
        denied,
        cancelled,
        deferred,
        escalated;

    }

    public static enum CompletionStatus {
        inProgress,
        completed,
        cancelled;

    }

    public static enum RequestorRole {
        STUDENT,
        MANAGER;

    }

    public static enum ApiMode {
        PREREG,
        REG;

    }

    public static enum ResponseStatus {
        success,
        error,
        failure,
        Failed;

    }
}

