/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.custom.purdue;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.restlet.Client;
import org.restlet.Uniform;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.MediaType;
import org.restlet.data.Protocol;
import org.restlet.resource.ClientResource;
import org.restlet.resource.ResourceException;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.CourseRequestsValidationProvider;
import org.unitime.timetable.onlinesectioning.custom.ExternalTermProvider;
import org.unitime.timetable.onlinesectioning.custom.purdue.BannerTermProvider;
import org.unitime.timetable.onlinesectioning.custom.purdue.GsonRepresentation;
import org.unitime.timetable.onlinesectioning.custom.purdue.SpecialRegistrationInterface;
import org.unitime.timetable.onlinesectioning.custom.purdue.XEInterface;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.server.DatabaseServer;
import org.unitime.timetable.util.Formats;

public class SimplifiedCourseRequestsValidationProvider
implements CourseRequestsValidationProvider {
    private static Logger sLog = Logger.getLogger(SimplifiedCourseRequestsValidationProvider.class);
    private static StudentSectioningMessages MESSAGES = Localization.create(StudentSectioningMessages.class);
    protected static Formats.Format<Number> sCreditFormat = Formats.getNumberFormat("0.##");
    private Client iClient;
    private ExternalTermProvider iExternalTermProvider;

    public SimplifiedCourseRequestsValidationProvider() {
        ArrayList<Protocol> protocols = new ArrayList<Protocol>();
        protocols.add(Protocol.HTTP);
        protocols.add(Protocol.HTTPS);
        this.iClient = new Client(protocols);
        try {
            String clazz = ApplicationProperty.CustomizationExternalTerm.value();
            this.iExternalTermProvider = clazz == null || clazz.isEmpty() ? new BannerTermProvider() : (ExternalTermProvider)Class.forName(clazz).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            sLog.error((Object)"Failed to create external term provider, using the default one instead.", (Throwable)e);
            this.iExternalTermProvider = new BannerTermProvider();
        }
    }

    protected String getSpecialRegistrationApiSite() {
        return ApplicationProperties.getProperty("purdue.specreg.site");
    }

    protected String getSpecialRegistrationApiSiteCheckEligibility() {
        return ApplicationProperties.getProperty("purdue.specreg.site.checkEligibility", this.getSpecialRegistrationApiSite() + "/checkEligibility");
    }

    protected String getSpecialRegistrationApiKey() {
        return ApplicationProperties.getProperty("purdue.specreg.apiKey");
    }

    protected SpecialRegistrationInterface.ApiMode getSpecialRegistrationApiMode() {
        return SpecialRegistrationInterface.ApiMode.valueOf(ApplicationProperties.getProperty("purdue.specreg.mode.validation", "PREREG"));
    }

    protected String getBannerSite() {
        return ApplicationProperties.getProperty("banner.xe.site");
    }

    protected String getBannerUser(boolean admin) {
        String user;
        if (admin && (user = ApplicationProperties.getProperty("banner.xe.admin.user")) != null) {
            return user;
        }
        return ApplicationProperties.getProperty("banner.xe.user");
    }

    protected String getBannerPassword(boolean admin) {
        String pwd;
        if (admin && (pwd = ApplicationProperties.getProperty("banner.xe.admin.password")) != null) {
            return pwd;
        }
        return ApplicationProperties.getProperty("banner.xe.password");
    }

    protected String getAdminParameter() {
        return ApplicationProperties.getProperty("banner.xe.adminParameter", "systemIn");
    }

    protected String getBannerErrors() {
        return ApplicationProperties.getProperty("banner.xe.prereg.errors", "(Holds prevent registration\\.|Student Status prevents registration\\.)");
    }

    protected boolean isValidationEnabled(Student student) {
        if (student == null) {
            return false;
        }
        StudentSectioningStatus status = student.getEffectiveStatus();
        return status == null || status.hasOption(StudentSectioningStatus.Option.reqval);
    }

    protected boolean isValidationEnabled(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student) {
        StudentSectioningStatus dbStatus;
        String status = student.getStatus();
        if (status == null) {
            status = server.getAcademicSession().getDefaultSectioningStatus();
        }
        if (status == null) {
            return true;
        }
        for (dbStatus = StudentSectioningStatus.getStatus(status, server.getAcademicSession().getUniqueId(), helper.getHibSession()); dbStatus != null && dbStatus.isPast() && dbStatus.getFallBackStatus() != null; dbStatus = dbStatus.getFallBackStatus()) {
        }
        return dbStatus != null && dbStatus.hasOption(StudentSectioningStatus.Option.reqval);
    }

    protected String getBannerTerm(AcademicSessionInfo session) {
        return this.iExternalTermProvider.getExternalTerm(session);
    }

    protected String getBannerCampus(AcademicSessionInfo session) {
        return this.iExternalTermProvider.getExternalCampus(session);
    }

    protected boolean isBannerAdmin() {
        return "true".equalsIgnoreCase(ApplicationProperties.getProperty("banner.xe.admin", "false"));
    }

    protected boolean isPreregAdmin() {
        return "true".equalsIgnoreCase(ApplicationProperties.getProperty("banner.xe.prereg.admin", "false"));
    }

    protected boolean isUseXE() {
        return "true".equalsIgnoreCase(ApplicationProperties.getProperty("purdue.specReg.XEeligibility", "false"));
    }

    protected String getBannerId(Student student) {
        String id = student.getExternalUniqueId();
        while (id.length() < 9) {
            id = "0" + id;
        }
        return id;
    }

    protected Gson getGson(OnlineSectioningHelper helper) {
        GsonBuilder builder = new GsonBuilder().registerTypeAdapter(DateTime.class, (Object)new JsonSerializer<DateTime>(){

            public JsonElement serialize(DateTime src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(src.toString("yyyy-MM-dd'T'HH:mm:ss'Z'"));
            }
        }).registerTypeAdapter(DateTime.class, (Object)new JsonDeserializer<DateTime>(){

            public DateTime deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return new DateTime((Object)json.getAsJsonPrimitive().getAsString(), DateTimeZone.UTC);
            }
        });
        if (helper.isDebugEnabled()) {
            builder.setPrettyPrinting();
        }
        return builder.create();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void checkEligibility(OnlineSectioningServer server, OnlineSectioningHelper helper, OnlineSectioningInterface.EligibilityCheck check, Student student) throws SectioningException {
        if (student == null || !check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_REGISTER)) {
            return;
        }
        if (!this.isValidationEnabled(student)) {
            return;
        }
        if (this.isUseXE()) {
            ClientResource resource = null;
            try {
                XStudent xs;
                boolean admin;
                String pin = helper.getPin();
                AcademicSessionInfo session = server.getAcademicSession();
                String term = this.getBannerTerm(session);
                boolean manager = helper.getUser().getType() == OnlineSectioningLog.Entity.EntityType.MANAGER;
                boolean bl = admin = manager && this.isBannerAdmin();
                if (helper.isDebugEnabled()) {
                    helper.debug("Checking eligility for " + student.getName("last-first-middle") + " (term: " + term + ", id:" + this.getBannerId(student) + (admin ? ", admin" : (pin != null ? ", pin:" + pin : "")) + ")");
                }
                resource = new ClientResource(this.getBannerSite());
                resource.setNext((Uniform)this.iClient);
                resource.setChallengeResponse(ChallengeScheme.HTTP_BASIC, this.getBannerUser(manager), this.getBannerPassword(manager));
                Gson gson = this.getGson(helper);
                XEInterface.RegisterResponse original = null;
                resource.addQueryParameter("term", term);
                resource.addQueryParameter("bannerId", this.getBannerId(student));
                helper.getAction().addOptionBuilder().setKey("term").setValue(term);
                helper.getAction().addOptionBuilder().setKey("bannerId").setValue(this.getBannerId(student));
                if (admin || this.isPreregAdmin()) {
                    String param = this.getAdminParameter();
                    resource.addQueryParameter(param, "SB");
                    helper.getAction().addOptionBuilder().setKey(param).setValue("SB");
                } else if (pin != null && !pin.isEmpty()) {
                    resource.addQueryParameter("altPin", pin);
                    helper.getAction().addOptionBuilder().setKey("pin").setValue(pin);
                }
                long t0 = System.currentTimeMillis();
                try {
                    resource.get(MediaType.APPLICATION_JSON);
                }
                catch (ResourceException exception) {
                    helper.getAction().setApiException(exception.getMessage());
                    try {
                        XEInterface.ErrorResponse response = new GsonRepresentation<XEInterface.ErrorResponse>(resource.getResponseEntity(), XEInterface.ErrorResponse.class).getObject();
                        helper.getAction().addOptionBuilder().setKey("exception").setValue(gson.toJson((Object)response));
                        XEInterface.Error error = response.getError();
                        if (error != null && error.message != null) {
                            throw new SectioningException(error.message);
                        }
                        if (error != null && error.description != null) {
                            throw new SectioningException(error.description);
                        }
                        if (error == null || error.errorMessage == null) throw exception;
                        throw new SectioningException(error.errorMessage);
                    }
                    catch (SectioningException e) {
                        helper.getAction().setApiException(e.getMessage());
                        throw e;
                    }
                    catch (Throwable t) {
                        throw exception;
                    }
                }
                finally {
                    helper.getAction().setApiGetTime(System.currentTimeMillis() - t0);
                }
                List current = (List)new GsonRepresentation(resource.getResponseEntity(), XEInterface.RegisterResponse.TYPE_LIST).getObject();
                helper.getAction().addOptionBuilder().setKey("response").setValue(gson.toJson((Object)current));
                if (current != null && !current.isEmpty()) {
                    original = (XEInterface.RegisterResponse)current.get(0);
                }
                if (original != null && helper.isDebugEnabled()) {
                    helper.debug("Current registration: " + gson.toJson((Object)original));
                }
                String bannerErrors = this.getBannerErrors();
                String error = null;
                if (original != null && original.failureReasons != null) {
                    for (String m : original.failureReasons) {
                        if (bannerErrors != null && !m.matches(bannerErrors)) continue;
                        if (error == null) {
                            error = m;
                            continue;
                        }
                        error = error + (error.endsWith(".") ? " " : ", ") + m;
                    }
                }
                if (error != null) {
                    check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_REGISTER, false);
                    check.setMessage(MESSAGES.exceptionFailedEligibilityCheck(error));
                }
                if (student.getUniqueId() == null || original == null || original.maxHours == null || !(original.maxHours.floatValue() > 0.0f) || original.maxHours == student.getMaxCredit()) return;
                Student dbStudent = (Student)StudentDAO.getInstance().get(student.getUniqueId(), helper.getHibSession());
                dbStudent.setMaxCredit(original.maxHours);
                helper.getHibSession().update((Object)dbStudent);
                helper.getHibSession().flush();
                if (server instanceof DatabaseServer || (xs = server.getStudent(student.getUniqueId())) == null) return;
                xs.setMaxCredit(original.maxHours);
                server.update(xs, false);
                return;
            }
            catch (SectioningException e) {
                helper.info("Banner eligibility failed: " + e.getMessage());
                throw e;
            }
            catch (Exception e) {
                helper.warn("Banner eligibility failed: " + e.getMessage(), e);
                throw new SectioningException(e.getMessage());
            }
            finally {
                if (resource != null) {
                    if (resource.getResponse() != null) {
                        resource.getResponse().release();
                    }
                    resource.release();
                }
            }
        }
        ClientResource resource = null;
        try {
            XStudent xs;
            resource = new ClientResource(this.getSpecialRegistrationApiSiteCheckEligibility());
            resource.setNext((Uniform)this.iClient);
            AcademicSessionInfo session = server.getAcademicSession();
            String term = this.getBannerTerm(session);
            String campus = this.getBannerCampus(session);
            resource.addQueryParameter("term", term);
            resource.addQueryParameter("campus", campus);
            resource.addQueryParameter("studentId", this.getBannerId(student));
            resource.addQueryParameter("mode", this.getSpecialRegistrationApiMode().name());
            helper.getAction().addOptionBuilder().setKey("term").setValue(term);
            helper.getAction().addOptionBuilder().setKey("campus").setValue(campus);
            helper.getAction().addOptionBuilder().setKey("studentId").setValue(this.getBannerId(student));
            resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
            long t0 = System.currentTimeMillis();
            resource.get(MediaType.APPLICATION_JSON);
            helper.getAction().setApiGetTime(System.currentTimeMillis() - t0);
            SpecialRegistrationInterface.CheckEligibilityResponse eligibility = new GsonRepresentation<SpecialRegistrationInterface.CheckEligibilityResponse>(resource.getResponseEntity(), SpecialRegistrationInterface.CheckEligibilityResponse.class).getObject();
            Gson gson = this.getGson(helper);
            if (helper.isDebugEnabled()) {
                helper.debug("Eligibility: " + gson.toJson((Object)eligibility));
            }
            helper.getAction().addOptionBuilder().setKey("response").setValue(gson.toJson((Object)eligibility));
            if (SpecialRegistrationInterface.ResponseStatus.success != eligibility.status) {
                throw new SectioningException(eligibility.message == null || eligibility.message.isEmpty() ? "Failed to check student eligibility (" + (Object)((Object)eligibility.status) + ")." : eligibility.message);
            }
            if (eligibility.data != null && ((SpecialRegistrationInterface.SpecialRegistrationEligibility)eligibility.data).eligibilityProblems != null) {
                String m = null;
                for (SpecialRegistrationInterface.EligibilityProblem p : ((SpecialRegistrationInterface.SpecialRegistrationEligibility)eligibility.data).eligibilityProblems) {
                    if (m == null) {
                        m = p.message;
                        continue;
                    }
                    m = m + "\n" + p.message;
                }
                if (m != null) {
                    check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_REGISTER, false);
                    check.setMessage(MESSAGES.exceptionFailedEligibilityCheck(m));
                }
            }
            if (student.getUniqueId() == null || eligibility.maxCredit == null || !(eligibility.maxCredit.floatValue() > 0.0f) || eligibility.maxCredit == student.getMaxCredit()) return;
            Student dbStudent = (Student)StudentDAO.getInstance().get(student.getUniqueId(), helper.getHibSession());
            dbStudent.setMaxCredit(eligibility.maxCredit);
            helper.getHibSession().update((Object)dbStudent);
            helper.getHibSession().flush();
            if (server instanceof DatabaseServer || (xs = server.getStudent(student.getUniqueId())) == null) return;
            xs.setMaxCredit(eligibility.maxCredit);
            server.update(xs, false);
            return;
        }
        catch (SectioningException e) {
            helper.getAction().setApiException(e.getMessage());
            throw e;
        }
        catch (Exception e) {
            helper.getAction().setApiException(e.getMessage() == null ? "Null" : e.getMessage());
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(e.getMessage());
        }
        finally {
            if (resource != null) {
                if (resource.getResponse() != null) {
                    resource.getResponse().release();
                }
                resource.release();
            }
        }
    }

    protected List<CourseRequestInterface.RequestedCourse> getOverCreditRequests(CourseRequestInterface request, float maxCredit) {
        ArrayList<CourseRequestInterface.RequestedCourse> ret = new ArrayList<CourseRequestInterface.RequestedCourse>();
        float primary = 0.0f;
        for (CourseRequestInterface.Request r : request.getCourses()) {
            if (!r.hasRequestedCourse() || !r.getRequestedCourse(0).hasCredit() || !((primary += r.getRequestedCourse(0).getCreditMin().floatValue()) > maxCredit)) continue;
            ret.add(r.getRequestedCourse(0));
        }
        if (!ret.isEmpty()) {
            return ret;
        }
        for (CourseRequestInterface.Request r : request.getCourses()) {
            if (!r.hasRequestedCourse() || r.getRequestedCourse().size() <= 1) continue;
            float credit = r.getRequestedCourse(0).hasCredit() ? r.getRequestedCourse(0).getCreditMin().floatValue() : 0.0f;
            for (int i = 1; i < r.getRequestedCourse().size(); ++i) {
                float alt;
                float f = alt = r.getRequestedCourse(i).hasCredit() ? r.getRequestedCourse(i).getCreditMin().floatValue() : 0.0f;
                if (!(primary - credit + alt > maxCredit)) continue;
                ret.add(r.getRequestedCourse(i));
            }
        }
        if (!ret.isEmpty()) {
            return ret;
        }
        ArrayList<Float> credits = new ArrayList<Float>();
        float total = 0.0f;
        CourseRequestInterface.RequestedCourse last = null;
        for (CourseRequestInterface.Request r : request.getCourses()) {
            if (!r.hasRequestedCourse()) continue;
            Float credit = null;
            for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                if (!rc.hasCredit() || credit != null && !(credit.floatValue() < rc.getCreditMin().floatValue()) || !(total + (credit = rc.getCreditMin()).floatValue() > maxCredit)) continue;
                ret.add(rc);
            }
            if (credit != null) {
                credits.add(credit);
                total += credit.floatValue();
            }
            last = r.getRequestedCourse(0);
        }
        if (!ret.isEmpty()) {
            return ret;
        }
        Collections.sort(credits);
        float low = credits.isEmpty() ? 0.0f : ((Float)credits.get(0)).floatValue();
        CourseRequestInterface.RequestedCourse first = null;
        for (CourseRequestInterface.Request r : request.getAlternatives()) {
            if (!r.hasRequestedCourse()) continue;
            for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                if (!rc.hasCredit() || !(total + rc.getCreditMin().floatValue() - low > maxCredit)) continue;
                ret.add(rc);
                break;
            }
            if (first != null) continue;
            first = r.getRequestedCourse(0);
        }
        if (!ret.isEmpty()) {
            return ret;
        }
        ret.add(first != null ? first : last);
        return ret;
    }

    @Override
    public void check(OnlineSectioningServer server, OnlineSectioningHelper helper, CourseRequestInterface request) throws SectioningException {
        Float maxCredit;
        XStudent original;
        XStudent xStudent = original = request.getStudentId() == null ? null : server.getStudent(request.getStudentId());
        if (original == null) {
            return;
        }
        if (!this.isValidationEnabled(server, helper, original)) {
            return;
        }
        Integer ORD_UNITIME = 0;
        for (CourseRequestInterface.Request r : request.getCourses()) {
            Object rc;
            if (!r.hasRequestedCourse() || r.getRequestedCourse().size() != 1 || ((CourseRequestInterface.RequestedCourse)(rc = r.getRequestedCourse(0))).getCourseId() == null || ((CourseRequestInterface.RequestedCourse)rc).isReadOnly()) continue;
            request.addConfirmationMessage(((CourseRequestInterface.RequestedCourse)rc).getCourseId(), ((CourseRequestInterface.RequestedCourse)rc).getCourseName(), "NO_ALT", ApplicationProperties.getProperty("purdue.specreg.messages.courseHasNoAlt", "No alternative course provided.").replace("{course}", ((CourseRequestInterface.RequestedCourse)rc).getCourseName()), ORD_UNITIME);
        }
        String minCreditLimit = ApplicationProperties.getProperty("purdue.specreg.minCreditCheck");
        float minCredit = 0.0f;
        block1: for (CourseRequestInterface.Request r : request.getCourses()) {
            if (!r.hasRequestedCourse()) continue;
            for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                if (!rc.hasCredit()) continue;
                minCredit += rc.getCreditMin().floatValue();
                continue block1;
            }
        }
        if (minCreditLimit != null && minCredit > 0.0f && minCredit < Float.parseFloat(minCreditLimit) && (original.getMaxCredit() == null || original.getMaxCredit().floatValue() > Float.parseFloat(minCreditLimit))) {
            request.setCreditWarning(ApplicationProperties.getProperty("purdue.specreg.messages.minCredit", "Less than {min} credit hours requested.").replace("{min}", minCreditLimit).replace("{credit}", sCreditFormat.format(Float.valueOf(minCredit))));
            request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.CREDIT_LOW);
        }
        if ((maxCredit = original.getMaxCredit()) == null) {
            maxCredit = Float.valueOf(Float.parseFloat(ApplicationProperties.getProperty("purdue.specreg.maxCreditDefault", "18")));
        }
        if (maxCredit.floatValue() < request.getCredit()) {
            for (CourseRequestInterface.RequestedCourse rc : this.getOverCreditRequests(request, maxCredit.floatValue())) {
                request.addConfirmationMessage(rc.getCourseId(), rc.getCourseName(), "CREDIT", ApplicationProperties.getProperty("purdue.specreg.messages.maxCredit", "Maximum of {max} credit hours exceeded.").replace("{max}", sCreditFormat.format(maxCredit)).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit()))), null, ORD_UNITIME);
            }
            request.setCreditWarning(ApplicationProperties.getProperty("purdue.specreg.messages.maxCredit", "Maximum of {max} credit hours exceeded.").replace("{max}", sCreditFormat.format(maxCredit)).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit()))));
            request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.CREDIT_HIGH);
        }
    }

    @Override
    public boolean updateStudent(OnlineSectioningServer server, OnlineSectioningHelper helper, Student student, OnlineSectioningLog.Action.Builder action) throws SectioningException {
        return false;
    }

    @Override
    public boolean revalidateStudent(OnlineSectioningServer server, OnlineSectioningHelper helper, Student student, OnlineSectioningLog.Action.Builder action) throws SectioningException {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void validate(OnlineSectioningServer server, OnlineSectioningHelper helper, CourseRequestInterface request, CourseRequestInterface.CheckCoursesResponse response) throws SectioningException {
        Set<Integer> conf;
        void var11_23;
        void var11_21;
        boolean bl;
        XStudent original;
        XStudent xStudent = original = request.getStudentId() == null ? null : server.getStudent(request.getStudentId());
        if (original == null) {
            throw new SectioningException(MESSAGES.exceptionEnrollNotStudent(server.getAcademicSession().toString()));
        }
        if (!this.isValidationEnabled(server, helper, original)) {
            return;
        }
        Integer CONF_NONE = null;
        Integer CONF_UNITIME = 0;
        HashSet<Long> coursesWithNotAlt = new HashSet<Long>();
        for (XRequest xRequest : original.getRequests()) {
            XCourseRequest xCourseRequest;
            if (!(xRequest instanceof XCourseRequest) || (xCourseRequest = (XCourseRequest)xRequest).getCourseIds().size() != 1 || xCourseRequest.isAlternative()) continue;
            coursesWithNotAlt.add(xCourseRequest.getCourseIds().get(0).getCourseId());
        }
        boolean questionNoAlt = false;
        for (CourseRequestInterface.Request request2 : request.getCourses()) {
            CourseRequestInterface.RequestedCourse rc;
            if (!request2.hasRequestedCourse() || request2.getRequestedCourse().size() != 1 || (rc = request2.getRequestedCourse(0)).getCourseId() == null || rc.isReadOnly()) continue;
            response.addMessage(rc.getCourseId(), rc.getCourseName(), "NO_ALT", ApplicationProperties.getProperty("purdue.specreg.messages.courseHasNoAlt", "No alternative course provided.").replace("{course}", rc.getCourseName()), !coursesWithNotAlt.contains(rc.getCourseId()) ? CONF_UNITIME : CONF_NONE);
            if (coursesWithNotAlt.contains(rc.getCourseId())) continue;
            questionNoAlt = true;
        }
        boolean bl2 = false;
        for (XRequest r : original.getRequests()) {
            Object cr;
            if (!(r instanceof XCourseRequest) || !((XCourseRequest)(cr = (XCourseRequest)r)).isCritical() || ((XRequest)cr).isAlternative() || ((XCourseRequest)cr).getCourseIds().isEmpty()) continue;
            boolean hasCourse = false;
            for (XCourseId course : ((XCourseRequest)cr).getCourseIds()) {
                if (request.getRequestPriority(new CourseRequestInterface.RequestedCourse(course.getCourseId(), course.getCourseName())) == null) continue;
                hasCourse = true;
                break;
            }
            if (hasCourse) continue;
            XCourseId course = ((XCourseRequest)cr).getCourseIds().get(0);
            response.addMessage(course.getCourseId(), course.getCourseName(), "DROP_CRIT", ApplicationProperties.getProperty("purdue.specreg.messages.courseDropCrit", "Critical course has been removed.").replace("{course}", course.getCourseName()), CONF_UNITIME);
            bl = true;
        }
        Object var11_19 = null;
        Float maxCredit = original.getMaxCredit();
        if (maxCredit == null) {
            maxCredit = Float.valueOf(Float.parseFloat(ApplicationProperties.getProperty("purdue.specreg.maxCreditDefault", "18")));
        }
        if (maxCredit != null && request.getCredit() > maxCredit.floatValue()) {
            for (CourseRequestInterface.RequestedCourse rc : this.getOverCreditRequests(request, maxCredit.floatValue())) {
                response.addMessage(rc.getCourseId(), rc.getCourseName(), "CREDIT", ApplicationProperties.getProperty("purdue.specreg.messages.maxCredit", "Maximum of {max} credit hours exceeded.").replace("{max}", sCreditFormat.format(maxCredit)).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit()))), CONF_NONE);
            }
            response.setCreditWarning(ApplicationProperties.getProperty("purdue.specreg.messages.maxCredit", "Maximum of {max} credit hours exceeded.").replace("{max}", sCreditFormat.format(maxCredit)).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit()))));
            response.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.CREDIT_HIGH);
            String string = ApplicationProperties.getProperty("purdue.specreg.messages.maxCreditError", "Maximum of {max} credit hours exceeded.\nYou may not be able to get a full schedule.").replace("{max}", sCreditFormat.format(maxCredit)).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit())));
        }
        String minCreditLimit = ApplicationProperties.getProperty("purdue.specreg.minCreditCheck");
        float minCredit = 0.0f;
        block5: for (CourseRequestInterface.Request r : request.getCourses()) {
            if (!r.hasRequestedCourse()) continue;
            for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                if (!rc.hasCredit()) continue;
                minCredit += rc.getCreditMin().floatValue();
                continue block5;
            }
        }
        if (var11_21 == null && minCreditLimit != null && minCredit < Float.parseFloat(minCreditLimit) && (maxCredit == null || maxCredit.floatValue() > Float.parseFloat(minCreditLimit))) {
            String string = ApplicationProperties.getProperty("purdue.specreg.messages.minCredit", "Less than {min} credit hours requested.").replace("{min}", minCreditLimit).replace("{credit}", sCreditFormat.format(Float.valueOf(minCredit)));
            response.setCreditWarning(ApplicationProperties.getProperty("purdue.specreg.messages.minCredit", "Less than {min} credit hours requested.").replace("{min}", minCreditLimit).replace("{credit}", sCreditFormat.format(Float.valueOf(minCredit))));
            response.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.CREDIT_LOW);
        }
        if (response.getConfirms().contains(CONF_UNITIME)) {
            response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.unitimeProblemsFound", "The following issues have been detected:"), CONF_UNITIME, -1);
            response.addConfirmation("", CONF_UNITIME, 1);
        }
        if (var11_23 != null) {
            response.addConfirmation((String)var11_23, CONF_UNITIME, 2);
        }
        if (questionNoAlt) {
            response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.noAlternatives", (var11_23 != null ? "\n" : "") + "One or more of the newly requested courses have no alternatives provided. You may not be able to get a full schedule because you did not provide an alternative course."), CONF_UNITIME, 3);
        }
        if (bl) {
            response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.dropCritical", (var11_23 != null || questionNoAlt ? "\n" : "") + "One or more courses that are marked as critical in your degree plan have been removed. This may prohibit progress towards degree. Please consult with your academic advisor."), CONF_UNITIME, 4);
        }
        if (var11_23 != null || questionNoAlt || bl) {
            response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.confirmation", "\nDo you want to proceed?"), CONF_UNITIME, 5);
        }
        if ((conf = response.getConfirms()).contains(CONF_UNITIME)) {
            response.setConfirmation(CONF_UNITIME, ApplicationProperties.getProperty("purdue.specreg.confirm.unitimeDialogName", "Warning Confirmations"), ApplicationProperties.getProperty("purdue.specreg.confirm.unitimeYesButton", "Accept & Submit"), ApplicationProperties.getProperty("purdue.specreg.confirm.unitimeNoButton", "Cancel Submit"), ApplicationProperties.getProperty("purdue.specreg.confirm.unitimeYesButtonTitle", "Accept the above warning(s) and submit the Course Requests"), ApplicationProperties.getProperty("purdue.specreg.confirm.unitimeNoButtonTitle", "Go back to editing your Course Requests"));
        }
    }

    @Override
    public void submit(OnlineSectioningServer server, OnlineSectioningHelper helper, CourseRequestInterface request) throws SectioningException {
    }

    @Override
    public Collection<Long> updateStudents(OnlineSectioningServer server, OnlineSectioningHelper helper, List<Student> students) throws SectioningException {
        return null;
    }

    @Override
    public void dispose() {
        try {
            this.iClient.stop();
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

