/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.custom.purdue;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gwt.user.client.rpc.IsSerializable;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.AssignmentMap;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.extension.StudentQuality;
import org.cpsolver.studentsct.heuristics.selection.BranchBoundSelection;
import org.cpsolver.studentsct.model.Choice;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.SctAssignment;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.Subpart;
import org.cpsolver.studentsct.online.OnlineReservation;
import org.cpsolver.studentsct.online.OnlineSectioningModel;
import org.cpsolver.studentsct.online.selection.MultiCriteriaBranchAndBoundSelection;
import org.cpsolver.studentsct.online.selection.SuggestionSelection;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.restlet.Client;
import org.restlet.Context;
import org.restlet.Uniform;
import org.restlet.data.MediaType;
import org.restlet.data.Protocol;
import org.restlet.resource.ClientResource;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.base.BaseInstructionalOffering;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.CourseRequestsValidationProvider;
import org.unitime.timetable.onlinesectioning.custom.ExternalTermProvider;
import org.unitime.timetable.onlinesectioning.custom.purdue.BannerTermProvider;
import org.unitime.timetable.onlinesectioning.custom.purdue.GsonRepresentation;
import org.unitime.timetable.onlinesectioning.custom.purdue.SpecialRegistrationHelper;
import org.unitime.timetable.onlinesectioning.custom.purdue.SpecialRegistrationInterface;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XDistribution;
import org.unitime.timetable.onlinesectioning.model.XDistributionType;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XFreeTimeRequest;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XReservationType;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XSubpart;
import org.unitime.timetable.onlinesectioning.server.DatabaseServer;
import org.unitime.timetable.onlinesectioning.solver.FindAssignmentAction;
import org.unitime.timetable.onlinesectioning.updates.ReloadStudent;
import org.unitime.timetable.util.Formats;

public class PurdueCourseRequestsValidationProvider
implements CourseRequestsValidationProvider {
    private static Logger sLog = Logger.getLogger(PurdueCourseRequestsValidationProvider.class);
    protected static final StudentSectioningMessages MESSAGES = Localization.create(StudentSectioningMessages.class);
    protected static Formats.Format<Number> sCreditFormat = Formats.getNumberFormat("0.##");
    private Client iClient;
    private ExternalTermProvider iExternalTermProvider;

    public PurdueCourseRequestsValidationProvider() {
        ArrayList<Protocol> protocols = new ArrayList<Protocol>();
        protocols.add(Protocol.HTTP);
        protocols.add(Protocol.HTTPS);
        this.iClient = new Client(protocols);
        Context cx = new Context();
        cx.getParameters().add("readTimeout", this.getSpecialRegistrationApiReadTimeout());
        try {
            String clazz = ApplicationProperty.CustomizationExternalTerm.value();
            this.iExternalTermProvider = clazz == null || clazz.isEmpty() ? new BannerTermProvider() : (ExternalTermProvider)Class.forName(clazz).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            sLog.error((Object)"Failed to create external term provider, using the default one instead.", (Throwable)e);
            this.iExternalTermProvider = new BannerTermProvider();
        }
    }

    protected String getSpecialRegistrationApiSite() {
        return ApplicationProperties.getProperty("purdue.specreg.site");
    }

    protected String getSpecialRegistrationApiReadTimeout() {
        return ApplicationProperties.getProperty("purdue.specreg.readTimeout", "60000");
    }

    protected String getSpecialRegistrationApiValidationSite() {
        return ApplicationProperties.getProperty("purdue.specreg.site.validation", this.getSpecialRegistrationApiSite() + "/checkRestrictions");
    }

    protected String getSpecialRegistrationApiSiteCheckSpecialRegistrationStatus() {
        return ApplicationProperties.getProperty("purdue.specreg.site.checkSpecialRegistrationStatus", this.getSpecialRegistrationApiSite() + "/checkSpecialRegistrationStatus");
    }

    protected String getSpecialRegistrationApiSiteSubmitRegistration() {
        return ApplicationProperties.getProperty("purdue.specreg.site.submitRegistration", this.getSpecialRegistrationApiSite() + "/submitRegistration");
    }

    protected String getSpecialRegistrationApiSiteCheckEligibility() {
        return ApplicationProperties.getProperty("purdue.specreg.site.checkEligibility", this.getSpecialRegistrationApiSite() + "/checkEligibility");
    }

    protected String getSpecialRegistrationApiSiteCheckAllSpecialRegistrationStatus() {
        return ApplicationProperties.getProperty("purdue.specreg.site.checkAllSpecialRegistrationStatus", this.getSpecialRegistrationApiSite() + "/checkAllSpecialRegistrationStatus");
    }

    protected String getSpecialRegistrationDashboardUrl() {
        return ApplicationProperties.getProperty("purdue.specreg.dashBoard");
    }

    protected String getSpecialRegistrationApiKey() {
        return ApplicationProperties.getProperty("purdue.specreg.apiKey");
    }

    protected SpecialRegistrationInterface.ApiMode getSpecialRegistrationApiMode() {
        return SpecialRegistrationInterface.ApiMode.valueOf(ApplicationProperties.getProperty("purdue.specreg.mode.validation", "PREREG"));
    }

    protected boolean isIngoreLCRegistrationErrors() {
        return "true".equalsIgnoreCase(ApplicationProperties.getProperty("purdue.specreg.ignoreLCerrors", "false"));
    }

    protected boolean isCanChangeNote() {
        return "true".equalsIgnoreCase(ApplicationProperties.getProperty("purdue.specreg.canChangeNote", "true"));
    }

    protected String getBannerId(XStudent student) {
        String id = student.getExternalId();
        while (id.length() < 9) {
            id = "0" + id;
        }
        return id;
    }

    protected String getBannerId(org.unitime.timetable.model.Student student) {
        String id = student.getExternalUniqueId();
        while (id.length() < 9) {
            id = "0" + id;
        }
        return id;
    }

    protected String getRequestorId(OnlineSectioningLog.Entity user) {
        if (user == null || user.getExternalId() == null) {
            return null;
        }
        String id = user.getExternalId();
        while (id.length() < 9) {
            id = "0" + id;
        }
        return id;
    }

    protected SpecialRegistrationInterface.RequestorRole getRequestorType(OnlineSectioningLog.Entity user, XStudent student) {
        if (user == null || user.getExternalId() == null) {
            return null;
        }
        if (student != null) {
            return user.getExternalId().equals(student.getExternalId()) ? SpecialRegistrationInterface.RequestorRole.STUDENT : SpecialRegistrationInterface.RequestorRole.MANAGER;
        }
        if (user.hasType()) {
            switch (user.getType()) {
                case MANAGER: {
                    return SpecialRegistrationInterface.RequestorRole.MANAGER;
                }
                case STUDENT: {
                    return SpecialRegistrationInterface.RequestorRole.STUDENT;
                }
            }
            return SpecialRegistrationInterface.RequestorRole.MANAGER;
        }
        return null;
    }

    protected String getBannerTerm(AcademicSessionInfo session) {
        return this.iExternalTermProvider.getExternalTerm(session);
    }

    protected String getBannerCampus(AcademicSessionInfo session) {
        return this.iExternalTermProvider.getExternalCampus(session);
    }

    protected String getCRN(Section section, Course course) {
        String name = section.getName(course.getId());
        if (name != null && name.indexOf(45) >= 0) {
            return name.substring(0, name.indexOf(45));
        }
        return name;
    }

    protected Enrollment firstEnrollment(CourseRequest request, Assignment<Request, Enrollment> assignment, Course course, Config config, HashSet<Section> sections, int idx) {
        if (config.getSubparts().size() == idx) {
            return new Enrollment((Request)request, request.getCourses().indexOf(course), null, config, new HashSet<Section>(sections), null);
        }
        Subpart subpart = (Subpart)config.getSubparts().get(idx);
        List sectionsThisSubpart = subpart.getSections();
        ArrayList<Section> matchingSectionsThisSubpart = new ArrayList<Section>(subpart.getSections().size());
        for (Section section : sectionsThisSubpart) {
            if (section.isCancelled() || section.getParent() != null && !sections.contains(section.getParent()) || section.isOverlapping(sections)) continue;
            matchingSectionsThisSubpart.add(section);
        }
        for (Section section : matchingSectionsThisSubpart) {
            sections.add(section);
            Enrollment e = this.firstEnrollment(request, assignment, course, config, sections, idx + 1);
            if (e != null) {
                return e;
            }
            sections.remove(section);
        }
        return null;
    }

    protected Gson getGson(OnlineSectioningHelper helper) {
        GsonBuilder builder = new GsonBuilder().registerTypeAdapter(DateTime.class, (Object)new JsonSerializer<DateTime>(){

            public JsonElement serialize(DateTime src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(src.toString("yyyy-MM-dd'T'HH:mm:ss'Z'"));
            }
        }).registerTypeAdapter(DateTime.class, (Object)new JsonDeserializer<DateTime>(){

            public DateTime deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return new DateTime((Object)json.getAsJsonPrimitive().getAsString(), DateTimeZone.UTC);
            }
        }).registerTypeAdapter(Date.class, (Object)new JsonSerializer<Date>(){

            public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(src));
            }
        }).registerTypeAdapter(Date.class, (Object)new JsonDeserializer<Date>(){

            public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                try {
                    return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(json.getAsJsonPrimitive().getAsString());
                }
                catch (ParseException e) {
                    throw new JsonParseException(e.getMessage(), (Throwable)e);
                }
            }
        });
        if (helper.isDebugEnabled()) {
            builder.setPrettyPrinting();
        }
        return builder.create();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void validate(OnlineSectioningServer server, OnlineSectioningHelper helper, CourseRequestInterface request, CourseRequestInterface.CheckCoursesResponse response) throws SectioningException {
        Set<Integer> set;
        boolean bl;
        boolean bl2;
        XCourse c;
        CourseRequestInterface.RequestedCourseStatus status;
        Object course;
        XCourseRequest cr;
        XStudent original;
        XStudent xStudent = original = request.getStudentId() == null ? null : server.getStudent(request.getStudentId());
        if (original == null) {
            throw new SectioningException(MESSAGES.exceptionEnrollNotStudent(server.getAcademicSession().toString()));
        }
        if (!this.isValidationEnabled(server, helper, original)) {
            return;
        }
        Integer CONF_NONE = null;
        Integer CONF_UNITIME = new Integer(0);
        Integer CONF_BANNER = new Integer(1);
        OnlineSectioningModel model = new OnlineSectioningModel(server.getConfig(), server.getOverExpectedCriterion());
        boolean linkedClassesMustBeUsed = server.getConfig().getPropertyBoolean("LinkedClasses.mustBeUsed", false);
        AssignmentMap assignment = new AssignmentMap();
        Student student = new Student(request.getStudentId().longValue());
        student.setExternalId(original.getExternalId());
        student.setName(original.getName());
        student.setNeedShortDistances(original.hasAccomodation(server.getDistanceMetric().getShortDistanceAccommodationReference()));
        student.setAllowDisabled(original.isAllowDisabled());
        HashMap<Long, Section> classTable = new HashMap<Long, Section>();
        HashSet<XDistribution> distributions = new HashSet<XDistribution>();
        Hashtable preferredSections = new Hashtable();
        boolean hasAssignment = false;
        for (XRequest reqest : original.getRequests()) {
            if (!(reqest instanceof XCourseRequest) || ((XCourseRequest)reqest).getEnrollment() == null) continue;
            hasAssignment = true;
            break;
        }
        for (CourseRequestInterface.Request c2 : request.getCourses()) {
            FindAssignmentAction.addRequest(server, (StudentSectioningModel)model, (Assignment<Request, Enrollment>)assignment, student, original, c2, false, false, classTable, distributions, hasAssignment);
        }
        for (CourseRequestInterface.Request c2 : request.getAlternatives()) {
            FindAssignmentAction.addRequest(server, (StudentSectioningModel)model, (Assignment<Request, Enrollment>)assignment, student, original, c2, true, false, classTable, distributions, hasAssignment);
        }
        HashSet<XCourseId> lcCourses = new HashSet<XCourseId>();
        HashSet<XCourseId> fixedCourses = new HashSet<XCourseId>();
        boolean ignoreLcCourses = this.isIngoreLCRegistrationErrors();
        for (XRequest r : original.getRequests()) {
            if (!(r instanceof XCourseRequest)) continue;
            cr = (XCourseRequest)r;
            XEnrollment en = cr.getEnrollment();
            if (en != null) {
                for (Request q : student.getRequests()) {
                    Course course2;
                    if (!(q instanceof CourseRequest) || (course2 = ((CourseRequest)q).getCourse(en.getCourseId().longValue())) == null) continue;
                    Iterator sections = new HashSet<Section>();
                    for (Long sectionId : en.getSectionIds()) {
                        Section section = course2.getOffering().getSection(sectionId.longValue());
                        if (section == null) continue;
                        sections.add(section);
                    }
                    if (sections.isEmpty()) continue;
                    preferredSections.put((CourseRequest)q, sections);
                }
            }
            for (XCourseId course3 : cr.getCourseIds()) {
                XOffering offering = server.getOffering(course3.getOfferingId());
                if (offering != null && offering.hasLearningCommunityReservation(original, course3)) {
                    lcCourses.add(course3);
                }
                if (offering == null || !offering.hasIndividualReservation(original, course3) && !offering.hasGroupReservation(original, course3)) continue;
                fixedCourses.add(course3);
            }
        }
        model.addStudent(student);
        model.setStudentQuality(new StudentQuality(server.getDistanceMetric(), model.getProperties()));
        for (XDistribution link : distributions) {
            if (link.getDistributionType() != XDistributionType.LinkedSections) continue;
            ArrayList<Section> sections = new ArrayList<Section>();
            for (Long sectionId : link.getSectionIds()) {
                Section x = (Section)classTable.get(sectionId);
                if (x == null) continue;
                sections.add(x);
            }
            if (sections.size() < 2) continue;
            model.addLinkedSections(linkedClassesMustBeUsed, sections);
        }
        if ("true".equalsIgnoreCase(ApplicationProperties.getProperty("purdue.specreg.dummyReservation", "false"))) {
            for (XRequest r : student.getRequests()) {
                if (!(r instanceof CourseRequest)) continue;
                cr = (CourseRequest)r;
                for (Course course4 : cr.getCourses()) {
                    new OnlineReservation(XReservationType.Dummy.ordinal(), -3L, course4.getOffering(), 5000, true, 1, true, true, true, true, true);
                }
            }
        }
        boolean questionTimeConflict = false;
        HashMap<Section, Course> singleSections = new HashMap<Section, Course>();
        for (Request r : student.getRequests()) {
            if (r.isAlternative() || !(r instanceof CourseRequest)) continue;
            CourseRequest cr2 = (CourseRequest)r;
            for (Course course2 : cr2.getCourses()) {
                if (course2.getOffering().getConfigs().size() != 1) continue;
                for (Subpart subpart : ((Config)course2.getOffering().getConfigs().get(0)).getSubparts()) {
                    if (subpart.getSections().size() != 1) continue;
                    Section section = (Section)subpart.getSections().get(0);
                    for (Object other : singleSections.keySet()) {
                        if (!section.isOverlapping((SctAssignment)other)) continue;
                        boolean confirm = (original.getRequestForCourse(course2.getId()) == null || original.getRequestForCourse(((Course)singleSections.get(other)).getId()) == null) && cr2.getCourses().size() == 1;
                        response.addMessage(course2.getId(), course2.getName(), "OVERLAP", ApplicationProperties.getProperty("purdue.specreg.messages.courseOverlaps", "Conflicts with {other}.").replace("{course}", course2.getName()).replace("{other}", ((Course)singleSections.get(other)).getName()), confirm ? CONF_UNITIME : CONF_NONE);
                        if (!confirm) continue;
                        questionTimeConflict = true;
                    }
                    if (cr2.getCourses().size() != 1) continue;
                    singleSections.put(section, course2);
                }
            }
        }
        Object selection = null;
        selection = server.getConfig().getPropertyBoolean("StudentWeights.MultiCriteria", true) ? new MultiCriteriaBranchAndBoundSelection(server.getConfig()) : new SuggestionSelection(server.getConfig());
        selection.setModel(model);
        if ("true".equalsIgnoreCase(ApplicationProperties.getProperty("purdue.specreg.fixCurrentEnrollments", "false"))) {
            selection.setPreferredSections(new Hashtable());
            selection.setRequiredSections(preferredSections);
        } else {
            selection.setPreferredSections(preferredSections);
            selection.setRequiredSections(new Hashtable());
        }
        selection.setRequiredFreeTimes(new HashSet());
        selection.setRequiredUnassinged(new HashSet());
        BranchBoundSelection.BranchBoundNeighbour neighbour = selection.select((Assignment)assignment, student);
        neighbour.assign((Assignment)assignment, 0L);
        SpecialRegistrationInterface.CheckRestrictionsRequest req = new SpecialRegistrationInterface.CheckRestrictionsRequest();
        req.studentId = this.getBannerId(original);
        req.term = this.getBannerTerm(server.getAcademicSession());
        req.campus = this.getBannerCampus(server.getAcademicSession());
        req.mode = this.getSpecialRegistrationApiMode();
        HashMap<Object, XCourseId> crn2course = new HashMap<Object, XCourseId>();
        HashMap<XCourseId, String> course2banner = new HashMap<XCourseId, String>();
        for (Request r : model.variables()) {
            if (!(r instanceof CourseRequest)) continue;
            CourseRequest cr3 = (CourseRequest)r;
            Enrollment e = (Enrollment)assignment.getValue((Variable)cr3);
            block22: for (Course course5 : cr3.getCourses()) {
                XCourseId cid = new XCourseId(course5);
                course2banner.put(cid, course5.getSubjectArea() + " " + course5.getCourseNumber());
                if (e != null && course5.equals((Object)e.getCourse())) {
                    for (Section section : e.getSections()) {
                        String crn = this.getCRN(section, course5);
                        crn2course.put(crn, cid);
                        SpecialRegistrationHelper.addCrn(req, crn);
                    }
                    continue;
                }
                for (Enrollment x : cr3.values((Assignment)assignment)) {
                    if (!course5.equals((Object)x.getCourse())) continue;
                    for (Section section : x.getSections()) {
                        String crn = this.getCRN(section, course5);
                        crn2course.put(crn, cid);
                        SpecialRegistrationHelper.addAltCrn(req, crn);
                    }
                    continue block22;
                }
                for (Config config : course5.getOffering().getConfigs()) {
                    Enrollment x = this.firstEnrollment(cr3, (Assignment<Request, Enrollment>)assignment, course5, config, new HashSet<Section>(), 0);
                    if (x == null) continue;
                    for (Section section2 : x.getSections()) {
                        String crn = this.getCRN(section2, course5);
                        crn2course.put(crn, cid);
                        SpecialRegistrationHelper.addAltCrn(req, crn);
                    }
                    continue block22;
                }
            }
        }
        if (SpecialRegistrationHelper.isEmpty(req)) {
            return;
        }
        if (req.changes == null) {
            req.changes = new SpecialRegistrationInterface.RestrictionsCheckRequest();
        }
        SpecialRegistrationInterface.CheckRestrictionsResponse resp = null;
        ClientResource resource = null;
        try {
            resource = new ClientResource(this.getSpecialRegistrationApiValidationSite());
            resource.setNext((Uniform)this.iClient);
            resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
            Gson gson = this.getGson(helper);
            if (helper.isDebugEnabled()) {
                helper.debug("Request: " + gson.toJson((Object)req));
            }
            helper.getAction().addOptionBuilder().setKey("validation_request").setValue(gson.toJson((Object)req));
            long t1 = System.currentTimeMillis();
            resource.post(new GsonRepresentation<SpecialRegistrationInterface.CheckRestrictionsRequest>(req));
            helper.getAction().setApiPostTime(System.currentTimeMillis() - t1);
            resp = new GsonRepresentation<SpecialRegistrationInterface.CheckRestrictionsResponse>(resource.getResponseEntity(), SpecialRegistrationInterface.CheckRestrictionsResponse.class).getObject();
            if (helper.isDebugEnabled()) {
                helper.debug("Response: " + gson.toJson((Object)resp));
            }
            helper.getAction().addOptionBuilder().setKey("validation_response").setValue(gson.toJson((Object)resp));
            if (SpecialRegistrationInterface.ResponseStatus.success != resp.status) {
                throw new SectioningException(resp.message == null || resp.message.isEmpty() ? "Failed to check student eligibility (" + (Object)((Object)resp.status) + ")." : resp.message);
            }
        }
        catch (SectioningException e) {
            helper.getAction().setApiException(e.getMessage());
            throw e;
        }
        catch (Exception e) {
            helper.getAction().setApiException(e.getMessage());
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(e.getMessage());
        }
        finally {
            if (resource != null) {
                if (resource.getResponse() != null) {
                    resource.getResponse().release();
                }
                resource.release();
            }
        }
        Float maxCredit = resp.maxCredit;
        if (maxCredit == null) {
            maxCredit = Float.valueOf(Float.parseFloat(ApplicationProperties.getProperty("purdue.specreg.maxCreditDefault", "18")));
        }
        Float maxCreditDenied = null;
        if (resp.deniedMaxCreditRequests != null) {
            for (SpecialRegistrationInterface.DeniedMaxCredit r : resp.deniedMaxCreditRequests) {
                if (r.mode != req.mode || r.maxCredit == null || !(r.maxCredit.floatValue() > maxCredit.floatValue()) || maxCreditDenied != null && !(maxCreditDenied.floatValue() > r.maxCredit.floatValue())) continue;
                maxCreditDenied = r.maxCredit;
            }
        }
        HashMap overrides = new HashMap();
        Float maxCreditOverride = null;
        CourseRequestInterface.RequestedCourseStatus maxCreditOverrideStatus = null;
        if (resp.cancelRegistrationRequests != null) {
            for (SpecialRegistrationInterface.SpecialRegistration r : resp.cancelRegistrationRequests) {
                if (r.changes == null || r.changes.isEmpty()) continue;
                for (SpecialRegistrationInterface.Change change : r.changes) {
                    if (change.status == SpecialRegistrationInterface.ChangeStatus.cancelled || change.status == SpecialRegistrationInterface.ChangeStatus.denied) continue;
                    if (change.subject != null && change.courseNbr != null) {
                        String course6 = change.subject + " " + change.courseNbr;
                        HashMap<String, CourseRequestInterface.RequestedCourseStatus> problems2 = (HashMap<String, CourseRequestInterface.RequestedCourseStatus>)overrides.get(course6);
                        if (problems2 == null) {
                            problems2 = new HashMap<String, CourseRequestInterface.RequestedCourseStatus>();
                            overrides.put(course6, problems2);
                        }
                        if (change.errors == null) continue;
                        for (SpecialRegistrationInterface.ChangeError changeError : change.errors) {
                            if (changeError.code == null) continue;
                            problems2.put(changeError.code, this.status(change.status));
                        }
                        continue;
                    }
                    if (r.maxCredit == null || maxCreditOverride != null && !(maxCreditOverride.floatValue() < r.maxCredit.floatValue())) continue;
                    maxCreditOverride = r.maxCredit;
                    maxCreditOverrideStatus = this.status(change.status);
                }
            }
        }
        String creditError = null;
        String maxCreditLimitStr = ApplicationProperties.getProperty("purdue.specreg.maxCreditCheck");
        if (maxCreditDenied != null && request.getCredit() >= maxCreditDenied.floatValue()) {
            for (CourseRequestInterface.RequestedCourse requestedCourse : this.getOverCreditRequests(request, maxCredit.floatValue())) {
                response.addMessage(requestedCourse.getCourseId(), requestedCourse.getCourseName(), "CREDIT", ApplicationProperties.getProperty("purdue.specreg.messages.maxCredit", "Maximum of {max} credit hours exceeded.").replace("{max}", sCreditFormat.format(maxCredit)).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit()))), CONF_NONE);
            }
            response.setCreditWarning(ApplicationProperties.getProperty("purdue.specreg.messages.maxCredit", "Maximum of {max} credit hours exceeded.").replace("{max}", sCreditFormat.format(maxCredit)).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit()))).replace("{maxCreditDenied}", sCreditFormat.format(maxCreditDenied)));
            response.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED);
            creditError = ApplicationProperties.getProperty("purdue.specreg.messages.maxCreditDeniedError", "Maximum of {max} credit hours exceeded.\nThe request to increase the maximum credit hours to {maxCreditDenied} has been denied.\nYou may not be able to get a full schedule.").replace("{max}", sCreditFormat.format(maxCredit)).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit()))).replace("{maxCreditDenied}", sCreditFormat.format(maxCreditDenied));
        } else if (maxCreditLimitStr != null) {
            float maxCreditLimit = Float.parseFloat(maxCreditLimitStr);
            if (maxCredit != null && maxCredit.floatValue() > maxCreditLimit) {
                maxCreditLimit = maxCredit.floatValue();
            }
            if (request.getCredit() > maxCreditLimit) {
                for (CourseRequestInterface.RequestedCourse rc : this.getOverCreditRequests(request, maxCreditLimit)) {
                    response.addMessage(rc.getCourseId(), rc.getCourseName(), "CREDIT", ApplicationProperties.getProperty("purdue.specreg.messages.maxCredit", "Maximum of {max} credit hours exceeded.").replace("{max}", sCreditFormat.format(Float.valueOf(maxCreditLimit))).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit()))), CONF_NONE);
                }
                response.setCreditWarning(ApplicationProperties.getProperty("purdue.specreg.messages.maxCredit", "Maximum of {max} credit hours exceeded.").replace("{max}", sCreditFormat.format(Float.valueOf(maxCreditLimit))).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit()))));
                response.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.CREDIT_HIGH);
                creditError = ApplicationProperties.getProperty("purdue.specreg.messages.maxCreditError", "Maximum of {max} credit hours exceeded.\nYou may not be able to get a full schedule.").replace("{max}", sCreditFormat.format(Float.valueOf(maxCreditLimit))).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit())));
            }
        }
        if (creditError == null && maxCredit.floatValue() < request.getCredit()) {
            for (CourseRequestInterface.RequestedCourse requestedCourse : this.getOverCreditRequests(request, maxCredit.floatValue())) {
                response.addMessage(requestedCourse.getCourseId(), requestedCourse.getCourseName(), "CREDIT", ApplicationProperties.getProperty("purdue.specreg.messages.maxCredit", "Maximum of {max} credit hours exceeded.").replace("{max}", sCreditFormat.format(maxCredit)).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit()))), maxCreditOverride == null || maxCreditOverride.floatValue() < request.getCredit() ? CONF_BANNER : CONF_NONE);
            }
            response.setCreditWarning(ApplicationProperties.getProperty("purdue.specreg.messages.maxCredit", "Maximum of {max} credit hours exceeded.").replace("{max}", sCreditFormat.format(maxCredit)).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit()))));
            response.setMaxCreditOverrideStatus(maxCreditOverrideStatus == null || maxCreditOverride.floatValue() < request.getCredit() ? CourseRequestInterface.RequestedCourseStatus.OVERRIDE_NEEDED : maxCreditOverrideStatus);
        }
        HashMap deniedOverrides = new HashMap();
        if (resp.deniedRequests != null) {
            for (SpecialRegistrationInterface.DeniedRequest r : resp.deniedRequests) {
                void var40_77;
                if (r.mode != req.mode) continue;
                course = r.subject + " " + r.courseNbr;
                Set set2 = (Set)deniedOverrides.get(course);
                if (set2 == null) {
                    TreeSet treeSet = new TreeSet();
                    deniedOverrides.put(course, treeSet);
                }
                var40_77.add(r.code);
            }
        }
        if (resp.outJson != null && resp.outJson.message != null && resp.outJson.status != null && resp.outJson.status != SpecialRegistrationInterface.ResponseStatus.success) {
            response.addError(null, null, "Failure", resp.outJson.message);
            response.setErrorMessage(resp.outJson.message);
        } else if (resp.outJsonAlternatives != null && resp.outJsonAlternatives.message != null && resp.outJsonAlternatives.status != null && resp.outJsonAlternatives.status != SpecialRegistrationInterface.ResponseStatus.success) {
            response.addError(null, null, "Failure", resp.outJsonAlternatives.message);
            response.setErrorMessage(resp.outJsonAlternatives.message);
        }
        if (resp.outJson != null && resp.outJson.problems != null) {
            for (SpecialRegistrationInterface.Problem problem : resp.outJson.problems) {
                Set set3;
                if ("HOLD".equals(problem.code)) {
                    response.addError(null, null, problem.code, problem.message);
                    response.setErrorMessage(ApplicationProperties.getProperty("purdue.specreg.messages.holdError", problem.message));
                }
                if ("DUPL".equals(problem.code) || "MAXI".equals(problem.code) || "CLOS".equals(problem.code) || "TIME".equals(problem.code) || (course = (XCourseId)crn2course.get(problem.crn)) == null || ignoreLcCourses && lcCourses.contains(course)) continue;
                String string = (String)course2banner.get(course);
                Map map = string == null ? null : (Map)overrides.get(string);
                Set set4 = set3 = string == null ? null : (Set)deniedOverrides.get(string);
                if (set3 != null && set3.contains(problem.code)) {
                    if (fixedCourses.contains(course)) {
                        response.addMessage(((XCourseId)course).getCourseId(), ((XCourseId)course).getCourseName(), problem.code, "Denied " + problem.message, CONF_NONE).setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED);
                        continue;
                    }
                    response.addError(((XCourseId)course).getCourseId(), ((XCourseId)course).getCourseName(), problem.code, "Denied " + problem.message).setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED);
                    response.setErrorMessage(ApplicationProperties.getProperty("purdue.specreg.messages.deniedOverrideError", "One or more courses require registration overrides which have been denied.\nYou must remove or replace these courses in order to submit your registration request."));
                    continue;
                }
                CourseRequestInterface.RequestedCourseStatus requestedCourseStatus = status = map == null ? null : (CourseRequestInterface.RequestedCourseStatus)map.get(problem.code);
                if (status == null) {
                    if (resp.overrides != null && !resp.overrides.contains(problem.code)) {
                        response.addError(((XCourseId)course).getCourseId(), ((XCourseId)course).getCourseName(), problem.code, "Not Allowed " + problem.message).setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED);
                        continue;
                    }
                    XCourse xCourse = c = course instanceof XCourse ? (XCourse)course : server.getCourse(((XCourseId)course).getCourseId());
                    if (c != null && !c.isOverrideEnabled(problem.code)) {
                        response.addError(((XCourseId)course).getCourseId(), ((XCourseId)course).getCourseName(), problem.code, "Not Allowed " + problem.message).setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED);
                        continue;
                    }
                }
                response.addMessage(((XCourseId)course).getCourseId(), ((XCourseId)course).getCourseName(), problem.code, problem.message, status == null ? CONF_BANNER : CONF_NONE).setStatus(status == null ? CourseRequestInterface.RequestedCourseStatus.OVERRIDE_NEEDED : status);
            }
        }
        if (resp.outJsonAlternatives != null && resp.outJsonAlternatives.problems != null) {
            for (SpecialRegistrationInterface.Problem problem : resp.outJsonAlternatives.problems) {
                Set set5;
                if ("HOLD".equals(problem.code)) {
                    response.addError(null, null, problem.code, problem.message);
                    response.setErrorMessage(ApplicationProperties.getProperty("purdue.specreg.messages.holdError", problem.message));
                }
                if ("DUPL".equals(problem.code) || "MAXI".equals(problem.code) || "CLOS".equals(problem.code) || "TIME".equals(problem.code) || (course = (XCourseId)crn2course.get(problem.crn)) == null || ignoreLcCourses && lcCourses.contains(course)) continue;
                String string = (String)course2banner.get(course);
                Map map = string == null ? null : (Map)overrides.get(string);
                Set set6 = set5 = string == null ? null : (Set)deniedOverrides.get(string);
                if (set5 != null && set5.contains(problem.code)) {
                    if (fixedCourses.contains(course)) {
                        response.addMessage(((XCourseId)course).getCourseId(), ((XCourseId)course).getCourseName(), problem.code, "Denied " + problem.message, CONF_NONE).setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED);
                        continue;
                    }
                    response.addError(((XCourseId)course).getCourseId(), ((XCourseId)course).getCourseName(), problem.code, "Denied " + problem.message).setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED);
                    response.setErrorMessage(ApplicationProperties.getProperty("purdue.specreg.messages.deniedOverrideError", "One or more courses require registration overrides which have been denied.\nYou must remove or replace these courses in order to submit your registration request."));
                    continue;
                }
                CourseRequestInterface.RequestedCourseStatus requestedCourseStatus = status = map == null ? null : (CourseRequestInterface.RequestedCourseStatus)map.get(problem.code);
                if (status == null) {
                    if (resp.overrides != null && !resp.overrides.contains(problem.code)) {
                        response.addError(((XCourseId)course).getCourseId(), ((XCourseId)course).getCourseName(), problem.code, "Not Allowed " + problem.message).setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED);
                        continue;
                    }
                    XCourse xCourse = c = course instanceof XCourse ? (XCourse)course : server.getCourse(((XCourseId)course).getCourseId());
                    if (c != null && !c.isOverrideEnabled(problem.code)) {
                        response.addError(((XCourseId)course).getCourseId(), ((XCourseId)course).getCourseName(), problem.code, "Not Allowed " + problem.message).setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED);
                        continue;
                    }
                }
                response.addMessage(((XCourseId)course).getCourseId(), ((XCourseId)course).getCourseName(), problem.code, problem.message, status == null ? CONF_BANNER : CONF_NONE).setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING).setStatus(status == null ? CourseRequestInterface.RequestedCourseStatus.OVERRIDE_NEEDED : status);
            }
        }
        if (response.hasMessages()) {
            for (CourseRequestInterface.CourseMessage m : response.getMessages()) {
                if (m.getCourse() != null && m.getMessage().indexOf("this section") >= 0) {
                    m.setMessage(m.getMessage().replace("this section", m.getCourse()));
                }
                if (m.getCourse() == null || m.getMessage().indexOf(" (CRN ") < 0) continue;
                m.setMessage(m.getMessage().replaceFirst(" \\(CRN [0-9][0-9][0-9][0-9][0-9]\\) ", " "));
            }
        }
        String string = ApplicationProperties.getProperty("purdue.specreg.minCreditCheck");
        float minCredit = 0.0f;
        block39: for (CourseRequestInterface.Request request2 : request.getCourses()) {
            if (!request2.hasRequestedCourse()) continue;
            for (CourseRequestInterface.RequestedCourse requestedCourse : request2.getRequestedCourse()) {
                if (!requestedCourse.hasCredit()) continue;
                minCredit += requestedCourse.getCreditMin().floatValue();
                continue block39;
            }
        }
        if (creditError == null && string != null && minCredit < Float.parseFloat(string) && (maxCredit == null || maxCredit.floatValue() > Float.parseFloat(string))) {
            creditError = ApplicationProperties.getProperty("purdue.specreg.messages.minCredit", "Less than {min} credit hours requested.").replace("{min}", string).replace("{credit}", sCreditFormat.format(Float.valueOf(minCredit)));
            response.setCreditWarning(ApplicationProperties.getProperty("purdue.specreg.messages.minCredit", "Less than {min} credit hours requested.").replace("{min}", string).replace("{credit}", sCreditFormat.format(Float.valueOf(minCredit))));
            response.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.CREDIT_LOW);
        }
        HashSet<Long> coursesWithNotAlt = new HashSet<Long>();
        for (XRequest xRequest : original.getRequests()) {
            XCourseRequest xCourseRequest;
            if (!(xRequest instanceof XCourseRequest) || (xCourseRequest = (XCourseRequest)xRequest).getCourseIds().size() != 1 || xCourseRequest.isAlternative()) continue;
            coursesWithNotAlt.add(xCourseRequest.getCourseIds().get(0).getCourseId());
        }
        boolean bl3 = false;
        for (CourseRequestInterface.Request request3 : request.getCourses()) {
            CourseRequestInterface.RequestedCourse rc;
            if (!request3.hasRequestedCourse() || request3.getRequestedCourse().size() != 1 || (rc = request3.getRequestedCourse(0)).getCourseId() == null || rc.isReadOnly()) continue;
            response.addMessage(rc.getCourseId(), rc.getCourseName(), "NO_ALT", ApplicationProperties.getProperty("purdue.specreg.messages.courseHasNoAlt", "No alternative course provided.").replace("{course}", rc.getCourseName()), !coursesWithNotAlt.contains(rc.getCourseId()) ? CONF_UNITIME : CONF_NONE);
            if (coursesWithNotAlt.contains(rc.getCourseId())) continue;
            bl2 = true;
        }
        boolean bl4 = false;
        for (XRequest r : original.getRequests()) {
            XCourseRequest cr5;
            if (!(r instanceof XCourseRequest) || !(cr5 = (XCourseRequest)r).isCritical() || cr5.isAlternative() || cr5.getCourseIds().isEmpty()) continue;
            boolean hasCourse = false;
            for (XCourseId course7 : cr5.getCourseIds()) {
                if (request.getRequestPriority(new CourseRequestInterface.RequestedCourse(course7.getCourseId(), course7.getCourseName())) == null) continue;
                hasCourse = true;
                break;
            }
            if (hasCourse) continue;
            XCourseId course8 = cr5.getCourseIds().get(0);
            response.addMessage(course8.getCourseId(), course8.getCourseName(), "DROP_CRIT", ApplicationProperties.getProperty("purdue.specreg.messages.courseDropCrit", "Critical course has been removed.").replace("{course}", course8.getCourseName()), CONF_UNITIME);
            bl = true;
        }
        if (response.getConfirms().contains(CONF_BANNER)) {
            response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.bannerProblemsFound", "The following registration errors have been detected:"), CONF_BANNER, -1);
            String string2 = ApplicationProperties.getProperty("purdue.specreg.messages.courseRequestNote", "<b>Request Note:</b>");
            int idx = 1;
            if (string2 != null && !string2.isEmpty()) {
                response.addConfirmation(string2, CONF_BANNER, idx++);
                response.addConfirmation("", CONF_BANNER, idx++).setCode("REQUEST_NOTE");
            }
            response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.requestOverrides", "\nIf you have already discussed these courses with your advisor and were advised to request registration in them please select Request Overrides & Submit. If you aren\u2019t sure, click Cancel Submit and consult with your advisor before coming back to your Course Request page."), CONF_BANNER, idx++);
        }
        if (response.getConfirms().contains(CONF_UNITIME)) {
            response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.unitimeProblemsFound", "The following issues have been detected:"), CONF_UNITIME, -1);
            response.addConfirmation("", CONF_UNITIME, 1);
        }
        if (creditError != null) {
            response.addConfirmation(creditError, CONF_UNITIME, 2);
        }
        if (bl2) {
            response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.noAlternatives", (creditError != null ? "\n" : "") + "One or more of the newly requested courses have no alternatives provided. You may not be able to get a full schedule because you did not provide an alternative course."), CONF_UNITIME, 3);
        }
        if (questionTimeConflict) {
            response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.timeConflicts", (creditError != null || bl2 ? "\n" : "") + "Two or more single section courses are conflicting with each other. You will likely not be able to get the conflicting course, so please provide an alternative course if possible."), CONF_UNITIME, 4);
        }
        if (bl) {
            response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.dropCritical", (creditError != null || bl2 || bl ? "\n" : "") + "One or more courses that are marked as critical in your degree plan have been removed. This may prohibit progress towards degree. Please consult with your academic advisor."), CONF_UNITIME, 5);
        }
        if (creditError != null || bl2 || questionTimeConflict) {
            response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.confirmation", "\nDo you want to proceed?"), CONF_UNITIME, 6);
        }
        if ((set = response.getConfirms()).contains(CONF_UNITIME)) {
            response.setConfirmation(CONF_UNITIME, ApplicationProperties.getProperty("purdue.specreg.confirm.unitimeDialogName", "Warning Confirmations"), set.contains(CONF_BANNER) ? ApplicationProperties.getProperty("purdue.specreg.confirm.unitimeContinueButton", "Accept & Continue") : ApplicationProperties.getProperty("purdue.specreg.confirm.unitimeYesButton", "Accept & Submit"), ApplicationProperties.getProperty("purdue.specreg.confirm.unitimeNoButton", "Cancel Submit"), set.contains(CONF_BANNER) ? ApplicationProperties.getProperty("purdue.specreg.confirm.unitimeContinueButtonTitle", "Accept the above warning(s) and continue to submit the Course Requests") : ApplicationProperties.getProperty("purdue.specreg.confirm.unitimeYesButtonTitle", "Accept the above warning(s) and submit the Course Requests"), ApplicationProperties.getProperty("purdue.specreg.confirm.unitimeNoButtonTitle", "Go back to editing your Course Requests"));
        }
        if (set.contains(CONF_BANNER)) {
            response.setConfirmation(CONF_BANNER, ApplicationProperties.getProperty("purdue.specreg.confirm.bannerDialogName", "Request Overrides"), ApplicationProperties.getProperty("purdue.specreg.confirm.bannerYesButton", "Request Overrides & Submit"), ApplicationProperties.getProperty("purdue.specreg.confirm.bannerNoButton", "Cancel Submit"), ApplicationProperties.getProperty("purdue.specreg.confirm.bannerYesButtonTitle", "Request overrides for the above registration errors and submit the Course Requests"), ApplicationProperties.getProperty("purdue.specreg.confirm.bannerNoButtonTitle", "Go back to editing your Course Requests"));
        }
    }

    @Override
    public void dispose() {
        try {
            this.iClient.stop();
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void submit(OnlineSectioningServer server, OnlineSectioningHelper helper, CourseRequestInterface request) throws SectioningException {
        XCourse course;
        XCourseId cid;
        SpecialRegistrationInterface.CourseCredit cc;
        float maxCreditLimit;
        XStudent original;
        XStudent xStudent = original = request.getStudentId() == null ? null : server.getStudent(request.getStudentId());
        if (original == null) {
            return;
        }
        if (!this.isValidationEnabled(server, helper, original)) {
            return;
        }
        request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.SAVED);
        String minCreditLimit = ApplicationProperties.getProperty("purdue.specreg.minCreditCheck");
        float minCredit = 0.0f;
        block12: for (CourseRequestInterface.Request r : request.getCourses()) {
            if (!r.hasRequestedCourse()) continue;
            for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                if (!rc.hasCredit()) continue;
                minCredit += rc.getCreditMin().floatValue();
                continue block12;
            }
        }
        if (minCreditLimit != null && minCredit < Float.parseFloat(minCreditLimit) && (original.getMaxCredit() == null || original.getMaxCredit().floatValue() > Float.parseFloat(minCreditLimit))) {
            request.setCreditWarning(ApplicationProperties.getProperty("purdue.specreg.messages.minCredit", "Less than {min} credit hours requested.").replace("{min}", minCreditLimit).replace("{credit}", sCreditFormat.format(Float.valueOf(minCredit))));
            request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.CREDIT_LOW);
        }
        ClientResource resource = null;
        HashMap overrides = new HashMap();
        Float maxCredit = null;
        try {
            resource = new ClientResource(this.getSpecialRegistrationApiSiteCheckSpecialRegistrationStatus());
            resource.setNext((Uniform)this.iClient);
            AcademicSessionInfo session = server.getAcademicSession();
            Iterator<CourseRequestInterface.Request> term = this.getBannerTerm(session);
            String campus = this.getBannerCampus(session);
            resource.addQueryParameter("term", (String)((Object)term));
            resource.addQueryParameter("campus", campus);
            resource.addQueryParameter("studentId", this.getBannerId(original));
            resource.addQueryParameter("mode", this.getSpecialRegistrationApiMode().name());
            helper.getAction().addOptionBuilder().setKey("term").setValue((String)((Object)term));
            helper.getAction().addOptionBuilder().setKey("campus").setValue(campus);
            helper.getAction().addOptionBuilder().setKey("studentId").setValue(this.getBannerId(original));
            resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
            long t1 = System.currentTimeMillis();
            resource.get(MediaType.APPLICATION_JSON);
            helper.getAction().setApiGetTime(System.currentTimeMillis() - t1);
            SpecialRegistrationInterface.SpecialRegistrationStatusResponse status = new GsonRepresentation<SpecialRegistrationInterface.SpecialRegistrationStatusResponse>(resource.getResponseEntity(), SpecialRegistrationInterface.SpecialRegistrationStatusResponse.class).getObject();
            Gson gson = this.getGson(helper);
            if (helper.isDebugEnabled()) {
                helper.debug("Status: " + gson.toJson((Object)status));
            }
            helper.getAction().addOptionBuilder().setKey("status_response").setValue(gson.toJson((Object)status));
            if (status != null && status.data != null) {
                maxCredit = ((SpecialRegistrationInterface.SpecialRegistrationStatus)status.data).maxCredit;
                request.setMaxCredit(((SpecialRegistrationInterface.SpecialRegistrationStatus)status.data).maxCredit);
            }
            if (maxCredit == null) {
                maxCredit = Float.valueOf(Float.parseFloat(ApplicationProperties.getProperty("purdue.specreg.maxCreditDefault", "18")));
            }
            if (status != null && status.data != null && ((SpecialRegistrationInterface.SpecialRegistrationStatus)status.data).requests != null) {
                for (SpecialRegistrationInterface.SpecialRegistration r : ((SpecialRegistrationInterface.SpecialRegistrationStatus)status.data).requests) {
                    if (r.changes == null) continue;
                    for (SpecialRegistrationInterface.Change change : r.changes) {
                        if (this.status(change.status) != CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING || change.subject == null || change.courseNbr == null) continue;
                        String course2 = change.subject + " " + change.courseNbr;
                        TreeSet<String> problems = (TreeSet<String>)overrides.get(course2);
                        if (problems == null) {
                            problems = new TreeSet<String>();
                            overrides.put(course2, problems);
                        }
                        if (change.errors == null) continue;
                        for (SpecialRegistrationInterface.ChangeError err : change.errors) {
                            if (err.code == null) continue;
                            problems.add(err.code);
                        }
                    }
                }
            }
        }
        catch (SectioningException e) {
            helper.getAction().setApiException(e.getMessage());
            throw e;
        }
        catch (Exception e) {
            helper.getAction().setApiException(e.getMessage());
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(e.getMessage());
        }
        finally {
            if (resource != null) {
                if (resource.getResponse() != null) {
                    resource.getResponse().release();
                }
                resource.release();
            }
        }
        SpecialRegistrationInterface.SpecialRegistrationRequest req = new SpecialRegistrationInterface.SpecialRegistrationRequest();
        req.studentId = this.getBannerId(original);
        req.term = this.getBannerTerm(server.getAcademicSession());
        req.campus = this.getBannerCampus(server.getAcademicSession());
        req.mode = this.getSpecialRegistrationApiMode();
        req.changes = new ArrayList();
        if (helper.getUser() != null) {
            req.requestorId = this.getRequestorId(helper.getUser());
            req.requestorRole = this.getRequestorType(helper.getUser(), original);
        }
        if (request.hasConfirmations()) {
            SpecialRegistrationInterface.ChangeError e;
            ArrayList<SpecialRegistrationInterface.ChangeError> errors;
            String courseNbr;
            String subject;
            for (CourseRequestInterface.CourseMessage m : request.getConfirmations()) {
                if (!"REQUEST_NOTE".equals(m.getCode()) || m.getMessage() == null || m.getMessage().isEmpty()) continue;
                req.requestorNotes = m.getMessage();
            }
            for (CourseRequestInterface.Request c : request.getCourses()) {
                if (!c.hasRequestedCourse()) continue;
                for (CourseRequestInterface.RequestedCourse rc : c.getRequestedCourse()) {
                    XCourse course2;
                    XCourseId cid2 = server.getCourse(rc.getCourseId(), rc.getCourseName());
                    if (cid2 == null) continue;
                    XCourse xCourse = course2 = cid2 instanceof XCourse ? (XCourse)cid2 : server.getCourse(cid2.getCourseId());
                    if (course2 == null) continue;
                    subject = course2.getSubjectArea();
                    courseNbr = course2.getCourseNumber();
                    errors = new ArrayList<SpecialRegistrationInterface.ChangeError>();
                    for (CourseRequestInterface.CourseMessage m : request.getConfirmations()) {
                        if ("CREDIT".equals(m.getCode()) || "NO_ALT".equals(m.getCode()) || "DROP_CRIT".equals(m.getCode()) || "OVERLAP".equals(m.getCode()) || !m.hasCourse() || m.isError() || !course2.getCourseId().equals(m.getCourseId()) && !course2.getCourseName().equals(m.getCourse())) continue;
                        e = new SpecialRegistrationInterface.ChangeError();
                        e.code = m.getCode();
                        e.message = m.getMessage();
                        errors.add(e);
                    }
                    if (errors.isEmpty()) continue;
                    SpecialRegistrationInterface.Change change = new SpecialRegistrationInterface.Change();
                    change.subject = subject;
                    change.courseNbr = courseNbr;
                    change.crn = "";
                    change.errors = errors;
                    change.operation = SpecialRegistrationInterface.ChangeOperation.ADD;
                    req.changes.add(change);
                    overrides.remove(subject + " " + courseNbr);
                }
            }
            for (CourseRequestInterface.Request c : request.getAlternatives()) {
                if (!c.hasRequestedCourse()) continue;
                for (CourseRequestInterface.RequestedCourse rc : c.getRequestedCourse()) {
                    Object course3;
                    XCourseId cid2 = server.getCourse(rc.getCourseId(), rc.getCourseName());
                    if (cid2 == null) continue;
                    Object object = course3 = cid2 instanceof XCourse ? (XCourse)cid2 : server.getCourse(cid2.getCourseId());
                    if (course3 == null) continue;
                    subject = ((XCourse)course3).getSubjectArea();
                    courseNbr = ((XCourse)course3).getCourseNumber();
                    errors = new ArrayList();
                    for (CourseRequestInterface.CourseMessage m : request.getConfirmations()) {
                        if ("CREDIT".equals(m.getCode()) || "NO_ALT".equals(m.getCode()) || "DROP_CRIT".equals(m.getCode()) || "OVERLAP".equals(m.getCode()) || !m.hasCourse() || m.isError() || !((XCourseId)course3).getCourseId().equals(m.getCourseId()) && !((XCourseId)course3).getCourseName().equals(m.getCourse())) continue;
                        e = new SpecialRegistrationInterface.ChangeError();
                        e.code = m.getCode();
                        e.message = m.getMessage();
                        errors.add(e);
                    }
                    if (errors.isEmpty()) continue;
                    SpecialRegistrationInterface.Change change = new SpecialRegistrationInterface.Change();
                    change.subject = subject;
                    change.courseNbr = courseNbr;
                    change.crn = "";
                    change.errors = errors;
                    change.operation = SpecialRegistrationInterface.ChangeOperation.ADD;
                    req.changes.add(change);
                    overrides.remove(subject + " " + courseNbr);
                }
            }
        }
        float total = request.getCredit();
        String maxCreditLimitStr = ApplicationProperties.getProperty("purdue.specreg.maxCreditCheck");
        if (maxCreditLimitStr != null && total > (maxCreditLimit = Float.parseFloat(maxCreditLimitStr))) {
            total = maxCreditLimit;
        }
        if (maxCredit.floatValue() < total) {
            req.maxCredit = Float.valueOf(total);
        }
        req.courseCreditHrs = new ArrayList<SpecialRegistrationInterface.CourseCredit>();
        req.alternateCourseCreditHrs = new ArrayList<SpecialRegistrationInterface.CourseCredit>();
        for (CourseRequestInterface.Request r : request.getCourses()) {
            if (!r.hasRequestedCourse()) continue;
            cc = null;
            for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                cid = server.getCourse(rc.getCourseId(), rc.getCourseName());
                if (cid == null || (course = cid instanceof XCourse ? (XCourse)cid : server.getCourse(cid.getCourseId())) == null) continue;
                if (cc == null) {
                    cc = new SpecialRegistrationInterface.CourseCredit();
                    cc.subject = course.getSubjectArea();
                    cc.courseNbr = course.getCourseNumber();
                    cc.title = course.getTitle();
                    cc.creditHrs = Float.valueOf(course.hasCredit() ? course.getMinCredit().floatValue() : 0.0f);
                    continue;
                }
                if (cc.alternatives == null) {
                    cc.alternatives = new ArrayList<SpecialRegistrationInterface.CourseCredit>();
                }
                SpecialRegistrationInterface.CourseCredit courseCredit = new SpecialRegistrationInterface.CourseCredit();
                courseCredit.subject = course.getSubjectArea();
                courseCredit.courseNbr = course.getCourseNumber();
                courseCredit.title = course.getTitle();
                courseCredit.creditHrs = Float.valueOf(course.hasCredit() ? course.getMinCredit().floatValue() : 0.0f);
                cc.alternatives.add(courseCredit);
            }
            if (cc == null) continue;
            req.courseCreditHrs.add(cc);
        }
        for (CourseRequestInterface.Request r : request.getAlternatives()) {
            if (!r.hasRequestedCourse()) continue;
            cc = null;
            for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                cid = server.getCourse(rc.getCourseId(), rc.getCourseName());
                if (cid == null || (course = cid instanceof XCourse ? (XCourse)cid : server.getCourse(cid.getCourseId())) == null) continue;
                if (cc == null) {
                    cc = new SpecialRegistrationInterface.CourseCredit();
                    cc.subject = course.getSubjectArea();
                    cc.courseNbr = course.getCourseNumber();
                    cc.title = course.getTitle();
                    cc.creditHrs = Float.valueOf(course.hasCredit() ? course.getMinCredit().floatValue() : 0.0f);
                    continue;
                }
                if (cc.alternatives == null) {
                    cc.alternatives = new ArrayList<SpecialRegistrationInterface.CourseCredit>();
                }
                SpecialRegistrationInterface.CourseCredit courseCredit = new SpecialRegistrationInterface.CourseCredit();
                courseCredit.subject = course.getSubjectArea();
                courseCredit.courseNbr = course.getCourseNumber();
                courseCredit.title = course.getTitle();
                courseCredit.creditHrs = Float.valueOf(course.hasCredit() ? course.getMinCredit().floatValue() : 0.0f);
                cc.alternatives.add(courseCredit);
            }
            if (cc == null) continue;
            req.alternateCourseCreditHrs.add(cc);
        }
        if (!req.changes.isEmpty() || !overrides.isEmpty() || req.maxCredit != null) {
            resource = null;
            try {
                resource = new ClientResource(this.getSpecialRegistrationApiSiteSubmitRegistration());
                resource.setNext((Uniform)this.iClient);
                resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
                Gson gson = this.getGson(helper);
                if (helper.isDebugEnabled()) {
                    helper.debug("Request: " + gson.toJson((Object)req));
                }
                helper.getAction().addOptionBuilder().setKey("specreg_request").setValue(gson.toJson((Object)req));
                long t1 = System.currentTimeMillis();
                resource.post(new GsonRepresentation<SpecialRegistrationInterface.SpecialRegistrationRequest>(req));
                helper.getAction().setApiPostTime(System.currentTimeMillis() - t1);
                SpecialRegistrationInterface.SpecialRegistrationResponseList response = new GsonRepresentation<SpecialRegistrationInterface.SpecialRegistrationResponseList>(resource.getResponseEntity(), SpecialRegistrationInterface.SpecialRegistrationResponseList.class).getObject();
                if (helper.isDebugEnabled()) {
                    helper.debug("Response: " + gson.toJson((Object)response));
                }
                helper.getAction().addOptionBuilder().setKey("specreg_response").setValue(gson.toJson((Object)response));
                if (SpecialRegistrationInterface.ResponseStatus.success != response.status) {
                    throw new SectioningException(response.message == null || response.message.isEmpty() ? "Failed to request overrides (" + (Object)((Object)response.status) + ")." : response.message);
                }
                if (response.data != null) {
                    String courseNbr;
                    String subject;
                    for (CourseRequestInterface.Request c : request.getCourses()) {
                        if (!c.hasRequestedCourse()) continue;
                        for (CourseRequestInterface.RequestedCourse requestedCourse : c.getRequestedCourse()) {
                            XCourse course4;
                            XCourseId cid3;
                            if (requestedCourse.getStatus() != null && requestedCourse.getStatus() != CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED) {
                                requestedCourse.setStatus(null);
                                requestedCourse.setOverrideExternalId(null);
                                requestedCourse.setOverrideTimeStamp(null);
                            }
                            if ((cid3 = server.getCourse(requestedCourse.getCourseId(), requestedCourse.getCourseName())) == null) continue;
                            XCourse xCourse = course4 = cid3 instanceof XCourse ? (XCourse)cid3 : server.getCourse(cid3.getCourseId());
                            if (course4 == null) continue;
                            subject = course4.getSubjectArea();
                            courseNbr = course4.getCourseNumber();
                            block30: for (SpecialRegistrationInterface.SpecialRegistration r : (List)response.data) {
                                if (r.changes == null) continue;
                                for (SpecialRegistrationInterface.Change ch : r.changes) {
                                    if (!subject.equals(ch.subject) || !courseNbr.equals(ch.courseNbr)) continue;
                                    requestedCourse.setOverrideTimeStamp(r.dateCreated == null ? null : r.dateCreated.toDate());
                                    requestedCourse.setOverrideExternalId(r.regRequestId);
                                    requestedCourse.setStatus(this.status(r, false));
                                    requestedCourse.setStatusNote(SpecialRegistrationHelper.note(r, false));
                                    requestedCourse.setRequestId(r.regRequestId);
                                    requestedCourse.setRequestorNote(r.requestorNotes);
                                    continue block30;
                                }
                            }
                        }
                    }
                    for (CourseRequestInterface.Request c : request.getAlternatives()) {
                        if (!c.hasRequestedCourse()) continue;
                        for (CourseRequestInterface.RequestedCourse requestedCourse : c.getRequestedCourse()) {
                            XCourse course3;
                            XCourseId cid3;
                            if (requestedCourse.getStatus() != null && requestedCourse.getStatus() != CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED) {
                                requestedCourse.setStatus(null);
                                requestedCourse.setOverrideExternalId(null);
                                requestedCourse.setOverrideTimeStamp(null);
                            }
                            if ((cid3 = server.getCourse(requestedCourse.getCourseId(), requestedCourse.getCourseName())) == null) continue;
                            XCourse xCourse = course3 = cid3 instanceof XCourse ? (XCourse)cid3 : server.getCourse(cid3.getCourseId());
                            if (course3 == null) continue;
                            subject = course3.getSubjectArea();
                            courseNbr = course3.getCourseNumber();
                            block34: for (SpecialRegistrationInterface.SpecialRegistration r : (List)response.data) {
                                if (r.changes == null) continue;
                                for (SpecialRegistrationInterface.Change ch : r.changes) {
                                    if (!subject.equals(ch.subject) || !courseNbr.equals(ch.courseNbr)) continue;
                                    requestedCourse.setOverrideTimeStamp(r.dateCreated == null ? null : r.dateCreated.toDate());
                                    requestedCourse.setOverrideExternalId(r.regRequestId);
                                    requestedCourse.setStatus(this.status(r, false));
                                    requestedCourse.setStatusNote(SpecialRegistrationHelper.note(r, false));
                                    continue block34;
                                }
                            }
                        }
                    }
                    if (req.maxCredit != null) {
                        for (SpecialRegistrationInterface.SpecialRegistration r : (List)response.data) {
                            if (r.maxCredit == null) continue;
                            request.setMaxCreditOverride(r.maxCredit);
                            request.setMaxCreditOverrideExternalId(r.regRequestId);
                            request.setMaxCreditOverrideTimeStamp(r.dateCreated == null ? null : r.dateCreated.toDate());
                            request.setMaxCreditOverrideStatus(this.status(r, true));
                            request.setCreditWarning(ApplicationProperties.getProperty("purdue.specreg.messages.maxCredit", "Maximum of {max} credit hours exceeded.").replace("{max}", sCreditFormat.format(maxCredit)).replace("{credit}", sCreditFormat.format(req.maxCredit)));
                            request.setCreditNote(SpecialRegistrationHelper.note(r, true));
                            request.setRequestorNote(r.requestorNotes);
                            request.setRequestId(r.regRequestId);
                            break;
                        }
                    } else {
                        request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.SAVED);
                    }
                }
                if (request.hasConfirmations()) {
                    for (CourseRequestInterface.CourseMessage message : request.getConfirmations()) {
                        if (message.getStatus() != CourseRequestInterface.RequestedCourseStatus.OVERRIDE_NEEDED) continue;
                        message.setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING);
                    }
                }
            }
            catch (SectioningException e) {
                helper.getAction().setApiException(e.getMessage());
                throw e;
            }
            catch (Exception e) {
                helper.getAction().setApiException(e.getMessage());
                sLog.error((Object)e.getMessage(), (Throwable)e);
                throw new SectioningException(e.getMessage());
            }
            finally {
                if (resource != null) {
                    if (resource.getResponse() != null) {
                        resource.getResponse().release();
                    }
                    resource.release();
                }
            }
        }
    }

    protected CourseRequestInterface.RequestedCourseStatus status(SpecialRegistrationInterface.ChangeStatus status) {
        if (status == null) {
            return CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING;
        }
        switch (status) {
            case denied: {
                return CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED;
            }
            case approved: {
                return CourseRequestInterface.RequestedCourseStatus.OVERRIDE_APPROVED;
            }
            case cancelled: {
                return CourseRequestInterface.RequestedCourseStatus.OVERRIDE_CANCELLED;
            }
        }
        return CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING;
    }

    protected CourseRequestInterface.RequestedCourseStatus combine(CourseRequestInterface.RequestedCourseStatus s1, CourseRequestInterface.RequestedCourseStatus s2) {
        if (s1 == null) {
            return s2;
        }
        if (s2 == null) {
            return s1;
        }
        if (s1 == s2) {
            return s1;
        }
        if (s1 == CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED || s2 == CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED) {
            return CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED;
        }
        if (s1 == CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING || s2 == CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING) {
            return CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING;
        }
        if (s1 == CourseRequestInterface.RequestedCourseStatus.OVERRIDE_APPROVED || s2 == CourseRequestInterface.RequestedCourseStatus.OVERRIDE_APPROVED) {
            return CourseRequestInterface.RequestedCourseStatus.OVERRIDE_APPROVED;
        }
        if (s1 == CourseRequestInterface.RequestedCourseStatus.OVERRIDE_CANCELLED || s2 == CourseRequestInterface.RequestedCourseStatus.OVERRIDE_CANCELLED) {
            return CourseRequestInterface.RequestedCourseStatus.OVERRIDE_CANCELLED;
        }
        return s1;
    }

    protected CourseRequestInterface.RequestedCourseStatus status(SpecialRegistrationInterface.SpecialRegistration request, boolean credit) {
        CourseRequestInterface.RequestedCourseStatus ret = null;
        if (request.changes != null) {
            for (SpecialRegistrationInterface.Change ch : request.changes) {
                if (credit && ch.subject == null && ch.courseNbr == null) {
                    ret = this.combine(ret, this.status(ch.status));
                }
                if (credit || ch.subject == null || ch.courseNbr == null) continue;
                ret = this.combine(ret, this.status(ch.status));
            }
        }
        if (ret != null) {
            return ret;
        }
        if (request.completionStatus != null) {
            switch (request.completionStatus) {
                case completed: {
                    return CourseRequestInterface.RequestedCourseStatus.OVERRIDE_APPROVED;
                }
                case cancelled: {
                    return CourseRequestInterface.RequestedCourseStatus.OVERRIDE_CANCELLED;
                }
                case inProgress: {
                    return CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING;
                }
            }
        }
        return CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING;
    }

    protected List<CourseRequestInterface.RequestedCourse> getOverCreditRequests(CourseRequestInterface request, float maxCredit) {
        ArrayList<CourseRequestInterface.RequestedCourse> ret = new ArrayList<CourseRequestInterface.RequestedCourse>();
        float primary = 0.0f;
        for (CourseRequestInterface.Request r : request.getCourses()) {
            if (!r.hasRequestedCourse() || !r.getRequestedCourse(0).hasCredit() || !((primary += r.getRequestedCourse(0).getCreditMin().floatValue()) > maxCredit)) continue;
            ret.add(r.getRequestedCourse(0));
        }
        if (!ret.isEmpty()) {
            return ret;
        }
        for (CourseRequestInterface.Request r : request.getCourses()) {
            if (!r.hasRequestedCourse() || r.getRequestedCourse().size() <= 1) continue;
            float credit = r.getRequestedCourse(0).hasCredit() ? r.getRequestedCourse(0).getCreditMin().floatValue() : 0.0f;
            for (int i = 1; i < r.getRequestedCourse().size(); ++i) {
                float alt;
                float f = alt = r.getRequestedCourse(i).hasCredit() ? r.getRequestedCourse(i).getCreditMin().floatValue() : 0.0f;
                if (!(primary - credit + alt > maxCredit)) continue;
                ret.add(r.getRequestedCourse(i));
            }
        }
        if (!ret.isEmpty()) {
            return ret;
        }
        ArrayList<Float> credits = new ArrayList<Float>();
        float total = 0.0f;
        CourseRequestInterface.RequestedCourse last = null;
        for (CourseRequestInterface.Request r : request.getCourses()) {
            if (!r.hasRequestedCourse()) continue;
            Float credit = null;
            for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                if (!rc.hasCredit() || credit != null && !(credit.floatValue() < rc.getCreditMin().floatValue()) || !(total + (credit = rc.getCreditMin()).floatValue() > maxCredit)) continue;
                ret.add(rc);
            }
            if (credit != null) {
                credits.add(credit);
                total += credit.floatValue();
            }
            last = r.getRequestedCourse(0);
        }
        if (!ret.isEmpty()) {
            return ret;
        }
        Collections.sort(credits);
        float low = credits.isEmpty() ? 0.0f : ((Float)credits.get(0)).floatValue();
        CourseRequestInterface.RequestedCourse first = null;
        for (CourseRequestInterface.Request r : request.getAlternatives()) {
            if (!r.hasRequestedCourse()) continue;
            for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                if (!rc.hasCredit() || !(total + rc.getCreditMin().floatValue() - low > maxCredit)) continue;
                ret.add(rc);
                break;
            }
            if (first != null) continue;
            first = r.getRequestedCourse(0);
        }
        if (!ret.isEmpty()) {
            return ret;
        }
        ret.add(first != null ? first : last);
        return ret;
    }

    @Override
    public void check(OnlineSectioningServer server, OnlineSectioningHelper helper, CourseRequestInterface request) throws SectioningException {
        Serializable offering;
        Iterator<IsSerializable> cr;
        HashMap<Serializable, XCourseId> singleSections;
        XStudent original;
        XStudent xStudent = original = request.getStudentId() == null ? null : server.getStudent(request.getStudentId());
        if (original == null) {
            return;
        }
        if (!this.isValidationEnabled(server, helper, original)) {
            return;
        }
        Integer ORD_UNITIME = new Integer(0);
        Integer ORD_BANNER = new Integer(1);
        Integer ORD_CREDIT = new Integer(2);
        for (CourseRequestInterface.Request request2 : request.getCourses()) {
            CourseRequestInterface.RequestedCourse requestedCourse;
            if (!request2.hasRequestedCourse() || request2.getRequestedCourse().size() != 1 || (requestedCourse = request2.getRequestedCourse(0)).getCourseId() == null || requestedCourse.isReadOnly()) continue;
            request.addConfirmationMessage(requestedCourse.getCourseId(), requestedCourse.getCourseName(), "NO_ALT", ApplicationProperties.getProperty("purdue.specreg.messages.courseHasNoAlt", "No alternative course provided.").replace("{course}", requestedCourse.getCourseName()), ORD_UNITIME);
        }
        if (server instanceof DatabaseServer) {
            singleSections = new HashMap<Serializable, XCourseId>();
            for (XRequest xRequest : original.getRequests()) {
                if (xRequest.isAlternative() || !(xRequest instanceof XCourseRequest)) continue;
                cr = (XCourseRequest)xRequest;
                for (XCourseId xCourseId : ((XCourseRequest)((Object)cr)).getCourseIds()) {
                    offering = (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(xCourseId.getOfferingId(), helper.getHibSession());
                    if (offering == null || ((BaseInstructionalOffering)offering).getInstrOfferingConfigs().size() != 1) continue;
                    for (SchedulingSubpart schedulingSubpart : ((BaseInstructionalOffering)offering).getInstrOfferingConfigs().iterator().next().getSchedulingSubparts()) {
                        Class_ clazz;
                        if (schedulingSubpart.getClasses().size() != 1 || (clazz = schedulingSubpart.getClasses().iterator().next()).getCommittedAssignment() == null) continue;
                        TimeLocation time = clazz.getCommittedAssignment().getTimeLocation();
                        for (Class_ other : singleSections.keySet()) {
                            if (!other.getCommittedAssignment().getTimeLocation().hasIntersection(time) || clazz.isToIgnoreStudentConflictsWith(other)) continue;
                            request.addConfirmationMessage(xCourseId.getCourseId(), xCourseId.getCourseName(), "OVERLAP", ApplicationProperties.getProperty("purdue.specreg.messages.courseOverlaps", "Conflicts with {other}.").replace("{course}", xCourseId.getCourseName()).replace("{other}", ((XCourseId)singleSections.get(other)).getCourseName()), ORD_UNITIME);
                        }
                        if (((XCourseRequest)((Object)cr)).getCourseIds().size() != 1) continue;
                        singleSections.put(clazz, xCourseId);
                    }
                }
            }
        } else {
            singleSections = new HashMap();
            for (XRequest xRequest : original.getRequests()) {
                if (xRequest.isAlternative() || !(xRequest instanceof XCourseRequest)) continue;
                cr = (XCourseRequest)xRequest;
                for (XCourseId xCourseId : ((XCourseRequest)((Object)cr)).getCourseIds()) {
                    offering = server.getOffering(xCourseId.getOfferingId());
                    if (offering == null || ((XOffering)offering).getConfigs().size() != 1) continue;
                    for (XSubpart xSubpart : ((XOffering)offering).getConfigs().get(0).getSubparts()) {
                        if (xSubpart.getSections().size() != 1) continue;
                        XSection section = xSubpart.getSections().get(0);
                        for (XSection other : singleSections.keySet()) {
                            if (!section.isOverlapping(((XOffering)offering).getDistributions(), other)) continue;
                            request.addConfirmationMessage(xCourseId.getCourseId(), xCourseId.getCourseName(), "OVERLAP", ApplicationProperties.getProperty("purdue.specreg.messages.courseOverlaps", "Conflicts with {other}.").replace("{course}", xCourseId.getCourseName()).replace("{other}", ((XCourseId)singleSections.get(other)).getCourseName()), ORD_UNITIME);
                        }
                        if (((XCourseRequest)((Object)cr)).getCourseIds().size() != 1) continue;
                        singleSections.put(section, xCourseId);
                    }
                }
            }
        }
        HashMap<String, CourseRequestInterface.RequestedCourse> rcs = new HashMap<String, CourseRequestInterface.RequestedCourse>();
        for (CourseRequestInterface.Request request3 : request.getCourses()) {
            if (!request3.hasRequestedCourse()) continue;
            for (CourseRequestInterface.RequestedCourse rc : request3.getRequestedCourse()) {
                if (rc.getOverrideExternalId() == null) continue;
                rcs.put(rc.getOverrideExternalId(), rc);
            }
        }
        for (CourseRequestInterface.Request request4 : request.getAlternatives()) {
            if (!request4.hasRequestedCourse()) continue;
            for (CourseRequestInterface.RequestedCourse rc : request4.getRequestedCourse()) {
                if (rc.getOverrideExternalId() == null) continue;
                rcs.put(rc.getOverrideExternalId(), rc);
            }
        }
        String string = ApplicationProperties.getProperty("purdue.specreg.minCreditCheck");
        float f = 0.0f;
        block19: for (CourseRequestInterface.Request r : request.getCourses()) {
            if (!r.hasRequestedCourse()) continue;
            for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                if (!rc.hasCredit()) continue;
                f += rc.getCreditMin().floatValue();
                continue block19;
            }
        }
        if (string != null && f > 0.0f && f < Float.parseFloat(string) && (original.getMaxCredit() == null || original.getMaxCredit().floatValue() > Float.parseFloat(string))) {
            request.setCreditWarning(ApplicationProperties.getProperty("purdue.specreg.messages.minCredit", "Less than {min} credit hours requested.").replace("{min}", string).replace("{credit}", sCreditFormat.format(Float.valueOf(f))));
            request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.CREDIT_LOW);
        }
        if (f > 0.0f && request.getMaxCreditOverrideStatus() == null) {
            request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.SAVED);
        }
        if (rcs.isEmpty() && !request.hasMaxCreditOverride()) {
            return;
        }
        ClientResource resource = null;
        try {
            String string2;
            resource = new ClientResource(this.getSpecialRegistrationApiSiteCheckSpecialRegistrationStatus());
            resource.setNext((Uniform)this.iClient);
            AcademicSessionInfo session = server.getAcademicSession();
            String string3 = this.getBannerTerm(session);
            String campus = this.getBannerCampus(session);
            resource.addQueryParameter("term", string3);
            resource.addQueryParameter("campus", campus);
            resource.addQueryParameter("studentId", this.getBannerId(original));
            resource.addQueryParameter("mode", this.getSpecialRegistrationApiMode().name());
            helper.getAction().addOptionBuilder().setKey("term").setValue(string3);
            helper.getAction().addOptionBuilder().setKey("campus").setValue(campus);
            helper.getAction().addOptionBuilder().setKey("studentId").setValue(this.getBannerId(original));
            resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
            long t0 = System.currentTimeMillis();
            resource.get(MediaType.APPLICATION_JSON);
            helper.getAction().setApiGetTime(System.currentTimeMillis() - t0);
            SpecialRegistrationInterface.SpecialRegistrationStatusResponse status = new GsonRepresentation<SpecialRegistrationInterface.SpecialRegistrationStatusResponse>(resource.getResponseEntity(), SpecialRegistrationInterface.SpecialRegistrationStatusResponse.class).getObject();
            Gson gson = this.getGson(helper);
            if (helper.isDebugEnabled()) {
                helper.debug("Status: " + gson.toJson((Object)status));
            }
            helper.getAction().addOptionBuilder().setKey("status_response").setValue(gson.toJson((Object)status));
            Float maxCredit = null;
            if (status != null && status.data != null) {
                maxCredit = ((SpecialRegistrationInterface.SpecialRegistrationStatus)status.data).maxCredit;
                request.setMaxCredit(((SpecialRegistrationInterface.SpecialRegistrationStatus)status.data).maxCredit);
            }
            if (maxCredit == null) {
                maxCredit = Float.valueOf(Float.parseFloat(ApplicationProperties.getProperty("purdue.specreg.maxCreditDefault", "18")));
            }
            String creditNote = null;
            if (status != null && status.data != null && ((SpecialRegistrationInterface.SpecialRegistrationStatus)status.data).requests != null) {
                for (SpecialRegistrationInterface.SpecialRegistration specialRegistration : ((SpecialRegistrationInterface.SpecialRegistrationStatus)status.data).requests) {
                    CourseRequestInterface.RequestedCourse rc;
                    if (specialRegistration.regRequestId == null) continue;
                    if (specialRegistration.regRequestId.equals(request.getMaxCreditOverrideExternalId())) {
                        request.setMaxCreditOverrideStatus(this.status(specialRegistration, true));
                        if (specialRegistration.maxCredit != null) {
                            request.setMaxCreditOverride(specialRegistration.maxCredit);
                        }
                        creditNote = SpecialRegistrationHelper.note(specialRegistration, true);
                        request.setRequestorNote(specialRegistration.requestorNotes);
                        request.setRequestId(specialRegistration.regRequestId);
                    }
                    if ((rc = (CourseRequestInterface.RequestedCourse)rcs.get(specialRegistration.regRequestId)) == null) continue;
                    if (rc.getStatus() != CourseRequestInterface.RequestedCourseStatus.ENROLLED) {
                        rc.setStatus(this.status(specialRegistration, false));
                    }
                    if (specialRegistration.changes != null) {
                        for (SpecialRegistrationInterface.Change ch : specialRegistration.changes) {
                            if (ch.errors == null || ch.courseNbr == null || ch.subject == null) continue;
                            for (SpecialRegistrationInterface.ChangeError er : ch.errors) {
                                if (ch.status == SpecialRegistrationInterface.ChangeStatus.denied) {
                                    request.addConfirmationError(rc.getCourseId(), rc.getCourseName(), er.code, "Denied " + er.message, this.status(ch.status), ORD_BANNER);
                                    request.setErrorMessage(ApplicationProperties.getProperty("purdue.specreg.messages.deniedOverrideError", "One or more courses require registration overrides which have been denied.\nYou must remove or replace these courses in order to submit your registration request."));
                                    continue;
                                }
                                if (ch.status == SpecialRegistrationInterface.ChangeStatus.approved || ch.status == SpecialRegistrationInterface.ChangeStatus.cancelled) continue;
                                request.addConfirmationMessage(rc.getCourseId(), rc.getCourseName(), er.code, er.message, this.status(ch.status), ORD_BANNER);
                            }
                        }
                    }
                    rc.setStatusNote(SpecialRegistrationHelper.note(specialRegistration, false));
                    rc.setRequestorNote(specialRegistration.requestorNotes);
                    rc.setRequestId(specialRegistration.regRequestId);
                }
            }
            String maxCreditLimitStr = ApplicationProperties.getProperty("purdue.specreg.maxCreditCheck");
            if (maxCredit.floatValue() < request.getCredit()) {
                for (CourseRequestInterface.RequestedCourse rc : this.getOverCreditRequests(request, maxCredit.floatValue())) {
                    request.addConfirmationMessage(rc.getCourseId(), rc.getCourseName(), "CREDIT", ApplicationProperties.getProperty("purdue.specreg.messages.maxCredit", "Maximum of {max} credit hours exceeded.").replace("{max}", sCreditFormat.format(maxCredit)).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit()))), null, ORD_CREDIT);
                }
                request.setCreditWarning(ApplicationProperties.getProperty("purdue.specreg.messages.maxCredit", "Maximum of {max} credit hours exceeded.").replace("{max}", sCreditFormat.format(maxCredit)).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit()))));
                if (request.getMaxCreditOverrideStatus() == CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED && request.getMaxCreditOverride() != null) {
                    if (!request.hasErrorMessage()) {
                        request.setErrorMessage(ApplicationProperties.getProperty("purdue.specreg.messages.maxCreditDeniedError", "Maximum of {max} credit hours exceeded.\nThe request to increase the maximum credit hours to {maxCreditDenied} has been denied.\nYou may not be able to get a full schedule.").replace("{max}", sCreditFormat.format(maxCredit)).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit()))).replace("{maxCreditDenied}", sCreditFormat.format(request.getMaxCreditOverride())));
                    }
                } else if (maxCreditLimitStr != null && Float.parseFloat(maxCreditLimitStr) < request.getCredit()) {
                    float f2 = Float.parseFloat(maxCreditLimitStr);
                    request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.CREDIT_HIGH);
                    if (!request.hasErrorMessage()) {
                        request.setErrorMessage(ApplicationProperties.getProperty("purdue.specreg.messages.maxCreditError", "Maximum of {max} credit hours exceeded.\nYou may not be able to get a full schedule.").replace("{max}", sCreditFormat.format(Float.valueOf(f2))).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit()))));
                    }
                }
                if (creditNote != null && !creditNote.isEmpty()) {
                    request.setCreditNote(creditNote);
                }
            }
            if ((string2 = this.getSpecialRegistrationDashboardUrl()) != null) {
                request.setSpecRegDashboardUrl(string2.replace("{term}", string3).replace("{campus}", campus).replace("{studentId}", this.getBannerId(original)));
            }
        }
        catch (SectioningException e) {
            helper.getAction().setApiException(e.getMessage());
            throw e;
        }
        catch (Exception e) {
            helper.getAction().setApiException(e.getMessage() == null ? "Null" : e.getMessage());
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(e.getMessage());
        }
        finally {
            if (resource != null) {
                if (resource.getResponse() != null) {
                    resource.getResponse().release();
                }
                resource.release();
            }
        }
    }

    protected boolean isValidationEnabled(org.unitime.timetable.model.Student student) {
        if (student == null) {
            return false;
        }
        StudentSectioningStatus status = student.getEffectiveStatus();
        return status == null || status.hasOption(StudentSectioningStatus.Option.reqval);
    }

    protected boolean isValidationEnabled(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student) {
        StudentSectioningStatus dbStatus;
        String status = student.getStatus();
        if (status == null) {
            status = server.getAcademicSession().getDefaultSectioningStatus();
        }
        if (status == null) {
            return true;
        }
        for (dbStatus = StudentSectioningStatus.getStatus(status, server.getAcademicSession().getUniqueId(), helper.getHibSession()); dbStatus != null && dbStatus.isPast() && dbStatus.getFallBackStatus() != null; dbStatus = dbStatus.getFallBackStatus()) {
        }
        return dbStatus != null && dbStatus.hasOption(StudentSectioningStatus.Option.reqval);
    }

    protected boolean hasPendingOverride(org.unitime.timetable.model.Student student) {
        if (student.getOverrideExternalId() != null && student.getMaxCreditOverrideStatus() == CourseRequest.CourseRequestOverrideStatus.PENDING) {
            return true;
        }
        if (student.getMaxCredit() == null) {
            return true;
        }
        for (CourseDemand cd : student.getCourseDemands()) {
            for (org.unitime.timetable.model.CourseRequest cr : cd.getCourseRequests()) {
                if (cr.getOverrideExternalId() == null || cr.getCourseRequestOverrideStatus() != CourseRequest.CourseRequestOverrideStatus.PENDING) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean updateStudent(OnlineSectioningServer server, OnlineSectioningHelper helper, org.unitime.timetable.model.Student student, OnlineSectioningLog.Action.Builder action) throws SectioningException {
        if (student == null || !this.hasPendingOverride(student)) {
            return false;
        }
        ClientResource resource = null;
        try {
            resource = new ClientResource(this.getSpecialRegistrationApiSiteCheckSpecialRegistrationStatus());
            resource.setNext((Uniform)this.iClient);
            AcademicSessionInfo session = server == null ? new AcademicSessionInfo(student.getSession()) : server.getAcademicSession();
            String term = this.getBannerTerm(session);
            String campus = this.getBannerCampus(session);
            resource.addQueryParameter("term", term);
            resource.addQueryParameter("campus", campus);
            resource.addQueryParameter("studentId", this.getBannerId(student));
            resource.addQueryParameter("mode", this.getSpecialRegistrationApiMode().name());
            action.addOptionBuilder().setKey("term").setValue(term);
            action.addOptionBuilder().setKey("campus").setValue(campus);
            action.addOptionBuilder().setKey("studentId").setValue(this.getBannerId(student));
            resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
            long t0 = System.currentTimeMillis();
            resource.get(MediaType.APPLICATION_JSON);
            action.setApiGetTime(System.currentTimeMillis() - t0);
            SpecialRegistrationInterface.SpecialRegistrationStatusResponse status = new GsonRepresentation<SpecialRegistrationInterface.SpecialRegistrationStatusResponse>(resource.getResponseEntity(), SpecialRegistrationInterface.SpecialRegistrationStatusResponse.class).getObject();
            Gson gson = this.getGson(helper);
            if (helper.isDebugEnabled()) {
                helper.debug("Status: " + gson.toJson((Object)status));
            }
            action.addOptionBuilder().setKey("status_response").setValue(gson.toJson((Object)status));
            boolean changed = false;
            for (CourseDemand cd : student.getCourseDemands()) {
                for (org.unitime.timetable.model.CourseRequest cr : cd.getCourseRequests()) {
                    if (cr.getOverrideExternalId() == null) continue;
                    SpecialRegistrationInterface.SpecialRegistration req = null;
                    for (SpecialRegistrationInterface.SpecialRegistration r : ((SpecialRegistrationInterface.SpecialRegistrationStatus)status.data).requests) {
                        if (!cr.getOverrideExternalId().equals(r.regRequestId)) continue;
                        req = r;
                        break;
                    }
                    if (req == null) {
                        if (cr.getCourseRequestOverrideStatus() == CourseRequest.CourseRequestOverrideStatus.CANCELLED) continue;
                        cr.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.CANCELLED);
                        helper.getHibSession().update((Object)cr);
                        changed = true;
                        continue;
                    }
                    Integer oldStatus = cr.getOverrideStatus();
                    switch (this.status(req, false)) {
                        case OVERRIDE_REJECTED: {
                            cr.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.REJECTED);
                            break;
                        }
                        case OVERRIDE_APPROVED: {
                            cr.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.APPROVED);
                            break;
                        }
                        case OVERRIDE_CANCELLED: {
                            cr.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.CANCELLED);
                            break;
                        }
                        case OVERRIDE_PENDING: {
                            cr.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.PENDING);
                        }
                    }
                    if (oldStatus != null && oldStatus.equals(cr.getOverrideStatus())) continue;
                    helper.getHibSession().update((Object)cr);
                    changed = true;
                }
            }
            boolean studentChanged = false;
            if (((SpecialRegistrationInterface.SpecialRegistrationStatus)status.data).maxCredit != null && !((SpecialRegistrationInterface.SpecialRegistrationStatus)status.data).maxCredit.equals(student.getMaxCredit())) {
                student.setMaxCredit(((SpecialRegistrationInterface.SpecialRegistrationStatus)status.data).maxCredit);
                studentChanged = true;
            }
            if (student.getOverrideExternalId() != null) {
                SpecialRegistrationInterface.SpecialRegistration req = null;
                for (SpecialRegistrationInterface.SpecialRegistration r : ((SpecialRegistrationInterface.SpecialRegistrationStatus)status.data).requests) {
                    if (!student.getOverrideExternalId().equals(r.regRequestId)) continue;
                    req = r;
                    break;
                }
                if (req == null) {
                    student.setOverrideExternalId(null);
                    student.setOverrideMaxCredit(null);
                    student.setOverrideStatus(null);
                    student.setOverrideTimeStamp(null);
                    studentChanged = true;
                } else {
                    Integer oldStatus = student.getOverrideStatus();
                    switch (this.status(req, true)) {
                        case OVERRIDE_REJECTED: {
                            student.setMaxCreditOverrideStatus(CourseRequest.CourseRequestOverrideStatus.REJECTED);
                            break;
                        }
                        case OVERRIDE_APPROVED: {
                            student.setMaxCreditOverrideStatus(CourseRequest.CourseRequestOverrideStatus.APPROVED);
                            break;
                        }
                        case OVERRIDE_CANCELLED: {
                            student.setMaxCreditOverrideStatus(CourseRequest.CourseRequestOverrideStatus.CANCELLED);
                            break;
                        }
                        case OVERRIDE_PENDING: {
                            student.setMaxCreditOverrideStatus(CourseRequest.CourseRequestOverrideStatus.PENDING);
                        }
                    }
                    if (oldStatus == null || !oldStatus.equals(student.getOverrideStatus())) {
                        studentChanged = true;
                    }
                }
            }
            if (studentChanged) {
                helper.getHibSession().update((Object)student);
            }
            if (changed || studentChanged) {
                helper.getHibSession().flush();
            }
            boolean bl = changed || studentChanged;
            return bl;
        }
        catch (SectioningException e) {
            action.setApiException(e.getMessage());
            throw e;
        }
        catch (Exception e) {
            action.setApiException(e.getMessage() == null ? "Null" : e.getMessage());
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(e.getMessage());
        }
        finally {
            if (resource != null) {
                if (resource.getResponse() != null) {
                    resource.getResponse().release();
                }
                resource.release();
            }
        }
    }

    protected boolean hasNotApprovedCourseRequestOverride(org.unitime.timetable.model.Student student) {
        for (CourseDemand cd : student.getCourseDemands()) {
            for (org.unitime.timetable.model.CourseRequest cr : cd.getCourseRequests()) {
                if (cr.getOverrideExternalId() == null || cr.getCourseRequestOverrideStatus() == CourseRequest.CourseRequestOverrideStatus.APPROVED) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean revalidateStudent(OnlineSectioningServer server, OnlineSectioningHelper helper, org.unitime.timetable.model.Student student, OnlineSectioningLog.Action.Builder action) throws SectioningException {
        float maxCreditLimit;
        Object err;
        SpecialRegistrationInterface.Change change;
        Course course;
        XCourseRequest cr;
        if (!this.isValidationEnabled(student)) {
            return false;
        }
        if (this.hasPendingOverride(student)) {
            this.updateStudent(server, helper, student, action);
        }
        if (!this.hasNotApprovedCourseRequestOverride(student) && !"true".equalsIgnoreCase(ApplicationProperties.getProperty("purdue.specreg.forceRevalidation", "false"))) {
            return false;
        }
        OnlineSectioningModel model = new OnlineSectioningModel(server.getConfig(), server.getOverExpectedCriterion());
        boolean linkedClassesMustBeUsed = server.getConfig().getPropertyBoolean("LinkedClasses.mustBeUsed", false);
        AssignmentMap assignment = new AssignmentMap();
        XStudent original = server.getStudent(student.getUniqueId());
        if (original == null) {
            original = new XStudent(student, helper, server.getAcademicSession().getFreeTimePattern());
        }
        Student s = new Student(student.getUniqueId().longValue());
        s.setExternalId(original.getExternalId());
        s.setName(original.getName());
        s.setNeedShortDistances(original.hasAccomodation(server.getDistanceMetric().getShortDistanceAccommodationReference()));
        s.setAllowDisabled(original.isAllowDisabled());
        HashSet<XDistribution> distributions = new HashSet<XDistribution>();
        Hashtable<CourseRequest, Iterator<Section>> preferredSections = new Hashtable<CourseRequest, Iterator<Section>>();
        HashSet<XCourseId> lcCourses = new HashSet<XCourseId>();
        boolean ignoreLcCourses = this.isIngoreLCRegistrationErrors();
        for (XRequest r : original.getRequests()) {
            Object clonnedCourse2;
            Section section;
            action.addRequest(OnlineSectioningHelper.toProto(r));
            if (r instanceof XFreeTimeRequest) {
                XFreeTimeRequest ft = (XFreeTimeRequest)r;
                new FreeTimeRequest(r.getRequestId().longValue(), r.getPriority(), r.isAlternative(), s, new TimeLocation(ft.getTime().getDays(), ft.getTime().getSlot(), ft.getTime().getLength(), 0, 0.0, Long.valueOf(-1L), "Free Time", server.getAcademicSession().getFreeTimePattern(), 0));
                continue;
            }
            cr = (XCourseRequest)r;
            Iterator enrollment = cr.getEnrollment();
            ArrayList<Course> courses = new ArrayList<Course>();
            Iterator<Section> sections = new HashSet();
            for (XCourseId xCourseId : cr.getCourseIds()) {
                XOffering offering = server.getOffering(xCourseId.getOfferingId());
                if (offering == null) continue;
                Course clonnedCourse2 = offering.toCourse(xCourseId.getCourseId(), original, server.getExpectations(xCourseId.getOfferingId()), offering.getDistributions(), server.getEnrollments(xCourseId.getOfferingId()));
                courses.add(clonnedCourse2);
                model.addOffering(clonnedCourse2.getOffering());
                distributions.addAll(offering.getDistributions());
                if (enrollment != null && ((XCourseId)((Object)enrollment)).getCourseId().equals(xCourseId.getCourseId())) {
                    for (Long sectionId : ((XEnrollment)((Object)enrollment)).getSectionIds()) {
                        section = clonnedCourse2.getOffering().getSection(sectionId.longValue());
                        if (section == null) continue;
                        sections.add(section);
                    }
                }
                if (offering == null || !offering.hasLearningCommunityReservation(original, xCourseId)) continue;
                lcCourses.add(xCourseId);
            }
            if (courses.isEmpty()) continue;
            CourseRequest clonnedRequest = new CourseRequest(r.getRequestId().longValue(), r.getPriority(), r.isAlternative(), s, courses, cr.isWaitlist(), cr.getTimeStamp() == null ? null : Long.valueOf(cr.getTimeStamp().getTime()));
            if (!sections.isEmpty()) {
                preferredSections.put(clonnedRequest, sections);
            }
            for (Object clonnedCourse2 : clonnedRequest.getCourses()) {
                Object reservation22;
                if (!clonnedCourse2.getOffering().hasReservations() || enrollment == null || !((XCourseId)((Object)enrollment)).getCourseId().equals(clonnedCourse2.getId())) continue;
                boolean hasMustUse = false;
                for (Object reservation22 : clonnedCourse2.getOffering().getReservations()) {
                    if (!reservation22.isApplicable(s) || !reservation22.mustBeUsed()) continue;
                    hasMustUse = true;
                }
                OnlineReservation reservation3 = new OnlineReservation(XReservationType.Dummy.ordinal(), -original.getStudentId().longValue(), clonnedCourse2.getOffering(), 1000, false, 1, true, hasMustUse, false, true, true);
                reservation22 = sections.iterator();
                while (reservation22.hasNext()) {
                    section = (Section)reservation22.next();
                    reservation3.addSection(section);
                }
                break block27;
            }
            cr.fillChoicesIn(clonnedRequest);
            if (clonnedRequest.getRequiredChoices().isEmpty()) continue;
            boolean bl = false;
            clonnedCourse2 = sections.iterator();
            while (clonnedCourse2.hasNext()) {
                boolean bl2;
                Section section2 = (Section)clonnedCourse2.next();
                clonnedRequest.getRequiredChoices().add(new Choice(section2));
                if (bl2) continue;
                clonnedRequest.getRequiredChoices().add(new Choice(section2.getSubpart().getConfig()));
                bl2 = true;
            }
        }
        model.addStudent(s);
        model.setStudentQuality(new StudentQuality(server.getDistanceMetric(), model.getProperties()));
        for (XDistribution link : distributions) {
            if (link.getDistributionType() != XDistributionType.LinkedSections) continue;
            ArrayList<Section> sections = new ArrayList<Section>();
            block32: for (Long sectionId : link.getSectionIds()) {
                for (Offering offering : model.getOfferings()) {
                    Section section = offering.getSection(sectionId.longValue());
                    if (section == null) continue;
                    sections.add(section);
                    continue block32;
                }
            }
            if (sections.size() < 2) continue;
            model.addLinkedSections(linkedClassesMustBeUsed, sections);
        }
        if ("true".equalsIgnoreCase(ApplicationProperties.getProperty("purdue.specreg.dummyReservation", "false"))) {
            for (XRequest r : s.getRequests()) {
                if (!(r instanceof CourseRequest)) continue;
                cr = (CourseRequest)r;
                for (Course course2 : cr.getCourses()) {
                    new OnlineReservation(XReservationType.Dummy.ordinal(), -3L, course2.getOffering(), -100, true, 1, true, true, true, true, true);
                }
            }
        }
        Object selection = null;
        selection = server.getConfig().getPropertyBoolean("StudentWeights.MultiCriteria", true) ? new MultiCriteriaBranchAndBoundSelection(server.getConfig()) : new SuggestionSelection(server.getConfig());
        selection.setModel(model);
        if ("true".equalsIgnoreCase(ApplicationProperties.getProperty("purdue.specreg.fixCurrentEnrollments", "false"))) {
            selection.setPreferredSections(new Hashtable());
            selection.setRequiredSections(preferredSections);
        } else {
            selection.setPreferredSections(preferredSections);
            selection.setRequiredSections(new Hashtable());
        }
        selection.setRequiredFreeTimes(new HashSet());
        selection.setRequiredUnassinged(new HashSet());
        BranchBoundSelection.BranchBoundNeighbour neighbour = selection.select((Assignment)assignment, s);
        neighbour.assign((Assignment)assignment, 0L);
        SpecialRegistrationInterface.CheckRestrictionsRequest validationRequest = new SpecialRegistrationInterface.CheckRestrictionsRequest();
        validationRequest.studentId = this.getBannerId(original);
        validationRequest.term = this.getBannerTerm(server.getAcademicSession());
        validationRequest.campus = this.getBannerCampus(server.getAcademicSession());
        validationRequest.mode = this.getSpecialRegistrationApiMode();
        HashMap<Object, Course> crn2course = new HashMap<Object, Course>();
        SpecialRegistrationInterface.CheckRestrictionsResponse validation = null;
        for (Request r : model.variables()) {
            if (!(r instanceof CourseRequest)) continue;
            CourseRequest courseRequest = (CourseRequest)r;
            Enrollment e = (Enrollment)assignment.getValue((Variable)courseRequest);
            block37: for (Course course3 : courseRequest.getCourses()) {
                if (e != null && course3.equals((Object)e.getCourse())) {
                    for (Section section : e.getSections()) {
                        String crn = this.getCRN(section, course3);
                        crn2course.put(crn, course3);
                        SpecialRegistrationHelper.addCrn(validationRequest, crn);
                    }
                    continue;
                }
                for (Enrollment x : courseRequest.values((Assignment)assignment)) {
                    if (!course3.equals((Object)x.getCourse())) continue;
                    for (Object section : x.getSections()) {
                        String crn = this.getCRN((Section)section, course3);
                        crn2course.put(crn, course3);
                        SpecialRegistrationHelper.addAltCrn(validationRequest, crn);
                    }
                    continue block37;
                }
                for (Object config : course3.getOffering().getConfigs()) {
                    Object section;
                    Enrollment x = this.firstEnrollment(courseRequest, (Assignment<Request, Enrollment>)assignment, course3, (Config)config, new HashSet<Section>(), 0);
                    if (x == null) continue;
                    section = x.getSections().iterator();
                    while (section.hasNext()) {
                        Section section3 = (Section)section.next();
                        String string = this.getCRN(section3, course3);
                        crn2course.put(string, course3);
                        SpecialRegistrationHelper.addAltCrn(validationRequest, string);
                    }
                    continue block37;
                }
            }
        }
        if (validationRequest.changes == null) {
            validationRequest.changes = new SpecialRegistrationInterface.RestrictionsCheckRequest();
        }
        ClientResource resource = null;
        try {
            resource = new ClientResource(this.getSpecialRegistrationApiValidationSite());
            resource.setNext((Uniform)this.iClient);
            resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
            Gson gson = this.getGson(helper);
            if (helper.isDebugEnabled()) {
                helper.debug("Validation Request: " + gson.toJson((Object)validationRequest));
            }
            action.addOptionBuilder().setKey("validation_request").setValue(gson.toJson((Object)validationRequest));
            long l = System.currentTimeMillis();
            resource.post(new GsonRepresentation<SpecialRegistrationInterface.CheckRestrictionsRequest>(validationRequest));
            action.setApiPostTime(System.currentTimeMillis() - l);
            validation = new GsonRepresentation<SpecialRegistrationInterface.CheckRestrictionsResponse>(resource.getResponseEntity(), SpecialRegistrationInterface.CheckRestrictionsResponse.class).getObject();
            if (helper.isDebugEnabled()) {
                helper.debug("Validation Response: " + gson.toJson((Object)validation));
            }
            action.addOptionBuilder().setKey("validation_response").setValue(gson.toJson((Object)validation));
            if (SpecialRegistrationInterface.ResponseStatus.success != validation.status) {
                throw new SectioningException(validation.message == null || validation.message.isEmpty() ? "Failed to check student eligibility (" + (Object)((Object)validation.status) + ")." : validation.message);
            }
        }
        catch (SectioningException e) {
            action.setApiException(e.getMessage());
            throw e;
        }
        catch (Exception e) {
            action.setApiException(e.getMessage());
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(e.getMessage());
        }
        finally {
            if (resource != null) {
                if (resource.getResponse() != null) {
                    resource.getResponse().release();
                }
                resource.release();
            }
        }
        Float maxCredit = student.getMaxCredit();
        if (maxCredit == null) {
            maxCredit = Float.valueOf(Float.parseFloat(ApplicationProperties.getProperty("purdue.specreg.maxCreditDefault", "18")));
        }
        SpecialRegistrationInterface.SpecialRegistrationRequest specialRegistrationRequest = new SpecialRegistrationInterface.SpecialRegistrationRequest();
        specialRegistrationRequest.studentId = this.getBannerId(original);
        specialRegistrationRequest.term = this.getBannerTerm(server.getAcademicSession());
        specialRegistrationRequest.campus = this.getBannerCampus(server.getAcademicSession());
        specialRegistrationRequest.mode = this.getSpecialRegistrationApiMode();
        specialRegistrationRequest.changes = new ArrayList();
        if (helper.getUser() != null) {
            specialRegistrationRequest.requestorId = this.getRequestorId(helper.getUser());
            specialRegistrationRequest.requestorRole = this.getRequestorType(helper.getUser(), original);
        }
        if (validation.outJson != null && validation.outJson.problems != null) {
            block43: for (SpecialRegistrationInterface.Problem problem : validation.outJson.problems) {
                if ("HOLD".equals(problem.code) || "DUPL".equals(problem.code) || "MAXI".equals(problem.code) || "CLOS".equals(problem.code) || "TIME".equals(problem.code) || (course = (Course)crn2course.get(problem.crn)) == null || ignoreLcCourses && lcCourses.contains(new XCourseId(course))) continue;
                change = null;
                for (SpecialRegistrationInterface.Change ch : specialRegistrationRequest.changes) {
                    if (!ch.subject.equals(course.getSubjectArea()) || !ch.courseNbr.equals(course.getCourseNumber())) continue;
                    change = ch;
                    break;
                }
                if (change == null) {
                    change = new SpecialRegistrationInterface.Change();
                    change.subject = course.getSubjectArea();
                    change.courseNbr = course.getCourseNumber();
                    change.crn = "";
                    change.errors = new ArrayList<SpecialRegistrationInterface.ChangeError>();
                    change.operation = SpecialRegistrationInterface.ChangeOperation.ADD;
                    specialRegistrationRequest.changes.add(change);
                } else {
                    for (SpecialRegistrationInterface.ChangeError err2 : change.errors) {
                        if (!problem.code.equals(err2.code)) continue;
                        continue block43;
                    }
                }
                err = new SpecialRegistrationInterface.ChangeError();
                ((SpecialRegistrationInterface.ChangeError)err).code = problem.code;
                ((SpecialRegistrationInterface.ChangeError)err).message = problem.message;
                if (((SpecialRegistrationInterface.ChangeError)err).message != null && ((SpecialRegistrationInterface.ChangeError)err).message.indexOf("this section") >= 0) {
                    ((SpecialRegistrationInterface.ChangeError)err).message = ((SpecialRegistrationInterface.ChangeError)err).message.replace("this section", course.getName());
                }
                if (((SpecialRegistrationInterface.ChangeError)err).message != null && ((SpecialRegistrationInterface.ChangeError)err).message.indexOf(" (CRN ") >= 0) {
                    ((SpecialRegistrationInterface.ChangeError)err).message = ((SpecialRegistrationInterface.ChangeError)err).message.replaceFirst(" \\(CRN [0-9][0-9][0-9][0-9][0-9]\\) ", " ");
                }
                change.errors.add((SpecialRegistrationInterface.ChangeError)err);
            }
        }
        if (validation.outJsonAlternatives != null && validation.outJsonAlternatives.problems != null) {
            block46: for (SpecialRegistrationInterface.Problem problem : validation.outJsonAlternatives.problems) {
                if ("HOLD".equals(problem.code) || "DUPL".equals(problem.code) || "MAXI".equals(problem.code) || "CLOS".equals(problem.code) || "TIME".equals(problem.code) || (course = (Course)crn2course.get(problem.crn)) == null || ignoreLcCourses && lcCourses.contains(new XCourseId(course))) continue;
                change = null;
                for (SpecialRegistrationInterface.Change ch : specialRegistrationRequest.changes) {
                    if (!ch.subject.equals(course.getSubjectArea()) || !ch.courseNbr.equals(course.getCourseNumber())) continue;
                    change = ch;
                    break;
                }
                if (change == null) {
                    change = new SpecialRegistrationInterface.Change();
                    change.subject = course.getSubjectArea();
                    change.courseNbr = course.getCourseNumber();
                    change.crn = "";
                    change.errors = new ArrayList<SpecialRegistrationInterface.ChangeError>();
                    change.operation = SpecialRegistrationInterface.ChangeOperation.ADD;
                    specialRegistrationRequest.changes.add(change);
                } else {
                    for (SpecialRegistrationInterface.ChangeError err2 : change.errors) {
                        if (!problem.code.equals(err2.code)) continue;
                        continue block46;
                    }
                }
                err = new SpecialRegistrationInterface.ChangeError();
                ((SpecialRegistrationInterface.ChangeError)err).code = problem.code;
                ((SpecialRegistrationInterface.ChangeError)err).message = problem.message;
                if (((SpecialRegistrationInterface.ChangeError)err).message != null && ((SpecialRegistrationInterface.ChangeError)err).message.indexOf("this section") >= 0) {
                    ((SpecialRegistrationInterface.ChangeError)err).message = ((SpecialRegistrationInterface.ChangeError)err).message.replace("this section", course.getName());
                }
                if (((SpecialRegistrationInterface.ChangeError)err).message != null && ((SpecialRegistrationInterface.ChangeError)err).message.indexOf(" (CRN ") >= 0) {
                    ((SpecialRegistrationInterface.ChangeError)err).message = ((SpecialRegistrationInterface.ChangeError)err).message.replaceFirst(" \\(CRN [0-9][0-9][0-9][0-9][0-9]\\) ", " ");
                }
                change.errors.add((SpecialRegistrationInterface.ChangeError)err);
            }
        }
        ArrayList<Float> credits = new ArrayList<Float>();
        int nrCourses = 0;
        specialRegistrationRequest.courseCreditHrs = new ArrayList<SpecialRegistrationInterface.CourseCredit>();
        specialRegistrationRequest.alternateCourseCreditHrs = new ArrayList<SpecialRegistrationInterface.CourseCredit>();
        for (XRequest r : original.getRequests()) {
            SpecialRegistrationInterface.CourseCredit cc = null;
            if (r instanceof XCourseRequest) {
                XCourseRequest cr3 = (XCourseRequest)r;
                Float credit = null;
                for (XCourseId xCourseId : cr3.getCourseIds()) {
                    XCourse course4 = server.getCourse(xCourseId.getCourseId());
                    if (course4 == null) continue;
                    if (cc == null) {
                        cc = new SpecialRegistrationInterface.CourseCredit();
                        cc.subject = course4.getSubjectArea();
                        cc.courseNbr = course4.getCourseNumber();
                        cc.title = course4.getTitle();
                        cc.creditHrs = Float.valueOf(course4.hasCredit() ? course4.getMinCredit().floatValue() : 0.0f);
                    } else {
                        if (cc.alternatives == null) {
                            cc.alternatives = new ArrayList<SpecialRegistrationInterface.CourseCredit>();
                        }
                        SpecialRegistrationInterface.CourseCredit acc = new SpecialRegistrationInterface.CourseCredit();
                        acc.subject = course4.getSubjectArea();
                        acc.courseNbr = course4.getCourseNumber();
                        acc.title = course4.getTitle();
                        acc.creditHrs = Float.valueOf(course4.hasCredit() ? course4.getMinCredit().floatValue() : 0.0f);
                        cc.alternatives.add(acc);
                    }
                    if (!course4.hasCredit() || credit != null && !(credit.floatValue() < course4.getMinCredit().floatValue())) continue;
                    credit = course4.getMinCredit();
                }
                if (credit != null) {
                    credits.add(credit);
                    if (!r.isAlternative()) {
                        ++nrCourses;
                    }
                }
            }
            if (cc == null) continue;
            if (r.isAlternative()) {
                specialRegistrationRequest.alternateCourseCreditHrs.add(cc);
                continue;
            }
            specialRegistrationRequest.courseCreditHrs.add(cc);
        }
        Collections.sort(credits);
        float total = 0.0f;
        for (int i = 0; i < nrCourses; ++i) {
            total += ((Float)credits.get(credits.size() - i - 1)).floatValue();
        }
        String maxCreditLimitStr = ApplicationProperties.getProperty("purdue.specreg.maxCreditCheck");
        if (maxCreditLimitStr != null && total > (maxCreditLimit = Float.parseFloat(maxCreditLimitStr))) {
            total = maxCreditLimit;
        }
        if (maxCredit.floatValue() < total) {
            specialRegistrationRequest.maxCredit = Float.valueOf(total);
        }
        SpecialRegistrationInterface.SpecialRegistrationResponseList response = null;
        resource = null;
        try {
            resource = new ClientResource(this.getSpecialRegistrationApiSiteSubmitRegistration());
            resource.setNext((Uniform)this.iClient);
            resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
            Gson gson = this.getGson(helper);
            if (helper.isDebugEnabled()) {
                helper.debug("Submit Request: " + gson.toJson((Object)specialRegistrationRequest));
            }
            action.addOptionBuilder().setKey("specreg_request").setValue(gson.toJson((Object)specialRegistrationRequest));
            long t1 = System.currentTimeMillis();
            resource.post(new GsonRepresentation<SpecialRegistrationInterface.SpecialRegistrationRequest>(specialRegistrationRequest));
            action.setApiPostTime(action.getApiPostTime() + System.currentTimeMillis() - t1);
            response = new GsonRepresentation<SpecialRegistrationInterface.SpecialRegistrationResponseList>(resource.getResponseEntity(), SpecialRegistrationInterface.SpecialRegistrationResponseList.class).getObject();
            if (helper.isDebugEnabled()) {
                helper.debug("Submit Response: " + gson.toJson((Object)response));
            }
            action.addOptionBuilder().setKey("specreg_response").setValue(gson.toJson((Object)response));
            if (SpecialRegistrationInterface.ResponseStatus.success != response.status) {
                throw new SectioningException(response.message == null || response.message.isEmpty() ? "Failed to request overrides (" + (Object)((Object)response.status) + ")." : response.message);
            }
        }
        catch (SectioningException e) {
            action.setApiException(e.getMessage());
            throw e;
        }
        catch (Exception e) {
            action.setApiException(e.getMessage());
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(e.getMessage());
        }
        finally {
            if (resource != null) {
                if (resource.getResponse() != null) {
                    resource.getResponse().release();
                }
                resource.release();
            }
        }
        boolean changed = false;
        for (CourseDemand cd : student.getCourseDemands()) {
            block53: for (org.unitime.timetable.model.CourseRequest cr4 : cd.getCourseRequests()) {
                if (response != null && response.data != null) {
                    for (SpecialRegistrationInterface.SpecialRegistration r : (List)response.data) {
                        if (r.changes == null) continue;
                        for (SpecialRegistrationInterface.Change ch : r.changes) {
                            if (!cr4.getCourseOffering().getSubjectAreaAbbv().equals(ch.subject) || !cr4.getCourseOffering().getCourseNbr().equals(ch.courseNbr)) continue;
                            Integer oldStatus = cr4.getOverrideStatus();
                            switch (this.status(r, false)) {
                                case OVERRIDE_REJECTED: {
                                    cr4.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.REJECTED);
                                    break;
                                }
                                case OVERRIDE_APPROVED: {
                                    cr4.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.APPROVED);
                                    break;
                                }
                                case OVERRIDE_CANCELLED: {
                                    cr4.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.CANCELLED);
                                    break;
                                }
                                case OVERRIDE_PENDING: {
                                    cr4.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.PENDING);
                                }
                            }
                            if (oldStatus == null || !oldStatus.equals(cr4.getOverrideStatus())) {
                                changed = true;
                            }
                            if (cr4.getOverrideExternalId() == null || !cr4.getOverrideExternalId().equals(r.regRequestId)) {
                                changed = true;
                            }
                            cr4.setOverrideExternalId(r.regRequestId);
                            cr4.setOverrideTimeStamp(r.dateCreated == null ? null : r.dateCreated.toDate());
                            cr4.setCourseRequestOverrideIntent(CourseRequest.CourseRequestOverrideIntent.REGISTER);
                            helper.getHibSession().update((Object)cr4);
                            continue block53;
                        }
                    }
                }
                if (cr4.getOverrideExternalId() == null && cr4.getOverrideStatus() == null) continue;
                cr4.setOverrideExternalId(null);
                cr4.setOverrideStatus(null);
                cr4.setOverrideTimeStamp(null);
                cr4.setOverrideIntent(null);
                helper.getHibSession().update((Object)cr4);
                changed = true;
            }
        }
        boolean studentChanged = false;
        if (specialRegistrationRequest.maxCredit != null) {
            for (SpecialRegistrationInterface.SpecialRegistration specialRegistration : (List)response.data) {
                if (specialRegistration.maxCredit == null) continue;
                Integer oldStatus = student.getOverrideStatus();
                switch (this.status(specialRegistration, true)) {
                    case OVERRIDE_REJECTED: {
                        student.setMaxCreditOverrideStatus(CourseRequest.CourseRequestOverrideStatus.REJECTED);
                        break;
                    }
                    case OVERRIDE_APPROVED: {
                        student.setMaxCreditOverrideStatus(CourseRequest.CourseRequestOverrideStatus.APPROVED);
                        break;
                    }
                    case OVERRIDE_CANCELLED: {
                        student.setMaxCreditOverrideStatus(CourseRequest.CourseRequestOverrideStatus.CANCELLED);
                        break;
                    }
                    case OVERRIDE_PENDING: {
                        student.setMaxCreditOverrideStatus(CourseRequest.CourseRequestOverrideStatus.PENDING);
                    }
                }
                if (oldStatus == null || !oldStatus.equals(student.getOverrideStatus())) {
                    studentChanged = true;
                }
                if (student.getOverrideMaxCredit() == null || !student.getOverrideMaxCredit().equals(specialRegistration.maxCredit)) {
                    studentChanged = true;
                }
                student.setOverrideMaxCredit(specialRegistration.maxCredit);
                if (student.getOverrideExternalId() == null || !student.getOverrideExternalId().equals(specialRegistration.regRequestId)) {
                    studentChanged = true;
                }
                student.setOverrideExternalId(specialRegistration.regRequestId);
                student.setOverrideTimeStamp(specialRegistration.dateCreated == null ? null : specialRegistration.dateCreated.toDate());
                break;
            }
        } else if (student.getOverrideExternalId() != null || student.getOverrideMaxCredit() != null) {
            student.setOverrideExternalId(null);
            student.setOverrideMaxCredit(null);
            student.setOverrideStatus(null);
            student.setOverrideTimeStamp(null);
            studentChanged = true;
        }
        if (studentChanged) {
            helper.getHibSession().update((Object)student);
        }
        if (changed) {
            helper.getHibSession().flush();
        }
        if (changed || studentChanged) {
            helper.getHibSession().flush();
        }
        return changed || studentChanged;
    }

    @Override
    public void checkEligibility(OnlineSectioningServer server, OnlineSectioningHelper helper, OnlineSectioningInterface.EligibilityCheck check, org.unitime.timetable.model.Student student) throws SectioningException {
        if (student == null) {
            return;
        }
        if (!this.isValidationEnabled(student)) {
            return;
        }
        check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.SR_CHANGE_NOTE, this.isCanChangeNote());
        if (!check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_REGISTER)) {
            return;
        }
        ClientResource resource = null;
        try {
            resource = new ClientResource(this.getSpecialRegistrationApiSiteCheckEligibility());
            resource.setNext((Uniform)this.iClient);
            AcademicSessionInfo session = server.getAcademicSession();
            String term = this.getBannerTerm(session);
            String campus = this.getBannerCampus(session);
            resource.addQueryParameter("term", term);
            resource.addQueryParameter("campus", campus);
            resource.addQueryParameter("studentId", this.getBannerId(student));
            resource.addQueryParameter("mode", this.getSpecialRegistrationApiMode().name());
            helper.getAction().addOptionBuilder().setKey("term").setValue(term);
            helper.getAction().addOptionBuilder().setKey("campus").setValue(campus);
            helper.getAction().addOptionBuilder().setKey("studentId").setValue(this.getBannerId(student));
            resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
            long t0 = System.currentTimeMillis();
            resource.get(MediaType.APPLICATION_JSON);
            helper.getAction().setApiGetTime(System.currentTimeMillis() - t0);
            SpecialRegistrationInterface.CheckEligibilityResponse eligibility = new GsonRepresentation<SpecialRegistrationInterface.CheckEligibilityResponse>(resource.getResponseEntity(), SpecialRegistrationInterface.CheckEligibilityResponse.class).getObject();
            Gson gson = this.getGson(helper);
            if (helper.isDebugEnabled()) {
                helper.debug("Eligibility: " + gson.toJson((Object)eligibility));
            }
            helper.getAction().addOptionBuilder().setKey("response").setValue(gson.toJson((Object)eligibility));
            if (SpecialRegistrationInterface.ResponseStatus.success != eligibility.status) {
                throw new SectioningException(eligibility.message == null || eligibility.message.isEmpty() ? "Failed to check student eligibility (" + (Object)((Object)eligibility.status) + ")." : eligibility.message);
            }
            if (eligibility.data == null || ((SpecialRegistrationInterface.SpecialRegistrationEligibility)eligibility.data).eligible == null || !((SpecialRegistrationInterface.SpecialRegistrationEligibility)eligibility.data).eligible.booleanValue()) {
                check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_REGISTER, helper.isAdmin());
            }
            if (eligibility.data != null && ((SpecialRegistrationInterface.SpecialRegistrationEligibility)eligibility.data).eligibilityProblems != null) {
                String m = null;
                for (SpecialRegistrationInterface.EligibilityProblem p : ((SpecialRegistrationInterface.SpecialRegistrationEligibility)eligibility.data).eligibilityProblems) {
                    if (m == null) {
                        m = p.message;
                        continue;
                    }
                    m = m + "\n" + p.message;
                }
                if (m != null) {
                    check.setMessage(MESSAGES.exceptionFailedEligibilityCheck(m));
                }
            }
        }
        catch (SectioningException e) {
            helper.getAction().setApiException(e.getMessage());
            throw e;
        }
        catch (Exception e) {
            helper.getAction().setApiException(e.getMessage() == null ? "Null" : e.getMessage());
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(e.getMessage());
        }
        finally {
            if (resource != null) {
                if (resource.getResponse() != null) {
                    resource.getResponse().release();
                }
                resource.release();
            }
        }
    }

    protected void checkStudentStatuses(OnlineSectioningServer server, OnlineSectioningHelper helper, Map<String, org.unitime.timetable.model.Student> id2student, List<Long> reloadIds, int batchNumber) throws SectioningException {
        ClientResource resource = null;
        try {
            resource = new ClientResource(this.getSpecialRegistrationApiSiteCheckAllSpecialRegistrationStatus());
            resource.setNext((Uniform)this.iClient);
            AcademicSessionInfo session = server == null ? null : server.getAcademicSession();
            String studentIds = null;
            ArrayList<String> ids = new ArrayList<String>();
            for (Map.Entry<String, org.unitime.timetable.model.Student> e : id2student.entrySet()) {
                if (session == null) {
                    session = new AcademicSessionInfo(e.getValue().getSession());
                }
                studentIds = studentIds == null ? e.getKey() : studentIds + "," + e.getKey();
                ids.add(e.getKey());
            }
            String term = this.getBannerTerm(session);
            String campus = this.getBannerCampus(session);
            resource.addQueryParameter("term", term);
            resource.addQueryParameter("campus", campus);
            resource.addQueryParameter("studentIds", studentIds);
            resource.addQueryParameter("mode", this.getSpecialRegistrationApiMode().name());
            resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
            OnlineSectioningLog.Action.Builder action = helper.getAction();
            if (action != null) {
                action.addOptionBuilder().setKey("term").setValue(term);
                action.addOptionBuilder().setKey("campus").setValue(campus);
                action.addOptionBuilder().setKey("studentIds-" + batchNumber).setValue(studentIds);
            }
            long t0 = System.currentTimeMillis();
            resource.get(MediaType.APPLICATION_JSON);
            if (action != null) {
                action.setApiGetTime(action.getApiGetTime() + System.currentTimeMillis() - t0);
            }
            SpecialRegistrationInterface.SpecialRegistrationMultipleStatusResponse response = new GsonRepresentation<SpecialRegistrationInterface.SpecialRegistrationMultipleStatusResponse>(resource.getResponseEntity(), SpecialRegistrationInterface.SpecialRegistrationMultipleStatusResponse.class).getObject();
            Gson gson = this.getGson(helper);
            if (helper.isDebugEnabled()) {
                helper.debug("Response: " + gson.toJson((Object)response));
            }
            if (action != null) {
                action.addOptionBuilder().setKey("response-" + batchNumber).setValue(gson.toJson((Object)response));
            }
            if (SpecialRegistrationInterface.ResponseStatus.success != response.status) {
                throw new SectioningException(response.message == null || response.message.isEmpty() ? "Failed to check student statuses (" + (Object)((Object)response.status) + ")." : response.message);
            }
            if (response.data != null && ((SpecialRegistrationInterface.SpecialRegistrationMultipleStatus)response.data).students != null) {
                int index = 0;
                for (SpecialRegistrationInterface.SpecialRegistrationStatus status : ((SpecialRegistrationInterface.SpecialRegistrationMultipleStatus)response.data).students) {
                    String studentId = status.studentId;
                    if (studentId == null && status.requests != null) {
                        for (SpecialRegistrationInterface.SpecialRegistration req : status.requests) {
                            if (req.studentId == null) continue;
                            studentId = req.studentId;
                            break;
                        }
                    }
                    if (studentId == null) {
                        studentId = (String)ids.get(index);
                    }
                    ++index;
                    org.unitime.timetable.model.Student student = id2student.get(studentId);
                    if (student == null) continue;
                    boolean changed = false;
                    for (CourseDemand cd : student.getCourseDemands()) {
                        for (org.unitime.timetable.model.CourseRequest cr : cd.getCourseRequests()) {
                            if (cr.getOverrideExternalId() == null) continue;
                            SpecialRegistrationInterface.SpecialRegistration req = null;
                            for (SpecialRegistrationInterface.SpecialRegistration r : status.requests) {
                                if (!cr.getOverrideExternalId().equals(r.regRequestId)) continue;
                                req = r;
                                break;
                            }
                            if (req == null) {
                                if (cr.getCourseRequestOverrideStatus() == CourseRequest.CourseRequestOverrideStatus.CANCELLED) continue;
                                cr.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.CANCELLED);
                                helper.getHibSession().update((Object)cr);
                                changed = true;
                                continue;
                            }
                            Integer oldStatus = cr.getOverrideStatus();
                            switch (this.status(req, false)) {
                                case OVERRIDE_REJECTED: {
                                    cr.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.REJECTED);
                                    break;
                                }
                                case OVERRIDE_APPROVED: {
                                    cr.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.APPROVED);
                                    break;
                                }
                                case OVERRIDE_CANCELLED: {
                                    cr.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.CANCELLED);
                                    break;
                                }
                                case OVERRIDE_PENDING: {
                                    cr.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.PENDING);
                                }
                            }
                            if (oldStatus != null && oldStatus.equals(cr.getOverrideStatus())) continue;
                            helper.getHibSession().update((Object)cr);
                            changed = true;
                        }
                    }
                    boolean studentChanged = false;
                    if (status.maxCredit != null && !status.maxCredit.equals(student.getMaxCredit())) {
                        student.setMaxCredit(status.maxCredit);
                        studentChanged = true;
                    }
                    if (student.getOverrideExternalId() != null) {
                        SpecialRegistrationInterface.SpecialRegistration req = null;
                        for (SpecialRegistrationInterface.SpecialRegistration r : status.requests) {
                            if (!student.getOverrideExternalId().equals(r.regRequestId)) continue;
                            req = r;
                            break;
                        }
                        if (req == null) {
                            student.setOverrideExternalId(null);
                            student.setOverrideMaxCredit(null);
                            student.setOverrideStatus(null);
                            student.setOverrideTimeStamp(null);
                            studentChanged = true;
                        } else {
                            Integer oldStatus = student.getOverrideStatus();
                            switch (this.status(req, true)) {
                                case OVERRIDE_REJECTED: {
                                    student.setMaxCreditOverrideStatus(CourseRequest.CourseRequestOverrideStatus.REJECTED);
                                    break;
                                }
                                case OVERRIDE_APPROVED: {
                                    student.setMaxCreditOverrideStatus(CourseRequest.CourseRequestOverrideStatus.APPROVED);
                                    break;
                                }
                                case OVERRIDE_CANCELLED: {
                                    student.setMaxCreditOverrideStatus(CourseRequest.CourseRequestOverrideStatus.CANCELLED);
                                    break;
                                }
                                case OVERRIDE_PENDING: {
                                    student.setMaxCreditOverrideStatus(CourseRequest.CourseRequestOverrideStatus.PENDING);
                                }
                            }
                            if (oldStatus == null || !oldStatus.equals(student.getOverrideStatus())) {
                                studentChanged = true;
                            }
                        }
                    }
                    if (studentChanged) {
                        helper.getHibSession().update((Object)student);
                    }
                    if (!changed && !studentChanged) continue;
                    reloadIds.add(student.getUniqueId());
                }
            }
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(e.getMessage());
        }
        finally {
            if (resource != null) {
                if (resource.getResponse() != null) {
                    resource.getResponse().release();
                }
                resource.release();
            }
        }
    }

    @Override
    public Collection<Long> updateStudents(OnlineSectioningServer server, OnlineSectioningHelper helper, List<org.unitime.timetable.model.Student> students) throws SectioningException {
        HashMap<String, org.unitime.timetable.model.Student> id2student = new HashMap<String, org.unitime.timetable.model.Student>();
        ArrayList<Long> reloadIds = new ArrayList<Long>();
        int batchNumber = 1;
        for (int i = 0; i < students.size(); ++i) {
            org.unitime.timetable.model.Student student = students.get(i);
            if (student == null || !this.hasPendingOverride(student) || !this.isValidationEnabled(student)) continue;
            String id = this.getBannerId(student);
            id2student.put(id, student);
            if (id2student.size() < 100) continue;
            this.checkStudentStatuses(server, helper, id2student, reloadIds, batchNumber++);
            id2student.clear();
        }
        if (!id2student.isEmpty()) {
            this.checkStudentStatuses(server, helper, id2student, reloadIds, batchNumber++);
        }
        if (!reloadIds.isEmpty()) {
            helper.getHibSession().flush();
        }
        if (!reloadIds.isEmpty() && server != null && !(server instanceof DatabaseServer)) {
            server.execute(server.createAction(ReloadStudent.class).forStudents(reloadIds), helper.getUser());
        }
        return reloadIds;
    }
}

