/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.custom.purdue;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.cpsolver.ifs.heuristics.RouletteWheelSelection;
import org.restlet.Client;
import org.restlet.Uniform;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.MediaType;
import org.restlet.data.Protocol;
import org.restlet.resource.ClientResource;
import org.restlet.resource.ResourceException;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.server.Query;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.DegreePlanInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.CourseRequestsProvider;
import org.unitime.timetable.onlinesectioning.custom.CriticalCoursesProvider;
import org.unitime.timetable.onlinesectioning.custom.CustomCourseLookupHolder;
import org.unitime.timetable.onlinesectioning.custom.DegreePlansProvider;
import org.unitime.timetable.onlinesectioning.custom.ExternalTermProvider;
import org.unitime.timetable.onlinesectioning.custom.purdue.BannerTermProvider;
import org.unitime.timetable.onlinesectioning.custom.purdue.GsonRepresentation;
import org.unitime.timetable.onlinesectioning.custom.purdue.XEInterface;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XStudentId;
import org.unitime.timetable.onlinesectioning.status.StatusPageSuggestionsAction;

public class DegreeWorksCourseRequests
implements CourseRequestsProvider,
DegreePlansProvider,
CriticalCoursesProvider {
    private static Logger sLog = Logger.getLogger(DegreeWorksCourseRequests.class);
    private static StudentSectioningConstants CONST = Localization.create(StudentSectioningConstants.class);
    private Client iClient;
    private ExternalTermProvider iExternalTermProvider;

    public DegreeWorksCourseRequests() {
        ArrayList<Protocol> protocols = new ArrayList<Protocol>();
        protocols.add(Protocol.HTTP);
        protocols.add(Protocol.HTTPS);
        this.iClient = new Client(protocols);
        try {
            String clazz = ApplicationProperty.CustomizationExternalTerm.value();
            this.iExternalTermProvider = clazz == null || clazz.isEmpty() ? new BannerTermProvider() : (ExternalTermProvider)Class.forName(clazz).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            sLog.error((Object)"Failed to create external term provider, using the default one instead.", (Throwable)e);
            this.iExternalTermProvider = new BannerTermProvider();
        }
    }

    protected String getDegreeWorksApiSite() {
        return ApplicationProperties.getProperty("banner.dgw.site");
    }

    protected String getDegreeWorksApiUser() {
        return ApplicationProperties.getProperty("banner.dgw.user");
    }

    protected String getDegreeWorksApiPassword() {
        return ApplicationProperties.getProperty("banner.dgw.password");
    }

    protected String getDegreeWorksApiEffectiveOnly() {
        return ApplicationProperties.getProperty("banner.dgw.effectiveOnly", "false");
    }

    protected String getDegreeWorksErrorPattern() {
        return ApplicationProperties.getProperty("banner.dgw.errorPattern", "<div class=\"exceptionMessage\">\n(.*)\n\n</div>");
    }

    protected boolean getDegreeWorksActiveOnly() {
        return "true".equalsIgnoreCase(ApplicationProperties.getProperty("banner.dgw.activeOnly", "true"));
    }

    protected String getDegreeWorksNoPlansMessage() {
        return ApplicationProperties.getProperty("banner.dgw.noPlansMessage", "No active degree plan is available.");
    }

    protected String getCreditSQL() {
        return ApplicationProperties.getProperty("banner.dgw.creditSQL", "select subject_code, course_numb, course_title, final_grade from timetable.szv_utm_apcredit where puid = :puid and final_grade != 'F'");
    }

    protected int getDegreeWorksNrAttempts() {
        return Integer.parseInt(ApplicationProperties.getProperty("banner.dgw.nrAttempts", "3"));
    }

    protected Query getStudentFilter() {
        String filter = ApplicationProperties.getProperty("banner.dgw.studentFilter");
        return filter == null || filter.isEmpty() ? null : new Query(filter);
    }

    protected String getBannerId(XStudentId student) {
        String id = student.getExternalId();
        while (id.length() < 9) {
            id = "0" + id;
        }
        return id;
    }

    protected String getBannerTerm(AcademicSessionInfo session) {
        return this.iExternalTermProvider.getExternalTerm(session);
    }

    protected Gson getGson(OnlineSectioningHelper helper) {
        GsonBuilder builder = new GsonBuilder();
        if (helper.isDebugEnabled()) {
            builder.setPrettyPrinting();
        }
        return builder.create();
    }

    protected XCourseId getCourse(OnlineSectioningServer server, XEInterface.Course course) {
        Collection<? extends XCourseId> courses = server.findCourses(course.courseDiscipline + " " + course.courseNumber, -1, null);
        for (XCourseId xCourseId : courses) {
            if (!xCourseId.matchTitle(course.title)) continue;
            return xCourseId;
        }
        Iterator<? extends XCourseId> iterator = courses.iterator();
        while (iterator.hasNext()) {
            XCourseId xCourseId = iterator.next();
            if (!xCourseId.getCourseName().equalsIgnoreCase(course.courseDiscipline + " " + course.courseNumber)) continue;
            return xCourseId;
        }
        if ((courses.size() == 1 || "true".equalsIgnoreCase(ApplicationProperties.getProperty("banner.dgw.firstSuffixedCourse", "true"))) && (iterator = courses.iterator()).hasNext()) {
            XCourseId xCourseId = iterator.next();
            return xCourseId;
        }
        if (!courses.isEmpty() || "true".equalsIgnoreCase(ApplicationProperties.getProperty("banner.dgw.includeNotOfferedCourses", "true"))) {
            return new XCourseId(null, null, course.courseDiscipline + " " + course.courseNumber);
        }
        return null;
    }

    protected OnlineSectioningLog.Entity toEntity(XEInterface.Course course, XCourseId courseId) {
        OnlineSectioningLog.Entity.Builder builder = OnlineSectioningLog.Entity.newBuilder();
        if (courseId.getCourseId() != null) {
            builder.setUniqueId(courseId.getCourseId());
        }
        builder.setName(courseId.getCourseName());
        builder.setExternalId(course.courseDiscipline + " " + course.courseNumber + (course.title != null && !course.title.isEmpty() ? " - " + course.title : ""));
        return builder.build();
    }

    protected OnlineSectioningLog.Entity toEntity(XCourseId courseId) {
        OnlineSectioningLog.Entity.Builder builder = OnlineSectioningLog.Entity.newBuilder();
        if (courseId.getCourseId() != null) {
            builder.setUniqueId(courseId.getCourseId());
        }
        builder.setName(courseId.getCourseName());
        return builder.build();
    }

    protected boolean hasSelection(XEInterface.Group group) {
        if ("CH".equals(group.groupType.code)) {
            for (XEInterface.Course course : group.plannedClasses) {
                if (!course.isGroupSelection) continue;
                return true;
            }
            for (XEInterface.Group g : group.groups) {
                if (!this.hasSelection(g)) continue;
                return true;
            }
            return false;
        }
        return group.isGroupSelection;
    }

    /*
     * WARNING - void declaration
     */
    protected void fillInRequests(OnlineSectioningServer server, OnlineSectioningHelper helper, CourseRequestInterface request, XEInterface.Group group) {
        block38: {
            CourseRequestInterface.RequestedCourse rc;
            CourseRequestInterface.Request r;
            block37: {
                if (!"CH".equals(group.groupType.code)) break block37;
                boolean hasSelection = false;
                for (XEInterface.Course course : group.plannedClasses) {
                    XCourse xCourse;
                    Iterator<XEInterface.Course> cid;
                    if (!course.isGroupSelection || (cid = this.getCourse(server, course)) == null) continue;
                    OnlineSectioningLog.Request.Builder b = helper.getAction().addRequestBuilder().setPriority(request.getCourses().size()).setAlternative(false).addCourse(this.toEntity(course, (XCourseId)((Object)cid)));
                    CourseRequestInterface.Request r2 = new CourseRequestInterface.Request();
                    CourseRequestInterface.RequestedCourse rc2 = new CourseRequestInterface.RequestedCourse();
                    rc2.setCourseId(((XCourseId)((Object)cid)).getCourseId());
                    rc2.setCourseName(((XCourseId)((Object)cid)).getCourseName());
                    rc2.setCourseTitle(((XCourseId)((Object)cid)).getTitle());
                    if (cid instanceof XCourse) {
                        rc2.setCredit(((XCourse)((Object)cid)).getMinCredit(), ((XCourse)((Object)cid)).getMaxCredit());
                    } else if (((XCourseId)((Object)cid)).getCourseId() != null && (xCourse = server.getCourse(((XCourseId)((Object)cid)).getCourseId())) != null) {
                        rc2.setCredit(xCourse.getMinCredit(), xCourse.getMaxCredit());
                    }
                    r2.setCritical(group.isCritical);
                    if (group.isCritical != null) {
                        b.setCritical(group.isCritical);
                    }
                    r2.addRequestedCourse(rc2);
                    request.addCourseCriticalFirst(r2);
                    hasSelection = true;
                    for (XEInterface.Course other : group.plannedClasses) {
                        XCourse c2;
                        XCourseId ocid;
                        if (other.isGroupSelection || (ocid = this.getCourse(server, other)) == null || ocid.getCourseId() == null) continue;
                        CourseRequestInterface.RequestedCourse orc = new CourseRequestInterface.RequestedCourse();
                        orc.setCourseId(ocid.getCourseId());
                        orc.setCourseName(ocid.getCourseName());
                        orc.setCourseTitle(ocid.getTitle());
                        if (ocid instanceof XCourse) {
                            orc.setCredit(((XCourse)ocid).getMinCredit(), ((XCourse)ocid).getMaxCredit());
                        } else if (ocid.getCourseId() != null && (c2 = server.getCourse(ocid.getCourseId())) != null) {
                            orc.setCredit(c2.getMinCredit(), c2.getMaxCredit());
                        }
                        r2.addRequestedCourse(orc);
                        b.addCourse(this.toEntity(other, ocid));
                    }
                }
                for (XEInterface.Group g : group.groups) {
                    if (!this.hasSelection(g)) continue;
                    this.fillInRequests(server, helper, request, g);
                    hasSelection = true;
                    for (XEInterface.Course other : group.plannedClasses) {
                        void var12_28;
                        XCourse xCourse;
                        XCourseId ocid;
                        if (other.isGroupSelection || (ocid = this.getCourse(server, other)) == null || ocid.getCourseId() == null) continue;
                        CourseRequestInterface.RequestedCourse orc = new CourseRequestInterface.RequestedCourse();
                        orc.setCourseId(ocid.getCourseId());
                        orc.setCourseName(ocid.getCourseName());
                        orc.setCourseTitle(ocid.getTitle());
                        if (ocid instanceof XCourse) {
                            orc.setCredit(((XCourse)ocid).getMinCredit(), ((XCourse)ocid).getMaxCredit());
                        } else if (ocid.getCourseId() != null && (xCourse = server.getCourse(ocid.getCourseId())) != null) {
                            orc.setCredit(xCourse.getMinCredit(), xCourse.getMaxCredit());
                        }
                        Object var12_25 = null;
                        OnlineSectioningLog.Request.Builder b = null;
                        if (request.getCourses().isEmpty()) {
                            CourseRequestInterface.Request request2 = new CourseRequestInterface.Request();
                            b = helper.getAction().addRequestBuilder().setPriority(request.getCourses().size()).setAlternative(false);
                            request.addCourseCriticalFirst(request2);
                        } else {
                            CourseRequestInterface.Request request3 = request.getCourses().get(request.getCourses().size() - 1);
                            b = helper.getAction().getRequestBuilder(helper.getAction().getRequestCount() - 1);
                        }
                        var12_28.addRequestedCourse(orc);
                        b.addCourse(this.toEntity(other, ocid));
                    }
                }
                if (hasSelection) break block38;
                CourseRequestInterface.Request r4 = new CourseRequestInterface.Request();
                OnlineSectioningLog.Request.Builder b = OnlineSectioningLog.Request.newBuilder().setPriority(request.getCourses().size()).setAlternative(false);
                for (XEInterface.Course course : group.plannedClasses) {
                    XCourse xCourse;
                    XCourseId cid = this.getCourse(server, course);
                    if (cid == null || cid.getCourseId() == null) continue;
                    CourseRequestInterface.RequestedCourse rc2 = new CourseRequestInterface.RequestedCourse();
                    rc2.setCourseId(cid.getCourseId());
                    rc2.setCourseName(cid.getCourseName());
                    rc2.setCourseTitle(cid.getTitle());
                    if (cid instanceof XCourse) {
                        rc2.setCredit(((XCourse)cid).getMinCredit(), ((XCourse)cid).getMaxCredit());
                    } else if (cid.getCourseId() != null && (xCourse = server.getCourse(cid.getCourseId())) != null) {
                        rc2.setCredit(xCourse.getMinCredit(), xCourse.getMaxCredit());
                    }
                    r4.addRequestedCourse(rc2);
                    b.addCourse(this.toEntity(course, cid));
                }
                if (!r4.hasRequestedCourse()) break block38;
                r4.setCritical(group.isCritical);
                if (group.isCritical != null) {
                    b.setCritical(group.isCritical);
                }
                helper.getAction().addRequest(b);
                request.addCourseCriticalFirst(r4);
                break block38;
            }
            for (XEInterface.Course course : group.plannedClasses) {
                Object c;
                XCourseId cid = this.getCourse(server, course);
                if (cid == null) continue;
                OnlineSectioningLog.Request.Builder b = helper.getAction().addRequestBuilder().setPriority(request.getCourses().size()).setAlternative(false).addCourse(this.toEntity(course, cid));
                r = new CourseRequestInterface.Request();
                rc = new CourseRequestInterface.RequestedCourse();
                rc.setCourseId(cid.getCourseId());
                rc.setCourseName(cid.getCourseName());
                rc.setCourseTitle(cid.getTitle());
                if (cid instanceof XCourse) {
                    rc.setCredit(((XCourse)cid).getMinCredit(), ((XCourse)cid).getMaxCredit());
                } else if (cid.getCourseId() != null && (c = server.getCourse(cid.getCourseId())) != null) {
                    rc.setCredit(((XCourse)c).getMinCredit(), ((XCourse)c).getMaxCredit());
                }
                r.setCritical(course.isCritical);
                if (course.isCritical != null) {
                    b.setCritical(course.isCritical);
                }
                r.addRequestedCourse(rc);
                request.addCourseCriticalFirst(r);
            }
            for (XEInterface.Group g : group.groups) {
                this.fillInRequests(server, helper, request, g);
            }
            for (XEInterface.PlaceHolder ph : group.plannedPlaceholders) {
                List<XCourse> phc = this.getPlaceHolderCourses(server, helper, ph);
                ArrayList<XCourse> courses = null;
                if (phc != null && !phc.isEmpty()) {
                    courses = new ArrayList<XCourse>();
                    String lastSubject = null;
                    String lastCourse = null;
                    for (XCourse xCourse : phc) {
                        if (lastSubject != null && lastSubject.equals(xCourse.getSubjectArea()) && lastCourse != null && xCourse.getCourseNumber().startsWith(lastCourse)) continue;
                        courses.add(xCourse);
                        lastSubject = this.iExternalTermProvider.getExternalSubject(server.getAcademicSession(), xCourse.getSubjectArea(), xCourse.getCourseNumber());
                        lastCourse = this.iExternalTermProvider.getExternalCourseNumber(server.getAcademicSession(), xCourse.getSubjectArea(), xCourse.getCourseNumber());
                    }
                }
                if (courses != null && !courses.isEmpty() && courses.size() <= CONST.degreePlanMaxAlternatives()) {
                    r = new CourseRequestInterface.Request();
                    r.setFilter(ph.placeholderValue);
                    OnlineSectioningLog.Request.Builder b = OnlineSectioningLog.Request.newBuilder().setPriority(request.getCourses().size()).setAlternative(false);
                    RouletteWheelSelection roulette = new RouletteWheelSelection();
                    for (XCourse course : courses) {
                        int av1 = 4 * (course.getLimit() < 0 ? 9999 : course.getLimit());
                        Collection<XCourseRequest> reqs = server.getRequests(course.getOfferingId());
                        if (reqs != null) {
                            for (XCourseRequest req : reqs) {
                                if (req.getEnrollment() != null && req.getEnrollment().getCourseId().equals(course.getCourseId())) {
                                    av1 -= 3;
                                }
                                if (req.isAlternative() || req.getEnrollment() != null || !req.getCourseIds().get(0).equals(course)) continue;
                                --av1;
                            }
                        }
                        roulette.add((Object)course, (double)av1);
                    }
                    while (roulette.hasMoreElements()) {
                        XCourse xCourse = (XCourse)roulette.nextElement();
                        CourseRequestInterface.RequestedCourse orc = new CourseRequestInterface.RequestedCourse();
                        orc.setCourseId(xCourse.getCourseId());
                        orc.setCourseName(xCourse.getCourseName());
                        orc.setCourseTitle(xCourse.getTitle());
                        orc.setCredit(xCourse.getMinCredit(), xCourse.getMaxCredit());
                        r.addRequestedCourse(orc);
                        b.addCourse(this.toEntity(xCourse));
                    }
                    if (this.isCriticalPlaceholder(ph)) {
                        r.setCritical(true);
                        b.setCritical(true);
                    }
                    helper.getAction().addRequest(b);
                    request.addCourseCriticalFirst(r);
                    continue;
                }
                if (!"true".equalsIgnoreCase(ApplicationProperties.getProperty("banner.dgw.includePlaceHolders", "true"))) continue;
                r = new CourseRequestInterface.Request();
                rc = new CourseRequestInterface.RequestedCourse();
                rc.setCourseName(ph.placeholderValue.trim());
                r.addRequestedCourse(rc);
                request.addCourseCriticalFirst(r);
            }
        }
    }

    protected String toString(Reader reader) throws IOException {
        char[] buffer = new char[8192];
        StringBuilder out = new StringBuilder();
        int read = 0;
        while ((read = reader.read(buffer, 0, buffer.length)) > 0) {
            out.append(buffer, 0, read);
        }
        reader.close();
        return out.toString();
    }

    @Override
    public CourseRequestInterface getCourseRequests(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudentId student) throws SectioningException {
        try {
            String effectiveOnly;
            Query q = this.getStudentFilter();
            if (q != null) {
                XStudent s;
                XStudent xStudent = s = student instanceof XStudent ? (XStudent)student : server.getStudent(student.getStudentId());
                if (s == null || !q.match(new StatusPageSuggestionsAction.StudentMatcher(s, server.getAcademicSession().getDefaultSectioningStatus(), server, false))) {
                    return null;
                }
            }
            AcademicSessionInfo session = server.getAcademicSession();
            String term = this.getBannerTerm(session);
            String studentId = this.getBannerId(student);
            if (helper.isDebugEnabled()) {
                helper.debug("Retrieving student plan for " + student.getName() + " (term: " + term + ", id:" + studentId + ")");
            }
            if ((effectiveOnly = this.getDegreeWorksApiEffectiveOnly()) != null) {
                helper.getAction().addOptionBuilder().setKey("effectiveOnly").setValue(effectiveOnly);
            }
            List<XEInterface.DegreePlan> current = null;
            long t0 = System.currentTimeMillis();
            try {
                current = this.getDegreePlans(term, studentId, effectiveOnly, this.getDegreeWorksNrAttempts());
            }
            catch (SectioningException e) {
                helper.getAction().setApiException(e.getMessage());
                throw e;
            }
            finally {
                helper.getAction().setApiGetTime(System.currentTimeMillis() - t0);
            }
            if (current != null && !current.isEmpty()) {
                Gson gson = this.getGson(helper);
                helper.getAction().addOptionBuilder().setKey("response").setValue(gson.toJson(current));
                for (XEInterface.DegreePlan plan : current) {
                    if (plan.isActive == null || !plan.isActive.value || plan.years == null) continue;
                    for (XEInterface.Year y : plan.years) {
                        if (y.terms == null) continue;
                        for (XEInterface.Term t : y.terms) {
                            if (t.term == null || !term.equals(t.term.code) || t.group == null) continue;
                            if (helper.isDebugEnabled()) {
                                helper.debug("Current degree plan: " + gson.toJson((Object)t.group));
                            }
                            CourseRequestInterface request = new CourseRequestInterface();
                            request.setAcademicSessionId(server.getAcademicSession().getUniqueId());
                            request.setStudentId(student.getStudentId());
                            this.fillInRequests(server, helper, request, t.group);
                            if (helper.isDebugEnabled()) {
                                helper.debug("Course Requests: " + request);
                            }
                            return request;
                        }
                    }
                }
            }
            if (helper.isDebugEnabled()) {
                helper.debug("No degree plan has been returned.");
            }
            return null;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SectioningException(e.getMessage(), e);
        }
    }

    @Override
    public void dispose() {
        try {
            this.iClient.stop();
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected DegreePlanInterface.DegreeGroupInterface toGroup(OnlineSectioningServer server, OnlineSectioningHelper helper, XEInterface.Group g) {
        Collection<XCourseRequest> requests;
        int enrl;
        int firstChoiceReqs;
        ClassAssignmentInterface.CourseAssignment ca;
        DegreePlanInterface.DegreeGroupInterface group = new DegreePlanInterface.DegreeGroupInterface();
        group.setChoice(g.groupType != null && "CH".equals(g.groupType.code));
        group.setDescription(g.summaryDescription);
        group.setCritical(g.isCritical);
        group.setId(g.id);
        if (g.plannedClasses != null) {
            for (XEInterface.Course c : g.plannedClasses) {
                if (c.courseDiscipline == null || c.courseNumber == null) continue;
                DegreePlanInterface.DegreeCourseInterface course = new DegreePlanInterface.DegreeCourseInterface();
                if (group.isChoice()) {
                    course.setSelected(c.isGroupSelection);
                }
                course.setSubject(c.courseDiscipline);
                course.setCourse(c.courseNumber);
                course.setTitle(c.title);
                course.setId(c.id);
                course.setCritical(c.isCritical);
                Collection<? extends XCourseId> ids = server.findCourses(c.courseDiscipline + " " + c.courseNumber, -1, null);
                if (ids != null) {
                    for (XCourseId xCourseId : ids) {
                        XCourse xc = xCourseId instanceof XCourse ? (XCourse)xCourseId : server.getCourse(xCourseId.getCourseId());
                        if (xc == null || !xCourseId.getCourseName().startsWith(c.courseDiscipline + " " + c.courseNumber)) continue;
                        ca = new ClassAssignmentInterface.CourseAssignment();
                        ca.setCourseId(xc.getCourseId());
                        ca.setSubject(xc.getSubjectArea());
                        ca.setCourseNbr(xc.getCourseNumber());
                        ca.setTitle(xc.getTitle());
                        ca.setNote(xc.getNote());
                        ca.setCreditAbbv(xc.getCreditAbbv());
                        ca.setCreditText(xc.getCreditText());
                        ca.setTitle(xc.getTitle());
                        ca.setHasUniqueName(xc.hasUniqueName());
                        ca.setLimit(xc.getLimit());
                        firstChoiceReqs = 0;
                        enrl = 0;
                        requests = server.getRequests(xCourseId.getOfferingId());
                        if (requests != null) {
                            for (XCourseRequest r : requests) {
                                if (r.getEnrollment() != null && r.getEnrollment().getCourseId().equals(xCourseId.getCourseId())) {
                                    ++enrl;
                                }
                                if (r.isAlternative() || r.getEnrollment() != null || !r.getCourseIds().get(0).equals(xCourseId)) continue;
                                ++firstChoiceReqs;
                            }
                        }
                        ca.setEnrollment(enrl);
                        ca.setProjected(firstChoiceReqs);
                        course.addCourse(ca);
                    }
                }
                if (course.hasCourses()) {
                    for (ClassAssignmentInterface.CourseAssignment courseAssignment : course.getCourses()) {
                        if (!courseAssignment.getSubject().equals(course.getSubject()) || !courseAssignment.getCourseNbr().equals(course.getCourse())) continue;
                        course.setCourseId(courseAssignment.getCourseId());
                    }
                }
                group.addCourse(course);
            }
        }
        if (g.groups != null) {
            for (XEInterface.Group ch : g.groups) {
                DegreePlanInterface.DegreeGroupInterface childGroup = this.toGroup(server, helper, ch);
                if (childGroup.countItems() <= 1 || childGroup.isChoice() == group.isChoice()) {
                    group.merge(childGroup);
                    continue;
                }
                if (group.isChoice()) {
                    childGroup.setSelected(this.hasSelection(ch));
                }
                group.addGroup(childGroup);
            }
        }
        if (g.plannedPlaceholders != null) {
            for (XEInterface.PlaceHolder ph : g.plannedPlaceholders) {
                List<XCourse> phc = this.getPlaceHolderCourses(server, helper, ph);
                if (phc != null && !phc.isEmpty()) {
                    DegreePlanInterface.DegreeGroupInterface phg = new DegreePlanInterface.DegreeGroupInterface();
                    phg.setChoice(true);
                    phg.setPlaceHolder(true);
                    phg.setDescription(ph.placeholderValue);
                    phg.setId(ph.id);
                    phg.setCritical(this.isCriticalPlaceholder(ph));
                    DegreePlanInterface.DegreeCourseInterface course = null;
                    for (XCourse xc : phc) {
                        if (course == null || !course.getSubject().equals(xc.getSubjectArea()) || !xc.getCourseNumber().startsWith(course.getCourse())) {
                            course = new DegreePlanInterface.DegreeCourseInterface();
                            course.setSubject(this.iExternalTermProvider.getExternalSubject(server.getAcademicSession(), xc.getSubjectArea(), xc.getCourseNumber()));
                            course.setCourse(this.iExternalTermProvider.getExternalCourseNumber(server.getAcademicSession(), xc.getSubjectArea(), xc.getCourseNumber()));
                            course.setTitle(xc.getTitle());
                            course.setId(ph.id + "-" + xc.getCourseId());
                            course.setCourseId(xc.getCourseId());
                            course.setSelected(false);
                            phg.addCourse(course);
                        }
                        ca = new ClassAssignmentInterface.CourseAssignment();
                        ca.setCourseId(xc.getCourseId());
                        ca.setSubject(xc.getSubjectArea());
                        ca.setCourseNbr(xc.getCourseNumber());
                        ca.setTitle(xc.getTitle());
                        ca.setNote(xc.getNote());
                        ca.setCreditAbbv(xc.getCreditAbbv());
                        ca.setCreditText(xc.getCreditText());
                        ca.setTitle(xc.getTitle());
                        ca.setHasUniqueName(xc.hasUniqueName());
                        ca.setLimit(xc.getLimit());
                        firstChoiceReqs = 0;
                        enrl = 0;
                        requests = server.getRequests(xc.getOfferingId());
                        if (requests != null) {
                            for (XCourseRequest r : requests) {
                                if (r.getEnrollment() != null && r.getEnrollment().getCourseId().equals(xc.getCourseId())) {
                                    ++enrl;
                                }
                                if (r.isAlternative() || r.getEnrollment() != null || !r.getCourseIds().get(0).equals(xc)) continue;
                                ++firstChoiceReqs;
                            }
                        }
                        ca.setEnrollment(enrl);
                        ca.setProjected(firstChoiceReqs);
                        course.addCourse(ca);
                    }
                    group.addGroup(phg);
                    continue;
                }
                DegreePlanInterface.DegreePlaceHolderInterface placeHolder = new DegreePlanInterface.DegreePlaceHolderInterface();
                placeHolder.setType(ph.placeholderType == null ? null : ph.placeholderType.description);
                placeHolder.setName(ph.placeholderValue);
                placeHolder.setId(ph.id);
                group.addPlaceHolder(placeHolder);
            }
        }
        return group;
    }

    protected List<XEInterface.DegreePlan> getDegreePlans(String term, String studentId, String effectiveOnly) throws SectioningException {
        ClientResource resource = null;
        try {
            resource = new ClientResource(this.getDegreeWorksApiSite());
            resource.setNext((Uniform)this.iClient);
            if (term != null) {
                resource.addQueryParameter("terms", term);
            }
            resource.addQueryParameter("studentId", studentId);
            if (effectiveOnly != null) {
                resource.addQueryParameter("effectiveOnly", effectiveOnly);
            }
            resource.setChallengeResponse(ChallengeScheme.HTTP_BASIC, this.getDegreeWorksApiUser(), this.getDegreeWorksApiPassword());
            try {
                resource.get(MediaType.APPLICATION_JSON);
            }
            catch (ResourceException exception) {
                try {
                    String response = this.toString(resource.getResponseEntity().getReader());
                    Pattern pattern = Pattern.compile(this.getDegreeWorksErrorPattern(), 11);
                    Matcher match = pattern.matcher(response);
                    if (match.find()) {
                        throw new SectioningException(match.group(1));
                    }
                }
                catch (SectioningException e) {
                    throw e;
                }
                finally {
                    throw exception;
                }
                {
                }
            }
            List exception = (List)new GsonRepresentation(resource.getResponseEntity(), XEInterface.DegreePlan.TYPE_LIST).getObject();
            return exception;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SectioningException(e.getMessage(), e);
        }
        finally {
            if (resource != null) {
                if (resource.getResponse() != null) {
                    resource.getResponse().release();
                }
                resource.release();
            }
        }
    }

    protected List<XEInterface.DegreePlan> getDegreePlans(String term, String studentId, String effectiveOnly, int nrAttempts) throws SectioningException {
        SectioningException exception = null;
        if (nrAttempts > 1) {
            for (int i = 0; i < nrAttempts; ++i) {
                try {
                    return this.getDegreePlans(term, studentId, effectiveOnly);
                }
                catch (SectioningException e) {
                    sLog.warn((Object)("Failed to retrieve degree plans for " + studentId + " [" + (1 + i) + ". attempt]: " + e.getMessage()));
                    exception = e;
                    continue;
                }
            }
            if (exception != null) {
                throw exception;
            }
            return null;
        }
        return this.getDegreePlans(term, studentId, effectiveOnly);
    }

    @Override
    public List<DegreePlanInterface> getDegreePlans(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student) throws SectioningException {
        try {
            AcademicSessionInfo session = server.getAcademicSession();
            String term = this.getBannerTerm(session);
            String studentId = this.getBannerId(student);
            if (helper.isDebugEnabled()) {
                helper.debug("Retrieving degree plans for " + student.getName() + " (term: " + term + ", id:" + studentId + ")");
            }
            String effectiveOnly = this.getDegreeWorksApiEffectiveOnly();
            helper.getAction().addOptionBuilder().setKey("terms").setValue(term);
            helper.getAction().addOptionBuilder().setKey("studentId").setValue(studentId);
            if (effectiveOnly != null) {
                helper.getAction().addOptionBuilder().setKey("effectiveOnly").setValue(effectiveOnly);
            }
            List<XEInterface.DegreePlan> current = null;
            long t0 = System.currentTimeMillis();
            try {
                current = this.getDegreePlans(term, studentId, effectiveOnly, this.getDegreeWorksNrAttempts());
            }
            catch (SectioningException e) {
                helper.getAction().setApiException(e.getMessage());
                throw e;
            }
            finally {
                helper.getAction().setApiGetTime(System.currentTimeMillis() - t0);
            }
            if (current == null) {
                throw new SectioningException(this.getDegreeWorksNoPlansMessage()).withTypeInfo();
            }
            Gson gson = this.getGson(helper);
            helper.getAction().addOptionBuilder().setKey("response").setValue(gson.toJson(current));
            if (helper.isDebugEnabled()) {
                helper.debug("Current degree plans: " + gson.toJson(current));
            }
            ArrayList<DegreePlanInterface> plans = new ArrayList<DegreePlanInterface>();
            for (XEInterface.DegreePlan p : current) {
                if (this.getDegreeWorksActiveOnly() && (p.isActive == null || !p.isActive.value)) continue;
                DegreePlanInterface plan = new DegreePlanInterface();
                plan.setSessionId(server.getAcademicSession().getUniqueId());
                plan.setStudentId(student.getStudentId());
                plan.setId(p.id);
                plan.setDegree(p.degree == null ? null : p.degree.description);
                plan.setName(p.description);
                plan.setSchool(p.school == null ? null : p.school.description);
                plan.setLastModified(p.modifyDate);
                plan.setModifiedWho(p.modifyWho == null ? null : p.modifyWho.name);
                plan.setTrackingStatus(p.officialTrackingStatus == null ? null : p.officialTrackingStatus.description);
                plan.setActive(p.isActive != null && p.isActive.value);
                plan.setLocked(p.isLocked != null && p.isLocked.value);
                if (p.years != null) {
                    for (XEInterface.Year y : p.years) {
                        if (y.terms == null) continue;
                        for (XEInterface.Term t : y.terms) {
                            if (t.term == null || !term.equals(t.term.code) || t.group == null) continue;
                            plan.setGroup(this.toGroup(server, helper, t.group));
                        }
                    }
                }
                if (plan.getGroup() == null) continue;
                plans.add(plan);
            }
            if (plans.isEmpty()) {
                throw new SectioningException(this.getDegreeWorksNoPlansMessage()).withTypeInfo();
            }
            return plans;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SectioningException(e.getMessage(), e);
        }
    }

    public String getCriticalTerms(String bannerTerm) {
        if ("true".equalsIgnoreCase(ApplicationProperties.getProperty("banner.dgw.criticalIncludeAllTerms", "false"))) {
            return null;
        }
        if ("true".equalsIgnoreCase(ApplicationProperties.getProperty("banner.dgw.criticalIncludePastTerm", "false"))) {
            if ("true".equalsIgnoreCase(ApplicationProperties.getProperty("banner.dgw.criticalIncludeFutureTerm", "true"))) {
                if (bannerTerm.endsWith("10")) {
                    return Integer.parseInt(bannerTerm) - 90 + "," + (Integer.parseInt(bannerTerm) - 80) + "," + bannerTerm + "," + (Integer.parseInt(bannerTerm) + 10) + "," + (Integer.parseInt(bannerTerm) + 20);
                }
                if (bannerTerm.endsWith("20")) {
                    return Integer.parseInt(bannerTerm) - 90 + "," + (Integer.parseInt(bannerTerm) - 10) + "," + bannerTerm + "," + (Integer.parseInt(bannerTerm) + 10) + "," + (Integer.parseInt(bannerTerm) + 90);
                }
                if (bannerTerm.endsWith("30")) {
                    return Integer.parseInt(bannerTerm) - 20 + "," + (Integer.parseInt(bannerTerm) - 10) + "," + bannerTerm + "," + (Integer.parseInt(bannerTerm) + 80) + "," + (Integer.parseInt(bannerTerm) + 90);
                }
            }
            if (bannerTerm.endsWith("10")) {
                return Integer.parseInt(bannerTerm) - 90 + "," + (Integer.parseInt(bannerTerm) - 80) + "," + bannerTerm;
            }
            if (bannerTerm.endsWith("20")) {
                return Integer.parseInt(bannerTerm) - 90 + "," + (Integer.parseInt(bannerTerm) - 10) + "," + bannerTerm;
            }
            if (bannerTerm.endsWith("30")) {
                return Integer.parseInt(bannerTerm) - 20 + "," + (Integer.parseInt(bannerTerm) - 10) + "," + bannerTerm;
            }
        }
        if ("true".equalsIgnoreCase(ApplicationProperties.getProperty("banner.dgw.criticalIncludeFutureTerm", "true"))) {
            if (bannerTerm.endsWith("10")) {
                return bannerTerm + "," + (Integer.parseInt(bannerTerm) + 10) + "," + (Integer.parseInt(bannerTerm) + 20);
            }
            if (bannerTerm.endsWith("20")) {
                return bannerTerm + "," + (Integer.parseInt(bannerTerm) + 10) + "," + (Integer.parseInt(bannerTerm) + 90);
            }
            if (bannerTerm.endsWith("30")) {
                return bannerTerm + "," + (Integer.parseInt(bannerTerm) + 80) + "," + (Integer.parseInt(bannerTerm) + 90);
            }
        }
        return bannerTerm;
    }

    protected String getCriticalPlaceHolderRegExp() {
        return ApplicationProperties.getProperty("banner.dgw.criticalPlaceHolderRegExp", ".* ?\\* ?");
    }

    protected String getUccPlaceHolderType() {
        return ApplicationProperties.getProperty("banner.dgw.uccPlaceHolderCodeRegExp", "UNIV-CORE");
    }

    protected boolean getCriticalPlaceHolderAllowPartialMatch() {
        return "true".equalsIgnoreCase(ApplicationProperties.getProperty("banner.dgw.placeHolderPartialMatch", "true"));
    }

    protected List<XCourse> getPlaceHolderCourses(OnlineSectioningServer server, OnlineSectioningHelper helper, XEInterface.PlaceHolder ph) {
        if (!CustomCourseLookupHolder.hasProvider()) {
            return null;
        }
        if (ph == null || ph.placeholderType == null || ph.placeholderType.code == null || !ph.placeholderType.code.matches(this.getUccPlaceHolderType())) {
            return null;
        }
        return CustomCourseLookupHolder.getProvider().getCourses(server, helper, ph.placeholderValue, this.getCriticalPlaceHolderAllowPartialMatch());
    }

    protected boolean isCriticalPlaceholder(XEInterface.PlaceHolder ph) {
        return ph.placeholderValue != null && ph.placeholderValue.matches(this.getCriticalPlaceHolderRegExp());
    }

    protected List<XCourse> getCriticalPlaceHolderCourses(OnlineSectioningServer server, OnlineSectioningHelper helper, XEInterface.PlaceHolder ph) {
        return this.isCriticalPlaceholder(ph) ? this.getPlaceHolderCourses(server, helper, ph) : null;
    }

    @Override
    public CriticalCoursesProvider.CriticalCourses getCriticalCourses(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudentId student) {
        return this.getCriticalCourses(server, helper, student, helper.getAction());
    }

    @Override
    public CriticalCoursesProvider.CriticalCourses getCriticalCourses(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudentId student, OnlineSectioningLog.Action.Builder action) {
        try {
            List credits;
            String sql;
            String term = this.getBannerTerm(server.getAcademicSession());
            String studentId = this.getBannerId(student);
            String effectiveOnly = this.getDegreeWorksApiEffectiveOnly();
            String criticalTerms = this.getCriticalTerms(term);
            if (effectiveOnly != null) {
                action.addOptionBuilder().setKey("effectiveOnly").setValue(effectiveOnly);
            }
            if (criticalTerms != null) {
                action.addOptionBuilder().setKey("criticalTerms").setValue(criticalTerms);
            }
            List<XEInterface.DegreePlan> current = null;
            long t0 = System.currentTimeMillis();
            try {
                current = this.getDegreePlans(criticalTerms, studentId, effectiveOnly, this.getDegreeWorksNrAttempts());
            }
            catch (SectioningException e) {
                if (!action.hasApiException()) {
                    action.setApiException(e.getMessage());
                }
                throw e;
            }
            finally {
                if (!action.hasApiGetTime()) {
                    action.setApiGetTime(System.currentTimeMillis() - t0);
                }
            }
            if (current == null || current.isEmpty()) {
                return null;
            }
            action.addOptionBuilder().setKey("plans").setValue(this.getGson(helper).toJson(current));
            CriticalCoursesImpl courses = new CriticalCoursesImpl();
            for (XEInterface.DegreePlan p : current) {
                if (this.getDegreeWorksActiveOnly() && (p.isActive == null || !p.isActive.value) || p.years == null) continue;
                for (XEInterface.Year y : p.years) {
                    if (y.terms == null) continue;
                    for (XEInterface.Term t : y.terms) {
                        if (t.group != null && t.group.plannedClasses != null) {
                            for (XEInterface.Course c : t.group.plannedClasses) {
                                if (c.isCritical == null || !c.isCritical.booleanValue()) continue;
                                courses.add(c);
                            }
                        }
                        if (t.group != null && t.group.groups != null) {
                            for (XEInterface.Group g : t.group.groups) {
                                if (g.isCritical == null || !g.isCritical.booleanValue()) continue;
                                if (g.plannedClasses != null) {
                                    for (XEInterface.Course c : g.plannedClasses) {
                                        courses.add(c);
                                    }
                                }
                                if (g.groups == null) continue;
                                for (XEInterface.Group h : g.groups) {
                                    if (h.plannedClasses == null) continue;
                                    for (XEInterface.Course c : h.plannedClasses) {
                                        courses.add(c);
                                    }
                                }
                            }
                        }
                        if (t.group == null || t.group.plannedPlaceholders == null) continue;
                        for (XEInterface.PlaceHolder ph : t.group.plannedPlaceholders) {
                            courses.add(this.getCriticalPlaceHolderCourses(server, helper, ph));
                        }
                    }
                }
            }
            if (!(courses.isEmpty() || (sql = this.getCreditSQL()) == null || sql.isEmpty() || (credits = helper.getHibSession().createSQLQuery(sql).setString("puid", studentId).list()).isEmpty())) {
                action.addOptionBuilder().setKey("credits").setValue(this.getGson(helper).toJson((Object)credits));
                for (Object[] o : credits) {
                    String subjectArea = (String)o[0];
                    String courseNbr = (String)o[1];
                    courses.remove(subjectArea, courseNbr);
                }
            }
            action.addOptionBuilder().setKey("critical").setValue(courses.toString());
            return courses;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SectioningException(e.getMessage(), e);
        }
    }

    protected static class CriticalCoursesImpl
    implements CriticalCoursesProvider.CriticalCourses {
        private Set<String> iCriticalCourses = new TreeSet<String>();
        private Set<XCourseId> iCriticalCourseIds = null;

        protected CriticalCoursesImpl() {
        }

        public boolean add(XEInterface.Course c) {
            return this.iCriticalCourses.add(c.courseDiscipline + " " + c.courseNumber);
        }

        public void add(Collection<XCourse> courses) {
            if (courses == null || courses.isEmpty()) {
                return;
            }
            if (this.iCriticalCourseIds == null) {
                this.iCriticalCourseIds = new HashSet<XCourseId>();
            }
            this.iCriticalCourseIds.addAll(courses);
        }

        public boolean remove(String subjectArea, String courseNbr) {
            boolean removed = this.iCriticalCourses.remove(subjectArea + " " + courseNbr);
            if (this.iCriticalCourseIds != null) {
                Iterator<XCourseId> i = this.iCriticalCourseIds.iterator();
                while (i.hasNext()) {
                    XCourseId c = i.next();
                    if (!c.getCourseName().startsWith(subjectArea + " " + courseNbr)) continue;
                    i.remove();
                    removed = true;
                }
            }
            return removed;
        }

        @Override
        public boolean isEmpty() {
            return this.iCriticalCourses.isEmpty() && (this.iCriticalCourseIds == null || this.iCriticalCourseIds.isEmpty());
        }

        @Override
        public boolean isCritical(CourseOffering course) {
            for (String c : this.iCriticalCourses) {
                if (!course.getCourseName().startsWith(c)) continue;
                return true;
            }
            return this.iCriticalCourseIds != null && this.iCriticalCourseIds.contains(new XCourseId(course));
        }

        @Override
        public boolean isCritical(XCourseId course) {
            for (String c : this.iCriticalCourses) {
                if (!course.getCourseName().startsWith(c)) continue;
                return true;
            }
            return this.iCriticalCourseIds != null && this.iCriticalCourseIds.contains(course);
        }

        public String toString() {
            TreeSet<String> courses = new TreeSet<String>(this.iCriticalCourses);
            if (this.iCriticalCourseIds != null) {
                for (XCourseId c : this.iCriticalCourseIds) {
                    courses.add(c.getCourseName());
                }
            }
            return ((Object)courses).toString();
        }
    }
}

