/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.basic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.model.FixedCreditUnitConfig;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.basic.ListCourseOfferings;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XInstructor;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRoom;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XSubpart;

public class ListCourseOfferingsByExternalId
extends ListCourseOfferings {
    private static final long serialVersionUID = 1L;

    @Override
    protected List<ClassAssignmentInterface.CourseAssignment> listCourses(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        List<ClassAssignmentInterface.CourseAssignment> ret = this.customCourseLookup(server, helper);
        if (ret != null && !ret.isEmpty()) {
            return ret;
        }
        ret = new ArrayList<ClassAssignmentInterface.CourseAssignment>();
        HashMap<Long, ClassAssignmentInterface.CourseAssignment> courses = null;
        if (this.iQuery != null && this.iQuery.length() >= 3) {
            try {
                for (Object[] objectArray : helper.getHibSession().createQuery("select distinct c.uniqueId, z.uniqueId from Class_ z inner join z.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings c where c.subjectArea.session.uniqueId = :sessionId and c.subjectArea.department.allowStudentScheduling = true and ((lower(c.subjectArea.subjectAreaAbbreviation || ' ' || c.courseNbr || ' ' || z.classSuffix) like :q || '%' and :q like lower(c.subjectArea.subjectAreaAbbreviation || ' ' || c.courseNbr || ' %')) or lower(z.classSuffix) like :q || '%') order by c.subjectArea.subjectAreaAbbreviation, c.courseNbr, z.classSuffix").setString("q", this.iQuery).setLong("sessionId", server.getAcademicSession().getUniqueId().longValue()).setCacheable(true).list()) {
                    Long courseId = (Long)objectArray[0];
                    Long sectionId = (Long)objectArray[1];
                    XCourse course = server.getCourse(courseId);
                    if (course != null && (this.iMatcher == null || this.iMatcher.match(course))) {
                        XSection section;
                        XOffering offering = server.getOffering(course.getOfferingId());
                        XSection xSection = section = offering == null ? null : offering.getSection(sectionId);
                        if (section != null) {
                            ClassAssignmentInterface.CourseAssignment ca;
                            if (courses == null) {
                                courses = new HashMap<Long, ClassAssignmentInterface.CourseAssignment>();
                            }
                            if ((ca = (ClassAssignmentInterface.CourseAssignment)courses.get(courseId)) == null) {
                                ca = this.convert(course, server);
                                courses.put(courseId, ca);
                                ret.add(ca);
                            }
                            ClassAssignmentInterface.ClassAssignment a = ca.addClassAssignment();
                            a.setClassId(section.getSectionId());
                            XSubpart subpart = offering.getSubpart(section.getSubpartId());
                            a.setSubpart(subpart.getName());
                            a.setSection(section.getName(courseId));
                            a.setExternalId(section.getExternalId(courseId));
                            a.setClassNumber(section.getName(-1L));
                            a.setCancelled(section.isCancelled());
                            a.addNote(course.getNote());
                            a.addNote(section.getNote());
                            a.setCredit(subpart.getCredit(courseId));
                            Float creditOverride = section.getCreditOverride(courseId);
                            if (creditOverride != null) {
                                a.setCredit(FixedCreditUnitConfig.formatCredit(creditOverride.floatValue()));
                            }
                            if (section.getTime() != null) {
                                for (DayCode d : DayCode.toDayCodes(section.getTime().getDays())) {
                                    a.addDay(d.getIndex());
                                }
                                a.setStart(section.getTime().getSlot());
                                a.setLength(section.getTime().getLength());
                                a.setBreakTime(section.getTime().getBreakTime());
                                a.setDatePattern(section.getTime().getDatePatternName());
                            }
                            if (section.getRooms() != null) {
                                for (XRoom rm : section.getRooms()) {
                                    a.addRoom(rm.getUniqueId(), rm.getName());
                                }
                            }
                            for (XInstructor instructor : section.getInstructors()) {
                                a.addInstructor(instructor.getName());
                                a.addInstructoEmail(instructor.getEmail() == null ? "" : instructor.getEmail());
                            }
                            if (section.getParentId() != null) {
                                a.setParentSection(offering.getSection(section.getParentId()).getName(courseId));
                            }
                            a.setSubpartId(subpart.getSubpartId());
                            if (a.getParentSection() == null) {
                                a.setParentSection(course.getConsentLabel());
                            }
                        }
                    }
                    if (this.iLimit == null || this.iLimit <= 0 || ret.size() != this.iLimit.intValue()) continue;
                    break;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        for (XCourseId xCourseId : server.findCourses(this.iQuery, this.iLimit, this.iMatcher)) {
            if (courses != null && courses.containsKey(xCourseId.getCourseId())) continue;
            XCourse course = server.getCourse(xCourseId.getCourseId());
            if (course != null) {
                ret.add(this.convert(course, server));
            }
            if (this.iLimit == null || this.iLimit <= 0 || ret.size() != this.iLimit.intValue()) continue;
            break;
        }
        return ret;
    }
}

