/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.basic;

import java.util.List;
import org.unitime.timetable.gwt.shared.DegreePlanInterface;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.CustomDegreePlansHolder;
import org.unitime.timetable.onlinesectioning.custom.DegreePlansProvider;
import org.unitime.timetable.onlinesectioning.model.XStudent;

public class GetDegreePlans
implements OnlineSectioningAction<List<DegreePlanInterface>> {
    private static final long serialVersionUID = 1L;
    protected Long iStudentId;

    public GetDegreePlans forStudent(Long studentId) {
        this.iStudentId = studentId;
        return this;
    }

    @Override
    public List<DegreePlanInterface> execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        XStudent student;
        DegreePlansProvider provider = CustomDegreePlansHolder.getProvider();
        if (provider == null) {
            return null;
        }
        OnlineSectioningLog.Action.Builder action = helper.getAction();
        if (this.iStudentId != null) {
            action.setStudent(OnlineSectioningLog.Entity.newBuilder().setUniqueId(this.iStudentId));
        }
        XStudent xStudent = student = this.iStudentId == null ? null : server.getStudent(this.iStudentId);
        if (student == null) {
            return provider.getDegreePlans(server, helper, new XStudent(null, helper.getStudentExternalId(), helper.getUser().getName()));
        }
        action.getStudentBuilder().setExternalId(student.getExternalId());
        action.getStudentBuilder().setName(student.getName());
        return provider.getDegreePlans(server, helper, student);
    }

    @Override
    public String name() {
        return "degree-plans";
    }
}

