/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.Session;
import org.unitime.timetable.model.base.BaseTeachingResponsibility;
import org.unitime.timetable.model.dao.TeachingResponsibilityDAO;

public class TeachingResponsibility
extends BaseTeachingResponsibility {
    private static final long serialVersionUID = 1L;

    public static List<TeachingResponsibility> getInstructorTeachingResponsibilities() {
        return TeachingResponsibilityDAO.getInstance().getSession().createQuery("from TeachingResponsibility where instructor = true order by label").setCacheable(true).list();
    }

    public static TeachingResponsibility getDefaultInstructorTeachingResponsibility() {
        for (TeachingResponsibility r : TeachingResponsibility.getInstructorTeachingResponsibilities()) {
            if (!r.hasOption(Option.isdefault)) continue;
            return r;
        }
        return null;
    }

    public static List<TeachingResponsibility> getCoordinatorTeachingResponsibilities() {
        return TeachingResponsibilityDAO.getInstance().getSession().createQuery("from TeachingResponsibility where coordinator = true order by label").setCacheable(true).list();
    }

    public static TeachingResponsibility getDefaultCoordinatorTeachingResponsibility() {
        for (TeachingResponsibility r : TeachingResponsibility.getCoordinatorTeachingResponsibilities()) {
            if (!r.hasOption(Option.isdefault)) continue;
            return r;
        }
        return null;
    }

    public static TeachingResponsibility getTeachingResponsibility(String reference, Session hibSession) {
        if (reference == null || reference.isEmpty()) {
            return null;
        }
        return (TeachingResponsibility)hibSession.createQuery("from TeachingResponsibility where reference = :reference").setString("reference", reference).setMaxResults(1).setCacheable(true).uniqueResult();
    }

    public boolean hasOption(Option option) {
        return this.getOptions() != null && (this.getOptions() & option.toggle()) != 0;
    }

    public void addOption(Option option) {
        if (!this.hasOption(option)) {
            this.setOptions((this.getOptions() == null ? 0 : this.getOptions()) + option.toggle());
        }
    }

    public void removeOption(Option option) {
        if (this.hasOption(option)) {
            this.setOptions(this.getOptions() - option.toggle());
        }
    }

    public static boolean hasOption(Option option, String reference, Session hibSession) {
        TeachingResponsibility responsibility = TeachingResponsibility.getTeachingResponsibility(reference, hibSession);
        return responsibility != null && responsibility.hasOption(option);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getMatchingResponsibilities(Option option) {
        try (Session hibSession = TeachingResponsibilityDAO.getInstance().createNewSession();){
            HashSet<String> responsibilities = new HashSet<String>();
            for (TeachingResponsibility responsibility : TeachingResponsibilityDAO.getInstance().findAll(hibSession)) {
                if (!responsibility.hasOption(option)) continue;
                responsibilities.add(responsibility.getReference());
            }
            HashSet<String> hashSet = responsibilities;
            return hashSet;
        }
    }

    public boolean isUsed() {
        if (((Number)TeachingResponsibilityDAO.getInstance().getSession().createQuery("select count(ci) from ClassInstructor ci where ci.responsibility.uniqueId = :responsibilityId").setLong("responsibilityId", this.getUniqueId().longValue()).uniqueResult()).intValue() > 0) {
            return true;
        }
        return ((Number)TeachingResponsibilityDAO.getInstance().getSession().createQuery("select count(oc) from OfferingCoordinator oc where oc.responsibility.uniqueId = :responsibilityId").setLong("responsibilityId", this.getUniqueId().longValue()).uniqueResult()).intValue() > 0;
    }

    public static enum Option {
        auxiliary("Do not report"),
        noexport("Do not export"),
        noevents("Do not show in events"),
        isdefault("Default responsibility");

        private String iName;

        private Option(String name) {
            this.iName = name;
        }

        public String getName() {
            return this.iName;
        }

        public int toggle() {
            return 1 << this.ordinal();
        }
    }
}

