/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.AcademicClassification;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.PosMajor;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentAreaClassificationMajor;
import org.unitime.timetable.model.base.BaseCurriculumReservation;

public class CurriculumReservation
extends BaseCurriculumReservation {
    private static final long serialVersionUID = -261396109078027984L;

    @Override
    public boolean isApplicable(Student student, CourseRequest request) {
        for (StudentAreaClassificationMajor acm : student.getAreaClasfMajors()) {
            if (!acm.getAcademicArea().equals(this.getArea()) || !this.getClassifications().isEmpty() && !this.getClassifications().contains(acm.getAcademicClassification()) || !this.getMajors().isEmpty() && !this.getMajors().contains(acm.getMajor())) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getPriority() {
        return ApplicationProperty.ReservationPriorityCurriculum.intValue();
    }

    @Override
    public boolean isCanAssignOverLimit() {
        return ApplicationProperty.ReservationCanOverLimitCurriculum.isTrue();
    }

    @Override
    public boolean isMustBeUsed() {
        return ApplicationProperty.ReservationMustBeUsedCurriculum.isTrue();
    }

    @Override
    public boolean isAllowOverlap() {
        return ApplicationProperty.ReservationAllowOverlapCurriculum.isTrue();
    }

    public boolean hasArea(String areaAbbv) {
        return this.getArea() != null && this.getArea().getAcademicAreaAbbreviation().equals(areaAbbv);
    }

    public boolean hasClassification(String classificationCode) {
        if (this.getClassifications().isEmpty()) {
            return true;
        }
        for (AcademicClassification c : this.getClassifications()) {
            if (!c.getCode().equals(classificationCode)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMajor(String majorCode) {
        if (this.getMajors().isEmpty()) {
            return true;
        }
        for (PosMajor c : this.getMajors()) {
            if (!c.getCode().equals(majorCode)) continue;
            return true;
        }
        return false;
    }
}

