/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.shared;

import com.google.gwt.regexp.shared.MatchResult;
import com.google.gwt.regexp.shared.RegExp;
import com.google.gwt.user.client.rpc.IsSerializable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.gwt.shared.SpecialRegistrationInterface;
import org.unitime.timetable.gwt.shared.TableInterface;

public class ClassAssignmentInterface
implements IsSerializable,
Serializable {
    private static final long serialVersionUID = 1L;
    private ArrayList<CourseAssignment> iAssignments = new ArrayList();
    private ArrayList<String> iMessages = null;
    private ArrayList<ErrorMessage> iErrors = null;
    private boolean iCanEnroll = true;
    private boolean iCanSetCriticalOverrides = false;
    private double iValue = 0.0;
    private CourseRequestInterface iRequest = null;

    public ArrayList<CourseAssignment> getCourseAssignments() {
        return this.iAssignments;
    }

    public void add(CourseAssignment a) {
        this.iAssignments.add(a);
    }

    public List<ClassAssignment> getClassAssignments() {
        ArrayList<ClassAssignment> ret = new ArrayList<ClassAssignment>();
        for (CourseAssignment a : this.iAssignments) {
            ret.addAll(a.getClassAssignments());
        }
        return ret;
    }

    public void clear() {
        this.iAssignments.clear();
        if (this.iMessages != null) {
            this.iMessages.clear();
        }
        if (this.iErrors != null) {
            this.iMessages.clear();
        }
    }

    public void addMessage(String message) {
        if (this.iMessages == null) {
            this.iMessages = new ArrayList();
        }
        this.iMessages.add(message);
    }

    public boolean hasMessages() {
        return this.iMessages != null && !this.iMessages.isEmpty();
    }

    public ArrayList<String> getMessages() {
        return this.iMessages;
    }

    public String getMessages(String delim) {
        String ret = "";
        if (this.iMessages == null) {
            return ret;
        }
        for (String message : this.iMessages) {
            if (!ret.isEmpty()) {
                ret = ret + delim;
            }
            ret = ret + message;
        }
        return ret;
    }

    public void addError(ErrorMessage error) {
        if (this.iErrors == null) {
            this.iErrors = new ArrayList();
        }
        this.iErrors.add(error);
    }

    public void setErrors(Collection<ErrorMessage> errors) {
        if (this.iErrors == null) {
            this.iErrors = new ArrayList();
        } else {
            this.iErrors.clear();
        }
        this.iErrors.addAll(errors);
    }

    public boolean hasErrors() {
        return this.iErrors != null && !this.iErrors.isEmpty();
    }

    public ArrayList<ErrorMessage> getErrors() {
        return this.iErrors;
    }

    public boolean isCanEnroll() {
        return this.iCanEnroll;
    }

    public void setCanEnroll(boolean canEnroll) {
        this.iCanEnroll = canEnroll;
    }

    public boolean isCanSetCriticalOverrides() {
        return this.iCanSetCriticalOverrides;
    }

    public void setCanSetCriticalOverrides(boolean canSetCriticalOverrides) {
        this.iCanSetCriticalOverrides = canSetCriticalOverrides;
    }

    public double getValue() {
        return this.iValue;
    }

    public void setValue(double value) {
        this.iValue = value;
    }

    public boolean hasRequest() {
        return this.iRequest != null;
    }

    public void setRequest(CourseRequestInterface request) {
        this.iRequest = request;
    }

    public CourseRequestInterface getRequest() {
        return this.iRequest;
    }

    public boolean isEnrolled() {
        for (CourseAssignment course : this.getCourseAssignments()) {
            if (!course.isAssigned() || course.isFreeTime() || course.isTeachingAssignment()) continue;
            return true;
        }
        return false;
    }

    public static class ErrorMessage
    implements IsSerializable,
    Serializable,
    Comparable<ErrorMessage> {
        private static final long serialVersionUID = 1L;
        private String iCourse;
        private String iSection;
        private String iCode;
        private String iMessage;

        public ErrorMessage() {
        }

        public ErrorMessage(String course, String section, String code, String message) {
            this.iCourse = course;
            this.iSection = section;
            this.iCode = code;
            this.iMessage = message;
        }

        public ErrorMessage(String course, String section, UniTimeCode code, String message) {
            this.iCourse = course;
            this.iSection = section;
            this.iCode = code.code();
            this.iMessage = message;
        }

        public void setCourse(String course) {
            this.iCourse = course;
        }

        public String getCourse() {
            return this.iCourse;
        }

        public void setSection(String section) {
            this.iSection = section;
        }

        public String getSection() {
            return this.iSection;
        }

        public void setCode(String code) {
            this.iCode = code;
        }

        public String getCode() {
            return this.iCode;
        }

        public void setMessage(String message) {
            this.iMessage = message;
        }

        public String getMessage() {
            return this.iMessage;
        }

        @Override
        public int compareTo(ErrorMessage other) {
            return TableInterface.NaturalOrderComparator.compare(this.toString(), other.toString());
        }

        public String toString() {
            return this.getCourse() + (this.getSection() == null ? "" : " " + this.getSection()) + ": " + this.getMessage();
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof ErrorMessage)) {
                return false;
            }
            return this.toString().equals(o.toString());
        }

        public static enum UniTimeCode {
            UT_LOCKED,
            UT_DISABLED,
            UT_STRUCTURE("LINK"),
            UT_TIME_CNF("TIME"),
            UT_NOT_AVAILABLE("CLOS"),
            UT_CANCEL,
            UT_DEADLINE,
            UT_GRADE_MODE;

            private String iCode;

            private UniTimeCode() {
            }

            private UniTimeCode(String code) {
                this.iCode = code;
            }

            String code() {
                return this.iCode == null ? this.name() : this.iCode;
            }
        }
    }

    public static class IdValue
    implements IsSerializable,
    Serializable,
    Comparable<IdValue> {
        private static final long serialVersionUID = 1L;
        private Long iId;
        private String iValue;

        public IdValue() {
        }

        public IdValue(Long id, String value) {
            this.iId = id;
            this.iValue = value;
        }

        public Long getId() {
            return this.iId;
        }

        public String getValue() {
            return this.iValue;
        }

        @Override
        public int compareTo(IdValue other) {
            return this.getValue().compareTo(other.getValue());
        }

        public String toString() {
            return this.getValue();
        }

        public int hashCode() {
            return this.getId().hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof IdValue)) {
                return false;
            }
            return this.getId().equals(((IdValue)o).getId());
        }
    }

    public static class SectioningAction
    implements IsSerializable,
    Serializable,
    Comparable<SectioningAction> {
        private static final long serialVersionUID = 1L;
        private Student iStudent;
        private Date iTimeStamp;
        private String iOperation;
        private String iUser;
        private String iMessage;
        private String iProto;
        private String iResult;
        private Long iCpuTime;
        private Long iWallTime;

        public Student getStudent() {
            return this.iStudent;
        }

        public void setStudent(Student student) {
            this.iStudent = student;
        }

        public Date getTimeStamp() {
            return this.iTimeStamp;
        }

        public void setTimeStamp(Date timeStamp) {
            this.iTimeStamp = timeStamp;
        }

        public String getOperation() {
            return this.iOperation;
        }

        public void setOperation(String operation) {
            this.iOperation = operation;
        }

        public String getUser() {
            return this.iUser;
        }

        public void setUser(String user) {
            this.iUser = user;
        }

        public String getMessage() {
            return this.iMessage;
        }

        public void setMessage(String message) {
            this.iMessage = message;
        }

        public String getResult() {
            return this.iResult;
        }

        public void setResult(String result) {
            this.iResult = result;
        }

        public Long getCpuTime() {
            return this.iCpuTime;
        }

        public void setCpuTime(Long cpuTime) {
            this.iCpuTime = cpuTime;
        }

        public Long getWallTime() {
            return this.iWallTime;
        }

        public void setWallTime(Long wallTime) {
            this.iWallTime = wallTime;
        }

        public String getProto() {
            return this.iProto;
        }

        public void setProto(String proto) {
            this.iProto = proto;
        }

        @Override
        public int compareTo(SectioningAction a) {
            return a.getTimeStamp().compareTo(this.getTimeStamp());
        }
    }

    public static class StudentInfo
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Student iStudent;
        private Integer iEnrollment;
        private Integer iWaitlist;
        private Integer iReservation;
        private Integer iRequested;
        private Integer iUnassigned;
        private Integer iTotalEnrollment;
        private Integer iTotalWaitlist;
        private Integer iTotalReservation;
        private Integer iTotalUnassigned;
        private Integer iConsentNeeded;
        private Integer iTotalConsentNeeded;
        private Integer iTopWaitingPriority;
        private Date iRequestedDate = null;
        private Date iEnrolledDate = null;
        private Date iApprovedDate = null;
        private Date iEmailDate = null;
        private String iStatus;
        private String iNote;
        private Float iCredit;
        private Float iTotalCredit;
        private Map<String, Float> iIMCredit;
        private Map<String, Float> iIMTotalCredit;
        private Integer iNrDistanceConflicts;
        private Integer iLongestDistanceMinutes;
        private Integer iOverlappingMinutes;
        private Integer iTotalNrDistanceConflicts;
        private Integer iTotalLongestDistanceMinutes;
        private Integer iTotalOverlappingMinutes;
        private Integer iFreeTimeOverlappingMins;
        private Integer iTotalFreeTimeOverlappingMins;
        private Integer iPrefInstrMethConflict;
        private Integer iTotalPrefInstrMethConflict;
        private Integer iPrefSectionConflict;
        private Integer iTotalPrefSectionConflict;
        private float[] iRequestCredit = null;
        private float[] iRequestTotalCredit = null;
        private Integer iOverrideNeeded;
        private Integer iTotalOverrideNeeded;
        private Boolean iMyStudent;

        public Student getStudent() {
            return this.iStudent;
        }

        public void setStudent(Student student) {
            this.iStudent = student;
        }

        public Integer getRequested() {
            return this.iRequested;
        }

        public void setRequested(Integer requested) {
            this.iRequested = requested;
        }

        public boolean hasRequested() {
            return this.iRequested != null;
        }

        public Integer getEnrollment() {
            return this.iEnrollment;
        }

        public void setEnrollment(Integer enrollment) {
            this.iEnrollment = enrollment;
        }

        public boolean hasEnrollment() {
            return this.iEnrollment != null;
        }

        public Integer getWaitlist() {
            return this.iWaitlist;
        }

        public void setWaitlist(Integer waitlist) {
            this.iWaitlist = waitlist;
        }

        public boolean hasWaitlist() {
            return this.iWaitlist != null;
        }

        public Integer getUnassigned() {
            return this.iUnassigned;
        }

        public void setUnassigned(Integer unassigned) {
            this.iUnassigned = unassigned;
        }

        public boolean hasUnassigned() {
            return this.iUnassigned != null;
        }

        public Integer getReservation() {
            return this.iReservation;
        }

        public void setReservation(Integer reservation) {
            this.iReservation = reservation;
        }

        public boolean hasReservation() {
            return this.iReservation != null;
        }

        public Integer getTotalEnrollment() {
            return this.iTotalEnrollment;
        }

        public void setTotalEnrollment(Integer enrollment) {
            this.iTotalEnrollment = enrollment;
        }

        public boolean hasTotalEnrollment() {
            return this.iTotalEnrollment != null;
        }

        public Integer getTotalWaitlist() {
            return this.iTotalWaitlist;
        }

        public void setTotalWaitlist(Integer waitlist) {
            this.iTotalWaitlist = waitlist;
        }

        public boolean hasTotalWaitlist() {
            return this.iTotalWaitlist != null;
        }

        public Integer getTotalUnassigned() {
            return this.iTotalUnassigned;
        }

        public void setTotalUnassigned(Integer unassigned) {
            this.iTotalUnassigned = unassigned;
        }

        public boolean hasTotalUnassigned() {
            return this.iTotalUnassigned != null;
        }

        public Integer getTotalReservation() {
            return this.iTotalReservation;
        }

        public void setTotalReservation(Integer reservation) {
            this.iTotalReservation = reservation;
        }

        public boolean hasTotalReservation() {
            return this.iTotalReservation != null;
        }

        public Integer getConsentNeeded() {
            return this.iConsentNeeded;
        }

        public void setConsentNeeded(Integer consentNeeded) {
            this.iConsentNeeded = consentNeeded;
        }

        public int hasConsentNeeded() {
            return this.iConsentNeeded;
        }

        public Integer getTotalConsentNeeded() {
            return this.iTotalConsentNeeded;
        }

        public void setTotalConsentNeeded(Integer totalConsentNeeded) {
            this.iTotalConsentNeeded = totalConsentNeeded;
        }

        public int hasTotalConsentNeeded() {
            return this.iTotalConsentNeeded;
        }

        public Integer getOverrideNeeded() {
            return this.iOverrideNeeded;
        }

        public void setOverrideNeeded(Integer overrideNeeded) {
            this.iOverrideNeeded = overrideNeeded;
        }

        public int hasOverrideNeeded() {
            return this.iOverrideNeeded;
        }

        public Integer getTotalOverrideNeeded() {
            return this.iTotalOverrideNeeded;
        }

        public void setTotalOverrideNeeded(Integer totalOverrideNeeded) {
            this.iTotalOverrideNeeded = totalOverrideNeeded;
        }

        public int hasTotalOverrideNeeded() {
            return this.iTotalOverrideNeeded;
        }

        public Integer getTopWaitingPriority() {
            return this.iTopWaitingPriority;
        }

        public void setTopWaitingPriority(Integer topWaitingPriority) {
            this.iTopWaitingPriority = topWaitingPriority;
        }

        public int hasTopWaitingPriority() {
            return this.iTopWaitingPriority;
        }

        public Date getRequestedDate() {
            return this.iRequestedDate;
        }

        public void setRequestedDate(Date ts) {
            this.iRequestedDate = ts;
        }

        public Date getEnrolledDate() {
            return this.iEnrolledDate;
        }

        public void setEnrolledDate(Date ts) {
            this.iEnrolledDate = ts;
        }

        public Date getApprovedDate() {
            return this.iApprovedDate;
        }

        public void setApprovedDate(Date ts) {
            this.iApprovedDate = ts;
        }

        public Date getEmailDate() {
            return this.iEmailDate;
        }

        public void setEmailDate(Date ts) {
            this.iEmailDate = ts;
        }

        public String getStatus() {
            return this.iStatus;
        }

        public void setStatus(String status) {
            this.iStatus = status;
        }

        public void setStatus(OnlineSectioningInterface.StudentStatusInfo status) {
            if (status == null) {
                this.iStatus = "";
                this.iStudent.setCanRegister(true);
                this.iStudent.setCanUseAssistant(true);
            } else {
                this.iStatus = status.getReference();
                this.iStudent.setCanRegister(status.isCanRegister());
                this.iStudent.setCanUseAssistant(status.isCanUseAssistant());
            }
        }

        public String getNote() {
            return this.iNote;
        }

        public boolean hasNote() {
            return this.iNote != null && !this.iNote.isEmpty();
        }

        public void setNote(String note) {
            this.iNote = note;
        }

        public boolean hasCredit() {
            return this.iCredit != null && this.iCredit.floatValue() > 0.0f;
        }

        public void setCredit(Float credit) {
            this.iCredit = credit;
        }

        public Float getCredit() {
            return this.iCredit;
        }

        public boolean hasTotalCredit() {
            return this.iTotalCredit != null && this.iTotalCredit.floatValue() > 0.0f;
        }

        public void setTotalCredit(Float totalCredit) {
            this.iTotalCredit = totalCredit;
        }

        public Float getTotalCredit() {
            return this.iTotalCredit;
        }

        public boolean hasIMCredit() {
            return this.iIMCredit != null && !this.iIMCredit.isEmpty();
        }

        public Map<String, Float> getIMCredit() {
            return this.iIMCredit;
        }

        public void setIMCredit(String im, Float credit) {
            if (this.iIMCredit == null) {
                this.iIMCredit = new HashMap<String, Float>();
            }
            if (credit == null || credit.floatValue() == 0.0f) {
                this.iIMCredit.remove(im);
            } else {
                this.iIMCredit.put(im, credit);
            }
        }

        public void addIMCredit(String im, float credit) {
            Float prev;
            if (credit <= 0.0f) {
                return;
            }
            if (this.iIMCredit == null) {
                this.iIMCredit = new HashMap<String, Float>();
            }
            this.iIMCredit.put(im, Float.valueOf(credit + ((prev = this.iIMCredit.get(im)) == null ? 0.0f : prev.floatValue())));
        }

        public float getIMCredit(String im) {
            if (this.iIMCredit == null) {
                return 0.0f;
            }
            Float cred = this.iIMCredit.get(im);
            return cred == null ? 0.0f : cred.floatValue();
        }

        public Set<String> getCreditIMs() {
            return this.iIMCredit == null ? new TreeSet<String>() : new TreeSet<String>(this.iIMCredit.keySet());
        }

        public boolean hasIMTotalCredit() {
            return this.iIMTotalCredit != null && !this.iIMTotalCredit.isEmpty();
        }

        public Map<String, Float> getIMTotalCredit() {
            return this.iIMTotalCredit;
        }

        public void setIMTotalCredit(String im, Float credit) {
            if (this.iIMTotalCredit == null) {
                this.iIMTotalCredit = new HashMap<String, Float>();
            }
            if (credit == null || credit.floatValue() == 0.0f) {
                this.iIMTotalCredit.remove(im);
            } else {
                this.iIMTotalCredit.put(im, credit);
            }
        }

        public void addIMTotalCredit(String im, float credit) {
            Float prev;
            if (credit <= 0.0f) {
                return;
            }
            if (this.iIMTotalCredit == null) {
                this.iIMTotalCredit = new HashMap<String, Float>();
            }
            this.iIMTotalCredit.put(im, Float.valueOf(credit + ((prev = this.iIMTotalCredit.get(im)) == null ? 0.0f : prev.floatValue())));
        }

        public float getIMTotalCredit(String im) {
            if (this.iIMTotalCredit == null) {
                return 0.0f;
            }
            Float cred = this.iIMTotalCredit.get(im);
            return cred == null ? 0.0f : cred.floatValue();
        }

        public Set<String> getTotalCreditIMs() {
            return this.iIMTotalCredit == null ? new TreeSet<String>() : new TreeSet<String>(this.iIMTotalCredit.keySet());
        }

        public boolean hasRequestCredit() {
            return this.iRequestCredit != null && this.iRequestCredit[1] > 0.0f;
        }

        public void setRequestCredit(float min, float max) {
            this.iRequestCredit = new float[]{min, max};
        }

        public float getRequestCreditMin() {
            return this.iRequestCredit == null ? 0.0f : this.iRequestCredit[0];
        }

        public float getRequestCreditMax() {
            return this.iRequestCredit == null ? 0.0f : this.iRequestCredit[1];
        }

        public boolean hasTotalRequestCredit() {
            return this.iRequestTotalCredit != null && this.iRequestTotalCredit[1] > 0.0f;
        }

        public void setTotalRequestCredit(float min, float max) {
            this.iRequestTotalCredit = new float[]{min, max};
        }

        public float getTotalRequestCreditMin() {
            return this.iRequestTotalCredit == null ? 0.0f : this.iRequestTotalCredit[0];
        }

        public float getTotalRequestCreditMax() {
            return this.iRequestTotalCredit == null ? 0.0f : this.iRequestTotalCredit[1];
        }

        public boolean hasDistanceConflicts() {
            return this.iNrDistanceConflicts != null && this.iNrDistanceConflicts > 0;
        }

        public void setNrDistanceConflicts(Integer nrDistanceConflicts) {
            this.iNrDistanceConflicts = nrDistanceConflicts;
        }

        public Integer getNrDistanceConflicts() {
            return this.iNrDistanceConflicts;
        }

        public void setLongestDistanceMinutes(Integer longestDistance) {
            this.iLongestDistanceMinutes = longestDistance;
        }

        public Integer getLongestDistanceMinutes() {
            return this.iLongestDistanceMinutes;
        }

        public boolean hasOverlappingMinutes() {
            return this.iOverlappingMinutes != null && this.iOverlappingMinutes > 0;
        }

        public void setOverlappingMinutes(Integer overlapMins) {
            this.iOverlappingMinutes = overlapMins;
        }

        public Integer getOverlappingMinutes() {
            return this.iOverlappingMinutes;
        }

        public boolean hasTotalDistanceConflicts() {
            return this.iTotalNrDistanceConflicts != null && this.iTotalNrDistanceConflicts > 0;
        }

        public void setTotalNrDistanceConflicts(Integer nrDistanceConflicts) {
            this.iTotalNrDistanceConflicts = nrDistanceConflicts;
        }

        public Integer getTotalNrDistanceConflicts() {
            return this.iTotalNrDistanceConflicts;
        }

        public void setTotalLongestDistanceMinutes(Integer longestDistance) {
            this.iTotalLongestDistanceMinutes = longestDistance;
        }

        public Integer getTotalLongestDistanceMinutes() {
            return this.iTotalLongestDistanceMinutes;
        }

        public boolean hasTotalOverlappingMinutes() {
            return this.iTotalOverlappingMinutes != null && this.iTotalOverlappingMinutes > 0;
        }

        public void setTotalOverlappingMinutes(Integer overlapMins) {
            this.iTotalOverlappingMinutes = overlapMins;
        }

        public Integer getTotalOverlappingMinutes() {
            return this.iTotalOverlappingMinutes;
        }

        public boolean hasFreeTimeOverlappingMins() {
            return this.iFreeTimeOverlappingMins != null && this.iFreeTimeOverlappingMins > 0;
        }

        public void setFreeTimeOverlappingMins(Integer overlapMins) {
            this.iFreeTimeOverlappingMins = overlapMins;
        }

        public Integer getFreeTimeOverlappingMins() {
            return this.iFreeTimeOverlappingMins;
        }

        public boolean hasTotalFreeTimeOverlappingMins() {
            return this.iTotalFreeTimeOverlappingMins != null && this.iTotalFreeTimeOverlappingMins > 0;
        }

        public void setTotalFreeTimeOverlappingMins(Integer overlapMins) {
            this.iTotalFreeTimeOverlappingMins = overlapMins;
        }

        public Integer getTotalFreeTimeOverlappingMins() {
            return this.iTotalFreeTimeOverlappingMins;
        }

        public boolean hasPrefInstrMethConflict() {
            return this.iPrefInstrMethConflict != null && this.iPrefInstrMethConflict > 0;
        }

        public void setPrefInstrMethConflict(Integer conf) {
            this.iPrefInstrMethConflict = conf;
        }

        public Integer getPrefInstrMethConflict() {
            return this.iPrefInstrMethConflict;
        }

        public boolean hasTotalPrefInstrMethConflict() {
            return this.iTotalPrefInstrMethConflict != null && this.iTotalPrefInstrMethConflict > 0;
        }

        public void setTotalPrefInstrMethConflict(Integer conf) {
            this.iTotalPrefInstrMethConflict = conf;
        }

        public Integer getTotalPrefInstrMethConflict() {
            return this.iTotalPrefInstrMethConflict;
        }

        public boolean hasPrefSectionConflict() {
            return this.iPrefSectionConflict != null && this.iPrefSectionConflict > 0;
        }

        public void setPrefSectionConflict(Integer conf) {
            this.iPrefSectionConflict = conf;
        }

        public Integer getPrefSectionConflict() {
            return this.iPrefSectionConflict;
        }

        public boolean hasTotalPrefSectionConflict() {
            return this.iTotalPrefSectionConflict != null && this.iTotalPrefSectionConflict > 0;
        }

        public void setTotalPrefSectionConflict(Integer conf) {
            this.iTotalPrefSectionConflict = conf;
        }

        public Integer getTotalPrefSectionConflict() {
            return this.iTotalPrefSectionConflict;
        }

        public boolean isMyStudent() {
            return this.iMyStudent != null && this.iMyStudent != false;
        }

        public Boolean getMyStudent() {
            return this.iMyStudent;
        }

        public void setMyStudent(Boolean myStudent) {
            this.iMyStudent = myStudent;
        }
    }

    public static class EnrollmentInfo
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private String iArea;
        private String iMajor;
        private String iClassification;
        private String iSubject;
        private String iCourseNbr;
        private String iConfig;
        private String iSubpart;
        private String iClazz;
        private String iTitle;
        private String iConsent;
        private Long iCourseId;
        private Long iOfferingId;
        private Long iSubjectId;
        private Long iConfigId;
        private Long iSubpartId;
        private Long iClazzId;
        private Integer iLimit;
        private Integer iOther;
        private Integer iProjection;
        private Integer iEnrollment;
        private Integer iWaitlist;
        private Integer iReservation;
        private Integer iAvailable;
        private Integer iUnassigned;
        private Integer iUnassignedPrimary;
        private Integer iTotalEnrollment;
        private Integer iTotalWaitlist;
        private Integer iTotalReservation;
        private Integer iTotalUnassigned;
        private Integer iTotalUnassignedPrimary;
        private Integer iConsentNeeded;
        private Integer iTotalConsentNeeded;
        private Integer iOverrideNeeded;
        private Integer iTotalOverrideNeeded;
        private ClassAssignment iAssignment;
        private int iLevel = 0;

        public String getArea() {
            return this.iArea;
        }

        public void setArea(String area) {
            this.iArea = area;
        }

        public String getMajor() {
            return this.iMajor;
        }

        public void setMajor(String major) {
            this.iMajor = major;
        }

        public String getClassification() {
            return this.iClassification;
        }

        public void setClassification(String classification) {
            this.iClassification = classification;
        }

        public String getSubject() {
            return this.iSubject;
        }

        public void setSubject(String subject) {
            this.iSubject = subject;
        }

        public String getCourseNbr() {
            return this.iCourseNbr;
        }

        public void setCourseNbr(String courseNbr) {
            this.iCourseNbr = courseNbr;
        }

        public String getTitle() {
            return this.iTitle;
        }

        public void setTitle(String title) {
            this.iTitle = title;
        }

        public String getConsent() {
            return this.iConsent;
        }

        public void setConsent(String consent) {
            this.iConsent = consent;
        }

        public Long getCourseId() {
            return this.iCourseId;
        }

        public void setCourseId(Long courseId) {
            this.iCourseId = courseId;
        }

        public Long getOfferingId() {
            return this.iOfferingId;
        }

        public void setOfferingId(Long offeringId) {
            this.iOfferingId = offeringId;
        }

        public Long getSubjectId() {
            return this.iSubjectId;
        }

        public void setSubjectId(Long subjectId) {
            this.iSubjectId = subjectId;
        }

        public String getConfig() {
            return this.iConfig;
        }

        public void setConfig(String config) {
            this.iConfig = config;
        }

        public Long getConfigId() {
            return this.iConfigId;
        }

        public void setConfigId(Long configId) {
            this.iConfigId = configId;
        }

        public String getSubpart() {
            return this.iSubpart;
        }

        public void setSubpart(String subpart) {
            this.iSubpart = subpart;
        }

        public Long getSubpartId() {
            return this.iSubpartId;
        }

        public void setSubpartId(Long subpartId) {
            this.iSubpartId = subpartId;
        }

        public String getClazz() {
            return this.iClazz;
        }

        public void setClazz(String clazz) {
            this.iClazz = clazz;
        }

        public Long getClazzId() {
            return this.iClazzId;
        }

        public void setClazzId(Long clazzId) {
            this.iClazzId = clazzId;
        }

        public Integer getLimit() {
            return this.iLimit;
        }

        public void setLimit(Integer limit) {
            this.iLimit = limit;
        }

        public boolean hasLimit() {
            return this.iLimit != null;
        }

        public Integer getOther() {
            return this.iOther;
        }

        public void setOther(Integer other) {
            this.iOther = other;
        }

        public boolean hasOther() {
            return this.iOther != null;
        }

        public Integer getEnrollment() {
            return this.iEnrollment;
        }

        public void setEnrollment(Integer enrollment) {
            this.iEnrollment = enrollment;
        }

        public boolean hasEnrollment() {
            return this.iEnrollment != null;
        }

        public Integer getProjection() {
            return this.iProjection;
        }

        public void setProjection(Integer projection) {
            this.iProjection = projection;
        }

        public boolean hasProjection() {
            return this.iProjection != null;
        }

        public Integer getWaitlist() {
            return this.iWaitlist;
        }

        public void setWaitlist(Integer waitlist) {
            this.iWaitlist = waitlist;
        }

        public boolean hasWaitlist() {
            return this.iWaitlist != null;
        }

        public Integer getUnassigned() {
            return this.iUnassigned;
        }

        public void setUnassigned(Integer unassigned) {
            this.iUnassigned = unassigned;
        }

        public boolean hasUnassigned() {
            return this.iUnassigned != null;
        }

        public Integer getUnassignedPrimary() {
            return this.iUnassignedPrimary;
        }

        public void setUnassignedPrimary(Integer unassigned) {
            this.iUnassignedPrimary = unassigned;
        }

        public boolean hasUnassignedPrimary() {
            return this.iUnassignedPrimary != null;
        }

        public Integer getUnassignedAlternative() {
            if (this.iUnassigned == null) {
                return null;
            }
            return this.iUnassigned - (this.iUnassignedPrimary == null ? 0 : this.iUnassignedPrimary);
        }

        public Integer getReservation() {
            return this.iReservation;
        }

        public void setReservation(Integer reservation) {
            this.iReservation = reservation;
        }

        public boolean hasReservation() {
            return this.iReservation != null;
        }

        public Integer getTotalEnrollment() {
            return this.iTotalEnrollment;
        }

        public void setTotalEnrollment(Integer enrollment) {
            this.iTotalEnrollment = enrollment;
        }

        public boolean hasTotalEnrollment() {
            return this.iTotalEnrollment != null;
        }

        public Integer getTotalWaitlist() {
            return this.iTotalWaitlist;
        }

        public void setTotalWaitlist(Integer waitlist) {
            this.iTotalWaitlist = waitlist;
        }

        public boolean hasTotalWaitlist() {
            return this.iTotalWaitlist != null;
        }

        public Integer getTotalUnassigned() {
            return this.iTotalUnassigned;
        }

        public void setTotalUnassigned(Integer unassigned) {
            this.iTotalUnassigned = unassigned;
        }

        public boolean hasTotalUnassigned() {
            return this.iTotalUnassigned != null;
        }

        public Integer getTotalUnassignedPrimary() {
            return this.iTotalUnassignedPrimary;
        }

        public void setTotalUnassignedPrimary(Integer unassigned) {
            this.iTotalUnassignedPrimary = unassigned;
        }

        public boolean hasTotalUnassignedPrimary() {
            return this.iTotalUnassignedPrimary != null;
        }

        public Integer getTotalUnassignedAlternative() {
            if (this.iTotalUnassigned == null) {
                return null;
            }
            return this.iTotalUnassigned - (this.iTotalUnassignedPrimary == null ? 0 : this.iTotalUnassignedPrimary);
        }

        public Integer getTotalReservation() {
            return this.iTotalReservation;
        }

        public void setTotalReservation(Integer reservation) {
            this.iTotalReservation = reservation;
        }

        public boolean hasTotalReservation() {
            return this.iTotalReservation != null;
        }

        public Integer getAvailable() {
            return this.iAvailable;
        }

        public void setAvailable(Integer available) {
            this.iAvailable = available;
        }

        public boolean hasAvailable() {
            return this.iAvailable != null;
        }

        public void setAssignment(ClassAssignment assignment) {
            this.iAssignment = assignment;
        }

        public ClassAssignment getAssignment() {
            return this.iAssignment;
        }

        public Integer getConsentNeeded() {
            return this.iConsentNeeded;
        }

        public void setConsentNeeded(Integer consentNeeded) {
            this.iConsentNeeded = consentNeeded;
        }

        public int hasConsentNeeded() {
            return this.iConsentNeeded;
        }

        public Integer getTotalConsentNeeded() {
            return this.iTotalConsentNeeded;
        }

        public void setTotalConsentNeeded(Integer totalConsentNeeded) {
            this.iTotalConsentNeeded = totalConsentNeeded;
        }

        public int hasTotalConsentNeeded() {
            return this.iTotalConsentNeeded;
        }

        public Integer getOverrideNeeded() {
            return this.iOverrideNeeded;
        }

        public void setOverrideNeeded(Integer overrideNeeded) {
            this.iOverrideNeeded = overrideNeeded;
        }

        public int hasOverrideNeeded() {
            return this.iOverrideNeeded;
        }

        public Integer getTotalOverrideNeeded() {
            return this.iTotalOverrideNeeded;
        }

        public void setTotalOverrideNeeded(Integer totalOverrideNeeded) {
            this.iTotalOverrideNeeded = totalOverrideNeeded;
        }

        public int hasTotalOverrideNeeded() {
            return this.iTotalOverrideNeeded;
        }

        public int getLevel() {
            return this.iLevel;
        }

        public void setLevel(int level) {
            this.iLevel = level;
        }

        public void incLevel() {
            ++this.iLevel;
        }

        public String getIndent() {
            return this.getIndent("&nbsp;&nbsp;");
        }

        public String getIndent(String ind) {
            String indent = "";
            for (int i = 0; i < this.iLevel; ++i) {
                indent = indent + ind;
            }
            return indent;
        }
    }

    public static class Conflict
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private String iName;
        private String iType;
        private String iDate;
        private String iTime;
        private String iRoom;
        private String iStyle;

        public String getName() {
            return this.iName;
        }

        public void setName(String name) {
            this.iName = name;
        }

        public String getType() {
            return this.iType;
        }

        public void setType(String type) {
            this.iType = type;
        }

        public String getDate() {
            return this.iDate;
        }

        public void setDate(String date) {
            this.iDate = date;
        }

        public String getTime() {
            return this.iTime;
        }

        public void setTime(String time) {
            this.iTime = time;
        }

        public String getRoom() {
            return this.iRoom;
        }

        public void setRoom(String room) {
            this.iRoom = room;
        }

        public boolean hasStyle() {
            return this.iStyle != null && !this.iStyle.isEmpty();
        }

        public String getStyle() {
            return this.iStyle;
        }

        public void setStyle(String style) {
            this.iStyle = style;
        }

        public String toString() {
            return this.getName() + " " + this.getType() + " " + this.getDate() + " " + this.getTime() + " " + this.getRoom();
        }
    }

    public static class Enrollment
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Student iStudent;
        private CourseAssignment iCourse = null;
        private int iPriority = 0;
        private String iAlternative = null;
        private Date iRequestedDate = null;
        private Date iEnrolledDate = null;
        private Date iApprovedDate = null;
        private String iReservation = null;
        private String iApprovedBy = null;
        private List<Conflict> iConflicts = null;
        private Boolean iWaitList = null;
        private String iEnrollmentMessage = null;

        public Student getStudent() {
            return this.iStudent;
        }

        public void setStudent(Student student) {
            this.iStudent = student;
        }

        public CourseAssignment getCourse() {
            return this.iCourse;
        }

        public void setCourse(CourseAssignment course) {
            this.iCourse = course;
        }

        public int getPriority() {
            return this.iPriority;
        }

        public void setPriority(int priority) {
            this.iPriority = priority;
        }

        public boolean isAlternative() {
            return this.iAlternative != null;
        }

        public void setAlternative(String course) {
            this.iAlternative = course;
        }

        public String getAlternative() {
            return this.iAlternative == null ? "" : this.iAlternative;
        }

        public Date getRequestedDate() {
            return this.iRequestedDate;
        }

        public void setRequestedDate(Date ts) {
            this.iRequestedDate = ts;
        }

        public Date getEnrolledDate() {
            return this.iEnrolledDate;
        }

        public void setEnrolledDate(Date ts) {
            this.iEnrolledDate = ts;
        }

        public Date getApprovedDate() {
            return this.iApprovedDate;
        }

        public void setApprovedDate(Date ts) {
            this.iApprovedDate = ts;
        }

        public String getApprovedBy() {
            return this.iApprovedBy;
        }

        public void setApprovedBy(String approvedBy) {
            this.iApprovedBy = approvedBy;
        }

        public boolean hasWaitList() {
            return this.iWaitList != null;
        }

        public boolean isWaitList() {
            return this.iWaitList != null && this.iWaitList != false;
        }

        public void setWaitList(Boolean waitList) {
            this.iWaitList = waitList;
        }

        public String getClasses(String subpart, String delim, boolean showClassNumbers) {
            if (this.getCourse() == null || this.getCourse().getClassAssignments().isEmpty()) {
                return "";
            }
            String ret = "";
            TreeSet<String> sections = new TreeSet<String>();
            for (ClassAssignment c : this.getCourse().getClassAssignments()) {
                if (!subpart.equals(c.getSubpart())) continue;
                sections.add(showClassNumbers && c.getClassNumber() != null ? c.getClassNumber() : c.getSection());
            }
            for (String section : sections) {
                if (!ret.isEmpty()) {
                    ret = ret + delim;
                }
                ret = ret + section;
            }
            return ret;
        }

        public boolean hasClasses() {
            return this.getCourse() != null && !this.getCourse().getClassAssignments().isEmpty();
        }

        public List<ClassAssignment> getClasses() {
            return this.getCourse() == null ? null : this.getCourse().getClassAssignments();
        }

        public Long getCourseId() {
            return this.getCourse() == null ? null : this.getCourse().getCourseId();
        }

        public String getCourseName() {
            return this.getCourse() == null ? null : this.getCourse().getCourseName();
        }

        public String getReservation() {
            return this.iReservation;
        }

        public void setReservation(String reservation) {
            this.iReservation = reservation;
        }

        public boolean hasConflict() {
            return this.iConflicts != null && !this.iConflicts.isEmpty();
        }

        public void addConflict(Conflict conflict) {
            if (this.iConflicts == null) {
                this.iConflicts = new ArrayList<Conflict>();
            }
            this.iConflicts.add(conflict);
        }

        public List<Conflict> getConflicts() {
            return this.iConflicts;
        }

        public String getEnrollmentMessage() {
            return this.iEnrollmentMessage;
        }

        public boolean hasEnrollmentMessage() {
            return this.iEnrollmentMessage != null && !this.iEnrollmentMessage.isEmpty();
        }

        public void setEnrollmentMessage(String message) {
            this.iEnrollmentMessage = message;
        }
    }

    public static class Student
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private long iId;
        private Long iSessionId = null;
        private String iExternalId;
        private String iName;
        private String iEmail;
        private List<String> iArea;
        private List<String> iClassification;
        private List<String> iMajor;
        private List<String> iAccommodation;
        private List<String> iAdvisor;
        private Set<Group> iGroups;
        private boolean iCanShowExternalId = false;
        private boolean iCanSelect = false;
        private boolean iCanUseAssitant = false;
        private boolean iCanRegister = false;

        public void setId(long id) {
            this.iId = id;
        }

        public long getId() {
            return this.iId;
        }

        public void setSessionId(Long sessionId) {
            this.iSessionId = sessionId;
        }

        public Long getSessionId() {
            return this.iSessionId;
        }

        public String getExternalId() {
            return this.iExternalId;
        }

        public void setExternalId(String externalId) {
            this.iExternalId = externalId;
        }

        public void setCanShowExternalId(boolean canShowExternalId) {
            this.iCanShowExternalId = canShowExternalId;
        }

        public boolean isCanShowExternalId() {
            return this.iExternalId != null && this.iCanShowExternalId;
        }

        public void setCanUseAssistant(boolean canUseAssistant) {
            this.iCanUseAssitant = canUseAssistant;
        }

        public boolean isCanUseAssistant() {
            return this.iCanUseAssitant;
        }

        public void setCanRegister(boolean canRegister) {
            this.iCanRegister = canRegister;
        }

        public boolean isCanRegister() {
            return this.iCanRegister;
        }

        public void setCanSelect(boolean canSelect) {
            this.iCanSelect = canSelect;
        }

        public boolean isCanSelect() {
            return this.iCanSelect;
        }

        public String getName() {
            return this.iName;
        }

        public void setName(String name) {
            this.iName = name;
        }

        public String getEmail() {
            return this.iEmail;
        }

        public void setEmail(String email) {
            this.iEmail = email;
        }

        public boolean hasArea() {
            return this.iArea != null && !this.iArea.isEmpty();
        }

        public String getArea(String delim) {
            if (this.iArea == null) {
                return "";
            }
            String ret = "";
            for (String area : this.iArea) {
                if (!ret.isEmpty()) {
                    ret = ret + delim;
                }
                ret = ret + area;
            }
            return ret;
        }

        public void addArea(String area) {
            if (this.iArea == null) {
                this.iArea = new ArrayList<String>();
            }
            this.iArea.add(area);
        }

        public List<String> getAreas() {
            return this.iArea;
        }

        public boolean hasClassification() {
            return this.iClassification != null && !this.iClassification.isEmpty();
        }

        public String getClassification(String delim) {
            if (this.iClassification == null) {
                return "";
            }
            String ret = "";
            for (String classification : this.iClassification) {
                if (!ret.isEmpty()) {
                    ret = ret + delim;
                }
                ret = ret + classification;
            }
            return ret;
        }

        public void addClassification(String classification) {
            if (this.iClassification == null) {
                this.iClassification = new ArrayList<String>();
            }
            this.iClassification.add(classification);
        }

        public List<String> getClassifications() {
            return this.iClassification;
        }

        public boolean hasMajor() {
            return this.iMajor != null && !this.iMajor.isEmpty();
        }

        public String getMajor(String delim) {
            if (this.iMajor == null) {
                return "";
            }
            String ret = "";
            for (String major : this.iMajor) {
                if (!ret.isEmpty()) {
                    ret = ret + delim;
                }
                ret = ret + major;
            }
            return ret;
        }

        public void addMajor(String major) {
            if (this.iMajor == null) {
                this.iMajor = new ArrayList<String>();
            }
            this.iMajor.add(major);
        }

        public List<String> getMajors() {
            return this.iMajor;
        }

        public boolean hasAdvisor() {
            return this.iAdvisor != null && !this.iAdvisor.isEmpty();
        }

        public String getAdvisor(String delim) {
            if (this.iAdvisor == null) {
                return "";
            }
            String ret = "";
            for (String advisor : this.iAdvisor) {
                if (!ret.isEmpty()) {
                    ret = ret + delim;
                }
                ret = ret + advisor;
            }
            return ret;
        }

        public void addAdvisor(String advisor) {
            if (advisor == null || advisor.isEmpty()) {
                return;
            }
            if (this.iAdvisor == null) {
                this.iAdvisor = new ArrayList<String>();
            }
            this.iAdvisor.add(advisor);
        }

        public List<String> getAdvisors() {
            return this.iAdvisor;
        }

        public boolean hasGroup() {
            return this.hasGroups(null);
        }

        public String getGroup(String delim) {
            return this.getGroup(null, delim);
        }

        public void addGroup(String group, String title) {
            this.addGroup(null, group, title);
        }

        public void removeGroup(String group) {
            this.removeGroup(null, group);
        }

        public List<Group> getGroups() {
            return this.getGroups(null);
        }

        public boolean hasGroup(String group) {
            if (this.iGroups == null) {
                return false;
            }
            for (Group g : this.iGroups) {
                if (!g.getName().equals(group)) continue;
                return true;
            }
            return false;
        }

        public boolean hasGroups() {
            return this.iGroups != null && !this.iGroups.isEmpty();
        }

        public void addGroup(String type, String group, String title) {
            if (this.iGroups == null) {
                this.iGroups = new TreeSet<Group>();
            }
            this.iGroups.add(new Group(type, group, title));
        }

        public void removeGroup(String type, String group) {
            if (this.iGroups == null) {
                return;
            }
            Iterator<Group> i = this.iGroups.iterator();
            while (i.hasNext()) {
                Group g = i.next();
                if (!g.sameType(type) || !g.getName().equals(group)) continue;
                i.remove();
            }
        }

        public List<Group> getGroups(String type) {
            if (this.iGroups == null) {
                return null;
            }
            ArrayList<Group> groups = new ArrayList<Group>();
            for (Group g : this.iGroups) {
                if (!g.sameType(type)) continue;
                groups.add(g);
            }
            return groups;
        }

        public Set<String> getGroupTypes() {
            if (this.iGroups == null) {
                return null;
            }
            HashSet<String> types = new HashSet<String>();
            for (Group g : this.iGroups) {
                if (!g.hasType()) continue;
                types.add(g.getType());
            }
            return types;
        }

        public boolean hasGroups(String type) {
            if (this.iGroups == null || this.iGroups.isEmpty()) {
                return false;
            }
            for (Group g : this.iGroups) {
                if (!g.sameType(type)) continue;
                return true;
            }
            return false;
        }

        public String getGroup(String type, String delim) {
            if (this.iGroups == null) {
                return "";
            }
            boolean html = "<br>".equalsIgnoreCase(delim);
            String ret = "";
            for (Group g : this.iGroups) {
                if (!g.sameType(type)) continue;
                if (!ret.isEmpty()) {
                    ret = ret + delim;
                }
                ret = ret + (html && g.hasTitle() ? "<span title='" + g.getTitle() + "'>" + g.getName() + "</span>" : g.getName());
            }
            return ret;
        }

        public boolean hasAccommodation() {
            return this.iAccommodation != null && !this.iAccommodation.isEmpty();
        }

        public String getAccommodation(String delim) {
            if (this.iAccommodation == null) {
                return "";
            }
            String ret = "";
            for (String accommodation : this.iAccommodation) {
                if (!ret.isEmpty()) {
                    ret = ret + delim;
                }
                ret = ret + accommodation;
            }
            return ret;
        }

        public void addAccommodation(String accommodation) {
            if (this.iAccommodation == null) {
                this.iAccommodation = new ArrayList<String>();
            }
            this.iAccommodation.add(accommodation);
        }

        public List<String> getAccommodations() {
            return this.iAccommodation;
        }

        public String getCurriculum(String delim) {
            if (!this.hasArea()) {
                return "";
            }
            String ret = "";
            for (int i = 0; i < this.iArea.size(); ++i) {
                if (!ret.isEmpty()) {
                    ret = ret + delim;
                }
                ret = ret + this.iArea.get(i) + " " + this.iClassification.get(i);
                if (this.iMajor == null || i >= this.iMajor.size()) continue;
                ret = ret + " " + this.iMajor.get(i);
            }
            return ret;
        }

        public String getAreaClasf(String delim) {
            if (!this.hasArea()) {
                return "";
            }
            String ret = "";
            for (int i = 0; i < this.iArea.size(); ++i) {
                if (!ret.isEmpty()) {
                    ret = ret + delim;
                }
                ret = ret + this.iArea.get(i) + " " + this.iClassification.get(i);
            }
            return ret;
        }
    }

    public static class Group
    implements IsSerializable,
    Serializable,
    Comparable<Group> {
        private static final long serialVersionUID = 1L;
        private String iType;
        private String iName;
        private String iTitle;

        public Group() {
        }

        public Group(String type, String name, String title) {
            this.iType = type;
            this.iName = name;
            this.iTitle = title;
        }

        public Group(String name, String title) {
            this(null, name, title);
        }

        public String getType() {
            return this.iType;
        }

        public void setType(String type) {
            this.iType = type;
        }

        public boolean hasType() {
            return this.iType != null && !this.iType.isEmpty();
        }

        public String getTypeNotNull() {
            return this.iType == null ? "" : this.iType;
        }

        public boolean sameType(String type) {
            if (!this.hasType()) {
                return type == null || type.isEmpty();
            }
            return this.getType().equals(type);
        }

        public String getName() {
            return this.iName;
        }

        public void setName(String name) {
            this.iName = name;
        }

        public String getTitle() {
            return this.iTitle;
        }

        public void setTitle(String title) {
            this.iTitle = title;
        }

        public boolean hasTitle() {
            return this.iTitle != null && !this.iTitle.isEmpty();
        }

        @Override
        public int compareTo(Group g) {
            int cmp = this.getTypeNotNull().compareTo(g.getTypeNotNull());
            if (cmp != 0) {
                return cmp;
            }
            return this.getName().compareTo(g.getName());
        }
    }

    public static class ClassAssignment
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private boolean iCourseAssigned = true;
        private Long iCourseId;
        private Long iClassId;
        private Long iSubpartId;
        private ArrayList<Integer> iDays = new ArrayList();
        private int iStart;
        private int iLength;
        private int iBreakTime = 0;
        private ArrayList<String> iInstructos = new ArrayList();
        private ArrayList<String> iInstructoEmails = new ArrayList();
        private ArrayList<IdValue> iRooms = new ArrayList();
        private boolean iAlternative = false;
        private boolean iHasAlternatives = true;
        private boolean iDistanceConflict = false;
        private boolean iTeachingAssigment = false;
        private boolean iInstructing = false;
        private String iDatePattern = null;
        private String iSubject;
        private String iCourseNbr;
        private String iSubpart;
        private String iSection;
        private String iParentSection;
        private String iNumber;
        private String iTitle;
        private int[] iLimit = null;
        private boolean iPin = false;
        private int iBackToBackDistance = 0;
        private String iBackToBackRooms = null;
        private boolean iSaved = false;
        private boolean iDummy = false;
        private boolean iCancelled = false;
        private Integer iExpected = null;
        private String iOverlapNote = null;
        private String iNote = null;
        private String iCredit = null;
        private String iError = null;
        private Date iEnrolledDate = null;
        private String iExternalId = null;
        private SpecialRegistrationInterface.SpecialRegistrationStatus iSpecRegStatus = null;
        private SpecialRegistrationInterface.SpecialRegistrationOperation iSpecRegOperation = null;
        private OnlineSectioningInterface.GradeMode iGradeMode = null;

        public ClassAssignment() {
        }

        public ClassAssignment(CourseAssignment course) {
            this.iCourseId = course.getCourseId();
            this.iSubject = course.getSubject();
            this.iCourseNbr = course.getCourseNbr();
            this.iCourseAssigned = course.isAssigned();
            this.iTitle = course.getTitle();
        }

        public Long getCourseId() {
            return this.iCourseId;
        }

        public void setCourseId(Long courseId) {
            this.iCourseId = courseId;
        }

        public boolean isFreeTime() {
            return this.iCourseId == null;
        }

        public boolean isCourseAssigned() {
            return this.iCourseAssigned;
        }

        public void setCourseAssigned(boolean courseAssigned) {
            this.iCourseAssigned = courseAssigned;
        }

        public String getSubject() {
            return this.iSubject;
        }

        public void setSubject(String subject) {
            this.iSubject = subject;
        }

        public String getCourseNbr() {
            return this.iCourseNbr;
        }

        public void setCourseNbr(String courseNbr) {
            this.iCourseNbr = courseNbr;
        }

        public String getCourseNbr(boolean includeTitle) {
            return this.getCourseNbr() + (includeTitle & this.hasTitle() ? " - " + this.getTitle() : "");
        }

        public String getTitle() {
            return this.iTitle;
        }

        public void setTitle(String title) {
            this.iTitle = title;
        }

        public boolean hasTitle() {
            return this.iTitle != null && !this.iTitle.isEmpty();
        }

        public String getSubpart() {
            return this.iSubpart;
        }

        public void setSubpart(String subpart) {
            this.iSubpart = subpart;
        }

        public String getSection() {
            return this.iSection;
        }

        public void setSection(String section) {
            this.iSection = section;
        }

        public String getExternalId() {
            return this.iExternalId;
        }

        public void setExternalId(String extId) {
            this.iExternalId = extId;
        }

        public CourseRequestInterface.Preference getSelection() {
            return this.getSelection(false);
        }

        public CourseRequestInterface.Preference getSelection(boolean required) {
            return new CourseRequestInterface.Preference(this.iClassId, this.iSection.length() <= 4 ? this.iSubpart + " " + this.iSection : this.iSection, required);
        }

        public String getParentSection() {
            return this.iParentSection;
        }

        public void setParentSection(String parentSection) {
            this.iParentSection = parentSection;
        }

        public boolean isAlternative() {
            return this.iAlternative;
        }

        public void setAlternative(boolean alternative) {
            this.iAlternative = alternative;
        }

        public Long getClassId() {
            return this.iClassId;
        }

        public void setClassId(Long classId) {
            this.iClassId = classId;
        }

        public Long getSubpartId() {
            return this.iSubpartId;
        }

        public void setSubpartId(Long subpartId) {
            this.iSubpartId = subpartId;
        }

        public void addDay(int day) {
            if (this.iDays == null) {
                this.iDays = new ArrayList();
            }
            this.iDays.add(day);
        }

        public ArrayList<Integer> getDays() {
            return this.iDays;
        }

        public String getDaysString(String[] shortDays, String separator) {
            if (this.iDays == null) {
                return "";
            }
            String ret = "";
            for (int day : this.iDays) {
                ret = ret + (ret.isEmpty() ? "" : separator) + shortDays[day];
            }
            return ret;
        }

        public String getDaysString(String[] shortDays) {
            return this.getDaysString(shortDays, "");
        }

        public boolean isAssigned() {
            return this.iDays != null && !this.iDays.isEmpty();
        }

        public int getStart() {
            return this.iStart;
        }

        public void setStart(int start) {
            this.iStart = start;
        }

        public String getStartString(boolean useAmPm) {
            if (!this.isAssigned()) {
                return "";
            }
            int h = this.iStart / 12;
            int m = 5 * (this.iStart % 12);
            if (useAmPm) {
                return (h > 12 ? h - 12 : h) + ":" + (m < 10 ? "0" : "") + m + (h == 24 ? "a" : (h >= 12 ? "p" : "a"));
            }
            return h + ":" + (m < 10 ? "0" : "") + m;
        }

        public String getStartStringAria(boolean useAmPm) {
            if (!this.isAssigned()) {
                return "";
            }
            int h = this.iStart / 12;
            int m = 5 * (this.iStart % 12);
            if (useAmPm) {
                return (h > 12 ? h - 12 : h) + (m == 0 ? "" : (m < 10 ? " 0" : " ") + m) + (h == 24 ? " AM" : (h >= 12 ? " PM" : " AM"));
            }
            return h + ":" + (m < 10 ? "0" : "") + m;
        }

        public int getLength() {
            return this.iLength;
        }

        public void setLength(int length) {
            this.iLength = length;
        }

        public String getEndString(boolean useAmPm) {
            if (!this.isAssigned()) {
                return "";
            }
            int h = (5 * (this.iStart + this.iLength) - this.iBreakTime) / 60;
            int m = (5 * (this.iStart + this.iLength) - this.iBreakTime) % 60;
            if (useAmPm) {
                return (h > 12 ? h - 12 : h) + ":" + (m < 10 ? "0" : "") + m + (h == 24 ? "a" : (h >= 12 ? "p" : "a"));
            }
            return h + ":" + (m < 10 ? "0" : "") + m;
        }

        public String getEndStringAria(boolean useAmPm) {
            if (!this.isAssigned()) {
                return "";
            }
            int h = (5 * (this.iStart + this.iLength) - this.iBreakTime) / 60;
            int m = (5 * (this.iStart + this.iLength) - this.iBreakTime) % 60;
            if (useAmPm) {
                return (h > 12 ? h - 12 : h) + (m == 0 ? "" : (m < 10 ? " 0" : " ") + m) + (h == 24 ? " AM" : (h >= 12 ? " PM" : " AM"));
            }
            return h + ":" + (m < 10 ? "0" : "") + m;
        }

        public String getTimeString(String[] shortDays, boolean useAmPm, String arrangeHours) {
            if (!this.isAssigned()) {
                return this.iClassId == null ? "" : arrangeHours;
            }
            return this.getDaysString(shortDays) + " " + this.getStartString(useAmPm) + " - " + this.getEndString(useAmPm);
        }

        public String getTimeStringAria(String[] longDays, boolean useAmPm, String arrangeHours) {
            if (!this.isAssigned()) {
                return this.iClassId == null ? "" : arrangeHours;
            }
            int h = this.iStart / 12;
            int m = 5 * (this.iStart % 12);
            String ret = this.getDaysString(longDays, " ") + " from ";
            ret = useAmPm ? ret + (h > 12 ? h - 12 : h) + (m == 0 ? "" : (m < 10 ? " 0" : " ") + m) + (h == 24 ? " AM" : (h >= 12 ? " PM" : " AM")) : ret + h + " " + (m < 10 ? "0" : "") + m;
            h = (this.iStart + this.iLength) / 12;
            m = 5 * ((this.iStart + this.iLength) % 12);
            ret = ret + " to ";
            ret = useAmPm ? ret + (h > 12 ? h - 12 : h) + (m == 0 ? "" : (m < 10 ? " 0" : " ") + m) + (h == 24 ? " AM" : (h >= 12 ? " PM" : " AM")) : ret + h + " " + (m < 10 ? "0" : "") + m;
            return ret;
        }

        public int getBreakTime() {
            return this.iBreakTime;
        }

        public void setBreakTime(int breakTime) {
            this.iBreakTime = breakTime;
        }

        public boolean hasDatePattern() {
            return this.iDatePattern != null && !this.iDatePattern.isEmpty();
        }

        public String getDatePattern() {
            return this.iDatePattern;
        }

        public void setDatePattern(String datePattern) {
            this.iDatePattern = datePattern;
        }

        public boolean hasInstructors() {
            return this.iInstructos != null && !this.iInstructos.isEmpty();
        }

        public void addInstructor(String instructor) {
            if (this.iInstructos == null) {
                this.iInstructos = new ArrayList();
            }
            this.iInstructos.add(instructor);
        }

        public ArrayList<String> getInstructors() {
            return this.iInstructos;
        }

        public String getInstructors(String delim) {
            if (this.iInstructos == null) {
                return "";
            }
            String ret = "";
            for (String instructor : this.iInstructos) {
                if (!ret.isEmpty()) {
                    ret = ret + delim;
                }
                ret = ret + instructor;
            }
            return ret;
        }

        public String getInstructorWithEmails(String delim) {
            if (this.iInstructos == null) {
                return "";
            }
            String ret = "";
            for (int i = 0; i < this.iInstructos.size(); ++i) {
                if (!ret.isEmpty()) {
                    ret = ret + delim;
                }
                String email = this.iInstructoEmails != null && i < this.iInstructoEmails.size() ? this.iInstructoEmails.get(i) : null;
                ret = email != null && !email.isEmpty() ? ret + "<A class=\"unitime-SimpleLink\" href=\"mailto:" + email + "\">" + this.iInstructos.get(i) + "</A>" : ret + this.iInstructos.get(i);
            }
            return ret;
        }

        public boolean hasInstructorEmails() {
            return this.iInstructoEmails != null && !this.iInstructoEmails.isEmpty();
        }

        public void addInstructoEmail(String instructorEmail) {
            if (this.iInstructoEmails == null) {
                this.iInstructoEmails = new ArrayList();
            }
            this.iInstructoEmails.add(instructorEmail == null ? "" : instructorEmail);
        }

        public ArrayList<String> getInstructorEmails() {
            return this.iInstructoEmails;
        }

        public boolean hasRoom() {
            return this.iRooms != null && !this.iRooms.isEmpty();
        }

        public void addRoom(Long id, String name) {
            if (this.iRooms == null) {
                this.iRooms = new ArrayList();
            }
            this.iRooms.add(new IdValue(id, name));
        }

        public ArrayList<IdValue> getRooms() {
            return this.iRooms;
        }

        public String getRooms(String delim) {
            if (this.iRooms == null) {
                return "";
            }
            String ret = "";
            for (IdValue room : this.iRooms) {
                if (!ret.isEmpty()) {
                    ret = ret + delim;
                }
                ret = ret + room.getValue();
            }
            return ret;
        }

        public boolean isUnlimited() {
            return this.iLimit != null && (this.iLimit[1] < 0 || this.iLimit[1] >= 9999);
        }

        public int[] getLimit() {
            return this.iLimit;
        }

        public void setLimit(int[] limit) {
            this.iLimit = limit;
        }

        public String getLimitString() {
            if (this.iLimit == null) {
                return "";
            }
            if (this.iLimit[1] >= 9999 || this.iLimit[1] < 0) {
                return "&infin;";
            }
            if (this.iLimit[0] < 0) {
                return String.valueOf(this.iLimit[1]);
            }
            return (this.iLimit[1] > this.iLimit[0] ? this.iLimit[1] - this.iLimit[0] : 0) + " / " + this.iLimit[1];
        }

        public boolean isAvailable() {
            if (this.iLimit == null) {
                return true;
            }
            if (this.iLimit[1] < 0) {
                return true;
            }
            if (this.iLimit[0] < 0) {
                return this.iLimit[1] != 0;
            }
            return this.iLimit[0] < this.iLimit[1];
        }

        public int getAvailableLimit() {
            if (this.iLimit == null) {
                return 9999;
            }
            if (this.iLimit[0] < 0) {
                return 9999;
            }
            return this.iLimit[1] - this.iLimit[0];
        }

        public boolean isPinned() {
            return this.iPin;
        }

        public void setPinned(boolean pin) {
            this.iPin = pin;
        }

        public boolean hasAlternatives() {
            return this.iHasAlternatives;
        }

        public void setHasAlternatives(boolean alternatives) {
            this.iHasAlternatives = alternatives;
        }

        public boolean isTeachingAssignment() {
            return this.iTeachingAssigment;
        }

        public void setTeachingAssignment(boolean ta) {
            this.iTeachingAssigment = ta;
        }

        public boolean isInstructing() {
            return this.iInstructing;
        }

        public void setInstructing(boolean instructing) {
            this.iInstructing = instructing;
        }

        public boolean hasDistanceConflict() {
            return this.iDistanceConflict;
        }

        public void setDistanceConflict(boolean distanceConflict) {
            this.iDistanceConflict = distanceConflict;
        }

        public int getBackToBackDistance() {
            return this.iBackToBackDistance;
        }

        public void setBackToBackDistance(int backToBackDistance) {
            this.iBackToBackDistance = backToBackDistance;
        }

        public String getBackToBackRooms() {
            return this.iBackToBackRooms;
        }

        public void setBackToBackRooms(String backToBackRooms) {
            this.iBackToBackRooms = backToBackRooms;
        }

        public boolean isSaved() {
            return this.iSaved;
        }

        public void setSaved(boolean saved) {
            this.iSaved = saved;
        }

        public boolean isDummy() {
            return this.iDummy;
        }

        public void setDummy(boolean dummy) {
            this.iDummy = dummy;
        }

        public boolean isCancelled() {
            return this.iCancelled;
        }

        public void setCancelled(boolean cancelled) {
            this.iCancelled = cancelled;
        }

        public void setError(String error) {
            this.iError = error;
        }

        public boolean hasError() {
            return this.iError != null && !this.iError.isEmpty();
        }

        public String getError() {
            return this.iError;
        }

        public void setExpected(Integer expected) {
            this.iExpected = expected;
        }

        public boolean hasExpected() {
            return this.iExpected != null;
        }

        public int getExpected() {
            return this.iExpected == null ? 0 : this.iExpected;
        }

        public boolean isOfHighDemand() {
            return this.isAvailable() && !this.isUnlimited() && this.hasExpected() && this.getExpected() + (this.isSaved() ? -1 : 0) >= this.getAvailableLimit();
        }

        public String toString() {
            return (this.isFreeTime() ? "Free Time" : this.getSubpart() + " " + this.getSection()) + (this.isAssigned() ? " " + this.getTimeString(new String[]{"M", "T", "W", "R", "F", "S", "X"}, true, "") : "") + (this.hasRoom() ? " " + this.getRooms(",") : "") + (this.isSaved() || this.isPinned() || this.isOfHighDemand() || this.hasAlternatives() || this.hasDistanceConflict() || this.isUnlimited() ? "[" + (this.isSaved() ? "s" : "") + (this.isPinned() ? "p" : "") + (this.isOfHighDemand() ? "h" : "") + (this.hasAlternatives() ? "a" : "") + (this.hasDistanceConflict() ? "d" : "") + (this.isUnlimited() ? "u" : "") + (this.isCancelled() ? "c" : "") + "]" : "");
        }

        public String getClassNumber() {
            return this.iNumber;
        }

        public void setClassNumber(String number) {
            this.iNumber = number;
        }

        public boolean hasNote() {
            return this.iNote != null && !this.iNote.isEmpty();
        }

        public String getNote() {
            return this.iNote == null ? "" : this.iNote;
        }

        public void setNote(String note) {
            this.iNote = note;
        }

        public void addNote(String note) {
            this.addNote(note, "\n");
        }

        public void addNote(String note, String separator) {
            if (note == null || note.isEmpty()) {
                return;
            }
            if (this.iNote == null || this.iNote.isEmpty()) {
                this.iNote = note;
            } else {
                this.iNote = separator == null ? (this.iNote.endsWith(".") || this.iNote.endsWith(",") ? this.iNote + " " : this.iNote + "; ") : this.iNote + separator;
                this.iNote = this.iNote + note;
            }
        }

        public void setOverlapNote(String note) {
            this.iOverlapNote = note;
        }

        public boolean hasOverlapNote() {
            return this.iOverlapNote != null && !this.iOverlapNote.isEmpty();
        }

        public String getOverlapNote() {
            return this.iOverlapNote;
        }

        public String getOverlapAndNote(String overlapStyle) {
            String ret = "";
            if (this.hasOverlapNote()) {
                ret = ret + (overlapStyle != null ? "<span class='" + overlapStyle + "'>" + this.getOverlapNote() + "</span>" : this.getOverlapNote());
            }
            if (this.hasNote()) {
                if (!ret.isEmpty()) {
                    ret = ret + (overlapStyle == null ? "\n" : "<br>");
                }
                ret = ret + (overlapStyle == null ? this.getNote() : this.getNote().replace("\n", "<br>"));
            }
            return ret;
        }

        public boolean hasCredit() {
            return this.iCredit != null && !this.iCredit.isEmpty();
        }

        public String getCredit() {
            return this.iCredit == null ? "" : this.iCredit;
        }

        public void setCredit(String credit) {
            this.iCredit = credit;
        }

        public float guessCreditCount() {
            if (!this.hasCredit()) {
                return 0.0f;
            }
            MatchResult m = RegExp.compile((String)"\\d+\\.?\\d*").exec(this.getCredit());
            if (m != null) {
                return Float.parseFloat(m.getGroup(0));
            }
            return 0.0f;
        }

        public String getCourseName() {
            return this.isFreeTime() ? "Free Time" : this.getSubject() + " " + this.getCourseNbr();
        }

        public String getCourseNameWithTitle() {
            return this.isFreeTime() ? "Free Time" : (this.hasTitle() ? this.getSubject() + " " + this.getCourseNbr() + " - " + this.getTitle() : this.getSubject() + " " + this.getCourseNbr());
        }

        public boolean equalsIgnoreCase(String requestedCourse) {
            return this.getCourseName().equalsIgnoreCase(requestedCourse) || this.getCourseNameWithTitle().equalsIgnoreCase(requestedCourse);
        }

        public boolean equalsIgnoreCase(CourseRequestInterface.RequestedCourse requestedCourse) {
            if (requestedCourse == null || !requestedCourse.isCourse()) {
                return false;
            }
            if (requestedCourse.hasCourseId()) {
                return requestedCourse.getCourseId().equals(this.getCourseId());
            }
            return this.getCourseName().equalsIgnoreCase(requestedCourse.getCourseName()) || this.getCourseNameWithTitle().equalsIgnoreCase(requestedCourse.getCourseName());
        }

        public Date getEnrolledDate() {
            return this.iEnrolledDate;
        }

        public void setEnrolledDate(Date ts) {
            this.iEnrolledDate = ts;
        }

        public SpecialRegistrationInterface.SpecialRegistrationStatus getSpecRegStatus() {
            return this.iSpecRegStatus;
        }

        public void setSpecRegStatus(SpecialRegistrationInterface.SpecialRegistrationStatus status) {
            this.iSpecRegStatus = status;
        }

        public SpecialRegistrationInterface.SpecialRegistrationOperation getSpecRegOperation() {
            return this.iSpecRegOperation;
        }

        public void setSpecRegOperation(SpecialRegistrationInterface.SpecialRegistrationOperation operation) {
            this.iSpecRegOperation = operation;
        }

        public OnlineSectioningInterface.GradeMode getGradeMode() {
            return this.iGradeMode;
        }

        public void setGradeMode(OnlineSectioningInterface.GradeMode mode) {
            this.iGradeMode = mode;
        }
    }

    public static class CourseAssignment
    implements IsSerializable,
    Serializable,
    Comparable<CourseAssignment> {
        private static final long serialVersionUID = 1L;
        private Long iCourseId = null;
        private boolean iAssigned = true;
        private boolean iTeachingAssigment = false;
        private String iSubject;
        private String iCourseNbr;
        private String iTitle;
        private String iNote;
        private String iCreditText = null;
        private String iCreditAbbv = null;
        private boolean iHasUniqueName = true;
        private boolean iHasCrossList = false;
        private Integer iLimit = null;
        private Integer iProjected = null;
        private Integer iEnrollment = null;
        private Integer iLastLike = null;
        private Integer iRequested = null;
        private Integer iSnapShotLimit = null;
        private ArrayList<String> iOverlaps = null;
        private boolean iNotAvailable = false;
        private boolean iFull = false;
        private boolean iLocked = false;
        private String iInstead;
        private boolean iWaitListed = false;
        private String iEnrollmentMessage = null;
        private Date iRequestedDate = null;
        private Integer iSelection = null;
        private Float iOverMaxCredit;
        private ArrayList<ClassAssignment> iAssignments = new ArrayList();
        private Set<IdValue> iInstructionalMethods = null;
        private boolean iHasNoInstructionalMethod = false;

        public Long getCourseId() {
            return this.iCourseId;
        }

        public void setCourseId(Long courseId) {
            this.iCourseId = courseId;
        }

        public boolean isFreeTime() {
            return this.iCourseId == null;
        }

        public boolean isAssigned() {
            return this.iAssigned;
        }

        public void setAssigned(boolean assigned) {
            this.iAssigned = assigned;
        }

        public boolean isTeachingAssignment() {
            return this.iTeachingAssigment;
        }

        public void setTeachingAssignment(boolean ta) {
            this.iTeachingAssigment = ta;
        }

        public String getSubject() {
            return this.iSubject;
        }

        public void setSubject(String subject) {
            this.iSubject = subject;
        }

        public String getCourseNbr() {
            return this.iCourseNbr;
        }

        public void setCourseNbr(String courseNbr) {
            this.iCourseNbr = courseNbr;
        }

        public String getCourseNbr(boolean includeTitle) {
            return this.getCourseNbr() + (includeTitle & this.hasTitle() ? " - " + this.getTitle() : "");
        }

        public String getCourseName() {
            return this.isFreeTime() ? "Free Time" : this.getSubject() + " " + this.getCourseNbr();
        }

        public String getCourseNameWithTitle() {
            return this.isFreeTime() ? "Free Time" : (this.hasTitle() ? this.getSubject() + " " + this.getCourseNbr() + " - " + this.getTitle() : this.getSubject() + " " + this.getCourseNbr());
        }

        public boolean equalsIgnoreCase(String requestedCourse) {
            return this.getCourseName().equalsIgnoreCase(requestedCourse) || this.getCourseNameWithTitle().equalsIgnoreCase(requestedCourse);
        }

        public String getTitle() {
            return this.iTitle;
        }

        public void setTitle(String title) {
            this.iTitle = title;
        }

        public boolean hasTitle() {
            return this.iTitle != null && !this.iTitle.isEmpty();
        }

        public String getNote() {
            return this.iNote;
        }

        public void setNote(String note) {
            this.iNote = note;
        }

        public boolean hasNote() {
            return this.iNote != null && !this.iNote.isEmpty();
        }

        public boolean hasCredit() {
            return this.iCreditAbbv != null && !this.iCreditAbbv.isEmpty();
        }

        public String getCreditText() {
            return this.iCreditText;
        }

        public void setCreditText(String creditText) {
            this.iCreditText = creditText;
        }

        public String getCreditAbbv() {
            return this.iCreditAbbv;
        }

        public void setCreditAbbv(String creditAbbv) {
            this.iCreditAbbv = creditAbbv;
        }

        public String getCredit() {
            return this.hasCredit() ? this.getCreditAbbv() + "|" + this.getCreditText() : null;
        }

        public float guessCreditCount() {
            if (!this.hasCredit()) {
                return 0.0f;
            }
            MatchResult m = RegExp.compile((String)"\\d+\\.?\\d*").exec(this.getCreditAbbv());
            if (m != null) {
                return Float.parseFloat(m.getGroup(0));
            }
            return 0.0f;
        }

        public float[] guessCreditRange() {
            if (!this.hasCredit()) {
                return new float[]{0.0f, 0.0f};
            }
            MatchResult r = RegExp.compile((String)"(\\d+\\.?\\d*)-(\\d+\\.?\\d*)").exec(this.getCreditAbbv());
            if (r != null) {
                return new float[]{Float.parseFloat(r.getGroup(1)), Float.parseFloat(r.getGroup(2))};
            }
            float credit = this.guessCreditCount();
            return new float[]{credit, credit};
        }

        public boolean hasUniqueName() {
            return this.iHasUniqueName;
        }

        public void setHasUniqueName(boolean hasUniqueName) {
            this.iHasUniqueName = hasUniqueName;
        }

        public boolean hasCrossList() {
            return this.iHasCrossList;
        }

        public void setHasCrossList(boolean hasCrossList) {
            this.iHasCrossList = hasCrossList;
        }

        public void addOverlap(String overlap) {
            if (this.iOverlaps == null) {
                this.iOverlaps = new ArrayList();
            }
            if (!this.iOverlaps.contains(overlap)) {
                this.iOverlaps.add(overlap);
            }
        }

        public ArrayList<String> getOverlaps() {
            return this.iOverlaps;
        }

        public boolean isNotAvailable() {
            return this.iNotAvailable;
        }

        public void setNotAvailable(boolean notAvailable) {
            this.iNotAvailable = notAvailable;
        }

        public boolean isFull() {
            return this.iFull;
        }

        public void setFull(boolean full) {
            this.iFull = full;
        }

        public boolean isOverMaxCredit() {
            return this.iOverMaxCredit != null;
        }

        public Float getOverMaxCredit() {
            return this.iOverMaxCredit;
        }

        public void setOverMaxCredit(Float maxCredit) {
            this.iOverMaxCredit = maxCredit;
        }

        public boolean isLocked() {
            return this.iLocked;
        }

        public void setLocked(boolean locked) {
            this.iLocked = locked;
        }

        public void setInstead(String instead) {
            this.iInstead = instead;
        }

        public String getInstead() {
            return this.iInstead;
        }

        public ArrayList<ClassAssignment> getClassAssignments() {
            return this.iAssignments;
        }

        public ClassAssignment addClassAssignment() {
            ClassAssignment a = new ClassAssignment(this);
            this.iAssignments.add(a);
            return a;
        }

        public Integer getLimit() {
            return this.iLimit;
        }

        public void setLimit(Integer limit) {
            this.iLimit = limit;
        }

        public String getLimitString() {
            if (this.iLimit == null) {
                return "";
            }
            if (this.iLimit < 0) {
                return "&infin;";
            }
            return this.iLimit.toString();
        }

        public Integer getSnapShotLimit() {
            return this.iSnapShotLimit;
        }

        public void setSnapShotLimit(Integer limit) {
            this.iSnapShotLimit = limit;
        }

        public Integer getProjected() {
            return this.iProjected;
        }

        public void setProjected(Integer projected) {
            this.iProjected = projected;
        }

        public String getProjectedString() {
            if (this.iProjected == null || this.iProjected == 0) {
                return "";
            }
            if (this.iProjected < 0) {
                return "&infin;";
            }
            return this.iProjected.toString();
        }

        public Integer getLastLike() {
            return this.iLastLike;
        }

        public void setLastLike(Integer lastLike) {
            this.iLastLike = lastLike;
        }

        public String getLastLikeString() {
            if (this.iLastLike == null || this.iLastLike == 0) {
                return "";
            }
            if (this.iLastLike < 0) {
                return "&infin;";
            }
            return this.iLastLike.toString();
        }

        public Integer getEnrollment() {
            return this.iEnrollment;
        }

        public void setEnrollment(Integer enrollment) {
            this.iEnrollment = enrollment;
        }

        public String getEnrollmentString() {
            if (this.iEnrollment == null || this.iEnrollment == 0) {
                return "";
            }
            if (this.iEnrollment < 0) {
                return "&infin;";
            }
            return this.iEnrollment.toString();
        }

        public void setAvailability(int[] availability) {
            this.iRequested = null;
            if (availability == null) {
                this.iEnrollment = null;
                this.iLimit = null;
            } else {
                this.iEnrollment = availability[0];
                this.iLimit = availability[1];
                if (availability.length > 2) {
                    this.iRequested = availability[2];
                }
            }
        }

        public boolean isWaitListed() {
            return this.iWaitListed;
        }

        public void setWaitListed(boolean waitListed) {
            this.iWaitListed = waitListed;
        }

        public String getEnrollmentMessage() {
            return this.iEnrollmentMessage;
        }

        public boolean hasEnrollmentMessage() {
            return this.iEnrollmentMessage != null && !this.iEnrollmentMessage.isEmpty();
        }

        public void setEnrollmentMessage(String message) {
            this.iEnrollmentMessage = message;
        }

        public boolean hasInstructionalMethods() {
            return this.iInstructionalMethods != null && !this.iInstructionalMethods.isEmpty();
        }

        public Set<IdValue> getInstructionalMethods() {
            return this.iInstructionalMethods;
        }

        public void addInstructionalMethod(Long id, String value) {
            if (this.iInstructionalMethods == null) {
                this.iInstructionalMethods = new TreeSet<IdValue>();
            }
            this.iInstructionalMethods.add(new IdValue(id, value));
        }

        public boolean isHasNoInstructionalMethod() {
            return this.iHasNoInstructionalMethod;
        }

        public void setHasNoInstructionalMethod(boolean hasNoInstructionalMethod) {
            this.iHasNoInstructionalMethod = hasNoInstructionalMethod;
        }

        public boolean hasInstructionalMethodSelection() {
            if (this.hasInstructionalMethods()) {
                return this.getInstructionalMethods().size() + (this.isHasNoInstructionalMethod() ? 1 : 0) > 1;
            }
            return false;
        }

        public String toString() {
            return (this.isFreeTime() ? "Free Time" : this.getSubject() + " " + this.getCourseNbr()) + ": " + (this.isAssigned() ? this.getClassAssignments() : "NOT ASSIGNED");
        }

        public Date getRequestedDate() {
            return this.iRequestedDate;
        }

        public void setRequestedDate(Date ts) {
            this.iRequestedDate = ts;
        }

        public Integer getRequested() {
            return this.iRequested;
        }

        public void setRequested(Integer requested) {
            this.iRequested = requested;
        }

        public Integer getSelection() {
            return this.iSelection;
        }

        public void setSelection(Integer selection) {
            this.iSelection = selection;
        }

        public boolean hasSelection() {
            return this.iSelection != null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int compareTo(CourseAssignment c) {
            if (this.hasSelection()) {
                if (!c.hasSelection()) return -1;
                int cmp = this.getSelection().compareTo(c.getSelection());
                if (cmp == 0) return this.getCourseName().compareTo(c.getCourseName());
                return cmp;
            }
            if (!c.hasSelection()) return this.getCourseName().compareTo(c.getCourseName());
            return 1;
        }
    }
}

