/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.solver;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.TakesValue;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.Widget;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.aria.AriaButton;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.page.UniTimePageHeader;
import org.unitime.timetable.gwt.client.solver.DataTable;
import org.unitime.timetable.gwt.client.solver.SolverCookie;
import org.unitime.timetable.gwt.client.solver.SolverPage;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeConfirmationDialog;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.CourseTimetablingSolverInterface;
import org.unitime.timetable.gwt.shared.SolverInterface;
import org.unitime.timetable.gwt.shared.TableInterface;

public class ListSolutionsPage
extends SimpleForm {
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    protected static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private UniTimeHeaderPanel iTableHeader;
    private DataTable iTable;
    private CourseTimetablingSolverInterface.ListSolutionsResponse iResponse;
    private TextArea iCurrentSolutionNote;
    private ListBox iSolverConfig = null;
    private ListBox iSolverOwner = null;
    private ListBox iSolverHost = null;
    private int iSolutionLine;
    private int iSolutionButtonsLine;
    private int iSolutionsTableHeaderLine;
    private Map<Long, Integer> iSelectedSolutionLine = new HashMap<Long, Integer>();
    private Map<Long, Integer> iSelectedSolutionButtonsLine = new HashMap<Long, Integer>();

    public ListSolutionsPage() {
        this.addStyleName("unitime-ListSolutionsPage");
        this.iTableHeader = new UniTimeHeaderPanel(MESSAGES.sectSavedSolutions());
        this.addHeaderRow((Widget)this.iTableHeader);
        this.execute(this.iTableHeader, CourseTimetablingSolverInterface.SolutionOperation.INIT);
    }

    protected void execute(UniTimeHeaderPanel header, CourseTimetablingSolverInterface.SolutionOperation operation) {
        this.execute(header, operation, null, null);
    }

    protected void execute(UniTimeHeaderPanel header, CourseTimetablingSolverInterface.SolutionOperation operation, Long solutionId) {
        this.execute(header, operation, null, solutionId);
    }

    protected void execute(final UniTimeHeaderPanel header, final CourseTimetablingSolverInterface.SolutionOperation operation, HasText note, Long solutionId) {
        switch (operation) {
            case EXPORT: {
                ToolBox.open(GWT.getHostPageBaseURL() + "export?output=solution.csv&type=course" + (solutionId == null ? "" : "&solution=" + solutionId));
                return;
            }
        }
        final CourseTimetablingSolverInterface.ListSolutionsRequest request = new CourseTimetablingSolverInterface.ListSolutionsRequest(operation);
        String confirmation = null;
        switch (operation) {
            case UNLOAD: {
                confirmation = MESSAGES.confirmSolverUnload();
                break;
            }
            case SAVE: {
                confirmation = MESSAGES.confirmSolverSave();
                if (this.iCurrentSolutionNote == null) break;
                request.setNote(this.iCurrentSolutionNote.getText());
                break;
            }
            case SAVE_AS_NEW: {
                confirmation = MESSAGES.confirmSolverSaveAsNew();
                if (this.iCurrentSolutionNote == null) break;
                request.setNote(this.iCurrentSolutionNote.getText());
                break;
            }
            case SAVE_COMMIT: {
                confirmation = MESSAGES.confirmSolverSaveCommit();
                if (this.iCurrentSolutionNote == null) break;
                request.setNote(this.iCurrentSolutionNote.getText());
                break;
            }
            case SAVE_AS_NEW_COMMIT: {
                confirmation = MESSAGES.confirmSolverSaveAsNewCommit();
                if (this.iCurrentSolutionNote == null) break;
                request.setNote(this.iCurrentSolutionNote.getText());
                break;
            }
            case UNCOMMIT: {
                request.setNote(note.getText());
                request.addSolutionId(solutionId);
                confirmation = MESSAGES.confirmSolverUncommit();
                break;
            }
            case COMMIT: {
                request.setNote(note.getText());
                request.addSolutionId(solutionId);
                confirmation = MESSAGES.confirmSolverCommit();
                break;
            }
            case DELETE: {
                request.addSolutionId(solutionId);
                confirmation = MESSAGES.confirmSolverDelete();
                break;
            }
            case RELOAD: {
                if (this.iCurrentSolutionNote == null) break;
                request.setNote(this.iCurrentSolutionNote.getText());
                break;
            }
            case SELECT: 
            case DESELECT: {
                request.addSolutionId(solutionId);
                break;
            }
            case UPDATE_NOTE: {
                request.setNote(note.getText());
                request.addSolutionId(solutionId);
                break;
            }
            case LOAD: {
                request.setConfigurationId(Long.valueOf(this.iSolverConfig.getSelectedValue()));
                request.setHost(this.iSolverHost == null ? null : this.iSolverHost.getSelectedValue());
                break;
            }
            case LOAD_EMPTY: {
                request.setConfigurationId(Long.valueOf(this.iSolverConfig.getSelectedValue()));
                request.setHost(this.iSolverHost == null ? null : this.iSolverHost.getSelectedValue());
                request.setOwnerId(Long.valueOf(this.iSolverOwner.getSelectedValue()));
            }
        }
        Command command = new Command(){

            public void execute() {
                if (operation == CourseTimetablingSolverInterface.SolutionOperation.INIT || operation == CourseTimetablingSolverInterface.SolutionOperation.CHECK) {
                    header.showLoading();
                } else {
                    LoadingWidget.showLoading(MESSAGES.waitSolverExecution());
                }
                RPC.execute(request, new AsyncCallback<CourseTimetablingSolverInterface.ListSolutionsResponse>(){

                    public void onFailure(Throwable caught) {
                        LoadingWidget.hideLoading();
                        header.setErrorMessage(caught.getMessage());
                        UniTimeNotifications.error(caught.getMessage(), caught);
                        ToolBox.checkAccess(caught);
                    }

                    public void onSuccess(CourseTimetablingSolverInterface.ListSolutionsResponse response) {
                        LoadingWidget.hideLoading();
                        header.clearMessage();
                        ListSolutionsPage.this.populate(request, response);
                        UniTimePageHeader.getInstance().reloadSolverInfo();
                    }
                });
            }
        };
        if (confirmation == null) {
            command.execute();
        } else {
            UniTimeConfirmationDialog.confirm(confirmation, command);
        }
    }

    protected ClickHandler createClickHandler(UniTimeHeaderPanel header, CourseTimetablingSolverInterface.SolutionOperation operation) {
        return this.createClickHandler(header, operation, null, null);
    }

    protected ClickHandler createClickHandler(UniTimeHeaderPanel header, CourseTimetablingSolverInterface.SolutionOperation operation, Long solutionId) {
        return this.createClickHandler(header, operation, null, solutionId);
    }

    protected ClickHandler createClickHandler(final UniTimeHeaderPanel header, final CourseTimetablingSolverInterface.SolutionOperation operation, final HasText parameter, final Long solutionId) {
        return new ClickHandler(){

            public void onClick(ClickEvent event) {
                ListSolutionsPage.this.execute(header, operation, parameter, solutionId);
            }
        };
    }

    protected void populate(CourseTimetablingSolverInterface.ListSolutionsRequest request, CourseTimetablingSolverInterface.ListSolutionsResponse response) {
        Integer row;
        this.clear();
        this.iResponse = response;
        RootPanel cpm = RootPanel.get((String)"UniTimeGWT:CustomPageMessages");
        if (cpm != null) {
            cpm.clear();
            if (response.hasPageMessages()) {
                for (final SolverInterface.PageMessage pageMessage : response.getPageMessages()) {
                    P p = new P(pageMessage.getType() == SolverInterface.PageMessageType.ERROR ? "unitime-PageError" : (pageMessage.getType() == SolverInterface.PageMessageType.WARNING ? "unitime-PageWarn" : "unitime-PageMessage"));
                    p.setHTML(pageMessage.getMessage());
                    if (pageMessage.hasUrl()) {
                        p.addStyleName("unitime-ClickablePageMessage");
                        p.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent event) {
                                if (pageMessage.hasUrl()) {
                                    ToolBox.open(GWT.getHostPageBaseURL() + pageMessage.getUrl());
                                }
                            }
                        });
                    }
                    cpm.add((Widget)p);
                }
            }
        }
        this.iSolutionLine = -1;
        this.iSolutionButtonsLine = -1;
        if (response.hasCurrentSolution()) {
            SolverInterface.SolutionInfo solutionInfo;
            UniTimeHeaderPanel header = new UniTimeHeaderPanel(MESSAGES.sectListSolutionsCurrentSolution());
            this.iSolutionLine = this.addHeaderRow((Widget)header);
            if (response.getSolverStatus() != null) {
                SolverPage.SolverStatus solverStatus = new SolverPage.SolverStatus();
                solverStatus.setStatus(response.getSolverStatus());
                this.addRow(MESSAGES.propSolverStatus(), (Widget)solverStatus);
            }
            if (response.getSolverProgress() != null) {
                this.addRow(MESSAGES.propSolverProgress(), (Widget)new Label(response.getSolverProgress()));
            }
            if ((solutionInfo = response.getCurrentSolution()).getCreated() != null) {
                this.addRow((Widget)new HTML(MESSAGES.propSolutionCreated()), (Widget)new HTML(solutionInfo.getCreated()));
            }
            if (solutionInfo.getOwner() != null) {
                this.addRow((Widget)new HTML(MESSAGES.propSolutionOwner()), (Widget)new HTML(solutionInfo.getOwner()));
            }
            if (solutionInfo.getCommitted() != null) {
                this.addRow((Widget)new HTML(MESSAGES.propSolutionCommitted()), (Widget)new HTML(solutionInfo.getCommitted()));
            }
            if (response.canExecute(-1L, CourseTimetablingSolverInterface.SolutionOperation.UPDATE_NOTE)) {
                this.iCurrentSolutionNote = new TextArea();
                this.iCurrentSolutionNote.setStyleName("unitime-TextArea");
                this.iCurrentSolutionNote.setVisibleLines(5);
                this.iCurrentSolutionNote.setCharacterWidth(80);
                this.iCurrentSolutionNote.setText(solutionInfo.getNote());
                this.addRow((Widget)new HTML(MESSAGES.propSolutionNote()), (Widget)this.iCurrentSolutionNote);
            } else if (!solutionInfo.getNote().isEmpty()) {
                HTML html = new HTML(solutionInfo.getNote());
                html.addStyleName("note");
                this.addRow((Widget)new HTML(MESSAGES.propSolutionNote()), (Widget)html);
            }
            for (SolverInterface.InfoPair pair : solutionInfo.getPairs()) {
                this.addRow((Widget)new HTML(pair.getName()), (Widget)new HTML(pair.getValue()));
            }
            if (response.hasLog()) {
                this.addRow((Widget)new HTML(MESSAGES.propSolutionLog()), (Widget)new ProgressLog(response.getLog()));
            }
            if (response.canExecute(-1L, CourseTimetablingSolverInterface.SolutionOperation.UNLOAD) || response.canExecute(-1L, CourseTimetablingSolverInterface.SolutionOperation.CHECK)) {
                UniTimeHeaderPanel buttons = header.clonePanel(null);
                if (response.canExecute(-1L, CourseTimetablingSolverInterface.SolutionOperation.SAVE)) {
                    buttons.addButton("save", MESSAGES.opSolverSave(), this.createClickHandler(header, CourseTimetablingSolverInterface.SolutionOperation.SAVE));
                }
                if (response.canExecute(-1L, CourseTimetablingSolverInterface.SolutionOperation.SAVE_AS_NEW)) {
                    buttons.addButton("save new", MESSAGES.opSolverSaveAsNew(), this.createClickHandler(header, CourseTimetablingSolverInterface.SolutionOperation.SAVE_AS_NEW));
                }
                if (response.canExecute(-1L, CourseTimetablingSolverInterface.SolutionOperation.SAVE_COMMIT)) {
                    buttons.addButton("save commit", MESSAGES.opSolverSaveCommit(), this.createClickHandler(header, CourseTimetablingSolverInterface.SolutionOperation.SAVE_COMMIT));
                }
                if (response.canExecute(-1L, CourseTimetablingSolverInterface.SolutionOperation.SAVE_AS_NEW_COMMIT)) {
                    buttons.addButton("save new commit", MESSAGES.opSolverSaveAsNewCommit(), this.createClickHandler(header, CourseTimetablingSolverInterface.SolutionOperation.SAVE_AS_NEW_COMMIT));
                }
                if (response.canExecute(-1L, CourseTimetablingSolverInterface.SolutionOperation.RELOAD)) {
                    buttons.addButton("reload", MESSAGES.opSolverReload(), this.createClickHandler(header, CourseTimetablingSolverInterface.SolutionOperation.RELOAD));
                }
                if (response.canExecute(-1L, CourseTimetablingSolverInterface.SolutionOperation.UNLOAD)) {
                    buttons.addButton("unload", MESSAGES.opSolverUnload(), this.createClickHandler(header, CourseTimetablingSolverInterface.SolutionOperation.UNLOAD));
                }
                if (response.canExecute(-1L, CourseTimetablingSolverInterface.SolutionOperation.CHECK)) {
                    buttons.addButton("refresh", MESSAGES.opSolverRefresh(), this.createClickHandler(header, CourseTimetablingSolverInterface.SolutionOperation.CHECK));
                }
                this.iSolutionButtonsLine = this.addBottomRow((Widget)buttons);
                this.getFlexCellFormatter().removeStyleName(this.iSolutionButtonsLine, 0, "unitime-TopLine");
            }
        }
        if (response.hasConfigurations()) {
            this.iSolverConfig = new ListBox();
            for (SolverInterface.SolverConfiguration solverConfiguration : response.getConfigurations()) {
                this.iSolverConfig.addItem(solverConfiguration.getName(), solverConfiguration.getId().toString());
                if (!solverConfiguration.getId().equals(response.getConfigurationId())) continue;
                this.iSolverConfig.setSelectedIndex(this.iSolverConfig.getItemCount() - 1);
            }
        } else {
            this.iSolverConfig = null;
        }
        if (response.hasHosts()) {
            this.iSolverHost = new ListBox();
            for (String string : response.getHosts()) {
                this.iSolverHost.addItem(string);
                if (!string.equals(response.getHost())) continue;
                this.iSolverHost.setSelectedIndex(this.iSolverHost.getItemCount() - 1);
            }
        } else {
            this.iSolverHost = null;
        }
        this.iSelectedSolutionLine.clear();
        this.iSelectedSolutionButtonsLine.clear();
        boolean load = false;
        if (response.hasSelectedSolutions()) {
            load = true;
            for (SolverInterface.SolutionInfo selected : response.getSelectedSolutions()) {
                UniTimeHeaderPanel header = new UniTimeHeaderPanel(MESSAGES.sectSolverSelectedSolution(selected.getName()));
                this.iSelectedSolutionLine.put(selected.getId(), this.addHeaderRow((Widget)header));
                if (selected.getCreated() != null) {
                    this.addRow((Widget)new HTML(MESSAGES.propSolutionCreated()), (Widget)new HTML(selected.getCreated()));
                }
                if (selected.getOwner() != null) {
                    this.addRow((Widget)new HTML(MESSAGES.propSolutionOwner()), (Widget)new HTML(selected.getOwner()));
                }
                if (selected.getCommitted() != null) {
                    this.addRow((Widget)new HTML(MESSAGES.propSolutionCommitted()), (Widget)new HTML(selected.getCommitted()));
                }
                TextArea note = null;
                if (response.canExecute(selected.getId(), CourseTimetablingSolverInterface.SolutionOperation.UPDATE_NOTE)) {
                    note = new TextArea();
                    note.setStyleName("unitime-TextArea");
                    note.setVisibleLines(5);
                    note.setCharacterWidth(80);
                    note.setText(selected.getNote());
                    this.addRow((Widget)new HTML(MESSAGES.propSolutionNote()), (Widget)note);
                } else if (!selected.getNote().isEmpty()) {
                    HTML html = new HTML(selected.getNote());
                    html.addStyleName("note");
                    this.addRow((Widget)new HTML(MESSAGES.propSolutionNote()), (Widget)html);
                }
                for (SolverInterface.InfoPair pair : selected.getPairs()) {
                    this.addRow((Widget)new HTML(pair.getName()), (Widget)new HTML(pair.getValue()));
                }
                if (selected.hasLog()) {
                    this.addRow((Widget)new HTML(MESSAGES.propSolutionLog()), (Widget)new ProgressLog(selected.getLog()));
                }
                UniTimeHeaderPanel buttons = header.clonePanel(null);
                buttons.addButton("deselect", MESSAGES.opSolutionDeselect(), this.createClickHandler(header, CourseTimetablingSolverInterface.SolutionOperation.DESELECT, selected.getId()));
                if (response.canExecute(selected.getId(), CourseTimetablingSolverInterface.SolutionOperation.UPDATE_NOTE)) {
                    buttons.addButton("update note", MESSAGES.opSolutionUpdateNote(), this.createClickHandler(header, CourseTimetablingSolverInterface.SolutionOperation.UPDATE_NOTE, (HasText)note, selected.getId()));
                }
                if (response.canExecute(selected.getId(), CourseTimetablingSolverInterface.SolutionOperation.COMMIT)) {
                    buttons.addButton("commit", MESSAGES.opSolutionCommit(), this.createClickHandler(header, CourseTimetablingSolverInterface.SolutionOperation.COMMIT, (HasText)note, selected.getId()));
                }
                if (response.canExecute(selected.getId(), CourseTimetablingSolverInterface.SolutionOperation.UNCOMMIT)) {
                    buttons.addButton("uncommit", MESSAGES.opSolutionUncommit(), this.createClickHandler(header, CourseTimetablingSolverInterface.SolutionOperation.UNCOMMIT, (HasText)note, selected.getId()));
                }
                if (response.canExecute(selected.getId(), CourseTimetablingSolverInterface.SolutionOperation.EXPORT)) {
                    buttons.addButton("export", MESSAGES.opSolutionExport(), this.createClickHandler(header, CourseTimetablingSolverInterface.SolutionOperation.EXPORT, selected.getId()));
                }
                if (response.canExecute(selected.getId(), CourseTimetablingSolverInterface.SolutionOperation.DELETE)) {
                    buttons.addButton("delete", MESSAGES.opSolutionDelete(), this.createClickHandler(header, CourseTimetablingSolverInterface.SolutionOperation.DELETE, selected.getId()));
                }
                if (!response.canExecute(selected.getId(), CourseTimetablingSolverInterface.SolutionOperation.LOAD)) {
                    load = false;
                }
                int row2 = this.addBottomRow((Widget)buttons);
                this.getFlexCellFormatter().removeStyleName(row2, 0, "unitime-TopLine");
                this.iSelectedSolutionButtonsLine.put(selected.getId(), row2);
            }
            if (load && this.iSolverConfig != null) {
                P p = new P("load-panel");
                P configLabel = new P("config-label");
                configLabel.setText(MESSAGES.propSolverConfig());
                p.add((Widget)configLabel);
                p.add((Widget)this.iSolverConfig);
                if (this.iSolverHost != null) {
                    P hostLabel = new P("host-label");
                    hostLabel.setText(MESSAGES.propSolverHost());
                    p.add((Widget)hostLabel);
                    p.add((Widget)this.iSolverHost);
                }
                AriaButton button = new AriaButton(MESSAGES.opSolverLoad());
                button.addClickHandler(this.createClickHandler(this.iTableHeader, CourseTimetablingSolverInterface.SolutionOperation.LOAD));
                p.add((Widget)button);
                this.addRow(MESSAGES.propLoadInteractiveSolver(), (Widget)p);
            }
        }
        this.iTableHeader.clearMessage();
        this.iSolutionsTableHeaderLine = this.addHeaderRow((Widget)this.iTableHeader);
        if (response.hasMessage()) {
            this.iTableHeader.setMessage(response.getMessage());
        }
        if (response.getRows().isEmpty()) {
            if (!response.hasMessage()) {
                this.iTableHeader.setMessage(MESSAGES.errorListSolutionsNoDataReturned());
            }
        } else {
            if (this.iTable == null) {
                this.iTable = new DataTable(response);
                this.iTable.addValueChangeHandler(new ValueChangeHandler<Integer>(){

                    public void onValueChange(ValueChangeEvent<Integer> event) {
                        SolverCookie.getInstance().setListSolutionsSort(event.getValue() == null ? 0 : (Integer)event.getValue());
                    }
                });
                this.iTable.addMouseClickListener(new UniTimeTable.MouseClickListener<TableInterface.TableRowInterface>(){

                    @Override
                    public void onMouseClick(UniTimeTable.TableEvent<TableInterface.TableRowInterface> event) {
                        if (event.getData() != null) {
                            boolean selected = false;
                            if (ListSolutionsPage.this.iResponse.hasSelectedSolutions()) {
                                for (SolverInterface.SolutionInfo solution : ListSolutionsPage.this.iResponse.getSelectedSolutions()) {
                                    if (!event.getData().getId().equals(solution.getId())) continue;
                                    selected = true;
                                }
                            }
                            ListSolutionsPage.this.execute(ListSolutionsPage.this.iTableHeader, selected ? CourseTimetablingSolverInterface.SolutionOperation.DESELECT : CourseTimetablingSolverInterface.SolutionOperation.SELECT, event.getData().getId());
                        }
                    }
                });
            } else {
                this.iTable.populate(response);
            }
            this.iTable.setValue(SolverCookie.getInstance().getListSolutionsSort());
            this.addRow((Widget)this.iTable);
        }
        if (!load && this.iSolverConfig != null && response.canExecute(-1L, CourseTimetablingSolverInterface.SolutionOperation.LOAD_EMPTY) && response.hasSolverOwners()) {
            P p = new P("load-panel");
            this.iSolverOwner = new ListBox();
            for (SolverInterface.SolverOwner owner : response.getSolverOwners()) {
                this.iSolverOwner.addItem(owner.getName(), owner.getId().toString());
            }
            P ownerLabel = new P("owner-label");
            ownerLabel.setText(MESSAGES.propSolverOwner());
            p.add((Widget)ownerLabel);
            p.add((Widget)this.iSolverOwner);
            P configLabel = new P("config-label");
            configLabel.setText(MESSAGES.propSolverConfig());
            p.add((Widget)configLabel);
            p.add((Widget)this.iSolverConfig);
            if (this.iSolverHost != null) {
                P hostLabel = new P("host-label");
                hostLabel.setText(MESSAGES.propSolverHost());
                p.add((Widget)hostLabel);
                p.add((Widget)this.iSolverHost);
            }
            AriaButton button = new AriaButton(MESSAGES.opSolverLoadEmptySolution());
            button.addClickHandler(this.createClickHandler(this.iTableHeader, CourseTimetablingSolverInterface.SolutionOperation.LOAD_EMPTY));
            p.add((Widget)button);
            this.addRow(MESSAGES.propLoadInteractiveSolver(), (Widget)p);
        }
        if (response.hasErrors()) {
            UniTimeConfirmationDialog.alert(response.getErrorMessage("\n"));
            if (request.hasSolutionIds()) {
                for (Long id : request.getSolutionIds()) {
                    row = this.iSelectedSolutionButtonsLine.get(id);
                    if (row == null) continue;
                    ((UniTimeHeaderPanel)this.getWidget(row, 0)).setErrorMessage(response.getErrorMessage("<br>"));
                }
            }
        }
        block0 : switch (response.getOperation()) {
            case LOAD: 
            case LOAD_EMPTY: {
                if (this.iSolutionLine < 0) break;
                this.getRowFormatter().getElement(this.iSolutionLine).scrollIntoView();
                break;
            }
            case SELECT: {
                if (!request.hasSolutionIds()) break;
                for (Long id : request.getSolutionIds()) {
                    row = this.iSelectedSolutionLine.get(id);
                    if (row == null) continue;
                    this.getRowFormatter().getElement(row.intValue()).scrollIntoView();
                    break block0;
                }
                break;
            }
            case UNLOAD: 
            case DESELECT: {
                if (this.iSolutionsTableHeaderLine < 0) break;
                this.getRowFormatter().getElement(this.iSolutionsTableHeaderLine).scrollIntoView();
            }
        }
    }

    public static class ProgressLog
    extends HTML
    implements TakesValue<List<SolverInterface.ProgressMessage>> {
        private List<SolverInterface.ProgressMessage> iLog;

        public ProgressLog(List<SolverInterface.ProgressMessage> log) {
            this.setValue(log);
        }

        public static String htmlTraceLog(SolverInterface.ProgressMessage m) {
            String[] trace = m.getStackTrace();
            if (trace == null || trace.length == 0) {
                return "";
            }
            StringBuffer ret = new StringBuffer("<BR>" + trace[0]);
            for (int i = 1; i < trace.length; ++i) {
                ret.append("<BR>&nbsp;&nbsp;&nbsp;&nbsp;at " + trace[i]);
            }
            return ret.toString();
        }

        public static String toString(SolverInterface.ProgressMessage m) {
            switch (m.getLevel()) {
                case WARN: {
                    return "<span style='color:orange;font-weight:bold;'>" + CONSTANTS.progressLogLevel()[m.getLevel().ordinal()].toUpperCase() + ":</span> " + m.getMessage() + ProgressLog.htmlTraceLog(m);
                }
                case ERROR: {
                    return "<span style='color:red;font-weight:bold;'>" + CONSTANTS.progressLogLevel()[m.getLevel().ordinal()].toUpperCase() + ":</span> " + m.getMessage() + ProgressLog.htmlTraceLog(m);
                }
                case FATAL: {
                    return "<span style='color:red;font-weight:bold;'>&gt;&gt;&gt;" + CONSTANTS.progressLogLevel()[m.getLevel().ordinal()].toUpperCase() + ": " + m.getMessage() + " &lt;&lt;&lt;</span>" + ProgressLog.htmlTraceLog(m);
                }
            }
            return null;
        }

        public void setValue(List<SolverInterface.ProgressMessage> value) {
            this.iLog = value;
            StringBuffer s = new StringBuffer();
            if (this.iLog != null) {
                for (SolverInterface.ProgressMessage m : this.iLog) {
                    String html = ProgressLog.toString(m);
                    if (html == null || html.isEmpty()) continue;
                    if (s.length() > 0) {
                        s.append("<br>");
                    }
                    s.append(html);
                }
            }
            this.setHTML(s.toString());
        }

        public List<SolverInterface.ProgressMessage> getValue() {
            return this.iLog;
        }

        public Date getLastDate() {
            if (this.iLog == null || this.iLog.isEmpty()) {
                return null;
            }
            return this.iLog.get(this.iLog.size() - 1).getDate();
        }

        public void append(List<SolverInterface.ProgressMessage> log) {
            StringBuffer s = new StringBuffer(this.getHTML());
            for (SolverInterface.ProgressMessage m : log) {
                this.iLog.add(m);
                if (s.length() > 0) {
                    s.append("<br>");
                }
                s.append(ProgressLog.toString(m));
            }
            this.setHTML(s.toString());
        }
    }
}

