/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.sectioning;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.aria.HasAriaLabel;
import org.unitime.timetable.gwt.client.sectioning.ScheduleStatus;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeDialogBox;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.WebTable;
import org.unitime.timetable.gwt.resources.GwtAriaMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningResources;
import org.unitime.timetable.gwt.services.SectioningService;
import org.unitime.timetable.gwt.services.SectioningServiceAsync;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.gwt.shared.SpecialRegistrationInterface;

public class ChangeGradeModesDialog
extends UniTimeDialogBox {
    protected static StudentSectioningMessages MESSAGES = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    protected static StudentSectioningConstants CONSTANTS = (StudentSectioningConstants)GWT.create(StudentSectioningConstants.class);
    protected static final StudentSectioningResources RESOURCES = (StudentSectioningResources)GWT.create(StudentSectioningResources.class);
    private final SectioningServiceAsync iSectioningService = (SectioningServiceAsync)GWT.create(SectioningService.class);
    protected static final GwtAriaMessages ARIA = (GwtAriaMessages)GWT.create(GwtAriaMessages.class);
    private SimpleForm iForm;
    private WebTable iTable;
    private UniTimeHeaderPanel iButtons;
    private List<GradeModeChange> iChanges = new ArrayList<GradeModeChange>();
    private ScheduleStatus iStatus;
    private ArrayList<ClassAssignmentInterface.ClassAssignment> iEnrollment;
    private List<SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse> iApprovals;
    private P iApproval = null;
    private TextArea iNote = null;
    private List<CheckBox> iDisclaimers = new ArrayList<CheckBox>();

    public ChangeGradeModesDialog(ScheduleStatus status) {
        super(true, true);
        this.addStyleName("unitime-ChangeGradeModesDialog");
        this.setText(MESSAGES.dialogChangeGradeMode());
        this.iStatus = status;
        this.iForm = new SimpleForm();
        this.iTable = new WebTable();
        this.iTable.setHeader(new WebTable.Row(new WebTable.Cell(MESSAGES.colSubject()), new WebTable.Cell(MESSAGES.colCourse()), new WebTable.Cell(MESSAGES.colSubpart()), new WebTable.Cell(MESSAGES.colClass()), new WebTable.Cell(MESSAGES.colDays()), new WebTable.Cell(MESSAGES.colStart()), new WebTable.Cell(MESSAGES.colEnd()), new WebTable.Cell(MESSAGES.colDate()), new WebTable.Cell(MESSAGES.colRoom()), new WebTable.Cell(MESSAGES.colCredit()), new WebTable.Cell(MESSAGES.colTitleGradeMode()), new WebTable.Cell(MESSAGES.colTitlePendingGradeMode())));
        this.iTable.setEmptyMessage(MESSAGES.emptyGradeChanges());
        ScrollPanel scroll = new ScrollPanel((Widget)this.iTable);
        scroll.setStyleName("unitime-ScrollPanel");
        scroll.addStyleName("class-table");
        this.iForm.addRow((Widget)scroll);
        this.iButtons = new UniTimeHeaderPanel();
        this.iButtons.addButton("submit", MESSAGES.buttonSubmitGradeModeChanges(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                ChangeGradeModesDialog.this.hide();
                ChangeGradeModesDialog.this.onSubmit();
            }
        });
        this.iButtons.addButton("cancel", MESSAGES.buttonCloseGradeModeChanges(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                ChangeGradeModesDialog.this.hide();
            }
        });
        this.iButtons.setEnabled("submit", false);
        this.iApproval = new P("approval-panel");
        this.iForm.addRow((Widget)this.iApproval);
        this.iForm.addBottomRow((Widget)this.iButtons);
        this.iNote = new TextArea();
        this.iNote.setStyleName("unitime-TextArea");
        this.iNote.addStyleName("request-note");
        this.iNote.setVisibleLines(5);
        this.iNote.setCharacterWidth(80);
        this.setWidget((Widget)this.iForm);
    }

    protected OnlineSectioningInterface.GradeMode getPendingGradeMode(Long courseId) {
        if (this.iApprovals == null) {
            return null;
        }
        for (SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse approval : this.iApprovals) {
            if (approval.getStatus() != SpecialRegistrationInterface.SpecialRegistrationStatus.Pending || !approval.hasChanges()) continue;
            for (ClassAssignmentInterface.ClassAssignment clazz : approval.getChanges()) {
                if (clazz.getGradeMode() == null || !courseId.equals(clazz.getCourseId())) continue;
                return clazz.getGradeMode();
            }
        }
        return null;
    }

    public void changeGradeModes(Long sessionId, Long studentId, ArrayList<ClassAssignmentInterface.ClassAssignment> enrollment, List<SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse> approvals) {
        LoadingWidget.getInstance().show(MESSAGES.waitRetrieveGradeModes());
        this.iChanges.clear();
        this.iNote.setValue((Object)"");
        this.iApproval.clear();
        this.iEnrollment = enrollment;
        this.iApprovals = approvals;
        this.iSectioningService.retrieveGradeModes(new SpecialRegistrationInterface.RetrieveAvailableGradeModesRequest(sessionId, studentId), new AsyncCallback<SpecialRegistrationInterface.RetrieveAvailableGradeModesResponse>(){

            public void onFailure(Throwable caught) {
                ChangeGradeModesDialog.this.iStatus.error(MESSAGES.exceptionRetrieveGradeModes(caught.getMessage()), caught);
                LoadingWidget.getInstance().hide();
            }

            public void onSuccess(SpecialRegistrationInterface.RetrieveAvailableGradeModesResponse result) {
                ArrayList<WebTable.Row> rows = new ArrayList<WebTable.Row>();
                ChangeGradeModesDialog.this.iTable.clearData(true);
                Long lastCourseId = null;
                GradeModeChange change = null;
                boolean hasPendingGradeMode = false;
                for (ClassAssignmentInterface.ClassAssignment clazz : ChangeGradeModesDialog.this.iEnrollment) {
                    boolean firstClazz;
                    SpecialRegistrationInterface.SpecialRegistrationGradeModeChanges gradeMode;
                    if (clazz == null || (gradeMode = result.get(clazz)) == null || clazz.getParentSection() != null && clazz.getParentSection().equals(clazz.getSection()) || clazz.isTeachingAssignment() || clazz.isDummy() || clazz.isFreeTime()) continue;
                    boolean bl = firstClazz = !clazz.getCourseId().equals(lastCourseId);
                    if (firstClazz) {
                        change = new GradeModeChange(clazz, gradeMode);
                        ChangeGradeModesDialog.this.iChanges.add(change);
                    } else {
                        change.addClassAssignment(clazz, gradeMode);
                    }
                    lastCourseId = clazz.getCourseId();
                    OnlineSectioningInterface.GradeMode pendingGradeMode = ChangeGradeModesDialog.this.getPendingGradeMode(clazz.getCourseId());
                    if (pendingGradeMode != null) {
                        hasPendingGradeMode = true;
                        if (pendingGradeMode.getLabel() == null) {
                            SpecialRegistrationInterface.SpecialRegistrationGradeMode m = gradeMode.getAvailableChange(pendingGradeMode.getCode());
                            if (m != null) {
                                pendingGradeMode.setLabel(m.getLabel());
                            } else {
                                pendingGradeMode.setLabel(pendingGradeMode.getCode());
                            }
                        }
                    }
                    String style = firstClazz && !rows.isEmpty() ? "top-border-dashed" : "";
                    WebTable.Row row = null;
                    if (clazz.isAssigned()) {
                        WebTable.Cell[] cellArray = new WebTable.Cell[12];
                        cellArray[0] = new WebTable.Cell(firstClazz ? clazz.getSubject() : "").aria(clazz.getSubject());
                        cellArray[1] = new WebTable.Cell(firstClazz ? (CONSTANTS.showCourseTitle() ? clazz.getCourseNameWithTitle() : clazz.getCourseName()) : "").aria(CONSTANTS.showCourseTitle() ? clazz.getCourseNameWithTitle() : clazz.getCourseName());
                        cellArray[2] = new WebTable.Cell(clazz.getSubpart());
                        cellArray[3] = new WebTable.Cell(clazz.getSection());
                        cellArray[4] = new WebTable.Cell(clazz.getDaysString(CONSTANTS.shortDays())).aria(clazz.getDaysString(CONSTANTS.longDays(), " "));
                        cellArray[5] = new WebTable.Cell(clazz.getStartString(CONSTANTS.useAmPm())).aria(clazz.getStartStringAria(CONSTANTS.useAmPm()));
                        cellArray[6] = new WebTable.Cell(clazz.getEndString(CONSTANTS.useAmPm())).aria(clazz.getEndStringAria(CONSTANTS.useAmPm()));
                        cellArray[7] = new WebTable.Cell(clazz.getDatePattern());
                        cellArray[8] = clazz.hasDistanceConflict() ? new WebTable.RoomCell(RESOURCES.distantConflict(), MESSAGES.backToBackDistance(clazz.getBackToBackRooms(), clazz.getBackToBackDistance()), clazz.getRooms(), ", ") : new WebTable.RoomCell((List<ClassAssignmentInterface.IdValue>)clazz.getRooms(), ", ");
                        cellArray[9] = new WebTable.AbbvTextCell(clazz.getCredit());
                        cellArray[10] = firstClazz ? change : new GradeModeLabel(change, gradeMode);
                        cellArray[11] = new WebTable.Cell(pendingGradeMode == null ? "" : pendingGradeMode.getLabel());
                        row = new WebTable.Row(cellArray);
                    } else {
                        WebTable.Cell[] cellArray = new WebTable.Cell[10];
                        cellArray[0] = new WebTable.Cell(firstClazz ? clazz.getSubject() : "").aria(clazz.getSubject());
                        cellArray[1] = new WebTable.Cell(firstClazz ? (CONSTANTS.showCourseTitle() ? clazz.getCourseNameWithTitle() : clazz.getCourseName()) : "").aria(CONSTANTS.showCourseTitle() ? clazz.getCourseNameWithTitle() : clazz.getCourseName());
                        cellArray[2] = new WebTable.Cell(clazz.getSubpart());
                        cellArray[3] = new WebTable.Cell(clazz.getSection());
                        cellArray[4] = new WebTable.Cell(MESSAGES.arrangeHours(), 3, null);
                        cellArray[5] = new WebTable.Cell(clazz.getDatePattern());
                        cellArray[6] = clazz.hasDistanceConflict() ? new WebTable.RoomCell(RESOURCES.distantConflict(), MESSAGES.backToBackDistance(clazz.getBackToBackRooms(), clazz.getBackToBackDistance()), clazz.getRooms(), ", ") : new WebTable.RoomCell((List<ClassAssignmentInterface.IdValue>)clazz.getRooms(), ", ");
                        cellArray[7] = new WebTable.AbbvTextCell(clazz.getCredit());
                        cellArray[8] = firstClazz ? change : new GradeModeLabel(change, gradeMode);
                        cellArray[9] = new WebTable.Cell(pendingGradeMode == null ? "" : pendingGradeMode.getLabel());
                        row = new WebTable.Row(cellArray);
                    }
                    for (WebTable.Cell cell : row.getCells()) {
                        cell.setStyleName(style);
                    }
                    rows.add(row);
                }
                WebTable.Row[] rowArray = new WebTable.Row[rows.size()];
                int idx = 0;
                for (WebTable.Row row : rows) {
                    rowArray[idx++] = row;
                }
                ChangeGradeModesDialog.this.iTable.setData(rowArray);
                ChangeGradeModesDialog.this.iTable.setColumnVisible(11, hasPendingGradeMode);
                LoadingWidget.getInstance().hide();
                if (rows.isEmpty()) {
                    ChangeGradeModesDialog.this.iStatus.info(MESSAGES.statusNoGradeModeChangesAvailable());
                } else {
                    ChangeGradeModesDialog.this.center();
                    if (!ChangeGradeModesDialog.this.iChanges.isEmpty()) {
                        ((Focusable)((GradeModeChange)ChangeGradeModesDialog.this.iChanges.get(0)).getWidget()).setFocus(true);
                    }
                }
            }
        });
    }

    protected void formChanged() {
        P m;
        this.iApproval.clear();
        P ctab = new P("course-table");
        boolean changes = false;
        boolean approvals = false;
        this.iDisclaimers.clear();
        TreeSet<String> disclaimers = new TreeSet<String>();
        for (GradeModeChange cell : this.iChanges) {
            SpecialRegistrationInterface.SpecialRegistrationGradeMode change = cell.getChange();
            if (change == null) continue;
            changes = true;
            boolean first = true;
            for (ClassAssignmentInterface.ClassAssignment ca : cell.getClassAssignments()) {
                SpecialRegistrationInterface.SpecialRegistrationGradeMode ch = cell.getChange(ca.getExternalId());
                if (ch == null || ch.getOriginalGradeMode() != null && ch.getOriginalGradeMode().equals(change.getCode())) continue;
                P cn = new P("course-name");
                if (first) {
                    cn.setText(ca.getCourseName());
                }
                P sn = new P("section-name");
                sn.setText(ca.getSection());
                P m2 = new P("approval-message");
                if (ch.hasApprovals()) {
                    m2.setText(MESSAGES.gradeModeApprovalNeeded(ch.getLabel(), ToolBox.toString(ch.getApprovals())));
                    approvals = true;
                } else {
                    m2.setText(MESSAGES.gradeModeNoApprovalNeeded(ch.getLabel()));
                }
                if (ch.hasDisclaimer()) {
                    disclaimers.add(ch.getDisclaimer());
                }
                P crow = new P("course-row");
                if (first) {
                    crow.addStyleName("first-course-line");
                }
                crow.add((Widget)cn);
                crow.add((Widget)sn);
                crow.add((Widget)m2);
                ctab.add((Widget)crow);
                first = false;
            }
        }
        if (changes) {
            m = new P("message");
            m.setHTML(MESSAGES.gradeModeListChanges());
            this.iApproval.add((Widget)m);
            this.iApproval.add((Widget)ctab);
            if (approvals) {
                m = new P("message");
                m.setHTML(MESSAGES.gradeModeChangesNote());
                this.iApproval.add((Widget)m);
                this.iApproval.add((Widget)this.iNote);
            }
        }
        if (!disclaimers.isEmpty()) {
            m = new P("message");
            m.setHTML(MESSAGES.gradeModeDisclaimers());
            this.iApproval.add((Widget)m);
            for (String d : disclaimers) {
                CheckBox ch = new CheckBox(d, true);
                ch.addStyleName("disclaimer-message");
                ch.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                    public void onValueChange(ValueChangeEvent<Boolean> event) {
                        ChangeGradeModesDialog.this.submitUpdateEnabled();
                    }
                });
                this.iDisclaimers.add(ch);
                this.iApproval.add((Widget)ch);
            }
        }
        if (changes) {
            m = new P("message");
            m.setHTML(MESSAGES.gradeModeChangeOptions());
            this.iApproval.add((Widget)m);
        }
        this.iButtons.setEnabled("submit", changes && disclaimers.isEmpty(), changes);
        this.center();
    }

    protected void submitUpdateEnabled() {
        for (CheckBox ch : this.iDisclaimers) {
            if (ch.getValue().booleanValue()) continue;
            this.iButtons.setEnabled("submit", false, true);
            return;
        }
        this.iButtons.setEnabled("submit", true, true);
    }

    protected void onChange(SpecialRegistrationInterface.ChangeGradeModesResponse response) {
    }

    protected void onSubmit() {
        SpecialRegistrationInterface.ChangeGradeModesRequest request = new SpecialRegistrationInterface.ChangeGradeModesRequest();
        request.setNote(this.iNote.getValue());
        for (GradeModeChange cell : this.iChanges) {
            SpecialRegistrationInterface.SpecialRegistrationGradeMode change = cell.getChange();
            if (change == null) continue;
            SpecialRegistrationInterface.SpecialRegistrationGradeModeChange ch = new SpecialRegistrationInterface.SpecialRegistrationGradeModeChange();
            ch.setOriginalGradeMode(cell.getGradeModes().get(0).getCurrentGradeMode() == null ? null : cell.getGradeModes().get(0).getCurrentGradeMode().getCode());
            ch.setSelectedGradeMode(change.getCode());
            ch.setSelectedGradeModeDescription(change.getLabel());
            ch.setSubject(cell.getClassAssignments().get(0).getSubject());
            ch.setCourse(cell.getClassAssignments().get(0).getCourseNbr());
            ch.setCredit(cell.getClassAssignments().get(0).getCredit());
            for (ClassAssignmentInterface.ClassAssignment ca : cell.getClassAssignments()) {
                SpecialRegistrationInterface.SpecialRegistrationGradeMode x = cell.getChange(ca.getExternalId());
                if (x == null || x.getOriginalGradeMode() != null && x.getOriginalGradeMode().equals(change.getCode())) continue;
                if (x.hasApprovals()) {
                    for (String app : x.getApprovals()) {
                        ch.addApproval(app);
                    }
                }
                ch.addCrn(ca.getExternalId());
            }
            request.addChange(ch);
        }
        if (request.hasGradeModeChanges()) {
            LoadingWidget.getInstance().show(MESSAGES.waitChangeGradeModes());
            this.iSectioningService.changeGradeModes(request, new AsyncCallback<SpecialRegistrationInterface.ChangeGradeModesResponse>(){

                public void onSuccess(SpecialRegistrationInterface.ChangeGradeModesResponse response) {
                    if (response.hasRequests()) {
                        ChangeGradeModesDialog.this.iStatus.info(MESSAGES.statusGradeModeChangesRequested());
                    } else {
                        ChangeGradeModesDialog.this.iStatus.info(MESSAGES.statusGradeModeChangesApplied());
                    }
                    LoadingWidget.getInstance().hide();
                    ChangeGradeModesDialog.this.onChange(response);
                }

                public void onFailure(Throwable caught) {
                    ChangeGradeModesDialog.this.iStatus.error(MESSAGES.exceptionChangeGradeModes(caught.getMessage()), caught);
                    LoadingWidget.getInstance().hide();
                }
            });
        } else {
            this.iStatus.info(MESSAGES.statusNoGradeModeChangesMade());
        }
    }

    public static class GradeModeLabel
    extends WebTable.Cell {
        private Label iLabel;
        private SpecialRegistrationInterface.SpecialRegistrationGradeModeChanges iGradeMode;

        public GradeModeLabel(GradeModeChange change, SpecialRegistrationInterface.SpecialRegistrationGradeModeChanges gradeMode) {
            super(null);
            this.iGradeMode = gradeMode;
            this.iLabel = new Label();
            this.iLabel.addStyleName("grade-mode-label");
            this.iLabel.setText(this.iGradeMode.getCurrentGradeMode() == null ? "" : this.iGradeMode.getCurrentGradeMode().getLabel());
            final ListBox box = (ListBox)change.getWidget();
            box.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    if (box.getSelectedIndex() <= 0) {
                        iLabel.setText(iGradeMode.getCurrentGradeMode() == null ? "" : iGradeMode.getCurrentGradeMode().getLabel());
                    } else {
                        SpecialRegistrationInterface.SpecialRegistrationGradeMode m = iGradeMode.getAvailableChange(box.getValue(box.getSelectedIndex()));
                        if (m == null) {
                            iLabel.setText(iGradeMode.getCurrentGradeMode() == null ? "" : iGradeMode.getCurrentGradeMode().getLabel());
                        } else {
                            iLabel.setText(m.getLabel());
                        }
                    }
                }
            });
        }

        @Override
        public String getValue() {
            return this.iLabel.getText();
        }

        @Override
        public Widget getWidget() {
            return this.iLabel;
        }

        @Override
        public void setStyleName(String styleName) {
            super.setStyleName(styleName);
        }
    }

    public class GradeModeChange
    extends WebTable.Cell
    implements HasAriaLabel {
        private ListBox iList;
        private List<SpecialRegistrationInterface.SpecialRegistrationGradeModeChanges> iGradeMode;
        private List<ClassAssignmentInterface.ClassAssignment> iClasses;

        public GradeModeChange(ClassAssignmentInterface.ClassAssignment ca, SpecialRegistrationInterface.SpecialRegistrationGradeModeChanges gradeMode) {
            super(null);
            this.iList = new ListBox();
            this.iList.addStyleName("grade-mode-list");
            this.iClasses = new ArrayList<ClassAssignmentInterface.ClassAssignment>();
            this.iClasses.add(ca);
            this.iGradeMode = new ArrayList<SpecialRegistrationInterface.SpecialRegistrationGradeModeChanges>();
            this.iGradeMode.add(gradeMode);
            this.iList.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    ChangeGradeModesDialog.this.formChanged();
                }
            });
            this.setup();
        }

        private void setup() {
            this.iList.clear();
            SpecialRegistrationInterface.SpecialRegistrationGradeMode current = this.iGradeMode.get(0).getCurrentGradeMode();
            boolean same = true;
            for (SpecialRegistrationInterface.SpecialRegistrationGradeModeChanges specialRegistrationGradeModeChanges : this.iGradeMode) {
                SpecialRegistrationInterface.SpecialRegistrationGradeMode m = specialRegistrationGradeModeChanges.getCurrentGradeMode();
                if (current != null) {
                    if (m != null && current.getCode().equals(m.getCode())) continue;
                    same = false;
                    continue;
                }
                if (m == null) continue;
                same = false;
            }
            if (same) {
                if (current != null) {
                    this.iList.addItem(current.getLabel(), current.getCode());
                    this.iList.setSelectedIndex(0);
                } else {
                    this.iList.addItem(MESSAGES.gradeModeItemNotSet(), "");
                    this.iList.setSelectedIndex(0);
                }
            } else if (current != null) {
                this.iList.addItem(MESSAGES.gradeModeItemNotSame(current.getLabel()), "");
                this.iList.setSelectedIndex(0);
            } else {
                this.iList.addItem(MESSAGES.gradeModeItemNotSame(MESSAGES.gradeModeItemNotSet()), "");
                this.iList.setSelectedIndex(0);
            }
            if (!same && current != null) {
                boolean canSetCurrent = true;
                for (SpecialRegistrationInterface.SpecialRegistrationGradeModeChanges gm : this.iGradeMode) {
                    if (gm.getAvailableChange(current.getCode()) != null || gm.isCurrentGradeMode(current.getCode())) continue;
                    canSetCurrent = false;
                    break;
                }
                if (canSetCurrent) {
                    this.iList.addItem(current.getLabel(), current.getCode());
                }
            }
            block2: for (SpecialRegistrationInterface.SpecialRegistrationGradeMode specialRegistrationGradeMode : this.iGradeMode.get(0).getAvailableChanges()) {
                for (SpecialRegistrationInterface.SpecialRegistrationGradeModeChanges gm : this.iGradeMode) {
                    if (gm.getAvailableChange(specialRegistrationGradeMode.getCode()) != null || gm.isCurrentGradeMode(specialRegistrationGradeMode.getCode())) continue;
                    continue block2;
                }
                if (same && current != null && current.getCode().equals(specialRegistrationGradeMode.getCode())) continue;
                this.iList.addItem(specialRegistrationGradeMode.getLabel(), specialRegistrationGradeMode.getCode());
            }
        }

        public void addClassAssignment(ClassAssignmentInterface.ClassAssignment ca, SpecialRegistrationInterface.SpecialRegistrationGradeModeChanges gm) {
            this.iClasses.add(ca);
            this.iGradeMode.add(gm);
            this.setup();
        }

        @Override
        public String getValue() {
            return this.iList.getValue(this.iList.getSelectedIndex());
        }

        @Override
        public Widget getWidget() {
            return this.iList;
        }

        public SpecialRegistrationInterface.SpecialRegistrationGradeMode getChange() {
            SpecialRegistrationInterface.SpecialRegistrationGradeMode current;
            if (this.iList.getSelectedIndex() <= 0) {
                return null;
            }
            SpecialRegistrationInterface.SpecialRegistrationGradeMode change = this.iGradeMode.get(0).getAvailableChange(this.iList.getValue(this.iList.getSelectedIndex()));
            if (change == null && (current = this.iGradeMode.get(0).getCurrentGradeMode()) != null && current.getCode().equals(this.iList.getValue(this.iList.getSelectedIndex()))) {
                change = current;
            }
            return change;
        }

        public List<ClassAssignmentInterface.ClassAssignment> getClassAssignments() {
            return this.iClasses;
        }

        public List<SpecialRegistrationInterface.SpecialRegistrationGradeModeChanges> getGradeModes() {
            return this.iGradeMode;
        }

        public SpecialRegistrationInterface.SpecialRegistrationGradeMode getChange(String extId) {
            if (this.iList.getSelectedIndex() <= 0) {
                return null;
            }
            for (int i = 0; i < this.iClasses.size(); ++i) {
                if (!extId.equals(this.iClasses.get(i).getExternalId())) continue;
                return this.iGradeMode.get(i).getAvailableChange(this.iList.getValue(this.iList.getSelectedIndex()));
            }
            return null;
        }
    }
}

