/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.instructor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.unitime.timetable.gwt.client.GwtHint;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.instructor.AttributesCell;
import org.unitime.timetable.gwt.client.instructor.InstructorDetails;
import org.unitime.timetable.gwt.client.instructor.InstructorExternalIdCell;
import org.unitime.timetable.gwt.client.instructor.InstructorNameCell;
import org.unitime.timetable.gwt.client.instructor.ObjectivesCell;
import org.unitime.timetable.gwt.client.instructor.PreferenceCell;
import org.unitime.timetable.gwt.client.instructor.TeachingRequestDetails;
import org.unitime.timetable.gwt.client.instructor.TimePreferenceCell;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeDialogBox;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseNull;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.InstructorInterface;

public class TeachingRequestDetailPage
extends UniTimeDialogBox {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    protected static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    protected static final StudentSectioningMessages SECTMSG = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    protected static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    protected static NumberFormat sTeachingLoadFormat = NumberFormat.getFormat((String)CONSTANTS.teachingLoadFormat());
    protected static NumberFormat sSuggestionScoreFormat = NumberFormat.getFormat((String)CONSTANTS.suggestionScoreFormat());
    private InstructorInterface.TeachingRequestsPagePropertiesResponse iProperties;
    private SimpleForm iForm;
    private ScrollPanel iScroll;
    private TeachingRequestDetails iRequestDetails = null;
    private InstructorDetails iInstructorDetails = null;
    private int iDetailsRow;
    private UniTimeHeaderPanel iAssignmentHeader;
    private UniTimeTable<InstructorInterface.AssignmentInfo> iAssignmentTable;
    private Label iAssignmentScore;
    private ObjectivesCell iAssignmentObjectives;
    private int iAssignmentRow;
    private int iAssignmentScoreRow;
    private int iAssignmentObjectivesRow;
    private CheckBox iIgnoreConflicts;
    private int iIgnoreConflictsRow = -1;
    private UniTimeHeaderPanel iDomainHeader;
    private int iDomainRow;
    private UniTimeTable<InstructorInterface.SuggestionInfo> iDomainTable;
    private int iSuggestionsRow;
    private UniTimeHeaderPanel iSuggestionsHeader;
    private InstructorInterface.TeachingRequestInfo iRequest;
    private InstructorInterface.InstructorInfo iInstructor;
    private InstructorInterface.ComputeSuggestionsRequest iSuggestionsRequest;
    private UniTimeTable<InstructorInterface.SuggestionInfo> iSuggestionsTable;

    public TeachingRequestDetailPage(InstructorInterface.TeachingRequestsPagePropertiesResponse properties) {
        super(true, true);
        this.setEscapeToHide(true);
        this.addStyleName("unitime-TeachingRequestDetail");
        this.iForm = new SimpleForm();
        this.iForm.addStyleName("detail");
        this.iScroll = new ScrollPanel((Widget)this.iForm);
        this.iScroll.setStyleName("scroll");
        this.setWidget((Widget)this.iScroll);
        this.iProperties = properties;
        this.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

            public void onClose(CloseEvent<PopupPanel> event) {
                RootPanel.getBodyElement().getStyle().setOverflow(Style.Overflow.AUTO);
            }
        });
        this.setupDetails();
        this.setupSelectedAssignments();
        this.setupDomain();
        this.setupSuggestions();
        UniTimeHeaderPanel footer = new UniTimeHeaderPanel();
        footer.addButton("close", MESSAGES.buttonClose(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                TeachingRequestDetailPage.this.hide();
            }
        });
        this.iForm.addBottomRow((Widget)footer);
    }

    protected void onAssignmentChanged(List<InstructorInterface.AssignmentInfo> assignments) {
    }

    public void showRequestDetail(Long id) {
        this.iAssignmentTable.clearTable(1);
        LoadingWidget.getInstance().show(MESSAGES.waitLoadTeachingRequestDetail());
        ToolBox.setMaxHeight(this.iScroll.getElement().getStyle(), Math.round(0.9 * (double)Window.getClientHeight()) + "px");
        RPC.execute(new InstructorInterface.TeachingRequestDetailRequest(id), new AsyncCallback<InstructorInterface.TeachingRequestInfo>(){

            public void onFailure(Throwable caught) {
                LoadingWidget.getInstance().hide();
                UniTimeNotifications.error(MESSAGES.failedToLoadTeachingRequestDetail(caught.getMessage()), caught);
                ToolBox.checkAccess(caught);
            }

            public void onSuccess(InstructorInterface.TeachingRequestInfo result) {
                LoadingWidget.getInstance().hide();
                TeachingRequestDetailPage.this.populate(result, null, null);
                GwtHint.hideHint();
                TeachingRequestDetailPage.this.center();
                RootPanel.getBodyElement().getStyle().setOverflow(Style.Overflow.HIDDEN);
            }
        });
    }

    public void showInstructorDetail(Long id) {
        this.iAssignmentTable.clearTable(1);
        LoadingWidget.getInstance().show(MESSAGES.waitLoadTeachingRequestDetail());
        ToolBox.setMaxHeight(this.iScroll.getElement().getStyle(), Math.round(0.9 * (double)Window.getClientHeight()) + "px");
        RPC.execute(new InstructorInterface.TeachingAssignmentsDetailRequest(id), new AsyncCallback<InstructorInterface.InstructorInfo>(){

            public void onFailure(Throwable caught) {
                LoadingWidget.getInstance().hide();
                UniTimeNotifications.error(MESSAGES.failedToLoadTeachingRequestDetail(caught.getMessage()), caught);
                ToolBox.checkAccess(caught);
            }

            public void onSuccess(InstructorInterface.InstructorInfo result) {
                LoadingWidget.getInstance().hide();
                TeachingRequestDetailPage.this.populate(null, null, result);
                GwtHint.hideHint();
                TeachingRequestDetailPage.this.center();
                RootPanel.getBodyElement().getStyle().setOverflow(Style.Overflow.HIDDEN);
            }
        });
    }

    protected void computeSuggestions(Integer scrollToRow) {
        InstructorInterface.ComputeSuggestionsRequest request = new InstructorInterface.ComputeSuggestionsRequest();
        for (InstructorInterface.AssignmentInfo assignment : this.iAssignmentTable.getData()) {
            if (assignment.getInstructor() == null) continue;
            request.addAssignment(assignment);
        }
        this.computeSuggestions(request, scrollToRow);
    }

    protected void scrollToRow(Integer row) {
        if (row != null) {
            Element scroll = this.iScroll.getElement();
            int realOffset = 0;
            for (Element item = this.iForm.getRowFormatter().getElement(row.intValue()); item != null && !item.equals((Object)scroll); item = item.getOffsetParent()) {
                realOffset += item.getOffsetTop();
            }
            scroll.setScrollTop(realOffset - scroll.getOffsetHeight() / 2);
        }
    }

    protected void computeSuggestions(final InstructorInterface.ComputeSuggestionsRequest request, final Integer scrollToRow) {
        this.iSuggestionsRequest = request;
        if (this.iRequest != null) {
            this.iSuggestionsRequest.setSelectedRequestId(this.iRequest.getRequestId());
            this.iSuggestionsRequest.setSelectedIndex(this.iRequestDetails.getValue());
        } else {
            this.iSuggestionsRequest.setSelectedInstructorId(this.iInstructor.getInstructorId());
            Integer index = this.iInstructorDetails.getValue();
            if (index != null && index < this.iInstructor.getAssignedRequests().size()) {
                this.iSuggestionsRequest.setSelectedRequestId(this.iInstructor.getAssignedRequests().get(index).getRequestId());
            }
        }
        if (this.iProperties.isHasSolver()) {
            if (request.isComputeSuggestions()) {
                this.showSuggestionsLoading();
            }
            if (request.isComputeDomain()) {
                this.showDomainLoading();
            }
        } else {
            this.showDomainLoading();
            this.hideSuggestions();
        }
        if (request.isComputeDomain() && request.isComputeSuggestions()) {
            this.showAssignmentLoading();
        }
        RPC.execute(this.iSuggestionsRequest, new AsyncCallback<InstructorInterface.SuggestionsResponse>(){

            public void onFailure(Throwable caught) {
                TeachingRequestDetailPage.this.iSuggestionsHeader.setErrorMessage(MESSAGES.failedToComputeSuggestions(caught.getMessage()));
                TeachingRequestDetailPage.this.iSuggestionsTable.setVisible(false);
            }

            public void onSuccess(InstructorInterface.SuggestionsResponse result) {
                TeachingRequestDetailPage.this.showAssignment(result.getCurrentAssignment());
                if (request.isComputeSuggestions()) {
                    TeachingRequestDetailPage.this.showSuggestions(result);
                }
                if (request.isComputeDomain()) {
                    TeachingRequestDetailPage.this.showDomain(result.getDomainValues(), result.getDomainSize());
                    TeachingRequestDetailPage.this.iDomainHeader.setEnabled("more", result.hasDomainValues() && result.getDomainValues().size() < result.getDomainSize());
                }
                TeachingRequestDetailPage.this.center();
                TeachingRequestDetailPage.this.scrollToRow(scrollToRow);
            }
        });
    }

    protected void hideSuggestions() {
        this.iSuggestionsTable.clearTable(1);
        this.iForm.getRowFormatter().setVisible(this.iSuggestionsRow, false);
        this.iForm.getRowFormatter().setVisible(this.iSuggestionsRow + 1, false);
    }

    protected void showSuggestionsLoading() {
        this.iForm.getRowFormatter().setVisible(this.iSuggestionsRow, true);
        this.iForm.getRowFormatter().setVisible(this.iSuggestionsRow + 1, true);
        this.iSuggestionsHeader.showLoading();
        this.iSuggestionsHeader.setEnabled("longer", false);
        this.iSuggestionsHeader.setEnabled("deeper", false);
        this.iSuggestionsTable.setVisible(false);
    }

    protected void showSuggestions(InstructorInterface.SuggestionsResponse result) {
        if (!this.iProperties.isHasSolver()) {
            this.hideSuggestions();
            return;
        }
        this.iSuggestionsHeader.clearMessage();
        this.iSuggestionsTable.clearTable(1);
        if (result.hasSuggestions()) {
            for (InstructorInterface.SuggestionInfo suggestion : result.getSuggestions()) {
                ArrayList<Object> line = new ArrayList<Object>();
                Label score = new Label(sSuggestionScoreFormat.format(suggestion.getValue()));
                if (suggestion.getValue() > 0.0) {
                    score.getElement().getStyle().setColor("red");
                }
                if (suggestion.getValue() < 0.0) {
                    score.getElement().getStyle().setColor("green");
                }
                line.add(score);
                P courses = new P(new String[0]);
                P sections = new P(new String[0]);
                P extIdOld = new P("initial");
                P extIdArrows = new P("arrow");
                P extIdNew = new P("current");
                P nameOld = new P("initial");
                P nameArrows = new P("arrow");
                P nameNew = new P("current");
                for (InstructorInterface.AssignmentInfo assignment : suggestion.getAssignments()) {
                    P course = new P("course");
                    course.setText(assignment.getRequest().getCourse().getCourseName());
                    courses.add((Widget)course);
                    P section = new P("sections");
                    Iterator<InstructorInterface.SectionInfo> i = assignment.getRequest().getSections().iterator();
                    while (i.hasNext()) {
                        InstructorInterface.SectionInfo s = i.next();
                        P p = new P("section");
                        p.setText(s.getSectionType() + (s.getExternalId() == null ? "" : " " + s.getExternalId()) + (i.hasNext() ? "," : ""));
                        if (s.isCommon()) {
                            p.addStyleName("common");
                        }
                        section.add((Widget)p);
                    }
                    sections.add((Widget)section);
                    InstructorInterface.InstructorInfo initial = assignment.getRequest().getInstructor(assignment.getIndex());
                    InstructorInterface.InstructorInfo current = assignment.getInstructor();
                    extIdOld.add((Widget)new InstructorExternalIdCell(this.iProperties, initial));
                    P extIdArrow = new P(new String[0]);
                    extIdArrow.setHTML(MESSAGES.assignmentArrow());
                    extIdArrows.add((Widget)extIdArrow);
                    extIdNew.add((Widget)new InstructorExternalIdCell(this.iProperties, current));
                    nameOld.add((Widget)new InstructorNameCell(this.iProperties, initial));
                    P nameArrow = new P(new String[0]);
                    nameArrow.setHTML(MESSAGES.assignmentArrow());
                    nameArrows.add((Widget)nameArrow);
                    nameNew.add((Widget)new InstructorNameCell(this.iProperties, current));
                }
                line.add((Object)courses);
                line.add((Object)sections);
                line.add((Object)extIdOld);
                line.add((Object)extIdArrows);
                line.add((Object)extIdNew);
                line.add((Object)nameOld);
                line.add((Object)nameArrows);
                line.add((Object)nameNew);
                line.add((Object)new ObjectivesCell(this.iProperties, suggestion.getValues()));
                this.iSuggestionsTable.addRow(suggestion, line);
            }
            if (result.getSuggestions().size() < result.getNrSolutions()) {
                if (result.isTimeoutReached()) {
                    this.iSuggestionsTable.addRow(null, new Widget[]{new Note(10, MESSAGES.suggestionsNoteTimeoutNResults(this.iSuggestionsRequest.getTimeout() / 1000, result.getNrCombinationsConsidered(), this.iSuggestionsRequest.getMaxDept(), result.getSuggestions().size(), result.getNrSolutions()))});
                } else {
                    this.iSuggestionsTable.addRow(null, new Widget[]{new Note(10, MESSAGES.suggestionsNoteNoTimeoutNResults(result.getNrCombinationsConsidered(), this.iSuggestionsRequest.getMaxDept(), result.getSuggestions().size(), result.getNrSolutions()))});
                }
            } else if (result.isTimeoutReached()) {
                this.iSuggestionsTable.addRow(null, new Widget[]{new Note(10, MESSAGES.suggestionsNoteTimeoutAllResults(this.iSuggestionsRequest.getTimeout() / 1000, result.getNrCombinationsConsidered(), this.iSuggestionsRequest.getMaxDept(), result.getSuggestions().size()))});
            } else {
                this.iSuggestionsTable.addRow(null, new Widget[]{new Note(10, MESSAGES.suggestionsNoteNoTimeoutAllResults(result.getNrCombinationsConsidered(), this.iSuggestionsRequest.getMaxDept(), result.getSuggestions().size()))});
            }
        } else if (result.isTimeoutReached()) {
            this.iSuggestionsTable.addRow(null, new Widget[]{new Note(10, MESSAGES.suggestionsNoteTimeoutNoResults(this.iSuggestionsRequest.getTimeout() / 1000, result.getNrCombinationsConsidered(), this.iSuggestionsRequest.getMaxDept()))});
        } else {
            this.iSuggestionsTable.addRow(null, new Widget[]{new Note(10, MESSAGES.suggestionsNoteNoTimeoutNoResults(result.getNrCombinationsConsidered(), this.iSuggestionsRequest.getMaxDept()))});
        }
        this.iSuggestionsTable.setVisible(true);
        this.iSuggestionsHeader.setEnabled("longer", result.isTimeoutReached());
        this.iSuggestionsHeader.setEnabled("deeper", true);
    }

    protected void showAssignmentLoading() {
        if (this.iAssignmentTable.getRowCount() > 1) {
            this.iAssignmentHeader.setEnabled("assign", false);
            this.iAssignmentHeader.showLoading();
        }
    }

    protected void showAssignment(InstructorInterface.SuggestionInfo suggestion) {
        this.iAssignmentHeader.clearMessage();
        this.iAssignmentTable.clearTable(1);
        if (suggestion != null) {
            for (final InstructorInterface.AssignmentInfo assignment : suggestion.getAssignments()) {
                ArrayList<P> line = new ArrayList<P>();
                P buttons = new P("buttons");
                line.add(buttons);
                P course = new P("course");
                course.setText(assignment.getRequest().getCourse().getCourseName());
                line.add(course);
                P section = new P("sections");
                Iterator<InstructorInterface.SectionInfo> i = assignment.getRequest().getSections().iterator();
                while (i.hasNext()) {
                    InstructorInterface.SectionInfo s = i.next();
                    P p = new P("section");
                    p.setText(s.getSectionType() + (s.getExternalId() == null ? "" : " " + s.getExternalId()) + (i.hasNext() ? "," : ""));
                    if (s.isCommon()) {
                        p.addStyleName("common");
                    }
                    section.add((Widget)p);
                }
                line.add(section);
                InstructorInterface.InstructorInfo initial = assignment.getRequest().getInstructor(assignment.getIndex());
                InstructorInterface.InstructorInfo current = assignment.getInstructor();
                if (initial == null && current == null || initial != null && initial.equals(current)) {
                    line.add(new P(new String[0]));
                    line.add(new P(new String[0]));
                } else {
                    InstructorExternalIdCell extIdOld = new InstructorExternalIdCell(this.iProperties, initial);
                    extIdOld.addStyleName("initial");
                    line.add(extIdOld);
                    P extIdArrow = new P(new String[0]);
                    extIdArrow.setHTML(MESSAGES.assignmentArrow());
                    line.add(extIdArrow);
                }
                InstructorExternalIdCell extIdNew = new InstructorExternalIdCell(this.iProperties, current);
                extIdNew.addStyleName("current");
                line.add(extIdNew);
                if (initial == null && current == null || initial != null && initial.equals(current)) {
                    line.add(new P(new String[0]));
                    line.add(new P(new String[0]));
                } else {
                    InstructorNameCell nameOld = new InstructorNameCell(this.iProperties, initial);
                    nameOld.addStyleName("initial");
                    line.add(nameOld);
                    P nameArrow = new P(new String[0]);
                    nameArrow.setHTML(MESSAGES.assignmentArrow());
                    line.add(nameArrow);
                }
                InstructorNameCell nameNew = new InstructorNameCell(this.iProperties, current);
                nameNew.addStyleName("current");
                line.add(nameNew);
                if (current != null) {
                    line.add(new AttributesCell(current.getAttributes()));
                    line.add(new PreferenceCell(this.iProperties, current.getCoursePreferences()));
                    line.add(new TimePreferenceCell(this.iProperties, current));
                    line.add(new PreferenceCell(this.iProperties, current.getDistributionPreferences()));
                } else if (initial != null) {
                    line.add(new AttributesCell(initial.getAttributes()));
                    line.add(new PreferenceCell(this.iProperties, initial.getCoursePreferences()));
                    line.add(new TimePreferenceCell(this.iProperties, initial));
                    line.add(new PreferenceCell(this.iProperties, initial.getDistributionPreferences()));
                } else {
                    line.add(new P(new String[0]));
                    line.add(new P(new String[0]));
                    line.add(new P(new String[0]));
                    line.add(new P(new String[0]));
                }
                ObjectivesCell obj = new ObjectivesCell(this.iProperties, initial == null ? null : initial.getValues(), current == null ? null : current.getValues());
                if (assignment.hasConflicts()) {
                    P confs = new P("conflicts");
                    for (String text : assignment.getConflicts()) {
                        P conf = new P("conflict");
                        conf.setText(text);
                        confs.add((Widget)conf);
                    }
                    obj.add((Widget)confs);
                }
                line.add(obj);
                if (current != null) {
                    Image delete = new Image(RESOURCES.delete());
                    delete.addStyleName("delete");
                    delete.setTitle(MESSAGES.titleDeleteRow());
                    delete.addClickHandler(new ClickHandler(){

                        public void onClick(ClickEvent event) {
                            event.preventDefault();
                            event.stopPropagation();
                            InstructorInterface.ComputeSuggestionsRequest request = new InstructorInterface.ComputeSuggestionsRequest();
                            for (InstructorInterface.AssignmentInfo a : TeachingRequestDetailPage.this.iAssignmentTable.getData()) {
                                if (a.getInstructor() == null || a.equals(assignment)) continue;
                                request.addAssignment(a);
                            }
                            TeachingRequestDetailPage.this.computeSuggestions(request, TeachingRequestDetailPage.this.iAssignmentRow);
                        }
                    });
                    buttons.add((Widget)delete);
                }
                this.iAssignmentTable.addRow(assignment, line);
            }
            this.iAssignmentScore.setText(sSuggestionScoreFormat.format(suggestion.getValue()));
            if (suggestion.getValue() > 0.0) {
                this.iAssignmentScore.getElement().getStyle().setColor("red");
            }
            if (suggestion.getValue() < 0.0) {
                this.iAssignmentScore.getElement().getStyle().setColor("green");
            }
            this.iAssignmentObjectives.setValue(suggestion.getValues());
        }
        this.iForm.getRowFormatter().setVisible(this.iAssignmentRow, this.iAssignmentTable.getRowCount() > 1);
        this.iForm.getRowFormatter().setVisible(this.iAssignmentRow + 1, this.iAssignmentTable.getRowCount() > 1);
        this.iForm.getRowFormatter().setVisible(this.iAssignmentScoreRow, this.iAssignmentTable.getRowCount() > 1 && suggestion != null && suggestion.getValue() != 0.0);
        this.iForm.getRowFormatter().setVisible(this.iAssignmentObjectivesRow, this.iAssignmentTable.getRowCount() > 1 && suggestion != null && suggestion.hasValues());
        if (this.iIgnoreConflicts != null) {
            this.iForm.getRowFormatter().setVisible(this.iIgnoreConflictsRow, this.iAssignmentTable.getRowCount() > 1);
            if (this.iIgnoreConflicts.getValue().booleanValue()) {
                for (int i = 1; i < this.iAssignmentTable.getRowCount(); ++i) {
                    InstructorInterface.AssignmentInfo ai = this.iAssignmentTable.getData(i);
                    if (ai == null || ai.getInstructor() != null) continue;
                    this.iAssignmentTable.getRowFormatter().setVisible(i, false);
                }
            }
        }
        this.iAssignmentHeader.setEnabled("assign", this.iAssignmentTable.getRowCount() > 1);
    }

    protected void hideDomain() {
        this.iForm.getRowFormatter().setVisible(this.iDomainRow, false);
        this.iForm.getRowFormatter().setVisible(this.iDomainRow + 1, false);
    }

    protected void showDomainLoading() {
        this.iDomainHeader.setEnabled("more", false);
        this.iForm.getRowFormatter().setVisible(this.iDomainRow, true);
        this.iForm.getRowFormatter().setVisible(this.iDomainRow + 1, true);
        if (this.iRequest != null) {
            this.iDomainHeader.setHeaderTitle(MESSAGES.headerAvailableInstructors());
        } else {
            this.iDomainHeader.setHeaderTitle(MESSAGES.headerAvailableAssignments());
        }
        this.iDomainHeader.showLoading();
        this.iDomainTable.setVisible(false);
    }

    protected void showDomain(List<InstructorInterface.SuggestionInfo> suggestions, int domainSize) {
        this.iDomainTable.setVisible(true);
        this.iDomainHeader.clearMessage();
        this.iDomainTable.clearTable(0);
        if (this.iRequest != null) {
            this.iDomainHeader.setHeaderTitle(MESSAGES.headerAvailableInstructors());
            ArrayList<UniTimeTableHeader> domainHeader = new ArrayList<UniTimeTableHeader>();
            domainHeader.add(new UniTimeTableHeader(MESSAGES.colExternalId()));
            domainHeader.add(new UniTimeTableHeader(MESSAGES.colNamePerson()));
            domainHeader.add(new UniTimeTableHeader(MESSAGES.colAssignedLoad()));
            domainHeader.add(new UniTimeTableHeader(MESSAGES.colAttributes()));
            domainHeader.add(new UniTimeTableHeader(MESSAGES.colCoursePreferences()));
            domainHeader.add(new UniTimeTableHeader(MESSAGES.colTimePreferences()));
            domainHeader.add(new UniTimeTableHeader(MESSAGES.colDistributionPreferences()));
            domainHeader.add(new UniTimeTableHeader(MESSAGES.colConflictingRequests()));
            domainHeader.add(new UniTimeTableHeader("&nbsp;"));
            domainHeader.add(new UniTimeTableHeader("&nbsp;"));
            domainHeader.add(new UniTimeTableHeader(MESSAGES.colObjectives()));
            this.iDomainTable.addRow(null, domainHeader);
            if (suggestions != null && this.iRequestDetails.getValue() != null) {
                int index = this.iRequestDetails.getValue();
                for (InstructorInterface.SuggestionInfo suggestion : suggestions) {
                    InstructorInterface.PreferenceInterface pref;
                    InstructorInterface.PreferenceInterface pref2;
                    InstructorInterface.InstructorInfo instructor = null;
                    ArrayList<InstructorInterface.AssignmentInfo> conflicts = new ArrayList<InstructorInterface.AssignmentInfo>();
                    for (InstructorInterface.AssignmentInfo assignment : suggestion.getAssignments()) {
                        if (assignment.getRequest().equals(this.iRequest) && assignment.getIndex() == index) {
                            instructor = assignment.getInstructor();
                        }
                        if (assignment.getInstructor() != null) continue;
                        conflicts.add(assignment);
                    }
                    if (instructor == null) continue;
                    ArrayList<Object> line = new ArrayList<Object>();
                    Label extId = new Label(instructor.getExternalId());
                    if (instructor.getTeachingPreference() != null && !"0".equals(instructor.getTeachingPreference()) && (pref2 = this.iProperties.getPreference(instructor.getTeachingPreference())) != null) {
                        extId.setTitle(pref2.getName() + " " + instructor.getExternalId());
                        extId.getElement().getStyle().setColor(pref2.getColor());
                    }
                    line.add(extId);
                    Label name = new Label(instructor.getInstructorName());
                    if (instructor.getTeachingPreference() != null && !"0".equals(instructor.getTeachingPreference()) && (pref = this.iProperties.getPreference(instructor.getTeachingPreference())) != null) {
                        name.setTitle(pref.getName() + " " + instructor.getInstructorName());
                        name.getElement().getStyle().setColor(pref.getColor());
                    }
                    line.add(name);
                    line.add(new Label(sTeachingLoadFormat.format((double)instructor.getAssignedLoad()) + " / " + sTeachingLoadFormat.format((double)instructor.getMaxLoad())));
                    P p = new P("attributes");
                    for (InstructorInterface.AttributeInterface a : instructor.getAttributes()) {
                        P i = new P("attribute");
                        i.setText(a.getName());
                        i.setTitle(a.getName() + " (" + a.getType().getLabel() + ")");
                        p.add((Widget)i);
                    }
                    line.add((Object)new AttributesCell(instructor.getAttributes()));
                    line.add((Object)new PreferenceCell(this.iProperties, instructor.getCoursePreferences()));
                    line.add(new TimePreferenceCell(this.iProperties, instructor));
                    line.add((Object)new PreferenceCell(this.iProperties, instructor.getDistributionPreferences()));
                    for (int i = 0; i < 3; ++i) {
                        if (!conflicts.isEmpty()) {
                            line.add((Object)new RequestConflicts(conflicts, i));
                            continue;
                        }
                        line.add(new Label());
                    }
                    line.add((Object)new ObjectivesCell(this.iProperties, suggestion.getValues()));
                    this.iDomainTable.addRow(suggestion, line);
                }
                if (suggestions.size() < domainSize) {
                    this.iDomainTable.addRow(null, new Widget[]{new Note(11, MESSAGES.domainNinstructors(suggestions.size(), domainSize))});
                }
            }
        } else {
            this.iDomainHeader.setHeaderTitle(MESSAGES.headerAvailableAssignments());
            ArrayList<UniTimeTableHeader> domainHeader = new ArrayList<UniTimeTableHeader>();
            domainHeader.add(new UniTimeTableHeader(MESSAGES.colCourse()));
            domainHeader.add(new UniTimeTableHeader(MESSAGES.colSection()));
            domainHeader.add(new UniTimeTableHeader(MESSAGES.colTime()));
            domainHeader.add(new UniTimeTableHeader(MESSAGES.colDate()));
            domainHeader.add(new UniTimeTableHeader(MESSAGES.colRoom()));
            domainHeader.add(new UniTimeTableHeader(MESSAGES.colTeachingLoad()));
            domainHeader.add(new UniTimeTableHeader(MESSAGES.colConflictingRequests()));
            domainHeader.add(new UniTimeTableHeader("&nbsp;"));
            domainHeader.add(new UniTimeTableHeader("&nbsp;"));
            domainHeader.add(new UniTimeTableHeader(MESSAGES.colObjectives()));
            this.iDomainTable.addRow(null, domainHeader);
            if (suggestions != null) {
                for (InstructorInterface.SuggestionInfo suggestion : suggestions) {
                    InstructorInterface.TeachingRequestInfo request = null;
                    ArrayList<InstructorInterface.AssignmentInfo> conflicts = new ArrayList<InstructorInterface.AssignmentInfo>();
                    for (InstructorInterface.AssignmentInfo assignment : suggestion.getAssignments()) {
                        if (this.iInstructor.equals(assignment.getInstructor()) && request == null) {
                            request = assignment.getRequest();
                        }
                        if (assignment.getInstructor() != null) continue;
                        conflicts.add(assignment);
                    }
                    if (request == null) continue;
                    ArrayList<P> line = new ArrayList<P>();
                    P course = new P("course");
                    course.setText(request.getCourse().getCourseName());
                    line.add(course);
                    P section = new P("sections");
                    P time = new P("times");
                    P date = new P("dates");
                    P room = new P("rooms");
                    for (InstructorInterface.SectionInfo s : request.getSections()) {
                        P p = new P("section");
                        p.setText(s.getSectionType() + (s.getExternalId() == null ? "" : " " + s.getExternalId()));
                        if (s.isCommon()) {
                            p.addStyleName("common");
                        }
                        section.add((Widget)p);
                        P t = new P("time");
                        t.setHTML(s.getTime() == null ? SECTMSG.arrangeHours() : s.getTime());
                        if (s.isCommon()) {
                            t.addStyleName("common");
                        }
                        time.add((Widget)t);
                        P d = new P("date");
                        d.setHTML(s.getDate() == null ? SECTMSG.noDate() : s.getDate());
                        if (s.isCommon()) {
                            d.addStyleName("common");
                        }
                        date.add((Widget)d);
                        P r = new P("room");
                        r.setHTML(s.getRoom() == null ? SECTMSG.noRoom() : s.getRoom());
                        if (s.isCommon()) {
                            r.addStyleName("common");
                        }
                        room.add((Widget)r);
                    }
                    line.add(section);
                    line.add(time);
                    line.add(date);
                    line.add(room);
                    line.add((P)new Label(sTeachingLoadFormat.format((double)request.getLoad())));
                    for (int i = 0; i < 3; ++i) {
                        if (!conflicts.isEmpty()) {
                            line.add(new InstructorConflicts(conflicts, i));
                            continue;
                        }
                        line.add((P)new Label());
                    }
                    line.add(new ObjectivesCell(this.iProperties, suggestion.getValues()));
                    this.iDomainTable.addRow(suggestion, line);
                }
                if (suggestions.size() < domainSize) {
                    this.iDomainTable.addRow(null, new Widget[]{new Note(10, MESSAGES.domainNassignments(suggestions.size(), domainSize))});
                }
            }
        }
        this.iForm.getRowFormatter().setVisible(this.iDomainRow, this.iDomainTable.getRowCount() > 1);
        this.iForm.getRowFormatter().setVisible(this.iDomainRow + 1, this.iDomainTable.getRowCount() > 1);
    }

    protected void populate(InstructorInterface.TeachingRequestInfo request, Integer index, InstructorInterface.InstructorInfo instructor) {
        if (request != null) {
            this.iRequest = request;
            this.iInstructor = null;
            this.iForm.setWidget(this.iDetailsRow, 0, (Widget)this.iRequestDetails);
            ArrayList<String> sections = new ArrayList<String>();
            for (InstructorInterface.SectionInfo s : request.getSections()) {
                if (s.isCommon()) continue;
                sections.add(s.getSectionType() + (s.getExternalId() == null ? "" : " " + s.getExternalId()));
            }
            this.setText(MESSAGES.dialogTeachingRequestDetail(request.getCourse().getCourseName(), ToolBox.toString(sections)));
            this.iRequestDetails.setRequest(request, index);
        } else {
            this.iRequest = null;
            this.iInstructor = instructor;
            this.iForm.setWidget(this.iDetailsRow, 0, (Widget)this.iInstructorDetails);
            this.setText(MESSAGES.dialogDetailsOf(instructor.getInstructorName()));
            this.iInstructorDetails.setInstructor(instructor);
        }
        this.iAssignmentHeader.clearMessage();
        this.iForm.getRowFormatter().setVisible(this.iAssignmentRow, this.iAssignmentTable.getRowCount() > 1);
        this.iForm.getRowFormatter().setVisible(this.iAssignmentRow + 1, this.iAssignmentTable.getRowCount() > 1);
        this.iForm.getRowFormatter().setVisible(this.iAssignmentScoreRow, this.iAssignmentTable.getRowCount() > 1 && !this.iAssignmentScore.getText().isEmpty() && sSuggestionScoreFormat.parse(this.iAssignmentScore.getText()) != 0.0);
        this.iForm.getRowFormatter().setVisible(this.iAssignmentObjectivesRow, this.iAssignmentTable.getRowCount() > 1 && this.iAssignmentObjectives.getValue() != null && !this.iAssignmentObjectives.getValue().isEmpty());
        if (this.iIgnoreConflicts != null) {
            this.iForm.getRowFormatter().setVisible(this.iIgnoreConflictsRow, this.iAssignmentTable.getRowCount() > 1);
        }
        this.hideDomain();
        this.iSuggestionsRequest = null;
        this.hideDomain();
        this.hideSuggestions();
        if (this.iRequest != null && this.iRequestDetails.getValue() != null) {
            this.computeSuggestions(null);
        } else if (this.iInstructor != null) {
            this.computeSuggestions(null);
        }
    }

    protected void setupDetails() {
        this.iRequestDetails = new TeachingRequestDetails(this.iProperties);
        this.iDetailsRow = this.iForm.addRow((Widget)this.iRequestDetails);
        this.iInstructorDetails = new InstructorDetails(this.iProperties);
        this.iRequestDetails.addValueChangeHandler(new ValueChangeHandler<Integer>(){

            public void onValueChange(ValueChangeEvent<Integer> event) {
                if (event.getValue() != null) {
                    InstructorInterface.InstructorInfo instructor;
                    if (TeachingRequestDetailPage.this.iSuggestionsRequest != null && TeachingRequestDetailPage.this.iRequest.getRequestId().equals(TeachingRequestDetailPage.this.iSuggestionsRequest.getSelectedRequestId()) && ((Integer)event.getValue()).intValue() == TeachingRequestDetailPage.this.iSuggestionsRequest.getSelectedIndex() && (instructor = TeachingRequestDetailPage.this.iRequest.getInstructor((Integer)event.getValue())) != null) {
                        RPC.execute(new InstructorInterface.TeachingAssignmentsDetailRequest(instructor.getInstructorId()), new AsyncCallback<InstructorInterface.InstructorInfo>(){

                            public void onFailure(Throwable caught) {
                                TeachingRequestDetailPage.this.computeSuggestions(TeachingRequestDetailPage.this.iAssignmentRow);
                            }

                            public void onSuccess(InstructorInterface.InstructorInfo result) {
                                TeachingRequestDetailPage.this.populate(null, null, result);
                            }
                        });
                        return;
                    }
                    TeachingRequestDetailPage.this.computeSuggestions(TeachingRequestDetailPage.this.iAssignmentRow);
                }
            }
        });
        this.iInstructorDetails.addValueChangeHandler(new ValueChangeHandler<Integer>(){

            public void onValueChange(ValueChangeEvent<Integer> event) {
                if (event.getValue() != null && (Integer)event.getValue() < TeachingRequestDetailPage.this.iInstructor.getAssignedRequests().size()) {
                    InstructorInterface.TeachingRequestInfo req = TeachingRequestDetailPage.this.iInstructor.getAssignedRequests().get((Integer)event.getValue());
                    if (TeachingRequestDetailPage.this.iSuggestionsRequest != null && TeachingRequestDetailPage.this.iInstructor.getInstructorId().equals(TeachingRequestDetailPage.this.iSuggestionsRequest.getSelectedInstructorId()) && req.getRequestId().equals(TeachingRequestDetailPage.this.iSuggestionsRequest.getSelectedRequestId())) {
                        RPC.execute(new InstructorInterface.TeachingRequestDetailRequest(req.getRequestId()), new AsyncCallback<InstructorInterface.TeachingRequestInfo>(){

                            public void onFailure(Throwable caught) {
                                TeachingRequestDetailPage.this.computeSuggestions(TeachingRequestDetailPage.this.iAssignmentRow);
                            }

                            public void onSuccess(InstructorInterface.TeachingRequestInfo result) {
                                InstructorInterface.InstructorInfo instructor = result.getInstructor(TeachingRequestDetailPage.this.iInstructor.getInstructorId());
                                TeachingRequestDetailPage.this.populate(result, instructor == null ? null : new Integer(instructor.getAssignmentIndex()), null);
                            }
                        });
                        return;
                    }
                    TeachingRequestDetailPage.this.computeSuggestions(TeachingRequestDetailPage.this.iAssignmentRow);
                }
            }
        });
    }

    protected void setupSelectedAssignments() {
        this.iAssignmentHeader = new UniTimeHeaderPanel(MESSAGES.headerSelectedAssignment());
        this.iAssignmentRow = this.iForm.addHeaderRow((Widget)this.iAssignmentHeader);
        this.iAssignmentTable = new UniTimeTable();
        this.iAssignmentTable.addStyleName("selected");
        ArrayList<UniTimeTableHeader> asgHeader = new ArrayList<UniTimeTableHeader>();
        asgHeader.add(new UniTimeTableHeader("&nbsp;"));
        asgHeader.add(new UniTimeTableHeader(MESSAGES.colCourse()));
        asgHeader.add(new UniTimeTableHeader(MESSAGES.colSection()));
        asgHeader.add(new UniTimeTableHeader(MESSAGES.colExternalId(), 3));
        asgHeader.add(new UniTimeTableHeader(MESSAGES.colNamePerson(), 3));
        asgHeader.add(new UniTimeTableHeader(MESSAGES.colAttributes()));
        asgHeader.add(new UniTimeTableHeader(MESSAGES.colCoursePreferences()));
        asgHeader.add(new UniTimeTableHeader(MESSAGES.colTimePreferences()));
        asgHeader.add(new UniTimeTableHeader(MESSAGES.colDistributionPreferences()));
        asgHeader.add(new UniTimeTableHeader(MESSAGES.colObjectives()));
        this.iAssignmentTable.addRow(null, asgHeader);
        this.iForm.addRow((Widget)this.iAssignmentTable);
        this.iAssignmentHeader.addButton("assign", MESSAGES.buttonAssign(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (!TeachingRequestDetailPage.this.iProperties.isHasSolver() && !Window.confirm((String)MESSAGES.confirmInstructorAssignmentChangesNoSolver())) {
                    return;
                }
                TeachingRequestDetailPage.this.iAssignmentHeader.showLoading();
                TeachingRequestDetailPage.this.iAssignmentHeader.setEnabled("assign", false);
                final InstructorInterface.InstructorAssignmentRequest request = new InstructorInterface.InstructorAssignmentRequest();
                for (InstructorInterface.AssignmentInfo assignment : TeachingRequestDetailPage.this.iAssignmentTable.getData()) {
                    request.addAssignment(assignment);
                }
                if (TeachingRequestDetailPage.this.iIgnoreConflicts != null) {
                    request.setIgnoreConflicts(TeachingRequestDetailPage.this.iIgnoreConflicts.getValue());
                }
                RPC.execute(request, new AsyncCallback<GwtRpcResponseNull>(){

                    public void onFailure(Throwable caught) {
                        TeachingRequestDetailPage.this.iAssignmentHeader.setErrorMessage(caught.getMessage());
                    }

                    public void onSuccess(GwtRpcResponseNull result) {
                        TeachingRequestDetailPage.this.iAssignmentHeader.clearMessage();
                        TeachingRequestDetailPage.this.hide();
                        TeachingRequestDetailPage.this.onAssignmentChanged(request.getAssignments());
                    }
                });
            }
        });
        this.iAssignmentHeader.setEnabled("assign", false);
        this.iAssignmentScore = new Label();
        this.iAssignmentScoreRow = this.iForm.addRow(MESSAGES.propSuggestionScore(), (Widget)this.iAssignmentScore);
        this.iAssignmentObjectives = new ObjectivesCell(this.iProperties);
        this.iAssignmentObjectivesRow = this.iForm.addRow(MESSAGES.propSuggestionObjectives(), (Widget)this.iAssignmentObjectives);
        this.iAssignmentTable.addMouseClickListener(new UniTimeTable.MouseClickListener<InstructorInterface.AssignmentInfo>(){

            @Override
            public void onMouseClick(final UniTimeTable.TableEvent<InstructorInterface.AssignmentInfo> event) {
                if (event.getData() != null) {
                    InstructorInterface.TeachingRequestInfo request = event.getData().getRequest();
                    Integer index = event.getData().getIndex();
                    InstructorInterface.InstructorInfo instructor = event.getData().getInstructor();
                    if (instructor == null) {
                        instructor = event.getData().getRequest().getInstructor(event.getData().getIndex());
                    }
                    if (TeachingRequestDetailPage.this.iRequest != null) {
                        if (request.equals(TeachingRequestDetailPage.this.iRequest) && index.equals(TeachingRequestDetailPage.this.iRequestDetails.getValue()) && instructor != null) {
                            RPC.execute(new InstructorInterface.TeachingAssignmentsDetailRequest(instructor.getInstructorId()), new AsyncCallback<InstructorInterface.InstructorInfo>(){

                                public void onFailure(Throwable caught) {
                                    TeachingRequestDetailPage.this.populate(((InstructorInterface.AssignmentInfo)event.getData()).getRequest(), ((InstructorInterface.AssignmentInfo)event.getData()).getIndex(), null);
                                }

                                public void onSuccess(InstructorInterface.InstructorInfo result) {
                                    TeachingRequestDetailPage.this.populate(null, null, result);
                                }
                            });
                        } else {
                            TeachingRequestDetailPage.this.populate(event.getData().getRequest(), event.getData().getIndex(), null);
                        }
                    } else if (instructor != null) {
                        if (instructor.equals(TeachingRequestDetailPage.this.iInstructor)) {
                            TeachingRequestDetailPage.this.populate(event.getData().getRequest(), event.getData().getIndex(), null);
                        } else {
                            RPC.execute(new InstructorInterface.TeachingAssignmentsDetailRequest(instructor.getInstructorId()), new AsyncCallback<InstructorInterface.InstructorInfo>(){

                                public void onFailure(Throwable caught) {
                                    TeachingRequestDetailPage.this.populate(((InstructorInterface.AssignmentInfo)event.getData()).getRequest(), ((InstructorInterface.AssignmentInfo)event.getData()).getIndex(), null);
                                }

                                public void onSuccess(InstructorInterface.InstructorInfo result) {
                                    TeachingRequestDetailPage.this.populate(null, null, result);
                                }
                            });
                        }
                    } else {
                        TeachingRequestDetailPage.this.populate(event.getData().getRequest(), event.getData().getIndex(), null);
                    }
                }
            }
        });
        if (!this.iProperties.isHasSolver()) {
            this.iIgnoreConflicts = new CheckBox(MESSAGES.checkIgnoreInstructorAssignmentConflicts());
            this.iIgnoreConflicts.addStyleName("ignore-conflicts");
            this.iIgnoreConflictsRow = this.iForm.addRow((Widget)this.iIgnoreConflicts);
            this.iIgnoreConflicts.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                public void onValueChange(ValueChangeEvent<Boolean> event) {
                    for (int i = 1; i < TeachingRequestDetailPage.this.iAssignmentTable.getRowCount(); ++i) {
                        InstructorInterface.AssignmentInfo ai = (InstructorInterface.AssignmentInfo)TeachingRequestDetailPage.this.iAssignmentTable.getData(i);
                        if (ai == null || ai.getInstructor() != null) continue;
                        TeachingRequestDetailPage.this.iAssignmentTable.getRowFormatter().setVisible(i, (Boolean)event.getValue() == false);
                    }
                }
            });
        }
    }

    protected void setupDomain() {
        this.iDomainHeader = new UniTimeHeaderPanel(MESSAGES.headerAvailableInstructors());
        this.iDomainRow = this.iForm.addHeaderRow((Widget)this.iDomainHeader);
        this.iDomainTable = new UniTimeTable();
        this.iDomainTable.addStyleName("domain");
        this.iForm.addRow((Widget)this.iDomainTable);
        this.iDomainTable.addMouseClickListener(new UniTimeTable.MouseClickListener<InstructorInterface.SuggestionInfo>(){

            @Override
            public void onMouseClick(UniTimeTable.TableEvent<InstructorInterface.SuggestionInfo> event) {
                if (event.getData() != null) {
                    TeachingRequestDetailPage.this.showAssignment(event.getData());
                    TeachingRequestDetailPage.this.computeSuggestions(TeachingRequestDetailPage.this.iAssignmentRow);
                    TeachingRequestDetailPage.this.iScroll.scrollToTop();
                }
            }
        });
        this.iDomainHeader.addButton("more", MESSAGES.buttonMoreAssignments(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (TeachingRequestDetailPage.this.iSuggestionsRequest != null) {
                    TeachingRequestDetailPage.this.iSuggestionsRequest.setMaxDomain(2 * TeachingRequestDetailPage.this.iSuggestionsRequest.getMaxDomain());
                    TeachingRequestDetailPage.this.iSuggestionsRequest.setComputeDomain();
                    TeachingRequestDetailPage.this.computeSuggestions(TeachingRequestDetailPage.this.iSuggestionsRequest, TeachingRequestDetailPage.this.iDomainRow);
                }
            }
        });
        this.iDomainHeader.setEnabled("more", false);
    }

    protected void setupSuggestions() {
        this.iSuggestionsHeader = new UniTimeHeaderPanel(MESSAGES.headerSuggestions());
        this.iSuggestionsRow = this.iForm.addHeaderRow((Widget)this.iSuggestionsHeader);
        this.iSuggestionsTable = new UniTimeTable();
        this.iSuggestionsTable.setVisible(false);
        this.iSuggestionsTable.addStyleName("suggestions");
        ArrayList<UniTimeTableHeader> sgHeader = new ArrayList<UniTimeTableHeader>();
        sgHeader.add(new UniTimeTableHeader(MESSAGES.colScore()));
        sgHeader.add(new UniTimeTableHeader(MESSAGES.colCourse()));
        sgHeader.add(new UniTimeTableHeader(MESSAGES.colSection()));
        sgHeader.add(new UniTimeTableHeader(MESSAGES.colExternalId(), 3));
        sgHeader.add(new UniTimeTableHeader(MESSAGES.colNamePerson(), 3));
        sgHeader.add(new UniTimeTableHeader(MESSAGES.colObjectives()));
        this.iSuggestionsTable.addRow(null, sgHeader);
        this.iForm.addRow((Widget)this.iSuggestionsTable);
        this.iSuggestionsHeader.addButton("longer", MESSAGES.buttonSearchLonger(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (TeachingRequestDetailPage.this.iSuggestionsRequest != null) {
                    TeachingRequestDetailPage.this.iSuggestionsRequest.setTimeout(2 * TeachingRequestDetailPage.this.iSuggestionsRequest.getTimeout());
                    TeachingRequestDetailPage.this.iSuggestionsRequest.setComputeSuggestions();
                    TeachingRequestDetailPage.this.computeSuggestions(TeachingRequestDetailPage.this.iSuggestionsRequest, TeachingRequestDetailPage.this.iSuggestionsRow);
                }
            }
        });
        this.iSuggestionsHeader.addButton("deeper", MESSAGES.buttonSearchDeeper(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (TeachingRequestDetailPage.this.iSuggestionsRequest != null) {
                    TeachingRequestDetailPage.this.iSuggestionsRequest.setMaxDept(1 + TeachingRequestDetailPage.this.iSuggestionsRequest.getMaxDept());
                    TeachingRequestDetailPage.this.iSuggestionsRequest.setComputeSuggestions();
                    TeachingRequestDetailPage.this.computeSuggestions(TeachingRequestDetailPage.this.iSuggestionsRequest, TeachingRequestDetailPage.this.iSuggestionsRow);
                }
            }
        });
        this.iSuggestionsHeader.setEnabled("longer", false);
        this.iSuggestionsHeader.setEnabled("deeper", false);
        this.iSuggestionsTable.addMouseClickListener(new UniTimeTable.MouseClickListener<InstructorInterface.SuggestionInfo>(){

            @Override
            public void onMouseClick(UniTimeTable.TableEvent<InstructorInterface.SuggestionInfo> event) {
                if (event.getData() != null) {
                    TeachingRequestDetailPage.this.showAssignment(event.getData());
                    TeachingRequestDetailPage.this.iScroll.scrollToTop();
                }
            }
        });
    }

    public class Note
    extends P
    implements UniTimeTable.HasColSpan {
        int iColSpan;

        Note(int colspan, String message) {
            super("note");
            this.iColSpan = colspan;
            this.setText(message);
        }

        @Override
        public int getColSpan() {
            return this.iColSpan;
        }
    }

    public class InstructorConflicts
    extends P {
        public InstructorConflicts(List<InstructorInterface.AssignmentInfo> conflicts, int column) {
            super("conflicts");
            for (InstructorInterface.AssignmentInfo conflict : conflicts) {
                P conf = new P("conflict");
                int idx = 0;
                Iterator<InstructorInterface.SectionInfo> i = conflict.getRequest().getSections().iterator();
                while (i.hasNext()) {
                    InstructorInterface.SectionInfo section = i.next();
                    P sct = new P("section");
                    switch (column) {
                        case 0: {
                            if (idx != 0) break;
                            sct.setText(conflict.getRequest().getCourse().getCourseName());
                            break;
                        }
                        case 1: {
                            sct.setText(section.getSectionType() + (section.getExternalId() == null ? "" : " " + section.getExternalId()) + (i.hasNext() ? "," : ""));
                            break;
                        }
                        case 2: {
                            InstructorInterface.InstructorInfo instructor;
                            if (idx != 0 || (instructor = conflict.getRequest().getInstructor(conflict.getIndex())) == null) break;
                            sct.setText(instructor.getInstructorName());
                        }
                    }
                    if (section.isCommon()) {
                        sct.getElement().getStyle().setFontStyle(Style.FontStyle.ITALIC);
                    }
                    ++idx;
                    conf.add((Widget)sct);
                }
                this.add((Widget)conf);
            }
        }
    }

    public class RequestConflicts
    extends P {
        public RequestConflicts(List<InstructorInterface.AssignmentInfo> conflicts, int column) {
            super("conflicts");
            for (InstructorInterface.AssignmentInfo conflict : conflicts) {
                int idx = 0;
                for (InstructorInterface.SectionInfo section : conflict.getRequest().getSections()) {
                    P conf = new P("conflict");
                    switch (column) {
                        case 0: {
                            if (idx == 0) {
                                conf.setText(conflict.getRequest().getCourse().getCourseName());
                                break;
                            }
                            conf.setHTML("<br>");
                            break;
                        }
                        case 1: {
                            conf.setText(section.getSectionType() + (section.getExternalId() == null ? "" : " " + section.getExternalId()));
                            break;
                        }
                        case 2: {
                            conf.setHTML(section.getTime() == null ? SECTMSG.arrangeHours() : section.getTime());
                            break;
                        }
                        case 3: {
                            conf.setHTML(section.getDate() == null ? SECTMSG.noDate() : section.getDate());
                            break;
                        }
                        case 4: {
                            conf.setHTML(section.getRoom() == null ? SECTMSG.noRoom() : section.getRoom());
                            break;
                        }
                        case 5: {
                            if (idx == 0 && conflict.hasConflicts()) {
                                conf.setText(conflict.getConflicts(", "));
                                break;
                            }
                            conf.setHTML("<br>");
                        }
                    }
                    if (section.isCommon()) {
                        conf.getElement().getStyle().setFontStyle(Style.FontStyle.ITALIC);
                    }
                    ++idx;
                    this.add((Widget)conf);
                }
            }
        }
    }
}

