/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.instructor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.instructor.InstructorCookie;
import org.unitime.timetable.gwt.client.instructor.TeachingAssignmentsTable;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.InstructorInterface;

public class TeachingAssignmentsWidget
extends SimpleForm {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private UniTimeHeaderPanel iHeader = new UniTimeHeaderPanel(MESSAGES.sectTeachingAssignments());
    private TeachingAssignmentsTable iTable;
    private String iInstructorId;

    public TeachingAssignmentsWidget() {
        this.iHeader.addCollapsibleHandler(new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                InstructorCookie.getInstance().setShowTeachingAssignments((Boolean)event.getValue());
                if (TeachingAssignmentsWidget.this.iTable != null) {
                    TeachingAssignmentsWidget.this.iTable.setVisible((Boolean)event.getValue());
                } else if (((Boolean)event.getValue()).booleanValue()) {
                    TeachingAssignmentsWidget.this.refresh();
                }
            }
        });
        this.iHeader.setCollapsible(InstructorCookie.getInstance().isShowTeachingAssignments());
        this.iHeader.setTitleStyleName("unitime3-HeaderTitle");
        this.removeStyleName("unitime-NotPrintableBottomLine");
        this.addHeaderRow((Widget)this.iHeader);
        this.iHeader.getElement().getStyle().setMarginTop(10.0, Style.Unit.PX);
    }

    public void insert(RootPanel panel) {
        this.iInstructorId = panel.getElement().getInnerText();
        if (InstructorCookie.getInstance().isShowTeachingAssignments()) {
            this.refresh();
        }
        panel.getElement().setInnerText(null);
        panel.add((Widget)this);
        panel.setVisible(true);
    }

    protected void refresh() {
        this.iHeader.showLoading();
        if (this.iTable == null) {
            this.init();
        } else {
            this.populate();
        }
    }

    protected void init() {
        RPC.execute(new InstructorInterface.TeachingRequestsPagePropertiesRequest(), new AsyncCallback<InstructorInterface.TeachingRequestsPagePropertiesResponse>(){

            public void onFailure(Throwable caught) {
                TeachingAssignmentsWidget.this.iHeader.setErrorMessage(MESSAGES.failedToInitialize(caught.getMessage()));
                TeachingAssignmentsWidget.this.iHeader.setCollapsible(null);
                UniTimeNotifications.error(MESSAGES.failedToInitialize(caught.getMessage()), caught);
                ToolBox.checkAccess(caught);
            }

            public void onSuccess(InstructorInterface.TeachingRequestsPagePropertiesResponse result) {
                TeachingAssignmentsWidget.this.iTable = new TeachingAssignmentsTable(){

                    @Override
                    protected void onAssignmentChanged(List<InstructorInterface.AssignmentInfo> assignments) {
                        if (TeachingAssignmentsWidget.this.iTable.isVisible()) {
                            TeachingAssignmentsWidget.this.refresh();
                        }
                    }
                };
                TeachingAssignmentsWidget.this.iTable.setProperties(result);
                TeachingAssignmentsWidget.this.iTable.setVisible(false);
                TeachingAssignmentsWidget.this.addRow((Widget)TeachingAssignmentsWidget.this.iTable);
                TeachingAssignmentsWidget.this.populate();
            }
        });
    }

    protected void populate() {
        InstructorInterface.TeachingAssignmentsPageRequest req = new InstructorInterface.TeachingAssignmentsPageRequest();
        req.getFilter().setOption("instructorId", this.iInstructorId);
        RPC.execute(req, new AsyncCallback<GwtRpcResponseList<InstructorInterface.InstructorInfo>>(){

            public void onFailure(Throwable caught) {
                TeachingAssignmentsWidget.this.iHeader.setCollapsible(null);
                TeachingAssignmentsWidget.this.iHeader.setErrorMessage(MESSAGES.failedToLoadTeachingRequests(caught.getMessage()));
                UniTimeNotifications.error(MESSAGES.failedToLoadTeachingRequests(caught.getMessage()), caught);
            }

            public void onSuccess(GwtRpcResponseList<InstructorInterface.InstructorInfo> result) {
                TeachingAssignmentsWidget.this.iHeader.clearMessage();
                LoadingWidget.getInstance().hide();
                TeachingAssignmentsWidget.this.iTable.populate(result);
                TeachingAssignmentsWidget.this.iTable.setVisible(true);
            }
        });
    }
}

