/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.form.PreferencesForm;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.TeachingResponsibility;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.model.dao.LocationDAO;
import org.unitime.timetable.util.DynamicList;
import org.unitime.timetable.util.DynamicListObjectFactory;

public class ClassEditForm
extends PreferencesForm {
    private static final long serialVersionUID = 3257849883023915058L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
    private Integer nbrRooms;
    private Integer expectedCapacity;
    private Long classId;
    private Long parentClassId;
    private String section;
    private Long managingDept;
    private Long controllingDept;
    private Long subpart;
    private String className;
    private String parentClassName;
    private String itypeDesc;
    private List instrLead;
    private String managingDeptLabel;
    private String notes;
    private List instructors;
    private List instrPctShare;
    private List assignments;
    private Long datePattern;
    private String subjectAreaId;
    private String instrOfferingId;
    private String courseName;
    private String courseTitle;
    private Boolean displayInstructor;
    private String schedulePrintNote;
    private String classSuffix;
    private Boolean enabledForStudentScheduling;
    private Integer maxExpectedCapacity;
    private Float roomRatio;
    private Integer minRoomLimit;
    private Boolean unlimitedEnroll;
    private Integer enrollment;
    private Integer snapshotLimit;
    private Boolean isCrosslisted;
    private String accommodation;
    private Boolean isCancelled;
    private List instrResponsibility;
    private String defaultTeachingResponsibilityId;
    private String lms;
    protected DynamicListObjectFactory factoryInstructors = new DynamicListObjectFactory(){

        @Override
        public Object create() {
            return new String("-");
        }
    };

    @Override
    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        int iRoomCapacity = -1;
        ActionErrors errors = new ActionErrors();
        if (this.nbrRooms != null && this.nbrRooms < 0) {
            errors.add("nbrRooms", new ActionMessage("errors.generic", (Object)MSG.errorNumberOfRoomsNegative()));
        }
        if (this.roomRatio == null || this.roomRatio.floatValue() < 0.0f) {
            errors.add("nbrRooms", new ActionMessage("errors.generic", (Object)MSG.errorRoomRatioNegative()));
        }
        if (this.expectedCapacity == null || this.expectedCapacity < 0) {
            errors.add("expectedCapacity", new ActionMessage("errors.generic", (Object)MSG.errorMinimumExpectedCapacityNegative()));
        }
        if (this.maxExpectedCapacity == null || this.maxExpectedCapacity < 0) {
            errors.add("maxExpectedCapacity", new ActionMessage("errors.generic", (Object)MSG.errorMaximumExpectedCapacityNegative()));
        } else if (this.maxExpectedCapacity < this.expectedCapacity) {
            errors.add("maxExpectedCapacity", new ActionMessage("errors.generic", (Object)MSG.errorMaximumExpectedCapacityLessThanMinimum()));
        }
        if (this.managingDept == null || this.managingDept <= 0L) {
            errors.add("managingDept", new ActionMessage("errors.generic", (Object)MSG.errorRequiredClassOwner()));
        }
        if (this.schedulePrintNote != null && this.schedulePrintNote.length() > 1999) {
            errors.add("notes", new ActionMessage("errors.generic", (Object)MSG.errorSchedulePrintNoteLongerThan1999()));
        }
        if (this.notes != null && this.notes.length() > 999) {
            errors.add("notes", new ActionMessage("errors.generic", (Object)MSG.errorNotesLongerThan999()));
        }
        if (this.instructors.size() > 0 && !super.checkPrefs(this.instructors, this.instrResponsibility)) {
            errors.add("instructors", new ActionMessage("errors.generic", (Object)MSG.errorInvalidInstructors()));
        }
        if (iRoomCapacity > 0) {
            List rp = this.getRoomPrefs();
            List rpl = this.getRoomPrefLevels();
            for (int i = 0; i < rpl.size(); ++i) {
                String roomId;
                Location room;
                int rCap;
                String pl = rpl.get(i).toString();
                if (!pl.trim().equalsIgnoreCase("1") || (rCap = (room = (Location)new LocationDAO().get(new Long(roomId = rp.get(i).toString()))).getCapacity().intValue()) >= iRoomCapacity) continue;
                errors.add("roomPref", new ActionMessage("errors.generic", (Object)MSG.errorRequiredRoomTooSmall(room.getLabel(), rCap, iRoomCapacity)));
            }
        }
        errors.add((ActionMessages)super.validate(mapping, request));
        return errors;
    }

    @Override
    public void reset(ActionMapping mapping, HttpServletRequest request) {
        this.nbrRooms = null;
        this.expectedCapacity = null;
        this.classId = null;
        this.section = null;
        this.managingDept = null;
        this.controllingDept = null;
        this.subpart = null;
        this.className = "";
        this.courseName = "";
        this.courseTitle = "";
        this.parentClassName = "-";
        this.itypeDesc = "";
        this.datePattern = null;
        this.instrLead = DynamicList.getInstance(new ArrayList(), this.factoryInstructors);
        this.managingDeptLabel = "-";
        this.notes = "";
        this.displayInstructor = null;
        this.schedulePrintNote = null;
        this.classSuffix = null;
        this.enabledForStudentScheduling = null;
        this.maxExpectedCapacity = null;
        this.roomRatio = null;
        this.unlimitedEnroll = null;
        this.isCrosslisted = null;
        this.isCancelled = null;
        this.instructors = DynamicList.getInstance(new ArrayList(), this.factoryInstructors);
        this.instrPctShare = DynamicList.getInstance(new ArrayList(), this.factoryInstructors);
        this.assignments = null;
        this.enrollment = null;
        this.snapshotLimit = null;
        this.accommodation = null;
        this.instrResponsibility = DynamicList.getInstance(new ArrayList(), this.factoryInstructors);
        TeachingResponsibility tr = TeachingResponsibility.getDefaultInstructorTeachingResponsibility();
        this.defaultTeachingResponsibilityId = tr == null ? "" : tr.getUniqueId().toString();
        this.lms = null;
        super.reset(mapping, request);
    }

    public Long getClassId() {
        return this.classId;
    }

    public void setClassId(Long classId) {
        this.classId = classId;
    }

    public String getSection() {
        return this.section;
    }

    public void setSection(String section) {
        this.section = section;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public List getAssignments() {
        return this.assignments;
    }

    public String getAssignments(int key) {
        return this.assignments.get(key).toString();
    }

    public void setAssignments(int key, Object value) {
        this.assignments.set(key, value);
    }

    public void setAssignments(List assignments) {
        this.assignments = assignments;
    }

    public Long getDatePattern() {
        return this.datePattern;
    }

    public void setDatePattern(Long datePattern) {
        this.datePattern = datePattern;
    }

    public Integer getExpectedCapacity() {
        return this.expectedCapacity;
    }

    public void setExpectedCapacity(Integer expectedCapacity) {
        this.expectedCapacity = expectedCapacity;
    }

    public List getInstructors() {
        return this.instructors;
    }

    public String getInstructors(int key) {
        return this.instructors.get(key).toString();
    }

    public void setInstructors(int key, Object value) {
        this.instructors.set(key, value);
    }

    public void setInstructors(List instructors) {
        this.instructors = instructors;
    }

    public List getInstrLead() {
        return this.instrLead;
    }

    public void setInstrLead(List instrLead) {
        this.instrLead = instrLead;
    }

    public void addInstrLead(String instructorId) {
        this.instrLead.add(instructorId);
    }

    public String getInstrLead(int key) {
        return this.instrLead.get(key).toString();
    }

    public void setInstrLead(int key, Object value) {
        this.instrLead.set(key, value);
    }

    public boolean getInstrHasPref(int key) {
        if (!"true".equals(this.getInstrLead(key)) && !"on".equals(this.getInstrLead(key))) {
            return false;
        }
        String instructorId = this.getInstructors(key);
        if (instructorId == null || instructorId.trim().length() == 0 || instructorId.equals("-")) {
            return false;
        }
        DepartmentalInstructor di = (DepartmentalInstructor)new DepartmentalInstructorDAO().get(Long.valueOf(instructorId));
        return di != null && di.hasPreferences();
    }

    public List getInstrPctShare() {
        return this.instrPctShare;
    }

    public String getInstrPctShare(int key) {
        return this.instrPctShare.get(key).toString();
    }

    public void setInstrPctShare(int key, Object value) {
        this.instrPctShare.set(key, value);
    }

    public void setInstrPctShare(List instrPctShare) {
        this.instrPctShare = instrPctShare;
    }

    public Integer getNbrRooms() {
        return this.nbrRooms;
    }

    public void setNbrRooms(Integer nbrRooms) {
        this.nbrRooms = nbrRooms;
    }

    public Long getManagingDept() {
        return this.managingDept;
    }

    public void setManagingDept(Long owner) {
        this.managingDept = owner;
    }

    public String getParentClassName() {
        return this.parentClassName;
    }

    public void setParentClassName(String parentClassName) {
        this.parentClassName = parentClassName;
    }

    public Long getSubpart() {
        return this.subpart;
    }

    public void setSubpart(Long subpart) {
        this.subpart = subpart;
    }

    public String getItypeDesc() {
        return this.itypeDesc;
    }

    public void setItypeDesc(String itypeDesc) {
        this.itypeDesc = itypeDesc;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public String getManagingDeptLabel() {
        return this.managingDeptLabel;
    }

    public void setManagingDeptLabel(String ownerLabel) {
        this.managingDeptLabel = ownerLabel;
    }

    public Long getParentClassId() {
        return this.parentClassId;
    }

    public String getSubjectAreaId() {
        return this.subjectAreaId;
    }

    public void setSubjectAreaId(String subjectAreaId) {
        this.subjectAreaId = subjectAreaId;
    }

    public String getInstrOfferingId() {
        return this.instrOfferingId;
    }

    public void setInstrOfferingId(String instrOfferingId) {
        this.instrOfferingId = instrOfferingId;
    }

    public void setParentClassId(Long parentClassId) {
        this.parentClassId = parentClassId;
    }

    public String getClassSuffix() {
        return this.classSuffix;
    }

    public void setClassSuffix(String classSuffix) {
        this.classSuffix = classSuffix;
    }

    public Boolean getEnabledForStudentScheduling() {
        return this.enabledForStudentScheduling;
    }

    public void setEnabledForStudentScheduling(Boolean enabledForStudentScheduling) {
        this.enabledForStudentScheduling = enabledForStudentScheduling;
    }

    public Boolean getDisplayInstructor() {
        return this.displayInstructor;
    }

    public void setDisplayInstructor(Boolean displayInstructor) {
        this.displayInstructor = displayInstructor;
    }

    public Integer getMaxExpectedCapacity() {
        return this.maxExpectedCapacity;
    }

    public void setMaxExpectedCapacity(Integer maxExpectedCapacity) {
        this.maxExpectedCapacity = maxExpectedCapacity;
    }

    public Float getRoomRatio() {
        return this.roomRatio;
    }

    public void setRoomRatio(Float roomRatio) {
        this.roomRatio = roomRatio;
    }

    public String getSchedulePrintNote() {
        return this.schedulePrintNote;
    }

    public void setSchedulePrintNote(String schedulePrintNote) {
        this.schedulePrintNote = schedulePrintNote;
    }

    public Integer getMinRoomLimit() {
        return this.minRoomLimit;
    }

    public void setMinRoomLimit(Integer minRoomLimit) {
        this.minRoomLimit = minRoomLimit;
    }

    public Boolean getUnlimitedEnroll() {
        return this.unlimitedEnroll;
    }

    public void setUnlimitedEnroll(Boolean unlimitedEnroll) {
        this.unlimitedEnroll = unlimitedEnroll;
    }

    public Boolean getIsCrosslisted() {
        return this.isCrosslisted;
    }

    public void setIsCrosslisted(Boolean isCrosslisted) {
        this.isCrosslisted = isCrosslisted;
    }

    public Boolean getIsCancelled() {
        return this.isCancelled;
    }

    public void setIsCancelled(Boolean isCancelled) {
        this.isCancelled = isCancelled;
    }

    public String dateToStr(java.util.Date date) {
        if (date == null) {
            return "";
        }
        return this.dateFormat.format(date);
    }

    public Date strToDate(String date) throws ParseException {
        Date dt = null;
        if (date == null || date.trim().length() == 0) {
            return null;
        }
        dt = new Date(this.dateFormat.parse(date).getTime());
        return dt;
    }

    public void addToInstructors(ClassInstructor classInstr) {
        String id = "";
        String pctShare = "0";
        boolean isLead = false;
        String resp = "";
        if (classInstr != null) {
            id = classInstr.getInstructor().getUniqueId().toString();
            pctShare = classInstr.getPercentShare().toString();
            isLead = classInstr.isLead();
            if (classInstr.getResponsibility() != null) {
                resp = classInstr.getResponsibility().getUniqueId().toString();
            }
        } else {
            if (this.instructors.size() == 0) {
                pctShare = "100";
                isLead = true;
            }
            resp = this.getDefaultTeachingResponsibilityId();
        }
        this.instructors.add(id);
        this.instrPctShare.add(pctShare);
        this.instrLead.add(isLead ? "true" : "false");
        this.instrResponsibility.add(resp);
    }

    public void removeInstructor(int deleteId) {
        this.instructors.remove(deleteId);
        this.instrPctShare.remove(deleteId);
        if (this.instrLead.size() > deleteId) {
            this.instrLead.remove(deleteId);
        }
        this.instrResponsibility.remove(deleteId);
    }

    @Override
    public void clearPrefs() {
        this.instructors.clear();
        this.instrPctShare.clear();
        this.instrLead.clear();
        this.instrResponsibility.clear();
    }

    public String getCourseName() {
        return this.courseName;
    }

    public void setCourseName(String courseName) {
        this.courseName = courseName;
    }

    public String getCourseTitle() {
        return this.courseTitle;
    }

    public void setCourseTitle(String courseTitle) {
        this.courseTitle = courseTitle;
    }

    public Integer getEnrollment() {
        return this.enrollment;
    }

    public void setEnrollment(Integer enrollment) {
        this.enrollment = enrollment;
    }

    public Integer getSnapshotLimit() {
        return this.snapshotLimit;
    }

    public void setSnapshotLimit(Integer snapshotLimit) {
        this.snapshotLimit = snapshotLimit;
    }

    public String getAccommodation() {
        return this.accommodation;
    }

    public void setAccommodation(String accommodation) {
        this.accommodation = accommodation;
    }

    public Long getControllingDept() {
        return this.controllingDept;
    }

    public void setControllingDept(Long deptId) {
        this.controllingDept = deptId;
    }

    public List getInstrResponsibility() {
        return this.instrResponsibility;
    }

    public String getInstrResponsibility(int key) {
        return this.instrResponsibility.get(key).toString();
    }

    public void setInstrResponsibility(int key, Object value) {
        this.instrResponsibility.set(key, value);
    }

    public void setInstrResponsibility(List instrResponsibility) {
        this.instrResponsibility = instrResponsibility;
    }

    public String getDefaultTeachingResponsibilityId() {
        return this.defaultTeachingResponsibilityId;
    }

    public void setDefaultTeachingResponsibilityId(String defaultTeachingResponsibilityId) {
        this.defaultTeachingResponsibilityId = defaultTeachingResponsibilityId;
    }

    public String getLms() {
        return this.lms;
    }

    public void setLms(String lms) {
        this.lms = lms;
    }
}

