/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.filter;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.unitime.timetable.security.UserContext;

public class MessageLogFilter
implements Filter {
    public void init(FilterConfig config) throws ServletException {
    }

    public void destroy() {
        Enumeration e = LogManager.getCurrentLoggers();
        while (e.hasMoreElements()) {
            Logger logger = (Logger)e.nextElement();
            logger.removeAppender("mlog");
        }
        LogManager.getRootLogger().removeAppender("mlog");
    }

    private UserContext getUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null && authentication.isAuthenticated() && authentication.getPrincipal() instanceof UserContext) {
            return (UserContext)authentication.getPrincipal();
        }
        return null;
    }

    private int ndcPush() {
        int count = 0;
        try {
            UserContext user = this.getUser();
            if (user != null) {
                NDC.push((String)("uid:" + user.getTrueExternalUserId()));
                ++count;
                if (user.getCurrentAuthority() != null) {
                    NDC.push((String)("role:" + user.getCurrentAuthority().getRole()));
                    ++count;
                    Long sessionId = user.getCurrentAcademicSessionId();
                    if (sessionId != null) {
                        NDC.push((String)("sid:" + sessionId));
                        ++count;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return count;
    }

    private void ndcPop(int count) {
        for (int i = 0; i < count; ++i) {
            NDC.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        int count = this.ndcPush();
        try {
            chain.doFilter(request, response);
        }
        finally {
            this.ndcPop(count);
        }
    }
}

