/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.export.students;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.export.CSVPrinter;
import org.unitime.timetable.export.ExportHelper;
import org.unitime.timetable.export.Exporter;
import org.unitime.timetable.gwt.client.sectioning.SectioningStatusFilterBox;
import org.unitime.timetable.gwt.client.sectioning.SectioningStatusPage;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.services.SectioningService;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.security.UserAuthority;
import org.unitime.timetable.security.qualifiers.SimpleQualifier;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.Formats;

@Service(value="org.unitime.timetable.export.Exporter:student-dashboard.csv")
public class StudentSchedulingDashboardExportCSV
implements Exporter {
    protected static StudentSectioningMessages MESSAGES = Localization.create(StudentSectioningMessages.class);
    protected static StudentSectioningConstants CONSTANTS = Localization.create(StudentSectioningConstants.class);
    protected static DecimalFormat sCreditFormat = new DecimalFormat("0.#");
    @Autowired
    private ApplicationContext applicationContext;

    @Override
    public String reference() {
        return "student-dashboard.csv";
    }

    @Override
    public void export(ExportHelper helper) throws IOException {
        int n;
        boolean online = "1".equals(helper.getParameter("online"));
        Long sessionId = helper.getAcademicSessionId();
        if (sessionId != null && helper.getSessionContext().isAuthenticated() && !sessionId.equals(helper.getSessionContext().getUser().getCurrentAcademicSessionId())) {
            UserAuthority preferredAuthority = null;
            for (UserAuthority userAuthority : helper.getSessionContext().getUser().getAuthorities(null, new SimpleQualifier("Session", sessionId))) {
                if (preferredAuthority == null && userAuthority.hasRight(Right.StudentSectioningSolverDashboard)) {
                    preferredAuthority = userAuthority;
                    continue;
                }
                if ((preferredAuthority == null || !preferredAuthority.hasRight(Right.StudentSchedulingAdmin)) && userAuthority.hasRight(Right.StudentSchedulingAdvisor)) {
                    preferredAuthority = userAuthority;
                    continue;
                }
                if (!userAuthority.hasRight(Right.StudentSchedulingAdmin)) continue;
                preferredAuthority = userAuthority;
            }
            if (preferredAuthority != null) {
                helper.getSessionContext().getUser().setCurrentAuthority(preferredAuthority);
            }
        }
        int tab = 0;
        try {
            tab = Integer.parseInt(helper.getParameter("tab"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        String query = helper.getParameter("query");
        if (query == null) {
            query = "";
        }
        boolean bl = false;
        try {
            n = Integer.parseInt(helper.getParameter("sort"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        SectioningStatusFilterBox.SectioningStatusFilterRpcRequest filter = new SectioningStatusFilterBox.SectioningStatusFilterRpcRequest();
        Enumeration<String> e = helper.getParameterNames();
        while (e.hasMoreElements()) {
            String command = e.nextElement();
            if (command.equals("f:text")) {
                filter.setText(helper.getParameter("e:text"));
                continue;
            }
            if (!command.startsWith("f:")) continue;
            for (String value : helper.getParameterValues(command)) {
                filter.addOption(command.substring(2), value);
            }
        }
        SectioningService service = (SectioningService)this.applicationContext.getBean("sectioning.gwt");
        if (tab == 0) {
            List<ClassAssignmentInterface.EnrollmentInfo> enrollments;
            HashSet<Long> courseIds = new HashSet<Long>();
            if (helper.getParameter("c") != null) {
                for (String value : helper.getParameterValues("c")) {
                    courseIds.add(Long.valueOf(value));
                }
            }
            if ((enrollments = service.findEnrollmentInfos(online, query, filter, null)) != null && n != 0) {
                boolean asc = n > 0;
                SectioningStatusPage.EnrollmentComparator.SortBy sortBy = SectioningStatusPage.EnrollmentComparator.SortBy.values()[Math.abs(n) - 1];
                Collections.sort(enrollments, new SectioningStatusPage.EnrollmentComparator(sortBy, asc));
                if (!asc) {
                    Collections.reverse(enrollments);
                }
            }
            if (!courseIds.isEmpty() && enrollments != null) {
                ArrayList<ClassAssignmentInterface.EnrollmentInfo> allEnrollments = new ArrayList<ClassAssignmentInterface.EnrollmentInfo>();
                for (ClassAssignmentInterface.EnrollmentInfo e2 : enrollments) {
                    List<ClassAssignmentInterface.EnrollmentInfo> classEnrollments;
                    allEnrollments.add(e2);
                    if (e2.getCourseId() == null || !courseIds.contains(e2.getCourseId()) || (classEnrollments = service.findEnrollmentInfos(online, query, filter, e2.getCourseId())) == null) continue;
                    allEnrollments.addAll(classEnrollments);
                }
                this.populateCourseTable(helper, allEnrollments);
            } else {
                this.populateCourseTable(helper, enrollments);
            }
        } else if (tab == 1) {
            List<ClassAssignmentInterface.StudentInfo> students = service.findStudentInfos(online, query, filter);
            if (students != null && n != 0) {
                boolean asc = n > 0;
                SectioningStatusPage.StudentComparator.SortBy sortBy = SectioningStatusPage.StudentComparator.SortBy.values()[Math.abs(n) - 1];
                Collections.sort(students, new SectioningStatusPage.StudentComparator(sortBy, asc, helper.getParameter("g")));
                if (!asc) {
                    Collections.reverse(students);
                }
            }
            this.populateStudentTable(helper, online, students);
        } else if (online) {
            List<ClassAssignmentInterface.SectioningAction> changelog = service.changeLog(query);
            if (changelog != null && n != 0) {
                boolean asc = n > 0;
                SectioningStatusPage.ChangeLogComparator.SortBy sortBy = SectioningStatusPage.ChangeLogComparator.SortBy.values()[Math.abs(n) - 1];
                Collections.sort(changelog, new SectioningStatusPage.ChangeLogComparator(sortBy));
                if (!asc) {
                    Collections.reverse(changelog);
                }
            }
            this.populateChangeLogTable(helper, changelog);
        } else {
            throw new IllegalArgumentException("Wrong tab and online parameter combination.");
        }
    }

    protected void populateCourseTable(ExportHelper helper, List<ClassAssignmentInterface.EnrollmentInfo> enrollments) throws IOException {
        CSVPrinter out = new CSVPrinter(helper, false);
        helper.setup(out.getContentType(), this.reference(), false);
        out.printHeader(MESSAGES.colSubject() + "\n  " + MESSAGES.colSubpart(), MESSAGES.colCourse() + "\n" + MESSAGES.colClass(), MESSAGES.colTitle() + "\n" + MESSAGES.colTime(), "\n" + MESSAGES.colDate(), MESSAGES.colConsent() + "\n" + MESSAGES.colRoom(), MESSAGES.colAvailable(), MESSAGES.colProjection(), MESSAGES.colEnrollment(), MESSAGES.colWaitListed(), MESSAGES.colUnassignedAlternative().replace("<br>", "\n"), MESSAGES.colReserved(), MESSAGES.colNeedConsent().replace("<br>", "\n"), MESSAGES.colNeedOverride().replace("<br>", "\n"));
        out.flush();
        if (enrollments != null) {
            for (ClassAssignmentInterface.EnrollmentInfo e : enrollments) {
                if (e.getConfigId() == null) {
                    out.printLine(e.getSubject(), e.getCourseNbr(), e.getTitle(), "", e.getConsent(), e.getCourseId() == null ? this.number(e.getAvailable(), e.getLimit()) : this.available(e), this.number(null, e.getProjection()), this.number(e.getEnrollment(), e.getTotalEnrollment()), this.waitlist(e), this.number(e.getUnassignedAlternative(), e.getTotalUnassignedAlternative()), this.number(e.getReservation(), e.getTotalReservation()), this.number(e.getConsentNeeded(), e.getTotalConsentNeeded()), this.number(e.getOverrideNeeded(), e.getTotalOverrideNeeded()));
                    continue;
                }
                out.printLine("  " + (e.getSubpart() == null ? "" : e.getIndent("  ") + e.getSubpart()), e.getClazz() == null ? "" : e.getIndent("  ") + e.getClazz(), e.getAssignment().getDays().isEmpty() ? "" : e.getAssignment().getDaysString(CONSTANTS.shortDays()) + " " + e.getAssignment().getStartString(CONSTANTS.useAmPm()) + " - " + e.getAssignment().getEndString(CONSTANTS.useAmPm()), !e.getAssignment().hasDatePattern() ? "" : e.getAssignment().getDatePattern(), e.getAssignment().getRooms(","), e.getCourseId() == null ? this.number(e.getAvailable(), e.getLimit()) : this.available(e), this.number(null, e.getProjection()), this.number(e.getEnrollment(), e.getTotalEnrollment()), this.waitlist(e), this.number(e.getUnassignedAlternative(), e.getTotalUnassignedAlternative()), this.number(e.getReservation(), e.getTotalReservation()), this.number(e.getConsentNeeded(), e.getTotalConsentNeeded()), this.number(e.getOverrideNeeded(), e.getTotalOverrideNeeded()));
            }
        }
        out.flush();
        out.close();
    }

    protected void populateStudentTable(ExportHelper helper, boolean online, List<ClassAssignmentInterface.StudentInfo> students) throws IOException {
        CSVPrinter out = new CSVPrinter(helper, false);
        helper.setup(out.getContentType(), this.reference(), false);
        boolean hasExtId = false;
        boolean hasEnrollment = false;
        boolean hasWaitList = false;
        boolean hasArea = false;
        boolean hasMajor = false;
        boolean hasGroup = false;
        boolean hasAcmd = false;
        boolean hasReservation = false;
        boolean hasRequestedDate = false;
        boolean hasEnrolledDate = false;
        boolean hasConsent = false;
        boolean hasReqCredit = false;
        boolean hasCredit = false;
        boolean hasDistances = false;
        boolean hasOverlaps = false;
        boolean hasFreeTimeOverlaps = false;
        boolean hasPrefIMConfs = false;
        boolean hasPrefSecConfs = false;
        boolean hasNote = false;
        boolean hasEmailed = false;
        boolean hasOverride = false;
        boolean hasAdvisor = false;
        TreeSet<String> groupTypes = new TreeSet<String>();
        if (students != null) {
            for (ClassAssignmentInterface.StudentInfo e : students) {
                if (e.getStudent() == null) continue;
                if (e.getTotalEnrollment() != null && e.getTotalEnrollment() > 0) {
                    hasEnrollment = true;
                }
                if (e.getTotalUnassigned() != null && e.getTotalUnassigned() > 0) {
                    hasWaitList = true;
                }
                if (e.getStudent().hasArea()) {
                    hasArea = true;
                }
                if (e.getStudent().hasMajor()) {
                    hasMajor = true;
                }
                if (e.getStudent().hasGroup()) {
                    hasGroup = true;
                }
                if (e.getStudent().hasAccommodation()) {
                    hasAcmd = true;
                }
                if (e.getTotalReservation() != null && e.getTotalReservation() > 0) {
                    hasReservation = true;
                }
                if (e.getRequestedDate() != null) {
                    hasRequestedDate = true;
                }
                if (e.getEnrolledDate() != null) {
                    hasEnrolledDate = true;
                }
                if (e.getTotalConsentNeeded() != null && e.getTotalConsentNeeded() > 0) {
                    hasConsent = true;
                }
                if (e.getTotalOverrideNeeded() != null && e.getTotalOverrideNeeded() > 0) {
                    hasOverride = true;
                }
                if (e.hasTotalRequestCredit()) {
                    hasReqCredit = true;
                }
                if (e.hasTotalCredit()) {
                    hasCredit = true;
                }
                if (e.hasTotalDistanceConflicts()) {
                    hasDistances = true;
                }
                if (e.hasOverlappingMinutes()) {
                    hasOverlaps = true;
                }
                if (e.hasFreeTimeOverlappingMins()) {
                    hasFreeTimeOverlaps = true;
                }
                if (e.hasTotalPrefInstrMethConflict()) {
                    hasPrefIMConfs = true;
                }
                if (e.hasTotalPrefSectionConflict()) {
                    hasPrefSecConfs = true;
                }
                if (e.hasNote()) {
                    hasNote = true;
                }
                if (e.getEmailDate() != null) {
                    hasEmailed = true;
                }
                if (e.getStudent() != null && e.getStudent().isCanShowExternalId()) {
                    hasExtId = true;
                }
                if (e.getStudent().hasGroups()) {
                    groupTypes.addAll(e.getStudent().getGroupTypes());
                }
                if (!e.getStudent().hasAdvisor()) continue;
                hasAdvisor = true;
            }
        }
        ArrayList<String> header = new ArrayList<String>();
        if (hasExtId) {
            header.add(MESSAGES.colStudentExternalId());
        }
        header.add(MESSAGES.colStudent());
        if (hasArea) {
            header.add(MESSAGES.colArea());
            header.add(MESSAGES.colClassification());
        }
        if (hasMajor) {
            header.add(MESSAGES.colMajor());
        }
        if (hasGroup) {
            header.add(MESSAGES.colGroup());
        }
        header.addAll(groupTypes);
        if (hasAcmd) {
            header.add(MESSAGES.colAccommodation());
        }
        header.add(MESSAGES.colStatus());
        if (hasEnrollment) {
            header.add(MESSAGES.colEnrollment());
        }
        if (hasWaitList) {
            header.add(MESSAGES.colWaitListed());
        }
        if (hasReservation) {
            header.add(MESSAGES.colReservation());
        }
        if (hasConsent) {
            header.add(MESSAGES.colConsent());
        }
        if (hasOverride) {
            header.add(MESSAGES.colPendingOverrides().replace("<br>", "\n"));
        }
        if (hasReqCredit) {
            header.add(MESSAGES.colRequestCredit().replace("<br>", "\n"));
        }
        if (hasCredit) {
            header.add(MESSAGES.colEnrollCredit().replace("<br>", "\n"));
        }
        if (hasDistances) {
            header.add(MESSAGES.colDistanceConflicts().replace("<br>", "\n"));
            header.add(MESSAGES.colLongestDistance().replace("<br>", "\n"));
        }
        if (hasOverlaps) {
            header.add(MESSAGES.colOverlapMins());
        }
        if (hasFreeTimeOverlaps) {
            header.add(MESSAGES.colFreeTimeOverlapMins());
        }
        if (hasPrefIMConfs) {
            header.add(MESSAGES.colPrefInstrMethConfs().replace("<br>", "\n"));
        }
        if (hasPrefSecConfs) {
            header.add(MESSAGES.colPrefSectionConfs().replace("<br>", "\n"));
        }
        if (hasRequestedDate) {
            header.add(MESSAGES.colRequestTimeStamp());
        }
        if (hasEnrolledDate) {
            header.add(MESSAGES.colEnrollmentTimeStamp());
        }
        if (hasAdvisor) {
            header.add(MESSAGES.colAdvisor());
        }
        if (hasNote) {
            header.add(MESSAGES.colStudentNote());
        }
        if (hasEmailed) {
            header.add(MESSAGES.colEmailTimeStamp());
        }
        out.printHeader(header.toArray(new String[header.size()]));
        out.flush();
        Formats.Format<Date> df = Formats.getDateFormat(Formats.Pattern.DATE_REQUEST);
        if (students != null) {
            for (ClassAssignmentInterface.StudentInfo info : students) {
                ArrayList<String> line = new ArrayList<String>();
                if (info.getStudent() != null) {
                    if (hasExtId) {
                        line.add(info.getStudent().isCanShowExternalId() ? info.getStudent().getExternalId() : "");
                    }
                    line.add(info.getStudent().getName());
                    if (hasArea) {
                        line.add(info.getStudent().getArea("\n"));
                        line.add(info.getStudent().getClassification("\n"));
                    }
                    if (hasMajor) {
                        line.add(info.getStudent().getMajor("\n"));
                    }
                    if (hasGroup) {
                        line.add(info.getStudent().getGroup("\n"));
                    }
                    for (String g : groupTypes) {
                        line.add(info.getStudent().getGroup(g, "\n"));
                    }
                    if (hasAcmd) {
                        line.add(info.getStudent().getAccommodation("\n"));
                    }
                    line.add(info.getStatus());
                    if (hasEnrollment) {
                        line.add(this.number(info.getEnrollment(), info.getTotalEnrollment()));
                    }
                    if (hasWaitList) {
                        line.add(this.waitlist(info));
                    }
                    if (hasReservation) {
                        line.add(this.number(info.getReservation(), info.getTotalReservation()));
                    }
                    if (hasConsent) {
                        line.add(this.number(info.getConsentNeeded(), info.getTotalConsentNeeded()));
                    }
                    if (hasOverride) {
                        line.add(this.number(info.getOverrideNeeded(), info.getTotalOverrideNeeded()));
                    }
                    if (hasReqCredit) {
                        line.add(this.reqCredit(info.getRequestCreditMin(), info.getRequestCreditMax(), info.getTotalRequestCreditMin(), info.getTotalRequestCreditMax()));
                    }
                    if (hasCredit) {
                        line.add(this.credit(info));
                    }
                    if (hasDistances) {
                        line.add(this.number(info.getNrDistanceConflicts(), info.getTotalNrDistanceConflicts()));
                        line.add(this.number(info.getLongestDistanceMinutes(), info.getTotalLongestDistanceMinutes()));
                    }
                    if (hasOverlaps) {
                        line.add(this.number(info.getOverlappingMinutes(), info.getTotalOverlappingMinutes()));
                    }
                    if (hasFreeTimeOverlaps) {
                        line.add(this.number(info.getFreeTimeOverlappingMins(), info.getTotalFreeTimeOverlappingMins()));
                    }
                    if (hasPrefIMConfs) {
                        line.add(this.number(info.getPrefInstrMethConflict(), info.getTotalPrefInstrMethConflict()));
                    }
                    if (hasPrefSecConfs) {
                        line.add(this.number(info.getPrefSectionConflict(), info.getTotalPrefSectionConflict()));
                    }
                    if (hasRequestedDate) {
                        line.add(info.getRequestedDate() == null ? null : df.format(info.getRequestedDate()));
                    }
                    if (hasEnrolledDate) {
                        line.add(info.getEnrolledDate() == null ? null : df.format(info.getEnrolledDate()));
                    }
                    if (hasAdvisor) {
                        line.add(info.getStudent().getAdvisor("\n"));
                    }
                    if (hasNote) {
                        line.add(info.hasNote() ? info.getNote() : "");
                    }
                    if (hasEmailed) {
                        line.add(info.getEmailDate() == null ? null : df.format(info.getEmailDate()));
                    }
                } else {
                    line.add(MESSAGES.total());
                    if (hasExtId) {
                        line.add("");
                    }
                    line.add(this.number(null, students.size() - 1));
                    if (hasArea) {
                        line.add("");
                        line.add("");
                    }
                    if (hasMajor) {
                        line.add("");
                    }
                    if (hasGroup) {
                        line.add("");
                    }
                    for (String g : groupTypes) {
                        line.add("");
                    }
                    if (hasAcmd) {
                        line.add("");
                    }
                    if (hasEnrollment) {
                        line.add(this.number(info.getEnrollment(), info.getTotalEnrollment()));
                    }
                    if (hasWaitList) {
                        line.add(this.waitlist(info));
                    }
                    if (hasReservation) {
                        line.add(this.number(info.getReservation(), info.getTotalReservation()));
                    }
                    if (hasConsent) {
                        line.add(this.number(info.getConsentNeeded(), info.getTotalConsentNeeded()));
                    }
                    if (hasOverride) {
                        line.add(this.number(info.getOverrideNeeded(), info.getTotalOverrideNeeded()));
                    }
                    if (hasReqCredit) {
                        line.add(this.reqCredit(info.getRequestCreditMin(), info.getRequestCreditMax(), info.getTotalRequestCreditMin(), info.getTotalRequestCreditMax()));
                    }
                    if (hasCredit) {
                        line.add(this.credit(info));
                    }
                    if (hasDistances) {
                        line.add(this.number(info.getNrDistanceConflicts(), info.getTotalNrDistanceConflicts()));
                        line.add(this.number(info.getLongestDistanceMinutes(), info.getTotalLongestDistanceMinutes()));
                    }
                    if (hasOverlaps) {
                        line.add(this.number(info.getOverlappingMinutes(), info.getTotalOverlappingMinutes()));
                    }
                    if (hasFreeTimeOverlaps) {
                        line.add(this.number(info.getFreeTimeOverlappingMins(), info.getTotalFreeTimeOverlappingMins()));
                    }
                    if (hasPrefIMConfs) {
                        line.add(this.number(info.getPrefInstrMethConflict(), info.getTotalPrefInstrMethConflict()));
                    }
                    if (hasPrefSecConfs) {
                        line.add(this.number(info.getPrefSectionConflict(), info.getTotalPrefSectionConflict()));
                    }
                    if (hasRequestedDate) {
                        line.add("");
                    }
                    if (hasEnrolledDate) {
                        line.add("");
                    }
                    if (hasNote) {
                        line.add("");
                    }
                    if (hasAdvisor) {
                        line.add("");
                    }
                    if (hasEmailed) {
                        line.add("");
                    }
                }
                out.printLine(line.toArray(new String[line.size()]));
            }
        }
        out.flush();
        out.close();
    }

    protected void populateChangeLogTable(ExportHelper helper, List<ClassAssignmentInterface.SectioningAction> changelog) throws IOException {
        CSVPrinter out = new CSVPrinter(helper, false);
        helper.setup(out.getContentType(), this.reference(), false);
        boolean hasExtId = false;
        if (changelog != null) {
            for (ClassAssignmentInterface.SectioningAction e : changelog) {
                if (e.getStudent() == null || !e.getStudent().isCanShowExternalId()) continue;
                hasExtId = true;
                break;
            }
        }
        if (!hasExtId) {
            out.hideColumn(0);
        }
        out.printHeader(MESSAGES.colStudentExternalId(), MESSAGES.colStudent(), MESSAGES.colOperation(), MESSAGES.colTimeStamp(), MESSAGES.colExecutionTime(), MESSAGES.colResult(), MESSAGES.colUser(), MESSAGES.colMessage());
        out.flush();
        Formats.Format<Date> df = Formats.getDateFormat(Formats.Pattern.DATE_TIME_STAMP);
        Formats.Format<Number> nf = Formats.getNumberFormat(CONSTANTS.executionTimeFormat());
        if (changelog != null) {
            for (ClassAssignmentInterface.SectioningAction log : changelog) {
                out.printLine(log.getStudent().isCanShowExternalId() ? log.getStudent().getExternalId() : null, log.getStudent().getName(), log.getOperation(), df.format(log.getTimeStamp()), log.getWallTime() == null ? "" : nf.format(0.001 * (double)log.getWallTime().longValue()), log.getResult(), log.getUser(), log.getMessage() == null ? null : log.getMessage().replace("<br>", "\n"));
            }
        }
        out.flush();
        out.close();
    }

    public String number(Integer value, Integer total) {
        if (value == null) {
            if (total != null) {
                return total == 0 ? "-" : (total < 0 ? "\u221e" : total.toString());
            }
            return null;
        }
        if (value.equals(total)) {
            return total == 0 ? "-" : (total < 0 ? "\u221e" : total.toString());
        }
        return (value < 0 ? "\u221e" : value.toString()) + " / " + (total < 0 ? "\u221e" : total.toString());
    }

    public String available(ClassAssignmentInterface.EnrollmentInfo e) {
        int other;
        int n = other = e.getOther() == null ? 0 : e.getOther();
        if (e.getLimit() == null) {
            return "-";
        }
        if (e.getLimit() < 0) {
            if (e.getAvailable() != null && e.getAvailable() == 0) {
                return "\u221e" + MESSAGES.csvReservationSign();
            }
            return "\u221e";
        }
        if (e.getAvailable() == e.getLimit() - e.getTotalEnrollment() - other) {
            return e.getAvailable() + " / " + e.getLimit();
        }
        if (e.getAvailable() == 0 && e.getLimit() > e.getTotalEnrollment() + other) {
            return e.getLimit() - e.getTotalEnrollment() - other + MESSAGES.csvReservationSign() + " / " + e.getLimit();
        }
        return e.getAvailable() + " + " + (e.getLimit() - e.getTotalEnrollment() - e.getAvailable() - other) + MESSAGES.csvReservationSign() + " / " + e.getLimit();
    }

    public String waitlist(int wait, int tWait, int unasg, int tUnasg, Integer topWaitingPriority) {
        if (tWait == 0 || tWait == tUnasg) {
            if (unasg == tUnasg) {
                return (unasg == 0 ? "-" : String.valueOf(unasg)) + (tWait > 0 ? MESSAGES.csvWaitListSign() : "") + (topWaitingPriority != null ? MESSAGES.csvFirstWaitListedPrioritySign(topWaitingPriority) : "");
            }
            return unasg + " / " + tUnasg + (tWait > 0 ? MESSAGES.csvWaitListSign() : "") + (topWaitingPriority != null ? MESSAGES.csvFirstWaitListedPrioritySign(topWaitingPriority) : "");
        }
        if (wait == tWait && unasg == tUnasg) {
            return (wait == 0 ? String.valueOf(unasg) : (wait == unasg ? wait + MESSAGES.csvWaitListSign() : unasg - wait + " + " + wait + MESSAGES.csvWaitListSign())) + (topWaitingPriority != null ? MESSAGES.csvFirstWaitListedPrioritySign(topWaitingPriority) : "");
        }
        return (wait == 0 ? String.valueOf(unasg) : (wait == unasg ? wait + MESSAGES.csvWaitListSign() : unasg - wait + " + " + wait + MESSAGES.csvWaitListSign())) + " / " + tUnasg + (topWaitingPriority != null ? MESSAGES.csvFirstWaitListedPrioritySign(topWaitingPriority) : "");
    }

    public String waitlist(ClassAssignmentInterface.StudentInfo e) {
        return this.waitlist(e.hasWaitlist() ? e.getWaitlist() : 0, e.hasTotalWaitlist() ? e.getTotalWaitlist() : 0, e.hasUnassigned() ? e.getUnassigned() : 0, e.hasTotalUnassigned() ? e.getTotalUnassigned() : 0, e.getTopWaitingPriority());
    }

    public String waitlist(ClassAssignmentInterface.EnrollmentInfo e) {
        return this.waitlist(e.hasWaitlist() ? e.getWaitlist() : 0, e.hasTotalWaitlist() ? e.getTotalWaitlist() : 0, e.hasUnassigned() ? e.getUnassignedPrimary() : 0, e.hasTotalUnassigned() ? e.getTotalUnassignedPrimary() : 0, null);
    }

    public String reqCredit(float min, float max, float totalMin, float totalMax) {
        if (totalMax > 0.0f) {
            if (min == totalMin && max == totalMax) {
                return totalMin == totalMax ? sCreditFormat.format(totalMin) : sCreditFormat.format(totalMin) + " - " + sCreditFormat.format(totalMax);
            }
            return (min == max ? sCreditFormat.format(min) : sCreditFormat.format(min) + " - " + sCreditFormat.format(max)) + " / " + (totalMin == totalMax ? sCreditFormat.format(totalMin) : sCreditFormat.format(totalMin) + " - " + sCreditFormat.format(totalMax));
        }
        return null;
    }

    public String credit(ClassAssignmentInterface.StudentInfo info) {
        Float value = info.getCredit();
        Float total = info.getTotalCredit();
        if (total != null && total.floatValue() > 0.0f) {
            if (total.equals(value)) {
                String html = sCreditFormat.format(total);
                if (info.hasIMTotalCredit()) {
                    html = html + " (";
                    Iterator<String> i = info.getTotalCreditIMs().iterator();
                    while (i.hasNext()) {
                        String im = i.next();
                        html = html + im + ": " + sCreditFormat.format(info.getIMTotalCredit(im));
                        if (!i.hasNext()) continue;
                        html = html + ", ";
                    }
                    html = html + ")";
                }
                return html;
            }
            String html = sCreditFormat.format(value) + " / " + sCreditFormat.format(total);
            if (info.hasIMCredit()) {
                html = html + " (";
                Iterator<String> i = info.getCreditIMs().iterator();
                while (i.hasNext()) {
                    String im = i.next();
                    html = html + im + ": " + sCreditFormat.format(info.getIMCredit(im));
                    if (!i.hasNext()) continue;
                    html = html + ", ";
                }
                html = html + ")";
            }
            return html;
        }
        return "";
    }
}

