/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.export.events;

import biweekly.ICalVersion;
import biweekly.ICalendar;
import biweekly.component.VEvent;
import biweekly.io.text.ICalWriter;
import biweekly.parameter.Role;
import biweekly.property.Attendee;
import biweekly.property.CalendarScale;
import biweekly.property.DateEnd;
import biweekly.property.DateStart;
import biweekly.property.DateTimeStamp;
import biweekly.property.ExceptionDates;
import biweekly.property.ICalProperty;
import biweekly.property.Method;
import biweekly.property.Organizer;
import biweekly.property.RecurrenceId;
import biweekly.property.Status;
import biweekly.util.Recurrence;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.springframework.stereotype.Service;
import org.unitime.commons.CalendarVTimeZoneGenerator;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.export.ExportHelper;
import org.unitime.timetable.export.events.EventsExporter;
import org.unitime.timetable.gwt.client.events.EventComparator;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Curriculum;
import org.unitime.timetable.model.CurriculumClassification;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.StudentGroup;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.CurriculumClassificationDAO;
import org.unitime.timetable.model.dao.CurriculumDAO;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.model.dao.LocationDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.StudentGroupDAO;
import org.unitime.timetable.model.dao.SubjectAreaDAO;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.util.Constants;

@Service(value="org.unitime.timetable.export.Exporter:events.ics")
public class EventsExportEventsToICal
extends EventsExporter {
    private static Logger sLog = Logger.getLogger(EventsExportEventsToICal.class);

    @Override
    public String reference() {
        return "events.ics";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void print(ExportHelper helper, EventInterface.EventLookupRpcRequest request, List<EventInterface> events, int eventCookieFlags, EventComparator.EventMeetingSortBy sort, boolean asc) throws IOException {
        helper.setup("text/calendar", this.reference(), false);
        ICalendar ical = new ICalendar();
        ical.setVersion(ICalVersion.V2_0);
        ical.setCalendarScale(CalendarScale.gregorian());
        ical.setMethod(new Method("PUBLISH"));
        ical.setExperimentalProperty("X-WR-CALNAME", this.guessScheduleName(helper, request));
        ical.setExperimentalProperty("X-WR-TIMEZONE", TimeZone.getDefault().getID());
        ical.setProductId("-//UniTime LLC/UniTime " + Constants.getVersion() + " Events//EN");
        for (EventInterface event : events) {
            this.print(ical, event);
        }
        ICalWriter writer = new ICalWriter(helper.getWriter(), ICalVersion.V2_0);
        try {
            writer.getTimezoneInfo().setGenerator(new CalendarVTimeZoneGenerator());
            writer.getTimezoneInfo().setDefaultTimeZone(TimeZone.getDefault());
        }
        catch (IllegalArgumentException e) {
            sLog.warn((Object)("Failed to set default time zone: " + e.getMessage()));
        }
        try {
            writer.write(ical);
            writer.flush();
        }
        finally {
            writer.close();
        }
    }

    public boolean print(ICalendar ical, EventInterface event) throws IOException {
        return this.print(ical, event, null);
    }

    protected String guessScheduleName(ExportHelper helper, EventInterface.EventLookupRpcRequest request) {
        boolean allSessions;
        org.hibernate.Session hibSession = new _RootDAO().getSession();
        String name = MESSAGES.scheduleNameDefault();
        if (request.getResourceType() == EventInterface.ResourceType.PERSON) {
            name = MESSAGES.pagePersonalTimetable();
        } else if (helper.getParameter("name") != null) {
            name = MESSAGES.scheduleNameForResource(Constants.toInitialCase(helper.getParameter("name")));
        } else {
            String resource = this.getResourceName(request, hibSession);
            if (resource != null) {
                name = MESSAGES.scheduleNameForResource(resource);
            } else if (request.getResourceType() != null && request.getResourceType() != EventInterface.ResourceType.ROOM) {
                name = CONSTANTS.resourceType()[request.getResourceType().ordinal()];
            }
        }
        boolean bl = allSessions = request.getEventFilter().hasOption("flag") && request.getEventFilter().getOptions("flag").contains("All Sessions");
        if (!allSessions && request.getSessionId() != null) {
            Session session = (Session)SessionDAO.getInstance().get(request.getSessionId(), hibSession);
            name = MESSAGES.scheduleNameForSession(name, session.getAcademicTerm(), session.getAcademicYear());
        }
        return name;
    }

    public String getResourceName(EventInterface.EventLookupRpcRequest request, org.hibernate.Session hibSession) {
        Location location;
        if (request.getResourceType() != null && request.getResourceId() != null) {
            switch (request.getResourceType()) {
                case ROOM: {
                    location = (Location)LocationDAO.getInstance().get(request.getResourceId(), hibSession);
                    if (location == null) break;
                    return location.getDisplayName() == null ? location.getLabel() : location.getDisplayName();
                }
                case SUBJECT: {
                    SubjectArea subject = (SubjectArea)SubjectAreaDAO.getInstance().get(request.getResourceId(), hibSession);
                    if (subject == null) break;
                    return subject.getSubjectAreaAbbreviation();
                }
                case COURSE: {
                    CourseOffering course = (CourseOffering)CourseOfferingDAO.getInstance().get(request.getResourceId(), hibSession);
                    if (course == null) break;
                    return course.getCourseName();
                }
                case CURRICULUM: {
                    Curriculum curriculum = (Curriculum)CurriculumDAO.getInstance().get(request.getResourceId(), hibSession);
                    if (curriculum != null) {
                        return curriculum.getAbbv() == null ? curriculum.getAcademicArea().getAcademicAreaAbbreviation() : curriculum.getAbbv();
                    }
                    CurriculumClassification clasf = (CurriculumClassification)CurriculumClassificationDAO.getInstance().get(request.getResourceId(), hibSession);
                    if (clasf == null) break;
                    return (clasf.getCurriculum().getAbbv() == null ? clasf.getCurriculum().getAcademicArea().getAcademicAreaAbbreviation() : clasf.getCurriculum().getAbbv()) + " " + (clasf.getName() == null ? clasf.getAcademicClassification().getCode() : clasf.getName());
                }
                case DEPARTMENT: {
                    Department department = (Department)DepartmentDAO.getInstance().get(request.getResourceId(), hibSession);
                    if (department == null) break;
                    return department.getAbbreviation() == null ? department.getDeptCode() : department.getAbbreviation();
                }
                case GROUP: {
                    StudentGroup group = (StudentGroup)StudentGroupDAO.getInstance().get(request.getResourceId(), hibSession);
                    if (group == null) break;
                    return group.getGroupAbbreviation();
                }
            }
        }
        if (request.getEventFilter().hasOption("room") && (location = (Location)LocationDAO.getInstance().get(Long.valueOf(request.getEventFilter().getOption("room")), hibSession)) != null) {
            return location.getDisplayName() == null ? location.getLabel() : location.getDisplayName();
        }
        return null;
    }

    public boolean print(ICalendar ical, EventInterface event, Status status) throws IOException {
        if (event.getType() == EventInterface.EventType.Unavailabile) {
            return false;
        }
        TreeSet<ICalendarMeeting> meetings = new TreeSet<ICalendarMeeting>();
        TreeSet<Integer> days = new TreeSet<Integer>();
        if (event.hasMeetings()) {
            block9: for (EventInterface.MeetingInterface m : event.getMeetings()) {
                if (m.isArrangeHours() || m.getApprovalStatus() != EventInterface.ApprovalStatus.Approved && m.getApprovalStatus() != EventInterface.ApprovalStatus.Pending) continue;
                ICalendarMeeting x = new ICalendarMeeting(m, status);
                for (ICalendarMeeting icm : meetings) {
                    if (!icm.merge(x)) continue;
                    continue block9;
                }
                meetings.add(x);
                days.add(x.getStart().getDayOfWeek());
            }
        }
        if (meetings.isEmpty()) {
            return false;
        }
        ICalendarMeeting first = (ICalendarMeeting)meetings.first();
        VEvent master = new VEvent();
        master.setDateStart(first.getDateStart());
        master.setDateEnd(first.getDateEnd());
        master.setLocation(first.getLocation());
        master.setStatus(first.getStatus());
        ArrayList<VEvent> events = new ArrayList<VEvent>();
        events.add(master);
        if (meetings.size() > 1) {
            DateTime until = new DateTime(((ICalendarMeeting)meetings.last()).getStart().getYear(), ((ICalendarMeeting)meetings.last()).getStart().getMonthOfYear(), ((ICalendarMeeting)meetings.last()).getStart().getDayOfMonth(), first.getEnd().getHourOfDay(), first.getEnd().getMinuteOfHour(), first.getEnd().getSecondOfMinute());
            int nrMeetingDays = 0;
            DateTime date = first.getStart();
            while (!date.isAfter((ReadableInstant)until)) {
                if (days.contains(date.getDayOfWeek())) {
                    ++nrMeetingDays;
                }
                date = date.plusDays(1);
            }
            while (nrMeetingDays < meetings.size()) {
                if (!days.contains((until = until.plusDays(1)).getDayOfWeek())) continue;
                ++nrMeetingDays;
            }
            Recurrence.Builder recur = new Recurrence.Builder(Recurrence.Frequency.WEEKLY);
            Iterator i = days.iterator();
            while (i.hasNext()) {
                switch ((Integer)i.next()) {
                    case 1: {
                        recur.byDay(Recurrence.DayOfWeek.MONDAY);
                        break;
                    }
                    case 2: {
                        recur.byDay(Recurrence.DayOfWeek.TUESDAY);
                        break;
                    }
                    case 3: {
                        recur.byDay(Recurrence.DayOfWeek.WEDNESDAY);
                        break;
                    }
                    case 4: {
                        recur.byDay(Recurrence.DayOfWeek.THURSDAY);
                        break;
                    }
                    case 5: {
                        recur.byDay(Recurrence.DayOfWeek.FRIDAY);
                        break;
                    }
                    case 6: {
                        recur.byDay(Recurrence.DayOfWeek.SATURDAY);
                        break;
                    }
                    case 7: {
                        recur.byDay(Recurrence.DayOfWeek.SUNDAY);
                    }
                }
            }
            recur.workweekStarts(Recurrence.DayOfWeek.MONDAY).until(until.toDate());
            master.setRecurrenceRule(recur.build());
            ExceptionDates exdates = new ExceptionDates();
            Object date2 = first.getStart();
            while (!date2.isAfter((ReadableInstant)until)) {
                block50: {
                    if (days.contains(date2.getDayOfWeek())) {
                        ICalendarMeeting ics;
                        Iterator i2 = meetings.iterator();
                        while (i2.hasNext()) {
                            ics = (ICalendarMeeting)i2.next();
                            if (date2.getYear() != ics.getStart().getYear() || date2.getDayOfYear() != ics.getStart().getDayOfYear() || !first.same(ics)) continue;
                            i2.remove();
                            break block50;
                        }
                        i2 = meetings.iterator();
                        while (i2.hasNext()) {
                            ics = (ICalendarMeeting)i2.next();
                            if (date2.getYear() != ics.getStart().getYear() || date2.getDayOfYear() != ics.getStart().getDayOfYear()) continue;
                            VEvent x = new VEvent();
                            RecurrenceId id = new RecurrenceId(date2.toDate(), true);
                            x.setRecurrenceId(id);
                            x.setDateStart(ics.getDateStart());
                            x.setDateEnd(ics.getDateEnd());
                            x.setLocation(ics.getLocation());
                            x.setStatus(ics.getStatus());
                            events.add(x);
                            i2.remove();
                            break block50;
                        }
                        exdates.addValue(date2.toDate());
                    }
                }
                date2 = date2.plusDays(1);
            }
            for (ICalendarMeeting ics : meetings) {
                VEvent x = new VEvent();
                x.setDateStart(ics.getDateStart());
                x.setDateEnd(ics.getDateEnd());
                x.setLocation(ics.getLocation());
                x.setStatus(ics.getStatus());
                if (!exdates.getValues().isEmpty()) {
                    RecurrenceId id = new RecurrenceId((Date)exdates.getValues().get(0), true);
                    x.setRecurrenceId(id);
                    exdates.getValues().remove(0);
                }
                events.add(x);
            }
            if (!exdates.getValues().isEmpty()) {
                master.addExceptionDates(exdates);
            }
        }
        for (VEvent vevent : events) {
            ICalProperty organizer;
            Attendee attendee;
            ICalProperty organizer2;
            String description;
            vevent.setSequence(event.getSequence());
            vevent.setUid(event.getId().toString());
            String name = event.getName();
            String string = description = event.hasInstruction() ? event.getInstruction() : event.getType().getName(CONSTANTS);
            if (event.hasCourseTitles() && event.getType() == EventInterface.EventType.Class && ApplicationProperty.EventGridDisplayTitle.isTrue()) {
                name = event.getCourseTitles().get(0);
                if (event.hasInstruction() && event.hasExternalIds()) {
                    description = event.getInstruction() + " " + event.getExternalIds().get(0);
                } else if (event.hasInstruction() && event.hasSectionNumber()) {
                    description = event.getInstruction() + " " + event.getSectionNumber();
                }
            }
            if (event.hasInstructors() && ApplicationProperty.EventCalendarDisplayInstructorsInDescription.isTrue()) {
                for (EventInterface.ContactInterface instructor : event.getInstructors()) {
                    description = description + "\n" + instructor.getName(MESSAGES);
                }
            }
            vevent.setSummary(name);
            vevent.setDescription(description);
            if (event.hasTimeStamp()) {
                DateTimeStamp ts = new DateTimeStamp(event.getTimeStamp());
                vevent.setDateTimeStamp(ts);
            }
            if (ApplicationProperty.EventCalendarSetOrganizer.isTrue()) {
                if (event.hasInstructors()) {
                    int idx = 0;
                    for (EventInterface.ContactInterface instructor : event.getInstructors()) {
                        if (idx++ == 0) {
                            organizer2 = new Organizer(instructor.getName(MESSAGES), instructor.hasEmail() ? instructor.getEmail() : "");
                            vevent.setOrganizer((Organizer)organizer2);
                            continue;
                        }
                        attendee = new Attendee(instructor.getName(MESSAGES), instructor.hasEmail() ? instructor.getEmail() : "");
                        attendee.setRole(Role.CHAIR);
                        vevent.addAttendee(attendee);
                    }
                } else if (event.hasSponsor()) {
                    organizer = new Organizer(event.getSponsor().getName(), event.getSponsor().hasEmail() ? event.getSponsor().getEmail() : "");
                    vevent.setOrganizer((Organizer)organizer);
                } else if (event.hasContact()) {
                    organizer = new Organizer(event.getContact().getName(MESSAGES), event.getContact().hasEmail() ? event.getContact().getEmail() : "");
                    vevent.setOrganizer((Organizer)organizer);
                }
            } else if (event.hasInstructors()) {
                int idx = 0;
                for (EventInterface.ContactInterface instructor : event.getInstructors()) {
                    if (idx++ == 0) {
                        organizer2 = new Attendee(instructor.getName(MESSAGES), instructor.hasEmail() ? instructor.getEmail() : "");
                        ((Attendee)organizer2).setRole(Role.ORGANIZER);
                        vevent.addAttendee((Attendee)organizer2);
                        continue;
                    }
                    attendee = new Attendee(instructor.getName(MESSAGES), instructor.hasEmail() ? instructor.getEmail() : "");
                    attendee.setRole(Role.CHAIR);
                    vevent.addAttendee(attendee);
                }
            } else if (event.hasSponsor()) {
                organizer = new Attendee(event.getSponsor().getName(), event.getSponsor().hasEmail() ? event.getSponsor().getEmail() : "");
                ((Attendee)organizer).setRole(Role.ORGANIZER);
                vevent.addAttendee((Attendee)organizer);
            } else if (event.hasContact() && event.getType() != EventInterface.EventType.Class && event.getType() != EventInterface.EventType.FinalExam && event.getType() != EventInterface.EventType.MidtermExam) {
                organizer = new Attendee(event.getContact().getName(MESSAGES), event.getContact().hasEmail() ? event.getContact().getEmail() : "");
                ((Attendee)organizer).setRole(Role.ORGANIZER);
                vevent.addAttendee((Attendee)organizer);
            }
            ical.addEvent(vevent);
        }
        return true;
    }

    public class ICalendarMeeting
    implements Comparable<ICalendarMeeting> {
        private DateTime iStart;
        private DateTime iEnd;
        private String iLocation;
        private Status iStatus;

        public ICalendarMeeting(EventInterface.MeetingInterface meeting, Status status) {
            this.iStart = meeting.getStartTime() != null ? new DateTime((Object)meeting.getStartTime()) : new DateTime((Object)meeting.getMeetingDate()).plusMinutes(5 * meeting.getStartSlot() + meeting.getStartOffset());
            this.iEnd = meeting.getStartTime() != null ? new DateTime((Object)meeting.getStopTime()) : new DateTime((Object)meeting.getMeetingDate()).plusMinutes(5 * meeting.getEndSlot() + meeting.getEndOffset());
            if (this.iStart.getSecondOfMinute() != 0) {
                this.iStart = this.iStart.minusSeconds(this.iStart.getSecondOfMinute());
            }
            if (this.iEnd.getSecondOfMinute() != 0) {
                this.iEnd = this.iEnd.minusSeconds(this.iEnd.getSecondOfMinute());
            }
            if (this.iStart.getMillisOfSecond() != 0) {
                this.iStart = this.iStart.minusMillis(this.iStart.getMillisOfSecond());
            }
            if (this.iEnd.getMillisOfSecond() != 0) {
                this.iEnd = this.iEnd.minusMillis(this.iEnd.getMillisOfSecond());
            }
            this.iLocation = meeting.getLocationName(EventsExporter.MESSAGES);
            this.iStatus = status != null ? status : (meeting.isApproved() ? Status.confirmed() : Status.tentative());
        }

        public DateTime getStart() {
            return this.iStart;
        }

        public DateStart getDateStart() {
            DateStart ds = new DateStart(this.iStart.toDate(), true);
            return ds;
        }

        public DateTime getEnd() {
            return this.iEnd;
        }

        public DateEnd getDateEnd() {
            DateEnd de = new DateEnd(this.iEnd.toDate(), true);
            return de;
        }

        public String getLocation() {
            return this.iLocation;
        }

        public Status getStatus() {
            return this.iStatus;
        }

        public boolean merge(ICalendarMeeting m) {
            if (m.getStart().equals((Object)this.getStart()) && m.getEnd().equals((Object)this.getEnd())) {
                if (m.getStatus().isTentative()) {
                    this.iStatus = Status.tentative();
                }
                this.iLocation = this.iLocation + ", " + m.getLocation();
                return true;
            }
            return false;
        }

        public boolean same(ICalendarMeeting m) {
            return m.getStart().getSecondOfDay() == this.getStart().getSecondOfDay() && m.getEnd().getSecondOfDay() == this.getEnd().getSecondOfDay() && this.getLocation().equals(m.getLocation()) && ((String)this.getStatus().getValue()).equals(m.getStatus().getValue());
        }

        @Override
        public int compareTo(ICalendarMeeting m) {
            int cmp = this.getStart().compareTo((ReadableInstant)m.getStart());
            if (cmp != 0) {
                return cmp;
            }
            return this.getEnd().compareTo((ReadableInstant)m.getEnd());
        }
    }
}

