/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.events;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.events.EventAction;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.command.server.GwtRpcServlet;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.PersonInterface;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.EventContact;
import org.unitime.timetable.model.EventServiceProvider;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SponsoringOrganization;
import org.unitime.timetable.model.Staff;
import org.unitime.timetable.model.StandardEventNote;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.dao.EventContactDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.StandardEventNoteDepartmentDAO;
import org.unitime.timetable.model.dao.StandardEventNoteGlobalDAO;
import org.unitime.timetable.model.dao.StandardEventNoteSessionDAO;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.UserAuthority;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.qualifiers.SimpleQualifier;
import org.unitime.timetable.security.rights.Right;

@GwtRpcImplements(value=EventInterface.EventPropertiesRpcRequest.class)
public class EventPropertiesBackend
extends EventAction<EventInterface.EventPropertiesRpcRequest, EventInterface.EventPropertiesRpcResponse> {
    @Autowired
    private ApplicationContext applicationContext;

    @Override
    public EventInterface.EventPropertiesRpcResponse execute(EventInterface.EventPropertiesRpcRequest request, EventAction.EventContext context) {
        int tooEarly;
        EventInterface.EventPropertiesRpcResponse response = new EventInterface.EventPropertiesRpcResponse();
        Session session = (Session)SessionDAO.getInstance().get(request.getSessionId());
        response.setCanLookupPeople(context.hasPermission(Right.EventLookupSchedule));
        response.setCanLookupMainContact(context.hasPermission(Right.EventLookupContact));
        response.setCanLookupAdditionalContacts(response.isCanLookupMainContact() || context.hasPermission(Right.EventLookupContactAdditional));
        response.setCanAddSpecialEvent(context.hasPermission(Right.EventAddSpecial));
        response.setCanAddCourseEvent(context.hasPermission(Right.EventAddCourseRelated));
        response.setCanAddUnavailableEvent(context.hasPermission(Right.EventAddUnavailable));
        response.setCanSetExpirationDate(context.hasPermission(Right.EventSetExpiration));
        response.setCanEditAcademicTitle(context.hasPermission(Right.EventCanEditAcademicTitle));
        response.setCanViewMeetingContacts(context.hasPermission(Right.EventCanViewMeetingContacts));
        response.setCanEditMeetingContacts(context.hasPermission(Right.EventCanEditMeetingContacts));
        response.setCanExportCSV(true);
        if (response.isCanLookupMainContact() && ApplicationProperty.EmailConfirmationEvents.isTrue()) {
            response.setEmailConfirmation("true".equalsIgnoreCase(context.getUser().getProperty("unitime.email.confirm.default", "true")));
        }
        this.setupSponsoringOrganizations(session, response);
        this.setupEventServiceProviders(session, response);
        if (context.getUser() != null) {
            response.setMainContact(this.lookupMainContact(request.getSessionId(), context));
        }
        this.setupStandardNotes(request.getSessionId(), context.getUser(), response);
        response.setCanSaveFilterDefaults(context.hasPermission(Right.HasRole));
        if (context.isAuthenticated() && response.isCanSaveFilterDefaults() && request.getPageName() != null) {
            response.setFilterDefault("rooms", context.getUser().getProperty("Default[" + request.getPageName() + ".rooms]"));
            response.setFilterDefault("events", context.getUser().getProperty("Default[" + request.getPageName() + ".events]"));
            response.setFilterDefault("emails", context.getUser().getProperty("Defaults[AddEvent.emails]"));
        }
        if ((tooEarly = ApplicationProperty.EventTooEarlySlot.intValue().intValue()) > 0) {
            response.setTooEarlySlot(tooEarly);
        }
        response.setGridDisplayTitle(ApplicationProperty.EventGridDisplayTitle.isTrue());
        response.setStudent(context.getUser() != null && context.getUser().hasRole("Student"));
        response.setFirstDayOfWeek(ApplicationProperty.EventGridStartDay.intValue());
        response.setCourseEventDefaultStudentAttendance(ApplicationProperty.EventCourseEventsDefaultStudentAttendance.isTrue());
        return response;
    }

    public void setupSponsoringOrganizations(Session session, EventInterface.EventPropertiesRpcResponse response) {
        for (SponsoringOrganization s : SponsoringOrganization.findAll()) {
            EventInterface.SponsoringOrganizationInterface sponsor = new EventInterface.SponsoringOrganizationInterface();
            sponsor.setUniqueId(s.getUniqueId());
            sponsor.setName(s.getName());
            sponsor.setEmail(s.getEmail());
            response.addSponsoringOrganization(sponsor);
        }
    }

    public void setupEventServiceProviders(Session session, EventInterface.EventPropertiesRpcResponse response) {
        for (EventServiceProvider p : EventServiceProvider.findAll(session.getUniqueId())) {
            EventInterface.EventServiceProviderInterface provider = new EventInterface.EventServiceProviderInterface();
            provider.setId(p.getUniqueId());
            provider.setReference(p.getReference());
            provider.setLabel(p.getLabel());
            provider.setMessage(p.getNote());
            provider.setEmail(p.getEmail());
            provider.setLocationIds(p.getLocationIds(session.getUniqueId()));
            response.addEventServiceProvider(provider);
        }
    }

    public EventInterface.ContactInterface lookupMainContact(Long sessionId, SessionContext context) {
        List people;
        UserContext user = context.getUser();
        String nameFormat = user.getProperty(UserProperty.NameFormat);
        org.hibernate.Session hibSession = EventContactDAO.getInstance().getSession();
        EventContact contact = (EventContact)hibSession.createQuery("from EventContact where externalUniqueId = :userId").setString("userId", user.getExternalUserId()).setMaxResults(1).uniqueResult();
        if (contact != null) {
            EventInterface.ContactInterface c = new EventInterface.ContactInterface();
            c.setFirstName(contact.getFirstName());
            c.setMiddleName(contact.getMiddleName());
            c.setLastName(contact.getLastName());
            c.setAcademicTitle(contact.getAcademicTitle());
            c.setEmail(contact.getEmailAddress());
            c.setPhone(contact.getPhone());
            c.setExternalId(contact.getExternalUniqueId());
            c.setFormattedName(contact.getName(nameFormat));
            return c;
        }
        TimetableManager manager = (TimetableManager)hibSession.createQuery("from TimetableManager where externalUniqueId = :userId").setString("userId", user.getExternalUserId()).setMaxResults(1).uniqueResult();
        if (manager != null) {
            EventInterface.ContactInterface c = new EventInterface.ContactInterface();
            c.setExternalId(manager.getExternalUniqueId());
            c.setFirstName(manager.getFirstName());
            c.setMiddleName(manager.getMiddleName());
            c.setLastName(manager.getLastName());
            c.setAcademicTitle(manager.getAcademicTitle());
            c.setEmail(manager.getEmailAddress());
            c.setFormattedName(manager.getName(nameFormat));
            return c;
        }
        DepartmentalInstructor instructor = (DepartmentalInstructor)hibSession.createQuery("from DepartmentalInstructor where department.session.uniqueId = :sessionId and externalUniqueId = :userId").setLong("sessionId", sessionId.longValue()).setString("userId", user.getExternalUserId()).setMaxResults(1).uniqueResult();
        if (instructor != null) {
            EventInterface.ContactInterface c = new EventInterface.ContactInterface();
            c.setExternalId(instructor.getExternalUniqueId());
            c.setFirstName(instructor.getFirstName());
            c.setMiddleName(instructor.getMiddleName());
            c.setLastName(instructor.getLastName());
            c.setAcademicTitle(instructor.getAcademicTitle());
            c.setEmail(instructor.getEmail());
            c.setFormattedName(instructor.getName(nameFormat));
            return c;
        }
        Staff staff = (Staff)hibSession.createQuery("from Staff where externalUniqueId = :userId").setString("userId", user.getExternalUserId()).setMaxResults(1).uniqueResult();
        if (staff != null) {
            EventInterface.ContactInterface c = new EventInterface.ContactInterface();
            c.setExternalId(staff.getExternalUniqueId());
            c.setFirstName(staff.getFirstName());
            c.setMiddleName(staff.getMiddleName());
            c.setLastName(staff.getLastName());
            c.setAcademicTitle(staff.getAcademicTitle());
            c.setEmail(staff.getEmail());
            c.setFormattedName(staff.getName(nameFormat));
            return c;
        }
        Student student = (Student)hibSession.createQuery("from Student where session.uniqueId = :sessionId and externalUniqueId = :userId").setLong("sessionId", sessionId.longValue()).setString("userId", user.getExternalUserId()).setMaxResults(1).uniqueResult();
        if (student != null) {
            EventInterface.ContactInterface c = new EventInterface.ContactInterface();
            c.setExternalId(student.getExternalUniqueId());
            c.setFirstName(student.getFirstName());
            c.setMiddleName(student.getMiddleName());
            c.setLastName(student.getLastName());
            c.setAcademicTitle(student.getAcademicTitle());
            c.setEmail(student.getEmail());
            c.setFormattedName(student.getName(nameFormat));
            return c;
        }
        if (user.getName() != null && !user.getName().isEmpty() && (people = (List)GwtRpcServlet.execute(new PersonInterface.LookupRequest(user.getName(), "mustHaveExternalId,session=" + sessionId), this.applicationContext, null)) != null) {
            for (PersonInterface person : people) {
                if (!user.getExternalUserId().equals(person.getId())) continue;
                EventInterface.ContactInterface c = new EventInterface.ContactInterface();
                c.setFirstName(person.getFirstName());
                c.setMiddleName(person.getMiddleName());
                c.setLastName(person.getLastName());
                c.setAcademicTitle(person.getAcademicTitle());
                c.setEmail(person.getEmail());
                c.setPhone(person.getPhone());
                c.setExternalId(person.getId());
                return c;
            }
        }
        EventInterface.ContactInterface c = new EventInterface.ContactInterface();
        if (user.getName() != null && !user.getName().isEmpty()) {
            String[] name = user.getName().split(" ");
            if (name.length == 1) {
                c.setLastName(name[0]);
            } else if (name.length == 2) {
                c.setFirstName(name[0]);
                c.setLastName(name[1]);
            } else {
                c.setFirstName(name[0]);
                String mName = "";
                for (int i = 1; i < name.length - 1; ++i) {
                    mName = mName + (mName.isEmpty() ? "" : " ") + name[i];
                }
                c.setFirstName(mName);
                c.setLastName(name[name.length - 1]);
            }
        } else {
            c.setLastName(user.getUsername());
        }
        c.setExternalId(user.getExternalUserId());
        return c;
    }

    public void setupStandardNotes(Long sessionId, UserContext user, EventInterface.EventPropertiesRpcResponse response) {
        block7: {
            EventInterface.StandardEventNoteInterface n;
            String departments;
            block8: {
                for (StandardEventNote note : StandardEventNoteGlobalDAO.getInstance().findAll()) {
                    EventInterface.StandardEventNoteInterface n2 = new EventInterface.StandardEventNoteInterface();
                    n2.setId(note.getUniqueId());
                    n2.setReference(note.getReference());
                    n2.setNote(note.getNote());
                    response.addStandardNote(n2);
                }
                for (StandardEventNote note : StandardEventNoteSessionDAO.getInstance().getSession().createQuery("from StandardEventNoteSession where session.uniqueId = :sessionId").setLong("sessionId", sessionId.longValue()).setCacheable(true).list()) {
                    EventInterface.StandardEventNoteInterface n2 = new EventInterface.StandardEventNoteInterface();
                    n2.setId(note.getUniqueId());
                    n2.setReference(note.getReference());
                    n2.setNote(note.getNote());
                    response.addStandardNote(n2);
                }
                if (user == null) break block7;
                departments = "";
                boolean allDepartments = false;
                for (UserAuthority userAuthority : user.getAuthorities(user.getCurrentAuthority() != null ? user.getCurrentAuthority().getRole() : "Anonymous", new SimpleQualifier("Session", sessionId))) {
                    if (userAuthority.hasRight(Right.DepartmentIndependent)) {
                        allDepartments = true;
                        break;
                    }
                    for (Qualifiable qualifiable : userAuthority.getQualifiers("Department")) {
                        departments = departments + (departments.isEmpty() ? "" : ",") + qualifiable.getQualifierId();
                    }
                }
                if (!allDepartments) break block8;
                for (StandardEventNote standardEventNote : StandardEventNoteDepartmentDAO.getInstance().getSession().createQuery("from StandardEventNoteDepartment where department.session.uniqueId = :sessionId").setLong("sessionId", sessionId.longValue()).setCacheable(true).list()) {
                    n = new EventInterface.StandardEventNoteInterface();
                    n.setId(standardEventNote.getUniqueId());
                    n.setReference(standardEventNote.getReference());
                    n.setNote(standardEventNote.getNote());
                    response.addStandardNote(n);
                }
                break block7;
            }
            if (departments.isEmpty()) break block7;
            for (StandardEventNote standardEventNote : StandardEventNoteDepartmentDAO.getInstance().getSession().createQuery("from StandardEventNoteDepartment where department.uniqueId in (" + departments + ")").setCacheable(true).list()) {
                n = new EventInterface.StandardEventNoteInterface();
                n.setId(standardEventNote.getUniqueId());
                n.setReference(standardEventNote.getReference());
                n.setNote(standardEventNote.getNote());
                response.addStandardNote(n);
            }
        }
    }
}

