/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.events;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.events.EventAction;
import org.unitime.timetable.events.EventFilterBackend;
import org.unitime.timetable.events.QueryEncoderBackend;
import org.unitime.timetable.events.RoomFilterBackend;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.model.ClassEvent;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseEvent;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Curriculum;
import org.unitime.timetable.model.CurriculumClassification;
import org.unitime.timetable.model.CurriculumCourse;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.EventContact;
import org.unitime.timetable.model.EventNote;
import org.unitime.timetable.model.EventServiceProvider;
import org.unitime.timetable.model.ExamEvent;
import org.unitime.timetable.model.ExamOwner;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Meeting;
import org.unitime.timetable.model.OfferingCoordinator;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.RelatedCourseInfo;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Solution;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.StudentGroup;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.TeachingResponsibility;
import org.unitime.timetable.model.base.BaseClassEvent;
import org.unitime.timetable.model.base.BaseCourseEvent;
import org.unitime.timetable.model.base.BaseCourseOffering;
import org.unitime.timetable.model.base.BaseCurriculumClassification;
import org.unitime.timetable.model.base.BaseEventServiceProvider;
import org.unitime.timetable.model.base.BaseExamOwner;
import org.unitime.timetable.model.dao.ClassEventDAO;
import org.unitime.timetable.model.dao.CourseEventDAO;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.model.dao.EventDAO;
import org.unitime.timetable.model.dao.ExamEventDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.StudentGroupDAO;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.CalendarUtils;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.Formats;

@GwtRpcImplements(value=EventInterface.EventLookupRpcRequest.class)
public class EventLookupBackend
extends EventAction<EventInterface.EventLookupRpcRequest, GwtRpcResponseList<EventInterface>> {
    private static Logger sLog = Logger.getLogger(EventLookupBackend.class);

    @Override
    public GwtRpcResponseList<EventInterface> execute(EventInterface.EventLookupRpcRequest request, EventAction.EventContext context) {
        if (request.getResourceType() == EventInterface.ResourceType.PERSON) {
            if (!request.hasResourceExternalId()) {
                request.setResourceExternalId(context.isAuthenticated() ? context.getUser().getExternalUserId() : null);
            } else if (!request.getResourceExternalId().equals(context.isAuthenticated() ? context.getUser().getExternalUserId() : null)) {
                context.checkPermission(Right.EventLookupSchedule);
                Set<String> roles = request.getEventFilter().getOptions("role");
                if (roles == null) {
                    roles = new HashSet<String>();
                    if (context.hasPermission(Right.CanLookupStudents)) {
                        roles.add("Student");
                    }
                    if (context.hasPermission(Right.CanLookupInstructors)) {
                        roles.add("Instructor");
                        roles.add("Coordinator");
                    }
                    if (context.hasPermission(Right.CanLookupEventContacts)) {
                        roles.add("Contact");
                    }
                    if (roles.size() < 4) {
                        request.getEventFilter().setOptions("role", roles);
                    }
                } else {
                    if (!context.hasPermission(Right.CanLookupStudents)) {
                        roles.remove("Student");
                        roles.remove("student");
                    }
                    if (!context.hasPermission(Right.CanLookupInstructors)) {
                        roles.remove("Instructor");
                        roles.remove("instructor");
                        roles.remove("Coordinator");
                        roles.remove("coordinator");
                    }
                    if (!context.hasPermission(Right.CanLookupStudents)) {
                        roles.remove("Contact");
                        roles.remove("contact");
                    }
                }
            }
        }
        if (request.getEventFilter() == null) {
            EventInterface.EventFilterRpcRequest eventFilter = new EventInterface.EventFilterRpcRequest();
            eventFilter.setSessionId(request.getSessionId());
            request.setEventFilter(eventFilter);
        }
        return this.findEvents(request, context);
    }

    private static boolean hasChild(Set<Long> restrictions, Class_ clazz) {
        if (restrictions.contains(clazz.getUniqueId())) {
            return true;
        }
        for (Class_ child : clazz.getChildClasses()) {
            if (!EventLookupBackend.hasChild(restrictions, child)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasClassRestrictionChild(Set<Long> restrictions, SchedulingSubpart subpart) {
        for (Class_ other : subpart.getClasses()) {
            if (!restrictions.contains(other.getUniqueId())) continue;
            return true;
        }
        for (SchedulingSubpart child : subpart.getChildSubparts()) {
            if (!EventLookupBackend.hasClassRestrictionChild(restrictions, child)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasClassRestriction(Set<Long> restrictions, Class_ clazz) {
        if (restrictions.isEmpty()) {
            return false;
        }
        for (SchedulingSubpart parent = clazz.getSchedulingSubpart().getParentSubpart(); parent != null; parent = parent.getParentSubpart()) {
            for (Class_ other : parent.getClasses()) {
                if (!restrictions.contains(other.getUniqueId())) continue;
                return true;
            }
        }
        return EventLookupBackend.hasClassRestrictionChild(restrictions, clazz.getSchedulingSubpart());
    }

    public static boolean hide(Set<Long>[] restrictions, Class_ clazz) {
        if (!restrictions[0].isEmpty() && !restrictions[0].contains(clazz.getSchedulingSubpart().getInstrOfferingConfig().getUniqueId())) {
            return true;
        }
        if (EventLookupBackend.hasClassRestriction(restrictions[1], clazz)) {
            for (Class_ parent = clazz; parent != null; parent = parent.getParentClass()) {
                if (!restrictions[1].contains(parent.getUniqueId())) continue;
                return false;
            }
            for (Class_ child : clazz.getChildClasses()) {
                if (!EventLookupBackend.hasChild(restrictions[1], child)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     */
    public GwtRpcResponseList<EventInterface> findEvents(EventInterface.EventLookupRpcRequest request, EventAction.EventContext context) {
        GwtRpcResponseList<EventInterface> gwtRpcResponseList;
        org.hibernate.Session hibSession = EventDAO.getInstance().getSession();
        try {
            Object contact;
            HashMap<Long, Double> distances = new HashMap<Long, Double>();
            HashMap<Long, Location> locationMap = null;
            if (request.getRoomFilter() != null && !request.getRoomFilter().isEmpty()) {
                locationMap = new HashMap<Long, Location>();
                if (context.isAuthenticated()) {
                    request.getRoomFilter().setOption("user", context.getUser().getExternalUserId());
                }
                for (Location location : new RoomFilterBackend().locations(request.getSessionId(), request.getRoomFilter(), 1000, distances, context)) {
                    request.getEventFilter().addOption("room", location.getUniqueId().toString());
                    locationMap.put(location.getPermanentId(), location);
                }
            }
            if (request.getResourceType() == EventInterface.ResourceType.ROOM && request.getEventFilter().hasOptions("type") && !request.getEventFilter().getOptions("type").contains(Event.sEventTypesAbbv[5])) {
                request.getEventFilter().addOption("type", Event.sEventTypesAbbv[5]);
            }
            EventFilterBackend.EventQuery query = EventFilterBackend.getQuery(request.getEventFilter(), context);
            int limit = request.getLimit();
            String nameFormat = context.getUser().getProperty(UserProperty.NameFormat);
            List meetings = null;
            Hashtable<Long, Set[]> restrictions = null;
            Session session = (Session)SessionDAO.getInstance().get(request.getSessionId(), hibSession);
            Curriculum curriculum = null;
            Collection curriculumCourses = null;
            HashSet curriculumClasses = null;
            Department department = null;
            StudentGroup group = null;
            if (request.getResourceType() == EventInterface.ResourceType.GROUP) {
                group = (StudentGroup)StudentGroupDAO.getInstance().get(request.getResourceId(), hibSession);
            }
            boolean groupEnrollments = request.getResourceType() == EventInterface.ResourceType.GROUP && group != null && ApplicationProperty.StudentGroupsTimetableGroupEnrollments.isTrue();
            switch (request.getResourceType()) {
                case ROOM: {
                    if (request.getResourceId() != null) {
                        meetings = query.select("distinct m").joinWithLocation().where("l.uniqueId = :resourceId").set("resourceId", request.getResourceId()).limit(1 + limit).query(hibSession).list();
                        break;
                    }
                    if (request.getResourceExternalId() != null) {
                        meetings = query.select("distinct m").joinWithLocation().where("l.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).limit(1 + limit).query(hibSession).list();
                        break;
                    }
                    meetings = query.select("distinct m").limit(1 + limit).query(hibSession).list();
                    break;
                }
                case SUBJECT: 
                case COURSE: {
                    String resourceCheck = request.getResourceType() == EventInterface.ResourceType.SUBJECT ? "co.subjectArea.uniqueId = :resourceId" : "co.uniqueId = :resourceId";
                    meetings = new ArrayList();
                    if (limit <= 0 || meetings.size() < limit) {
                        meetings.addAll(query.select("distinct m").type("ClassEvent").from("inner join e.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co").where(resourceCheck).set("resourceId", request.getResourceId()).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                    }
                    if (limit <= 0 || meetings.size() < limit) {
                        meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, CourseOffering co").where("o.ownerType = :type and o.ownerId = co.uniqueId").set("type", 1).where(resourceCheck).set("resourceId", request.getResourceId()).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                    }
                    if (limit <= 0 || meetings.size() < limit) {
                        meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, CourseOffering co").where("o.ownerType = :type and o.ownerId = co.instructionalOffering.uniqueId").set("type", 0).where(resourceCheck).set("resourceId", request.getResourceId()).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                    }
                    if (limit <= 0 || meetings.size() < limit) {
                        meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co").where("o.ownerType = :type and o.ownerId = c.uniqueId").set("type", 3).where(resourceCheck).set("resourceId", request.getResourceId()).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                    }
                    if (limit <= 0 || meetings.size() < limit) {
                        meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, CourseOffering co inner join co.instructionalOffering.instrOfferingConfigs cfg").where("o.ownerType = :type and o.ownerId = cfg.uniqueId").set("type", 2).where(resourceCheck).set("resourceId", request.getResourceId()).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                    }
                    if (limit <= 0 || meetings.size() < limit) {
                        meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, CourseOffering co").where("o.ownerType = :type and o.ownerId = co.uniqueId").set("type", 1).where(resourceCheck).set("resourceId", request.getResourceId()).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                    }
                    if (limit <= 0 || meetings.size() < limit) {
                        meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, CourseOffering co").where("o.ownerType = :type and o.ownerId = co.instructionalOffering.uniqueId").set("type", 0).where(resourceCheck).set("resourceId", request.getResourceId()).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                    }
                    if (limit <= 0 || meetings.size() < limit) {
                        meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co").where("o.ownerType = :type and o.ownerId = c.uniqueId").set("type", 3).where(resourceCheck).set("resourceId", request.getResourceId()).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                    }
                    if (limit > 0 && meetings.size() >= limit) break;
                    meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, CourseOffering co inner join co.instructionalOffering.instrOfferingConfigs cfg").where("o.ownerType = :type and o.ownerId = cfg.uniqueId").set("type", 2).where(resourceCheck).set("resourceId", request.getResourceId()).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                    break;
                }
                case CURRICULUM: {
                    curriculum = (Curriculum)hibSession.createQuery("select distinct c from CurriculumClassification f inner join f.curriculum c where c.uniqueId = :resourceId or f.uniqueId = :resourceId").setLong("resourceId", request.getResourceId().longValue()).setCacheable(true).uniqueResult();
                    if (!curriculum.isMultipleMajors().booleanValue() || curriculum.getMajors().isEmpty()) {
                        curriculumCourses = hibSession.createQuery("select cc.course.uniqueId from CurriculumCourse cc where cc.classification.curriculum.uniqueId = :resourceId or cc.classification.uniqueId = :resourceId").setLong("resourceId", request.getResourceId().longValue()).list();
                        meetings = new ArrayList();
                        if (limit <= 0 || meetings.size() < limit) {
                            meetings.addAll(query.select("distinct m").type("ClassEvent").from("inner join e.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co, CurriculumCourse cc").where("co = cc.course").where("cc.classification.curriculum.uniqueId = :resourceId or cc.classification.uniqueId = :resourceId").set("resourceId", request.getResourceId()).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        restrictions = new Hashtable<Long, Set[]>();
                        for (Object o : hibSession.createQuery("select distinct cc.course.instructionalOffering.uniqueId, (case when g.uniqueId is null then x.uniqueId else g.uniqueId end), z.uniqueId from CurriculumReservation r left outer join r.configurations g left outer join r.classes z left outer join z.schedulingSubpart.instrOfferingConfig x left outer join r.majors rm left outer join r.classifications rc, CurriculumCourse cc inner join cc.classification.curriculum.majors cm where (cc.classification.curriculum.uniqueId = :resourceId or cc.classification.uniqueId = :resourceId) and cc.course.instructionalOffering = r.instructionalOffering and r.area = cc.classification.curriculum.academicArea and (rm is null or rm = cm) and (rc is null or rc = cc.classification.academicClassification)").setLong("resourceId", request.getResourceId().longValue()).setCacheable(true).list()) {
                            Long offeringId = (Long)o[0];
                            Long configId = (Long)o[1];
                            Long clazzId = (Long)o[2];
                            Set[] r = (Set[])restrictions.get(offeringId);
                            if (r == null) {
                                r = new Set[]{new HashSet(), new HashSet()};
                                restrictions.put(offeringId, r);
                            }
                            if (configId != null) {
                                r[0].add(configId);
                            }
                            if (clazzId == null) continue;
                            r[1].add(clazzId);
                        }
                        if (limit <= 0 || meetings.size() < limit) {
                            meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, CourseOffering co, CurriculumCourse cc").where("co = cc.course").where("cc.classification.curriculum.uniqueId = :resourceId or cc.classification.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = co.uniqueId").set("type", 1).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (limit <= 0 || meetings.size() < limit) {
                            meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, CourseOffering co, CurriculumCourse cc").where("co = cc.course").where("cc.classification.curriculum.uniqueId = :resourceId or cc.classification.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = co.instructionalOffering.uniqueId").set("type", 0).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (limit <= 0 || meetings.size() < limit) {
                            meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co, CurriculumCourse cc").where("co = cc.course").where("cc.classification.curriculum.uniqueId = :resourceId or cc.classification.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = c.uniqueId").set("type", 3).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (limit <= 0 || meetings.size() < limit) {
                            meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, CourseOffering co inner join co.instructionalOffering.instrOfferingConfigs cfg, CurriculumCourse cc").where("co = cc.course").where("cc.classification.curriculum.uniqueId = :resourceId or cc.classification.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = cfg.uniqueId").set("type", 2).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (limit <= 0 || meetings.size() < limit) {
                            meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, CourseOffering co, CurriculumCourse cc").where("co = cc.course").where("cc.classification.curriculum.uniqueId = :resourceId or cc.classification.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = co.uniqueId").set("type", 1).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (limit <= 0 || meetings.size() < limit) {
                            meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, CourseOffering co, CurriculumCourse cc").where("co = cc.course").where("cc.classification.curriculum.uniqueId = :resourceId or cc.classification.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = co.instructionalOffering.uniqueId").set("type", 0).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (limit <= 0 || meetings.size() < limit) {
                            meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co, CurriculumCourse cc").where("co = cc.course").where("cc.classification.curriculum.uniqueId = :resourceId or cc.classification.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = c.uniqueId").set("type", 3).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (limit > 0 && meetings.size() >= limit) break;
                        meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, CourseOffering co inner join co.instructionalOffering.instrOfferingConfigs cfg, CurriculumCourse cc").where("co = cc.course").where("cc.classification.curriculum.uniqueId = :resourceId or cc.classification.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = cfg.uniqueId").set("type", 2).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        break;
                    }
                    curriculumCourses = new HashSet();
                    List parents = hibSession.createQuery("select distinct x from Curriculum x, Curriculum c inner join c.majors m where c.uniqueId = :curriculumId and x.uniqueId != c.uniqueId and c.academicArea = x.academicArea and (x.majors is empty or m in elements(x.majors))").setLong("curriculumId", curriculum.getUniqueId().longValue()).setCacheable(true).list();
                    for (CurriculumClassification clasf : curriculum.getClassifications()) {
                        if (!curriculum.getUniqueId().equals(request.getResourceId()) && !clasf.getUniqueId().equals(request.getResourceId())) continue;
                        HashSet<Long> courses = new HashSet<Long>();
                        for (Curriculum parent : parents) {
                            if (parent.getMajors().size() > 1) continue;
                            for (Object parentClasf : parent.getClassifications()) {
                                if (!clasf.getAcademicClassification().equals(((BaseCurriculumClassification)parentClasf).getAcademicClassification())) continue;
                                for (CurriculumCourse cc : ((BaseCurriculumClassification)parentClasf).getCourses()) {
                                    if (!(cc.getPercShare().floatValue() > 0.0f)) continue;
                                    courses.add(cc.getCourse().getUniqueId());
                                }
                            }
                        }
                        for (CurriculumCourse cc : clasf.getCourses()) {
                            if (cc.getPercShare().floatValue() > 0.0f) {
                                courses.add(cc.getCourse().getUniqueId());
                                continue;
                            }
                            courses.remove(cc.getCourse().getUniqueId());
                        }
                        curriculumCourses.addAll(courses);
                    }
                    meetings = new ArrayList();
                    if (curriculumCourses.isEmpty()) break;
                    if (limit <= 0 || meetings.size() < limit) {
                        meetings.addAll(query.select("distinct m").type("ClassEvent").from("inner join e.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co").where("co.uniqueId in (:courses)").set("courses", curriculumCourses).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                    }
                    restrictions = new Hashtable();
                    for (Object[] o : hibSession.createQuery("select distinct r.instructionalOffering.uniqueId, (case when g.uniqueId is null then x.uniqueId else g.uniqueId end), z.uniqueId from CurriculumReservation r left outer join r.configurations g left outer join r.classes z left outer join z.schedulingSubpart.instrOfferingConfig x left outer join r.majors rm left outer join r.classifications rc, CurriculumClassification f inner join f.curriculum c inner join c.majors cm, CourseOffering co where (f.uniqueId = :resourceId or c.uniqueId = :resourceId) and co.uniqueId in (:courses) and co.instructionalOffering = r.instructionalOffering and r.area = c.academicArea and (rm is null or rm = cm) and (rc is null or rc = f.academicClassification)").setLong("resourceId", request.getResourceId().longValue()).setParameterList("courses", curriculumCourses).setCacheable(true).list()) {
                        Long offeringId = (Long)o[0];
                        Long configId = (Long)o[1];
                        Long clazzId = (Long)o[2];
                        Set[] r = (Set[])restrictions.get(offeringId);
                        if (r == null) {
                            r = new Set[]{new HashSet(), new HashSet()};
                            restrictions.put(offeringId, r);
                        }
                        if (configId != null) {
                            r[0].add(configId);
                        }
                        if (clazzId == null) continue;
                        r[1].add(clazzId);
                    }
                    if (limit <= 0 || meetings.size() < limit) {
                        meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o").where("o.ownerType = :type and o.ownerId in (:courses)").set("courses", curriculumCourses).set("type", 1).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                    }
                    if (limit <= 0 || meetings.size() < limit) {
                        meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, CourseOffering co").where("co.uniqueId in (:courses)").set("courses", curriculumCourses).where("o.ownerType = :type and o.ownerId = co.instructionalOffering.uniqueId").set("type", 0).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                    }
                    if (limit <= 0 || meetings.size() < limit) {
                        meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co").where("co.uniqueId in (:courses)").set("courses", curriculumCourses).where("o.ownerType = :type and o.ownerId = c.uniqueId").set("type", 3).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                    }
                    if (limit <= 0 || meetings.size() < limit) {
                        meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, CourseOffering co inner join co.instructionalOffering.instrOfferingConfigs cfg").where("co.uniqueId in (:courses)").set("courses", curriculumCourses).where("o.ownerType = :type and o.ownerId = cfg.uniqueId").set("type", 2).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                    }
                    if (limit <= 0 || meetings.size() < limit) {
                        meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, CourseOffering co").where("o.ownerType = :type and o.ownerId in (:courses)").set("courses", curriculumCourses).set("type", 1).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                    }
                    if (limit <= 0 || meetings.size() < limit) {
                        meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, CourseOffering co").where("co.uniqueId in (:courses)").set("courses", curriculumCourses).where("o.ownerType = :type and o.ownerId = co.instructionalOffering.uniqueId").set("type", 0).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                    }
                    if (limit <= 0 || meetings.size() < limit) {
                        meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co").where("co.uniqueId in (:courses)").set("courses", curriculumCourses).where("o.ownerType = :type and o.ownerId = c.uniqueId").set("type", 3).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                    }
                    if (limit > 0 && meetings.size() >= limit) break;
                    meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, CourseOffering co inner join co.instructionalOffering.instrOfferingConfigs cfg").where("co.uniqueId in (:courses)").set("courses", curriculumCourses).where("o.ownerType = :type and o.ownerId = cfg.uniqueId").set("type", 2).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                    break;
                }
                case DEPARTMENT: {
                    department = (Department)DepartmentDAO.getInstance().get(request.getResourceId(), hibSession);
                    if (department.isExternalManager().booleanValue()) {
                        meetings = query.select("distinct m").type("ClassEvent").from("inner join e.clazz.managingDept d").where("d.uniqueId = :resourceId").set("resourceId", request.getResourceId()).limit(1 + limit).query(hibSession).list();
                        break;
                    }
                    meetings = query.select("distinct m").type("ClassEvent").from("inner join e.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co inner join co.subjectArea.department d").where("d.uniqueId = :resourceId").set("resourceId", request.getResourceId()).limit(1 + limit).query(hibSession).list();
                    if (limit <= 0 || meetings.size() < limit) {
                        meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, CourseOffering co inner join co.subjectArea.department d").where("d.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = co.uniqueId").set("type", 1).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                    }
                    if (limit <= 0 || meetings.size() < limit) {
                        meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, CourseOffering co inner join co.subjectArea.department d").where("d.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = co.instructionalOffering.uniqueId").set("type", 0).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                    }
                    if (limit <= 0 || meetings.size() < limit) {
                        meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co inner join co.subjectArea.department d").where("d.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = c.uniqueId").set("type", 3).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                    }
                    if (limit <= 0 || meetings.size() < limit) {
                        meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, CourseOffering co inner join co.instructionalOffering.instrOfferingConfigs cfg inner join co.subjectArea.department d").where("d.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = cfg.uniqueId").set("type", 2).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                    }
                    if (limit <= 0 || meetings.size() < limit) {
                        meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, CourseOffering co inner join co.subjectArea.department d").where("d.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = co.uniqueId").set("type", 1).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                    }
                    if (limit <= 0 || meetings.size() < limit) {
                        meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, CourseOffering co inner join co.subjectArea.department d").where("d.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = co.instructionalOffering.uniqueId").set("type", 0).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                    }
                    if (limit <= 0 || meetings.size() < limit) {
                        meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co inner join co.subjectArea.department d").where("d.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = c.uniqueId").set("type", 3).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                    }
                    if (limit > 0 && meetings.size() >= limit) break;
                    meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, CourseOffering co inner join co.instructionalOffering.instrOfferingConfigs cfg inner join co.subjectArea.department d").where("d.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = cfg.uniqueId").set("type", 2).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                    break;
                }
                case PERSON: {
                    boolean allSessions = request.getEventFilter().hasOption("flag") && request.getEventFilter().getOptions("flag").contains("All Sessions");
                    Set<String> roles = request.getEventFilter().getOptions("role");
                    boolean student = roles == null || roles.contains("student") || roles.contains("Student");
                    boolean instructor = roles == null || roles.contains("instructor") || roles.contains("Instructor");
                    boolean contact2 = roles == null || roles.contains("contact") || roles.contains("Contact");
                    boolean coordinator = roles != null && (roles.contains("coordinator") || roles.contains("Coordinator"));
                    HashSet<Long> excludeSessionIds = null;
                    if (allSessions && student) {
                        for (Student s : hibSession.createQuery("from Student where externalUniqueId = :externalId").setString("externalId", request.getResourceExternalId()).setCacheable(true).list()) {
                            StudentSectioningStatus status = s == null ? null : s.getEffectiveStatus();
                            if (status == null || !status.hasOption(StudentSectioningStatus.Option.noschedule)) continue;
                            if (excludeSessionIds == null) {
                                excludeSessionIds = new HashSet<Long>();
                            }
                            excludeSessionIds.add(s.getSession().getUniqueId());
                        }
                    }
                    if (!allSessions && student) {
                        StudentSectioningStatus status;
                        Student s = Student.findByExternalId(request.getSessionId(), request.getResourceExternalId());
                        StudentSectioningStatus studentSectioningStatus = status = s == null ? null : s.getEffectiveStatus();
                        if (status != null && status.hasOption(StudentSectioningStatus.Option.noschedule)) {
                            student = false;
                        }
                    }
                    curriculumCourses = new HashSet();
                    curriculumClasses = new HashSet();
                    if (allSessions) {
                        if (student) {
                            curriculumCourses.addAll(hibSession.createQuery("select e.courseOffering.uniqueId from StudentClassEnrollment e where e.student.externalUniqueId = :externalId").setString("externalId", request.getResourceExternalId()).list());
                            curriculumClasses.addAll(hibSession.createQuery("select e.clazz.uniqueId from StudentClassEnrollment e where e.student.externalUniqueId = :externalId").setString("externalId", request.getResourceExternalId()).list());
                        }
                        if (instructor) {
                            curriculumCourses.addAll(hibSession.createQuery("select co.uniqueId from ClassInstructor i inner join i.classInstructing.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co where i.instructor.externalUniqueId = :externalId and co.isControl = true").setString("externalId", request.getResourceExternalId()).list());
                            curriculumClasses.addAll(hibSession.createQuery("select i.classInstructing.uniqueId from ClassInstructor i where i.instructor.externalUniqueId = :externalId").setString("externalId", request.getResourceExternalId()).list());
                        }
                        if (coordinator) {
                            curriculumCourses.addAll(hibSession.createQuery("select co.uniqueId from OfferingCoordinator c inner join c.offering.courseOfferings co where c.instructor.externalUniqueId = :externalId").setString("externalId", request.getResourceExternalId()).list());
                            curriculumClasses.addAll(hibSession.createQuery("select z.uniqueId from Class_ z inner join z.schedulingSubpart.instrOfferingConfig.instructionalOffering.offeringCoordinators c where c.instructor.externalUniqueId = :externalId").setString("externalId", request.getResourceExternalId()).list());
                        }
                    } else {
                        if (student) {
                            curriculumCourses.addAll(hibSession.createQuery("select e.courseOffering.uniqueId from StudentClassEnrollment e where e.student.session.uniqueId = :sessionId and e.student.externalUniqueId = :externalId").setLong("sessionId", request.getSessionId().longValue()).setString("externalId", request.getResourceExternalId()).list());
                            curriculumClasses.addAll(hibSession.createQuery("select e.clazz.uniqueId from StudentClassEnrollment e where e.student.session.uniqueId = :sessionId and e.student.externalUniqueId = :externalId").setLong("sessionId", request.getSessionId().longValue()).setString("externalId", request.getResourceExternalId()).list());
                        }
                        if (instructor) {
                            curriculumCourses.addAll(hibSession.createQuery("select co.uniqueId from ClassInstructor i inner join i.classInstructing.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co where i.instructor.externalUniqueId = :externalId and co.isControl = true and i.instructor.department.session.uniqueId = :sessionId").setLong("sessionId", request.getSessionId().longValue()).setString("externalId", request.getResourceExternalId()).list());
                            curriculumClasses.addAll(hibSession.createQuery("select i.classInstructing.uniqueId from ClassInstructor i where i.instructor.externalUniqueId = :externalId and i.instructor.department.session.uniqueId = :sessionId").setLong("sessionId", request.getSessionId().longValue()).setString("externalId", request.getResourceExternalId()).list());
                        }
                        if (coordinator) {
                            curriculumCourses.addAll(hibSession.createQuery("select co.uniqueId from OfferingCoordinator c inner join c.offering.courseOfferings co where c.instructor.externalUniqueId = :externalId and c.instructor.department.session.uniqueId = :sessionId").setLong("sessionId", request.getSessionId().longValue()).setString("externalId", request.getResourceExternalId()).list());
                            curriculumClasses.addAll(hibSession.createQuery("select z.uniqueId from Class_ z inner join z.schedulingSubpart.instrOfferingConfig.instructionalOffering.offeringCoordinators c where c.instructor.externalUniqueId = :externalId and c.instructor.department.session.uniqueId = :sessionId").setLong("sessionId", request.getSessionId().longValue()).setString("externalId", request.getResourceExternalId()).list());
                        }
                    }
                    meetings = new ArrayList();
                    if (allSessions) {
                        if (student && (limit <= 0 || meetings.size() < limit)) {
                            meetings.addAll(query.select("distinct m").type("ClassEvent").from("inner join e.clazz.studentEnrollments enrl").where("enrl.student.externalUniqueId = :externalId").where("enrl.student.session.uniqueId = s.uniqueId").set("externalId", request.getResourceExternalId()).where("enrl.student.session.uniqueId not in :excludeSessionIds", "excludeSessionIds", excludeSessionIds).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (instructor && (limit <= 0 || meetings.size() < limit)) {
                            meetings.addAll(query.select("distinct m").type("ClassEvent").from("inner join e.clazz.classInstructors ci").where("ci.instructor.externalUniqueId = :externalId").where("ci.instructor.department.session.uniqueId = s.uniqueId").set("externalId", request.getResourceExternalId()).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (coordinator && (limit <= 0 || meetings.size() < limit)) {
                            meetings.addAll(query.select("distinct m").type("ClassEvent").from("inner join e.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering.offeringCoordinators cc").where("cc.instructor.externalUniqueId = :externalId").where("cc.instructor.department.session.uniqueId = s.uniqueId").set("externalId", request.getResourceExternalId()).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                    } else {
                        if (student && (limit <= 0 || meetings.size() < limit)) {
                            meetings.addAll(query.select("distinct m").type("ClassEvent").from("inner join e.clazz.studentEnrollments enrl").where("enrl.student.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("enrl.student.session = s").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (instructor && (limit <= 0 || meetings.size() < limit)) {
                            meetings.addAll(query.select("distinct m").type("ClassEvent").from("inner join e.clazz.classInstructors ci").where("ci.instructor.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("ci.instructor.department.session = s").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (coordinator && (limit <= 0 || meetings.size() < limit)) {
                            meetings.addAll(query.select("distinct m").type("ClassEvent").from("inner join e.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering.offeringCoordinators cc").where("cc.instructor.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("cc.instructor.department.session = s").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                    }
                    if (allSessions) {
                        if (student && (limit <= 0 || meetings.size() < limit)) {
                            meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, StudentClassEnrollment enrl inner join enrl.courseOffering co").where("enrl.student.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = co.uniqueId").set("type", 1).where("enrl.student.session.uniqueId = s.uniqueId").where("enrl.student.session.uniqueId not in :excludeSessionIds", "excludeSessionIds", excludeSessionIds).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (student && (limit <= 0 || meetings.size() < limit)) {
                            meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, StudentClassEnrollment enrl inner join enrl.courseOffering co").where("enrl.student.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = co.instructionalOffering.uniqueId").set("type", 0).where("enrl.student.session.uniqueId = s.uniqueId").where("enrl.student.session.uniqueId not in :excludeSessionIds", "excludeSessionIds", excludeSessionIds).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (student && (limit <= 0 || meetings.size() < limit)) {
                            meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, StudentClassEnrollment enrl inner join enrl.clazz c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co").where("enrl.student.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = c.uniqueId").set("type", 3).where("enrl.student.session.uniqueId = s.uniqueId").where("enrl.student.session.uniqueId not in :excludeSessionIds", "excludeSessionIds", excludeSessionIds).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (student && (limit <= 0 || meetings.size() < limit)) {
                            meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, StudentClassEnrollment enrl inner join enrl.clazz c inner join c.schedulingSubpart.instrOfferingConfig cfg").where("enrl.student.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = cfg.uniqueId").set("type", 2).where("enrl.student.session.uniqueId = s.uniqueId").where("enrl.student.session.uniqueId not in :excludeSessionIds", "excludeSessionIds", excludeSessionIds).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (instructor && (limit <= 0 || meetings.size() < limit)) {
                            meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.instructors i").where("i.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("i.department.session.uniqueId = s.uniqueId").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (instructor && ApplicationProperty.EventExamsConsiderClassInstructorAssignments.isTrue() && (limit <= 0 || meetings.size() < limit)) {
                            meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, ClassInstructor ci inner join ci.classInstructing.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co").where("ci.instructor.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = co.uniqueId").set("type", 1).where("ci.instructor.department.session.uniqueId = s.uniqueId").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (instructor && ApplicationProperty.EventExamsConsiderClassInstructorAssignments.isTrue() && (limit <= 0 || meetings.size() < limit)) {
                            meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, ClassInstructor ci").where("ci.instructor.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = ci.classInstructing.schedulingSubpart.instrOfferingConfig.instructionalOffering.uniqueId").set("type", 0).where("ci.instructor.department.session.uniqueId = s.uniqueId").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (instructor && ApplicationProperty.EventExamsConsiderClassInstructorAssignments.isTrue() && (limit <= 0 || meetings.size() < limit)) {
                            meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, ClassInstructor ci").where("ci.instructor.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = ci.classInstructing.uniqueId").set("type", 3).where("ci.instructor.department.session.uniqueId = s.uniqueId").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (instructor && ApplicationProperty.EventExamsConsiderClassInstructorAssignments.isTrue() && (limit <= 0 || meetings.size() < limit)) {
                            meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, ClassInstructor ci").where("ci.instructor.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = ci.classInstructing.schedulingSubpart.instrOfferingConfig.uniqueId").set("type", 2).where("ci.instructor.department.session.uniqueId = s.uniqueId").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (coordinator && (limit <= 0 || meetings.size() < limit)) {
                            meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, CourseOffering co inner join co.instructionalOffering.offeringCoordinators cc").where("cc.instructor.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = co.uniqueId").set("type", 1).where("cc.instructor.department.session.uniqueId = s.uniqueId").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (coordinator && (limit <= 0 || meetings.size() < limit)) {
                            meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, CourseOffering co inner join co.instructionalOffering.offeringCoordinators cc").where("cc.instructor.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = co.instructionalOffering.uniqueId").set("type", 0).where("cc.instructor.department.session.uniqueId = s.uniqueId").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (coordinator && (limit <= 0 || meetings.size() < limit)) {
                            meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.offeringCoordinators cc").where("cc.instructor.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = c.uniqueId").set("type", 3).where("cc.instructor.department.session.uniqueId = s.uniqueId").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (coordinator && (limit <= 0 || meetings.size() < limit)) {
                            meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, InstrOfferingConfig cfg inner join cfg.instructionalOffering.offeringCoordinators cc").where("cc.instructor.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = cfg.uniqueId").set("type", 2).where("cc.instructor.department.session.uniqueId = s.uniqueId").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                    } else {
                        if (student && (limit <= 0 || meetings.size() < limit)) {
                            meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, StudentClassEnrollment enrl inner join enrl.courseOffering co").where("enrl.student.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = co.uniqueId").set("type", 1).where("e.exam.session = s").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (student && (limit <= 0 || meetings.size() < limit)) {
                            meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, StudentClassEnrollment enrl inner join enrl.courseOffering co").where("enrl.student.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = co.instructionalOffering.uniqueId").set("type", 0).where("e.exam.session = s").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (student && (limit <= 0 || meetings.size() < limit)) {
                            meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, StudentClassEnrollment enrl inner join enrl.clazz c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co").where("enrl.student.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = c.uniqueId").set("type", 3).where("e.exam.session = s").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (student && (limit <= 0 || meetings.size() < limit)) {
                            meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, StudentClassEnrollment enrl inner join enrl.clazz c inner join c.schedulingSubpart.instrOfferingConfig cfg").where("enrl.student.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = cfg.uniqueId").set("type", 2).where("e.exam.session = s").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (instructor && (limit <= 0 || meetings.size() < limit)) {
                            meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.instructors i").where("i.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("e.exam.session = s").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (instructor && ApplicationProperty.EventExamsConsiderClassInstructorAssignments.isTrue() && (limit <= 0 || meetings.size() < limit)) {
                            meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, ClassInstructor ci inner join ci.classInstructing.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co").where("ci.instructor.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = co.uniqueId").set("type", 1).where("ci.instructor.department.session = s").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (instructor && ApplicationProperty.EventExamsConsiderClassInstructorAssignments.isTrue() && (limit <= 0 || meetings.size() < limit)) {
                            meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, ClassInstructor ci").where("ci.instructor.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = ci.classInstructing.schedulingSubpart.instrOfferingConfig.instructionalOffering.uniqueId").set("type", 0).where("ci.instructor.department.session = s").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (instructor && ApplicationProperty.EventExamsConsiderClassInstructorAssignments.isTrue() && (limit <= 0 || meetings.size() < limit)) {
                            meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, ClassInstructor ci").where("ci.instructor.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = ci.classInstructing.uniqueId").set("type", 3).where("ci.instructor.department.session = s").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (instructor && ApplicationProperty.EventExamsConsiderClassInstructorAssignments.isTrue() && (limit <= 0 || meetings.size() < limit)) {
                            meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, ClassInstructor ci").where("ci.instructor.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = ci.classInstructing.schedulingSubpart.instrOfferingConfig.uniqueId").set("type", 2).where("ci.instructor.department.session = s").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (coordinator && (limit <= 0 || meetings.size() < limit)) {
                            meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, CourseOffering co inner join co.instructionalOffering.offeringCoordinators cc").where("cc.instructor.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = co.uniqueId").set("type", 1).where("cc.instructor.department.session = s").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (coordinator && (limit <= 0 || meetings.size() < limit)) {
                            meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, CourseOffering co inner join co.instructionalOffering.offeringCoordinators cc").where("cc.instructor.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = co.instructionalOffering.uniqueId").set("type", 0).where("cc.instructor.department.session = s").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (coordinator && (limit <= 0 || meetings.size() < limit)) {
                            meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.offeringCoordinators cc").where("cc.instructor.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = c.uniqueId").set("type", 3).where("cc.instructor.department.session = s").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (coordinator && (limit <= 0 || meetings.size() < limit)) {
                            meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, InstrOfferingConfig cfg inner join cfg.instructionalOffering.offeringCoordinators cc").where("cc.instructor.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = cfg.uniqueId").set("type", 2).where("cc.instructor.department.session = s").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                    }
                    if (allSessions) {
                        if (student && (limit <= 0 || meetings.size() < limit)) {
                            meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, StudentClassEnrollment enrl inner join enrl.courseOffering co").where("enrl.student.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = co.uniqueId").set("type", 1).where("enrl.student.session.uniqueId = s.uniqueId").where("enrl.student.session.uniqueId not in :excludeSessionIds", "excludeSessionIds", excludeSessionIds).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (student && (limit <= 0 || meetings.size() < limit)) {
                            meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, StudentClassEnrollment enrl inner join enrl.courseOffering co").where("enrl.student.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = co.instructionalOffering.uniqueId").set("type", 0).where("enrl.student.session.uniqueId = s.uniqueId").where("enrl.student.session.uniqueId not in :excludeSessionIds", "excludeSessionIds", excludeSessionIds).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (student && (limit <= 0 || meetings.size() < limit)) {
                            meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, StudentClassEnrollment enrl inner join enrl.clazz c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co").where("enrl.student.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = c.uniqueId").set("type", 3).where("enrl.student.session.uniqueId = s.uniqueId").where("enrl.student.session.uniqueId not in :excludeSessionIds", "excludeSessionIds", excludeSessionIds).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (student && (limit <= 0 || meetings.size() < limit)) {
                            meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, StudentClassEnrollment enrl inner join enrl.clazz c inner join c.schedulingSubpart.instrOfferingConfig cfg").where("enrl.student.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = cfg.uniqueId").set("type", 2).where("enrl.student.session.uniqueId = s.uniqueId").where("enrl.student.session.uniqueId not in :excludeSessionIds", "excludeSessionIds", excludeSessionIds).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (instructor && (limit <= 0 || meetings.size() < limit)) {
                            meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, ClassInstructor ci inner join ci.classInstructing c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co").where("ci.instructor.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = co.uniqueId").set("type", 1).where("ci.instructor.department.session.uniqueId = s.uniqueId").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (instructor && (limit <= 0 || meetings.size() < limit)) {
                            meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, ClassInstructor ci").where("ci.instructor.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = ci.classInstructing.schedulingSubpart.instrOfferingConfig.instructionalOffering.uniqueId").set("type", 0).where("ci.instructor.department.session.uniqueId = s.uniqueId").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (instructor && (limit <= 0 || meetings.size() < limit)) {
                            meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, ClassInstructor ci").where("ci.instructor.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = ci.classInstructing.schedulingSubpart.instrOfferingConfig.uniqueId").set("type", 2).where("ci.instructor.department.session.uniqueId = s.uniqueId").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (instructor && (limit <= 0 || meetings.size() < limit)) {
                            meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, ClassInstructor ci").where("ci.instructor.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = ci.classInstructing.uniqueId").set("type", 3).where("ci.instructor.department.session.uniqueId = s.uniqueId").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (coordinator && (limit <= 0 || meetings.size() < limit)) {
                            meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, CourseOffering co inner join co.instructionalOffering.offeringCoordinators cc").where("cc.instructor.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = co.uniqueId").set("type", 1).where("cc.instructor.department.session.uniqueId = s.uniqueId").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (coordinator && (limit <= 0 || meetings.size() < limit)) {
                            meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, CourseOffering co inner join co.instructionalOffering.offeringCoordinators cc").where("cc.instructor.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = co.instructionalOffering.uniqueId").set("type", 0).where("cc.instructor.department.session.uniqueId = s.uniqueId").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (coordinator && (limit <= 0 || meetings.size() < limit)) {
                            meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, InstrOfferingConfig cfg inner join cfg.instructionalOffering.offeringCoordinators cc").where("cc.instructor.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = cfg.uniqueId").set("type", 2).where("cc.instructor.department.session.uniqueId = s.uniqueId").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (coordinator && (limit <= 0 || meetings.size() < limit)) {
                            meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.offeringCoordinators cc").where("cc.instructor.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = c.uniqueId").set("type", 3).where("cc.instructor.department.session.uniqueId = s.uniqueId").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                    } else {
                        if (student && (limit <= 0 || meetings.size() < limit)) {
                            meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, StudentClassEnrollment enrl inner join enrl.courseOffering co").where("enrl.student.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = co.uniqueId").where("enrl.student.session = s").set("type", 1).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (student && (limit <= 0 || meetings.size() < limit)) {
                            meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, StudentClassEnrollment enrl inner join enrl.courseOffering co").where("enrl.student.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = co.instructionalOffering.uniqueId").where("enrl.student.session = s").set("type", 0).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (student && (limit <= 0 || meetings.size() < limit)) {
                            meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, StudentClassEnrollment enrl inner join enrl.clazz c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co").where("enrl.student.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = c.uniqueId").where("enrl.student.session = s").set("type", 3).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (student && (limit <= 0 || meetings.size() < limit)) {
                            meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, StudentClassEnrollment enrl inner join enrl.clazz c inner join c.schedulingSubpart.instrOfferingConfig cfg").where("enrl.student.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = cfg.uniqueId").where("enrl.student.session = s").set("type", 2).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (instructor && (limit <= 0 || meetings.size() < limit)) {
                            meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, ClassInstructor ci inner join ci.classInstructing c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co").where("ci.instructor.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = co.uniqueId").where("ci.instructor.department.session = s").set("type", 1).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (instructor && (limit <= 0 || meetings.size() < limit)) {
                            meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, ClassInstructor ci").where("ci.instructor.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = ci.classInstructing.schedulingSubpart.instrOfferingConfig.instructionalOffering.uniqueId").where("ci.instructor.department.session = s").set("type", 0).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (instructor && (limit <= 0 || meetings.size() < limit)) {
                            meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, ClassInstructor ci").where("ci.instructor.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = ci.classInstructing.schedulingSubpart.instrOfferingConfig.uniqueId").where("ci.instructor.department.session = s").set("type", 2).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (instructor && (limit <= 0 || meetings.size() < limit)) {
                            meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, ClassInstructor ci").where("ci.instructor.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = ci.classInstructing.uniqueId").where("ci.instructor.department.session = s").set("type", 3).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (coordinator && (limit <= 0 || meetings.size() < limit)) {
                            meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, CourseOffering co inner join co.instructionalOffering.offeringCoordinators cc").where("cc.instructor.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = co.uniqueId").where("cc.instructor.department.session = s").set("type", 1).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (coordinator && (limit <= 0 || meetings.size() < limit)) {
                            meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, CourseOffering co inner join co.instructionalOffering.offeringCoordinators cc").where("cc.instructor.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = co.instructionalOffering.uniqueId").where("cc.instructor.department.session = s").set("type", 0).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (coordinator && (limit <= 0 || meetings.size() < limit)) {
                            meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.offeringCoordinators cc").where("cc.instructor.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = c.uniqueId").where("cc.instructor.department.session = s").set("type", 3).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (coordinator && (limit <= 0 || meetings.size() < limit)) {
                            meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, InstrOfferingConfig cfg inner join cfg.instructionalOffering.offeringCoordinators cc").where("cc.instructor.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = cfg.uniqueId").where("cc.instructor.department.session = s").set("type", 2).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                    }
                    if (contact2 && (limit <= 0 || meetings.size() < limit)) {
                        meetings.addAll(query.select("distinct m").where("e.class in (CourseEvent, SpecialEvent, UnavailableEvent)").where("e.mainContact.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                    }
                    if (contact2 && (limit <= 0 || meetings.size() < limit)) {
                        meetings.addAll(query.select("distinct m").from("inner join m.event.additionalContacts c").where("c.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                    }
                    if (contact2 && (limit <= 0 || meetings.size() < limit)) {
                        meetings.addAll(query.select("distinct m").from("inner join m.meetingContacts c").where("c.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                    }
                    if (!contact2 || limit > 0 && meetings.size() >= limit) break;
                    meetings.addAll(query.select("distinct m").from("EventContact c").where("c.externalUniqueId = :externalId").where("c.emailAddress is not null").where("lower(m.event.email) like '%' || lower(c.emailAddress) || '%'").set("externalId", request.getResourceExternalId()).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                    break;
                }
                case GROUP: {
                    Object ec;
                    boolean allSessions = request.getEventFilter().hasOption("flag") && request.getEventFilter().getOptions("flag").contains("All Sessions");
                    curriculumCourses = new HashSet();
                    curriculumClasses = new HashSet();
                    Integer minEnrollment = null;
                    String pMinEnrl = ApplicationProperty.StudentGroupsTimetableMinimalEnrollment.value();
                    if (pMinEnrl != null) {
                        minEnrollment = pMinEnrl.endsWith("%") ? Integer.valueOf((int)Math.floor(Double.parseDouble(pMinEnrl.substring(0, pMinEnrl.length() - 1)) * (double)group.getStudents().size() / 100.0)) : Integer.valueOf(Integer.parseInt(pMinEnrl));
                    }
                    if (allSessions) {
                        if (group.getExternalUniqueId() != null) {
                            curriculumCourses.addAll(hibSession.createQuery("select distinct e.courseOffering.uniqueId from StudentGroup g inner join g.students s inner join s.classEnrollments e where g.externalId = :externalId").setString("externalId", group.getExternalUniqueId()).list());
                            curriculumClasses.addAll(hibSession.createQuery("select distinct e.clazz.uniqueId from StudentGroup g inner join g.students s inner join s.classEnrollments e where g.externalId = :externalId").setString("externalId", group.getExternalUniqueId()).list());
                        } else {
                            curriculumCourses.addAll(hibSession.createQuery("select distinct e.courseOffering.uniqueId from StudentGroup g inner join g.students s inner join s.classEnrollments e where g.groupAbbreviation = :abbreviation").setString("abbreviation", group.getGroupAbbreviation()).list());
                            curriculumClasses.addAll(hibSession.createQuery("select distinct e.clazz.uniqueId from StudentGroup g inner join g.students s inner join s.classEnrollments e where g.groupAbbreviation = :abbreviation").setString("abbreviation", group.getGroupAbbreviation()).list());
                        }
                    } else {
                        curriculumCourses.addAll(hibSession.createQuery("select distinct e.courseOffering.uniqueId from StudentGroup g inner join g.students s inner join s.classEnrollments e where g.uniqueId = :resourceId").setLong("resourceId", group.getUniqueId().longValue()).list());
                        curriculumClasses.addAll(hibSession.createQuery("select distinct e.clazz.uniqueId from StudentGroup g inner join g.students s inner join s.classEnrollments e where g.uniqueId = :resourceId").setLong("resourceId", group.getUniqueId().longValue()).list());
                    }
                    meetings = new ArrayList();
                    if (limit <= 0 || meetings.size() < limit) {
                        ec = query.select("distinct m").type("ClassEvent").from("inner join e.clazz.studentEnrollments enrl inner join enrl.student.groups grp");
                        if (minEnrollment != null) {
                            ((EventFilterBackend.EventQuery.EventInstance)ec).where("(select count(enrlX) from StudentClassEnrollment enrlX inner join enrlX.student.groups grpX where grpX.uniqueId = grp.uniqueId and enrlX.clazz.uniqueId = e.clazz.uniqueId) >= :minEnrl").set("minEnrl", minEnrollment);
                        }
                        if (allSessions) {
                            if (group.getExternalUniqueId() != null) {
                                ((EventFilterBackend.EventQuery.EventInstance)ec).where("grp.externalId = :externalId").set("externalId", group.getExternalUniqueId()).where("enrl.student.session.uniqueId = s.uniqueId");
                            } else {
                                ((EventFilterBackend.EventQuery.EventInstance)ec).where("grp.groupAbbreviation = :abbreviation").set("abbreviation", group.getGroupAbbreviation()).where("enrl.student.session.uniqueId = s.uniqueId");
                            }
                        } else {
                            ((EventFilterBackend.EventQuery.EventInstance)ec).where("grp.uniqueId = :resourceId").set("resourceId", group.getUniqueId());
                        }
                        meetings.addAll(((EventFilterBackend.EventQuery.EventInstance)ec).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                    }
                    if (limit <= 0 || meetings.size() < limit) {
                        ec = query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, StudentClassEnrollment enrl inner join enrl.courseOffering co inner join enrl.student.groups grp").where("o.ownerType = :type and o.ownerId = co.uniqueId").set("type", 1);
                        if (minEnrollment != null) {
                            ((EventFilterBackend.EventQuery.EventInstance)ec).where("(select count(enrlX) from StudentClassEnrollment enrlX inner join enrlX.student.groups grpX where grpX.uniqueId = grp.uniqueId and enrlX.courseOffering.uniqueId = co.uniqueId) >= :minEnrl").set("minEnrl", minEnrollment);
                        }
                        if (allSessions) {
                            if (group.getExternalUniqueId() != null) {
                                ((EventFilterBackend.EventQuery.EventInstance)ec).where("grp.externalId = :externalId").set("externalId", group.getExternalUniqueId()).where("enrl.student.session.uniqueId = s.uniqueId");
                            } else {
                                ((EventFilterBackend.EventQuery.EventInstance)ec).where("grp.groupAbbreviation = :abbreviation").set("abbreviation", group.getGroupAbbreviation()).where("enrl.student.session.uniqueId = s.uniqueId");
                            }
                        } else {
                            ((EventFilterBackend.EventQuery.EventInstance)ec).where("grp.uniqueId = :resourceId").set("resourceId", group.getUniqueId());
                        }
                        meetings.addAll(((EventFilterBackend.EventQuery.EventInstance)ec).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                    }
                    if (limit <= 0 || meetings.size() < limit) {
                        ec = query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, StudentClassEnrollment enrl inner join enrl.courseOffering co inner join enrl.student.groups grp").where("o.ownerType = :type and o.ownerId = co.instructionalOffering.uniqueId").set("type", 0);
                        if (minEnrollment != null) {
                            ((EventFilterBackend.EventQuery.EventInstance)ec).where("(select count(enrlX) from StudentClassEnrollment enrlX inner join enrlX.student.groups grpX where grpX.uniqueId = grp.uniqueId and enrlX.courseOffering.uniqueId = co.uniqueId) >= :minEnrl").set("minEnrl", minEnrollment);
                        }
                        if (allSessions) {
                            if (group.getExternalUniqueId() != null) {
                                ((EventFilterBackend.EventQuery.EventInstance)ec).where("grp.externalId = :externalId").set("externalId", group.getExternalUniqueId()).where("enrl.student.session.uniqueId = s.uniqueId");
                            } else {
                                ((EventFilterBackend.EventQuery.EventInstance)ec).where("grp.groupAbbreviation = :abbreviation").set("abbreviation", group.getGroupAbbreviation()).where("enrl.student.session.uniqueId = s.uniqueId");
                            }
                        } else {
                            ((EventFilterBackend.EventQuery.EventInstance)ec).where("grp.uniqueId = :resourceId").set("resourceId", group.getUniqueId());
                        }
                        meetings.addAll(((EventFilterBackend.EventQuery.EventInstance)ec).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                    }
                    if (limit <= 0 || meetings.size() < limit) {
                        ec = query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, StudentClassEnrollment enrl inner join enrl.clazz c inner join enrl.student.groups grp").where("o.ownerType = :type and o.ownerId = c.uniqueId").set("type", 3);
                        if (minEnrollment != null) {
                            ((EventFilterBackend.EventQuery.EventInstance)ec).where("(select count(enrlX) from StudentClassEnrollment enrlX inner join enrlX.student.groups grpX where grpX.uniqueId = grp.uniqueId and enrlX.clazz.uniqueId = c.uniqueId) >= :minEnrl").set("minEnrl", minEnrollment);
                        }
                        if (allSessions) {
                            if (group.getExternalUniqueId() != null) {
                                ((EventFilterBackend.EventQuery.EventInstance)ec).where("grp.externalId = :externalId").set("externalId", group.getExternalUniqueId()).where("enrl.student.session.uniqueId = s.uniqueId");
                            } else {
                                ((EventFilterBackend.EventQuery.EventInstance)ec).where("grp.groupAbbreviation = :abbreviation").set("abbreviation", group.getGroupAbbreviation()).where("enrl.student.session.uniqueId = s.uniqueId");
                            }
                        } else {
                            ((EventFilterBackend.EventQuery.EventInstance)ec).where("grp.uniqueId = :resourceId").set("resourceId", group.getUniqueId());
                        }
                        meetings.addAll(((EventFilterBackend.EventQuery.EventInstance)ec).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                    }
                    if (limit <= 0 || meetings.size() < limit) {
                        ec = query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, StudentClassEnrollment enrl inner join enrl.clazz c inner join c.schedulingSubpart.instrOfferingConfig cfg inner join enrl.student.groups grp").where("o.ownerType = :type and o.ownerId = cfg.uniqueId").set("type", 2);
                        if (minEnrollment != null) {
                            ((EventFilterBackend.EventQuery.EventInstance)ec).where("(select count(enrlX) from StudentClassEnrollment enrlX inner join enrlX.student.groups grpX where grpX.uniqueId = grp.uniqueId and enrlX.clazz.uniqueId = c.uniqueId) >= :minEnrl").set("minEnrl", minEnrollment);
                        }
                        if (allSessions) {
                            if (group.getExternalUniqueId() != null) {
                                ((EventFilterBackend.EventQuery.EventInstance)ec).where("grp.externalId = :externalId").set("externalId", group.getExternalUniqueId()).where("enrl.student.session.uniqueId = s.uniqueId");
                            } else {
                                ((EventFilterBackend.EventQuery.EventInstance)ec).where("grp.groupAbbreviation = :abbreviation").set("abbreviation", group.getGroupAbbreviation()).where("enrl.student.session.uniqueId = s.uniqueId");
                            }
                        } else {
                            ((EventFilterBackend.EventQuery.EventInstance)ec).where("grp.uniqueId = :resourceId").set("resourceId", group.getUniqueId());
                        }
                        meetings.addAll(((EventFilterBackend.EventQuery.EventInstance)ec).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                    }
                    if (limit <= 0 || meetings.size() < limit) {
                        ec = query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, StudentClassEnrollment enrl inner join enrl.courseOffering co inner join enrl.student.groups grp").where("o.ownerType = :type and o.ownerId = co.uniqueId").set("type", 1);
                        if (minEnrollment != null) {
                            ((EventFilterBackend.EventQuery.EventInstance)ec).where("(select count(enrlX) from StudentClassEnrollment enrlX inner join enrlX.student.groups grpX where grpX.uniqueId = grp.uniqueId and enrlX.courseOffering.uniqueId = co.uniqueId) >= :minEnrl").set("minEnrl", minEnrollment);
                        }
                        if (allSessions) {
                            if (group.getExternalUniqueId() != null) {
                                ((EventFilterBackend.EventQuery.EventInstance)ec).where("grp.externalId = :externalId").set("externalId", group.getExternalUniqueId()).where("enrl.student.session.uniqueId = s.uniqueId");
                            } else {
                                ((EventFilterBackend.EventQuery.EventInstance)ec).where("grp.groupAbbreviation = :abbreviation").set("abbreviation", group.getGroupAbbreviation()).where("enrl.student.session.uniqueId = s.uniqueId");
                            }
                        } else {
                            ((EventFilterBackend.EventQuery.EventInstance)ec).where("grp.uniqueId = :resourceId").set("resourceId", group.getUniqueId());
                        }
                        meetings.addAll(((EventFilterBackend.EventQuery.EventInstance)ec).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                    }
                    if (limit <= 0 || meetings.size() < limit) {
                        ec = query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, StudentClassEnrollment enrl inner join enrl.courseOffering co inner join enrl.student.groups grp").where("o.ownerType = :type and o.ownerId = co.instructionalOffering.uniqueId").set("type", 0);
                        if (minEnrollment != null) {
                            ((EventFilterBackend.EventQuery.EventInstance)ec).where("(select count(enrlX) from StudentClassEnrollment enrlX inner join enrlX.student.groups grpX where grpX.uniqueId = grp.uniqueId and enrlX.courseOffering.uniqueId = co.uniqueId) >= :minEnrl").set("minEnrl", minEnrollment);
                        }
                        if (allSessions) {
                            if (group.getExternalUniqueId() != null) {
                                ((EventFilterBackend.EventQuery.EventInstance)ec).where("grp.externalId = :externalId").set("externalId", group.getExternalUniqueId()).where("enrl.student.session.uniqueId = s.uniqueId");
                            } else {
                                ((EventFilterBackend.EventQuery.EventInstance)ec).where("grp.groupAbbreviation = :abbreviation").set("abbreviation", group.getGroupAbbreviation()).where("enrl.student.session.uniqueId = s.uniqueId");
                            }
                        } else {
                            ((EventFilterBackend.EventQuery.EventInstance)ec).where("grp.uniqueId = :resourceId").set("resourceId", group.getUniqueId());
                        }
                        meetings.addAll(((EventFilterBackend.EventQuery.EventInstance)ec).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                    }
                    if (limit <= 0 || meetings.size() < limit) {
                        ec = query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, StudentClassEnrollment enrl inner join enrl.clazz c inner join enrl.student.groups grp").where("o.ownerType = :type and o.ownerId = c.uniqueId").set("type", 3);
                        if (minEnrollment != null) {
                            ((EventFilterBackend.EventQuery.EventInstance)ec).where("(select count(enrlX) from StudentClassEnrollment enrlX inner join enrlX.student.groups grpX where grpX.uniqueId = grp.uniqueId and enrlX.clazz.uniqueId = c.uniqueId) >= :minEnrl").set("minEnrl", minEnrollment);
                        }
                        if (allSessions) {
                            if (group.getExternalUniqueId() != null) {
                                ((EventFilterBackend.EventQuery.EventInstance)ec).where("grp.externalId = :externalId").set("externalId", group.getExternalUniqueId()).where("enrl.student.session.uniqueId = s.uniqueId");
                            } else {
                                ((EventFilterBackend.EventQuery.EventInstance)ec).where("grp.groupAbbreviation = :abbreviation").set("abbreviation", group.getGroupAbbreviation()).where("enrl.student.session.uniqueId = s.uniqueId");
                            }
                        } else {
                            ((EventFilterBackend.EventQuery.EventInstance)ec).where("grp.uniqueId = :resourceId").set("resourceId", group.getUniqueId());
                        }
                        meetings.addAll(((EventFilterBackend.EventQuery.EventInstance)ec).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                    }
                    if (limit > 0 && meetings.size() >= limit) break;
                    ec = query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, StudentClassEnrollment enrl inner join enrl.clazz c inner join c.schedulingSubpart.instrOfferingConfig cfg inner join enrl.student.groups grp").where("o.ownerType = :type and o.ownerId = cfg.uniqueId").set("type", 2);
                    if (minEnrollment != null) {
                        ((EventFilterBackend.EventQuery.EventInstance)ec).where("(select count(enrlX) from StudentClassEnrollment enrlX inner join enrlX.student.groups grpX where grpX.uniqueId = grp.uniqueId and enrlX.clazz.uniqueId = c.uniqueId) >= :minEnrl").set("minEnrl", minEnrollment);
                    }
                    if (allSessions) {
                        if (group.getExternalUniqueId() != null) {
                            ((EventFilterBackend.EventQuery.EventInstance)ec).where("grp.externalId = :externalId").set("externalId", group.getExternalUniqueId()).where("enrl.student.session.uniqueId = s.uniqueId");
                        } else {
                            ((EventFilterBackend.EventQuery.EventInstance)ec).where("grp.groupAbbreviation = :abbreviation").set("abbreviation", group.getGroupAbbreviation()).where("enrl.student.session.uniqueId = s.uniqueId");
                        }
                    } else {
                        ((EventFilterBackend.EventQuery.EventInstance)ec).where("grp.uniqueId = :resourceId").set("resourceId", group.getUniqueId());
                    }
                    meetings.addAll(((EventFilterBackend.EventQuery.EventInstance)ec).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                    break;
                }
                default: {
                    throw new GwtRpcException("Resource type " + request.getResourceType().getLabel() + " not supported.");
                }
            }
            GwtRpcResponseList<EventInterface> ret = new GwtRpcResponseList<EventInterface>();
            Hashtable<Long, EventInterface> events = new Hashtable<Long, EventInterface>();
            Hashtable<Long, HashSet<Location>> unavailableLocations = new Hashtable<Long, HashSet<Location>>();
            for (Meeting m : meetings) {
                EventInterface event;
                Location location;
                if (locationMap != null && m.getLocationPermanentId() != null && (location = (Location)locationMap.get(m.getLocationPermanentId())) != null) {
                    m.setLocation(location);
                }
                if ((event = (EventInterface)events.get(m.getEvent().getUniqueId())) == null) {
                    Iterator<EventNote> ce;
                    event = new EventInterface();
                    event.setId(m.getEvent().getUniqueId());
                    event.setName(m.getEvent().getEventName());
                    event.setType(EventInterface.EventType.values()[m.getEvent().getEventType()]);
                    events.put(m.getEvent().getUniqueId(), event);
                    event.setCanView(context.hasPermission(m.getEvent(), Right.EventDetail));
                    event.setMaxCapacity(m.getEvent().getMaxCapacity());
                    if (m.getEvent().getMainContact() != null) {
                        EventInterface.ContactInterface contact3 = new EventInterface.ContactInterface();
                        contact3.setFirstName(m.getEvent().getMainContact().getFirstName());
                        contact3.setMiddleName(m.getEvent().getMainContact().getMiddleName());
                        contact3.setLastName(m.getEvent().getMainContact().getLastName());
                        contact3.setAcademicTitle(m.getEvent().getMainContact().getAcademicTitle());
                        contact3.setEmail(m.getEvent().getMainContact().getEmailAddress());
                        contact3.setFormattedName(m.getEvent().getMainContact().getName(nameFormat));
                        event.setContact(contact3);
                    }
                    for (EventContact additional : m.getEvent().getAdditionalContacts()) {
                        EventInterface.ContactInterface contact4 = new EventInterface.ContactInterface();
                        contact4.setFirstName(additional.getFirstName());
                        contact4.setMiddleName(additional.getMiddleName());
                        contact4.setLastName(additional.getLastName());
                        contact4.setAcademicTitle(additional.getAcademicTitle());
                        contact4.setEmail(additional.getEmailAddress());
                        contact4.setFormattedName(additional.getName(nameFormat));
                        event.addAdditionalContact(contact4);
                    }
                    event.setEmail(m.getEvent().getEmail());
                    if (m.getEvent().getSponsoringOrganization() != null) {
                        EventInterface.SponsoringOrganizationInterface sponsor = new EventInterface.SponsoringOrganizationInterface();
                        sponsor.setEmail(m.getEvent().getSponsoringOrganization().getEmail());
                        sponsor.setName(m.getEvent().getSponsoringOrganization().getName());
                        sponsor.setUniqueId(m.getEvent().getSponsoringOrganization().getUniqueId());
                        event.setSponsor(sponsor);
                    }
                    event.setExpirationDate(m.getEvent().getExpirationDate());
                    for (EventServiceProvider p : m.getEvent().getRequestedServices()) {
                        if (!p.isVisible().booleanValue()) continue;
                        EventInterface.EventServiceProviderInterface provider = new EventInterface.EventServiceProviderInterface();
                        provider.setId(p.getUniqueId());
                        provider.setReference(p.getReference());
                        provider.setLabel(p.getLabel());
                        provider.setMessage(p.getNote());
                        provider.setEmail(p.getEmail());
                        event.addRequestedService(provider);
                    }
                    if (0 == m.getEvent().getEventType()) {
                        Object note;
                        Set[] r;
                        ce = (ClassEvent)ClassEventDAO.getInstance().get(m.getEvent().getUniqueId(), hibSession);
                        Class_ clazz = ((BaseClassEvent)((Object)ce)).getClazz();
                        Set[] setArray = r = restrictions == null ? null : (Set[])restrictions.get(clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getUniqueId());
                        if (r != null && EventLookupBackend.hide(r, clazz)) continue;
                        event.setEnrollment(clazz.getEnrollment());
                        if (groupEnrollments) {
                            int enrl = 0;
                            for (StudentClassEnrollment e : clazz.getStudentEnrollments()) {
                                if (!group.getStudents().contains(e.getStudent())) continue;
                                ++enrl;
                            }
                            event.setEnrollment(enrl);
                        }
                        event.setMaxCapacity(clazz.getClassLimit());
                        if (clazz.getDisplayInstructor().booleanValue()) {
                            for (ClassInstructor i : clazz.getClassInstructors()) {
                                if (i.getResponsibility() != null && i.getResponsibility().hasOption(TeachingResponsibility.Option.noevents)) continue;
                                EventInterface.ContactInterface instructor = new EventInterface.ContactInterface();
                                instructor.setFirstName(i.getInstructor().getFirstName());
                                instructor.setMiddleName(i.getInstructor().getMiddleName());
                                instructor.setLastName(i.getInstructor().getLastName());
                                instructor.setAcademicTitle(i.getInstructor().getAcademicTitle());
                                instructor.setEmail(i.getInstructor().getEmail());
                                instructor.setFormattedName(i.getInstructor().getName(nameFormat));
                                if (i.getResponsibility() != null) {
                                    instructor.setResponsibility(i.getResponsibility().getLabel());
                                    instructor.setResponsibilityAbbreviation(i.getResponsibility().getAbbreviation());
                                }
                                event.addInstructor(instructor);
                            }
                        }
                        CourseOffering correctedOffering = clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getControllingCourseOffering();
                        ArrayList<CourseOffering> courses = new ArrayList<CourseOffering>(clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getCourseOfferings());
                        boolean instructing = false;
                        if (request.getResourceType() == EventInterface.ResourceType.PERSON && request.getResourceExternalId() != null) {
                            for (ClassInstructor i : clazz.getClassInstructors()) {
                                if (!request.getResourceExternalId().equals(i.getInstructor().getExternalUniqueId())) continue;
                                instructing = true;
                                break;
                            }
                        }
                        switch (request.getResourceType()) {
                            case CURRICULUM: 
                            case PERSON: 
                            case GROUP: {
                                Iterator i = courses.iterator();
                                while (i.hasNext()) {
                                    CourseOffering co = (CourseOffering)i.next();
                                    if (curriculumCourses.contains(co.getUniqueId())) {
                                        if (curriculumCourses.contains(correctedOffering.getUniqueId())) continue;
                                        correctedOffering = co;
                                        continue;
                                    }
                                    if (instructing) continue;
                                    i.remove();
                                }
                                break;
                            }
                        }
                        courses.remove(correctedOffering);
                        event.addCourseId(correctedOffering.getUniqueId());
                        event.addCourseName(correctedOffering.getCourseName());
                        event.addCourseTitle(correctedOffering.getTitle() == null ? "" : correctedOffering.getTitle());
                        event.setInstruction(clazz.getSchedulingSubpart().getItype().getDesc().length() <= 20 ? clazz.getSchedulingSubpart().getItype().getDesc() : clazz.getSchedulingSubpart().getItype().getAbbv());
                        if (clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalMethod() != null) {
                            event.setInstruction(event.getInstruction() + " (" + clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalMethod().getLabel() + ")");
                        }
                        event.setInstructionType(clazz.getSchedulingSubpart().getItype().getItype());
                        event.setSectionNumber(clazz.getSectionNumberString(hibSession));
                        if (clazz.getClassSuffix(correctedOffering) == null) {
                            event.setName(clazz.getClassLabel(correctedOffering));
                        } else {
                            event.addExternalId(clazz.getClassSuffix(correctedOffering));
                            event.setName(correctedOffering.getCourseName() + " " + clazz.getClassSuffix(correctedOffering));
                        }
                        for (CourseOffering co : courses) {
                            event.addCourseId(co.getUniqueId());
                            event.addCourseName(co.getCourseName());
                            event.addCourseTitle(co.getTitle() == null ? "" : co.getTitle());
                            if (clazz.getClassSuffix(co) == null) continue;
                            event.addExternalId(clazz.getClassSuffix(co));
                        }
                        if (correctedOffering.getScheduleBookNote() != null && !correctedOffering.getScheduleBookNote().isEmpty()) {
                            note = new EventInterface.NoteInterface();
                            ((EventInterface.NoteInterface)note).setId(-2L);
                            ((EventInterface.NoteInterface)note).setNote(correctedOffering.getScheduleBookNote());
                            event.addNote((EventInterface.NoteInterface)note);
                        }
                        if (clazz.getSchedulePrintNote() != null && !clazz.getSchedulePrintNote().isEmpty()) {
                            note = new EventInterface.NoteInterface();
                            ((EventInterface.NoteInterface)note).setId(-1L);
                            ((EventInterface.NoteInterface)note).setNote(clazz.getSchedulePrintNote());
                            event.addNote((EventInterface.NoteInterface)note);
                        }
                    } else if (1 == m.getEvent().getEventType() || 2 == m.getEvent().getEventType()) {
                        ExamEvent xe = (ExamEvent)ExamEventDAO.getInstance().get(m.getEvent().getUniqueId(), hibSession);
                        event.setEnrollment(xe.getExam().countStudents());
                        event.setMaxCapacity(xe.getExam().getSize());
                        if (groupEnrollments) {
                            int enrl = 0;
                            Set<Long> studentIds = xe.getExam().getStudentIds();
                            for (Student s : group.getStudents()) {
                                if (!studentIds.contains(s.getUniqueId())) continue;
                                ++enrl;
                            }
                            event.setEnrollment(enrl);
                        }
                        for (DepartmentalInstructor i : xe.getExam().getInstructors()) {
                            EventInterface.ContactInterface instructor = new EventInterface.ContactInterface();
                            instructor.setFirstName(i.getFirstName());
                            instructor.setMiddleName(i.getMiddleName());
                            instructor.setLastName(i.getLastName());
                            instructor.setAcademicTitle(i.getAcademicTitle());
                            instructor.setEmail(i.getEmail());
                            instructor.setFormattedName(i.getName(nameFormat));
                            event.addInstructor(instructor);
                        }
                        boolean instructing = false;
                        if (request.getResourceType() == EventInterface.ResourceType.PERSON && request.getResourceExternalId() != null) {
                            for (DepartmentalInstructor i : xe.getExam().getInstructors()) {
                                if (!request.getResourceExternalId().equals(i.getExternalUniqueId())) continue;
                                instructing = true;
                                break;
                            }
                        }
                        String name = null;
                        for (Object owner : new TreeSet<ExamOwner>(xe.getExam().getOwners())) {
                            if (((BaseExamOwner)owner).getOwnerType() == 3 && !instructing && curriculumClasses != null && !curriculumClasses.contains(((BaseExamOwner)owner).getOwnerId())) continue;
                            TreeSet<CourseOffering> courses = new TreeSet<CourseOffering>();
                            if (((BaseExamOwner)owner).getOwnerType() == 1 || request.getResourceType() == EventInterface.ResourceType.ROOM) {
                                courses.add(((BaseExamOwner)owner).getCourse());
                            } else {
                                courses.addAll(((BaseExamOwner)owner).getCourse().getInstructionalOffering().getCourseOfferings());
                            }
                            block72: for (Object course : courses) {
                                switch (request.getResourceType()) {
                                    case CURRICULUM: 
                                    case PERSON: 
                                    case GROUP: {
                                        if (instructing && ((BaseCourseOffering)course).isIsControl().booleanValue() || curriculumCourses.contains(((BaseCourseOffering)course).getUniqueId())) break;
                                        continue block72;
                                    }
                                }
                                event.addCourseId(((BaseCourseOffering)course).getUniqueId());
                                event.addCourseName(((CourseOffering)course).getCourseName());
                                event.addCourseTitle(((BaseCourseOffering)course).getTitle() == null ? "" : ((BaseCourseOffering)course).getTitle());
                                name = ((CourseOffering)course).getCourseName();
                                switch (((BaseExamOwner)owner).getOwnerType()) {
                                    case 3: {
                                        Class_ clazz = (Class_)((ExamOwner)owner).getOwnerObject();
                                        if (clazz.getClassSuffix((CourseOffering)course) == null) {
                                            event.addExternalId(clazz.getItypeDesc().trim() + " " + clazz.getSectionNumberString(hibSession));
                                            name = ((CourseOffering)course).getCourseName() + " " + clazz.getClassLabel((CourseOffering)course);
                                            break;
                                        }
                                        event.addExternalId(clazz.getClassSuffix((CourseOffering)course));
                                        name = ((CourseOffering)course).getCourseName() + " " + clazz.getClassSuffix((CourseOffering)course);
                                        break;
                                    }
                                    case 2: {
                                        InstrOfferingConfig config = (InstrOfferingConfig)((ExamOwner)owner).getOwnerObject();
                                        event.addExternalId("[" + config.getName() + "]");
                                        break;
                                    }
                                    case 1: {
                                        event.addExternalId(MESSAGES.colCourse());
                                        break;
                                    }
                                    case 0: {
                                        event.addExternalId(MESSAGES.colOffering());
                                    }
                                }
                            }
                        }
                        if (event.hasCourseNames() && event.getCourseNames().size() == 1 && (request.getResourceType() == EventInterface.ResourceType.PERSON || request.getResourceType() == EventInterface.ResourceType.CURRICULUM || request.getResourceType() == EventInterface.ResourceType.GROUP)) {
                            event.setName(name);
                        }
                    } else if (3 == m.getEvent().getEventType()) {
                        Object owner;
                        ce = (CourseEvent)CourseEventDAO.getInstance().get(m.getEvent().getUniqueId(), hibSession);
                        event.setRequiredAttendance(((BaseCourseEvent)((Object)ce)).isReqAttendance());
                        int enrl = 0;
                        int cap = 0;
                        boolean instructing = false;
                        if (request.getResourceType() == EventInterface.ResourceType.PERSON && request.getResourceExternalId() != null) {
                            if (request.getResourceExternalId().equals(m.getEvent().getMainContact().getExternalUniqueId())) {
                                instructing = true;
                            }
                            if (!instructing) {
                                for (EventContact contact5 : m.getEvent().getAdditionalContacts()) {
                                    if (!request.getResourceExternalId().equals(contact5.getExternalUniqueId())) continue;
                                    instructing = true;
                                    break;
                                }
                            }
                        }
                        owner = ((BaseCourseEvent)((Object)ce)).getRelatedCourses().iterator();
                        while (owner.hasNext()) {
                            Object course;
                            RelatedCourseInfo owner2 = owner.next();
                            if (owner2.getOwnerType() == 3 && !instructing && curriculumClasses != null && !curriculumClasses.contains(owner2.getOwnerId())) continue;
                            if (groupEnrollments) {
                                HashSet studentIds = new HashSet(owner2.getStudentIds());
                                for (Student s : group.getStudents()) {
                                    if (!studentIds.contains(s.getUniqueId())) continue;
                                    ++enrl;
                                }
                                event.setEnrollment(enrl);
                            } else {
                                enrl += owner2.countStudents();
                            }
                            cap += owner2.getLimit();
                            TreeSet<CourseOffering> courses = new TreeSet<CourseOffering>();
                            if (owner2.getOwnerType() == 1 || request.getResourceType() == EventInterface.ResourceType.ROOM) {
                                courses.add(owner2.getCourse());
                            } else {
                                courses.addAll(owner2.getCourse().getInstructionalOffering().getCourseOfferings());
                            }
                            course = courses.iterator();
                            block76: while (course.hasNext()) {
                                CourseOffering course2 = (CourseOffering)((Object)course.next());
                                switch (request.getResourceType()) {
                                    case CURRICULUM: 
                                    case PERSON: 
                                    case GROUP: {
                                        if (instructing && course2.isIsControl().booleanValue() || curriculumCourses.contains(course2.getUniqueId())) break;
                                        continue block76;
                                    }
                                }
                                event.addCourseId(course2.getUniqueId());
                                event.addCourseName(course2.getCourseName());
                                event.addCourseTitle(course2.getTitle() == null ? "" : course2.getTitle());
                                switch (owner2.getOwnerType()) {
                                    case 3: {
                                        Class_ clazz = (Class_)owner2.getOwnerObject();
                                        if (clazz.getClassSuffix(course2) == null) {
                                            event.addExternalId(clazz.getClassLabel(course2));
                                            break;
                                        }
                                        event.addExternalId(clazz.getClassSuffix(course2));
                                        break;
                                    }
                                    case 2: {
                                        InstrOfferingConfig config = (InstrOfferingConfig)owner2.getOwnerObject();
                                        event.addExternalId("[" + config.getName() + (config.getInstructionalMethod() == null ? "" : " " + config.getInstructionalMethod().getLabel()) + "]");
                                        break;
                                    }
                                    case 1: {
                                        event.addExternalId(MESSAGES.colCourse());
                                        break;
                                    }
                                    case 0: {
                                        event.addExternalId(MESSAGES.colOffering());
                                    }
                                }
                            }
                        }
                        event.setEnrollment(enrl);
                        event.setMaxCapacity(cap);
                    }
                    if (event.isCanView()) {
                        for (EventNote n : m.getEvent().getNotes()) {
                            EventInterface.NoteInterface note = new EventInterface.NoteInterface();
                            note.setId(n.getUniqueId());
                            note.setDate(n.getTimeStamp());
                            note.setType(EventInterface.NoteInterface.NoteType.values()[n.getNoteType()]);
                            note.setMeetings(n.getMeetingsHtml());
                            note.setNote(n.getTextNote());
                            note.setUser(n.getUser());
                            note.setAttachment(n.getAttachedName());
                            note.setLink(n.getAttachedName() == null ? null : QueryEncoderBackend.encode("event=" + m.getEvent().getUniqueId() + "&note=" + n.getUniqueId()));
                            event.addNote(note);
                        }
                    }
                    event.setSequence(m.getEvent().getNotes().size());
                    for (EventNote n : m.getEvent().getNotes()) {
                        if (n.getTimeStamp() == null || event.hasTimeStamp() && event.getTimeStamp().compareTo(n.getTimeStamp()) >= 0) continue;
                        event.setTimeStamp(n.getTimeStamp());
                    }
                    ret.add(event);
                }
                EventInterface.MeetingInterface meeting = new EventInterface.MeetingInterface();
                meeting.setId(m.getUniqueId());
                meeting.setMeetingDate(m.getMeetingDate());
                meeting.setDayOfWeek(Constants.getDayOfWeek(m.getMeetingDate()));
                meeting.setStartTime(m.getStartTime().getTime());
                meeting.setStopTime(m.getStopTime().getTime());
                meeting.setDayOfYear(CalendarUtils.date2dayOfYear(session.getSessionStartYear(), m.getMeetingDate()));
                meeting.setStartSlot(m.getStartPeriod());
                meeting.setEndSlot(m.getStopPeriod());
                meeting.setStartOffset(m.getStartOffset() == null ? 0 : m.getStartOffset());
                meeting.setEndOffset(m.getStopOffset() == null ? 0 : m.getStopOffset());
                meeting.setPast(context.isPastOrOutside(m.getStartTime()));
                meeting.setCanEdit(context.hasPermission(m, Right.EventMeetingEdit));
                meeting.setCanInquire(context.hasPermission(m, Right.EventMeetingInquire) || m.getEvent().getEventType() == 0 && context.hasPermission(m, Right.EventMeetingInquireClass) || m.getEvent().getEventType() == 1 && context.hasPermission(m, Right.EventMeetingInquireExam) || m.getEvent().getEventType() == 2 && context.hasPermission(m, Right.EventMeetingInquireExam));
                meeting.setCanApprove(context.hasPermission(m, Right.EventMeetingApprove));
                meeting.setCanDelete(context.hasPermission(m, Right.EventMeetingDelete));
                meeting.setCanCancel(context.hasPermission(m, Right.EventMeetingCancel) || m.getEvent().getEventType() == 0 && context.hasPermission(m, Right.EventMeetingCancelClass) || m.getEvent().getEventType() == 1 && context.hasPermission(m, Right.EventMeetingCancelExam) || m.getEvent().getEventType() == 2 && context.hasPermission(m, Right.EventMeetingCancelExam));
                meeting.setApprovalDate(m.getApprovalDate());
                meeting.setApprovalStatus(m.getApprovalStatus());
                if (m.getLocation() != null) {
                    EventInterface.ResourceInterface location2 = new EventInterface.ResourceInterface();
                    location2.setType(EventInterface.ResourceType.ROOM);
                    location2.setId(m.getLocation().getUniqueId());
                    location2.setName(m.getLocation().getLabel());
                    location2.setSize(m.getLocation().getCapacity());
                    location2.setDistance((Double)distances.get(m.getLocation().getUniqueId()));
                    location2.setRoomType(m.getLocation().getRoomTypeLabel());
                    location2.setBreakTime(m.getLocation().getEffectiveBreakTime());
                    location2.setMessage(m.getLocation().getEventMessage());
                    location2.setIgnoreRoomCheck(m.getLocation().isIgnoreRoomCheck());
                    location2.setDisplayName(m.getLocation().getDisplayName());
                    meeting.setLocation(location2);
                }
                if (request.getEventFilter().hasOptions("flag") && request.getEventFilter().getOptions("flag").contains("Conflicts") && m.getLocation() != null && m.getLocation().getEventAvailability() != null && m.getLocation().getEventAvailability().length() == 288 * Constants.DAY_CODES.length) {
                    for (int slot = meeting.getStartSlot(); slot < meeting.getEndSlot(); ++slot) {
                        if (m.getLocation().getEventAvailability().charAt(meeting.getDayOfWeek() * 288 + slot) != '1') continue;
                        HashSet<Location> locations = (HashSet<Location>)unavailableLocations.get(event.getId());
                        if (locations == null) {
                            locations = new HashSet<Location>();
                            unavailableLocations.put(event.getId(), locations);
                        }
                        locations.add(m.getLocation());
                        break;
                    }
                }
                if (context.hasPermission(Right.EventCanViewMeetingContacts)) {
                    HashMap<Long, Object> contacts = new HashMap<Long, Object>();
                    for (EventContact c : m.getMeetingContacts()) {
                        contact = (EventInterface.ContactInterface)contacts.get(c.getUniqueId());
                        if (contact == null) {
                            contact = new EventInterface.ContactInterface();
                            ((EventInterface.ContactInterface)contact).setFirstName(c.getFirstName());
                            ((EventInterface.ContactInterface)contact).setMiddleName(c.getMiddleName());
                            ((EventInterface.ContactInterface)contact).setLastName(c.getLastName());
                            ((EventInterface.ContactInterface)contact).setAcademicTitle(c.getAcademicTitle());
                            ((EventInterface.ContactInterface)contact).setExternalId(c.getExternalUniqueId());
                            ((EventInterface.ContactInterface)contact).setPhone(c.getPhone());
                            ((EventInterface.ContactInterface)contact).setEmail(c.getEmailAddress());
                            ((EventInterface.ContactInterface)contact).setFormattedName(c.getName(nameFormat));
                            contacts.put(c.getUniqueId(), contact);
                        }
                        meeting.addMeetingContact((EventInterface.ContactInterface)contact);
                    }
                }
                event.addMeeting(meeting);
            }
            if (request.getEventFilter().hasOptions("flag") && request.getEventFilter().getOptions("flag").contains("Conflicts")) {
                request.getEventFilter().setOption("mode", "Conflicting");
                query = EventFilterBackend.getQuery(request.getEventFilter(), context);
                List conflicts = null;
                switch (request.getResourceType()) {
                    case ROOM: {
                        if (request.getResourceId() == null) {
                            conflicts = query.select("distinct m.event.uniqueId, Xm").query(hibSession).list();
                            break;
                        }
                        conflicts = query.select("distinct m.event.uniqueId, Xm").joinWithLocation().where("l.uniqueId = :resourceId").set("resourceId", request.getResourceId()).query(hibSession).list();
                        break;
                    }
                    case SUBJECT: 
                    case COURSE: {
                        String resourceCheck = request.getResourceType() == EventInterface.ResourceType.SUBJECT ? "co.subjectArea.uniqueId = :resourceId" : "co.uniqueId = :resourceId";
                        conflicts = new ArrayList();
                        conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("ClassEvent").from("inner join e.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co").where(resourceCheck).set("resourceId", request.getResourceId()).query(hibSession).list());
                        conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("CourseEvent").from("inner join e.relatedCourses o, CourseOffering co").where("o.ownerType = :type and o.ownerId = co.uniqueId").set("type", 1).where(resourceCheck).set("resourceId", request.getResourceId()).query(hibSession).list());
                        conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("CourseEvent").from("inner join e.relatedCourses o, CourseOffering co").where("o.ownerType = :type and o.ownerId = co.instructionalOffering.uniqueId").set("type", 0).where(resourceCheck).set("resourceId", request.getResourceId()).query(hibSession).list());
                        conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("CourseEvent").from("inner join e.relatedCourses o, Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co").where("o.ownerType = :type and o.ownerId = c.uniqueId").set("type", 3).where(resourceCheck).set("resourceId", request.getResourceId()).query(hibSession).list());
                        conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("CourseEvent").from("inner join e.relatedCourses o, CourseOffering co inner join co.instructionalOffering.instrOfferingConfigs cfg").where("o.ownerType = :type and o.ownerId = cfg.uniqueId").set("type", 2).where(resourceCheck).set("resourceId", request.getResourceId()).query(hibSession).list());
                        conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("ExamEvent").from("inner join e.exam.owners o, CourseOffering co").where("o.ownerType = :type and o.ownerId = co.uniqueId").set("type", 1).where(resourceCheck).set("resourceId", request.getResourceId()).query(hibSession).list());
                        conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("ExamEvent").from("inner join e.exam.owners o, CourseOffering co").where("o.ownerType = :type and o.ownerId = co.instructionalOffering.uniqueId").set("type", 0).where(resourceCheck).set("resourceId", request.getResourceId()).query(hibSession).list());
                        conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("ExamEvent").from("inner join e.exam.owners o, Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co").where("o.ownerType = :type and o.ownerId = c.uniqueId").set("type", 3).where(resourceCheck).set("resourceId", request.getResourceId()).query(hibSession).list());
                        conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("ExamEvent").from("inner join e.exam.owners o, CourseOffering co inner join co.instructionalOffering.instrOfferingConfigs cfg").where("o.ownerType = :type and o.ownerId = cfg.uniqueId").set("type", 2).where(resourceCheck).set("resourceId", request.getResourceId()).query(hibSession).list());
                        break;
                    }
                    case CURRICULUM: {
                        conflicts = new ArrayList();
                        if (curriculum != null && curriculum.isMultipleMajors().booleanValue() && !curriculum.getMajors().isEmpty()) {
                            if (curriculumCourses.isEmpty()) break;
                            conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("ClassEvent").from("inner join e.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co").where("co.uniqueId in (:courses)").set("courses", curriculumCourses).query(hibSession).list());
                            conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("ExamEvent").from("inner join e.exam.owners o").where("o.ownerType = :type and o.ownerId in (:courses)").set("courses", curriculumCourses).set("type", 1).query(hibSession).list());
                            conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("ExamEvent").from("inner join e.exam.owners o, CourseOffering co").where("co.uniqueId in (:courses)").set("courses", curriculumCourses).where("o.ownerType = :type and o.ownerId = co.instructionalOffering.uniqueId").set("type", 0).query(hibSession).list());
                            conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("ExamEvent").from("inner join e.exam.owners o, Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co").where("co.uniqueId in (:courses)").set("courses", curriculumCourses).where("o.ownerType = :type and o.ownerId = c.uniqueId").set("type", 3).query(hibSession).list());
                            conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("ExamEvent").from("inner join e.exam.owners o, CourseOffering co inner join co.instructionalOffering.instrOfferingConfigs cfg").where("co.uniqueId in (:courses)").set("courses", curriculumCourses).where("o.ownerType = :type and o.ownerId = cfg.uniqueId").set("type", 2).query(hibSession).list());
                            conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("CourseEvent").from("inner join e.relatedCourses o").where("o.ownerType = :type and o.ownerId in (:courses)").set("courses", curriculumCourses).set("type", 1).query(hibSession).list());
                            conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("CourseEvent").from("inner join e.relatedCourses o, CourseOffering co").where("co.uniqueId in (:courses)").set("courses", curriculumCourses).where("o.ownerType = :type and o.ownerId = co.instructionalOffering.uniqueId").set("type", 0).query(hibSession).list());
                            conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("CourseEvent").from("inner join e.relatedCourses o, Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co").where("co.uniqueId in (:courses)").set("courses", curriculumCourses).where("o.ownerType = :type and o.ownerId = c.uniqueId").set("type", 3).query(hibSession).list());
                            conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("CourseEvent").from("inner join e.relatedCourses o, CourseOffering co inner join co.instructionalOffering.instrOfferingConfigs cfg").where("co.uniqueId in (:courses)").set("courses", curriculumCourses).where("o.ownerType = :type and o.ownerId = cfg.uniqueId").set("type", 2).query(hibSession).list());
                            break;
                        }
                        conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("ClassEvent").from("inner join e.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co, CurriculumCourse cc").where("co = cc.course").where("cc.classification.curriculum.uniqueId = :resourceId or cc.classification.uniqueId = :resourceId").set("resourceId", request.getResourceId()).query(hibSession).list());
                        conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("ExamEvent").from("inner join e.exam.owners o, CourseOffering co, CurriculumCourse cc").where("co = cc.course").where("cc.classification.curriculum.uniqueId = :resourceId or cc.classification.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = co.uniqueId").set("type", 1).query(hibSession).list());
                        conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("ExamEvent").from("inner join e.exam.owners o, CourseOffering co, CurriculumCourse cc").where("co = cc.course").where("cc.classification.curriculum.uniqueId = :resourceId or cc.classification.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = co.instructionalOffering.uniqueId").set("type", 0).query(hibSession).list());
                        conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("ExamEvent").from("inner join e.exam.owners o, Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co, CurriculumCourse cc").where("co = cc.course").where("cc.classification.curriculum.uniqueId = :resourceId or cc.classification.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = c.uniqueId").set("type", 3).query(hibSession).list());
                        conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("ExamEvent").from("inner join e.exam.owners o, CourseOffering co inner join co.instructionalOffering.instrOfferingConfigs cfg, CurriculumCourse cc").where("co = cc.course").where("cc.classification.curriculum.uniqueId = :resourceId or cc.classification.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = cfg.uniqueId").set("type", 2).query(hibSession).list());
                        conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("CourseEvent").from("inner join e.relatedCourses o, CourseOffering co, CurriculumCourse cc").where("co = cc.course").where("cc.classification.curriculum.uniqueId = :resourceId or cc.classification.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = co.uniqueId").set("type", 1).query(hibSession).list());
                        conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("CourseEvent").from("inner join e.relatedCourses o, CourseOffering co, CurriculumCourse cc").where("co = cc.course").where("cc.classification.curriculum.uniqueId = :resourceId or cc.classification.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = co.instructionalOffering.uniqueId").set("type", 0).query(hibSession).list());
                        conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("CourseEvent").from("inner join e.relatedCourses o, Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co, CurriculumCourse cc").where("co = cc.course").where("cc.classification.curriculum.uniqueId = :resourceId or cc.classification.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = c.uniqueId").set("type", 3).query(hibSession).list());
                        conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("CourseEvent").from("inner join e.relatedCourses o, CourseOffering co inner join co.instructionalOffering.instrOfferingConfigs cfg, CurriculumCourse cc").where("co = cc.course").where("cc.classification.curriculum.uniqueId = :resourceId or cc.classification.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = cfg.uniqueId").set("type", 2).query(hibSession).list());
                        break;
                    }
                    case DEPARTMENT: {
                        if (department.isExternalManager().booleanValue()) {
                            conflicts = query.select("distinct m.event.uniqueId, Xm").type("ClassEvent").from("inner join e.clazz.managingDept d").where("d.uniqueId = :resourceId").set("resourceId", request.getResourceId()).query(hibSession).list();
                            break;
                        }
                        conflicts = query.select("distinct m.event.uniqueId, Xm").type("ClassEvent").from("inner join e.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co inner join co.subjectArea.department d").where("d.uniqueId = :resourceId").set("resourceId", request.getResourceId()).query(hibSession).list();
                        conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("ExamEvent").from("inner join e.exam.owners o, CourseOffering co inner join co.subjectArea.department d").where("d.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = co.uniqueId").set("type", 1).query(hibSession).list());
                        conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("ExamEvent").from("inner join e.exam.owners o, CourseOffering co inner join co.subjectArea.department d").where("d.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = co.instructionalOffering.uniqueId").set("type", 0).query(hibSession).list());
                        conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("ExamEvent").from("inner join e.exam.owners o, Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co inner join co.subjectArea.department d").where("d.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = c.uniqueId").set("type", 3).query(hibSession).list());
                        conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("ExamEvent").from("inner join e.exam.owners o, CourseOffering co inner join co.instructionalOffering.instrOfferingConfigs cfg inner join co.subjectArea.department d").where("d.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = cfg.uniqueId").set("type", 2).query(hibSession).list());
                        conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("CourseEvent").from("inner join e.relatedCourses o, CourseOffering co inner join co.subjectArea.department d").where("d.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = co.uniqueId").set("type", 1).query(hibSession).list());
                        conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("CourseEvent").from("inner join e.relatedCourses o, CourseOffering co inner join co.subjectArea.department d").where("d.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = co.instructionalOffering.uniqueId").set("type", 0).query(hibSession).list());
                        conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("CourseEvent").from("inner join e.relatedCourses o, Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co inner join co.subjectArea.department d").where("d.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = c.uniqueId").set("type", 3).query(hibSession).list());
                        conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("CourseEvent").from("inner join e.relatedCourses o, CourseOffering co inner join co.instructionalOffering.instrOfferingConfigs cfg inner join co.subjectArea.department d").where("d.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = cfg.uniqueId").set("type", 2).query(hibSession).list());
                    }
                }
                if (conflicts != null) {
                    Hashtable<Long, EventInterface> conflictingEvents = new Hashtable<Long, EventInterface>();
                    for (Object[] o : conflicts) {
                        EventInterface event;
                        Location location;
                        EventInterface parent = (EventInterface)events.get((Long)o[0]);
                        if (parent == null) continue;
                        Meeting m = (Meeting)o[1];
                        if (locationMap != null && m.getLocationPermanentId() != null && (location = (Location)locationMap.get(m.getLocationPermanentId())) != null) {
                            m.setLocation(location);
                        }
                        if ((event = (EventInterface)conflictingEvents.get(m.getEvent().getUniqueId())) == null) {
                            Event ce;
                            Object p2;
                            event = new EventInterface();
                            event.setId(m.getEvent().getUniqueId());
                            event.setName(m.getEvent().getEventName());
                            event.setType(EventInterface.EventType.values()[m.getEvent().getEventType()]);
                            conflictingEvents.put(m.getEvent().getUniqueId(), event);
                            event.setCanView(context.hasPermission(m.getEvent(), Right.EventDetail));
                            event.setMaxCapacity(m.getEvent().getMaxCapacity());
                            if (m.getEvent().getMainContact() != null) {
                                contact = new EventInterface.ContactInterface();
                                ((EventInterface.ContactInterface)contact).setFirstName(m.getEvent().getMainContact().getFirstName());
                                ((EventInterface.ContactInterface)contact).setMiddleName(m.getEvent().getMainContact().getMiddleName());
                                ((EventInterface.ContactInterface)contact).setLastName(m.getEvent().getMainContact().getLastName());
                                ((EventInterface.ContactInterface)contact).setAcademicTitle(m.getEvent().getMainContact().getAcademicTitle());
                                ((EventInterface.ContactInterface)contact).setEmail(m.getEvent().getMainContact().getEmailAddress());
                                ((EventInterface.ContactInterface)contact).setFormattedName(m.getEvent().getMainContact().getName(nameFormat));
                                event.setContact((EventInterface.ContactInterface)contact);
                            }
                            for (EventContact additional : m.getEvent().getAdditionalContacts()) {
                                EventInterface.ContactInterface contact6 = new EventInterface.ContactInterface();
                                contact6.setFirstName(additional.getFirstName());
                                contact6.setMiddleName(additional.getMiddleName());
                                contact6.setLastName(additional.getLastName());
                                contact6.setAcademicTitle(additional.getAcademicTitle());
                                contact6.setEmail(additional.getEmailAddress());
                                contact6.setFormattedName(additional.getName(nameFormat));
                                event.addAdditionalContact(contact6);
                            }
                            event.setEmail(m.getEvent().getEmail());
                            if (m.getEvent().getSponsoringOrganization() != null) {
                                EventInterface.SponsoringOrganizationInterface sponsor = new EventInterface.SponsoringOrganizationInterface();
                                sponsor.setEmail(m.getEvent().getSponsoringOrganization().getEmail());
                                sponsor.setName(m.getEvent().getSponsoringOrganization().getName());
                                sponsor.setUniqueId(m.getEvent().getSponsoringOrganization().getUniqueId());
                                event.setSponsor(sponsor);
                            }
                            for (Object p2 : m.getEvent().getRequestedServices()) {
                                if (!((BaseEventServiceProvider)p2).isVisible().booleanValue()) continue;
                                EventInterface.EventServiceProviderInterface provider = new EventInterface.EventServiceProviderInterface();
                                provider.setId(((BaseEventServiceProvider)p2).getUniqueId());
                                provider.setReference(((BaseEventServiceProvider)p2).getReference());
                                provider.setLabel(((BaseEventServiceProvider)p2).getLabel());
                                provider.setMessage(((BaseEventServiceProvider)p2).getNote());
                                provider.setEmail(((BaseEventServiceProvider)p2).getEmail());
                                event.addRequestedService(provider);
                            }
                            String note = null;
                            p2 = m.getEvent().getNotes().iterator();
                            while (p2.hasNext()) {
                                EventNote n = (EventNote)p2.next();
                                if (n.getTextNote() == null || n.getTextNote().isEmpty()) continue;
                                note = (note == null ? "" : note + "n") + n.getTextNote();
                            }
                            if (0 == m.getEvent().getEventType()) {
                                Object instructor;
                                ce = (ClassEvent)ClassEventDAO.getInstance().get(m.getEvent().getUniqueId(), hibSession);
                                Class_ clazz = ((BaseClassEvent)ce).getClazz();
                                event.setEnrollment(clazz.getEnrollment());
                                if (groupEnrollments) {
                                    int enrl = 0;
                                    for (StudentClassEnrollment e : clazz.getStudentEnrollments()) {
                                        if (!group.getStudents().contains(e.getStudent())) continue;
                                        ++enrl;
                                    }
                                    event.setEnrollment(enrl);
                                }
                                event.setMaxCapacity(clazz.getClassLimit());
                                if (clazz.getDisplayInstructor().booleanValue()) {
                                    for (ClassInstructor i : clazz.getClassInstructors()) {
                                        if (i.getResponsibility() != null && i.getResponsibility().hasOption(TeachingResponsibility.Option.noevents)) continue;
                                        instructor = new EventInterface.ContactInterface();
                                        ((EventInterface.ContactInterface)instructor).setFirstName(i.getInstructor().getFirstName());
                                        ((EventInterface.ContactInterface)instructor).setMiddleName(i.getInstructor().getMiddleName());
                                        ((EventInterface.ContactInterface)instructor).setLastName(i.getInstructor().getLastName());
                                        ((EventInterface.ContactInterface)instructor).setAcademicTitle(i.getInstructor().getAcademicTitle());
                                        ((EventInterface.ContactInterface)instructor).setEmail(i.getInstructor().getEmail());
                                        ((EventInterface.ContactInterface)instructor).setFormattedName(i.getInstructor().getName(nameFormat));
                                        if (i.getResponsibility() != null) {
                                            ((EventInterface.ContactInterface)instructor).setResponsibility(i.getResponsibility().getLabel());
                                            ((EventInterface.ContactInterface)instructor).setResponsibilityAbbreviation(i.getResponsibility().getAbbreviation());
                                        }
                                        event.addInstructor((EventInterface.ContactInterface)instructor);
                                    }
                                }
                                CourseOffering correctedOffering = clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getControllingCourseOffering();
                                ArrayList<CourseOffering> courses = new ArrayList<CourseOffering>(clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getCourseOfferings());
                                courses.remove(correctedOffering);
                                event.addCourseId(correctedOffering.getUniqueId());
                                event.addCourseName(correctedOffering.getCourseName());
                                event.addCourseTitle(correctedOffering.getTitle() == null ? "" : correctedOffering.getTitle());
                                event.setInstruction(clazz.getSchedulingSubpart().getItype().getDesc().length() <= 20 ? clazz.getSchedulingSubpart().getItype().getDesc() : clazz.getSchedulingSubpart().getItype().getAbbv());
                                if (clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalMethod() != null) {
                                    event.setInstruction(event.getInstruction() + " (" + clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalMethod().getLabel() + ")");
                                }
                                event.setInstructionType(clazz.getSchedulingSubpart().getItype().getItype());
                                event.setSectionNumber(clazz.getSectionNumberString(hibSession));
                                if (clazz.getClassSuffix(correctedOffering) == null) {
                                    event.setName(clazz.getClassLabel(correctedOffering));
                                } else {
                                    event.addExternalId(clazz.getClassSuffix(correctedOffering));
                                    event.setName(correctedOffering.getCourseName() + " " + clazz.getClassSuffix(correctedOffering));
                                }
                                instructor = courses.iterator();
                                while (instructor.hasNext()) {
                                    CourseOffering co = (CourseOffering)instructor.next();
                                    event.addCourseId(co.getUniqueId());
                                    event.addCourseName(co.getCourseName());
                                    event.addCourseTitle(co.getTitle() == null ? "" : co.getTitle());
                                    if (clazz.getClassSuffix(co) == null) continue;
                                    event.addExternalId(clazz.getClassSuffix(co));
                                }
                                note = correctedOffering.getScheduleBookNote();
                                if (clazz.getSchedulePrintNote() != null && !clazz.getSchedulePrintNote().isEmpty()) {
                                    note = (note == null || note.isEmpty() ? "" : note + "\n") + clazz.getSchedulePrintNote();
                                }
                            } else if (1 == m.getEvent().getEventType() || 2 == m.getEvent().getEventType()) {
                                ExamEvent xe = (ExamEvent)ExamEventDAO.getInstance().get(m.getEvent().getUniqueId(), hibSession);
                                event.setEnrollment(xe.getExam().countStudents());
                                event.setMaxCapacity(xe.getExam().getSize());
                                if (groupEnrollments) {
                                    int enrl = 0;
                                    Set<Long> studentIds = xe.getExam().getStudentIds();
                                    for (Student s : group.getStudents()) {
                                        if (!studentIds.contains(s.getUniqueId())) continue;
                                        ++enrl;
                                    }
                                    event.setEnrollment(enrl);
                                }
                                for (DepartmentalInstructor i : xe.getExam().getInstructors()) {
                                    Iterator<CourseOffering> instructor = new EventInterface.ContactInterface();
                                    ((EventInterface.ContactInterface)((Object)instructor)).setFirstName(i.getFirstName());
                                    ((EventInterface.ContactInterface)((Object)instructor)).setMiddleName(i.getMiddleName());
                                    ((EventInterface.ContactInterface)((Object)instructor)).setLastName(i.getLastName());
                                    ((EventInterface.ContactInterface)((Object)instructor)).setAcademicTitle(i.getAcademicTitle());
                                    ((EventInterface.ContactInterface)((Object)instructor)).setEmail(i.getEmail());
                                    ((EventInterface.ContactInterface)((Object)instructor)).setFormattedName(i.getName(nameFormat));
                                    event.addInstructor((EventInterface.ContactInterface)((Object)instructor));
                                }
                                for (ExamOwner owner : new TreeSet<ExamOwner>(xe.getExam().getOwners())) {
                                    for (CourseOffering course : owner.getCourse().getInstructionalOffering().getCourseOfferings()) {
                                        String courseName = owner.getCourse().getCourseName();
                                        Object label = owner.getLabel();
                                        if (((String)label).startsWith(courseName)) {
                                            label = ((String)label).substring(courseName.length());
                                        }
                                        event.addCourseId(course.getUniqueId());
                                        event.addCourseName(course.getCourseName());
                                        event.addCourseTitle(course.getTitle() == null ? "" : course.getTitle());
                                        event.addExternalId(((String)label).trim());
                                    }
                                }
                                if (event.hasCourseNames() && event.getCourseNames().size() == 1 && (request.getResourceType() == EventInterface.ResourceType.PERSON || request.getResourceType() == EventInterface.ResourceType.CURRICULUM || request.getResourceType() == EventInterface.ResourceType.GROUP)) {
                                    event.setName((event.getCourseNames().get(0) + " " + event.getExternalIds().get(0)).trim());
                                }
                            } else if (3 == m.getEvent().getEventType()) {
                                ce = (CourseEvent)CourseEventDAO.getInstance().get(m.getEvent().getUniqueId(), hibSession);
                                event.setRequiredAttendance(((BaseCourseEvent)ce).isReqAttendance());
                                int enrl = 0;
                                int cap = 0;
                                for (RelatedCourseInfo owner : ((BaseCourseEvent)ce).getRelatedCourses()) {
                                    if (groupEnrollments) {
                                        HashSet studentIds = new HashSet(owner.getStudentIds());
                                        for (Student s : group.getStudents()) {
                                            if (!studentIds.contains(s.getUniqueId())) continue;
                                            ++enrl;
                                        }
                                        event.setEnrollment(enrl);
                                    } else {
                                        enrl += owner.countStudents();
                                    }
                                    cap += owner.getLimit();
                                    for (CourseOffering course : owner.getCourse().getInstructionalOffering().getCourseOfferings()) {
                                        String courseName = owner.getCourse().getCourseName();
                                        String label = owner.getLabel();
                                        if (label.startsWith(courseName)) {
                                            label = label.substring(courseName.length());
                                        }
                                        event.addCourseId(course.getUniqueId());
                                        event.addCourseName(course.getCourseName());
                                        event.addCourseTitle(course.getTitle() == null ? "" : course.getTitle());
                                        event.addExternalId(label.trim());
                                    }
                                }
                                event.setEnrollment(enrl);
                                event.setMaxCapacity(cap);
                            }
                            if (note != null && !note.isEmpty()) {
                                EventInterface.NoteInterface n = new EventInterface.NoteInterface();
                                n.setNote(note);
                                event.addNote(n);
                            }
                        }
                        EventInterface.MeetingInterface meeting = new EventInterface.MeetingInterface();
                        meeting.setId(m.getUniqueId());
                        meeting.setMeetingDate(m.getMeetingDate());
                        meeting.setDayOfWeek(Constants.getDayOfWeek(m.getMeetingDate()));
                        meeting.setStartTime(m.getStartTime().getTime());
                        meeting.setStopTime(m.getStopTime().getTime());
                        meeting.setDayOfYear(CalendarUtils.date2dayOfYear(session.getSessionStartYear(), m.getMeetingDate()));
                        meeting.setStartSlot(m.getStartPeriod());
                        meeting.setEndSlot(m.getStopPeriod());
                        meeting.setStartOffset(m.getStartOffset() == null ? 0 : m.getStartOffset());
                        meeting.setEndOffset(m.getStopOffset() == null ? 0 : m.getStopOffset());
                        meeting.setPast(context.isPastOrOutside(m.getStartTime()));
                        meeting.setApprovalDate(m.getApprovalDate());
                        meeting.setApprovalStatus(m.getApprovalStatus());
                        if (m.getLocation() != null) {
                            EventInterface.ResourceInterface location3 = new EventInterface.ResourceInterface();
                            location3.setType(EventInterface.ResourceType.ROOM);
                            location3.setId(m.getLocation().getUniqueId());
                            location3.setName(m.getLocation().getLabel());
                            location3.setSize(m.getLocation().getCapacity());
                            location3.setRoomType(m.getLocation().getRoomTypeLabel());
                            location3.setBreakTime(m.getLocation().getEffectiveBreakTime());
                            location3.setMessage(m.getLocation().getEventMessage());
                            location3.setIgnoreRoomCheck(m.getLocation().isIgnoreRoomCheck());
                            location3.setDisplayName(m.getLocation().getDisplayName());
                            meeting.setLocation(location3);
                        }
                        if (context.hasPermission(Right.EventCanViewMeetingContacts)) {
                            HashMap<Long, EventInterface.ContactInterface> contacts = new HashMap<Long, EventInterface.ContactInterface>();
                            for (EventContact c : m.getMeetingContacts()) {
                                EventInterface.ContactInterface contact7 = (EventInterface.ContactInterface)contacts.get(c.getUniqueId());
                                if (contact7 == null) {
                                    contact7 = new EventInterface.ContactInterface();
                                    contact7.setFirstName(c.getFirstName());
                                    contact7.setMiddleName(c.getMiddleName());
                                    contact7.setLastName(c.getLastName());
                                    contact7.setAcademicTitle(c.getAcademicTitle());
                                    contact7.setExternalId(c.getExternalUniqueId());
                                    contact7.setPhone(c.getPhone());
                                    contact7.setEmail(c.getEmailAddress());
                                    contact7.setFormattedName(c.getName(nameFormat));
                                    contacts.put(c.getUniqueId(), contact7);
                                }
                                meeting.addMeetingContact(contact7);
                            }
                        }
                        event.addMeeting(meeting);
                        parent.addConflict(event);
                    }
                }
                for (Map.Entry entry : unavailableLocations.entrySet()) {
                    EventInterface parent = (EventInterface)events.get(entry.getKey());
                    if (parent == null) continue;
                    for (Location location : (Set)entry.getValue()) {
                        EventInterface unavailability = EventLookupBackend.generateUnavailabilityEvent(location, parent);
                        if (unavailability == null) continue;
                        parent.addConflict(unavailability);
                    }
                }
            }
            if (!(request.getEventFilter().hasOptions("type") && !request.getEventFilter().getOptions("type").contains("Class") || request.getEventFilter().hasOptions("from") || request.getEventFilter().hasOptions("to") || request.getEventFilter().hasOptions("requested") || request.getEventFilter().hasOptions("day") || request.getEventFilter().hasOptions("after") || request.getEventFilter().hasOptions("before") || !context.hasPermission(Right.HasRole) && !session.canNoRoleReportClass() || !Solution.hasTimetable(session.getUniqueId()))) {
                String datePatternFormat = ApplicationProperty.DatePatternFormatUseDates.value();
                List arrageHourClasses = null;
                switch (request.getResourceType()) {
                    case SUBJECT: 
                    case COURSE: {
                        arrageHourClasses = hibSession.createQuery("select c from Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co where c.committedAssignment is null and c.cancelled = false and " + (request.getResourceType() == EventInterface.ResourceType.SUBJECT ? "co.subjectArea.uniqueId = :resourceId" : "co.uniqueId = :resourceId")).setLong("resourceId", request.getResourceId().longValue()).setCacheable(true).list();
                        break;
                    }
                    case DEPARTMENT: {
                        arrageHourClasses = hibSession.createQuery("select c from Class_ c inner join c.managingDept d where c.committedAssignment is null and c.cancelled = false and d.uniqueId = :resourceId").setLong("resourceId", request.getResourceId().longValue()).setCacheable(true).list();
                        break;
                    }
                    case CURRICULUM: {
                        if (curriculum != null && curriculum.isMultipleMajors().booleanValue() && !curriculum.getMajors().isEmpty()) {
                            if (curriculumCourses.isEmpty()) break;
                            arrageHourClasses = hibSession.createQuery("select c from Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co where c.committedAssignment is null and c.cancelled = false and co.uniqueId in (:courses)").setParameterList("courses", curriculumCourses).setCacheable(true).list();
                            break;
                        }
                        arrageHourClasses = hibSession.createQuery("select c from Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co, CurriculumCourse cc where c.committedAssignment is null and c.cancelled = false and co = cc.course and (cc.classification.curriculum.uniqueId = :resourceId or cc.classification.uniqueId = :resourceId)").setLong("resourceId", request.getResourceId().longValue()).setCacheable(true).list();
                        break;
                    }
                    case PERSON: {
                        Set<String> roles = request.getEventFilter().getOptions("role");
                        boolean student = roles == null || roles.contains("student") || roles.contains("Student");
                        boolean instructor = roles == null || roles.contains("instructor") || roles.contains("Instructor");
                        boolean coordinator = roles != null && (roles.contains("coordinator") || roles.contains("Coordinator"));
                        arrageHourClasses = new ArrayList();
                        if (student) {
                            arrageHourClasses.addAll(hibSession.createQuery("select c from StudentClassEnrollment e inner join e.clazz c where c.committedAssignment is null and c.cancelled = false and e.student.session.uniqueId = :sessionId and e.student.externalUniqueId = :externalId").setString("externalId", request.getResourceExternalId()).setLong("sessionId", request.getSessionId().longValue()).setCacheable(true).list());
                        }
                        if (instructor) {
                            arrageHourClasses.addAll(hibSession.createQuery("select c from ClassInstructor ci inner join ci.classInstructing c where c.committedAssignment is null and c.cancelled = false and ci.instructor.department.session.uniqueId = :sessionId and  ci.instructor.externalUniqueId = :externalId").setString("externalId", request.getResourceExternalId()).setLong("sessionId", request.getSessionId().longValue()).setCacheable(true).list());
                        }
                        if (!coordinator) break;
                        arrageHourClasses.addAll(hibSession.createQuery("select c from Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.offeringCoordinators cc where c.committedAssignment is null and c.cancelled = false and cc.instructor.department.session.uniqueId = :sessionId and cc.instructor.externalUniqueId = :externalId").setString("externalId", request.getResourceExternalId()).setLong("sessionId", request.getSessionId().longValue()).setCacheable(true).list());
                        break;
                    }
                    case GROUP: {
                        Integer minEnrollment = null;
                        Iterator<Comparable> pMinEnrl = ApplicationProperty.StudentGroupsTimetableMinimalEnrollment.value();
                        if (pMinEnrl != null) {
                            minEnrollment = ((String)((Object)pMinEnrl)).endsWith("%") ? Integer.valueOf((int)Math.floor(Double.parseDouble(((String)((Object)pMinEnrl)).substring(0, ((String)((Object)pMinEnrl)).length() - 1)) * (double)group.getStudents().size() / 100.0)) : Integer.valueOf(Integer.parseInt((String)((Object)pMinEnrl)));
                        }
                        arrageHourClasses = new ArrayList();
                        if (minEnrollment == null) {
                            arrageHourClasses.addAll(hibSession.createQuery("select distinct c from StudentGroup g inner join g.students s inner join s.classEnrollments e inner join e.clazz c where c.committedAssignment is null and c.cancelled = false and g.uniqueId = :resourceId").setLong("resourceId", group.getUniqueId().longValue()).setCacheable(true).list());
                            break;
                        }
                        arrageHourClasses.addAll(hibSession.createQuery("select distinct c from StudentGroup g inner join g.students s inner join s.classEnrollments e inner join e.clazz c where c.committedAssignment is null and c.cancelled = false and g.uniqueId = :resourceId and (select count(x) from StudentClassEnrollment x inner join x.student.groups y where y.uniqueId = g.uniqueId and x.clazz.uniqueId = e.clazz.uniqueId) >= :minEnrl").setLong("resourceId", group.getUniqueId().longValue()).setInteger("minEnrl", minEnrollment.intValue()).setCacheable(true).list());
                    }
                }
                if (arrageHourClasses != null) {
                    boolean checkDepartment = ApplicationProperty.EventHasRoleCheckReportStatus.isTrue() && !context.hasPermission(Right.DepartmentIndependent) && !context.hasPermission(Right.StatusIndependent) && !session.canNoRoleReportClass() && !context.hasPermission(session, Right.EventCanSeeUnpublishedEvents);
                    for (Class_ clazz : arrageHourClasses) {
                        EventInterface.NoteInterface note;
                        if (checkDepartment && !context.getUser().getCurrentAuthority().hasQualifier(clazz.getControllingDept())) continue;
                        EventInterface event = new EventInterface();
                        event.setId(-clazz.getUniqueId().longValue());
                        event.setName(clazz.getClassLabel(hibSession));
                        event.setType(EventInterface.EventType.Class);
                        event.setCanView(context.hasPermission(clazz, Right.EventDetailArrangeHourClass));
                        event.setMaxCapacity(clazz.getClassLimit());
                        event.setEnrollment(clazz.getEnrollment());
                        if (groupEnrollments) {
                            int enrl = 0;
                            for (StudentClassEnrollment e : clazz.getStudentEnrollments()) {
                                if (!group.getStudents().contains(e.getStudent())) continue;
                                ++enrl;
                            }
                            event.setEnrollment(enrl);
                        }
                        HashSet<Long> addedInstructorIds = new HashSet<Long>();
                        if (clazz.getDisplayInstructor().booleanValue()) {
                            for (ClassInstructor i : clazz.getClassInstructors()) {
                                if (i.getResponsibility() != null && i.getResponsibility().hasOption(TeachingResponsibility.Option.noevents)) continue;
                                EventInterface.ContactInterface instructor = new EventInterface.ContactInterface();
                                instructor.setFirstName(i.getInstructor().getFirstName());
                                instructor.setMiddleName(i.getInstructor().getMiddleName());
                                instructor.setLastName(i.getInstructor().getLastName());
                                instructor.setAcademicTitle(i.getInstructor().getAcademicTitle());
                                instructor.setEmail(i.getInstructor().getEmail());
                                instructor.setFormattedName(i.getInstructor().getName(nameFormat));
                                if (i.getResponsibility() != null) {
                                    instructor.setResponsibility(i.getResponsibility().getLabel());
                                    instructor.setResponsibilityAbbreviation(i.getResponsibility().getAbbreviation());
                                }
                                event.addInstructor(instructor);
                                addedInstructorIds.add(i.getInstructor().getUniqueId());
                            }
                        }
                        for (OfferingCoordinator oc : clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getOfferingCoordinators()) {
                            DepartmentalInstructor c;
                            if (oc.getResponsibility() != null && oc.getResponsibility().hasOption(TeachingResponsibility.Option.noevents) || !addedInstructorIds.add((c = oc.getInstructor()).getUniqueId())) continue;
                            EventInterface.ContactInterface coordinator = new EventInterface.ContactInterface();
                            coordinator.setFirstName(c.getFirstName());
                            coordinator.setMiddleName(c.getMiddleName());
                            coordinator.setLastName(c.getLastName());
                            coordinator.setAcademicTitle(c.getAcademicTitle());
                            coordinator.setEmail(c.getEmail());
                            coordinator.setFormattedName(c.getName(nameFormat));
                            if (oc.getResponsibility() != null) {
                                coordinator.setResponsibility(oc.getResponsibility().getLabel());
                                coordinator.setResponsibilityAbbreviation(oc.getResponsibility().getAbbreviation());
                            }
                            event.addCoordinator(coordinator);
                        }
                        CourseOffering correctedOffering = clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getControllingCourseOffering();
                        ArrayList<CourseOffering> courses = new ArrayList<CourseOffering>(clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getCourseOfferings());
                        switch (request.getResourceType()) {
                            case CURRICULUM: 
                            case PERSON: 
                            case GROUP: {
                                Iterator i = courses.iterator();
                                while (i.hasNext()) {
                                    CourseOffering co = (CourseOffering)i.next();
                                    if (curriculumCourses.contains(co.getUniqueId())) {
                                        if (curriculumCourses.contains(correctedOffering.getUniqueId())) continue;
                                        correctedOffering = co;
                                        continue;
                                    }
                                    i.remove();
                                }
                                break;
                            }
                        }
                        courses.remove(correctedOffering);
                        event.addCourseId(correctedOffering.getUniqueId());
                        event.addCourseName(correctedOffering.getCourseName());
                        event.addCourseTitle(correctedOffering.getTitle() == null ? "" : correctedOffering.getTitle());
                        event.setInstruction(clazz.getSchedulingSubpart().getItype().getDesc().length() <= 20 ? clazz.getSchedulingSubpart().getItype().getDesc() : clazz.getSchedulingSubpart().getItype().getAbbv());
                        if (clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalMethod() != null) {
                            event.setInstruction(event.getInstruction() + " (" + clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalMethod().getLabel() + ")");
                        }
                        event.setInstructionType(clazz.getSchedulingSubpart().getItype().getItype());
                        event.setSectionNumber(clazz.getSectionNumberString(hibSession));
                        if (clazz.getClassSuffix(correctedOffering) == null) {
                            event.setName(clazz.getClassLabel(correctedOffering));
                        } else {
                            event.addExternalId(clazz.getClassSuffix(correctedOffering));
                            event.setName(correctedOffering.getCourseName() + " " + clazz.getClassSuffix(correctedOffering));
                        }
                        for (CourseOffering co : courses) {
                            event.addCourseId(co.getUniqueId());
                            event.addCourseName(co.getCourseName());
                            event.addCourseTitle(co.getTitle() == null ? "" : co.getTitle());
                            if (clazz.getClassSuffix(co) == null) continue;
                            event.addExternalId(clazz.getClassSuffix(co));
                        }
                        DatePattern pattern = clazz.effectiveDatePattern();
                        if (pattern != null) {
                            if ("never".equals(datePatternFormat)) {
                                event.setMessage(pattern.getName());
                            } else if ("extended".equals(datePatternFormat) && pattern.getType() != 3) {
                                event.setMessage(pattern.getName());
                            } else if ("alternate".equals(datePatternFormat) && pattern.getType() == 1) {
                                event.setMessage(pattern.getName());
                            } else {
                                Date last;
                                Date first = pattern.getStartDate();
                                event.setMessage(first.equals(last = pattern.getEndDate()) ? Formats.getDateFormat(Formats.Pattern.DATE_EVENT_LONG).format(first) : Formats.getDateFormat(Formats.Pattern.DATE_EVENT_SHORT).format(first) + " - " + Formats.getDateFormat(Formats.Pattern.DATE_EVENT_LONG).format(last));
                            }
                        }
                        for (RoomPref rp : clazz.effectivePreferences(RoomPref.class)) {
                            if (!PreferenceLevel.sRequired.equals(rp.getPrefLevel().getPrefProlog()) || request.getEventFilter().hasOptions("room") && !request.getEventFilter().getOptions("room").contains(rp.getRoom().getUniqueId().toString())) continue;
                            EventInterface.MeetingInterface meeting = new EventInterface.MeetingInterface();
                            meeting.setPast(true);
                            EventInterface.ResourceInterface location = new EventInterface.ResourceInterface();
                            location.setType(EventInterface.ResourceType.ROOM);
                            location.setId(rp.getRoom().getUniqueId());
                            location.setName(rp.getRoom().getLabel());
                            location.setSize(rp.getRoom().getCapacity());
                            location.setDistance((Double)distances.get(rp.getRoom().getUniqueId()));
                            location.setRoomType(rp.getRoom().getRoomTypeLabel());
                            location.setBreakTime(rp.getRoom().getEffectiveBreakTime());
                            location.setMessage(rp.getRoom().getEventMessage());
                            location.setIgnoreRoomCheck(rp.getRoom().isIgnoreRoomCheck());
                            location.setDisplayName(rp.getRoom().getDisplayName());
                            meeting.setLocation(location);
                            event.addMeeting(meeting);
                        }
                        if (!event.hasMeetings()) {
                            if (request.getEventFilter().hasOptions("room")) continue;
                            EventInterface.MeetingInterface meeting = new EventInterface.MeetingInterface();
                            meeting.setPast(true);
                            event.addMeeting(meeting);
                        }
                        if (correctedOffering.getScheduleBookNote() != null && !correctedOffering.getScheduleBookNote().isEmpty()) {
                            note = new EventInterface.NoteInterface();
                            note.setId(-2L);
                            note.setNote(correctedOffering.getScheduleBookNote());
                            event.addNote(note);
                        }
                        if (clazz.getSchedulePrintNote() != null && !clazz.getSchedulePrintNote().isEmpty()) {
                            note = new EventInterface.NoteInterface();
                            note.setId(-1L);
                            note.setNote(clazz.getSchedulePrintNote());
                            event.addNote(note);
                        }
                        if (request.getEventFilter().hasText() && !event.getName().toLowerCase().startsWith(request.getEventFilter().getText().toLowerCase()) && (request.getEventFilter().getText().length() < 2 || !event.getName().toLowerCase().contains(" " + request.getEventFilter().getText().toLowerCase()))) continue;
                        ret.add(event);
                    }
                }
            }
            if (request.getResourceType() == EventInterface.ResourceType.ROOM) {
                for (Location location : new RoomFilterBackend().locations(request.getSessionId(), request.getRoomFilter(), 1000, distances, context)) {
                    EventInterface unavailability = EventLookupBackend.generateUnavailabilityEvent(location, null);
                    if (unavailability == null) continue;
                    ret.add(unavailability);
                }
            }
            gwtRpcResponseList = ret;
        }
        catch (Throwable throwable) {
            try {
                hibSession.close();
                throw throwable;
            }
            catch (GwtRpcException e) {
                throw e;
            }
            catch (Exception e) {
                sLog.error((Object)("Unable to find events for " + request.getResourceType().getLabel() + " " + request.getResourceId() + ": " + e.getMessage()), (Throwable)e);
                throw new GwtRpcException("Unable to find events for " + request.getResourceType().getLabel() + " " + request.getResourceId() + ": " + e.getMessage(), e);
            }
        }
        hibSession.close();
        return gwtRpcResponseList;
    }

    public static EventInterface generateUnavailabilityEvent(Location location, EventInterface parent) {
        TreeSet<EventInterface.MeetingInterface> meetings = EventLookupBackend.generateUnavailabilityMeetings(location, false);
        if (meetings == null || meetings.isEmpty()) {
            return null;
        }
        EventInterface event = new EventInterface();
        event.setId(-location.getUniqueId().longValue());
        event.setName(MESSAGES.unavailableEventDefaultName());
        event.setType(EventInterface.EventType.Unavailabile);
        if (parent == null) {
            event.setMeetings(meetings);
        } else {
            for (EventInterface.MeetingInterface m : meetings) {
                if (!parent.inConflict(m)) continue;
                event.addMeeting(m);
            }
        }
        if (location.getNote() != null && !location.getNote().isEmpty()) {
            EventInterface.NoteInterface n = new EventInterface.NoteInterface();
            n.setNote(location.getNote());
            event.addNote(n);
        }
        return event;
    }

    public static TreeSet<EventInterface.MeetingInterface> generateUnavailabilityMeetings(Location location, boolean conflict) {
        if (location.getEventAvailability() == null || location.getEventAvailability().length() != 288 * Constants.DAY_CODES.length) {
            return null;
        }
        TreeSet<EventInterface.MeetingInterface> ret = new TreeSet<EventInterface.MeetingInterface>();
        EventInterface.ResourceInterface resource = new EventInterface.ResourceInterface();
        resource.setType(EventInterface.ResourceType.ROOM);
        resource.setId(location.getUniqueId());
        resource.setName(location.getLabel());
        resource.setSize(location.getCapacity());
        resource.setRoomType(location.getRoomTypeLabel());
        resource.setBreakTime(location.getEffectiveBreakTime());
        resource.setMessage(location.getEventMessage());
        resource.setIgnoreRoomCheck(location.isIgnoreRoomCheck());
        resource.setDisplayName(location.getDisplayName());
        Calendar calendar = Calendar.getInstance();
        for (int day = 0; day < Constants.DAY_CODES.length; ++day) {
            int startTime = 0;
            while (startTime < 288) {
                int endTime;
                if (location.getEventAvailability().charAt(day * 288 + startTime) != '1') {
                    ++startTime;
                    continue;
                }
                for (endTime = startTime + 1; endTime < 288 && location.getEventAvailability().charAt(day * 288 + endTime) == '1'; ++endTime) {
                }
                calendar.setTime(location.getSession().getEventBeginDate());
                int dayOfYear = CalendarUtils.date2dayOfYear(location.getSession().getSessionStartYear(), calendar.getTime());
                do {
                    int dayOfWeek = -1;
                    switch (calendar.get(7)) {
                        case 2: {
                            dayOfWeek = 0;
                            break;
                        }
                        case 3: {
                            dayOfWeek = 1;
                            break;
                        }
                        case 4: {
                            dayOfWeek = 2;
                            break;
                        }
                        case 5: {
                            dayOfWeek = 3;
                            break;
                        }
                        case 6: {
                            dayOfWeek = 4;
                            break;
                        }
                        case 7: {
                            dayOfWeek = 5;
                            break;
                        }
                        case 1: {
                            dayOfWeek = 6;
                        }
                    }
                    if (day == dayOfWeek) {
                        EventInterface.MeetingInterface m = null;
                        if (conflict) {
                            EventInterface.MeetingConflictInterface c = new EventInterface.MeetingConflictInterface();
                            c.setName(MESSAGES.unavailableEventDefaultName());
                            c.setType(EventInterface.EventType.Unavailabile);
                            m = c;
                        } else {
                            m = new EventInterface.MeetingInterface();
                        }
                        m.setStartSlot(startTime);
                        m.setEndSlot(endTime);
                        m.setDayOfWeek(dayOfWeek);
                        m.setMeetingDate(calendar.getTime());
                        m.setDayOfYear(dayOfYear);
                        m.setLocation(resource);
                        ret.add(m);
                    }
                    calendar.add(6, 1);
                    ++dayOfYear;
                } while (!calendar.getTime().after(location.getSession().getEventEndDate()));
                startTime = endTime;
            }
        }
        return ret;
    }
}

