/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.dom4j.Document;
import org.dom4j.Element;
import org.unitime.timetable.dataexchange.BaseExport;
import org.unitime.timetable.model.AcademicClassification;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseReservation;
import org.unitime.timetable.model.CurriculumReservation;
import org.unitime.timetable.model.GroupOverrideReservation;
import org.unitime.timetable.model.IndividualOverrideReservation;
import org.unitime.timetable.model.IndividualReservation;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.LearningCommunityReservation;
import org.unitime.timetable.model.OverrideReservation;
import org.unitime.timetable.model.PosMajor;
import org.unitime.timetable.model.Reservation;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentGroup;
import org.unitime.timetable.model.StudentGroupReservation;

public class ReservationExport
extends BaseExport {
    public static String sDateFormat = "MM/dd/yyyy";

    @Override
    public void saveXml(Document document, Session session, Properties parameters) throws Exception {
        try {
            this.beginTransaction();
            Element root = document.addElement("reservations");
            root.addAttribute("campus", session.getAcademicInitiative());
            root.addAttribute("year", session.getAcademicYear());
            root.addAttribute("term", session.getAcademicTerm());
            root.addAttribute("dateFormat", sDateFormat);
            root.addAttribute("created", new Date().toString());
            List reservations = this.getHibSession().createQuery("select r from Reservation r where r.instructionalOffering.session.uniqueId = :sessionId").setLong("sessionId", session.getUniqueId().longValue()).list();
            Collections.sort(reservations, new Comparator<Reservation>(){

                @Override
                public int compare(Reservation r1, Reservation r2) {
                    int cmp = r1.getInstructionalOffering().getControllingCourseOffering().compareTo(r2.getInstructionalOffering().getControllingCourseOffering());
                    if (cmp != 0) {
                        return cmp;
                    }
                    cmp = r1.getClass().getName().compareTo(r2.getClass().getName());
                    if (cmp != 0) {
                        return cmp;
                    }
                    return r1.getUniqueId().compareTo(r2.getUniqueId());
                }
            });
            SimpleDateFormat df = new SimpleDateFormat(sDateFormat, Locale.US);
            for (Reservation reservation : this.getHibSession().createQuery("select r from Reservation r where r.instructionalOffering.session.uniqueId = :sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                Element groupEl;
                StudentGroup group;
                Element reservationEl = root.addElement("reservation");
                CourseOffering course = reservation.getInstructionalOffering().getControllingCourseOffering();
                if (reservation instanceof CourseReservation) {
                    course = ((CourseReservation)reservation).getCourse();
                }
                if (reservation instanceof LearningCommunityReservation) {
                    course = ((LearningCommunityReservation)reservation).getCourse();
                }
                reservationEl.addAttribute("subject", course.getSubjectAreaAbbv());
                reservationEl.addAttribute("courseNbr", course.getCourseNbr());
                if (reservation.getLimit() != null && !(reservation instanceof IndividualReservation)) {
                    reservationEl.addAttribute("limit", reservation.getLimit().toString());
                }
                if (reservation.getExpirationDate() != null) {
                    reservationEl.addAttribute("expire", df.format(reservation.getExpirationDate()));
                }
                if (reservation.getStartDate() != null) {
                    reservationEl.addAttribute("startDate", df.format(reservation.getStartDate()));
                }
                for (InstrOfferingConfig config : reservation.getConfigurations()) {
                    reservationEl.addElement("configuration").addAttribute("name", config.getName());
                }
                for (Class_ clazz : reservation.getClasses()) {
                    Element classEl = reservationEl.addElement("class");
                    if (clazz.getExternalUniqueId() != null) {
                        classEl.addAttribute("externalId", clazz.getExternalUniqueId());
                    }
                    classEl.addAttribute("type", clazz.getItypeDesc().trim());
                    classEl.addAttribute("suffix", this.getClassSuffix(clazz));
                }
                if (reservation instanceof OverrideReservation) {
                    reservationEl.addAttribute("type", ((OverrideReservation)reservation).getOverrideType().getReference());
                    for (Student student : ((OverrideReservation)reservation).getStudents()) {
                        reservationEl.addElement("student").addAttribute("externalId", student.getExternalUniqueId());
                    }
                    continue;
                }
                if (reservation instanceof IndividualReservation) {
                    reservationEl.addAttribute("type", "individual");
                    for (Student student : ((IndividualReservation)reservation).getStudents()) {
                        reservationEl.addElement("student").addAttribute("externalId", student.getExternalUniqueId());
                    }
                    if (!(reservation instanceof IndividualOverrideReservation)) continue;
                    IndividualOverrideReservation override = (IndividualOverrideReservation)reservation;
                    reservationEl.addElement("override", "true");
                    reservationEl.addElement("expired", override.isAlwaysExpired() ? "true" : "false");
                    reservationEl.addElement("allowOverlap", override.isAllowOverlap() ? "true" : "false");
                    reservationEl.addElement("overLimit", override.isCanAssignOverLimit() ? "true" : "false");
                    reservationEl.addElement("mustBeUsed", override.isMustBeUsed() ? "true" : "false");
                    continue;
                }
                if (reservation instanceof LearningCommunityReservation) {
                    reservationEl.addAttribute("type", "lc");
                    group = ((LearningCommunityReservation)reservation).getGroup();
                    groupEl = reservationEl.addElement("studentGroup");
                    if (group.getExternalUniqueId() != null) {
                        groupEl.addAttribute("externalId", group.getExternalUniqueId());
                    }
                    groupEl.addAttribute("code", group.getGroupAbbreviation());
                    continue;
                }
                if (reservation instanceof StudentGroupReservation) {
                    reservationEl.addAttribute("type", "group");
                    group = ((StudentGroupReservation)reservation).getGroup();
                    groupEl = reservationEl.addElement("studentGroup");
                    if (group.getExternalUniqueId() != null) {
                        groupEl.addAttribute("externalId", group.getExternalUniqueId());
                    }
                    groupEl.addAttribute("code", group.getGroupAbbreviation());
                    if (!(reservation instanceof GroupOverrideReservation)) continue;
                    Iterator<PosMajor> override = (GroupOverrideReservation)reservation;
                    reservationEl.addElement("override", "true");
                    reservationEl.addElement("expired", ((GroupOverrideReservation)((Object)override)).isAlwaysExpired() ? "true" : "false");
                    reservationEl.addElement("allowOverlap", ((GroupOverrideReservation)((Object)override)).isAllowOverlap() ? "true" : "false");
                    reservationEl.addElement("overLimit", ((GroupOverrideReservation)((Object)override)).isCanAssignOverLimit() ? "true" : "false");
                    reservationEl.addElement("mustBeUsed", ((GroupOverrideReservation)((Object)override)).isMustBeUsed() ? "true" : "false");
                    continue;
                }
                if (reservation instanceof CurriculumReservation) {
                    reservationEl.addAttribute("type", "curriculum");
                    CurriculumReservation curRes = (CurriculumReservation)reservation;
                    Element acadAreaEl = reservationEl.addElement("academicArea");
                    if (curRes.getArea().getExternalUniqueId() != null) {
                        acadAreaEl.addAttribute("externalId", curRes.getArea().getExternalUniqueId());
                    }
                    acadAreaEl.addAttribute("abbreviation", curRes.getArea().getAcademicAreaAbbreviation());
                    for (AcademicClassification clasf : curRes.getClassifications()) {
                        Element clasfEl = reservationEl.addElement("academicClassification");
                        if (clasf.getExternalUniqueId() != null) {
                            clasfEl.addAttribute("externalId", clasf.getExternalUniqueId());
                        }
                        clasfEl.addAttribute("code", clasf.getCode());
                    }
                    for (PosMajor major : curRes.getMajors()) {
                        Element majorEl = reservationEl.addElement("major");
                        if (major.getExternalUniqueId() != null) {
                            majorEl.addAttribute("externalId", major.getExternalUniqueId());
                        }
                        majorEl.addAttribute("code", major.getCode());
                    }
                    continue;
                }
                if (reservation instanceof CourseReservation) {
                    if (course.getReservation() != null) {
                        reservationEl.addAttribute("limit", course.getReservation().toString());
                    }
                    reservationEl.addAttribute("type", "course");
                    continue;
                }
                if (reservation instanceof OverrideReservation) {
                    OverrideReservation ovRes = (OverrideReservation)reservation;
                    reservationEl.addAttribute("type", ovRes.getOverrideType().getReference());
                    for (Student student : ovRes.getStudents()) {
                        reservationEl.addElement("student").addAttribute("externalId", student.getExternalUniqueId());
                    }
                    continue;
                }
                reservationEl.addAttribute("type", "unknown");
            }
            this.commitTransaction();
        }
        catch (Exception e) {
            this.fatal("Exception: " + e.getMessage(), e);
            this.rollbackTransaction();
        }
    }
}

