/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.api;

import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hibernate.CacheMode;
import org.unitime.timetable.api.AbstractApiHelper;
import org.unitime.timetable.api.ApiHelper;
import org.unitime.timetable.api.ErrorMessage;
import org.unitime.timetable.security.SessionContext;

public class JsonApiHelper
extends AbstractApiHelper {
    protected Gson iGson;

    public JsonApiHelper(HttpServletRequest request, HttpServletResponse response, SessionContext context, CacheMode cacheMode) {
        super(request, response, context, cacheMode);
    }

    protected Gson createGson() {
        return new GsonBuilder().registerTypeAdapter(Timestamp.class, (Object)new JsonSerializer<Timestamp>(){

            public JsonElement serialize(Timestamp src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(src));
            }
        }).registerTypeAdapter(Date.class, (Object)new JsonSerializer<Date>(){

            public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(new SimpleDateFormat("yyyy-MM-dd").format(src));
            }
        }).registerTypeAdapter(java.util.Date.class, (Object)new JsonSerializer<java.util.Date>(){

            public JsonElement serialize(java.util.Date src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(src));
            }
        }).setFieldNamingStrategy(new FieldNamingStrategy(){
            Pattern iPattern = Pattern.compile("i([A-Z])(.*)");

            public String translateName(Field f) {
                Matcher matcher = this.iPattern.matcher(f.getName());
                if (matcher.matches()) {
                    return matcher.group(1).toLowerCase() + matcher.group(2);
                }
                return f.getName();
            }
        }).setPrettyPrinting().create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P> P getRequest(Type requestType) throws IOException {
        if (this.iGson == null) {
            this.iGson = this.createGson();
        }
        try (JsonReader reader = new JsonReader((Reader)this.iRequest.getReader());){
            Object object = this.iGson.fromJson(reader, requestType);
            return (P)object;
        }
    }

    @Override
    public <R> void setResponse(R response) throws IOException {
        if (this.iGson == null) {
            this.iGson = this.createGson();
        }
        this.iResponse.setContentType("application/json");
        this.iResponse.setCharacterEncoding("UTF-8");
        this.iResponse.setHeader("Pragma", "no-cache");
        this.iResponse.addHeader("Cache-Control", "must-revalidate");
        this.iResponse.addHeader("Cache-Control", "no-cache");
        this.iResponse.addHeader("Cache-Control", "no-store");
        this.iResponse.setDateHeader("Date", new java.util.Date().getTime());
        this.iResponse.setDateHeader("Expires", 0L);
        this.iResponse.setHeader("Content-Disposition", "attachment; filename=\"response.json\"");
        PrintWriter writer = this.iResponse.getWriter();
        try {
            ((Writer)writer).write(this.iGson.toJson(response));
        }
        finally {
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
    }

    @Override
    public void sendError(int code, String message) throws IOException {
        try {
            this.iResponse.setStatus(code);
            this.setResponse(new ErrorMessage(code, message, (ApiHelper)this));
        }
        catch (Throwable t) {
            this.iResponse.sendError(code, message);
        }
    }

    @Override
    public void sendError(int code) throws IOException {
        try {
            this.iResponse.setStatus(code);
            this.setResponse(new ErrorMessage(code, this));
        }
        catch (Throwable t) {
            this.iResponse.sendError(code);
        }
    }

    @Override
    public void sendError(int code, Throwable error) throws IOException {
        try {
            this.iResponse.setStatus(code);
            this.setResponse(new ErrorMessage(code, error, (ApiHelper)this));
        }
        catch (Throwable t) {
            this.iResponse.sendError(code, error.getMessage());
        }
    }
}

