/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.LabelValueBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.form.InstructorSearchForm;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;

@Service(value="/instructorSearch")
public class InstructorSearchAction
extends Action {
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.sessionContext.checkPermission(Right.Instructors);
        InstructorSearchForm instructorSearchForm = (InstructorSearchForm)form;
        Set<Department> departments = this.setupManagerDepartments(request);
        String deptId = (String)this.sessionContext.getAttribute(SessionAttribute.DepartmentId);
        if ((deptId == null || deptId.isEmpty()) && departments.size() == 1) {
            deptId = departments.iterator().next().getUniqueId().toString();
        }
        if (deptId == null || deptId.isEmpty() || !this.sessionContext.hasPermission((Serializable)((Object)deptId), "Department", Right.Instructors)) {
            return mapping.findForward("showInstructorSearch");
        }
        instructorSearchForm.setDeptUniqueId(deptId);
        List<DepartmentalInstructor> instructors = DepartmentalInstructor.findInstructorsForDepartment(Long.valueOf(deptId));
        if (instructors == null || instructors.isEmpty()) {
            ActionMessages errors = new ActionMessages();
            errors.add("searchResult", new ActionMessage("errors.generic", (Object)MSG.errorNoInstructorsFoundForDepartment()));
            this.saveErrors(request, errors);
        }
        return mapping.findForward("instructorList");
    }

    private Set<Department> setupManagerDepartments(HttpServletRequest request) throws Exception {
        TreeSet<Department> departments = Department.getUserDepartments(this.sessionContext.getUser());
        if (departments.isEmpty()) {
            throw new Exception(MSG.exceptionNoDepartmentToManage());
        }
        ArrayList<LabelValueBean> labelValueDepts = new ArrayList<LabelValueBean>();
        for (Department d : departments) {
            labelValueDepts.add(new LabelValueBean(d.getDeptCode() + "-" + d.getName(), d.getUniqueId().toString()));
        }
        if (labelValueDepts.size() == 1) {
            request.setAttribute("deptId", (Object)((LabelValueBean)labelValueDepts.get(0)).getValue());
        }
        request.setAttribute(Department.DEPT_ATTR_NAME, labelValueDepts);
        return departments;
    }
}

