/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.DataSource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.upload.FormFile;
import org.apache.struts.util.MessageResources;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.commons.Email;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.form.InquiryForm;
import org.unitime.timetable.model.ContactCategory;
import org.unitime.timetable.model.EventContact;
import org.unitime.timetable.model.dao.ContactCategoryDAO;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.UserQualifier;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.LookupTables;

@Service(value="/inquiry")
public class InquiryAction
extends Action {
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            HashMap<String, Attachment> files;
            InquiryForm myForm = (InquiryForm)form;
            MessageResources rsc = this.getResources(request);
            this.sessionContext.checkPermission(Right.Inquiry);
            String op = myForm.getOp() != null ? myForm.getOp() : request.getParameter("op");
            myForm.setNoRole(!this.sessionContext.getUser().getCurrentAuthority().hasRight(Right.HasRole));
            if (op == null && request.getParameter("op2") == null) {
                request.getSession().removeAttribute("ContactUsFiles");
            }
            if ("Cancel".equals(op) || "Back".equals(op)) {
                request.getSession().removeAttribute("ContactUsFiles");
                return mapping.findForward("submit");
            }
            ActionMessages errors = null;
            if (op != null && op.equals(rsc.getMessage("button.insertAddress"))) {
                if (myForm.getPuid() != null && myForm.getPuid().length() > 0) {
                    myForm.addToCarbonCopy(myForm.getPuid());
                    myForm.setPuid(null);
                } else {
                    errors = new ActionMessages();
                    errors.add("puid", new ActionMessage("errors.generic", (Object)"Recipient has an invalid email address."));
                    this.saveErrors(request, errors);
                }
            }
            if (myForm.getFile() != null && myForm.getFile().getFileSize() > 0) {
                files = (HashMap<String, Attachment>)request.getSession().getAttribute("ContactUsFiles");
                if (files == null) {
                    files = new HashMap<String, Attachment>();
                    request.getSession().setAttribute("ContactUsFiles", files);
                }
                files.put(myForm.getFile().getFileName(), new Attachment(myForm.getFile()));
            }
            if (request.getParameter("deleteFile") != null && !request.getParameter("deleteFile").isEmpty() && (files = (Map)request.getSession().getAttribute("ContactUsFiles")) != null) {
                files.remove(request.getParameter("deleteFile"));
            }
            if (request.getParameter("deleteId") != null && request.getParameter("deleteId").length() > 0) {
                try {
                    int deleteId = Integer.parseInt(request.getParameter("deleteId"));
                    myForm.removeCarbonCopy(deleteId);
                    myForm.setPuid(null);
                }
                catch (Exception e) {
                    errors = new ActionMessages();
                    errors.add("puid", new ActionMessage("errors.generic", (Object)"Invalid email address."));
                    this.saveErrors(request, errors);
                }
            }
            if ("Submit".equals(op)) {
                errors = myForm.validate(mapping, request);
                if (errors.size() > 0) {
                    this.saveErrors(request, errors);
                } else {
                    Map files2;
                    ContactCategory cc;
                    List<? extends UserQualifier> sg;
                    List<? extends UserQualifier> depts;
                    String mail = myForm.getMessage();
                    mail = mail + "\r\n";
                    mail = mail + "\r\n";
                    mail = mail + "User info -------------- \r\n";
                    mail = mail + "User: " + this.sessionContext.getUser().getName() + "\r\n";
                    mail = mail + "Login: " + this.sessionContext.getUser().getUsername() + "\r\n";
                    mail = mail + "Email: " + this.sessionContext.getUser().getEmail() + "\r\n";
                    mail = mail + "Role: " + this.sessionContext.getUser().getCurrentAuthority() + "\r\n";
                    List<? extends UserQualifier> sessions = this.sessionContext.getUser().getCurrentAuthority().getQualifiers("Session");
                    if (!sessions.isEmpty()) {
                        mail = mail + "Academic Session: " + ((Qualifiable)sessions.get(0)).getQualifierLabel() + "\r\n";
                    }
                    if (!(depts = this.sessionContext.getUser().getCurrentAuthority().getQualifiers("Department")).isEmpty()) {
                        mail = mail + "Departments: " + depts + "\r\n";
                    }
                    if (!(sg = this.sessionContext.getUser().getCurrentAuthority().getQualifiers("SolverGroup")).isEmpty()) {
                        mail = mail + "Solver Groups: " + sg + "\r\n";
                    }
                    mail = mail + "\r\n";
                    mail = mail + "\r\n";
                    mail = mail + "Application info -------------- \r\n";
                    mail = mail + "Version: " + Constants.getVersion() + " (" + Constants.getReleaseDate() + ")\r\n";
                    mail = mail + "TimeStamp: " + new Date();
                    EventContact c = EventContact.findByExternalUniqueId(this.sessionContext.getUser().getExternalUserId());
                    Email email = Email.createEmail();
                    email.setSubject("UniTime (" + myForm.getTypeMsg(myForm.getType()) + "): " + myForm.getSubject());
                    email.setText(mail);
                    if (!myForm.getCarbonCopy().isEmpty()) {
                        Iterator i = myForm.getCarbonCopy().iterator();
                        while (i.hasNext()) {
                            email.addRecipientCC((String)i.next(), null);
                        }
                    }
                    if ((cc = (ContactCategory)ContactCategoryDAO.getInstance().get(myForm.getType())) != null && cc.getEmail() != null && !cc.getEmail().isEmpty()) {
                        String suffix = ApplicationProperty.EmailDefaultAddressSuffix.value();
                        for (String address : cc.getEmail().split("[\n,]")) {
                            if (address.trim().isEmpty()) continue;
                            if (suffix != null && address.indexOf(64) < 0) {
                                email.addRecipient(address.trim() + suffix, null);
                                continue;
                            }
                            email.addRecipient(address.trim(), null);
                        }
                    } else if (ApplicationProperty.EmailInquiryAddress.value() != null) {
                        email.addRecipient(ApplicationProperty.EmailInquiryAddress.value(), ApplicationProperty.EmailInquiryAddressName.value());
                    } else {
                        email.addNotify();
                    }
                    boolean autoreply = ApplicationProperty.EmailInquiryAutoreply.isTrue();
                    if (!autoreply) {
                        if (this.sessionContext.getUser().getEmail() != null && !this.sessionContext.getUser().getEmail().isEmpty()) {
                            email.addRecipientCC(this.sessionContext.getUser().getEmail(), this.sessionContext.getUser().getName());
                        } else if (c != null && c.getEmailAddress() != null && !c.getEmailAddress().isEmpty()) {
                            email.addRecipientCC(c.getEmailAddress(), c.getName());
                        } else {
                            email.addRecipientCC(this.sessionContext.getUser().getUsername() + ApplicationProperty.EmailInquiryAddressSuffix.value(), this.sessionContext.getUser().getName());
                        }
                    }
                    if ((files2 = (Map)request.getSession().getAttribute("ContactUsFiles")) != null) {
                        for (Attachment attachment : files2.values()) {
                            email.addAttachment(attachment);
                        }
                        request.getSession().removeAttribute("ContactUsFiles");
                    }
                    email.send();
                    if (autoreply) {
                        try {
                            mail = "The following inquiry was submitted on your behalf. We will contact you soon. This email was automatically generated, please do not reply.\n\n";
                            if (ApplicationProperty.EmailSenderName.value() != null) {
                                mail = mail + "Thank you, \n\n" + ApplicationProperty.EmailSenderName.value() + "\n\n";
                            }
                            mail = mail + "-- INQUIRY (" + myForm.getTypeMsg(myForm.getType()) + "): " + myForm.getSubject() + " ---------- \n\n" + myForm.getMessage() + "\n-- END INQUIRY -------------------------------------------";
                            email = Email.createEmail();
                            email.setSubject("RE: UniTime (" + myForm.getTypeMsg(myForm.getType()) + "): " + myForm.getSubject());
                            email.setText(mail);
                            if (this.sessionContext.getUser().getEmail() != null && !this.sessionContext.getUser().getEmail().isEmpty()) {
                                email.addRecipient(this.sessionContext.getUser().getEmail(), this.sessionContext.getUser().getName());
                            } else if (c != null && c.getEmailAddress() != null && !c.getEmailAddress().isEmpty()) {
                                email.addRecipient(c.getEmailAddress(), c.getName());
                            } else {
                                email.addRecipient(this.sessionContext.getUser().getUsername() + ApplicationProperty.EmailInquiryAddressSuffix.value(), this.sessionContext.getUser().getName());
                            }
                            email.send();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    myForm.setOp("Sent");
                    return mapping.findForward("display");
                }
            }
            LookupTables.setupTimetableManagers(request);
            myForm.updateMessage();
            return mapping.findForward("display");
        }
        catch (Exception e) {
            Debug.error(e);
            throw e;
        }
    }

    static class Attachment
    implements DataSource,
    Serializable {
        private static final long serialVersionUID = 1L;
        private String iName;
        private byte[] iData;
        private String iContentType;

        public Attachment(FormFile file) throws IOException {
            this.iName = file.getFileName();
            this.iData = file.getFileData();
            this.iContentType = file.getContentType();
        }

        public String getContentType() {
            return this.iContentType;
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.iData);
        }

        public String getName() {
            return this.iName;
        }

        public OutputStream getOutputStream() throws IOException {
            return null;
        }
    }
}

