/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.WriterAppender;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.dom4j.Document;
import org.hibernate.MappingException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.engine.jdbc.internal.BasicFormatterImpl;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.hql.internal.QueryExecutionRequestException;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.type.CollectionType;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.export.BufferedPrinter;
import org.unitime.timetable.export.CSVPrinter;
import org.unitime.timetable.export.hql.TestHqlExportToCSV;
import org.unitime.timetable.form.HibernateQueryTestForm;
import org.unitime.timetable.model.SavedHQL;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.webutil.BackTracker;
import org.unitime.timetable.webutil.Navigation;

@Service(value="/hibernateQueryTest")
public class HibernateQueryTestAction
extends Action {
    private static Level iOriginalLevel = null;
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String url;
        String q;
        this.sessionContext.checkPermission(Right.TestHQL);
        String op = request.getParameter("op");
        if (!(op != null && (op.equals("Submit") || op.equals("Export CSV") || op.equals("Next") || op.equals("Previous") || op.equals("Back")))) {
            if ("Clear Cache".equals(op)) {
                HibernateUtil.clearCache();
            }
            return mapping.findForward("displayQueryForm");
        }
        HibernateQueryTestForm frm = (HibernateQueryTestForm)form;
        if ("Back".equals(op) && (frm.getQuery() == null || frm.getQuery().isEmpty()) && (q = (String)request.getSession().getAttribute("TestHQL.LastQuery")) != null) {
            frm.setQuery(q);
        }
        ActionErrors errors = frm.validate(mapping, request);
        if ("Next".equals(op)) {
            frm.setStart(frm.getStart() + ApplicationProperty.TestHQLMaxLines.intValue());
        }
        if ("Previous".equals(op)) {
            frm.setStart(Math.max(0, frm.getStart() - ApplicationProperty.TestHQLMaxLines.intValue()));
        }
        if ("Submit".equals(op)) {
            frm.setStart(0);
        }
        if ("Export CSV".equals(op) && errors.size() == 0) {
            String query = frm.getQuery();
            for (SavedHQL.Option o : SavedHQL.Option.values()) {
                if (query.indexOf("%" + o.name() + "%") < 0) continue;
                String value = null;
                if (value == null || value.isEmpty()) {
                    Map<Long, String> vals = o.values(this.sessionContext.getUser());
                    if (vals == null || vals.isEmpty()) {
                        errors.add("query", new ActionMessage("errors.generic", (Object)("Unable to set parameter " + o.name() + ": no available values.")));
                        this.saveErrors(request, (ActionMessages)errors);
                        return mapping.findForward("displayQueryForm");
                    }
                    value = "";
                    for (Long id : vals.keySet()) {
                        if (!value.isEmpty()) {
                            value = value + ",";
                        }
                        value = value + id.toString();
                    }
                }
                query = query.replace("%" + o.name() + "%", "(" + value + ")");
            }
            BufferedPrinter out = new BufferedPrinter(new CSVPrinter(response.getWriter(), false));
            response.setContentType(out.getContentType() + "; charset=UTF-8");
            response.setCharacterEncoding("UTF-8");
            response.setHeader("Pragma", "no-cache");
            response.addHeader("Cache-Control", "must-revalidate");
            response.addHeader("Cache-Control", "no-cache");
            response.addHeader("Cache-Control", "no-store");
            response.setDateHeader("Date", new Date().getTime());
            response.setDateHeader("Expires", 0L);
            response.setHeader("Content-Disposition", "attachment; filename=\"hql-test.csv\"");
            TestHqlExportToCSV.execute(this.sessionContext.getUser(), out, query, 0, -1);
            out.close();
            return null;
        }
        Logger sqlLog = Logger.getLogger((String)"org.hibernate.SQL");
        if (iOriginalLevel == null) {
            iOriginalLevel = sqlLog.getLevel();
        }
        sqlLog.setLevel(Level.DEBUG);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        WriterAppender myAppender = new WriterAppender((Layout)new PatternLayout("%m%n"), (OutputStream)out);
        sqlLog.addAppender((Appender)myAppender);
        frm.setExport(false);
        if (errors.size() == 0) {
            try {
                int limit = ApplicationProperty.TestHQLMaxLines.intValue();
                String query = frm.getQuery();
                for (SavedHQL.Option o : SavedHQL.Option.values()) {
                    if (query.indexOf("%" + o.name() + "%") < 0) continue;
                    String value = null;
                    if (value == null || value.isEmpty()) {
                        Map<Long, String> vals = o.values(this.sessionContext.getUser());
                        if (vals == null || vals.isEmpty()) {
                            throw new Exception("Unable to set parameter " + o.name() + ": no available values.");
                        }
                        value = "";
                        for (Long id : vals.keySet()) {
                            if (!value.isEmpty()) {
                                value = value + ",";
                            }
                            value = value + id.toString();
                        }
                    }
                    query = query.replace("%" + o.name() + "%", "(" + value + ")");
                }
                _RootDAO rdao = new _RootDAO();
                Session hibSession = rdao.getSession();
                Query q2 = hibSession.createQuery(query);
                q2.setFirstResult(frm.getStart());
                if (limit > 0) {
                    q2.setMaxResults(limit + 1);
                }
                try {
                    List l = q2.list();
                    String[] alias = q2.getReturnAliases();
                    ArrayList<Long> ids = new ArrayList<Long>();
                    StringBuffer s = new StringBuffer();
                    Iterator i = l.iterator();
                    for (int line = 0; i.hasNext() && (limit <= 0 || line < limit); ++line) {
                        Object o = i.next();
                        if (s.length() == 0) {
                            this.printHeader(s, o, alias);
                        }
                        this.printLine(s, o, (SessionImplementor)hibSession, alias);
                        if (o == null || !(o instanceof Object[]) || ((Object[])o).length <= 0 || ((Object[])o)[0] == null || !(((Object[])o)[0] instanceof Long)) continue;
                        ids.add((Long)((Object[])o)[0]);
                    }
                    if (s.length() > 0) {
                        this.printFooter(s);
                        request.setAttribute("result", (Object)s.toString());
                    }
                    if (frm.getStart() == 0) {
                        if (limit > 0 && l.size() > limit) {
                            frm.setListSize(limit + "+ lines");
                        } else {
                            frm.setListSize(l.size() + " lines");
                        }
                    } else if (limit > 0 && l.size() > limit) {
                        frm.setListSize("lines " + frm.getStart() + " ... " + (frm.getStart() + limit));
                    } else {
                        frm.setListSize("lines " + frm.getStart() + " ... " + (frm.getStart() + l.size()));
                    }
                    frm.setExport(!l.isEmpty());
                    frm.setNext(limit > 0 && l.size() > limit);
                    if (!ids.isEmpty() && alias != null && alias.length > 0 && alias[0].startsWith("__")) {
                        if ("__Class".equals(alias[0])) {
                            Navigation.set(this.sessionContext, Navigation.sClassLevel, ids);
                        } else if ("__Offering".equals(alias[0])) {
                            Navigation.set(this.sessionContext, Navigation.sInstructionalOfferingLevel, ids);
                        } else if ("__Subpart".equals(alias[0])) {
                            Navigation.set(this.sessionContext, Navigation.sSchedulingSubpartLevel, ids);
                        } else if ("__Room".equals(alias[0])) {
                            Navigation.set(this.sessionContext, Navigation.sInstructionalOfferingLevel, ids);
                        } else if ("__Instructor".equals(alias[0])) {
                            Navigation.set(this.sessionContext, Navigation.sInstructionalOfferingLevel, ids);
                        } else if ("__Exam".equals(alias[0])) {
                            Navigation.set(this.sessionContext, Navigation.sInstructionalOfferingLevel, ids);
                        } else if ("__Event".equals(alias[0])) {
                            Navigation.set(this.sessionContext, Navigation.sInstructionalOfferingLevel, ids);
                        }
                    }
                }
                catch (QueryExecutionRequestException e) {
                    Transaction tx = null;
                    try {
                        tx = hibSession.beginTransaction();
                        int i = q2.executeUpdate();
                        request.setAttribute("result", (Object)(i + " lines updated."));
                        frm.setListSize(i + " lines updated");
                        tx.commit();
                    }
                    catch (Exception ex) {
                        if (tx != null && tx.isActive()) {
                            tx.rollback();
                        }
                        throw ex;
                    }
                    hibSession.flush();
                    HibernateUtil.clearCache();
                }
            }
            catch (Exception e) {
                errors.add("query", new ActionMessage("errors.generic", (Object)e.getMessage()));
                Debug.error(e);
            }
        }
        sqlLog.removeAppender((Appender)myAppender);
        sqlLog.setLevel(iOriginalLevel == null ? Level.INFO : iOriginalLevel);
        out.flush();
        out.close();
        String sql = "";
        try {
            StringTokenizer stk = new StringTokenizer(new String(out.toByteArray()), "\n");
            while (stk.hasMoreTokens()) {
                String line = stk.nextToken();
                String comment = null;
                if (line.indexOf("/*") >= 0 && line.indexOf("/*") < line.indexOf("*/")) {
                    comment = line.substring(line.indexOf("/*") + 2, line.indexOf("*/"));
                    line = line.substring(0, line.indexOf("/*")) + line.substring(line.indexOf("*/") + 2);
                }
                if (sql.length() > 0) {
                    sql = sql + "<br><br>";
                }
                if (comment != null) {
                    sql = sql + "<font color='gray'>-- " + comment + "</font>";
                }
                BasicFormatterImpl f = new BasicFormatterImpl();
                sql = sql + f.format(line).replaceAll("\n", "<br>").replaceAll(" ", "&nbsp;");
            }
        }
        catch (Exception stk) {
            // empty catch block
        }
        if (sql.length() > 0) {
            request.setAttribute("sql", (Object)sql);
        }
        if ((url = "hibernateQueryTest.do?query=" + URLEncoder.encode(frm.getQuery(), "utf-8") + "&start=" + frm.getStart() + "&op=Back").length() <= 2000) {
            request.getSession().removeAttribute("TestHQL.LastQuery");
            BackTracker.markForBack(request, url, "HQL", true, true);
        } else {
            request.getSession().setAttribute("TestHQL.LastQuery", (Object)frm.getQuery());
            BackTracker.markForBack(request, "hibernateQueryTest.do?start=" + frm.getStart() + "&op=Back", "HQL", true, true);
        }
        this.saveErrors(request, (ActionMessages)errors);
        return mapping.findForward("displayQueryForm");
    }

    private void header(StringBuffer s, int idx, String text) {
        block4: {
            s.append("<td class='WebTableHeader'><i>");
            if (text == null || text.length() <= 0) {
                s.append("Col " + idx);
            } else {
                try {
                    s.append("Col " + (1 + Integer.parseInt(text)));
                }
                catch (NumberFormatException e) {
                    s.append(text.substring(0, 1).toUpperCase());
                    if (text.length() <= 1) break block4;
                    s.append(text.substring(1).replace('_', ' '));
                }
            }
        }
        s.append("</i></td>");
    }

    private boolean skip(Type t, boolean lazy) {
        try {
            if (t.isCollectionType()) {
                if (!lazy) {
                    return true;
                }
                SessionFactory hibSessionFactory = new _RootDAO().getSession().getSessionFactory();
                Type w = ((CollectionType)t).getElementType((SessionFactoryImplementor)hibSessionFactory);
                Class<?> ts = w.getReturnedClass().getMethod("toString", new Class[0]).getDeclaringClass();
                return ts.equals(Object.class) || ts.getName().startsWith("org.unitime.timetable.model.base.Base");
            }
        }
        catch (MappingException e) {
            return true;
        }
        catch (NoSuchMethodException e) {
            return true;
        }
        try {
            Class<?> ts = t.getReturnedClass().getMethod("toString", new Class[0]).getDeclaringClass();
            return ts.equals(Object.class) || ts.getName().startsWith("org.unitime.timetable.model.base.Base");
        }
        catch (NoSuchMethodException e) {
            return true;
        }
    }

    public void printHeader(StringBuffer s, Object o, String[] alias) {
        s.append("<table width='100%' border='0' cellspacing='0' cellpadding='3'>");
        s.append("<tr align='left'>");
        SessionFactory hibSessionFactory = new _RootDAO().getSession().getSessionFactory();
        boolean hasLink = false;
        if (alias != null && alias.length > 0 && alias[0].startsWith("__")) {
            if ("__Class".equals(alias[0])) {
                hasLink = true;
            } else if ("__Offering".equals(alias[0])) {
                hasLink = true;
            } else if ("__Subpart".equals(alias[0])) {
                hasLink = true;
            } else if ("__Room".equals(alias[0])) {
                hasLink = true;
            } else if ("__Instructor".equals(alias[0])) {
                hasLink = true;
            } else if ("__Exam".equals(alias[0])) {
                hasLink = true;
            } else if ("__Event".equals(alias[0])) {
                hasLink = true;
            }
        }
        int idx = 1;
        if (o == null) {
            this.header(s, idx++, alias != null && alias.length > 0 && alias[0] != null && !alias[0].isEmpty() ? alias[0] : null);
        } else if (o instanceof Object[]) {
            Object[] x = (Object[])o;
            for (int i = 0; i < x.length; ++i) {
                String a;
                if (hasLink && i == 0) continue;
                String string = a = alias != null && alias.length > i && alias[i] != null && !alias[i].isEmpty() ? alias[i] : null;
                if (x[i] == null) {
                    this.header(s, idx++, a);
                    continue;
                }
                ClassMetadata meta = hibSessionFactory.getClassMetadata(x[i].getClass());
                if (meta == null) {
                    this.header(s, idx++, a);
                    continue;
                }
                this.header(s, idx++, meta.getIdentifierPropertyName());
                for (int j = 0; j < meta.getPropertyNames().length; ++j) {
                    if (this.skip(meta.getPropertyTypes()[j], meta.getPropertyLaziness()[j])) continue;
                    this.header(s, idx++, meta.getPropertyNames()[j]);
                }
            }
        } else {
            ClassMetadata meta = hibSessionFactory.getClassMetadata(o.getClass());
            if (meta == null) {
                this.header(s, idx++, alias != null && alias.length > 0 && alias[0] != null && !alias[0].isEmpty() ? alias[0] : null);
            } else {
                this.header(s, idx++, meta.getIdentifierPropertyName());
                for (int i = 0; i < meta.getPropertyNames().length; ++i) {
                    if (this.skip(meta.getPropertyTypes()[i], meta.getPropertyLaziness()[i])) continue;
                    this.header(s, idx++, meta.getPropertyNames()[i]);
                }
            }
        }
        s.append("</tr>");
    }

    private void line(StringBuffer s, Object text) {
        s.append("<td>");
        if (text != null) {
            if (text instanceof Document) {
                s.append(StringEscapeUtils.escapeHtml((String)((Document)text).asXML()));
            } else {
                s.append(text.toString());
            }
        }
        s.append("</td>");
    }

    public void printLine(StringBuffer s, Object o, SessionImplementor session, String[] alias) {
        String link = null;
        if (alias != null && alias.length > 0 && alias[0].startsWith("__") && o != null && o instanceof Object[]) {
            if ("__Class".equals(alias[0])) {
                link = "classDetail.do?cid=" + ((Object[])o)[0];
            } else if ("__Offering".equals(alias[0])) {
                link = "instructionalOfferingDetail.do?op=view&io=" + ((Object[])o)[0];
            } else if ("__Subpart".equals(alias[0])) {
                link = "schedulingSubpartDetail.do?ssuid=" + ((Object[])o)[0];
            } else if ("__Room".equals(alias[0])) {
                link = "gwt.jsp?page=rooms&back=1&id=" + ((Object[])o)[0];
            } else if ("__Instructor".equals(alias[0])) {
                link = "instructorDetail.do?instructorId=" + ((Object[])o)[0];
            } else if ("__Exam".equals(alias[0])) {
                link = "examDetail.do?examId=" + ((Object[])o)[0];
            } else if ("__Event".equals(alias[0])) {
                link = "gwt.jsp?page=events#event=" + ((Object[])o)[0];
            }
        }
        s.append("<tr align='left' onmouseover=\"this.style.backgroundColor='rgb(223,231,242)';\" onmouseout=\"this.style.backgroundColor='transparent';\" " + (link == null ? "" : "onClick=\"document.location='" + link + "';\"") + ">");
        SessionFactory hibSessionFactory = new _RootDAO().getSession().getSessionFactory();
        if (o == null) {
            this.line(s, null);
        } else if (o instanceof Object[]) {
            Object[] x = (Object[])o;
            for (int i = 0; i < x.length; ++i) {
                if (link != null && i == 0) continue;
                if (x[i] == null) {
                    this.line(s, null);
                    continue;
                }
                ClassMetadata meta = hibSessionFactory.getClassMetadata(x[i].getClass());
                if (meta == null) {
                    this.line(s, x[i]);
                    continue;
                }
                this.line(s, meta.getIdentifier(x[i], session));
                for (int j = 0; j < meta.getPropertyNames().length; ++j) {
                    if (this.skip(meta.getPropertyTypes()[j], meta.getPropertyLaziness()[j])) continue;
                    this.line(s, meta.getPropertyValue(x[i], meta.getPropertyNames()[j]));
                }
            }
        } else {
            ClassMetadata meta = hibSessionFactory.getClassMetadata(o.getClass());
            if (meta == null) {
                this.line(s, o);
            } else {
                this.line(s, meta.getIdentifier(o, session));
                for (int i = 0; i < meta.getPropertyNames().length; ++i) {
                    if (this.skip(meta.getPropertyTypes()[i], meta.getPropertyLaziness()[i])) continue;
                    this.line(s, meta.getPropertyValue(o, meta.getPropertyNames()[i]));
                }
            }
        }
        s.append("</tr>");
    }

    public void printFooter(StringBuffer s) {
        s.append("</table>");
    }
}

