/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.xml;

import biweekly.ICalDataType;
import biweekly.util.XmlUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XCalElement {
    private final Element element;
    private final Document document;

    public XCalElement(Element element) {
        this.element = element;
        this.document = element.getOwnerDocument();
    }

    public String first(ICalDataType dataType) {
        String dataTypeStr = this.toLocalName(dataType);
        return this.first(dataTypeStr);
    }

    public String first(String localName) {
        for (Element child : this.children()) {
            if (!localName.equals(child.getLocalName()) || !"urn:ietf:params:xml:ns:icalendar-2.0".equals(child.getNamespaceURI())) continue;
            return child.getTextContent();
        }
        return null;
    }

    public List<String> all(ICalDataType dataType) {
        String dataTypeStr = this.toLocalName(dataType);
        return this.all(dataTypeStr);
    }

    public List<String> all(String localName) {
        ArrayList<String> childrenText = new ArrayList<String>();
        for (Element child : this.children()) {
            if (!localName.equals(child.getLocalName()) || !"urn:ietf:params:xml:ns:icalendar-2.0".equals(child.getNamespaceURI())) continue;
            String text = child.getTextContent();
            childrenText.add(text);
        }
        return childrenText;
    }

    public Element append(ICalDataType dataType, String value) {
        String dataTypeStr = this.toLocalName(dataType);
        return this.append(dataTypeStr, value);
    }

    public Element append(String name, String value) {
        Element child = this.document.createElementNS("urn:ietf:params:xml:ns:icalendar-2.0", name);
        child.setTextContent(value);
        this.element.appendChild(child);
        return child;
    }

    public XCalElement append(String name) {
        return new XCalElement(this.append(name, (String)null));
    }

    public XCalElement append(ICalDataType dataType) {
        return this.append(dataType.getName().toLowerCase());
    }

    public List<Element> append(String name, Collection<String> values) {
        ArrayList<Element> elements = new ArrayList<Element>(values.size());
        for (String value : values) {
            elements.add(this.append(name, value));
        }
        return elements;
    }

    public Document document() {
        return this.document;
    }

    public Element getElement() {
        return this.element;
    }

    private List<Element> children() {
        return XmlUtils.toElementList(this.element.getChildNodes());
    }

    public List<XCalElement> children(ICalDataType dataType) {
        String localName = dataType.getName().toLowerCase();
        ArrayList<XCalElement> children = new ArrayList<XCalElement>();
        for (Element child : this.children()) {
            if (!localName.equals(child.getLocalName()) || !"urn:ietf:params:xml:ns:icalendar-2.0".equals(child.getNamespaceURI())) continue;
            children.add(new XCalElement(child));
        }
        return children;
    }

    public XCalElement child(ICalDataType dataType) {
        String localName = dataType.getName().toLowerCase();
        for (Element child : this.children()) {
            if (!localName.equals(child.getLocalName()) || !"urn:ietf:params:xml:ns:icalendar-2.0".equals(child.getNamespaceURI())) continue;
            return new XCalElement(child);
        }
        return null;
    }

    private String toLocalName(ICalDataType dataType) {
        return dataType == null ? "unknown" : dataType.getName().toLowerCase();
    }
}

