/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.instructor.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.coursett.preference.PreferenceCombination;
import org.cpsolver.coursett.preference.SumPreferenceCombination;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.instructor.model.Attribute;
import org.cpsolver.instructor.model.Course;
import org.cpsolver.instructor.model.Instructor;
import org.cpsolver.instructor.model.InstructorSchedulingModel;
import org.cpsolver.instructor.model.Preference;
import org.cpsolver.instructor.model.Section;
import org.cpsolver.instructor.model.TeachingAssignment;

public class TeachingRequest {
    private long iRequestId;
    private Course iCourse;
    private float iLoad;
    private List<Section> iSections = new ArrayList<Section>();
    private List<Preference<Attribute>> iAttributePreferences = new ArrayList<Preference<Attribute>>();
    private List<Preference<Instructor>> iInstructorPreferences = new ArrayList<Preference<Instructor>>();
    private Variable[] iVariables;
    private int iSameCoursePreference;
    private int iSameCommonPreference;

    public TeachingRequest(long requestId, int nrVariables, Course course, float load, Collection<Section> sections, int sameCoursePreference, int sameCommonPreference) {
        this.iRequestId = requestId;
        this.iCourse = course;
        this.iLoad = load;
        this.iSections.addAll(sections);
        this.iVariables = new Variable[nrVariables];
        for (int i = 0; i < nrVariables; ++i) {
            this.iVariables[i] = new Variable(i);
        }
        this.iSameCoursePreference = sameCoursePreference;
        this.iSameCommonPreference = sameCommonPreference;
    }

    public long getRequestId() {
        return this.iRequestId;
    }

    public int getSameCoursePreference() {
        return this.iSameCoursePreference;
    }

    public boolean isSameCourseRequired() {
        return "R".equals(Constants.preferenceLevel2preference(this.iSameCoursePreference));
    }

    public boolean isSameCourseProhibited() {
        return "P".equals(Constants.preferenceLevel2preference(this.iSameCoursePreference));
    }

    public int getSameCommonPreference() {
        return this.iSameCommonPreference;
    }

    public boolean isSameCommonRequired() {
        return "R".equals(Constants.preferenceLevel2preference(this.iSameCommonPreference));
    }

    public boolean isSameCommonProhibited() {
        return "P".equals(Constants.preferenceLevel2preference(this.iSameCommonPreference));
    }

    public Variable[] getVariables() {
        return this.iVariables;
    }

    public Variable getVariable(int index) {
        return this.iVariables[index];
    }

    public int getNrInstructors() {
        return this.iVariables.length;
    }

    public List<Preference<Attribute>> getAttributePreferences() {
        return this.iAttributePreferences;
    }

    public void addAttributePreference(Preference<Attribute> pref) {
        this.iAttributePreferences.add(pref);
    }

    public int getAttributePreference(Instructor instructor, Attribute.Type type) {
        Set<Attribute> attributes = instructor.getAttributes(type);
        boolean hasReq = false;
        boolean hasPref = false;
        boolean needReq = false;
        boolean hasType = false;
        SumPreferenceCombination ret = new SumPreferenceCombination();
        for (Preference<Attribute> pref : this.iAttributePreferences) {
            if (!type.equals(pref.getTarget().getType())) continue;
            hasType = true;
            if (pref.isRequired()) {
                needReq = true;
            }
            if (attributes.contains(pref.getTarget())) {
                if (pref.isProhibited()) {
                    return 100;
                }
                if (pref.isRequired()) {
                    hasReq = true;
                } else {
                    ((PreferenceCombination)ret).addPreferenceInt(pref.getPreference());
                }
                hasPref = true;
                continue;
            }
            if (!pref.isRequired() || !type.isConjunctive()) continue;
            return 100;
        }
        if (needReq && !hasReq) {
            return 100;
        }
        if (type.isRequired() && hasType && !hasPref) {
            return 100;
        }
        if (!type.isRequired() && hasType && !hasPref) {
            return 16;
        }
        return ((PreferenceCombination)ret).getPreferenceInt();
    }

    public PreferenceCombination getAttributePreference(Instructor instructor) {
        SumPreferenceCombination preference = new SumPreferenceCombination();
        for (Attribute.Type type : ((InstructorSchedulingModel)this.getVariables()[0].getModel()).getAttributeTypes()) {
            ((PreferenceCombination)preference).addPreferenceInt(this.getAttributePreference(instructor, type));
        }
        return preference;
    }

    public List<Preference<Instructor>> getInstructorPreferences() {
        return this.iInstructorPreferences;
    }

    public void addInstructorPreference(Preference<Instructor> pref) {
        this.iInstructorPreferences.add(pref);
    }

    public Preference<Instructor> getInstructorPreference(Instructor instructor) {
        boolean hasRequired = false;
        for (Preference<Instructor> pref : this.iInstructorPreferences) {
            if (!pref.isRequired()) continue;
            hasRequired = true;
            break;
        }
        for (Preference<Instructor> pref : this.iInstructorPreferences) {
            if (!pref.getTarget().equals(instructor) || hasRequired && !pref.isRequired()) continue;
            return pref;
        }
        if (hasRequired) {
            return new Preference<Instructor>(instructor, 100);
        }
        return new Preference<Instructor>(instructor, 0);
    }

    public Course getCourse() {
        return this.iCourse;
    }

    public List<Section> getSections() {
        return this.iSections;
    }

    public float getLoad() {
        return this.iLoad;
    }

    public void setLoad(float load) {
        this.iLoad = load;
    }

    public String toString() {
        return this.iCourse.getCourseName() + " " + this.getSections();
    }

    public boolean sameCommon(TeachingRequest request) {
        for (Section section : this.getSections()) {
            if (!section.isCommon() || request.getSections().contains(section)) continue;
            return false;
        }
        for (Section section : request.getSections()) {
            if (!section.isCommon() || this.getSections().contains(section)) continue;
            return false;
        }
        return true;
    }

    public boolean shareCommon(TeachingRequest request) {
        for (Section section : this.getSections()) {
            if (!section.isCommon() || !request.getSections().contains(section)) continue;
            return true;
        }
        for (Section section : request.getSections()) {
            if (!section.isCommon() || !this.getSections().contains(section)) continue;
            return true;
        }
        return false;
    }

    public boolean isSameCommonViolated(TeachingRequest request) {
        if (!this.sameCourse(request)) {
            return false;
        }
        if ((this.isSameCommonRequired() || request.isSameCommonRequired()) && !this.sameCommon(request)) {
            return true;
        }
        return (this.isSameCommonProhibited() || request.isSameCommonProhibited()) && this.shareCommon(request);
    }

    public double getSameCommonPenalty(TeachingRequest request) {
        if (!this.sameCourse(request)) {
            return 0.0;
        }
        int penalty = 0;
        if ((this.getSameCommonPreference() < 0 || request.getSameCommonPreference() < 0) && this.sameCommon(request)) {
            penalty += (!this.isSameCommonRequired() && this.getSameCommonPreference() < 0 ? this.getSameCommonPreference() : 0) + (!request.isSameCommonRequired() && request.getSameCommonPreference() < 0 ? request.getSameCommonPreference() : 0);
        }
        if ((this.getSameCommonPreference() > 0 || request.getSameCommonPreference() > 0) && this.shareCommon(request)) {
            penalty += (this.getSameCommonPreference() > 0 ? this.getSameCommonPreference() : 0) + (request.getSameCommonPreference() > 0 ? request.getSameCommonPreference() : 0);
        }
        return penalty;
    }

    public double nrSameLectures(TeachingRequest request) {
        if (!this.sameCourse(request)) {
            return 0.0;
        }
        double same = 0.0;
        int common = 0;
        for (Section section : this.getSections()) {
            if (!section.isCommon()) continue;
            ++common;
            if (!request.getSections().contains(section)) continue;
            same += 1.0;
        }
        return common == 0 ? 1.0 : same / (double)common;
    }

    public boolean sameCourse(TeachingRequest request) {
        return this.getCourse().equals(request.getCourse());
    }

    public boolean isSameCourseViolated(TeachingRequest request) {
        if (this.sameCourse(request)) {
            return this.isSameCourseProhibited() || request.isSameCourseProhibited();
        }
        return this.isSameCourseRequired() || request.isSameCourseRequired();
    }

    public double getSameCoursePenalty(TeachingRequest request) {
        if (!this.sameCourse(request)) {
            return 0.0;
        }
        return (this.isSameCourseRequired() ? 0 : this.getSameCoursePreference()) + (request.isSameCourseRequired() ? 0 : request.getSameCoursePreference());
    }

    public boolean overlaps(TeachingRequest request) {
        for (Section section : this.getSections()) {
            if (section.isAllowOverlap() || section.getTime() == null || request.getSections().contains(section)) continue;
            for (Section other : request.getSections()) {
                if (other.isAllowOverlap() || other.getTime() == null || this.getSections().contains(other) || !section.getTime().hasIntersection(other.getTime())) continue;
                return true;
            }
        }
        return false;
    }

    public int share(TeachingRequest request) {
        int ret = 0;
        for (Section section : this.getSections()) {
            ret += section.share(request.getSections());
        }
        return ret;
    }

    public int share(TimeLocation time) {
        int ret = 0;
        for (Section section : this.getSections()) {
            ret += section.share(time);
        }
        return ret;
    }

    public double countBackToBacks(TeachingRequest request, double diffRoomWeight, double diffTypeWeight) {
        double b2b = 0.0;
        int count = 0;
        for (Section section : this.getSections()) {
            if (section.isCommon() && this.sameCourse(request) && request.getSections().contains(section)) continue;
            b2b += section.countBackToBacks(request.getSections(), diffRoomWeight, diffTypeWeight);
            ++count;
        }
        return count == 0 ? 0.0 : b2b / (double)count;
    }

    public double countSameDays(TeachingRequest request, double diffRoomWeight, double diffTypeWeight) {
        double sd = 0.0;
        int count = 0;
        for (Section section : this.getSections()) {
            if (section.isCommon() && this.sameCourse(request) && request.getSections().contains(section)) continue;
            sd += section.countSameDays(request.getSections(), diffRoomWeight, diffTypeWeight);
            ++count;
        }
        return count == 0 ? 0.0 : sd / (double)count;
    }

    public double countSameRooms(TeachingRequest request, double diffTypeWeight) {
        double sr = 0.0;
        int count = 0;
        for (Section section : this.getSections()) {
            if (section.isCommon() && this.sameCourse(request) && request.getSections().contains(section)) continue;
            sr += section.countSameRooms(request.getSections(), diffTypeWeight);
            ++count;
        }
        return count == 0 ? 0.0 : sr / (double)count;
    }

    public int hashCode() {
        return (int)(this.iRequestId ^ this.iRequestId >>> 32);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof TeachingRequest)) {
            return false;
        }
        TeachingRequest tr = (TeachingRequest)o;
        return this.getRequestId() == tr.getRequestId();
    }

    public class Variable
    extends org.cpsolver.ifs.model.Variable<Variable, TeachingAssignment> {
        private int iIndex;

        public Variable(int index) {
            this.iId = (TeachingRequest.this.iRequestId << 8) + (long)index;
            this.iIndex = index;
        }

        public int getInstructorIndex() {
            return this.iIndex;
        }

        public TeachingRequest getRequest() {
            return TeachingRequest.this;
        }

        public Course getCourse() {
            return TeachingRequest.this.iCourse;
        }

        public List<Section> getSections() {
            return TeachingRequest.this.iSections;
        }

        @Override
        public List<TeachingAssignment> values(Assignment<Variable, TeachingAssignment> assignment) {
            List<TeachingAssignment> values = super.values(assignment);
            if (values == null) {
                values = new ArrayList<TeachingAssignment>();
                for (Instructor instructor : ((InstructorSchedulingModel)this.getModel()).getInstructors()) {
                    PreferenceCombination attributePref;
                    if (!instructor.canTeach(this.getRequest()) || (attributePref = TeachingRequest.this.getAttributePreference(instructor)).isProhibited()) continue;
                    values.add(new TeachingAssignment(this, instructor, attributePref.getPreferenceInt()));
                }
                this.setValues(values);
            }
            return values;
        }

        @Override
        public void variableAssigned(Assignment<Variable, TeachingAssignment> assignment, long iteration, TeachingAssignment ta) {
            super.variableAssigned(assignment, iteration, ta);
            ((Instructor.Context)ta.getInstructor().getContext(assignment)).assigned(assignment, ta);
        }

        @Override
        public void variableUnassigned(Assignment<Variable, TeachingAssignment> assignment, long iteration, TeachingAssignment ta) {
            super.variableUnassigned(assignment, iteration, ta);
            ((Instructor.Context)ta.getInstructor().getContext(assignment)).unassigned(assignment, ta);
        }

        @Override
        public int hashCode() {
            return new Long(TeachingRequest.this.iRequestId << 8 + this.iIndex).hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (o == null || !(o instanceof Variable)) {
                return false;
            }
            Variable tr = (Variable)o;
            return this.getRequest().getRequestId() == tr.getRequest().getRequestId() && this.getInstructorIndex() == tr.getInstructorIndex();
        }

        @Override
        public String getName() {
            return TeachingRequest.this.iCourse.getCourseName() + (TeachingRequest.this.getNrInstructors() > 1 ? "[" + this.getInstructorIndex() + "]" : "") + " " + this.getSections();
        }
    }
}

