/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.cpsolver.coursett.IdConvertor;
import org.cpsolver.exam.criteria.DistributionPenalty;
import org.cpsolver.exam.criteria.ExamCriterion;
import org.cpsolver.exam.criteria.ExamRotationPenalty;
import org.cpsolver.exam.criteria.InstructorBackToBackConflicts;
import org.cpsolver.exam.criteria.InstructorDirectConflicts;
import org.cpsolver.exam.criteria.InstructorDistanceBackToBackConflicts;
import org.cpsolver.exam.criteria.InstructorMoreThan2ADayConflicts;
import org.cpsolver.exam.criteria.InstructorNotAvailableConflicts;
import org.cpsolver.exam.criteria.LargeExamsPenalty;
import org.cpsolver.exam.criteria.PeriodIndexPenalty;
import org.cpsolver.exam.criteria.PeriodPenalty;
import org.cpsolver.exam.criteria.PeriodSizePenalty;
import org.cpsolver.exam.criteria.PerturbationPenalty;
import org.cpsolver.exam.criteria.RoomPenalty;
import org.cpsolver.exam.criteria.RoomPerturbationPenalty;
import org.cpsolver.exam.criteria.RoomSizePenalty;
import org.cpsolver.exam.criteria.RoomSplitDistancePenalty;
import org.cpsolver.exam.criteria.RoomSplitPenalty;
import org.cpsolver.exam.criteria.StudentBackToBackConflicts;
import org.cpsolver.exam.criteria.StudentDirectConflicts;
import org.cpsolver.exam.criteria.StudentDistanceBackToBackConflicts;
import org.cpsolver.exam.criteria.StudentMoreThan2ADayConflicts;
import org.cpsolver.exam.criteria.StudentNotAvailableConflicts;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamContext;
import org.cpsolver.exam.model.ExamDistributionConstraint;
import org.cpsolver.exam.model.ExamInstructor;
import org.cpsolver.exam.model.ExamOwner;
import org.cpsolver.exam.model.ExamPeriod;
import org.cpsolver.exam.model.ExamPeriodPlacement;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.exam.model.ExamRoom;
import org.cpsolver.exam.model.ExamRoomPlacement;
import org.cpsolver.exam.model.ExamRoomSharing;
import org.cpsolver.exam.model.ExamStudent;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.context.ModelWithContext;
import org.cpsolver.ifs.criteria.Criterion;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.util.Callback;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.DistanceMetric;
import org.cpsolver.ifs.util.ToolBox;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class ExamModel
extends ModelWithContext<Exam, ExamPlacement, ExamContext> {
    private static Logger sLog = Logger.getLogger(ExamModel.class);
    private DataProperties iProperties = null;
    private int iMaxRooms = 4;
    private List<ExamPeriod> iPeriods = new ArrayList<ExamPeriod>();
    private List<ExamRoom> iRooms = new ArrayList<ExamRoom>();
    private List<ExamStudent> iStudents = new ArrayList<ExamStudent>();
    private List<ExamDistributionConstraint> iDistributionConstraints = new ArrayList<ExamDistributionConstraint>();
    private List<ExamInstructor> iInstructors = new ArrayList<ExamInstructor>();
    private ExamRoomSharing iRoomSharing = null;
    private DistanceMetric iDistanceMetric = null;

    public ExamModel(DataProperties properties) {
        this.iProperties = properties;
        this.iMaxRooms = properties.getPropertyInt("Exams.MaxRooms", this.iMaxRooms);
        this.iDistanceMetric = new DistanceMetric(properties);
        String roomSharingClass = properties.getProperty("Exams.RoomSharingClass");
        if (roomSharingClass != null) {
            try {
                this.iRoomSharing = (ExamRoomSharing)Class.forName(roomSharingClass).getConstructor(Model.class, DataProperties.class).newInstance(this, properties);
            }
            catch (Exception e) {
                sLog.error("Failed to instantiate room sharing class " + roomSharingClass + ", reason: " + e.getMessage());
            }
        }
        String criteria = properties.getProperty("Exams.Criteria", StudentDirectConflicts.class.getName() + ";" + StudentNotAvailableConflicts.class.getName() + ";" + StudentBackToBackConflicts.class.getName() + ";" + StudentDistanceBackToBackConflicts.class.getName() + ";" + StudentMoreThan2ADayConflicts.class.getName() + ";" + InstructorDirectConflicts.class.getName() + ";" + InstructorNotAvailableConflicts.class.getName() + ";" + InstructorBackToBackConflicts.class.getName() + ";" + InstructorDistanceBackToBackConflicts.class.getName() + ";" + InstructorMoreThan2ADayConflicts.class.getName() + ";" + PeriodPenalty.class.getName() + ";" + RoomPenalty.class.getName() + ";" + DistributionPenalty.class.getName() + ";" + RoomSplitPenalty.class.getName() + ";" + RoomSplitDistancePenalty.class.getName() + ";" + RoomSizePenalty.class.getName() + ";" + ExamRotationPenalty.class.getName() + ";" + LargeExamsPenalty.class.getName() + ";" + PeriodSizePenalty.class.getName() + ";" + PeriodIndexPenalty.class.getName() + ";" + PerturbationPenalty.class.getName() + ";" + RoomPerturbationPenalty.class.getName() + ";");
        criteria = criteria + ";" + properties.getProperty("Exams.AdditionalCriteria", "");
        for (String criterion : criteria.split("\\;")) {
            if (criterion == null || criterion.isEmpty()) continue;
            try {
                Class<?> clazz = Class.forName(criterion);
                this.addCriterion((Criterion)clazz.newInstance());
            }
            catch (Exception e) {
                sLog.error("Unable to use " + criterion + ": " + e.getMessage());
            }
        }
    }

    public DistanceMetric getDistanceMetric() {
        return this.iDistanceMetric;
    }

    public boolean hasRoomSharing() {
        return this.iRoomSharing != null;
    }

    public ExamRoomSharing getRoomSharing() {
        return this.iRoomSharing;
    }

    public void setRoomSharing(ExamRoomSharing sharing) {
        this.iRoomSharing = sharing;
    }

    public void init() {
        for (Exam exam : this.variables()) {
            for (ExamRoomPlacement room : exam.getRoomPlacements()) {
                room.getRoom().addVariable(exam);
            }
        }
    }

    public int getMaxRooms() {
        return this.iMaxRooms;
    }

    public void setMaxRooms(int maxRooms) {
        this.iMaxRooms = maxRooms;
    }

    public ExamPeriod addPeriod(Long id, String day, String time, int length, int penalty) {
        ExamPeriod lastPeriod = this.iPeriods.isEmpty() ? null : this.iPeriods.get(this.iPeriods.size() - 1);
        ExamPeriod p = new ExamPeriod(id, day, time, length, penalty);
        if (lastPeriod == null) {
            p.setIndex(this.iPeriods.size(), 0, 0);
        } else if (lastPeriod.getDayStr().equals(day)) {
            p.setIndex(this.iPeriods.size(), lastPeriod.getDay(), lastPeriod.getTime() + 1);
        } else {
            p.setIndex(this.iPeriods.size(), lastPeriod.getDay() + 1, 0);
        }
        if (lastPeriod != null) {
            lastPeriod.setNext(p);
            p.setPrev(lastPeriod);
        }
        this.iPeriods.add(p);
        return p;
    }

    public int getNrDays() {
        return this.iPeriods.get(this.iPeriods.size() - 1).getDay() + 1;
    }

    public int getNrPeriods() {
        return this.iPeriods.size();
    }

    public List<ExamPeriod> getPeriods() {
        return this.iPeriods;
    }

    public ExamPeriod getPeriod(Long id) {
        for (ExamPeriod period : this.iPeriods) {
            if (!period.getId().equals(id)) continue;
            return period;
        }
        return null;
    }

    public boolean isDayBreakBackToBack() {
        return ((StudentBackToBackConflicts)this.getCriterion(StudentBackToBackConflicts.class)).isDayBreakBackToBack();
    }

    public double getBackToBackDistance() {
        return ((StudentDistanceBackToBackConflicts)this.getCriterion(StudentDistanceBackToBackConflicts.class)).getBackToBackDistance();
    }

    @Override
    public double getTotalValue(Assignment<Exam, ExamPlacement> assignment) {
        double total = 0.0;
        for (Criterion<Exam, ExamPlacement> criterion : this.getCriteria()) {
            total += criterion.getWeightedValue(assignment);
        }
        return total;
    }

    public double[] getTotalMultiValue(Assignment<Exam, ExamPlacement> assignment) {
        double[] total = new double[this.getCriteria().size()];
        int i = 0;
        for (Criterion<Exam, ExamPlacement> criterion : this.getCriteria()) {
            total[i++] = criterion.getWeightedValue(assignment);
        }
        return total;
    }

    @Override
    public String toString(Assignment<Exam, ExamPlacement> assignment) {
        TreeSet<String> props = new TreeSet<String>();
        for (Criterion criterion : this.getCriteria()) {
            String val = ((ExamCriterion)criterion).toString(assignment);
            if (val.isEmpty()) continue;
            props.add(val);
        }
        return ((Object)props).toString();
    }

    @Override
    public Map<String, String> getExtendedInfo(Assignment<Exam, ExamPlacement> assignment) {
        Map<String, String> info = super.getExtendedInfo(assignment);
        info.put("Number of Periods", String.valueOf(this.getPeriods().size()));
        info.put("Number of Exams", String.valueOf(this.variables().size()));
        info.put("Number of Rooms", String.valueOf(this.getRooms().size()));
        info.put("Number of Students", String.valueOf(this.getStudents().size()));
        int nrStudentExams = 0;
        for (ExamStudent student : this.getStudents()) {
            nrStudentExams += student.getOwners().size();
        }
        info.put("Number of Student Exams", String.valueOf(nrStudentExams));
        int nrAltExams = 0;
        int nrSmallExams = 0;
        for (Exam exam : this.variables()) {
            if (exam.hasAltSeating()) {
                ++nrAltExams;
            }
            if (exam.getMaxRooms() != 0) continue;
            ++nrSmallExams;
        }
        info.put("Number of Exams Requiring Alt Seating", String.valueOf(nrAltExams));
        info.put("Number of Small Exams (Exams W/O Room)", String.valueOf(nrSmallExams));
        int[] nbrMtgs = new int[11];
        for (int i = 0; i <= 10; ++i) {
            nbrMtgs[i] = 0;
        }
        for (ExamStudent student : this.getStudents()) {
            int n = Math.min(10, student.variables().size());
            nbrMtgs[n] = nbrMtgs[n] + 1;
        }
        for (int i = 0; i <= 10; ++i) {
            if (nbrMtgs[i] == 0) continue;
            info.put("Number of Students with " + (i == 0 ? "no" : String.valueOf(i)) + (i == 10 ? " or more" : "") + " meeting" + (i != 1 ? "s" : ""), String.valueOf(nbrMtgs[i]));
        }
        HashMap<Integer, Integer> penalty2count = new HashMap<Integer, Integer>();
        for (Exam exam : this.variables()) {
            Integer preference;
            ExamPlacement placement = assignment.getValue(exam);
            if (placement == null) continue;
            Integer count = (Integer)penalty2count.get(preference = Integer.valueOf(placement.getPeriodPlacement().getExamPenalty()));
            penalty2count.put(preference, 1 + (count == null ? 0 : count));
        }
        if (!penalty2count.isEmpty()) {
            String value = null;
            for (Integer penalty : new TreeSet(penalty2count.keySet())) {
                if (penalty == 0) continue;
                value = (value == null ? "" : value + ", ") + penalty2count.get(penalty) + "&times; " + penalty;
            }
            if (value != null) {
                info.put("Period Preferences", value);
            }
        }
        return info;
    }

    public DataProperties getProperties() {
        return this.iProperties;
    }

    public List<ExamRoom> getRooms() {
        return this.iRooms;
    }

    public List<ExamStudent> getStudents() {
        return this.iStudents;
    }

    public List<ExamInstructor> getInstructors() {
        return this.iInstructors;
    }

    public List<ExamDistributionConstraint> getDistributionConstraints() {
        return this.iDistributionConstraints;
    }

    private String getId(boolean anonymize, String type, String id) {
        return anonymize ? IdConvertor.getInstance().convert(type, id) : id;
    }

    /*
     * WARNING - void declaration
     */
    public Document save(Assignment<Exam, ExamPlacement> assignment) {
        boolean saveInitial = this.getProperties().getPropertyBoolean("Xml.SaveInitial", true);
        boolean saveBest = this.getProperties().getPropertyBoolean("Xml.SaveBest", true);
        boolean saveSolution = this.getProperties().getPropertyBoolean("Xml.SaveSolution", true);
        boolean saveConflictTable = this.getProperties().getPropertyBoolean("Xml.SaveConflictTable", false);
        boolean saveParams = this.getProperties().getPropertyBoolean("Xml.SaveParameters", true);
        boolean anonymize = this.getProperties().getPropertyBoolean("Xml.Anonymize", false);
        boolean idconv = this.getProperties().getPropertyBoolean("Xml.ConvertIds", anonymize);
        Document document = DocumentHelper.createDocument();
        document.addComment("Examination Timetable");
        if (assignment != null && assignment.nrAssignedVariables() > 0) {
            StringBuffer comments = new StringBuffer("Solution Info:\n");
            Map<String, String> solutionInfo = this.getProperties().getPropertyBoolean("Xml.ExtendedInfo", false) ? this.getExtendedInfo(assignment) : this.getInfo(assignment);
            for (String string : new TreeSet<String>(solutionInfo.keySet())) {
                String value = solutionInfo.get(string);
                comments.append("    " + string + ": " + value + "\n");
            }
            document.addComment(comments.toString());
        }
        Element root = document.addElement("examtt");
        root.addAttribute("version", "1.0");
        root.addAttribute("campus", this.getProperties().getProperty("Data.Initiative"));
        root.addAttribute("term", this.getProperties().getProperty("Data.Term"));
        root.addAttribute("year", this.getProperties().getProperty("Data.Year"));
        root.addAttribute("created", String.valueOf(new Date()));
        if (saveParams) {
            HashMap<String, String> params = new HashMap<String, String>();
            for (Criterion criterion : this.getCriteria()) {
                if (!(criterion instanceof ExamCriterion)) continue;
                ((ExamCriterion)criterion).getXmlParameters(params);
            }
            params.put("maxRooms", String.valueOf(this.getMaxRooms()));
            Element parameters = root.addElement("parameters");
            for (String key : new TreeSet(params.keySet())) {
                parameters.addElement("property").addAttribute("name", key).addAttribute("value", (String)params.get(key));
            }
        }
        Element periods = root.addElement("periods");
        for (ExamPeriod examPeriod : this.getPeriods()) {
            periods.addElement("period").addAttribute("id", this.getId(idconv, "period", String.valueOf(examPeriod.getId()))).addAttribute("length", String.valueOf(examPeriod.getLength())).addAttribute("day", examPeriod.getDayStr()).addAttribute("time", examPeriod.getTimeStr()).addAttribute("penalty", String.valueOf(examPeriod.getPenalty()));
        }
        Element rooms = root.addElement("rooms");
        for (ExamRoom room : this.getRooms()) {
            Element r = rooms.addElement("room");
            r.addAttribute("id", this.getId(idconv, "room", String.valueOf(room.getId())));
            if (!anonymize && room.hasName()) {
                r.addAttribute("name", room.getName());
            }
            r.addAttribute("size", String.valueOf(room.getSize()));
            r.addAttribute("alt", String.valueOf(room.getAltSize()));
            if (room.getCoordX() != null && room.getCoordY() != null) {
                r.addAttribute("coordinates", room.getCoordX() + "," + room.getCoordY());
            }
            for (ExamPeriod period : this.getPeriods()) {
                if (!room.isAvailable(period)) {
                    r.addElement("period").addAttribute("id", this.getId(idconv, "period", String.valueOf(period.getId()))).addAttribute("available", "false");
                    continue;
                }
                if (room.getPenalty(period) == 0) continue;
                r.addElement("period").addAttribute("id", this.getId(idconv, "period", String.valueOf(period.getId()))).addAttribute("penalty", String.valueOf(room.getPenalty(period)));
            }
            Map<Long, Integer> travelTimes = this.getDistanceMetric().getTravelTimes().get(room.getId());
            if (travelTimes == null) continue;
            for (Map.Entry entry : travelTimes.entrySet()) {
                r.addElement("travel-time").addAttribute("id", this.getId(idconv, "room", ((Long)entry.getKey()).toString())).addAttribute("minutes", ((Integer)entry.getValue()).toString());
            }
        }
        Element element = root.addElement("exams");
        for (Exam exam : this.variables()) {
            ExamPlacement p;
            Element ex = element.addElement("exam");
            ex.addAttribute("id", this.getId(idconv, "exam", String.valueOf(exam.getId())));
            if (!anonymize && exam.hasName()) {
                ex.addAttribute("name", exam.getName());
            }
            ex.addAttribute("length", String.valueOf(exam.getLength()));
            if (exam.getSizeOverride() != null) {
                ex.addAttribute("size", exam.getSizeOverride().toString());
            }
            if (exam.getMinSize() != 0) {
                ex.addAttribute("minSize", String.valueOf(exam.getMinSize()));
            }
            ex.addAttribute("alt", exam.hasAltSeating() ? "true" : "false");
            if (exam.getMaxRooms() != this.getMaxRooms()) {
                ex.addAttribute("maxRooms", String.valueOf(exam.getMaxRooms()));
            }
            if (exam.getPrintOffset() != null && !anonymize) {
                ex.addAttribute("printOffset", exam.getPrintOffset().toString());
            }
            if (!anonymize) {
                ex.addAttribute("enrl", String.valueOf(exam.getStudents().size()));
            }
            if (!anonymize) {
                for (ExamOwner examOwner : exam.getOwners()) {
                    Element o = ex.addElement("owner");
                    o.addAttribute("id", this.getId(idconv, "owner", String.valueOf(examOwner.getId())));
                    o.addAttribute("name", examOwner.getName());
                }
            }
            for (ExamPeriodPlacement examPeriodPlacement : exam.getPeriodPlacements()) {
                Element pe = ex.addElement("period").addAttribute("id", this.getId(idconv, "period", String.valueOf(examPeriodPlacement.getId())));
                int penalty = examPeriodPlacement.getExamPenalty();
                if (penalty == 0) continue;
                pe.addAttribute("penalty", String.valueOf(penalty));
            }
            for (ExamRoomPlacement examRoomPlacement : exam.getRoomPlacements()) {
                Element re = ex.addElement("room").addAttribute("id", this.getId(idconv, "room", String.valueOf(examRoomPlacement.getId())));
                if (examRoomPlacement.getPenalty() != 0) {
                    re.addAttribute("penalty", String.valueOf(examRoomPlacement.getPenalty()));
                }
                if (examRoomPlacement.getMaxPenalty() == 100) continue;
                re.addAttribute("maxPenalty", String.valueOf(examRoomPlacement.getMaxPenalty()));
            }
            if (exam.hasAveragePeriod()) {
                ex.addAttribute("average", String.valueOf(exam.getAveragePeriod()));
            }
            ExamPlacement examPlacement = p = assignment == null ? null : assignment.getValue(exam);
            if (p != null && saveSolution) {
                Element element2 = ex.addElement("assignment");
                element2.addElement("period").addAttribute("id", this.getId(idconv, "period", String.valueOf(p.getPeriod().getId())));
                for (ExamRoomPlacement r : p.getRoomPlacements()) {
                    element2.addElement("room").addAttribute("id", this.getId(idconv, "room", String.valueOf(r.getId())));
                }
            }
            if ((p = (ExamPlacement)exam.getInitialAssignment()) != null && saveInitial) {
                Element element3 = ex.addElement("initial");
                element3.addElement("period").addAttribute("id", this.getId(idconv, "period", String.valueOf(p.getPeriod().getId())));
                for (ExamRoomPlacement r : p.getRoomPlacements()) {
                    element3.addElement("room").addAttribute("id", this.getId(idconv, "room", String.valueOf(r.getId())));
                }
            }
            if ((p = (ExamPlacement)exam.getBestAssignment()) != null && saveBest) {
                Element element4 = ex.addElement("best");
                element4.addElement("period").addAttribute("id", this.getId(idconv, "period", String.valueOf(p.getPeriod().getId())));
                for (ExamRoomPlacement r : p.getRoomPlacements()) {
                    element4.addElement("room").addAttribute("id", this.getId(idconv, "room", String.valueOf(r.getId())));
                }
            }
            if (this.iRoomSharing == null) continue;
            this.iRoomSharing.save(exam, ex, anonymize ? IdConvertor.getInstance() : null);
        }
        Element students = root.addElement("students");
        for (ExamStudent student : this.getStudents()) {
            Element s = students.addElement("student");
            s.addAttribute("id", this.getId(idconv, "student", String.valueOf(student.getId())));
            for (Exam ex : student.variables()) {
                Element x = s.addElement("exam").addAttribute("id", this.getId(idconv, "exam", String.valueOf(ex.getId())));
                if (anonymize) continue;
                for (ExamOwner owner : ex.getOwners(student)) {
                    x.addElement("owner").addAttribute("id", this.getId(idconv, "owner", String.valueOf(owner.getId())));
                }
            }
            for (ExamPeriod period : this.getPeriods()) {
                if (student.isAvailable(period)) continue;
                s.addElement("period").addAttribute("id", this.getId(idconv, "period", String.valueOf(period.getId()))).addAttribute("available", "false");
            }
        }
        Element instructors = root.addElement("instructors");
        for (ExamInstructor instructor : this.getInstructors()) {
            Element element5 = instructors.addElement("instructor");
            element5.addAttribute("id", this.getId(idconv, "instructor", String.valueOf(instructor.getId())));
            if (!anonymize && instructor.hasName()) {
                element5.addAttribute("name", instructor.getName());
            }
            for (Exam ex : instructor.variables()) {
                Element x = element5.addElement("exam").addAttribute("id", this.getId(idconv, "exam", String.valueOf(ex.getId())));
                if (anonymize) continue;
                for (ExamOwner owner : ex.getOwners(instructor)) {
                    x.addElement("owner").addAttribute("id", this.getId(idconv, "owner", String.valueOf(owner.getId())));
                }
            }
            for (ExamPeriod period : this.getPeriods()) {
                if (instructor.isAvailable(period)) continue;
                element5.addElement("period").addAttribute("id", this.getId(idconv, "period", String.valueOf(period.getId()))).addAttribute("available", "false");
            }
        }
        Element distConstraints = root.addElement("constraints");
        for (ExamDistributionConstraint examDistributionConstraint : this.getDistributionConstraints()) {
            Element dc = distConstraints.addElement(examDistributionConstraint.getTypeString());
            dc.addAttribute("id", this.getId(idconv, "constraint", String.valueOf(examDistributionConstraint.getId())));
            if (!examDistributionConstraint.isHard()) {
                dc.addAttribute("hard", "false");
                dc.addAttribute("weight", String.valueOf(examDistributionConstraint.getWeight()));
            }
            for (Exam exam : examDistributionConstraint.variables()) {
                dc.addElement("exam").addAttribute("id", this.getId(idconv, "exam", String.valueOf(exam.getId())));
            }
        }
        if (saveConflictTable && assignment != null) {
            Element conflicts = root.addElement("conflicts");
            Object var18_41 = null;
            for (ExamPeriod period : this.getPeriods()) {
                Map<ExamStudent, Set<Exam>> studentsOfPeriod = this.getStudentsOfPeriod(assignment, period);
                for (Map.Entry<ExamStudent, Set<Exam>> entry : studentsOfPeriod.entrySet()) {
                    Set previousExamsOfStudent;
                    void var18_42;
                    ExamStudent student = entry.getKey();
                    Set<Exam> examsOfStudent = entry.getValue();
                    if (examsOfStudent.size() > 1) {
                        Element dir = conflicts.addElement("direct").addAttribute("student", this.getId(idconv, "student", String.valueOf(student.getId())));
                        for (Exam exam : examsOfStudent) {
                            dir.addElement("exam").addAttribute("id", this.getId(idconv, "exam", String.valueOf(exam.getId())));
                        }
                    }
                    if (examsOfStudent.size() <= 0 || var18_42 == null || !this.isDayBreakBackToBack() && period.prev().getDay() != period.getDay() || (previousExamsOfStudent = (Set)var18_42.get(student)) == null) continue;
                    for (Exam ex1 : previousExamsOfStudent) {
                        for (Exam ex2 : examsOfStudent) {
                            double dist;
                            Element btb = conflicts.addElement("back-to-back").addAttribute("student", this.getId(idconv, "student", String.valueOf(student.getId())));
                            btb.addElement("exam").addAttribute("id", this.getId(idconv, "exam", String.valueOf(ex1.getId())));
                            btb.addElement("exam").addAttribute("id", this.getId(idconv, "exam", String.valueOf(ex2.getId())));
                            if (!(this.getBackToBackDistance() >= 0.0) || period.prev().getDay() != period.getDay() || !((dist = assignment.getValue(ex1).getDistanceInMeters(assignment.getValue(ex2))) > 0.0)) continue;
                            btb.addAttribute("distance", String.valueOf(dist));
                        }
                    }
                }
                if (period.next() == null || period.next().getDay() != period.getDay()) {
                    Map<ExamStudent, Set<Exam>> studentsOfDay = this.getStudentsOfDay(assignment, period);
                    for (Map.Entry<ExamStudent, Set<Exam>> entry : studentsOfDay.entrySet()) {
                        ExamStudent student = entry.getKey();
                        Set<Exam> examsOfStudent = entry.getValue();
                        if (examsOfStudent.size() <= 2) continue;
                        Element mt2 = conflicts.addElement("more-2-day").addAttribute("student", this.getId(idconv, "student", String.valueOf(student.getId())));
                        for (Exam exam : examsOfStudent) {
                            mt2.addElement("exam").addAttribute("id", this.getId(idconv, "exam", String.valueOf(exam.getId())));
                        }
                    }
                }
                Map<ExamStudent, Set<Exam>> map = studentsOfPeriod;
            }
        }
        return document;
    }

    public boolean load(Document document, Assignment<Exam, ExamPlacement> assignment) {
        return this.load(document, assignment, null);
    }

    /*
     * WARNING - void declaration
     */
    public boolean load(Document document, Assignment<Exam, ExamPlacement> assignment, Callback saveBest) {
        ExamPeriod period;
        String available;
        ExamOwner owner;
        Element f;
        Iterator k;
        Element x;
        Iterator j;
        Element e;
        Iterator j2;
        boolean loadInitial = this.getProperties().getPropertyBoolean("Xml.LoadInitial", true);
        boolean loadBest = this.getProperties().getPropertyBoolean("Xml.LoadBest", true);
        boolean loadSolution = this.getProperties().getPropertyBoolean("Xml.LoadSolution", true);
        boolean loadParams = this.getProperties().getPropertyBoolean("Xml.LoadParameters", false);
        Integer softPeriods = this.getProperties().getPropertyInteger("Exam.SoftPeriods", null);
        Integer softRooms = this.getProperties().getPropertyInteger("Exam.SoftRooms", null);
        Integer softDistributions = this.getProperties().getPropertyInteger("Exam.SoftDistributions", null);
        Element root = document.getRootElement();
        if (!"examtt".equals(root.getName())) {
            return false;
        }
        if (root.attribute("campus") != null) {
            this.getProperties().setProperty("Data.Campus", root.attributeValue("campus"));
        } else if (root.attribute("initiative") != null) {
            this.getProperties().setProperty("Data.Initiative", root.attributeValue("initiative"));
        }
        if (root.attribute("term") != null) {
            this.getProperties().setProperty("Data.Term", root.attributeValue("term"));
        }
        if (root.attribute("year") != null) {
            this.getProperties().setProperty("Data.Year", root.attributeValue("year"));
        }
        if (loadParams && root.element("parameters") != null) {
            HashMap<String, String> params = new HashMap<String, String>();
            Iterator i = root.element("parameters").elementIterator("property");
            while (i.hasNext()) {
                Element e2 = (Element)i.next();
                params.put(e2.attributeValue("name"), e2.attributeValue("value"));
            }
            for (Criterion criterion : this.getCriteria()) {
                if (!(criterion instanceof ExamCriterion)) continue;
                ((ExamCriterion)criterion).setXmlParameters(params);
            }
            try {
                this.setMaxRooms(Integer.valueOf((String)params.get("maxRooms")));
            }
            catch (NumberFormatException i$) {
            }
            catch (NullPointerException i$) {
                // empty catch block
            }
        }
        Iterator i = root.element("periods").elementIterator("period");
        while (i.hasNext()) {
            Element e3 = (Element)i.next();
            this.addPeriod(Long.valueOf(e3.attributeValue("id")), e3.attributeValue("day"), e3.attributeValue("time"), Integer.parseInt(e3.attributeValue("length")), Integer.parseInt(e3.attributeValue("penalty") == null ? e3.attributeValue("weight", "0") : e3.attributeValue("penalty")));
        }
        HashMap<Long, ExamRoom> rooms = new HashMap<Long, ExamRoom>();
        HashMap roomGroups = new HashMap();
        Iterator i2 = root.element("rooms").elementIterator("room");
        while (i2.hasNext()) {
            String g;
            Element e4 = (Element)i2.next();
            String coords = e4.attributeValue("coordinates");
            ExamRoom room = new ExamRoom(this, Long.parseLong(e4.attributeValue("id")), e4.attributeValue("name"), Integer.parseInt(e4.attributeValue("size")), Integer.parseInt(e4.attributeValue("alt")), coords == null ? null : Double.valueOf(coords.substring(0, coords.indexOf(44))), coords == null ? null : Double.valueOf(coords.substring(coords.indexOf(44) + 1)));
            this.addConstraint(room);
            this.getRooms().add(room);
            rooms.put(new Long(room.getId()), room);
            Iterator j3 = e4.elementIterator("period");
            while (j3.hasNext()) {
                Element pe2 = (Element)j3.next();
                ExamPeriod period2 = this.getPeriod(Long.valueOf(pe2.attributeValue("id")));
                if (period2 == null) continue;
                if ("false".equals(pe2.attributeValue("available"))) {
                    if (softRooms == null) {
                        room.setAvailable(period2, false);
                        continue;
                    }
                    room.setPenalty(period2, (int)softRooms);
                    continue;
                }
                room.setPenalty(period2, Integer.parseInt(pe2.attributeValue("penalty")));
            }
            String av = e4.attributeValue("available");
            if (av != null) {
                for (int j4 = 0; j4 < this.getPeriods().size(); ++j4) {
                    if ('0' != av.charAt(j4)) continue;
                    room.setAvailable(this.getPeriods().get(j4), false);
                }
            }
            if ((g = e4.attributeValue("groups")) != null) {
                StringTokenizer s = new StringTokenizer(g, ",");
                while (s.hasMoreTokens()) {
                    void var22_26;
                    String gr = s.nextToken();
                    ArrayList arrayList = (ArrayList)roomGroups.get(gr);
                    if (arrayList == null) {
                        ArrayList arrayList2 = new ArrayList();
                        roomGroups.put(gr, arrayList2);
                    }
                    var22_26.add(room);
                }
            }
            j2 = e4.elementIterator("travel-time");
            while (j2.hasNext()) {
                Element travelTimeEl = (Element)j2.next();
                this.getDistanceMetric().addTravelTime(room.getId(), Long.valueOf(travelTimeEl.attributeValue("id")), Integer.valueOf(travelTimeEl.attributeValue("minutes")));
            }
        }
        ArrayList<ExamPlacement> assignments = new ArrayList<ExamPlacement>();
        HashMap<Long, Exam> exams = new HashMap<Long, Exam>();
        HashMap<Long, ExamOwner> courseSections = new HashMap<Long, ExamOwner>();
        Iterator i3 = root.element("exams").elementIterator("exam");
        while (i3.hasNext()) {
            Element per;
            Element best;
            Element per2;
            Element ini;
            Iterator j3;
            Element per3;
            Element asg;
            String g;
            e = (Element)i3.next();
            ArrayList<ExamPeriodPlacement> periodPlacements = new ArrayList<ExamPeriodPlacement>();
            if (softPeriods != null) {
                for (ExamPeriod period3 : this.getPeriods()) {
                    int n = softPeriods;
                    Iterator j6 = e.elementIterator("period");
                    while (j6.hasNext()) {
                        Element pe3 = (Element)j6.next();
                        if (!period3.getId().equals(Long.valueOf(pe3.attributeValue("id")))) continue;
                        n = Integer.parseInt(pe3.attributeValue("penalty", "0"));
                        break;
                    }
                    periodPlacements.add(new ExamPeriodPlacement(period3, n));
                }
            } else {
                Iterator j22 = e.elementIterator("period");
                while (j22.hasNext()) {
                    Element pe4 = (Element)j22.next();
                    ExamPeriod examPeriod = this.getPeriod(Long.valueOf(pe4.attributeValue("id")));
                    if (examPeriod == null) continue;
                    periodPlacements.add(new ExamPeriodPlacement(examPeriod, Integer.parseInt(pe4.attributeValue("penalty", "0"))));
                }
            }
            ArrayList<ExamRoomPlacement> roomPlacements = new ArrayList<ExamRoomPlacement>();
            if (softRooms != null) {
                for (ExamRoom examRoom : this.getRooms()) {
                    boolean av = false;
                    for (ExamPeriodPlacement p : periodPlacements) {
                        if (!examRoom.isAvailable(p.getPeriod()) || examRoom.getPenalty(p.getPeriod()) == softRooms.intValue()) continue;
                        av = true;
                        break;
                    }
                    if (!av) continue;
                    int penalty = softRooms;
                    int maxPenalty = softRooms;
                    Iterator j5 = e.elementIterator("room");
                    while (j5.hasNext()) {
                        Element re = (Element)j5.next();
                        if (examRoom.getId() != Long.parseLong(re.attributeValue("id"))) continue;
                        penalty = Integer.parseInt(re.attributeValue("penalty", "0"));
                        maxPenalty = Integer.parseInt(re.attributeValue("maxPenalty", softRooms.toString()));
                    }
                    roomPlacements.add(new ExamRoomPlacement(examRoom, penalty, maxPenalty));
                }
            } else {
                j = e.elementIterator("room");
                while (j.hasNext()) {
                    Element element = (Element)j.next();
                    ExamRoomPlacement room = new ExamRoomPlacement((ExamRoom)rooms.get(Long.valueOf(element.attributeValue("id"))), Integer.parseInt(element.attributeValue("penalty", "0")), Integer.parseInt(element.attributeValue("maxPenalty", "100")));
                    if (!room.getRoom().isAvailable()) continue;
                    roomPlacements.add(room);
                }
            }
            if ((g = e.attributeValue("groups")) != null) {
                HashMap<ExamRoom, Integer> hashMap = new HashMap<ExamRoom, Integer>();
                StringTokenizer s = new StringTokenizer(g, ",");
                while (s.hasMoreTokens()) {
                    String gr = s.nextToken();
                    ArrayList roomsThisGrop = (ArrayList)roomGroups.get(gr);
                    if (roomsThisGrop == null) continue;
                    for (ExamRoom r : roomsThisGrop) {
                        hashMap.put(r, 0);
                    }
                }
                Iterator j7 = e.elementIterator("original-room");
                while (j7.hasNext()) {
                    hashMap.put((ExamRoom)rooms.get(Long.valueOf(((Element)j7.next()).attributeValue("id"))), new Integer(-1));
                }
                for (Map.Entry entry : hashMap.entrySet()) {
                    ExamRoomPlacement room = new ExamRoomPlacement((ExamRoom)entry.getKey(), (Integer)entry.getValue(), 100);
                    roomPlacements.add(room);
                }
                if (periodPlacements.isEmpty()) {
                    for (ExamPeriod p : this.getPeriods()) {
                        periodPlacements.add(new ExamPeriodPlacement(p, 0));
                    }
                }
            }
            Exam exam = new Exam(Long.parseLong(e.attributeValue("id")), e.attributeValue("name"), Integer.parseInt(e.attributeValue("length")), "true".equals(e.attributeValue("alt")), e.attribute("maxRooms") == null ? this.getMaxRooms() : Integer.parseInt(e.attributeValue("maxRooms")), Integer.parseInt(e.attributeValue("minSize", "0")), periodPlacements, roomPlacements);
            if (e.attributeValue("size") != null) {
                exam.setSizeOverride(Integer.valueOf(e.attributeValue("size")));
            }
            if (e.attributeValue("printOffset") != null) {
                exam.setPrintOffset(Integer.valueOf(e.attributeValue("printOffset")));
            }
            exams.put(new Long(exam.getId()), exam);
            this.addVariable(exam);
            if (e.attribute("average") != null) {
                exam.setAveragePeriod(Integer.parseInt(e.attributeValue("average")));
            }
            if ((asg = e.element("assignment")) != null && loadSolution && (per3 = asg.element("period")) != null) {
                HashSet<ExamRoomPlacement> rp = new HashSet<ExamRoomPlacement>();
                j3 = asg.elementIterator("room");
                while (j3.hasNext()) {
                    rp.add(exam.getRoomPlacement(Long.parseLong(((Element)j3.next()).attributeValue("id"))));
                }
                ExamPeriodPlacement pp = exam.getPeriodPlacement(Long.valueOf(per3.attributeValue("id")));
                if (pp != null) {
                    assignments.add(new ExamPlacement(exam, pp, rp));
                }
            }
            if ((ini = e.element("initial")) != null && loadInitial && (per2 = ini.element("period")) != null) {
                HashSet<ExamRoomPlacement> rp = new HashSet<ExamRoomPlacement>();
                Iterator j8 = ini.elementIterator("room");
                while (j8.hasNext()) {
                    rp.add(exam.getRoomPlacement(Long.parseLong(((Element)j8.next()).attributeValue("id"))));
                }
                ExamPeriodPlacement pp = exam.getPeriodPlacement(Long.valueOf(per2.attributeValue("id")));
                if (pp != null) {
                    exam.setInitialAssignment(new ExamPlacement(exam, pp, rp));
                }
            }
            if ((best = e.element("best")) != null && loadBest && (per = best.element("period")) != null) {
                HashSet<ExamRoomPlacement> rp = new HashSet<ExamRoomPlacement>();
                Iterator j9 = best.elementIterator("room");
                while (j9.hasNext()) {
                    rp.add(exam.getRoomPlacement(Long.parseLong(((Element)j9.next()).attributeValue("id"))));
                }
                ExamPeriodPlacement pp = exam.getPeriodPlacement(Long.valueOf(per.attributeValue("id")));
                if (pp != null) {
                    exam.setBestAssignment(new ExamPlacement(exam, pp, rp), 0L);
                }
            }
            j3 = e.elementIterator("owner");
            while (j3.hasNext()) {
                Element f2 = (Element)j3.next();
                ExamOwner owner2 = new ExamOwner(exam, Long.parseLong(f2.attributeValue("id")), f2.attributeValue("name"));
                exam.getOwners().add(owner2);
                courseSections.put(new Long(owner2.getId()), owner2);
            }
            if (this.iRoomSharing == null) continue;
            this.iRoomSharing.load(exam, e);
        }
        Iterator i4 = root.element("students").elementIterator("student");
        while (i4.hasNext()) {
            e = (Element)i4.next();
            ExamStudent student = new ExamStudent(this, Long.parseLong(e.attributeValue("id")));
            j2 = e.elementIterator("exam");
            while (j2.hasNext()) {
                x = (Element)j2.next();
                Exam exam = (Exam)exams.get(Long.valueOf(x.attributeValue("id")));
                student.addVariable(exam);
                k = x.elementIterator("owner");
                while (k.hasNext()) {
                    f = (Element)k.next();
                    owner = (ExamOwner)courseSections.get(Long.valueOf(f.attributeValue("id")));
                    student.getOwners().add(owner);
                    owner.getStudents().add(student);
                }
            }
            available = e.attributeValue("available");
            if (available != null) {
                for (ExamPeriod examPeriod : this.getPeriods()) {
                    if (available.charAt(examPeriod.getIndex()) != '0') continue;
                    student.setAvailable(examPeriod.getIndex(), false);
                }
            }
            j = e.elementIterator("period");
            while (j.hasNext()) {
                Element element = (Element)j.next();
                period = this.getPeriod(Long.valueOf(element.attributeValue("id")));
                if (period == null || !"false".equals(element.attributeValue("available"))) continue;
                student.setAvailable(period.getIndex(), false);
            }
            this.addConstraint(student);
            this.getStudents().add(student);
        }
        if (root.element("instructors") != null) {
            i4 = root.element("instructors").elementIterator("instructor");
            while (i4.hasNext()) {
                e = (Element)i4.next();
                ExamInstructor instructor = new ExamInstructor(this, Long.parseLong(e.attributeValue("id")), e.attributeValue("name"));
                j2 = e.elementIterator("exam");
                while (j2.hasNext()) {
                    x = (Element)j2.next();
                    Exam exam = (Exam)exams.get(Long.valueOf(x.attributeValue("id")));
                    instructor.addVariable(exam);
                    k = x.elementIterator("owner");
                    while (k.hasNext()) {
                        f = (Element)k.next();
                        owner = (ExamOwner)courseSections.get(Long.valueOf(f.attributeValue("id")));
                        instructor.getOwners().add(owner);
                        owner.getIntructors().add(instructor);
                    }
                }
                available = e.attributeValue("available");
                if (available != null) {
                    for (ExamPeriod examPeriod : this.getPeriods()) {
                        if (available.charAt(examPeriod.getIndex()) != '0') continue;
                        instructor.setAvailable(examPeriod.getIndex(), false);
                    }
                }
                j = e.elementIterator("period");
                while (j.hasNext()) {
                    Element element = (Element)j.next();
                    period = this.getPeriod(Long.valueOf(element.attributeValue("id")));
                    if (period == null || !"false".equals(element.attributeValue("available"))) continue;
                    instructor.setAvailable(period.getIndex(), false);
                }
                this.addConstraint(instructor);
                this.getInstructors().add(instructor);
            }
        }
        if (root.element("constraints") != null) {
            i4 = root.element("constraints").elementIterator();
            while (i4.hasNext()) {
                e = (Element)i4.next();
                ExamDistributionConstraint dc = new ExamDistributionConstraint(Long.parseLong(e.attributeValue("id")), e.getName(), softDistributions != null ? false : "true".equals(e.attributeValue("hard", "true")), softDistributions != null && "true".equals(e.attributeValue("hard", "true")) ? softDistributions : Integer.parseInt(e.attributeValue("weight", "0")));
                j2 = e.elementIterator("exam");
                while (j2.hasNext()) {
                    dc.addVariable((Variable)exams.get(Long.valueOf(((Element)j2.next()).attributeValue("id"))));
                }
                this.addConstraint(dc);
                this.getDistributionConstraints().add(dc);
            }
        }
        this.init();
        if (loadBest && saveBest != null && assignment != null) {
            for (Exam exam : this.variables()) {
                ExamPlacement placement = (ExamPlacement)exam.getBestAssignment();
                if (placement == null) continue;
                assignment.assign(0L, placement);
            }
            saveBest.execute();
            for (Exam exam : this.variables()) {
                if (assignment.getValue(exam) == null) continue;
                assignment.unassign(0L, exam);
            }
        }
        if (assignment != null) {
            for (ExamPlacement placement : assignments) {
                Exam exam = (Exam)placement.variable();
                Set<ExamPlacement> conf = this.conflictValues(assignment, placement);
                if (!conf.isEmpty()) {
                    for (Map.Entry entry : this.conflictConstraints(assignment, placement).entrySet()) {
                        Constraint constraint = (Constraint)entry.getKey();
                        Set values = (Set)entry.getValue();
                        if (!(constraint instanceof ExamStudent)) continue;
                        ((ExamStudent)constraint).setAllowDirectConflicts(true);
                        exam.setAllowDirectConflicts(true);
                        for (ExamPlacement p : values) {
                            ((Exam)p.variable()).setAllowDirectConflicts(true);
                        }
                    }
                    conf = this.conflictValues(assignment, placement);
                }
                if (conf.isEmpty()) {
                    assignment.assign(0L, placement);
                    continue;
                }
                sLog.error("Unable to assign " + ((ExamPlacement)exam.getInitialAssignment()).getName() + " to exam " + exam.getName());
                sLog.error("Conflicts:" + ToolBox.dict2string(this.conflictConstraints(assignment, exam.getInitialAssignment()), 2));
            }
        }
        return true;
    }

    @Override
    public ExamContext createAssignmentContext(Assignment<Exam, ExamPlacement> assignment) {
        return new ExamContext(this, assignment);
    }

    public Map<ExamStudent, Set<Exam>> getStudentsOfPeriod(Assignment<Exam, ExamPlacement> assignment, ExamPeriod period) {
        return ((ExamContext)this.getContext((Assignment)assignment)).getStudentsOfPeriod(period.getIndex());
    }

    public Map<ExamStudent, Set<Exam>> getStudentsOfDay(Assignment<Exam, ExamPlacement> assignment, ExamPeriod period) {
        return ((ExamContext)this.getContext((Assignment)assignment)).getStudentsOfDay(period.getDay());
    }

    public Map<ExamStudent, Set<Exam>> getStudentsOfDay(Assignment<Exam, ExamPlacement> assignment, int day) {
        return ((ExamContext)this.getContext((Assignment)assignment)).getStudentsOfDay(day);
    }

    public Map<ExamInstructor, Set<Exam>> getInstructorsOfPeriod(Assignment<Exam, ExamPlacement> assignment, ExamPeriod period) {
        return ((ExamContext)this.getContext((Assignment)assignment)).getInstructorsOfPeriod(period.getIndex());
    }

    public Map<ExamInstructor, Set<Exam>> getInstructorsOfDay(Assignment<Exam, ExamPlacement> assignment, ExamPeriod period) {
        return ((ExamContext)this.getContext((Assignment)assignment)).getInstructorsOfDay(period.getDay());
    }

    public Map<ExamInstructor, Set<Exam>> getInstructorsOfDay(Assignment<Exam, ExamPlacement> assignment, int day) {
        return ((ExamContext)this.getContext((Assignment)assignment)).getInstructorsOfDay(day);
    }
}

