/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.criteria;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.cpsolver.exam.criteria.InstructorNotAvailableConflicts;
import org.cpsolver.exam.criteria.StudentDirectConflicts;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamInstructor;
import org.cpsolver.exam.model.ExamModel;
import org.cpsolver.exam.model.ExamPeriod;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.util.DataProperties;

public class InstructorDirectConflicts
extends StudentDirectConflicts {
    @Override
    public String getWeightName() {
        return "Exams.InstructorDirectConflictWeight";
    }

    @Override
    public String getXmlWeightName() {
        return "instructorDirectConflictWeight";
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return 1000.0;
    }

    @Override
    public double getValue(Assignment<Exam, ExamPlacement> assignment, ExamPlacement value, Set<ExamPlacement> conflicts) {
        Exam exam = (Exam)value.variable();
        int penalty = 0;
        Map<ExamInstructor, Set<Exam>> instructors = ((ExamModel)this.getModel()).getInstructorsOfPeriod(assignment, value.getPeriod());
        for (ExamInstructor s : exam.getInstructors()) {
            int nrExams;
            Set<Exam> exams = instructors.get(s);
            if (exams == null || (nrExams = exams.size() + (exams.contains(exam) ? 0 : 1)) <= 1) continue;
            ++penalty;
        }
        return penalty;
    }

    @Override
    public double getValue(Assignment<Exam, ExamPlacement> assignment, Collection<Exam> variables) {
        int ret = 0;
        ExamModel m = (ExamModel)this.getModel();
        for (ExamPeriod p : m.getPeriods()) {
            Map<ExamInstructor, Set<Exam>> instructors = ((ExamModel)this.getModel()).getInstructorsOfPeriod(assignment, p);
            for (Set<Exam> exams : instructors.values()) {
                int nrExams = exams.size();
                if (nrExams <= 1) continue;
                ret += nrExams - 1;
            }
        }
        return ret;
    }

    @Override
    public String getName() {
        return "Instructor Direct Conflicts";
    }

    @Override
    public void getInfo(Assignment<Exam, ExamPlacement> assignment, Map<String, String> info) {
        InstructorNotAvailableConflicts na = (InstructorNotAvailableConflicts)this.getModel().getCriterion(InstructorNotAvailableConflicts.class);
        if (this.getValue(assignment) != 0.0 || na != null && na.getValue(assignment) != 0.0) {
            info.put(this.getName(), sDoubleFormat.format(this.getValue(assignment) + (na == null ? 0.0 : na.getValue(assignment))) + (na == null || na.getValue(assignment) == 0.0 ? "" : " (" + sDoubleFormat.format(na.getValue(assignment)) + " N/A)"));
        }
    }

    @Override
    public String toString(Assignment<Exam, ExamPlacement> assignment) {
        return "iDC:" + sDoubleFormat.format(this.getValue(assignment));
    }
}

