/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.sectioning;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cpsolver.coursett.constraint.JenrlConstraint;
import org.cpsolver.coursett.criteria.StudentConflict;
import org.cpsolver.coursett.model.Configuration;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.Student;
import org.cpsolver.coursett.sectioning.SctEnrollment;
import org.cpsolver.coursett.sectioning.SctModel;

public class SctStudent
implements Comparable<SctStudent> {
    private SctModel iModel;
    private Student iStudent;
    private List<SctEnrollment> iEnrollments = null;
    private double iTotalEnrollmentWeight = 0.0;
    private Double iOfferingWeight = null;
    private List<Lecture> iInstructing = null;

    public SctStudent(SctModel model, Student student) {
        this.iStudent = student;
        this.iModel = model;
    }

    public SctModel getModel() {
        return this.iModel;
    }

    public Student getStudent() {
        return this.iStudent;
    }

    public SctEnrollment getCurrentEnrollment(boolean checkInstructor) {
        if (checkInstructor && this.isInstructing()) {
            return new SctEnrollment(-1, this, this.getInstructingLectures());
        }
        ArrayList<Lecture> lectures = new ArrayList<Lecture>();
        for (Lecture lecture : this.getStudent().getLectures()) {
            if (!this.getModel().getOfferingId().equals(lecture.getConfiguration().getOfferingId())) continue;
            lectures.add(lecture);
        }
        if (!lectures.isEmpty()) {
            return new SctEnrollment(-1, this, lectures);
        }
        return null;
    }

    public List<Lecture> getInstructingLectures() {
        if (this.iInstructing == null && this.getStudent().getInstructor() != null) {
            this.iInstructing = new ArrayList<Lecture>();
            for (Lecture lecture : this.getStudent().getInstructor().variables()) {
                if (!this.getModel().getOfferingId().equals(lecture.getConfiguration().getOfferingId())) continue;
                this.iInstructing.add(lecture);
            }
        }
        return this.iInstructing;
    }

    public boolean isInstructing() {
        return this.getStudent().getInstructor() != null && !this.getInstructingLectures().isEmpty();
    }

    public double getJenrConflictWeight(Lecture l1, Lecture l2) {
        Placement p1 = this.getModel().getAssignment().getValue(l1);
        Placement p2 = this.getModel().getAssignment().getValue(l2);
        if (p1 == null || p2 == null) {
            return 0.0;
        }
        if (this.getModel().getStudentConflictCriteria() == null) {
            if (JenrlConstraint.isInConflict(p1, p2, this.getModel().getTimetableModel().getDistanceMetric(), this.getModel().getTimetableModel().getStudentWorkDayLimit())) {
                return this.getStudent().getJenrlWeight(l1, l2);
            }
            return 0.0;
        }
        double weight = 0.0;
        for (StudentConflict sc : this.getModel().getStudentConflictCriteria()) {
            if (!sc.isApplicable(this.getStudent(), (Lecture)p1.variable(), (Lecture)p2.variable()) || !sc.inConflict(p1, p2)) continue;
            weight += sc.getWeight() * this.getStudent().getJenrlWeight(l1, l2);
        }
        return weight;
    }

    private List<Long> getSubpartIds(Configuration configuration) {
        ArrayList<Long> subpartIds = new ArrayList<Long>();
        LinkedList<Lecture> queue = new LinkedList<Lecture>();
        for (Map.Entry<Long, Set<Lecture>> e : configuration.getTopLectures().entrySet()) {
            subpartIds.add(e.getKey());
            queue.add(e.getValue().iterator().next());
        }
        Lecture lecture = null;
        while ((lecture = (Lecture)queue.poll()) != null) {
            if (lecture.getChildren() == null) continue;
            for (Map.Entry<Long, List<Lecture>> e : lecture.getChildren().entrySet()) {
                subpartIds.add(e.getKey());
                queue.add(e.getValue().iterator().next());
            }
        }
        return subpartIds;
    }

    private void computeEnrollments(Configuration configuration, Map<Long, Set<Lecture>> subparts, List<Long> subpartIds, Set<Lecture> enrollment, double conflictWeight) {
        if (enrollment.size() == subpartIds.size()) {
            this.iEnrollments.add(new SctEnrollment(this.iEnrollments.size(), this, enrollment, conflictWeight));
            this.iTotalEnrollmentWeight += conflictWeight;
        } else {
            Set<Lecture> lectures = subparts.get(subpartIds.get(enrollment.size()));
            for (Lecture lecture : lectures) {
                if (lecture.getParent() != null && !enrollment.contains(lecture.getParent()) || !this.getStudent().canEnroll(lecture)) continue;
                double delta = 0.0;
                for (Lecture other : this.getStudent().getLectures()) {
                    if (configuration.getOfferingId().equals(other.getConfiguration().getOfferingId())) continue;
                    delta += this.getJenrConflictWeight(lecture, other);
                }
                for (Lecture other : enrollment) {
                    delta += this.getJenrConflictWeight(lecture, other);
                }
                enrollment.add(lecture);
                this.computeEnrollments(configuration, subparts, subpartIds, enrollment, conflictWeight + delta);
                enrollment.remove(lecture);
            }
        }
    }

    private void computeEnrollments() {
        this.iEnrollments = new ArrayList<SctEnrollment>();
        if (this.isInstructing()) {
            double conflictWeight = 0.0;
            for (Lecture lecture : this.getInstructingLectures()) {
                for (Lecture other : this.getStudent().getLectures()) {
                    if (this.getModel().getOfferingId().equals(other.getConfiguration().getOfferingId())) continue;
                    conflictWeight += this.getJenrConflictWeight(lecture, other);
                }
            }
            this.iEnrollments.add(new SctEnrollment(0, this, this.getInstructingLectures(), conflictWeight));
            return;
        }
        for (Configuration configuration : this.getModel().getConfigurations()) {
            Map<Long, Set<Lecture>> subparts = this.getModel().getSubparts(configuration);
            List<Long> subpartIds = this.getSubpartIds(configuration);
            this.computeEnrollments(configuration, subparts, subpartIds, new HashSet<Lecture>(), 0.0);
        }
        Collections.sort(this.iEnrollments);
    }

    public List<SctEnrollment> getEnrollments() {
        if (this.iEnrollments == null) {
            this.computeEnrollments();
        }
        return this.iEnrollments;
    }

    public List<SctEnrollment> getEnrollments(Comparator<SctEnrollment> cmp) {
        if (this.iEnrollments == null) {
            this.computeEnrollments();
        }
        if (cmp != null) {
            Collections.sort(this.iEnrollments, cmp);
        }
        return this.iEnrollments;
    }

    public int getNumberOfEnrollments() {
        if (this.iEnrollments == null) {
            this.computeEnrollments();
        }
        return this.iEnrollments.size();
    }

    public double getAverageConflictWeight() {
        if (this.iEnrollments == null) {
            this.computeEnrollments();
        }
        return this.iTotalEnrollmentWeight / (double)this.iEnrollments.size();
    }

    public double getOfferingWeight() {
        if (this.iOfferingWeight == null) {
            this.iOfferingWeight = this.getStudent().getOfferingWeight(this.getModel().getOfferingId());
        }
        return this.iOfferingWeight;
    }

    public int compare(Student s1, Student s2) {
        int cmp = (s1.getCurriculum() == null ? "" : s1.getCurriculum()).compareToIgnoreCase(s2.getCurriculum() == null ? "" : s2.getCurriculum());
        if (cmp != 0) {
            return cmp;
        }
        cmp = (s1.getAcademicArea() == null ? "" : s1.getAcademicArea()).compareToIgnoreCase(s2.getAcademicArea() == null ? "" : s2.getAcademicArea());
        if (cmp != 0) {
            return cmp;
        }
        cmp = (s1.getMajor() == null ? "" : s1.getMajor()).compareToIgnoreCase(s2.getMajor() == null ? "" : s2.getMajor());
        if (cmp != 0) {
            return cmp;
        }
        cmp = (s1.getAcademicClassification() == null ? "" : s1.getAcademicClassification()).compareToIgnoreCase(s2.getAcademicClassification() == null ? "" : s2.getAcademicClassification());
        if (cmp != 0) {
            return cmp;
        }
        return s1.getId().compareTo(s2.getId());
    }

    @Override
    public int compareTo(SctStudent s) {
        int cmp = Double.compare(s.getAverageConflictWeight(), this.getAverageConflictWeight());
        if (cmp != 0) {
            return cmp;
        }
        cmp = Double.compare(this.getNumberOfEnrollments(), s.getNumberOfEnrollments());
        if (cmp != 0) {
            return cmp;
        }
        return this.compare(this.getStudent(), s.getStudent());
    }

    public String toString() {
        return this.getStudent() + "{enrls:" + this.getEnrollments().size() + (this.getEnrollments().isEmpty() ? "" : ", best:" + this.getEnrollments().get(0).getConflictWeight()) + ", avg:" + this.getAverageConflictWeight() + "}";
    }
}

