/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.cpsolver.coursett.TimetableLoader;
import org.cpsolver.coursett.constraint.ClassLimitConstraint;
import org.cpsolver.coursett.constraint.DepartmentSpreadConstraint;
import org.cpsolver.coursett.constraint.DiscouragedRoomConstraint;
import org.cpsolver.coursett.constraint.FlexibleConstraint;
import org.cpsolver.coursett.constraint.GroupConstraint;
import org.cpsolver.coursett.constraint.IgnoreStudentConflictsConstraint;
import org.cpsolver.coursett.constraint.InstructorConstraint;
import org.cpsolver.coursett.constraint.JenrlConstraint;
import org.cpsolver.coursett.constraint.MinimizeNumberOfUsedGroupsOfTime;
import org.cpsolver.coursett.constraint.MinimizeNumberOfUsedRoomsConstraint;
import org.cpsolver.coursett.constraint.RoomConstraint;
import org.cpsolver.coursett.constraint.SpreadConstraint;
import org.cpsolver.coursett.model.Configuration;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.coursett.model.RoomSharingModel;
import org.cpsolver.coursett.model.Student;
import org.cpsolver.coursett.model.StudentGroup;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.ifs.util.ToolBox;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class TimetableXMLLoader
extends TimetableLoader {
    private static Logger sLogger = Logger.getLogger(TimetableXMLLoader.class);
    private static SimpleDateFormat sDF = new SimpleDateFormat("MM/dd");
    private boolean iDeptBalancing = true;
    private int iForcedPerturbances = 0;
    private boolean iInteractiveMode = false;
    private File iInputFile;
    private Progress iProgress = Progress.getInstance(this.getModel());
    private Solver<Lecture, Placement> iSolver = null;

    public TimetableXMLLoader(TimetableModel model, Assignment<Lecture, Placement> assignment) {
        super(model, assignment);
        this.iInputFile = new File(((TimetableModel)this.getModel()).getProperties().getProperty("General.Input", "." + File.separator + "solution.xml"));
        this.iForcedPerturbances = ((TimetableModel)this.getModel()).getProperties().getPropertyInt("General.ForcedPerturbances", 0);
        this.iDeptBalancing = ((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("General.DeptBalancing", true);
        this.iInteractiveMode = ((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("General.InteractiveMode", this.iInteractiveMode);
    }

    public void setSolver(Solver<Lecture, Placement> solver) {
        this.iSolver = solver;
    }

    public Solver<Lecture, Placement> getSolver() {
        return this.iSolver;
    }

    public void setInputFile(File inputFile) {
        this.iInputFile = inputFile;
    }

    @Override
    public void load() throws Exception {
        this.load(null);
    }

    public void load(Solution<Lecture, Placement> currentSolution) throws Exception {
        sLogger.debug("Reading XML data from " + this.iInputFile);
        this.iProgress.setPhase("Reading " + this.iInputFile.getName() + " ...");
        Document document = new SAXReader().read(this.iInputFile);
        Element root = document.getRootElement();
        sLogger.debug("Root element: " + root.getName());
        if (!"llrt".equals(root.getName()) && !"timetable".equals(root.getName())) {
            throw new IllegalArgumentException("Given XML file is not large lecture room timetabling problem.");
        }
        if (root.element("input") != null) {
            root = root.element("input");
        }
        this.iProgress.load(root, true);
        this.iProgress.message(4, "Restoring from backup ...");
        this.doLoad(currentSolution, root);
        try {
            this.getSolver().getClass().getMethod("load", Element.class).invoke(this.getSolver(), root);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.iProgress.setPhase("Done", 1L);
        this.iProgress.incProgress();
        sLogger.debug("Model successfully loaded.");
        this.iProgress.info("Model successfully loaded.");
    }

    public void load(Solution<Lecture, Placement> currentSolution, Document document) {
        this.iProgress.setPhase("Reading solution file ...");
        Element root = document.getRootElement();
        sLogger.debug("Root element: " + root.getName());
        if (!"llrt".equals(root.getName()) && !"timetable".equals(root.getName())) {
            throw new IllegalArgumentException("Given XML file is not large lecture room timetabling problem.");
        }
        if (root.element("input") != null) {
            root = root.element("input");
        }
        this.iProgress.load(root, true);
        this.iProgress.message(4, "Restoring from backup ...");
        this.doLoad(currentSolution, root);
        this.iProgress.setPhase("Done", 1L);
        this.iProgress.incProgress();
        this.iProgress.info("Model successfully loaded.");
    }

    /*
     * WARNING - void declaration
     */
    protected void doLoad(Solution<Lecture, Placement> currentSolution, Element root) {
        Set<Placement> vals;
        Map conflictConstraints;
        Placement placement;
        Lecture lecture4;
        Iterator i2;
        if (root.attributeValue("term") != null) {
            ((TimetableModel)this.getModel()).getProperties().setProperty("Data.Term", root.attributeValue("term"));
        }
        if (root.attributeValue("year") != null) {
            ((TimetableModel)this.getModel()).setYear(Integer.parseInt(root.attributeValue("year")));
        } else if (root.attributeValue("term") != null) {
            ((TimetableModel)this.getModel()).setYear(Integer.parseInt(root.attributeValue("term").substring(0, 4)));
        }
        if (root.attributeValue("initiative") != null) {
            ((TimetableModel)this.getModel()).getProperties().setProperty("Data.Initiative", root.attributeValue("initiative"));
        }
        if (root.attributeValue("semester") != null && root.attributeValue("year") != null) {
            ((TimetableModel)this.getModel()).getProperties().setProperty("Data.Term", root.attributeValue("semester") + root.attributeValue("year"));
        }
        if (root.attributeValue("session") != null) {
            ((TimetableModel)this.getModel()).getProperties().setProperty("General.SessionId", root.attributeValue("session"));
        }
        if (root.attributeValue("solverGroup") != null) {
            ((TimetableModel)this.getModel()).getProperties().setProperty("General.SolverGroupId", root.attributeValue("solverGroup"));
        }
        String version = root.attributeValue("version");
        boolean sectionWholeCourse = true;
        if (version != null && version.indexOf(46) >= 0) {
            int majorVersion = Integer.parseInt(version.substring(0, version.indexOf(46)));
            int minorVersion = Integer.parseInt(version.substring(1 + version.indexOf(46)));
            sectionWholeCourse = majorVersion == 2 && minorVersion >= 5 || majorVersion > 2;
        }
        HashMap<Long, TimeLocation> perts = new HashMap<Long, TimeLocation>();
        if (((TimetableModel)this.getModel()).getProperties().getPropertyInt("MPP.TimePert", 0) > 0) {
            int nrChanges = ((TimetableModel)this.getModel()).getProperties().getPropertyInt("MPP.TimePert", 0);
            Iterator i = root.element("perturbations").elementIterator("class");
            for (int idx = 0; i.hasNext() && idx < nrChanges; ++idx) {
                Element pertEl = (Element)i.next();
                Long classId = Long.valueOf(pertEl.attributeValue("id"));
                TimeLocation tl = new TimeLocation(Integer.parseInt(pertEl.attributeValue("days"), 2), Integer.parseInt(pertEl.attributeValue("start")), Integer.parseInt(pertEl.attributeValue("length")), 0, 0.0, 0, null, null, null, 0);
                perts.put(classId, tl);
            }
        }
        this.iProgress.setPhase("Creating rooms ...", root.element("rooms").elements("room").size());
        HashMap<String, Element> roomElements = new HashMap<String, Element>();
        HashMap<String, RoomConstraint> roomConstraints = new HashMap<String, RoomConstraint>();
        HashMap<Long, ArrayList<Lecture>> sameLectures = new HashMap<Long, ArrayList<Lecture>>();
        Iterator i = root.element("rooms").elementIterator("room");
        while (i.hasNext()) {
            RoomConstraint constraint;
            boolean discouraged;
            Element roomEl = (Element)i.next();
            this.iProgress.incProgress();
            roomElements.put(roomEl.attributeValue("id"), roomEl);
            if ("false".equals(roomEl.attributeValue("constraint"))) continue;
            RoomSharingModel sharingModel = null;
            Element sharingEl = roomEl.element("sharing");
            if (sharingEl != null) {
                Character freeForAllPrefChar = null;
                Element freeForAllEl = sharingEl.element("freeForAll");
                if (freeForAllEl != null) {
                    freeForAllPrefChar = Character.valueOf(freeForAllEl.attributeValue("value", "F").charAt(0));
                }
                Character notAvailablePrefChar = null;
                Element notAvailableEl = sharingEl.element("notAvailable");
                if (notAvailableEl != null) {
                    notAvailablePrefChar = Character.valueOf(notAvailableEl.attributeValue("value", "X").charAt(0));
                }
                String pattern = sharingEl.element("pattern").getText();
                int unit = Integer.parseInt(sharingEl.element("pattern").attributeValue("unit", "1"));
                HashMap<Character, Long> departments = new HashMap<Character, Long>();
                Iterator j = sharingEl.elementIterator("department");
                while (j.hasNext()) {
                    Element deptEl = (Element)j.next();
                    char value = deptEl.attributeValue("value", String.valueOf((char)(48 + departments.size()))).charAt(0);
                    Long id = Long.valueOf(deptEl.attributeValue("id"));
                    departments.put(Character.valueOf(value), id);
                }
                sharingModel = new RoomSharingModel(unit, departments, pattern, freeForAllPrefChar, notAvailablePrefChar);
            }
            boolean ignoreTooFar = false;
            if ("true".equals(roomEl.attributeValue("ignoreTooFar"))) {
                ignoreTooFar = true;
            }
            boolean fake = false;
            if ("true".equals(roomEl.attributeValue("fake"))) {
                fake = true;
            }
            Double posX = null;
            Double posY = null;
            if (roomEl.attributeValue("location") != null) {
                String loc = roomEl.attributeValue("location");
                posX = Double.valueOf(loc.substring(0, loc.indexOf(44)));
                posY = Double.valueOf(loc.substring(loc.indexOf(44) + 1));
            }
            RoomConstraint roomConstraint = (discouraged = "true".equals(roomEl.attributeValue("discouraged"))) ? new DiscouragedRoomConstraint(((TimetableModel)this.getModel()).getProperties(), Long.valueOf(roomEl.attributeValue("id")), roomEl.attributeValue("name") != null ? roomEl.attributeValue("name") : "r" + roomEl.attributeValue("id"), roomEl.attributeValue("building") == null ? null : Long.valueOf(roomEl.attributeValue("building")), Integer.parseInt(roomEl.attributeValue("capacity")), sharingModel, posX, posY, ignoreTooFar, !fake) : (constraint = new RoomConstraint(Long.valueOf(roomEl.attributeValue("id")), roomEl.attributeValue("name") != null ? roomEl.attributeValue("name") : "r" + roomEl.attributeValue("id"), roomEl.attributeValue("building") == null ? null : Long.valueOf(roomEl.attributeValue("building")), Integer.parseInt(roomEl.attributeValue("capacity")), sharingModel, posX, posY, ignoreTooFar, !fake));
            if (roomEl.attributeValue("type") != null) {
                constraint.setType(Long.valueOf(roomEl.attributeValue("type")));
            }
            ((TimetableModel)this.getModel()).addConstraint(constraint);
            roomConstraints.put(roomEl.attributeValue("id"), constraint);
            Iterator j = roomEl.elementIterator("travel-time");
            while (j.hasNext()) {
                Element travelTimeEl = (Element)j.next();
                ((TimetableModel)this.getModel()).getDistanceMetric().addTravelTime(constraint.getResourceId(), Long.valueOf(travelTimeEl.attributeValue("id")), Integer.valueOf(travelTimeEl.attributeValue("minutes")));
            }
        }
        HashMap<String, InstructorConstraint> instructorConstraints = new HashMap<String, InstructorConstraint>();
        if (root.element("instructors") != null) {
            Iterator i3 = root.element("instructors").elementIterator("instructor");
            while (i3.hasNext()) {
                Element instructorEl = (Element)i3.next();
                InstructorConstraint instructorConstraint = new InstructorConstraint(Long.valueOf(instructorEl.attributeValue("id")), instructorEl.attributeValue("puid"), instructorEl.attributeValue("name") != null ? instructorEl.attributeValue("name") : "i" + instructorEl.attributeValue("id"), "true".equals(instructorEl.attributeValue("ignDist")));
                if (instructorEl.attributeValue("type") != null) {
                    instructorConstraint.setType(Long.valueOf(instructorEl.attributeValue("type")));
                }
                instructorConstraints.put(instructorEl.attributeValue("id"), instructorConstraint);
                ((TimetableModel)this.getModel()).addConstraint(instructorConstraint);
            }
        }
        HashMap<Long, String> depts = new HashMap<Long, String>();
        if (root.element("departments") != null) {
            Iterator i4 = root.element("departments").elementIterator("department");
            while (i4.hasNext()) {
                Element deptEl = (Element)i4.next();
                depts.put(Long.valueOf(deptEl.attributeValue("id")), deptEl.attributeValue("name") != null ? deptEl.attributeValue("name") : "d" + deptEl.attributeValue("id"));
            }
        }
        HashMap<Long, Configuration> configs = new HashMap<Long, Configuration>();
        HashMap<Long, ArrayList<Configuration>> alternativeConfigurations = new HashMap<Long, ArrayList<Configuration>>();
        if (root.element("configurations") != null) {
            Iterator i5 = root.element("configurations").elementIterator("config");
            while (i5.hasNext()) {
                Element configEl = (Element)i5.next();
                Long configId = Long.valueOf(configEl.attributeValue("id"));
                int limit = Integer.parseInt(configEl.attributeValue("limit"));
                Long offeringId = Long.valueOf(configEl.attributeValue("offering"));
                Configuration config = new Configuration(offeringId, configId, limit);
                configs.put(configId, config);
                ArrayList<Configuration> altConfigs = (ArrayList<Configuration>)alternativeConfigurations.get(offeringId);
                if (altConfigs == null) {
                    altConfigs = new ArrayList<Configuration>();
                    alternativeConfigurations.put(offeringId, altConfigs);
                }
                altConfigs.add(config);
                config.setAltConfigurations(altConfigs);
            }
        }
        this.iProgress.setPhase("Creating variables ...", root.element("classes").elements("class").size());
        HashMap<String, Element> classElements = new HashMap<String, Element>();
        HashMap<String, Lecture> lectures = new HashMap<String, Lecture>();
        HashMap<Lecture, Placement> assignedPlacements = new HashMap<Lecture, Placement>();
        HashMap<Lecture, String> parents = new HashMap<Lecture, String>();
        int ord = 0;
        Iterator i1 = root.element("classes").elementIterator("class");
        while (i1.hasNext()) {
            String parent;
            Element classEl = (Element)i1.next();
            Configuration config = null;
            if (classEl.attributeValue("config") != null) {
                config = (Configuration)configs.get(Long.valueOf(classEl.attributeValue("config")));
            }
            if (config == null && classEl.attributeValue("offering") != null) {
                Long offeringId = Long.valueOf(classEl.attributeValue("offering"));
                Long configId = Long.valueOf(classEl.attributeValue("config"));
                ArrayList<Configuration> altConfigs = (ArrayList<Configuration>)alternativeConfigurations.get(offeringId);
                if (altConfigs == null) {
                    altConfigs = new ArrayList<Configuration>();
                    alternativeConfigurations.put(offeringId, altConfigs);
                }
                for (Configuration configuration : altConfigs) {
                    if (!configuration.getConfigId().equals(configId)) continue;
                    config = configuration;
                    break;
                }
                if (config == null) {
                    config = new Configuration(offeringId, configId, -1);
                    altConfigs.add(config);
                    config.setAltConfigurations(altConfigs);
                    configs.put(config.getConfigId(), config);
                }
            }
            DatePattern defaultDatePattern = new DatePattern();
            if (classEl.attributeValue("dates") == null) {
                int startDay = Integer.parseInt(classEl.attributeValue("startDay", "0"));
                int endDay = Integer.parseInt(classEl.attributeValue("endDay", "1"));
                defaultDatePattern.setPattern(startDay, endDay);
                defaultDatePattern.setName(sDF.format(TimetableXMLLoader.getDate(((TimetableModel)this.getModel()).getYear(), startDay)) + "-" + sDF.format(TimetableXMLLoader.getDate(((TimetableModel)this.getModel()).getYear(), endDay)));
            } else {
                defaultDatePattern.setId(classEl.attributeValue("datePattern") == null ? null : Long.valueOf(classEl.attributeValue("datePattern")));
                defaultDatePattern.setName(classEl.attributeValue("datePatternName"));
                defaultDatePattern.setPattern(classEl.attributeValue("dates"));
            }
            Hashtable<Long, DatePattern> datePatterns = new Hashtable<Long, DatePattern>();
            Iterator i22 = classEl.elementIterator("date");
            while (i22.hasNext()) {
                Element element = (Element)i22.next();
                Long l = Long.valueOf(element.attributeValue("id"));
                datePatterns.put(l, new DatePattern(l, element.attributeValue("name"), element.attributeValue("pattern")));
            }
            classElements.put(classEl.attributeValue("id"), classEl);
            ArrayList<InstructorConstraint> ics = new ArrayList<InstructorConstraint>();
            Iterator iterator = classEl.elementIterator("instructor");
            while (iterator.hasNext()) {
                Element element = (Element)iterator.next();
                InstructorConstraint instructorConstraint = (InstructorConstraint)instructorConstraints.get(element.attributeValue("id"));
                if (instructorConstraint == null) {
                    instructorConstraint = new InstructorConstraint(Long.valueOf(element.attributeValue("id")), element.attributeValue("puid"), element.attributeValue("name") != null ? element.attributeValue("name") : "i" + element.attributeValue("id"), "true".equals(element.attributeValue("ignDist")));
                    instructorConstraints.put(element.attributeValue("id"), instructorConstraint);
                    ((TimetableModel)this.getModel()).addConstraint(instructorConstraint);
                }
                ics.add(instructorConstraint);
            }
            ArrayList<RoomLocation> arrayList = new ArrayList<RoomLocation>();
            ArrayList<RoomConstraint> arrayList2 = new ArrayList<RoomConstraint>();
            ArrayList<RoomLocation> initialRoomLocations = new ArrayList<RoomLocation>();
            ArrayList<RoomLocation> assignedRoomLocations = new ArrayList<RoomLocation>();
            ArrayList<RoomLocation> bestRoomLocations = new ArrayList<RoomLocation>();
            Iterator i24 = classEl.elementIterator("room");
            while (i24.hasNext()) {
                Element roomLocationEl = (Element)i24.next();
                Element roomEl = (Element)roomElements.get(roomLocationEl.attributeValue("id"));
                RoomConstraint roomConstraint = (RoomConstraint)roomConstraints.get(roomLocationEl.attributeValue("id"));
                Long roomId = null;
                String roomName = null;
                Long bldgId = null;
                if (roomConstraint != null) {
                    arrayList2.add(roomConstraint);
                    roomId = roomConstraint.getResourceId();
                    roomName = roomConstraint.getRoomName();
                    bldgId = roomConstraint.getBuildingId();
                } else {
                    roomId = Long.valueOf(roomEl.attributeValue("id"));
                    roomName = roomEl.attributeValue("name") != null ? roomEl.attributeValue("name") : "r" + roomEl.attributeValue("id");
                    bldgId = roomEl.attributeValue("building") == null ? null : Long.valueOf(roomEl.attributeValue("building"));
                }
                boolean ignoreTooFar = false;
                if ("true".equals(roomEl.attributeValue("ignoreTooFar"))) {
                    ignoreTooFar = true;
                }
                Double posX = null;
                Double posY = null;
                if (roomEl.attributeValue("location") != null) {
                    String loc = roomEl.attributeValue("location");
                    posX = Double.valueOf(loc.substring(0, loc.indexOf(44)));
                    posY = Double.valueOf(loc.substring(loc.indexOf(44) + 1));
                }
                RoomLocation rl = new RoomLocation(roomId, roomName, bldgId, Integer.parseInt(roomLocationEl.attributeValue("pref")), Integer.parseInt(roomEl.attributeValue("capacity")), posX, posY, ignoreTooFar, roomConstraint);
                if ("true".equals(roomLocationEl.attributeValue("initial"))) {
                    initialRoomLocations.add(rl);
                }
                if ("true".equals(roomLocationEl.attributeValue("solution"))) {
                    assignedRoomLocations.add(rl);
                }
                if ("true".equals(roomLocationEl.attributeValue("best"))) {
                    bestRoomLocations.add(rl);
                }
                arrayList.add(rl);
            }
            ArrayList<TimeLocation> timeLocations = new ArrayList<TimeLocation>();
            TimeLocation initialTimeLocation = null;
            TimeLocation assignedTimeLocation = null;
            TimeLocation bestTimeLocation = null;
            TimeLocation prohibitedTime = (TimeLocation)perts.get(Long.valueOf(classEl.attributeValue("id")));
            Iterator i25 = classEl.elementIterator("time");
            while (i25.hasNext()) {
                TimeLocation tl;
                Element timeLocationEl = (Element)i25.next();
                DatePattern dp = defaultDatePattern;
                if (timeLocationEl.attributeValue("date") != null) {
                    dp = (DatePattern)datePatterns.get(Long.valueOf(timeLocationEl.attributeValue("date")));
                }
                if ((tl = new TimeLocation(Integer.parseInt(timeLocationEl.attributeValue("days"), 2), Integer.parseInt(timeLocationEl.attributeValue("start")), Integer.parseInt(timeLocationEl.attributeValue("length")), (int)Double.parseDouble(timeLocationEl.attributeValue("pref")), Double.parseDouble(timeLocationEl.attributeValue("npref", timeLocationEl.attributeValue("pref"))), Integer.parseInt(timeLocationEl.attributeValue("datePref", "0")), dp.getId(), dp.getName(), dp.getPattern(), Integer.parseInt(timeLocationEl.attributeValue("breakTime") == null ? "-1" : timeLocationEl.attributeValue("breakTime")))).getBreakTime() < 0) {
                    tl.setBreakTime(tl.getLength() == 18 ? 15 : 10);
                }
                if (timeLocationEl.attributeValue("pattern") != null) {
                    tl.setTimePatternId(Long.valueOf(timeLocationEl.attributeValue("pattern")));
                }
                if (prohibitedTime != null && prohibitedTime.getDayCode() == tl.getDayCode() && prohibitedTime.getStartSlot() == tl.getStartSlot() && prohibitedTime.getLength() == tl.getLength()) {
                    sLogger.info("Time " + tl.getLongName(true) + " is prohibited for class " + classEl.attributeValue("id"));
                    continue;
                }
                if ("true".equals(timeLocationEl.attributeValue("solution"))) {
                    assignedTimeLocation = tl;
                }
                if ("true".equals(timeLocationEl.attributeValue("initial"))) {
                    initialTimeLocation = tl;
                }
                if ("true".equals(timeLocationEl.attributeValue("best"))) {
                    bestTimeLocation = tl;
                }
                timeLocations.add(tl);
            }
            if (timeLocations.isEmpty()) {
                sLogger.error("  ERROR: No time.");
                continue;
            }
            int minClassLimit = 0;
            int maxClassLimit = 0;
            float room2limitRatio = 1.0f;
            if (!"true".equals(classEl.attributeValue("committed"))) {
                if (classEl.attributeValue("expectedCapacity") != null) {
                    minClassLimit = maxClassLimit = Integer.parseInt(classEl.attributeValue("expectedCapacity"));
                    int roomCapacity = Integer.parseInt(classEl.attributeValue("roomCapacity", classEl.attributeValue("expectedCapacity")));
                    if (minClassLimit == 0) {
                        minClassLimit = maxClassLimit = roomCapacity;
                    }
                    room2limitRatio = minClassLimit == 0 ? 1.0f : (float)roomCapacity / (float)minClassLimit;
                } else {
                    if (classEl.attribute("classLimit") != null) {
                        minClassLimit = maxClassLimit = Integer.parseInt(classEl.attributeValue("classLimit"));
                    } else {
                        minClassLimit = Integer.parseInt(classEl.attributeValue("minClassLimit"));
                        maxClassLimit = Integer.parseInt(classEl.attributeValue("maxClassLimit"));
                    }
                    room2limitRatio = Float.parseFloat(classEl.attributeValue("roomToLimitRatio", "1.0"));
                }
            }
            Lecture lecture2 = new Lecture(Long.valueOf(classEl.attributeValue("id")), classEl.attributeValue("solverGroup") != null ? Long.valueOf(classEl.attributeValue("solverGroup")) : null, Long.valueOf(classEl.attributeValue("subpart", classEl.attributeValue("course", "-1"))), classEl.attributeValue("name") != null ? classEl.attributeValue("name") : "c" + classEl.attributeValue("id"), timeLocations, arrayList, Integer.parseInt(classEl.attributeValue("nrRooms", arrayList.isEmpty() ? "0" : "1")), null, minClassLimit, maxClassLimit, room2limitRatio);
            lecture2.setNote(classEl.attributeValue("note"));
            if ("true".equals(classEl.attributeValue("committed"))) {
                lecture2.setCommitted(true);
            }
            if (!lecture2.isCommitted() && classEl.attributeValue("ord") != null) {
                lecture2.setOrd(Integer.parseInt(classEl.attributeValue("ord")));
            } else {
                lecture2.setOrd(ord++);
            }
            lecture2.setWeight(Double.parseDouble(classEl.attributeValue("weight", "1.0")));
            if (lecture2.getNrRooms() > 1) {
                lecture2.setMaxRoomCombinations(Integer.parseInt(classEl.attributeValue("maxRoomCombinations", "-1")));
            }
            if (config != null) {
                lecture2.setConfiguration(config);
            }
            if (initialTimeLocation != null && initialRoomLocations.size() == lecture2.getNrRooms()) {
                lecture2.setInitialAssignment(new Placement(lecture2, initialTimeLocation, initialRoomLocations));
            }
            if (assignedTimeLocation != null && assignedRoomLocations.size() == lecture2.getNrRooms()) {
                assignedPlacements.put(lecture2, new Placement(lecture2, assignedTimeLocation, assignedRoomLocations));
            } else if (lecture2.getInitialAssignment() != null) {
                assignedPlacements.put(lecture2, (Placement)lecture2.getInitialAssignment());
            }
            if (bestTimeLocation != null && bestRoomLocations.size() == lecture2.getNrRooms()) {
                lecture2.setBestAssignment(new Placement(lecture2, bestTimeLocation, bestRoomLocations), 0L);
            } else if (assignedTimeLocation != null && assignedRoomLocations.size() == lecture2.getNrRooms()) {
                lecture2.setBestAssignment((Value)assignedPlacements.get(lecture2), 0L);
            }
            lectures.put(classEl.attributeValue("id"), lecture2);
            if (classEl.attributeValue("department") != null) {
                lecture2.setDepartment(Long.valueOf(classEl.attributeValue("department")));
            }
            if (classEl.attribute("scheduler") != null) {
                lecture2.setScheduler(Long.valueOf(classEl.attributeValue("scheduler")));
            }
            if ((sectionWholeCourse || !lecture2.isCommitted()) && classEl.attributeValue("subpart", classEl.attributeValue("course")) != null) {
                Long subpartId = Long.valueOf(classEl.attributeValue("subpart", classEl.attributeValue("course")));
                ArrayList<Lecture> sames = (ArrayList<Lecture>)sameLectures.get(subpartId);
                if (sames == null) {
                    sames = new ArrayList<Lecture>();
                    sameLectures.put(subpartId, sames);
                }
                sames.add(lecture2);
            }
            if ((parent = classEl.attributeValue("parent")) != null) {
                parents.put(lecture2, parent);
            }
            ((TimetableModel)this.getModel()).addVariable(lecture2);
            if (lecture2.isCommitted()) {
                Placement placement2 = (Placement)assignedPlacements.get(lecture2);
                if (classEl.attribute("assignment") != null) {
                    placement2.setAssignmentId(Long.valueOf(classEl.attributeValue("assignment")));
                }
                for (InstructorConstraint ic : ics) {
                    ic.setNotAvailable(placement2);
                }
                for (RoomConstraint rc : arrayList2) {
                    rc.setNotAvailable(placement2);
                }
            } else {
                for (InstructorConstraint ic : ics) {
                    ic.addVariable(lecture2);
                }
                for (RoomConstraint rc : arrayList2) {
                    rc.addVariable(lecture2);
                }
            }
            this.iProgress.incProgress();
        }
        for (Map.Entry entry : parents.entrySet()) {
            Lecture lecture3 = (Lecture)entry.getKey();
            Lecture parent = (Lecture)lectures.get(entry.getValue());
            if (parent == null) {
                this.iProgress.warn("Parent class " + (String)entry.getValue() + " does not exists.");
                continue;
            }
            lecture3.setParent(parent);
        }
        this.iProgress.setPhase("Creating constraints ...", root.element("groupConstraints").elements("constraint").size());
        HashMap<String, Element> grConstraintElements = new HashMap<String, Element>();
        HashMap<String, Constraint> groupConstraints = new HashMap<String, Constraint>();
        Iterator i12 = root.element("groupConstraints").elementIterator("constraint");
        while (i12.hasNext()) {
            Element grConstraintEl = (Element)i12.next();
            Constraint c = null;
            if ("SPREAD".equals(grConstraintEl.attributeValue("type"))) {
                c = new SpreadConstraint(((TimetableModel)this.getModel()).getProperties(), grConstraintEl.attributeValue("name", "spread"));
            } else if ("MIN_ROOM_USE".equals(grConstraintEl.attributeValue("type"))) {
                c = new MinimizeNumberOfUsedRoomsConstraint(((TimetableModel)this.getModel()).getProperties());
            } else if ("CLASS_LIMIT".equals(grConstraintEl.attributeValue("type"))) {
                if (grConstraintEl.element("parentClass") == null) {
                    c = new ClassLimitConstraint(Integer.parseInt(grConstraintEl.attributeValue("courseLimit")), grConstraintEl.attributeValue("name", "class-limit"));
                } else {
                    String classId = grConstraintEl.element("parentClass").attributeValue("id");
                    c = new ClassLimitConstraint((Lecture)lectures.get(classId), grConstraintEl.attributeValue("name", "class-limit"));
                }
                if (grConstraintEl.attributeValue("delta") != null) {
                    ((ClassLimitConstraint)c).setClassLimitDelta(Integer.parseInt(grConstraintEl.attributeValue("delta")));
                }
            } else if ("MIN_GRUSE(10x1h)".equals(grConstraintEl.attributeValue("type"))) {
                c = new MinimizeNumberOfUsedGroupsOfTime(((TimetableModel)this.getModel()).getProperties(), "10x1h", MinimizeNumberOfUsedGroupsOfTime.sGroups10of1h);
            } else if ("MIN_GRUSE(5x2h)".equals(grConstraintEl.attributeValue("type"))) {
                c = new MinimizeNumberOfUsedGroupsOfTime(((TimetableModel)this.getModel()).getProperties(), "5x2h", MinimizeNumberOfUsedGroupsOfTime.sGroups5of2h);
            } else if ("MIN_GRUSE(3x3h)".equals(grConstraintEl.attributeValue("type"))) {
                c = new MinimizeNumberOfUsedGroupsOfTime(((TimetableModel)this.getModel()).getProperties(), "3x3h", MinimizeNumberOfUsedGroupsOfTime.sGroups3of3h);
            } else if ("MIN_GRUSE(2x5h)".equals(grConstraintEl.attributeValue("type"))) {
                c = new MinimizeNumberOfUsedGroupsOfTime(((TimetableModel)this.getModel()).getProperties(), "2x5h", MinimizeNumberOfUsedGroupsOfTime.sGroups2of5h);
            } else if ("NO_CONFLICT".equals(grConstraintEl.attributeValue("type"))) {
                c = new IgnoreStudentConflictsConstraint();
            } else {
                try {
                    FlexibleConstraint.FlexibleConstraintType f = FlexibleConstraint.FlexibleConstraintType.valueOf(grConstraintEl.attributeValue("type"));
                    try {
                        c = f.create(Long.valueOf(grConstraintEl.attributeValue("id")), grConstraintEl.attributeValue("owner"), grConstraintEl.attributeValue("pref"), grConstraintEl.attributeValue("reference"));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.iProgress.warn("Failed to create flexible constraint " + grConstraintEl.attributeValue("type") + ": " + illegalArgumentException.getMessage(), illegalArgumentException);
                        continue;
                    }
                }
                catch (IllegalArgumentException e) {
                    c = new GroupConstraint(Long.valueOf(grConstraintEl.attributeValue("id")), GroupConstraint.ConstraintType.get(grConstraintEl.attributeValue("type")), grConstraintEl.attributeValue("pref"));
                }
            }
            ((TimetableModel)this.getModel()).addConstraint(c);
            Iterator i22 = grConstraintEl.elementIterator("class");
            while (i22.hasNext()) {
                String string = ((Element)i22.next()).attributeValue("id");
                Lecture lecture2 = (Lecture)lectures.get(string);
                if (lecture2 != null) {
                    c.addVariable(lecture2);
                    continue;
                }
                this.iProgress.warn("Class " + string + " does not exists, but it is referred from group constraint " + c.getId() + " (" + c.getName() + ")");
            }
            grConstraintElements.put(grConstraintEl.attributeValue("id"), grConstraintEl);
            groupConstraints.put(grConstraintEl.attributeValue("id"), c);
            this.iProgress.incProgress();
        }
        this.iProgress.setPhase("Loading students ...", root.element("students").elements("student").size());
        boolean initialSectioning = true;
        HashMap<Long, Student> students = new HashMap<Long, Student>();
        HashMap<Long, HashSet<Student>> offering2students = new HashMap<Long, HashSet<Student>>();
        Iterator i13 = root.element("students").elementIterator("student");
        while (i13.hasNext()) {
            String classId;
            Element element = (Element)i13.next();
            ArrayList<Lecture> arrayList = new ArrayList<Lecture>();
            Long studentId = Long.valueOf(element.attributeValue("id"));
            Student student = (Student)students.get(studentId);
            if (student == null) {
                student = new Student(studentId);
                students.put(studentId, student);
                ((TimetableModel)this.getModel()).addStudent(student);
            }
            student.setAcademicArea(element.attributeValue("area"));
            student.setAcademicClassification(element.attributeValue("classification"));
            student.setMajor(element.attributeValue("major"));
            student.setCurriculum(element.attributeValue("curriculum"));
            i2 = element.elementIterator("offering");
            while (i2.hasNext()) {
                Element ofEl = (Element)i2.next();
                Long offeringId = Long.valueOf(ofEl.attributeValue("id"));
                String priority = ofEl.attributeValue("priority");
                student.addOffering(offeringId, Double.parseDouble(ofEl.attributeValue("weight", "1.0")), priority == null ? null : Double.valueOf(priority));
                HashSet<Student> studentsThisOffering = (HashSet<Student>)offering2students.get(offeringId);
                if (studentsThisOffering == null) {
                    studentsThisOffering = new HashSet<Student>();
                    offering2students.put(offeringId, studentsThisOffering);
                }
                studentsThisOffering.add(student);
            }
            i2 = element.elementIterator("class");
            while (i2.hasNext()) {
                classId = ((Element)i2.next()).attributeValue("id");
                Lecture lecture4 = (Lecture)lectures.get(classId);
                if (lecture4 == null) {
                    this.iProgress.warn("Class " + classId + " does not exists, but it is referred from student " + student.getId());
                    continue;
                }
                if (lecture4.isCommitted()) {
                    if (sectionWholeCourse && (lecture4.getParent() != null || lecture4.getConfiguration() != null)) {
                        student.addLecture(lecture4);
                        student.addConfiguration(lecture4.getConfiguration());
                        lecture4.addStudent(this.getAssignment(), student);
                        arrayList.add(lecture4);
                        initialSectioning = false;
                        continue;
                    }
                    Placement placement3 = (Placement)assignedPlacements.get(lecture4);
                    student.addCommitedPlacement(placement3);
                    continue;
                }
                student.addLecture(lecture4);
                student.addConfiguration(lecture4.getConfiguration());
                lecture4.addStudent(this.getAssignment(), student);
                arrayList.add(lecture4);
                initialSectioning = false;
            }
            i2 = element.elementIterator("prohibited-class");
            while (i2.hasNext()) {
                classId = ((Element)i2.next()).attributeValue("id");
                Lecture lecture3 = (Lecture)lectures.get(classId);
                if (lecture3 != null) {
                    student.addCanNotEnroll(lecture3);
                    continue;
                }
                this.iProgress.warn("Class " + classId + " does not exists, but it is referred from student " + student.getId());
            }
            if (element.attributeValue("instructor") != null) {
                student.setInstructor((InstructorConstraint)instructorConstraints.get(element.attributeValue("instructor")));
            }
            this.iProgress.incProgress();
        }
        if (root.element("groups") != null) {
            this.iProgress.setPhase("Loading student groups ...", root.element("groups").elements("group").size());
            Iterator i14 = root.element("groups").elementIterator("group");
            while (i14.hasNext()) {
                Element element = (Element)i14.next();
                long l = Long.parseLong(element.attributeValue("id"));
                StudentGroup group = new StudentGroup(l, Double.parseDouble(element.attributeValue("weight", "1.0")), element.attributeValue("name", "Group-" + l));
                ((TimetableModel)this.getModel()).addStudentGroup(group);
                i2 = element.elementIterator("student");
                while (i2.hasNext()) {
                    Element studentEl = (Element)i2.next();
                    Student student = (Student)students.get(Long.valueOf(studentEl.attributeValue("id")));
                    if (student == null) continue;
                    group.addStudent(student);
                    student.addGroup(group);
                }
            }
        }
        for (List list : sameLectures.values()) {
            for (Lecture lect : list) {
                lect.setSameSubpartLectures(list);
            }
        }
        if (initialSectioning) {
            this.iProgress.setPhase("Initial sectioning ...", offering2students.size());
            for (Map.Entry entry : offering2students.entrySet()) {
                Long l = (Long)entry.getKey();
                Set studentsThisOffering = (Set)entry.getValue();
                List altConfigs = (List)alternativeConfigurations.get(l);
                ((TimetableModel)this.getModel()).getStudentSectioning().initialSectioning(this.getAssignment(), l, String.valueOf(l), studentsThisOffering, altConfigs);
                this.iProgress.incProgress();
            }
            for (Student student : students.values()) {
                student.clearDistanceCache();
                if (student.getInstructor() == null) continue;
                for (Lecture lecture5 : student.getInstructor().variables()) {
                    student.addLecture(lecture5);
                    student.addConfiguration(lecture5.getConfiguration());
                    lecture5.addStudent(this.getAssignment(), student);
                }
            }
        }
        this.iProgress.setPhase("Computing jenrl ...", students.size());
        HashMap jenrls = new HashMap();
        for (Student student : students.values()) {
            for (Lecture l1 : student.getLectures()) {
                for (Lecture l2 : student.getLectures()) {
                    JenrlConstraint jenrl;
                    if (l1.getId() >= l2.getId()) continue;
                    HashMap<Lecture, JenrlConstraint> x = (HashMap<Lecture, JenrlConstraint>)jenrls.get(l1);
                    if (x == null) {
                        x = new HashMap<Lecture, JenrlConstraint>();
                        jenrls.put(l1, x);
                    }
                    if ((jenrl = (JenrlConstraint)x.get(l2)) == null) {
                        jenrl = new JenrlConstraint();
                        jenrl.addVariable(l1);
                        jenrl.addVariable(l2);
                        ((TimetableModel)this.getModel()).addConstraint(jenrl);
                        x.put(l2, jenrl);
                    }
                    jenrl.incJenrl(this.getAssignment(), student);
                }
            }
            this.iProgress.incProgress();
        }
        if (this.iDeptBalancing) {
            this.iProgress.setPhase("Creating dept. spread constraints ...", ((TimetableModel)this.getModel()).variables().size());
            HashMap<Long, DepartmentSpreadConstraint> hashMap = new HashMap<Long, DepartmentSpreadConstraint>();
            for (Lecture lecture4 : ((TimetableModel)this.getModel()).variables()) {
                if (lecture4.getDepartment() == null) continue;
                DepartmentSpreadConstraint deptConstr = (DepartmentSpreadConstraint)hashMap.get(lecture4.getDepartment());
                if (deptConstr == null) {
                    String name = (String)depts.get(lecture4.getDepartment());
                    deptConstr = new DepartmentSpreadConstraint(((TimetableModel)this.getModel()).getProperties(), lecture4.getDepartment(), name != null ? name : "d" + lecture4.getDepartment());
                    hashMap.put(lecture4.getDepartment(), deptConstr);
                    ((TimetableModel)this.getModel()).addConstraint(deptConstr);
                }
                deptConstr.addVariable(lecture4);
                this.iProgress.incProgress();
            }
        }
        if (((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("General.PurgeInvalidPlacements", true)) {
            this.iProgress.setPhase("Purging invalid placements ...", ((TimetableModel)this.getModel()).variables().size());
            for (Lecture lecture5 : ((TimetableModel)this.getModel()).variables()) {
                lecture5.purgeInvalidValues(this.iInteractiveMode);
                this.iProgress.incProgress();
            }
        }
        if (((TimetableModel)this.getModel()).hasConstantVariables() && ((TimetableModel)this.getModel()).constantVariables().size() > 0) {
            this.iProgress.setPhase("Assigning committed classes ...", assignedPlacements.size());
            for (Map.Entry entry : assignedPlacements.entrySet()) {
                lecture4 = (Lecture)entry.getKey();
                placement = (Placement)entry.getValue();
                if (!lecture4.isCommitted()) {
                    this.iProgress.incProgress();
                    continue;
                }
                lecture4.setConstantValue(placement);
                ((TimetableModel)this.getModel()).weaken(this.getAssignment(), placement);
                conflictConstraints = ((TimetableModel)this.getModel()).conflictConstraints(this.getAssignment(), placement);
                if (conflictConstraints.isEmpty()) {
                    this.getAssignment().assign(0L, placement);
                } else {
                    sLogger.warn("WARNING: Unable to assign " + lecture4.getName() + " := " + placement.getName());
                    sLogger.debug("  Reason:");
                    for (Constraint c : conflictConstraints.keySet()) {
                        vals = conflictConstraints.get(c);
                        for (Placement v : vals) {
                            sLogger.debug("    " + ((Lecture)v.variable()).getName() + " = " + v.getName());
                        }
                        sLogger.debug("    in constraint " + c);
                    }
                }
                this.iProgress.incProgress();
            }
        }
        if (currentSolution != null) {
            this.iProgress.setPhase("Creating best assignment ...", 2 * ((TimetableModel)this.getModel()).variables().size());
            for (Lecture lecture6 : ((TimetableModel)this.getModel()).variables()) {
                this.iProgress.incProgress();
                Placement placement4 = (Placement)lecture6.getBestAssignment();
                if (placement4 == null) continue;
                ((TimetableModel)this.getModel()).weaken(this.getAssignment(), placement4);
                this.getAssignment().assign(0L, placement4);
            }
            currentSolution.saveBest();
            for (Lecture lecture7 : ((TimetableModel)this.getModel()).variables()) {
                this.iProgress.incProgress();
                this.getAssignment().unassign(0L, lecture7);
            }
        }
        this.iProgress.setPhase("Creating initial assignment ...", assignedPlacements.size());
        for (Map.Entry entry : assignedPlacements.entrySet()) {
            lecture4 = (Lecture)entry.getKey();
            placement = (Placement)entry.getValue();
            if (lecture4.isCommitted()) {
                this.iProgress.incProgress();
                continue;
            }
            ((TimetableModel)this.getModel()).weaken(this.getAssignment(), placement);
            conflictConstraints = ((TimetableModel)this.getModel()).conflictConstraints(this.getAssignment(), placement);
            if (conflictConstraints.isEmpty()) {
                if (!placement.isValid()) {
                    sLogger.warn("WARNING: Lecture " + lecture4.getName() + " does not contain assignment " + placement.getLongName(true) + " in its domain (" + placement.getNotValidReason(this.getAssignment(), true) + ").");
                } else {
                    this.getAssignment().assign(0L, placement);
                }
            } else {
                sLogger.warn("WARNING: Unable to assign " + lecture4.getName() + " := " + placement.getName());
                sLogger.debug("  Reason:");
                for (Constraint c : conflictConstraints.keySet()) {
                    vals = conflictConstraints.get(c);
                    for (Placement v : vals) {
                        sLogger.debug("    " + ((Lecture)v.variable()).getName() + " = " + v.getName());
                    }
                    sLogger.debug("    in constraint " + c);
                }
            }
            this.iProgress.incProgress();
        }
        if (initialSectioning && this.getAssignment().nrAssignedVariables() != 0 && !((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("Global.LoadStudentEnrlsFromSolution", false)) {
            ((TimetableModel)this.getModel()).switchStudents(this.getAssignment());
        }
        if (this.iForcedPerturbances > 0) {
            void var24_79;
            this.iProgress.setPhase("Forcing perturbances", this.iForcedPerturbances);
            boolean bl = false;
            while (var24_79 < this.iForcedPerturbances) {
                Lecture lecture8;
                this.iProgress.setProgress((long)var24_79);
                Object var25_102 = null;
                while ((lecture8 = (Lecture)ToolBox.random(((TimetableModel)this.getModel()).variables())).getInitialAssignment() == null || lecture8.values(this.getAssignment()).size() <= 1) {
                }
                lecture8.removeInitialValue();
                ++var24_79;
            }
        }
    }

    public static Date getDate(int year, int dayOfYear) {
        Calendar c = Calendar.getInstance(Locale.US);
        c.set(year, 1, 1, 0, 0, 0);
        c.set(6, dayOfYear);
        return c.getTime();
    }

    public static class DatePattern {
        Long iId;
        String iName;
        BitSet iPattern;

        public DatePattern() {
        }

        public DatePattern(Long id, String name, BitSet pattern) {
            this.setId(id);
            this.setName(name);
            this.setPattern(pattern);
        }

        public DatePattern(Long id, String name, String pattern) {
            this.setId(id);
            this.setName(name);
            this.setPattern(pattern);
        }

        public Long getId() {
            return this.iId;
        }

        public void setId(Long id) {
            this.iId = id;
        }

        public String getName() {
            return this.iName;
        }

        public void setName(String name) {
            this.iName = name;
        }

        public BitSet getPattern() {
            return this.iPattern;
        }

        public void setPattern(BitSet pattern) {
            this.iPattern = pattern;
        }

        public void setPattern(String pattern) {
            this.iPattern = new BitSet(pattern.length());
            for (int i = 0; i < pattern.length(); ++i) {
                if (pattern.charAt(i) != '1') continue;
                this.iPattern.set(i);
            }
        }

        public void setPattern(int startDay, int endDay) {
            this.iPattern = new BitSet(366);
            for (int d = startDay; d <= endDay; ++d) {
                this.iPattern.set(d);
            }
        }
    }
}

