/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.util.queue;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.activation.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.blocks.mux.MuxRpcDispatcher;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.solver.jgroups.SolverServerImplementation;
import org.unitime.timetable.util.queue.ByteArrayDataSource;
import org.unitime.timetable.util.queue.LocalQueueProcessor;
import org.unitime.timetable.util.queue.QueueItem;

public class RemoteQueueProcessor
extends LocalQueueProcessor {
    private static Log sLog = LogFactory.getLog(RemoteQueueProcessor.class);
    private RpcDispatcher iDispatcher;

    public RemoteQueueProcessor(JChannel channel, short scope) {
        this.iDispatcher = new MuxRpcDispatcher(scope, (Channel)channel, null, null, (Object)this);
        sInstance = this;
        this.start();
    }

    public RpcDispatcher getDispatcher() {
        return this.iDispatcher;
    }

    public String generateId() {
        String id;
        block2: while (true) {
            if (this.get(id = UUID.randomUUID().toString()) != null) {
                continue;
            }
            try {
                RspList ret = this.iDispatcher.callRemoteMethods(null, "invoke", new Object[]{"get", new Class[]{String.class}, new Object[]{id}}, new Class[]{String.class, Class[].class, Object[].class}, SolverServerImplementation.sAllResponses);
                for (Rsp rsp : ret) {
                    if (rsp == null || rsp.getValue() == null) continue;
                    continue block2;
                }
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
                break;
            }
        }
        return id;
    }

    public QueueItem add(QueueItem item) {
        item.setAddress(this.iDispatcher.getChannel().getAddress());
        item.setId(this.generateId());
        return super.add(item);
    }

    public DataSource getFile(String id) {
        try {
            DataSource ds = super.getFile(id);
            return ds == null ? null : new ByteArrayDataSource(ds);
        }
        catch (IOException e) {
            sLog.error((Object)("Failed to create data source: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(String method, Class[] types, Object[] args) throws Exception {
        Object object;
        try {
            object = this.getClass().getMethod(method, types).invoke((Object)this, args);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            _RootDAO.closeCurrentThreadSessions();
            throw throwable;
        }
        _RootDAO.closeCurrentThreadSessions();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object dispatch(Address address, Method method, Object[] args) throws Exception {
        Iterator iterator;
        block15: {
            Object object;
            block14: {
                List list;
                block13: {
                    Object object2;
                    block12: {
                        try {
                            try {
                                if ("add".equals(method.getName())) {
                                    object2 = method.invoke((Object)this, args);
                                    Object var10_8 = null;
                                    break block12;
                                }
                                if ("getItems".equals(method.getName())) {
                                    List items = (List)method.invoke((Object)this, args);
                                    if (this.iDispatcher.getChannel().getView().getMembers().size() > 1) {
                                        ArrayList other = new ArrayList(this.iDispatcher.getChannel().getView().getMembers());
                                        other.remove(this.iDispatcher.getChannel().getAddress());
                                        RspList ret = this.iDispatcher.callRemoteMethods(other, "invoke", new Object[]{method.getName(), method.getParameterTypes(), args}, new Class[]{String.class, Class[].class, Object[].class}, SolverServerImplementation.sAllResponses);
                                        for (Rsp rsp : ret) {
                                            if (rsp != null && rsp.getValue() != null) {
                                                items.addAll((Collection)rsp.getValue());
                                            }
                                            if (rsp == null || !rsp.hasException()) continue;
                                            sLog.error((Object)("Excution of queue processor method " + method + " failed: " + rsp.getException().getMessage()), rsp.getException());
                                        }
                                        Collections.sort(items);
                                    }
                                    list = items;
                                    break block13;
                                }
                                RspList ret = this.iDispatcher.callRemoteMethods(null, "invoke", new Object[]{method.getName(), method.getParameterTypes(), args}, new Class[]{String.class, Class[].class, Object[].class}, SolverServerImplementation.sAllResponses);
                                for (Rsp rsp : ret) {
                                    if (rsp != null && rsp.getValue() != null) {
                                        object = rsp.getValue();
                                        break block14;
                                    }
                                    if (rsp == null || !rsp.hasException()) continue;
                                    sLog.error((Object)("Excution of queue processor method " + method + " failed: " + rsp.getException().getMessage()), rsp.getException());
                                }
                                iterator = null;
                                break block15;
                            }
                            catch (Exception e) {
                                sLog.error((Object)("Excution of queue processor method " + method + " failed: " + e.getMessage()), (Throwable)e);
                                Object var5_16 = null;
                                Object var10_12 = null;
                                _RootDAO.closeCurrentThreadSessions();
                                return var5_16;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var10_13 = null;
                            _RootDAO.closeCurrentThreadSessions();
                            throw throwable;
                        }
                    }
                    _RootDAO.closeCurrentThreadSessions();
                    return object2;
                }
                Object var10_9 = null;
                _RootDAO.closeCurrentThreadSessions();
                return list;
            }
            Object var10_10 = null;
            _RootDAO.closeCurrentThreadSessions();
            return object;
        }
        Object var10_11 = null;
        _RootDAO.closeCurrentThreadSessions();
        return iterator;
    }
}

