/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.util.queue;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Date;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.unitime.timetable.util.Formats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueMessage
implements Serializable,
Comparable<QueueMessage> {
    private static final long serialVersionUID = 1L;
    private Level iLevel = Level.INFO;
    private String iMessage;
    private Date iDate = null;
    private String iError = null;

    public QueueMessage(Level level, String message) {
        this.iLevel = level;
        this.iMessage = message;
        this.iDate = new Date();
    }

    public QueueMessage(Level level, Object message) {
        this(level, message == null ? "" : message.toString());
    }

    public QueueMessage(Level level, String message, Throwable error) {
        this(level, message);
        if (error != null) {
            StringWriter writer = new StringWriter();
            PrintWriter pw = new PrintWriter(writer);
            error.printStackTrace(new PrintWriter(writer));
            pw.flush();
            pw.close();
            this.iError = writer.toString();
        }
    }

    public QueueMessage(Level level, Object message, Throwable error) {
        this(level, message == null ? "" : message.toString(), error);
    }

    public Level getLevel() {
        return this.iLevel;
    }

    public String getMessage() {
        return this.iMessage;
    }

    public Date getDate() {
        return this.iDate;
    }

    public boolean hasError() {
        return this.iError != null && !this.iError.isEmpty();
    }

    public String getError() {
        return this.iError;
    }

    protected String formatMessagePlain() {
        Formats.Format<Date> df = Formats.getDateFormat(Formats.Pattern.DATE_TIME_STAMP);
        return df.format(this.getDate()) + " " + StringUtils.leftPad((String)this.getLevel().name(), (int)5) + " " + this.getMessage();
    }

    public String toString() {
        return this.formatMessagePlain() + (this.hasError() ? "\n" + this.getError() : "");
    }

    protected String formatMessageHTML() {
        switch (this.getLevel()) {
            case TRACE: {
                return "&nbsp;&nbsp;&nbsp;&nbsp;<i><font color='gray'> " + StringEscapeUtils.escapeHtml((String)this.getMessage()) + "</font></i>";
            }
            case DEBUG: {
                return "&nbsp;&nbsp;<i><font color='gray'> " + StringEscapeUtils.escapeHtml((String)this.getMessage()) + "</font></i>";
            }
            case INFO: {
                return "&nbsp;&nbsp;" + StringEscapeUtils.escapeHtml((String)this.getMessage());
            }
            case WARN: {
                return "<font color='orange'>" + StringEscapeUtils.escapeHtml((String)this.getMessage()) + "</font>";
            }
            case ERROR: {
                return "<font color='red'>" + StringEscapeUtils.escapeHtml((String)this.getMessage()) + "</font>";
            }
            case FATAL: {
                return "<font color='red'><b>" + StringEscapeUtils.escapeHtml((String)this.getMessage()) + "</b></font>";
            }
            case PROGRESS: {
                return "<b>" + StringEscapeUtils.escapeHtml((String)this.getMessage()) + "</b>";
            }
            case STAGE: {
                return "<b>" + StringEscapeUtils.escapeHtml((String)this.getMessage()) + "</b>";
            }
            case HTML: {
                return this.getMessage();
            }
        }
        return StringEscapeUtils.escapeHtml((String)this.getMessage());
    }

    public String toHTML() {
        return this.formatMessageHTML() + (this.hasError() ? "<br><font color='red'><pre>" + StringEscapeUtils.escapeHtml((String)this.getError()) + "</pre></font>" : "");
    }

    @Override
    public int compareTo(QueueMessage m) {
        return this.getDate().compareTo(m.getDate());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Level {
        TRACE,
        DEBUG,
        PROGRESS,
        INFO,
        STAGE,
        WARN,
        ERROR,
        FATAL,
        HTML;

    }
}

