/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.test;

import java.io.Serializable;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.StudentSectioningSaver;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.Subpart;
import org.hibernate.Transaction;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.SectioningInfo;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.StudentSectioningQueue;
import org.unitime.timetable.model.WaitList;
import org.unitime.timetable.model.dao.SessionDAO;

public class BatchStudentSectioningSaver
extends StudentSectioningSaver {
    private static Log sLog = LogFactory.getLog(BatchStudentSectioningSaver.class);
    private boolean iIncludeCourseDemands = true;
    private boolean iIncludeLastLikeStudents = true;
    private String iInitiative = null;
    private String iTerm = null;
    private String iYear = null;
    private Hashtable<Long, org.unitime.timetable.model.Student> iStudents = null;
    private Hashtable<Long, CourseOffering> iCourses = null;
    private Hashtable<Long, Class_> iClasses = null;
    private Hashtable<String, org.unitime.timetable.model.CourseRequest> iRequests = null;
    private int iInsert = 0;

    public BatchStudentSectioningSaver(Solver solver) {
        super(solver);
        this.iIncludeCourseDemands = solver.getProperties().getPropertyBoolean("Load.IncludeCourseDemands", this.iIncludeCourseDemands);
        this.iIncludeLastLikeStudents = solver.getProperties().getPropertyBoolean("Load.IncludeLastLikeStudents", this.iIncludeLastLikeStudents);
        this.iInitiative = solver.getProperties().getProperty("Data.Initiative");
        this.iYear = solver.getProperties().getProperty("Data.Year");
        this.iTerm = solver.getProperties().getProperty("Data.Term");
    }

    public void save() throws Exception {
        Session session = Session.getSessionUsingInitiativeYearTerm(this.iInitiative, this.iYear, this.iTerm);
        if (session == null) {
            throw new Exception("Session " + this.iInitiative + " " + this.iTerm + this.iYear + " not found!");
        }
        this.save(session);
    }

    public void flushIfNeeded(org.hibernate.Session hibSession) {
        ++this.iInsert;
        if (this.iInsert % 1000 == 0) {
            hibSession.flush();
            hibSession.clear();
        }
    }

    public void flush(org.hibernate.Session hibSession) {
        hibSession.flush();
        hibSession.clear();
        this.iInsert = 0;
    }

    public void saveStudent(org.hibernate.Session hibSession, Student student) {
        org.unitime.timetable.model.Student s = this.iStudents.get(student.getId());
        if (s == null) {
            sLog.warn((Object)("Student " + student.getId() + " not found."));
            return;
        }
        Iterator<Serializable> i = s.getClassEnrollments().iterator();
        while (i.hasNext()) {
            StudentClassEnrollment sce = i.next();
            hibSession.delete((Object)sce);
            i.remove();
        }
        i = s.getWaitlists().iterator();
        while (i.hasNext()) {
            WaitList wl = (WaitList)i.next();
            hibSession.delete((Object)wl);
            i.remove();
        }
        for (Request request : student.getRequests()) {
            Enrollment enrollment = (Enrollment)this.getAssignment().getValue((Variable)request);
            if (!(request instanceof CourseRequest)) continue;
            CourseRequest courseRequest = (CourseRequest)request;
            if (enrollment == null) {
                if (!courseRequest.isWaitlist() || !student.canAssign(this.getAssignment(), (Request)courseRequest)) continue;
                WaitList wl = new WaitList();
                wl.setStudent(s);
                wl.setCourseOffering(this.iCourses.get(((Course)courseRequest.getCourses().get(0)).getId()));
                wl.setTimestamp(new Date());
                wl.setType(new Integer(0));
                hibSession.save((Object)wl);
                continue;
            }
            org.unitime.timetable.model.CourseRequest cr = this.iRequests.get(request.getId() + ":" + enrollment.getOffering().getId());
            if (cr == null) continue;
            for (Section section : enrollment.getAssignments()) {
                StudentClassEnrollment sce = new StudentClassEnrollment();
                sce.setStudent(s);
                sce.setClazz(this.iClasses.get(section.getId()));
                sce.setCourseRequest(cr);
                sce.setCourseOffering(cr.getCourseOffering());
                sce.setTimestamp(new Date());
                hibSession.save((Object)sce);
            }
        }
    }

    public void save(Session session) {
        org.hibernate.Session hibSession = new SessionDAO().getSession();
        Transaction tx = hibSession.beginTransaction();
        try {
            try {
                this.iClasses = new Hashtable();
                for (Class_ clazz : Class_.findAll(session.getUniqueId())) {
                    this.iClasses.put(clazz.getUniqueId(), clazz);
                }
                if (this.iIncludeCourseDemands) {
                    this.iStudents = new Hashtable();
                    this.iCourses = new Hashtable();
                    this.iRequests = new Hashtable();
                    for (CourseDemand demand : CourseDemand.findAll(session.getUniqueId())) {
                        this.iStudents.put(demand.getStudent().getUniqueId(), demand.getStudent());
                        for (org.unitime.timetable.model.CourseRequest request : demand.getCourseRequests()) {
                            this.iRequests.put(demand.getUniqueId() + ":" + request.getCourseOffering().getInstructionalOffering().getUniqueId(), request);
                            this.iCourses.put(request.getCourseOffering().getUniqueId(), request.getCourseOffering());
                        }
                    }
                    for (Student student : ((StudentSectioningModel)this.getModel()).getStudents()) {
                        if (student.isDummy()) continue;
                        this.saveStudent(hibSession, student);
                        this.flushIfNeeded(hibSession);
                    }
                    this.flush(hibSession);
                }
                if (this.iIncludeLastLikeStudents) {
                    ((StudentSectioningModel)this.getModel()).computeOnlineSectioningInfos(this.getAssignment());
                    Hashtable<Long, SectioningInfo> infoTable = new Hashtable<Long, SectioningInfo>();
                    List infos = hibSession.createQuery("select i from SectioningInfo i where i.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering.session.uniqueId = :sessionId").setLong("sessionId", session.getUniqueId().longValue()).list();
                    for (SectioningInfo info : infos) {
                        infoTable.put(info.getClazz().getUniqueId(), info);
                    }
                    for (Offering offering : ((StudentSectioningModel)this.getModel()).getOfferings()) {
                        for (Config config : offering.getConfigs()) {
                            for (Subpart subpart : config.getSubparts()) {
                                for (Section section : subpart.getSections()) {
                                    Class_ clazz = this.iClasses.get(section.getId());
                                    if (clazz == null) continue;
                                    SectioningInfo info = (SectioningInfo)infoTable.get(section.getId());
                                    if (info == null) {
                                        info = new SectioningInfo();
                                        info.setClazz(clazz);
                                    }
                                    sLog.debug((Object)("  -- " + info.getClazz().getClassLabel() + " expects " + info.getNbrExpectedStudents() + ", holds " + info.getNbrHoldingStudents() + " of " + section.getLimit()));
                                    info.setNbrExpectedStudents(section.getSpaceExpected());
                                    info.setNbrHoldingStudents(section.getSpaceHeld());
                                    hibSession.saveOrUpdate((Object)info);
                                    this.flushIfNeeded(hibSession);
                                }
                            }
                        }
                    }
                }
                StudentSectioningQueue.allStudentsChanged(hibSession, null, session.getUniqueId());
                tx.commit();
            }
            catch (Exception e) {
                tx.rollback();
                throw new RuntimeException(e);
            }
            Object var17_17 = null;
        }
        catch (Throwable throwable) {
            Object var17_18 = null;
            hibSession.close();
            throw throwable;
        }
        hibSession.close();
    }
}

