/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.solver;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.coursett.preference.PreferenceCombination;
import org.hibernate.Query;
import org.hibernate.type.LongType;
import org.hibernate.type.Type;
import org.unitime.commons.Debug;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.events.EventLookupBackend;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.gwt.shared.TimetableGridInterface;
import org.unitime.timetable.interfaces.RoomAvailabilityInterface;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CurriculumClassification;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.ExactTimeMins;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.RoomSharingModel;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Solution;
import org.unitime.timetable.model.StudentGroup;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.dao.SolutionDAO;
import org.unitime.timetable.server.solver.TimetableGridContext;
import org.unitime.timetable.server.solver.TimetableGridHelper;
import org.unitime.timetable.solver.ui.AssignmentPreferenceInfo;
import org.unitime.timetable.solver.ui.GroupConstraintInfo;
import org.unitime.timetable.solver.ui.StudentGroupInfo;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.DateUtils;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.NameFormat;
import org.unitime.timetable.util.RoomAvailability;
import org.unitime.timetable.util.duration.DurationModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimetableGridSolutionHelper
extends TimetableGridHelper {
    private static DecimalFormat sDF = new DecimalFormat("0.0");

    protected static void createCells(TimetableGridInterface.TimetableGridModel model, List<Assignment> assignments, org.hibernate.Session hibSession, TimetableGridContext context, boolean notAvailable) {
        for (Assignment assignment : assignments) {
            TimetableGridSolutionHelper.createCells(model, assignment, hibSession, context, false);
        }
    }

    protected static List<TimetableGridInterface.TimetableGridCell> createCells(TimetableGridInterface.TimetableGridModel model, Assignment assignment, org.hibernate.Session hibSession, TimetableGridContext context, boolean notAvailable) {
        ArrayList<TimetableGridInterface.TimetableGridCell> cells = new ArrayList<TimetableGridInterface.TimetableGridCell>();
        TimetableGridInterface.TimetableGridCell cell = null;
        int days = assignment.getDays();
        int start = assignment.getStartSlot();
        BitSet weekCode = assignment.getDatePattern() == null ? null : assignment.getDatePattern().getPatternBitSet();
        for (int j = 0; j < Constants.DAY_CODES.length; ++j) {
            int day;
            int d = (j + context.getWeekOffset()) % 7;
            if ((Constants.DAY_CODES[d] & days) == 0 || context.getFirstDay() >= 0 && !weekCode.get(day = context.getFirstDay() + j)) continue;
            cell = cell == null ? TimetableGridSolutionHelper.createCell(model, d, start, hibSession, assignment, context, notAvailable) : new TimetableGridInterface.TimetableGridCell(cell, d, TimetableGridSolutionHelper.formatDatePattern(assignment.getDatePattern(), Constants.DAY_CODES[d]));
            model.addCell(cell);
            cells.add(cell);
        }
        return cells;
    }

    protected static void createMeetingCells(TimetableGridInterface.TimetableGridModel model, Session session, TimetableGridContext context, Collection<RoomAvailabilityInterface.TimeBlock> times, String room) {
        if (times == null) {
            return;
        }
        int sessionYear = session.getSessionStartYear();
        int firstDOY = session.getDayOfYear(1, session.getPatternStartMonth());
        int lastDOY = session.getDayOfYear(0, session.getPatternEndMonth() + 1);
        Calendar c = Calendar.getInstance(Locale.US);
        Formats.Format<Date> df = Formats.getDateFormat(Formats.Pattern.DATE_EVENT_SHORT);
        for (RoomAvailabilityInterface.TimeBlock time : times) {
            if (time.getEndTime().before(context.getSessionStartDate()) || time.getStartTime().after(context.getSessionEndDate())) continue;
            int dayCode = 0;
            c.setTime(time.getStartTime());
            int m = c.get(2);
            int d = c.get(5);
            if (c.get(1) < sessionYear) {
                m -= 12 * (sessionYear - c.get(1));
            }
            if (c.get(1) > sessionYear) {
                m += 12 * (c.get(1) - sessionYear);
            }
            BitSet weekCode = new BitSet(lastDOY - firstDOY);
            int offset = session.getDayOfYear(d, m) - firstDOY;
            weekCode.set(offset);
            switch (c.get(7)) {
                case 2: {
                    dayCode = Constants.DAY_CODES[0];
                    break;
                }
                case 3: {
                    dayCode = Constants.DAY_CODES[1];
                    break;
                }
                case 4: {
                    dayCode = Constants.DAY_CODES[2];
                    break;
                }
                case 5: {
                    dayCode = Constants.DAY_CODES[3];
                    break;
                }
                case 6: {
                    dayCode = Constants.DAY_CODES[4];
                    break;
                }
                case 7: {
                    dayCode = Constants.DAY_CODES[5];
                    break;
                }
                case 1: {
                    dayCode = Constants.DAY_CODES[6];
                }
            }
            int startSlot = (c.get(11) * 60 + c.get(12) - Constants.FIRST_SLOT_TIME_MIN) / Constants.SLOT_LENGTH_MIN;
            c.setTime(time.getEndTime());
            int endSlot = (c.get(11) * 60 + c.get(12) - Constants.FIRST_SLOT_TIME_MIN) / Constants.SLOT_LENGTH_MIN;
            int length = endSlot - startSlot;
            if (length <= 0) continue;
            TimeLocation timeLocation = new TimeLocation(dayCode, startSlot, length, 0, 0.0, null, df.format(time.getStartTime()), weekCode, 0);
            TimetableGridInterface.TimetableGridCell cell = null;
            TimeLocation.IntEnumeration f = timeLocation.getStartSlots();
            while (f.hasMoreElements()) {
                int slot = (Integer)f.nextElement();
                int idx = (7 + slot / 288 - context.getWeekOffset()) % 7;
                if (context.getFirstDay() >= 0 && !timeLocation.getWeekCode().get(context.getFirstDay() + idx)) continue;
                if (cell == null) {
                    cell = new TimetableGridInterface.TimetableGridCell();
                    cell.setType(TimetableGridInterface.TimetableGridCell.Type.Event);
                    cell.setId(time.getEventId());
                    cell.setDay(slot / 288);
                    cell.setSlot(slot % 288);
                    cell.addRoom(room);
                    cell.addName(time.getEventName());
                    cell.setProperty(TimetableGridInterface.TimetableGridCell.Property.EventType, time.getEventType());
                    cell.setBackground(sBgColorNotAvailable);
                    cell.setLength(length);
                    cell.setTime(Constants.toTime(Constants.SLOT_LENGTH_MIN * startSlot + Constants.FIRST_SLOT_TIME_MIN) + " - " + Constants.toTime(Constants.SLOT_LENGTH_MIN * endSlot + Constants.FIRST_SLOT_TIME_MIN));
                    cell.setDate(df.format(time.getStartTime()));
                    cell.setWeekCode(TimetableGridSolutionHelper.pattern2string(weekCode));
                } else {
                    cell = new TimetableGridInterface.TimetableGridCell(cell, slot / 288, null);
                }
                model.addCell(cell);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected static TimetableGridInterface.TimetableGridCell createCell(TimetableGridInterface.TimetableGridModel model, int day, int slot, org.hibernate.Session hibSession, Assignment assignment, TimetableGridContext context, boolean notAvailable) {
        void var12_38;
        Set<CourseOffering> courses;
        TimetableGridInterface.TimetableGridCell cell = new TimetableGridInterface.TimetableGridCell();
        cell.setType(TimetableGridInterface.TimetableGridCell.Type.Class);
        cell.setId(assignment.getClassId());
        CourseOffering course = assignment.getClazz().getSchedulingSubpart().getControllingCourseOffering();
        if (context.isShowClassNameTwoLines()) {
            Object extId;
            cell.addName(assignment.getClazz().getCourseName());
            String label = assignment.getClazz().getItypeDesc().trim() + " " + assignment.getClazz().getSectionNumberString();
            if (context.isShowClassSuffix() && (extId = assignment.getClazz().getClassSuffix(course)) != null && !((String)extId).isEmpty() && !((String)extId).equalsIgnoreCase(assignment.getClazz().getSectionNumberString())) {
                label = label + " - " + (String)extId;
            }
            if (context.isShowConfigName() && assignment.getClazz().getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getInstrOfferingConfigs().size() > 1) {
                label = label + " (" + assignment.getClazz().getSchedulingSubpart().getInstrOfferingConfig().getName() + ")";
            }
            cell.addName(label);
        } else {
            cell.addName(assignment.getClazz().getClassLabel(context.isShowClassSuffix(), context.isShowConfigName()));
        }
        if (context.isShowCourseTitle() && course.getTitle() != null && !course.getTitle().isEmpty()) {
            cell.addName(course.getTitle());
        }
        cell.setCommitted(notAvailable);
        cell.setDay(day);
        cell.setSlot(slot);
        if (context.isShowCourseTitle() || context.isShowClassNameTwoLines()) {
            cell.addTitle(assignment.getClazz().getClassLabel(course, context.isShowClassSuffix(), context.isShowConfigName()) + (course.getTitle() != null && !course.getTitle().isEmpty() ? " - " + course.getTitle() : ""));
        }
        if (context.isShowCrossLists() && (courses = assignment.getClazz().getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getCourseOfferings()).size() > 1) {
            for (CourseOffering co : new TreeSet<CourseOffering>(courses)) {
                if (co.isIsControl().booleanValue()) continue;
                cell.addName(assignment.getClazz().getClassLabel(co, context.isShowClassSuffix(), context.isShowConfigName()));
                if (context.isShowCourseTitle()) {
                    if (co.getTitle() != null && !co.getTitle().isEmpty()) {
                        cell.addName(co.getTitle());
                        cell.addTitle(assignment.getClazz().getClassLabel(co, context.isShowClassSuffix(), context.isShowConfigName()) + " - " + co.getTitle());
                        continue;
                    }
                    cell.addTitle(assignment.getClazz().getClassLabel(co, context.isShowClassSuffix(), context.isShowConfigName()));
                    continue;
                }
                if (!context.isShowClassNameTwoLines()) continue;
                cell.addTitle(assignment.getClazz().getClassLabel(co, context.isShowClassSuffix(), context.isShowConfigName()));
            }
        }
        cell.setLength(assignment.getTimePattern().getSlotsPerMtg());
        if (assignment.getTimePattern().getType() == 5) {
            DurationModel dm = assignment.getClazz().getSchedulingSubpart().getInstrOfferingConfig().getDurationModel();
            int minsPerMeeting = dm.getExactTimeMinutesPerMeeting(assignment.getClazz().getSchedulingSubpart().getMinutesPerWk(), assignment.getDatePattern(), assignment.getDays());
            cell.setLength(ExactTimeMins.getNrSlotsPerMtg(minsPerMeeting));
        }
        for (Location location : assignment.getRooms()) {
            cell.addRoom(location.getLabel());
        }
        int bgMode = context.getBgMode();
        AssignmentPreferenceInfo assignmentInfo = null;
        if (notAvailable) {
            cell.setBackground(sBgColorNotAvailable);
        } else {
            try {
                assignmentInfo = (AssignmentPreferenceInfo)assignment.getAssignmentInfo("AssignmentInfo");
            }
            catch (Exception e) {
                Debug.error(e);
            }
        }
        if (assignmentInfo != null) {
            int roomPref = assignmentInfo.combineRoomPreference();
            if (model.getResourceType() == TimetableGridHelper.ResourceType.ROOM.ordinal() && model.getResourceId() != null) {
                roomPref = assignmentInfo.getRoomPreference(model.getResourceId());
            }
            switch (TimetableGridHelper.BgMode.values()[bgMode]) {
                case TimePref: {
                    cell.setBackground(TimetableGridSolutionHelper.pref2color(assignmentInfo.getTimePreference()));
                    break;
                }
                case RoomPref: {
                    cell.setBackground(TimetableGridSolutionHelper.pref2color(roomPref));
                    break;
                }
                case StudentConf: {
                    cell.setBackground(TimetableGridSolutionHelper.conflicts2color(assignmentInfo.getNrStudentConflicts()));
                    break;
                }
                case InstructorBtbPref: {
                    cell.setBackground(TimetableGridSolutionHelper.pref2color(assignmentInfo.getBtbInstructorPreference()));
                    break;
                }
                case Perturbations: {
                    void var12_27;
                    String string = PreferenceLevel.sNeutral;
                    if (assignmentInfo.getInitialAssignment() != null) {
                        if (assignmentInfo.getIsInitial()) {
                            String string2 = PreferenceLevel.sStronglyPreferred;
                        } else if (assignmentInfo.getHasInitialSameTime()) {
                            String string3 = PreferenceLevel.sDiscouraged;
                        } else if (assignmentInfo.getHasInitialSameRoom()) {
                            String string4 = PreferenceLevel.sStronglyDiscouraged;
                        } else {
                            String string5 = PreferenceLevel.sProhibited;
                        }
                    }
                    cell.setBackground(TimetableGridSolutionHelper.pref2color((String)var12_27));
                    break;
                }
                case PerturbationPenalty: {
                    cell.setBackground(TimetableGridSolutionHelper.conflicts2color((int)Math.ceil(assignmentInfo.getPerturbationPenalty())));
                    break;
                }
                case HardConflicts: {
                    cell.setBackground(TimetableGridSolutionHelper.pref2color(TimetableGridSolutionHelper.hardConflicts2pref(assignmentInfo)));
                    break;
                }
                case DepartmentalBalancing: {
                    cell.setBackground(TimetableGridSolutionHelper.conflicts2colorFast(assignmentInfo.getMaxDeptBalancPenalty()));
                    break;
                }
                case TooBigRooms: {
                    int roomCap = assignment.getClazz().getMinRoomLimit();
                    long minRoomSize = assignmentInfo.getMinRoomSize();
                    int roomSize = 0;
                    for (Location r : assignment.getRooms()) {
                        roomSize += r.getCapacity().intValue();
                    }
                    if (roomSize < roomCap) {
                        cell.setBackground(TimetableGridSolutionHelper.pref2color(PreferenceLevel.sRequired));
                    } else {
                        cell.setBackground(TimetableGridSolutionHelper.pref2color(assignmentInfo.getTooBigRoomPreference()));
                    }
                    if (assignment.getRooms().isEmpty()) break;
                    cell.setPreference((assignmentInfo.getNrRoomLocations() == 1 ? "<u>" : "") + roomCap + " / " + (minRoomSize == Integer.MAX_VALUE ? "-" : String.valueOf(minRoomSize)) + " / " + roomSize + (assignmentInfo.getNrRoomLocations() == 1 ? "</u>" : ""));
                    break;
                }
                case StudentGroups: {
                    if (assignmentInfo.getStudentGroupPercent() != null) {
                        cell.setBackground(TimetableGridSolutionHelper.percentage2color(assignmentInfo.getStudentGroupPercent()));
                    }
                    if (assignmentInfo.getStudentGroupComment() == null) break;
                    cell.setPreference(assignmentInfo.getStudentGroupComment());
                }
            }
            if (!cell.hasPreference()) {
                cell.setPreference((assignmentInfo.getBestNormalizedTimePreference() < assignmentInfo.getNormalizedTimePreference() ? "<span style='color:red'>" + (int)(assignmentInfo.getNormalizedTimePreference() - assignmentInfo.getBestNormalizedTimePreference()) + "</span>" : "" + (int)(assignmentInfo.getNormalizedTimePreference() - assignmentInfo.getBestNormalizedTimePreference())) + ", " + (assignmentInfo.getNrStudentConflicts() > 0 ? "<span style='color:rgb(20,130,10)'>" + assignmentInfo.getNrStudentConflicts() + "</span>" : "" + assignmentInfo.getNrStudentConflicts()) + ", " + (assignmentInfo.getBestRoomPreference() < roomPref ? "<span style='color:blue'>" + (roomPref - assignmentInfo.getBestRoomPreference()) + "</span>" : "" + (roomPref - assignmentInfo.getBestRoomPreference())));
            }
            cell.setProperty(TimetableGridInterface.TimetableGridCell.Property.TimePreference, (int)assignmentInfo.getNormalizedTimePreference());
            cell.setProperty(TimetableGridInterface.TimetableGridCell.Property.StudentConflicts, assignmentInfo.getNrStudentConflicts());
            cell.setProperty(TimetableGridInterface.TimetableGridCell.Property.StudentConflictsCommitted, assignmentInfo.getNrCommitedStudentConflicts());
            cell.setProperty(TimetableGridInterface.TimetableGridCell.Property.StudentConflictsDistance, assignmentInfo.getNrDistanceStudentConflicts());
            cell.setProperty(TimetableGridInterface.TimetableGridCell.Property.StudentConflictsHard, assignmentInfo.getNrHardStudentConflicts());
            cell.setProperty(TimetableGridInterface.TimetableGridCell.Property.RoomPreference, roomPref);
            cell.setProperty(TimetableGridInterface.TimetableGridCell.Property.InstructorPreference, assignmentInfo.getBtbInstructorPreference());
            if (assignmentInfo.getInitialAssignment() != null) {
                cell.setProperty(TimetableGridInterface.TimetableGridCell.Property.InitialAssignment, assignmentInfo.getIsInitial() ? "-" : assignmentInfo.getInitialAssignment());
                cell.setProperty(TimetableGridInterface.TimetableGridCell.Property.PerturbationPenalty, sDF.format(assignmentInfo.getPerturbationPenalty()));
            }
            cell.setProperty(TimetableGridInterface.TimetableGridCell.Property.NonConflictingPlacements, assignmentInfo.getNrPlacementsNoConf());
            cell.setProperty(TimetableGridInterface.TimetableGridCell.Property.DepartmentBalance, sDF.format(assignmentInfo.getDeptBalancPenalty()));
        } else {
            cell.setProperty(TimetableGridInterface.TimetableGridCell.Property.Owner, assignment.getSolution().getOwner().getName());
        }
        if (bgMode == TimetableGridHelper.BgMode.DistributionConstPref.ordinal()) {
            Vector constraintInfos = new Vector();
            try {
                constraintInfos = assignment.getConstraintInfos("DistributionInfo");
            }
            catch (Exception exception) {
                Debug.error(exception);
            }
            if (constraintInfos != null) {
                PreferenceCombination preferenceCombination = PreferenceCombination.getDefault();
                Enumeration e = constraintInfos.elements();
                while (e.hasMoreElements()) {
                    GroupConstraintInfo gcInfo = (GroupConstraintInfo)e.nextElement();
                    if (gcInfo.isSatisfied()) continue;
                    if (PreferenceLevel.sRequired.equals(gcInfo.getPreference()) || PreferenceLevel.sProhibited.equals(gcInfo.getPreference())) {
                        preferenceCombination.addPreferenceProlog(PreferenceLevel.sProhibited);
                    }
                    preferenceCombination.addPreferenceInt(Math.abs(PreferenceLevel.prolog2int(gcInfo.getPreference())));
                }
                cell.setProperty(TimetableGridInterface.TimetableGridCell.Property.DistributionPreference, preferenceCombination.getPreferenceProlog());
                cell.setBackground(TimetableGridSolutionHelper.pref2color(preferenceCombination.getPreferenceProlog()));
            }
        }
        if (ApplicationProperty.TimetableGridUseClassInstructors.isTrue()) {
            if (!ApplicationProperty.TimetableGridUseClassInstructorsCheckClassDisplayInstructors.isTrue() || assignment.getClazz().isDisplayInstructor().booleanValue()) {
                for (ClassInstructor classInstructor : assignment.getClazz().getClassInstructors()) {
                    if (!classInstructor.isLead().booleanValue() && !ApplicationProperty.TimetableGridUseClassInstructorsCheckLead.isFalse()) continue;
                    cell.addInstructor(classInstructor.getInstructor().getName(context.getInstructorNameFormat()));
                }
            }
        } else {
            for (DepartmentalInstructor departmentalInstructor : assignment.getInstructors()) {
                cell.addInstructor(departmentalInstructor.getName(context.getInstructorNameFormat()));
            }
        }
        String days = "";
        boolean bl = false;
        while (var12_38 < Constants.DAY_CODES.length) {
            if ((assignment.getDays() & Constants.DAY_CODES[var12_38]) != 0) {
                days = days + CONST.shortDays()[var12_38];
            }
            ++var12_38;
        }
        cell.setDays(days);
        cell.setTime(Constants.toTime(assignment.getStartSlot() * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN) + " - " + Constants.toTime((assignment.getStartSlot() + assignment.getSlotPerMtg()) * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN - assignment.getBreakTime()));
        cell.setDate(TimetableGridSolutionHelper.formatDatePattern(assignment.getDatePattern(), Constants.DAY_CODES[day]));
        cell.setWeekCode(TimetableGridSolutionHelper.pattern2string(assignment.getDatePattern().getPatternBitSet()));
        return cell;
    }

    protected static double countUtilization(Iterable<Assignment> assignments, TimetableGridContext context) {
        HashSet<Integer> slots = new HashSet<Integer>();
        for (Assignment assignment : assignments) {
            int slot;
            int dow;
            int idx;
            int stop;
            int start;
            TimeLocation t = assignment == null ? null : assignment.getTimeLocation();
            if (t == null || (start = Math.max(context.getFirstSlot(), t.getStartSlot())) > (stop = Math.min(context.getLastSlot(), t.getStartSlot() + t.getLength() - 1))) continue;
            if (context.getFirstDay() >= 0) {
                for (idx = context.getFirstDay(); idx < 7 + context.getFirstDay(); ++idx) {
                    dow = (idx + context.getStartDayDayOfWeek()) % 7;
                    if (!t.getWeekCode().get(idx) || (t.getDayCode() & Constants.DAY_CODES[dow]) == 0 || (context.getDayCode() & Constants.DAY_CODES[dow]) == 0) continue;
                    for (slot = start; slot <= stop; ++slot) {
                        slots.add(288 * idx + slot);
                    }
                }
                continue;
            }
            idx = -1;
            while ((idx = t.getWeekCode().nextSetBit(1 + idx)) >= 0) {
                dow = (idx + context.getStartDayDayOfWeek()) % 7;
                if (!context.getDefaultDatePattern().get(idx) || (t.getDayCode() & Constants.DAY_CODES[dow]) == 0 || (context.getDayCode() & Constants.DAY_CODES[dow]) == 0) continue;
                for (slot = start; slot <= stop; ++slot) {
                    slots.add(288 * idx + slot);
                }
            }
        }
        return (float)slots.size() / (context.getNumberOfWeeks() * 12.0f);
    }

    public static String formatDatePattern(DatePattern dp, int dayCode) {
        int idx;
        if (dp == null || dp.isDefault()) {
            return null;
        }
        String format = ApplicationProperty.DatePatternFormatUseDates.value();
        if ("never".equals(format)) {
            return dp.getName();
        }
        if ("extended".equals(format) && dp.getType() != 3) {
            return dp.getName();
        }
        if ("alternate".equals(format) && dp.getType() == 1) {
            return dp.getName();
        }
        BitSet weekCode = dp.getPatternBitSet();
        if (weekCode.isEmpty()) {
            return dp.getName();
        }
        Calendar cal = Calendar.getInstance(Locale.US);
        cal.setLenient(true);
        Date dpFirstDate = DateUtils.getDate(1, dp.getSession().getPatternStartMonth(), dp.getSession().getSessionStartYear());
        cal.setTime(dpFirstDate);
        cal.add(6, idx);
        Date first = null;
        for (idx = weekCode.nextSetBit(0); idx < weekCode.size() && first == null; ++idx) {
            if (weekCode.get(idx)) {
                int dow = cal.get(7);
                switch (dow) {
                    case 2: {
                        if ((dayCode & DayCode.MON.getCode()) == 0) break;
                        first = cal.getTime();
                        break;
                    }
                    case 3: {
                        if ((dayCode & DayCode.TUE.getCode()) == 0) break;
                        first = cal.getTime();
                        break;
                    }
                    case 4: {
                        if ((dayCode & DayCode.WED.getCode()) == 0) break;
                        first = cal.getTime();
                        break;
                    }
                    case 5: {
                        if ((dayCode & DayCode.THU.getCode()) == 0) break;
                        first = cal.getTime();
                        break;
                    }
                    case 6: {
                        if ((dayCode & DayCode.FRI.getCode()) == 0) break;
                        first = cal.getTime();
                        break;
                    }
                    case 7: {
                        if ((dayCode & DayCode.SAT.getCode()) == 0) break;
                        first = cal.getTime();
                        break;
                    }
                    case 1: {
                        if ((dayCode & DayCode.SUN.getCode()) == 0) break;
                        first = cal.getTime();
                    }
                }
            }
            cal.add(6, 1);
        }
        if (first == null) {
            return dp.getName();
        }
        cal.setTime(dpFirstDate);
        cal.add(6, idx);
        Date last = null;
        for (idx = weekCode.length() - 1; idx >= 0 && last == null; --idx) {
            if (weekCode.get(idx)) {
                int dow = cal.get(7);
                switch (dow) {
                    case 2: {
                        if ((dayCode & DayCode.MON.getCode()) == 0) break;
                        last = cal.getTime();
                        break;
                    }
                    case 3: {
                        if ((dayCode & DayCode.TUE.getCode()) == 0) break;
                        last = cal.getTime();
                        break;
                    }
                    case 4: {
                        if ((dayCode & DayCode.WED.getCode()) == 0) break;
                        last = cal.getTime();
                        break;
                    }
                    case 5: {
                        if ((dayCode & DayCode.THU.getCode()) == 0) break;
                        last = cal.getTime();
                        break;
                    }
                    case 6: {
                        if ((dayCode & DayCode.FRI.getCode()) == 0) break;
                        last = cal.getTime();
                        break;
                    }
                    case 7: {
                        if ((dayCode & DayCode.SAT.getCode()) == 0) break;
                        last = cal.getTime();
                        break;
                    }
                    case 1: {
                        if ((dayCode & DayCode.SUN.getCode()) == 0) break;
                        last = cal.getTime();
                    }
                }
            }
            cal.add(6, -1);
        }
        if (last == null) {
            return dp.getName();
        }
        Formats.Format<Date> dpf = Formats.getDateFormat(Formats.Pattern.DATE_EVENT_SHORT);
        return dpf.format(first) + (first.equals(last) ? "" : " - " + dpf.format(last));
    }

    public static TimetableGridInterface.TimetableGridModel createModel(String solutionIdsStr, Location room, org.hibernate.Session hibSession, TimetableGridContext context) {
        TimetableGridInterface.TimetableGridModel model = new TimetableGridInterface.TimetableGridModel(TimetableGridHelper.ResourceType.ROOM.ordinal(), room.getUniqueId());
        model.setName(room.getLabel());
        model.setSize(room.getCapacity());
        model.setFirstDay(context.getFirstDay());
        model.setFirstSessionDay(context.getFirstSessionDay());
        model.setFirstDate(context.getFirstDate());
        Solution firstSolution = null;
        String ownerIds = "";
        HashSet<Long> deptIds = new HashSet<Long>();
        StringTokenizer s = new StringTokenizer(solutionIdsStr, ",");
        while (s.hasMoreTokens()) {
            Long solutionId = Long.valueOf(s.nextToken());
            Solution solution = (Solution)SolutionDAO.getInstance().get(solutionId, hibSession);
            if (solution == null) continue;
            if (firstSolution == null) {
                firstSolution = solution;
            }
            if (ownerIds.length() > 0) {
                ownerIds = ownerIds + ",";
            }
            ownerIds = ownerIds + solution.getOwner().getUniqueId();
            for (Department d : solution.getOwner().getDepartments()) {
                deptIds.add(d.getUniqueId());
            }
        }
        Query q = hibSession.createQuery("select distinct a from Assignment as a inner join a.rooms as r where a.solution.uniqueId in (" + solutionIdsStr + ") and r.uniqueId=:resourceId");
        q.setLong("resourceId", room.getUniqueId().longValue());
        q.setCacheable(true);
        List assignments = q.list();
        TimetableGridSolutionHelper.createCells(model, assignments, hibSession, context, false);
        q = hibSession.createQuery("select distinct a from Room r inner join r.assignments as a where r.uniqueId=:roomId and a.solution.commited=true and a.solution.owner.session.uniqueId=:sessionId and a.solution.owner.uniqueId not in (" + ownerIds + ")");
        q.setLong("roomId", room.getUniqueId().longValue());
        q.setLong("sessionId", room.getSession().getUniqueId().longValue());
        q.setCacheable(true);
        List committed = q.list();
        TimetableGridSolutionHelper.createCells(model, committed, hibSession, context, true);
        model.setUtilization(TimetableGridSolutionHelper.countUtilization(new TimetableGridHelper.Combine<Assignment>(assignments, committed), context));
        RoomSharingModel sharing = room.getRoomSharingModel();
        if (sharing != null) {
            for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
                int start = 0;
                Boolean av = null;
                for (int j = 0; j < 288; ++j) {
                    Long dept;
                    Boolean available = sharing.isFreeForAll(i, j) ? Boolean.valueOf(true) : (sharing.isNotAvailable(i, j) ? Boolean.valueOf(false) : Boolean.valueOf((dept = sharing.getDepartmentId(i, j)) == null || deptIds.contains(dept)));
                    if (av == null) {
                        av = available;
                        start = j;
                        continue;
                    }
                    if (av.equals(available)) continue;
                    if (!av.booleanValue()) {
                        TimetableGridInterface.TimetableGridBackground bg = new TimetableGridInterface.TimetableGridBackground();
                        bg.setBackground(sBgColorNotAvailable);
                        bg.setSlot(start);
                        bg.setLength(j - start);
                        bg.setDay(i);
                        bg.setAvailable(false);
                        model.addBackground(bg);
                    }
                    av = available;
                    start = j;
                }
                if (av == null || av.booleanValue()) continue;
                TimetableGridInterface.TimetableGridBackground bg = new TimetableGridInterface.TimetableGridBackground();
                bg.setBackground(sBgColorNotAvailable);
                bg.setSlot(start);
                bg.setLength(288 - start);
                bg.setDay(i);
                bg.setAvailable(false);
                model.addBackground(bg);
            }
        }
        if (context.isShowEvents() && RoomAvailability.getInstance() != null) {
            TimetableGridSolutionHelper.createMeetingCells(model, room.getSession(), context, RoomAvailability.getInstance().getRoomAvailability(room.getUniqueId(), context.getSessionStartDate(), context.getSessionEndDate(), RoomAvailabilityInterface.sClassType), room.getLabel());
        }
        model.setType(room instanceof Room ? ((Room)room).getRoomType().getUniqueId() : null);
        return model;
    }

    public static TimetableGridInterface.TimetableGridModel createModel(String solutionIdsStr, DepartmentalInstructor instructor, org.hibernate.Session hibSession, TimetableGridContext context) {
        Query q;
        TimetableGridInterface.TimetableGridModel model = new TimetableGridInterface.TimetableGridModel(TimetableGridHelper.ResourceType.INSTRUCTOR.ordinal(), instructor.getUniqueId());
        model.setName(instructor.getName(NameFormat.LAST_FIRST_MIDDLE.reference()));
        model.setFirstDay(context.getFirstDay());
        model.setFirstSessionDay(context.getFirstSessionDay());
        model.setFirstDate(context.getFirstDate());
        Solution firstSolution = null;
        String ownerIds = "";
        StringTokenizer s = new StringTokenizer(solutionIdsStr, ",");
        while (s.hasMoreTokens()) {
            Long solutionId = Long.valueOf(s.nextToken());
            Solution solution = (Solution)new SolutionDAO().get(solutionId, hibSession);
            if (solution == null) continue;
            if (firstSolution == null) {
                firstSolution = solution;
            }
            if (ownerIds.length() > 0) {
                ownerIds = ownerIds + ",";
            }
            ownerIds = ownerIds + solution.getOwner().getUniqueId();
        }
        List assignments = null;
        List committed = null;
        if (ApplicationProperty.TimetableGridUseClassInstructors.isTrue()) {
            String check = "";
            if (ApplicationProperty.TimetableGridUseClassInstructorsCheckLead.isTrue()) {
                check = check + " and i.lead = true";
            }
            if (ApplicationProperty.TimetableGridUseClassInstructorsCheckClassDisplayInstructors.isTrue()) {
                check = check + " and i.classInstructing.displayInstructor = true";
            }
            if (instructor.getExternalUniqueId() != null && !instructor.getExternalUniqueId().isEmpty()) {
                Query q2 = hibSession.createQuery("select distinct a from Assignment as a inner join a.clazz.classInstructors as i where a.solution.uniqueId in (" + solutionIdsStr + ") and i.instructor.externalUniqueId = :extId" + check);
                q2.setString("extId", instructor.getExternalUniqueId());
                q2.setCacheable(true);
                assignments = q2.list();
                q2 = hibSession.createQuery("select distinct a from ClassInstructor i inner join i.classInstructing.assignments as a where i.instructor.externalUniqueId = :extId and a.solution.commited = true and a.solution.owner.session.uniqueId = :sessionId and a.solution.owner.uniqueId not in (" + ownerIds + ")" + check);
                q2.setString("extId", instructor.getExternalUniqueId());
                q2.setLong("sessionId", instructor.getDepartment().getSession().getUniqueId().longValue());
                q2.setCacheable(true);
                committed = q2.list();
            } else {
                Query q3 = hibSession.createQuery("select distinct a from Assignment as a inner join a.clazz.classInstructors as i where a.solution.uniqueId in (" + solutionIdsStr + ") and i.instructor.uniqueId = :instructorId" + check);
                q3.setLong("instructorId", instructor.getUniqueId().longValue());
                q3.setCacheable(true);
                assignments = q3.list();
                q3 = hibSession.createQuery("select distinct a from ClassInstructor i inner join i.classInstructing.assignments as a where i.instructor.uniqueId = :instructorId and a.solution.commited = true and a.solution.owner.session.uniqueId = :sessionId and a.solution.owner.uniqueId not in (" + ownerIds + ")" + check);
                q3.setLong("instructorId", instructor.getUniqueId().longValue());
                q3.setLong("sessionId", instructor.getDepartment().getSession().getUniqueId().longValue());
                q3.setCacheable(true);
                committed = q3.list();
            }
        } else if (instructor.getExternalUniqueId() != null && instructor.getExternalUniqueId().length() > 0) {
            q = hibSession.createQuery("select distinct a from Assignment as a inner join a.instructors as i where a.solution.uniqueId in (" + solutionIdsStr + ") and i.externalUniqueId=:puid");
            q.setString("puid", instructor.getExternalUniqueId());
            q.setCacheable(true);
            assignments = q.list();
            q = hibSession.createQuery("select distinct a from DepartmentalInstructor i inner join i.assignments as a where i.externalUniqueId=:puid and a.solution.commited=true and a.solution.owner.session.uniqueId=:sessionId and a.solution.owner.uniqueId not in (" + ownerIds + ")");
            q.setString("puid", instructor.getExternalUniqueId());
            q.setLong("sessionId", instructor.getDepartment().getSession().getUniqueId().longValue());
            q.setCacheable(true);
            committed = q.list();
        } else {
            q = hibSession.createQuery("select distinct a from Assignment as a inner join a.instructors as i where a.solution.uniqueId in (" + solutionIdsStr + ") and i.uniqueId=:resourceId");
            q.setLong("resourceId", instructor.getUniqueId().longValue());
            q.setCacheable(true);
            assignments = q.list();
            q = hibSession.createQuery("select distinct a from DepartmentalInstructor i inner join i.assignments as a where i.uniqueId=:instructorId and a.solution.commited=true and a.solution.owner.session.uniqueId=:sessionId and a.solution.owner.uniqueId not in (" + ownerIds + ")");
            q.setLong("instructorId", instructor.getUniqueId().longValue());
            q.setLong("sessionId", instructor.getDepartment().getSession().getUniqueId().longValue());
            q.setCacheable(true);
            committed = q.list();
        }
        TimetableGridSolutionHelper.createCells(model, assignments, hibSession, context, false);
        TimetableGridSolutionHelper.createCells(model, committed, hibSession, context, true);
        model.setUtilization(TimetableGridSolutionHelper.countUtilization(new TimetableGridHelper.Combine<Assignment>(assignments, committed), context));
        if (context.isShowEvents() && RoomAvailability.getInstance() != null) {
            TimetableGridSolutionHelper.createMeetingCells(model, instructor.getDepartment().getSession(), context, RoomAvailability.getInstance().getInstructorAvailability(instructor.getUniqueId(), context.getSessionStartDate(), context.getSessionEndDate(), RoomAvailabilityInterface.sClassType), null);
        }
        if (instructor.getPositionType() != null) {
            model.setType(new Long(instructor.getPositionType().getSortOrder().intValue()));
        }
        return model;
    }

    public static TimetableGridInterface.TimetableGridModel createModel(String solutionIdsStr, Department department, org.hibernate.Session hibSession, TimetableGridContext context) {
        TimetableGridInterface.TimetableGridModel model = new TimetableGridInterface.TimetableGridModel(TimetableGridHelper.ResourceType.DEPARTMENT.ordinal(), department.getUniqueId());
        model.setName(department.getShortLabel());
        model.setFirstDay(context.getFirstDay());
        model.setFirstSessionDay(context.getFirstSessionDay());
        model.setFirstDate(context.getFirstDate());
        Query q = hibSession.createQuery("select distinct a from Assignment as a inner join a.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings as o inner join o.subjectArea.department as d where a.solution.uniqueId in (" + solutionIdsStr + ") and d.uniqueId=:resourceId and o.isControl=true");
        q.setCacheable(true);
        q.setLong("resourceId", department.getUniqueId().longValue());
        List assignments = q.list();
        TimetableGridSolutionHelper.createCells(model, assignments, hibSession, context, false);
        model.setSize(assignments.size());
        model.setUtilization(TimetableGridSolutionHelper.countUtilization(assignments, context));
        return model;
    }

    public static TimetableGridInterface.TimetableGridModel createModel(String solutionIdsStr, SubjectArea sa, org.hibernate.Session hibSession, TimetableGridContext context) {
        TimetableGridInterface.TimetableGridModel model = new TimetableGridInterface.TimetableGridModel(TimetableGridHelper.ResourceType.SUBJECT_AREA.ordinal(), sa.getUniqueId());
        model.setName(sa.getSubjectAreaAbbreviation());
        model.setFirstDay(context.getFirstDay());
        model.setFirstSessionDay(context.getFirstSessionDay());
        model.setFirstDate(context.getFirstDate());
        Query q = hibSession.createQuery("select distinct a from Assignment as a inner join a.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings as o inner join o.subjectArea as sa where a.solution.uniqueId in (" + solutionIdsStr + ") and sa.uniqueId=:resourceId and o.isControl=true");
        q.setCacheable(true);
        q.setLong("resourceId", sa.getUniqueId().longValue());
        List assignments = q.list();
        TimetableGridSolutionHelper.createCells(model, assignments, hibSession, context, false);
        model.setSize(assignments.size());
        model.setUtilization(TimetableGridSolutionHelper.countUtilization(assignments, context));
        return model;
    }

    public static TimetableGridInterface.TimetableGridModel createModel(String solutionIdsStr, CurriculumClassification cc, org.hibernate.Session hibSession, TimetableGridContext context) {
        TimetableGridInterface.TimetableGridModel model = new TimetableGridInterface.TimetableGridModel(TimetableGridHelper.ResourceType.CURRICULUM.ordinal(), cc.getUniqueId());
        model.setName(cc.getCurriculum().getAbbv() + " " + cc.getName());
        model.setFirstDay(context.getFirstDay());
        model.setFirstSessionDay(context.getFirstSessionDay());
        model.setFirstDate(context.getFirstDate());
        Query q = hibSession.createQuery("select distinct a from CurriculumClassification cc inner join cc.courses cx, Assignment a inner join a.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co where a.solution.uniqueId in (" + solutionIdsStr + ") and cc.uniqueId=:resourceId and cx.course = co");
        q.setCacheable(true);
        q.setLong("resourceId", cc.getUniqueId().longValue());
        List assignments = q.list();
        Hashtable<Long, Set[]> restrictions = new Hashtable<Long, Set[]>();
        for (Object[] o : hibSession.createQuery("select distinct cc.course.instructionalOffering.uniqueId, (case when g.uniqueId is null then x.uniqueId else g.uniqueId end), z.uniqueId from CurriculumReservation r left outer join r.configurations g left outer join r.classes z left outer join z.schedulingSubpart.instrOfferingConfig x left outer join r.majors rm left outer join r.classifications rc, CurriculumCourse cc inner join cc.classification.curriculum.majors cm where cc.classification.uniqueId = :resourceId and cc.course.instructionalOffering = r.instructionalOffering and r.area = cc.classification.curriculum.academicArea and (rm is null or rm = cm) and (rc is null or rc = cc.classification.academicClassification)").setLong("resourceId", cc.getUniqueId().longValue()).setCacheable(true).list()) {
            Long offeringId = (Long)o[0];
            Long configId = (Long)o[1];
            Long clazzId = (Long)o[2];
            Set[] r = (Set[])restrictions.get(offeringId);
            if (r == null) {
                r = new Set[]{new HashSet(), new HashSet()};
                restrictions.put(offeringId, r);
            }
            if (configId != null) {
                r[0].add(configId);
            }
            if (clazzId == null) continue;
            r[1].add(clazzId);
        }
        if (!restrictions.isEmpty()) {
            Iterator i = assignments.iterator();
            while (i.hasNext()) {
                Assignment asgn = (Assignment)i.next();
                Set[] r = restrictions == null ? null : (Set[])restrictions.get(asgn.getClazz().getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getUniqueId());
                if (r == null || !EventLookupBackend.hide(r, asgn.getClazz())) continue;
                i.remove();
            }
        }
        TimetableGridSolutionHelper.createCells(model, assignments, hibSession, context, false);
        model.setSize(assignments.size());
        model.setUtilization(TimetableGridSolutionHelper.countUtilization(assignments, context));
        return model;
    }

    public static TimetableGridInterface.TimetableGridModel createModel(String solutionIdsStr, StudentGroup g, org.hibernate.Session hibSession, TimetableGridContext context) {
        TimetableGridInterface.TimetableGridModel model = new TimetableGridInterface.TimetableGridModel(TimetableGridHelper.ResourceType.STUDENT_GROUP.ordinal(), g.getUniqueId());
        model.setName(g.getGroupAbbreviation());
        model.setFirstDay(context.getFirstDay());
        model.setFirstSessionDay(context.getFirstSessionDay());
        model.setFirstDate(context.getFirstDate());
        Query q = hibSession.createQuery("select distinct a from StudentGroupReservation r, Assignment a inner join a.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering as io where a.solution.uniqueId in (" + solutionIdsStr + ") and io = r.instructionalOffering and r.group.uniqueId=:resourceId");
        q.setCacheable(true);
        q.setLong("resourceId", g.getUniqueId().longValue());
        List assignments = q.list();
        Hashtable<Long, Set[]> restrictions = new Hashtable<Long, Set[]>();
        for (Object[] o : hibSession.createQuery("select distinct r.instructionalOffering.uniqueId, (case when g.uniqueId is null then x.uniqueId else g.uniqueId end), z.uniqueId from StudentGroupReservation r left outer join r.configurations g left outer join r.classes z left outer join z.schedulingSubpart.instrOfferingConfig x where r.group.uniqueId = :resourceId").setLong("resourceId", g.getUniqueId().longValue()).setCacheable(true).list()) {
            Long offeringId = (Long)o[0];
            Long configId = (Long)o[1];
            Long clazzId = (Long)o[2];
            Set[] r = (Set[])restrictions.get(offeringId);
            if (r == null) {
                r = new Set[]{new HashSet(), new HashSet()};
                restrictions.put(offeringId, r);
            }
            if (configId != null) {
                r[0].add(configId);
            }
            if (clazzId == null) continue;
            r[1].add(clazzId);
        }
        if (!restrictions.isEmpty()) {
            Iterator i = assignments.iterator();
            while (i.hasNext()) {
                Assignment asgn = (Assignment)i.next();
                Set[] r = restrictions == null ? null : (Set[])restrictions.get(asgn.getClazz().getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getUniqueId());
                if (r == null || !EventLookupBackend.hide(r, asgn.getClazz())) continue;
                i.remove();
            }
        }
        TimetableGridSolutionHelper.createCells(model, assignments, hibSession, context, false);
        model.setSize(assignments.size());
        model.setUtilization(TimetableGridSolutionHelper.countUtilization(assignments, context));
        return model;
    }

    public static TimetableGridInterface.TimetableGridModel createModel(String solutionIdsStr, StudentGroupInfo g, org.hibernate.Session hibSession, TimetableGridContext context) {
        TimetableGridInterface.TimetableGridModel model = new TimetableGridInterface.TimetableGridModel(TimetableGridHelper.ResourceType.STUDENT_GROUP.ordinal(), g.getGroupId());
        model.setName(g.getGroupName());
        model.setFirstDay(context.getFirstDay());
        model.setFirstSessionDay(context.getFirstSessionDay());
        model.setFirstDate(context.getFirstDate());
        ArrayList<Long> classIds = new ArrayList<Long>();
        for (StudentGroupInfo.ClassInfo clazz : g.getGroupAssignments()) {
            classIds.add(clazz.getClassId());
        }
        if (classIds.isEmpty()) {
            return null;
        }
        Query q = hibSession.createQuery("select distinct a from Assignment a where a.solution.uniqueId in (" + solutionIdsStr + ") and a.classId in (:classIds)");
        q.setParameterList("classIds", classIds, (Type)new LongType());
        q.setCacheable(true);
        List assignments = q.list();
        model.setSize((int)Math.round(g.countStudentWeights()));
        for (Assignment assignment : assignments) {
            List<TimetableGridInterface.TimetableGridCell> cells = TimetableGridSolutionHelper.createCells(model, assignment, hibSession, context, false);
            StudentGroupInfo.ClassInfo ci = g.getGroupAssignment(assignment.getClassId());
            if (ci == null) continue;
            int total = g.countStudentsOfOffering(assignment.getClazz().getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getUniqueId());
            for (TimetableGridInterface.TimetableGridCell cell : cells) {
                int maxLimit;
                cell.setGroup("(" + Math.round(ci.countStudentsWeight()) + ")");
                if (ci.getStudents() == null || ci.getStudents().isEmpty() || total <= 1) continue;
                int assigned = ci.getStudents().size();
                int minLimit = assignment.getClazz().getExpectedCapacity();
                int limit = maxLimit = assignment.getClazz().getMaxExpectedCapacity().intValue();
                if (minLimit < maxLimit) {
                    int roomLimit = (int)Math.floor((float)assignment.getPlacement().getRoomSize() / (assignment.getClazz().getRoomRatio() == null ? 1.0f : assignment.getClazz().getRoomRatio().floatValue()));
                    limit = Math.min(Math.max(minLimit, roomLimit), maxLimit);
                }
                if (assignment.getClazz().getSchedulingSubpart().getInstrOfferingConfig().isUnlimitedEnrollment().booleanValue() || limit >= 9999) {
                    limit = Integer.MAX_VALUE;
                }
                int p = 100 * assigned / Math.min(limit, total);
                cell.setBackground(TimetableGridSolutionHelper.percentage2color(p));
                cell.setPreference(assigned + " of " + total);
            }
        }
        model.setUtilization(g.getGroupValue());
        return model;
    }
}

