/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.solver;

import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.TimetableGridInterface;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.server.solver.TimetableGridContext;
import org.unitime.timetable.solver.ui.AssignmentPreferenceInfo;

public class TimetableGridHelper {
    protected static GwtMessages MSG = Localization.create(GwtMessages.class);
    protected static GwtConstants CONST = Localization.create(GwtConstants.class);
    public static String sBgColorEmpty = "rgb(255,255,255)";
    public static String sBgColorRequired = "rgb(80,80,200)";
    public static String sBgColorStronglyPreferred = "rgb(40,180,60)";
    public static String sBgColorPreferred = "rgb(170,240,60)";
    public static String sBgColorNeutral = "rgb(240,240,240)";
    public static String sBgColorDiscouraged = "rgb(240,210,60)";
    public static String sBgColorStronglyDiscouraged = "rgb(240,120,60)";
    public static String sBgColorProhibited = "rgb(220,50,40)";
    public static String sBgColorNotAvailable = "rgb(200,200,200)";
    public static String sBgColorNotAvailableButAssigned = sBgColorProhibited;

    public static String pref2color(String pref) {
        return PreferenceLevel.prolog2bgColor(pref);
    }

    public static String pref2color(int pref) {
        return PreferenceLevel.prolog2bgColor(PreferenceLevel.int2prolog(pref));
    }

    public static String conflicts2color(int nrConflicts) {
        if (nrConflicts > 15) {
            nrConflicts = 15;
        }
        String color = null;
        color = nrConflicts == 0 ? "rgb(240,240,240)" : (nrConflicts < 5 ? "rgb(240," + (240 - 30 * nrConflicts / 5) + "," + (240 - 180 * nrConflicts / 5) + ")" : (nrConflicts < 10 ? "rgb(240," + (210 - 90 * (nrConflicts - 5) / 5) + ",60)" : "rgb(" + (240 - 20 * (nrConflicts - 10) / 5) + "," + (120 - 70 * (nrConflicts - 10) / 5) + "," + (60 - 20 * (nrConflicts - 10) / 5) + ")"));
        return color;
    }

    public static String conflicts2colorFast(int nrConflicts) {
        if (nrConflicts == 0) {
            return "rgb(240,240,240)";
        }
        if (nrConflicts == 1) {
            return "rgb(240,210,60)";
        }
        if (nrConflicts == 2) {
            return "rgb(240,120,60)";
        }
        return "rgb(220,50,40)";
    }

    public static String hardConflicts2pref(AssignmentPreferenceInfo assignmentInfo) {
        if (assignmentInfo == null) {
            return PreferenceLevel.sNeutral;
        }
        String pref = PreferenceLevel.sNeutral;
        pref = assignmentInfo.getNrRoomLocations() == 1 && assignmentInfo.getNrTimeLocations() == 1 ? PreferenceLevel.sRequired : (assignmentInfo.getNrSameTimePlacementsNoConf() > 0 ? PreferenceLevel.sStronglyPreferred : (assignmentInfo.getNrTimeLocations() > 1 && assignmentInfo.getNrSameRoomPlacementsNoConf() > 0 ? PreferenceLevel.sProhibited : (assignmentInfo.getNrTimeLocations() > 1 ? PreferenceLevel.sNeutral : (assignmentInfo.getNrSameRoomPlacementsNoConf() > 0 ? PreferenceLevel.sDiscouraged : (assignmentInfo.getNrRoomLocations() > 1 ? PreferenceLevel.sStronglyDiscouraged : PreferenceLevel.sRequired)))));
        return pref;
    }

    private static int gradient(int min, int v1, int max, int v2, int value) {
        return value <= min ? v1 : (value >= max ? v2 : v1 + (v2 - v1) * (value - min) / (max - min));
    }

    public static String percentage2color(int p) {
        int[] points = new int[]{0, 20, 40, 60, 80, 100};
        int[] r = new int[]{220, 240, 240, 240, 70, 30};
        int[] g = new int[]{50, 120, 210, 240, 230, 160};
        int[] b = new int[]{40, 60, 60, 240, 30, 60};
        for (int i = 1; i < points.length; ++i) {
            if (p > points[i]) continue;
            return "rgb(" + TimetableGridHelper.gradient(points[i - 1], r[i - 1], points[i], r[i], p) + "," + TimetableGridHelper.gradient(points[i - 1], g[i - 1], points[i], g[i], p) + "," + TimetableGridHelper.gradient(points[i - 1], b[i - 1], points[i], b[i], p) + ")";
        }
        return "rgb(" + r[points.length - 1] + "," + g[points.length - 1] + "," + b[points.length - 1] + ")";
    }

    public static String pattern2string(BitSet pattern) {
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < pattern.length(); ++i) {
            ret.append(pattern.get(i) ? (char)'1' : '0');
        }
        return ret.toString();
    }

    private static void setCell(TimetableGridInterface.TimetableGridCell[][][] data, int day, int slot, int idx, TimetableGridInterface.TimetableGridCell cell) {
        if (data[day][slot] == null) {
            data[day][slot] = new TimetableGridInterface.TimetableGridCell[idx + 1];
            for (int i = 0; i < idx; ++i) {
                data[day][slot][i] = null;
            }
            data[day][slot][idx] = cell;
        } else if (data[day][slot].length <= idx) {
            TimetableGridInterface.TimetableGridCell[] old = data[day][slot];
            data[day][slot] = new TimetableGridInterface.TimetableGridCell[idx + 1];
            for (int i = 0; i < idx; ++i) {
                data[day][slot][i] = i < old.length ? old[i] : null;
            }
            data[day][slot][idx] = cell;
        } else {
            data[day][slot][idx] = cell;
        }
    }

    private static TimetableGridInterface.TimetableGridCell getCell(TimetableGridInterface.TimetableGridCell[][][] data, int day, int slot, int idx) {
        if (data[day][slot] == null) {
            return null;
        }
        if (data[day][slot].length <= idx) {
            return null;
        }
        return data[day][slot][idx];
    }

    private static int getIndex(TimetableGridInterface.TimetableGridCell[][][] data, int day, int slot, int length) {
        int idx = 0;
        while (true) {
            block3: {
                for (int i = 0; i < length; ++i) {
                    if (TimetableGridHelper.getCell(data, day, slot + i, idx) == null) {
                        continue;
                    }
                    break block3;
                }
                return idx;
            }
            ++idx;
        }
    }

    private static void addCell(TimetableGridInterface.TimetableGridCell[][][] data, int day, int slot, int length, TimetableGridInterface.TimetableGridCell cell) {
        int idx = TimetableGridHelper.getIndex(data, day, slot, length);
        for (int i = 0; i < length; ++i) {
            TimetableGridHelper.setCell(data, day, slot + i, idx, cell);
        }
    }

    private static int nrEmptyAbove(TimetableGridInterface.TimetableGridCell[][][] data, int day, int slot, int index, int length, TimetableGridInterface.TimetableGridCell cell) {
        for (int idx = index + 1; idx < length; ++idx) {
            for (int i = 0; i < cell.getLength(); ++i) {
                if (TimetableGridHelper.getCell(data, day, slot + i, idx) == null) continue;
                return idx - index - 1;
            }
        }
        return length - index - 1;
    }

    private static int nrCells(TimetableGridInterface.TimetableGridCell[][][] data, int day, int slot) {
        if (data[day][slot] == null) {
            return 0;
        }
        int ret = 0;
        for (int i = 0; i < data[day][slot].length; ++i) {
            if (data[day][slot][i] == null) continue;
            ++ret;
        }
        return ret;
    }

    private static boolean isUselessFirst(TimetableGridInterface.TimetableGridCell[][][] data, int d, int s) {
        if (s - 1 < 0 || s + 6 >= 288) {
            return false;
        }
        return TimetableGridHelper.nrCells(data, d, s - 1) != 0 && TimetableGridHelper.nrCells(data, d, s + 0) == 0 && TimetableGridHelper.nrCells(data, d, s + 1) == 0 && TimetableGridHelper.nrCells(data, d, s + 2) == 0 && TimetableGridHelper.nrCells(data, d, s + 3) == 0 && TimetableGridHelper.nrCells(data, d, s + 4) == 0 && TimetableGridHelper.nrCells(data, d, s + 5) == 0 && TimetableGridHelper.nrCells(data, d, s + 6) != 0;
    }

    private static boolean isUseless(TimetableGridInterface.TimetableGridCell[][][] data, int d, int s) {
        return TimetableGridHelper.isUselessFirst(data, d, s) || TimetableGridHelper.isUselessFirst(data, d, s - 1) || TimetableGridHelper.isUselessFirst(data, d, s - 2) || TimetableGridHelper.isUselessFirst(data, d, s - 3) || TimetableGridHelper.isUselessFirst(data, d, s - 4) || TimetableGridHelper.isUselessFirst(data, d, s - 5);
    }

    public static void initBgModeUselessSlots(TimetableGridInterface.TimetableGridModel model, TimetableGridInterface.TimetableGridCell[][][] data) {
        for (int d = 0; d < data.length; ++d) {
            int start = 0;
            Integer lastPref = null;
            for (int s = 0; s < 288; ++s) {
                Integer pref = null;
                if (model.isAvailable(d, s)) {
                    pref = 0;
                    if (TimetableGridHelper.nrCells(data, d, s) == 0) {
                        if (TimetableGridHelper.isUseless(data, d, s)) {
                            pref = 4;
                        }
                        switch (d) {
                            case 0: {
                                if (TimetableGridHelper.nrCells(data, 2, s) == 0 || TimetableGridHelper.nrCells(data, 4, s) == 0) break;
                                Integer n = pref;
                                Integer n2 = pref = Integer.valueOf(pref + 1);
                                break;
                            }
                            case 1: {
                                if (TimetableGridHelper.nrCells(data, 3, s) == 0) break;
                                Integer n = pref;
                                Integer n2 = pref = Integer.valueOf(pref + 1);
                                break;
                            }
                            case 2: {
                                if (TimetableGridHelper.nrCells(data, 0, s) == 0 || TimetableGridHelper.nrCells(data, 4, s) == 0) break;
                                Integer n = pref;
                                Integer n2 = pref = Integer.valueOf(pref + 1);
                                break;
                            }
                            case 3: {
                                if (TimetableGridHelper.nrCells(data, 1, s) == 0) break;
                                Integer n = pref;
                                Integer n2 = pref = Integer.valueOf(pref + 1);
                                break;
                            }
                            case 4: {
                                if (TimetableGridHelper.nrCells(data, 0, s) == 0 || TimetableGridHelper.nrCells(data, 2, s) == 0) break;
                                Integer n = pref;
                                Integer n2 = pref = Integer.valueOf(pref + 1);
                            }
                        }
                    }
                }
                if (lastPref != null && !lastPref.equals(pref)) {
                    TimetableGridInterface.TimetableGridBackground bg = new TimetableGridInterface.TimetableGridBackground();
                    bg.setDay(d);
                    bg.setSlot(start);
                    bg.setLength(s - start);
                    bg.setAvailable(true);
                    bg.setBackground(TimetableGridHelper.pref2color(PreferenceLevel.sNeutral));
                    if (lastPref > 4) {
                        bg.setBackground(TimetableGridHelper.pref2color(PreferenceLevel.sProhibited));
                    } else if (lastPref == 4) {
                        bg.setBackground(TimetableGridHelper.pref2color(PreferenceLevel.sStronglyDiscouraged));
                    } else if (lastPref > 0) {
                        bg.setBackground(TimetableGridHelper.pref2color(PreferenceLevel.sDiscouraged));
                    }
                    model.addBackground(bg);
                    lastPref = pref;
                    start = s;
                    continue;
                }
                if (lastPref != null || pref == null) continue;
                lastPref = pref;
                start = s;
            }
            if (lastPref == null) continue;
            TimetableGridInterface.TimetableGridBackground bg = new TimetableGridInterface.TimetableGridBackground();
            bg.setDay(d);
            bg.setSlot(start);
            bg.setLength(288 - start);
            bg.setAvailable(true);
            bg.setBackground(TimetableGridHelper.pref2color(PreferenceLevel.sNeutral));
            if (lastPref > 4) {
                bg.setBackground(TimetableGridHelper.pref2color(PreferenceLevel.sProhibited));
            } else if (lastPref == 4) {
                bg.setBackground(TimetableGridHelper.pref2color(PreferenceLevel.sStronglyDiscouraged));
            } else if (lastPref > 0) {
                bg.setBackground(TimetableGridHelper.pref2color(PreferenceLevel.sDiscouraged));
            }
            model.addBackground(bg);
        }
    }

    public static void computeIndexes(TimetableGridInterface.TimetableGridModel model, TimetableGridContext context) {
        int i;
        int lines;
        int empty;
        TimetableGridInterface.TimetableGridCell c;
        int s;
        int index;
        Collections.sort(model.getCells());
        if (context.getDisplayMode() == DisplayMode.WeekByWeekHorizontal.ordinal()) {
            TimetableGridInterface.TimetableGridCell[][][] weekData = new TimetableGridInterface.TimetableGridCell[365][288][];
            for (int d = 0; d < 365; ++d) {
                for (int s2 = 0; s2 < 288; ++s2) {
                    weekData[d][s2] = null;
                }
            }
            for (TimetableGridInterface.TimetableGridCell cell : model.getCells()) {
                for (int d = 0; d < 365; ++d) {
                    int date = d + model.getFirstSessionDay();
                    int day = d % 7;
                    if (day != cell.getDay() || !cell.hasDate(date)) continue;
                    TimetableGridHelper.addCell(weekData, date, cell.getSlot(), cell.getLength(), cell);
                }
            }
            for (int d = 0; d < 365; ++d) {
                int idx;
                int length = 0;
                for (int s3 = 0; s3 < 288; ++s3) {
                    if (weekData[d][s3] == null || weekData[d][s3].length <= length) continue;
                    length = weekData[d][s3].length;
                }
                int[] maxLines = new int[length];
                index = 0;
                for (idx = 0; idx < length; ++idx) {
                    maxLines[idx] = 0;
                    for (s = 0; s < 288; ++s) {
                        c = TimetableGridHelper.getCell(weekData, d, s, idx);
                        if (c == null || maxLines[idx] >= c.getMinLines(context.isShowRoom(), context.isShowInstructor(), context.isShowTime(), context.isShowPreference(), context.isShowDate())) continue;
                        maxLines[idx] = c.getMinLines(context.isShowRoom(), context.isShowInstructor(), context.isShowTime(), context.isShowPreference(), context.isShowDate());
                    }
                    for (s = 0; s < 288; ++s) {
                        c = TimetableGridHelper.getCell(weekData, d, s, idx);
                        if (c == null) continue;
                        c.setNrLines(maxLines[idx]);
                        c.setIndex(index);
                    }
                    index += maxLines[idx];
                }
                if (context.getResourceType() > 1) continue;
                for (idx = 0; idx < length; ++idx) {
                    for (s = 0; s < 288; ++s) {
                        c = TimetableGridHelper.getCell(weekData, d, s, idx);
                        if (c == null || c.getSlot() != s || (empty = TimetableGridHelper.nrEmptyAbove(weekData, d, s, idx, length, c)) <= 0) continue;
                        lines = maxLines[idx];
                        for (i = 1; i <= empty; ++i) {
                            lines += maxLines[idx + i];
                        }
                        c.setNrLines(lines);
                    }
                }
            }
            if (context.isShowFreeTimes()) {
                TimetableGridInterface.TimetableGridCell[][][] data = new TimetableGridInterface.TimetableGridCell[7][288][];
                for (int d = 0; d < 7; ++d) {
                    for (int s4 = 0; s4 < 288; ++s4) {
                        data[d][s4] = null;
                    }
                }
                for (TimetableGridInterface.TimetableGridCell cell : model.getCells()) {
                    TimetableGridHelper.addCell(data, cell.getDay(), cell.getSlot(), cell.getLength(), cell);
                }
                TimetableGridHelper.initBgModeUselessSlots(model, data);
            }
        } else {
            int d;
            TimetableGridInterface.TimetableGridCell[][][] data = new TimetableGridInterface.TimetableGridCell[7][288][];
            for (int d2 = 0; d2 < 7; ++d2) {
                for (int s5 = 0; s5 < 288; ++s5) {
                    data[d2][s5] = null;
                }
            }
            for (TimetableGridInterface.TimetableGridCell cell : model.getCells()) {
                TimetableGridHelper.addCell(data, cell.getDay(), cell.getSlot(), cell.getLength(), cell);
            }
            if (context.isVertical()) {
                for (d = 0; d < 7; ++d) {
                    TimetableGridInterface.TimetableGridCell c2;
                    int s6;
                    int idx;
                    int length = 0;
                    for (int s7 = 0; s7 < 288; ++s7) {
                        if (data[d][s7] == null || data[d][s7].length <= length) continue;
                        length = data[d][s7].length;
                    }
                    for (idx = 0; idx < length; ++idx) {
                        for (s6 = 0; s6 < 288; ++s6) {
                            c2 = TimetableGridHelper.getCell(data, d, s6, idx);
                            if (c2 == null) continue;
                            c2.setIndex(idx);
                            c2.setNrLines(1);
                        }
                    }
                    if (context.getResourceType() > 1) continue;
                    for (idx = 0; idx < length; ++idx) {
                        for (s6 = 0; s6 < 288; ++s6) {
                            int empty2;
                            c2 = TimetableGridHelper.getCell(data, d, s6, idx);
                            if (c2 == null || c2.getSlot() != s6 || (empty2 = TimetableGridHelper.nrEmptyAbove(data, d, s6, idx, length, c2)) <= 0) continue;
                            c2.setNrLines(1 + empty2);
                        }
                    }
                }
            } else {
                for (d = 0; d < 7; ++d) {
                    int idx;
                    int length = 0;
                    for (int s8 = 0; s8 < 288; ++s8) {
                        if (data[d][s8] == null || data[d][s8].length <= length) continue;
                        length = data[d][s8].length;
                    }
                    int[] maxLines = new int[length];
                    index = 0;
                    for (idx = 0; idx < length; ++idx) {
                        maxLines[idx] = 0;
                        for (s = 0; s < 288; ++s) {
                            c = TimetableGridHelper.getCell(data, d, s, idx);
                            if (c == null || maxLines[idx] >= c.getMinLines(context.isShowRoom(), context.isShowInstructor(), context.isShowTime(), context.isShowPreference(), context.isShowDate())) continue;
                            maxLines[idx] = c.getMinLines(context.isShowRoom(), context.isShowInstructor(), context.isShowTime(), context.isShowPreference(), context.isShowDate());
                        }
                        for (s = 0; s < 288; ++s) {
                            c = TimetableGridHelper.getCell(data, d, s, idx);
                            if (c == null) continue;
                            c.setNrLines(maxLines[idx]);
                            c.setIndex(index);
                        }
                        index += maxLines[idx];
                    }
                    if (context.getResourceType() > 1) continue;
                    for (idx = 0; idx < length; ++idx) {
                        for (s = 0; s < 288; ++s) {
                            c = TimetableGridHelper.getCell(data, d, s, idx);
                            if (c == null || c.getSlot() != s || (empty = TimetableGridHelper.nrEmptyAbove(data, d, s, idx, length, c)) <= 0) continue;
                            lines = maxLines[idx];
                            for (i = 1; i <= empty; ++i) {
                                lines += maxLines[idx + i];
                            }
                            c.setNrLines(lines);
                        }
                    }
                }
            }
            if (context.isShowFreeTimes()) {
                TimetableGridHelper.initBgModeUselessSlots(model, data);
            }
        }
        if (context.getBgMode() == BgMode.None.ordinal()) {
            block32: for (TimetableGridInterface.TimetableGridCell cell : model.getCells()) {
                if (sBgColorNotAvailable.equals(cell.getBackground())) continue;
                for (int s9 = 0; s9 < cell.getLength(); ++s9) {
                    if (model.isAvailable(cell.getDay(), cell.getSlot() + s9)) continue;
                    cell.setBackground(sBgColorNotAvailableButAssigned);
                    continue block32;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CombinedIterator<T>
    implements Iterator<T> {
        private Iterable<T>[] iItems;
        private Iterator<T> iIterator;
        private int iIdx;

        public CombinedIterator(Iterable<T> ... items) {
            this.iItems = items;
            this.iIdx = -1;
            this.iIterator = null;
        }

        @Override
        public boolean hasNext() {
            if (this.iIterator != null && this.iIterator.hasNext()) {
                return true;
            }
            do {
                ++this.iIdx;
                if (this.iIdx >= this.iItems.length) {
                    return false;
                }
                this.iIterator = this.iItems[this.iIdx].iterator();
            } while (!this.iIterator.hasNext());
            return true;
        }

        @Override
        public T next() {
            return this.iIterator.next();
        }

        @Override
        public void remove() {
            this.iIterator.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Combine<T>
    implements Iterable<T> {
        private Iterable<T>[] iItems;

        public Combine(Iterable<T> ... items) {
            this.iItems = items;
        }

        @Override
        public Iterator<T> iterator() {
            return new CombinedIterator<T>(this.iItems);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DisplayMode {
        InRow,
        PerWeekHorizontal,
        PerWeekVertical,
        WeekByWeekHorizontal;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OrderBy {
        NameAsc,
        NameDesc,
        SizeAsc,
        SizeDesc,
        TypeAsc,
        TypeDesc,
        UtilizationAsc,
        UtilizationDesc;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BgMode {
        None,
        TimePref,
        RoomPref,
        StudentConf,
        InstructorBtbPref,
        DistributionConstPref,
        Perturbations,
        PerturbationPenalty,
        HardConflicts,
        DepartmentalBalancing,
        TooBigRooms,
        StudentGroups;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ResourceType {
        ROOM,
        INSTRUCTOR,
        DEPARTMENT,
        CURRICULUM,
        SUBJECT_AREA,
        STUDENT_GROUP;

    }
}

