/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.solver;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.cpsolver.coursett.constraint.FlexibleConstraint;
import org.cpsolver.coursett.constraint.GroupConstraint;
import org.cpsolver.coursett.constraint.InstructorConstraint;
import org.cpsolver.coursett.constraint.JenrlConstraint;
import org.cpsolver.coursett.criteria.StudentOverlapConflict;
import org.cpsolver.coursett.criteria.placement.DeltaTimePreference;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.criteria.Criterion;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solver.Solver;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.CPSolverMessages;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SuggestionsInterface;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.ConstraintInfo;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.ExactTimeMins;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.dao.AssignmentDAO;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.solver.SuggestionsContext;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.service.AssignmentService;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.solver.ui.AssignmentPreferenceInfo;
import org.unitime.timetable.solver.ui.BtbInstructorConstraintInfo;
import org.unitime.timetable.solver.ui.GroupConstraintInfo;
import org.unitime.timetable.solver.ui.JenrlInfo;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.duration.DurationModel;
import org.unitime.timetable.webutil.timegrid.SolutionGridModel;
import org.unitime.timetable.webutil.timegrid.SolverGridModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtRpcImplements(value=SuggestionsInterface.ClassAssignmentDetailsRequest.class)
public class ClassAssignmentDetailsBackend
implements GwtRpcImplementation<SuggestionsInterface.ClassAssignmentDetailsRequest, SuggestionsInterface.ClassAssignmentDetails> {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    protected static CPSolverMessages MSG = Localization.create(CPSolverMessages.class);
    @Autowired
    SolverService<SolverProxy> courseTimetablingSolverService;
    @Autowired
    AssignmentService<ClassAssignmentProxy> classAssignmentService;

    @Override
    public SuggestionsInterface.ClassAssignmentDetails execute(SuggestionsInterface.ClassAssignmentDetailsRequest request, SessionContext context) {
        SolverProxy solver;
        context.checkPermission(Right.Suggestions);
        SuggestionsContext cx = new SuggestionsContext();
        String instructorFormat = context.getUser().getProperty(UserProperty.NameFormat);
        if (instructorFormat != null) {
            cx.setInstructorNameFormat(instructorFormat);
        }
        if ((solver = this.courseTimetablingSolverService.getSolver()) != null) {
            SuggestionsInterface.ClassAssignmentDetails details = solver.getClassAssignmentDetails(cx, request.getClassId(), true, true);
            if (details != null) {
                return details;
            }
            try {
                Class_ clazz = (Class_)Class_DAO.getInstance().get(request.getClassId());
                if (clazz == null) {
                    throw new GwtRpcException(MESSAGES.errorClassDoesNotExist(request.getClassId()));
                }
                Assignment assignment = solver.getAssignment(clazz);
                if (assignment == null || assignment.getSolution() == null) {
                    return ClassAssignmentDetailsBackend.createClassAssignmentDetailsFromClass(cx, clazz);
                }
                return ClassAssignmentDetailsBackend.createClassAssignmentDetailsFromAssignment(cx, assignment, true);
            }
            catch (Exception e) {
                throw new GwtRpcException(e.getMessage(), e);
            }
        }
        ClassAssignmentProxy proxy = this.classAssignmentService.getAssignment();
        if (proxy != null) {
            Assignment assignment = proxy.getAssignment(request.getClassId());
            if (assignment != null) {
                return ClassAssignmentDetailsBackend.createClassAssignmentDetailsFromAssignment(cx, assignment, true);
            }
            Class_ clazz = (Class_)Class_DAO.getInstance().get(request.getClassId());
            if (clazz == null) {
                throw new GwtRpcException(MESSAGES.errorClassDoesNotExist(request.getClassId()));
            }
            return ClassAssignmentDetailsBackend.createClassAssignmentDetailsFromClass(cx, clazz);
        }
        return null;
    }

    public static SuggestionsInterface.ClassAssignmentDetails createClassAssignmentDetails(SuggestionsContext context, Solver solver, Lecture lecture, boolean includeDomain, boolean includeConstraints) {
        return ClassAssignmentDetailsBackend.createClassAssignmentDetails(context, solver, lecture, (Placement)solver.currentSolution().getAssignment().getValue((Variable)lecture), includeDomain, includeConstraints);
    }

    public static SuggestionsInterface.ClassAssignmentDetails createClassAssignmentDetails(SuggestionsContext context, Solver solver, Lecture lecture, Placement placement, boolean includeDomain, boolean includeConstraints) {
        Placement initialPlacement;
        org.cpsolver.ifs.assignment.Assignment assignment = solver.currentSolution().getAssignment();
        SuggestionsInterface.ClassAssignmentDetails details = new SuggestionsInterface.ClassAssignmentDetails();
        details.setCanUnassign(!lecture.isCommitted());
        details.setClazz(new SuggestionsInterface.ClassInfo(lecture.getName(), lecture.getClassId(), lecture.getNrRooms(), SolverGridModel.hardConflicts2pref((org.cpsolver.ifs.assignment.Assignment<Lecture, Placement>)solver.currentSolution().getAssignment(), lecture, placement), lecture.minRoomSize(), lecture.getOrd(), lecture.getNote()));
        if (placement != null) {
            if (placement.isMultiRoom()) {
                for (RoomLocation room : placement.getRoomLocations()) {
                    details.setRoom(new SuggestionsInterface.RoomInfo(room.getName(), room.getId(), room.getRoomSize(), room.getPreference() == 0 && lecture.nrRoomLocations() == lecture.getNrRooms() ? PreferenceLevel.sIntLevelRequired : room.getPreference()));
                }
            } else {
                RoomLocation room = placement.getRoomLocation();
                details.setRoom(new SuggestionsInterface.RoomInfo(room.getName(), room.getId(), room.getRoomSize(), room.getPreference() == 0 && lecture.nrRoomLocations() == lecture.getNrRooms() ? PreferenceLevel.sIntLevelRequired : room.getPreference()));
            }
            TimeLocation time = placement.getTimeLocation();
            int min = Constants.SLOT_LENGTH_MIN * time.getNrSlotsPerMeeting() - time.getBreakTime();
            details.setTime(new SuggestionsInterface.TimeInfo(time.getDayCode(), time.getStartSlot(), time.getPreference() == 0 && lecture.nrTimeLocations() == 1 ? PreferenceLevel.sIntLevelRequired : time.getPreference(), min, time.getDatePatternName(), time.getTimePatternId(), time.getDatePatternId(), time.getDatePatternPreference()));
            if (!lecture.getInstructorConstraints().isEmpty()) {
                for (int i = 0; i < lecture.getInstructorConstraints().size(); ++i) {
                    InstructorConstraint ic = (InstructorConstraint)lecture.getInstructorConstraints().get(i);
                    details.setInstructor(new SuggestionsInterface.InstructorInfo(ic.getName(), ic.getResourceId()));
                }
            }
            Map<String, String> translations = context.courseObjectives();
            for (Criterion criterion : lecture.getModel().getCriteria()) {
                String translatedName;
                if (criterion instanceof StudentOverlapConflict || criterion instanceof DeltaTimePreference) continue;
                String string = translatedName = translations == null || translations.isEmpty() ? null : translations.get(criterion.getName());
                if (translatedName != null) {
                    details.setObjective(translatedName, criterion.getValue(assignment, (Value)placement, null));
                    continue;
                }
                details.setObjective(criterion.getName(), criterion.getValue(assignment, (Value)placement, null));
            }
        }
        if ((initialPlacement = (Placement)lecture.getInitialAssignment()) != null) {
            if (initialPlacement.isMultiRoom()) {
                for (RoomLocation room : initialPlacement.getRoomLocations()) {
                    details.setInitialRoom(new SuggestionsInterface.RoomInfo(room.getName(), room.getId(), room.getRoomSize(), room.getPreference() == 0 && lecture.nrRoomLocations() == lecture.getNrRooms() ? PreferenceLevel.sIntLevelRequired : room.getPreference()));
                }
            } else {
                RoomLocation room = initialPlacement.getRoomLocation();
                details.setInitialRoom(new SuggestionsInterface.RoomInfo(room.getName(), room.getId(), room.getRoomSize(), room.getPreference() == 0 && lecture.nrRoomLocations() == lecture.getNrRooms() ? PreferenceLevel.sIntLevelRequired : room.getPreference()));
            }
            TimeLocation time = initialPlacement.getTimeLocation();
            int min = Constants.SLOT_LENGTH_MIN * time.getNrSlotsPerMeeting() - time.getBreakTime();
            details.setInitialTime(new SuggestionsInterface.TimeInfo(time.getDayCode(), time.getStartSlot(), time.getPreference() == 0 && lecture.nrTimeLocations() == 1 ? PreferenceLevel.sIntLevelRequired : time.getPreference(), min, time.getDatePatternName(), time.getTimePatternId(), time.getDatePatternId(), time.getDatePatternPreference()));
        }
        if (includeDomain) {
            for (TimeLocation time : lecture.timeLocations()) {
                int min = Constants.SLOT_LENGTH_MIN * time.getNrSlotsPerMeeting() - time.getBreakTime();
                details.addTime(new SuggestionsInterface.TimeInfo(time.getDayCode(), time.getStartSlot(), time.getPreference() == 0 && lecture.nrTimeLocations() == 1 ? PreferenceLevel.sIntLevelRequired : time.getPreference(), min, time.getDatePatternName(), time.getTimePatternId(), time.getDatePatternId(), time.getDatePatternPreference()));
            }
            for (RoomLocation room : lecture.roomLocations()) {
                details.addRoom(new SuggestionsInterface.RoomInfo(room.getName(), room.getId(), room.getRoomSize(), room.getPreference() == 0 && lecture.nrRoomLocations() == lecture.getNrRooms() ? PreferenceLevel.sIntLevelRequired : room.getPreference()));
            }
        }
        if (includeConstraints) {
            for (JenrlConstraint jenrl : lecture.activeJenrls(assignment)) {
                Lecture another = (Lecture)jenrl.another((Variable)lecture);
                if (jenrl.isToBeIgnored() || jenrl.getJenrl() <= 0L) continue;
                details.addStudentConflict(new SuggestionsInterface.StudentConflictInfo(ClassAssignmentDetailsBackend.toJenrlInfo(new JenrlInfo(solver, jenrl)), ClassAssignmentDetailsBackend.createClassAssignmentDetails(context, solver, another, false, false)));
            }
            if (placement != null) {
                Hashtable<Long, JenrlInfo> infos = JenrlInfo.getCommitedJenrlInfos(solver, lecture);
                for (Map.Entry<Long, JenrlInfo> entry : infos.entrySet()) {
                    Long assignmentId = entry.getKey();
                    Iterator jInfo = entry.getValue();
                    details.addStudentConflict(new SuggestionsInterface.StudentConflictInfo(ClassAssignmentDetailsBackend.toJenrlInfo((JenrlInfo)((Object)jInfo)), ClassAssignmentDetailsBackend.createClassAssignmentDetailsFromAssignment(context, assignmentId, false)));
                }
            }
            for (Constraint c : lecture.constraints()) {
                SuggestionsInterface.DistributionInfo dist;
                GroupConstraint gc;
                if (c instanceof GroupConstraint) {
                    gc = (GroupConstraint)c;
                    dist = new SuggestionsInterface.DistributionInfo();
                    dist.setInfo(ClassAssignmentDetailsBackend.toGroupConstraintInfo(new GroupConstraintInfo((org.cpsolver.ifs.assignment.Assignment<Lecture, Placement>)assignment, gc)));
                    for (Lecture another : gc.variables()) {
                        if (another.equals((Object)lecture)) continue;
                        dist.addClass(ClassAssignmentDetailsBackend.createClassAssignmentDetails(context, solver, another, false, false));
                    }
                    details.addDistributionConflict(dist);
                }
                if (!(c instanceof FlexibleConstraint)) continue;
                gc = (FlexibleConstraint)c;
                dist = new SuggestionsInterface.DistributionInfo();
                dist.setInfo(ClassAssignmentDetailsBackend.toGroupConstraintInfo(new GroupConstraintInfo((org.cpsolver.ifs.assignment.Assignment<Lecture, Placement>)assignment, (FlexibleConstraint)gc)));
                for (Lecture another : gc.variables()) {
                    if (another.equals((Object)lecture)) continue;
                    dist.addClass(ClassAssignmentDetailsBackend.createClassAssignmentDetails(context, solver, another, false, false));
                }
                details.addDistributionConflict(dist);
            }
            if (!lecture.getInstructorConstraints().isEmpty() && placement != null) {
                for (InstructorConstraint ic : lecture.getInstructorConstraints()) {
                    for (Lecture other : ic.variables()) {
                        int pref;
                        if (other.equals((Object)lecture) || assignment.getValue((Variable)other) == null || (pref = ic.getDistancePreference(placement, (Placement)assignment.getValue((Variable)other))) == PreferenceLevel.sIntLevelNeutral) continue;
                        details.addBtbInstructorConflict(new SuggestionsInterface.BtbInstructorInfo(ClassAssignmentDetailsBackend.createClassAssignmentDetails(context, solver, other, false, false), pref));
                    }
                }
            }
        }
        return details;
    }

    public static SuggestionsInterface.ClassAssignmentDetails createClassAssignmentDetailsFromAssignment(SuggestionsContext context, Long assignmentId, boolean includeConstraints) {
        return ClassAssignmentDetailsBackend.createClassAssignmentDetailsFromAssignment(context, (Assignment)AssignmentDAO.getInstance().get(assignmentId), includeConstraints);
    }

    public static SuggestionsInterface.ClassAssignmentDetails createClassAssignmentDetailsFromClass(SuggestionsContext context, Class_ clazz) {
        SuggestionsInterface.ClassAssignmentDetails details = new SuggestionsInterface.ClassAssignmentDetails();
        details.setClazz(new SuggestionsInterface.ClassInfo(clazz.getClassLabel(), clazz.getUniqueId(), clazz.getNbrRooms(), PreferenceLevel.sProhibited, -1, 0, clazz.getNotes()));
        details.setCanUnassign(false);
        return details;
    }

    public static SuggestionsInterface.ClassAssignmentDetails createClassAssignmentDetailsFromAssignment(SuggestionsContext context, Assignment assignment, boolean includeConstraints) {
        if (assignment == null) {
            return null;
        }
        SuggestionsInterface.ClassAssignmentDetails details = new SuggestionsInterface.ClassAssignmentDetails();
        AssignmentPreferenceInfo assignmentInfo = (AssignmentPreferenceInfo)assignment.getAssignmentInfo("AssignmentInfo");
        if (!assignment.getRooms().isEmpty()) {
            for (Location room : assignment.getRooms()) {
                details.setRoom(new SuggestionsInterface.RoomInfo(room.getLabel(), room.getUniqueId(), room.getCapacity(), assignmentInfo == null ? 0 : assignmentInfo.getRoomPreference(room.getUniqueId())));
            }
        }
        int length = assignment.getTimePattern().getSlotsPerMtg();
        int breakTime = assignment.getTimePattern().getBreakTime();
        if (assignment.getTimePattern().getType() == 5) {
            DurationModel dm = assignment.getClazz().getSchedulingSubpart().getInstrOfferingConfig().getDurationModel();
            int minsPerMeeting = dm.getExactTimeMinutesPerMeeting(assignment.getClazz().getSchedulingSubpart().getMinutesPerWk(), assignment.getDatePattern(), assignment.getDays());
            length = ExactTimeMins.getNrSlotsPerMtg(minsPerMeeting);
            breakTime = ExactTimeMins.getBreakTime(minsPerMeeting);
        }
        int min = Constants.SLOT_LENGTH_MIN * length - breakTime;
        DatePattern datePattern = assignment.getDatePattern();
        details.setTime(new SuggestionsInterface.TimeInfo(assignment.getDays(), assignment.getStartSlot(), assignmentInfo == null ? 0 : assignmentInfo.getTimePreference(), min, datePattern == null ? "not set" : datePattern.getName(), assignment.getTimePattern().getUniqueId(), datePattern == null ? null : datePattern.getUniqueId(), assignmentInfo == null ? 0 : assignmentInfo.getDatePatternPref()));
        TreeSet<DepartmentalInstructor> instructors = new TreeSet<DepartmentalInstructor>();
        if (ApplicationProperty.TimetableGridUseClassInstructors.isTrue()) {
            if (!ApplicationProperty.TimetableGridUseClassInstructorsCheckClassDisplayInstructors.isTrue() || assignment.getClazz().isDisplayInstructor().booleanValue()) {
                for (ClassInstructor classInstructor : assignment.getClazz().getClassInstructors()) {
                    if (!classInstructor.isLead().booleanValue() && ApplicationProperty.TimetableGridUseClassInstructorsCheckLead.isTrue()) continue;
                    instructors.add(classInstructor.getInstructor());
                }
            }
        } else {
            instructors.addAll(assignment.getInstructors());
        }
        if (instructors != null && !instructors.isEmpty()) {
            for (DepartmentalInstructor departmentalInstructor : instructors) {
                details.setInstructor(new SuggestionsInterface.InstructorInfo(departmentalInstructor.getName(context.getInstructorNameFormat()), departmentalInstructor.getUniqueId()));
            }
        }
        if (includeConstraints) {
            Assignment another;
            Serializable info;
            ConstraintInfo constraint;
            for (Map.Entry entry : assignment.getConstraintInfoTable("JenrlInfo").entrySet()) {
                constraint = (ConstraintInfo)entry.getKey();
                info = (JenrlInfo)entry.getValue();
                another = null;
                for (Assignment x : constraint.getAssignments()) {
                    if (x.getUniqueId().equals(assignment.getUniqueId())) continue;
                    another = x;
                    break;
                }
                details.addStudentConflict(new SuggestionsInterface.StudentConflictInfo(ClassAssignmentDetailsBackend.toJenrlInfo((JenrlInfo)info), ClassAssignmentDetailsBackend.createClassAssignmentDetailsFromAssignment(context, another, false)));
            }
            for (Map.Entry entry : assignment.getConstraintInfoTable("DistributionInfo").entrySet()) {
                constraint = (ConstraintInfo)entry.getKey();
                info = (GroupConstraintInfo)entry.getValue();
                SuggestionsInterface.DistributionInfo dist = new SuggestionsInterface.DistributionInfo(ClassAssignmentDetailsBackend.toGroupConstraintInfo((GroupConstraintInfo)info));
                for (Assignment another2 : constraint.getAssignments()) {
                    if (another2.getUniqueId().equals(assignment.getUniqueId())) continue;
                    dist.addClass(ClassAssignmentDetailsBackend.createClassAssignmentDetailsFromAssignment(context, another2, false));
                }
                details.addDistributionConflict(dist);
            }
            for (Map.Entry entry : assignment.getConstraintInfoTable("BtbInstructorInfo").entrySet()) {
                constraint = (ConstraintInfo)entry.getKey();
                info = (BtbInstructorConstraintInfo)entry.getValue();
                another = null;
                for (Assignment x : constraint.getAssignments()) {
                    if (x.getUniqueId().equals(assignment.getUniqueId())) continue;
                    another = x;
                    break;
                }
                details.addBtbInstructorConflict(new SuggestionsInterface.BtbInstructorInfo(ClassAssignmentDetailsBackend.createClassAssignmentDetailsFromAssignment(context, another, false), ((BtbInstructorConstraintInfo)info).getPreference()));
            }
        }
        details.setClazz(new SuggestionsInterface.ClassInfo(assignment.getClassName(), assignment.getClassId(), assignment.getRooms().size(), SolutionGridModel.hardConflicts2pref(assignmentInfo), -1, 0, assignment.getClazz().getNotes()));
        details.setCanUnassign(false);
        return details;
    }

    public static SuggestionsInterface.JenrlInfo toJenrlInfo(JenrlInfo info) {
        SuggestionsInterface.JenrlInfo ret = new SuggestionsInterface.JenrlInfo();
        ret.setJenrl((int)Math.round(info.getJenrl()));
        ret.setIsSatisfied(info.isSatisfied());
        ret.setIsHard(info.isHard());
        ret.setIsDistance(info.isDistance());
        ret.setIsFixed(info.isFixed());
        ret.setIsCommited(info.isCommited());
        ret.setIsImportant(info.isImportant());
        ret.setIsWorkDay(info.isWorkDay());
        ret.setIsInstructor(info.isInstructor());
        ret.setDistance(info.getDistance());
        if (info.hasCurricula()) {
            for (JenrlInfo.CurriculumInfo cur : info.getCurricula()) {
                ret.addCurriculum(new SuggestionsInterface.CurriculumInfo(cur.getName(), (int)Math.round(cur.getNrStudents())));
            }
        }
        return ret;
    }

    public static SuggestionsInterface.GroupConstraintInfo toGroupConstraintInfo(GroupConstraintInfo info) {
        SuggestionsInterface.GroupConstraintInfo ret = new SuggestionsInterface.GroupConstraintInfo();
        ret.setPreference(info.getPreference());
        ret.setIsSatisfied(info.isSatisfied());
        ret.setName(info.getName());
        ret.setType(info.getType());
        return ret;
    }
}

