/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.sectioning;

import java.util.Properties;
import org.cpsolver.ifs.util.CSVFile;
import org.cpsolver.ifs.util.DataProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.client.sectioning.SectioningReports;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.basic.GenerateSectioningReport;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.service.SolverServerService;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.solver.studentsct.StudentSolverProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtRpcImplements(value=SectioningReports.SectioningReportRpcRequest.class)
public class SectioningReportsBackend
implements GwtRpcImplementation<SectioningReports.SectioningReportRpcRequest, SectioningReports.SectioningReportRpcResponse> {
    protected static GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    @Autowired
    SolverService<StudentSolverProxy> studentSectioningSolverService;
    @Autowired
    SolverServerService solverServerService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SectioningReports.SectioningReportRpcResponse execute(SectioningReports.SectioningReportRpcRequest request, SessionContext context) {
        DataProperties parameters = new DataProperties(request.getParameters());
        CSVFile csv = null;
        boolean online = parameters.getPropertyBoolean("online", false);
        parameters.setProperty("useAmPm", CONSTANTS.useAmPm() ? "true" : "false");
        if (online) {
            context.checkPermission(Right.SchedulingReports);
            OnlineSectioningServer server = this.solverServerService.getOnlineStudentSchedulingContainer().getSolver(context.getUser().getCurrentAcademicSessionId().toString());
            if (server == null) {
                throw new GwtRpcException("Online student scheduling is not enabled for " + context.getUser().getCurrentAuthority().getQualifiers("Session").get(0).getQualifierLabel() + ".");
            }
            OnlineSectioningLog.Entity user = OnlineSectioningLog.Entity.newBuilder().setExternalId(context.getUser().getExternalUserId()).setName(context.getUser().getName() == null ? context.getUser().getUsername() : context.getUser().getName()).setType(context.hasPermission(Right.StudentSchedulingAdvisor) ? OnlineSectioningLog.Entity.EntityType.MANAGER : OnlineSectioningLog.Entity.EntityType.STUDENT).build();
            csv = server.execute(server.createAction(GenerateSectioningReport.class).withParameters((Properties)parameters), user);
        } else {
            context.checkPermission(Right.StudentSectioningSolver);
            StudentSolverProxy solver = this.studentSectioningSolverService.getSolver();
            if (solver == null) {
                throw new GwtRpcException("No student solver is running.");
            }
            csv = solver.getReport(parameters);
        }
        if (csv == null) {
            throw new GwtRpcException("No report was created.");
        }
        SectioningReports.SectioningReportRpcResponse response = new SectioningReports.SectioningReportRpcResponse();
        CSVFile cSVFile = csv;
        synchronized (cSVFile) {
            String[] header = new String[csv.getHeader().getFields().size()];
            for (int i = 0; i < csv.getHeader().getFields().size(); ++i) {
                header[i] = csv.getHeader().getField(i).toString();
            }
            response.addLine(header);
            if (csv.getLines() != null) {
                for (CSVFile.CSVLine line : csv.getLines()) {
                    String[] row = new String[line.getFields().size()];
                    for (int i = 0; i < line.getFields().size(); ++i) {
                        row[i] = line.getField(i).toString();
                    }
                    response.addLine(row);
                }
            }
        }
        return response;
    }
}

