/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.script;

import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.events.DateSelectorBackend;
import org.unitime.timetable.events.EventAction;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.AcademicSessionProvider;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.ScriptInterface;
import org.unitime.timetable.gwt.shared.TaskInterface;
import org.unitime.timetable.model.Script;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.dao.ScriptDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.script.LoadAllScriptsBackend;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtRpcImplements(value=TaskInterface.GetTaskOptionsRpcRequest.class)
public class TaskOptionsBackend
implements GwtRpcImplementation<TaskInterface.GetTaskOptionsRpcRequest, TaskInterface.TaskOptionsInterface> {
    @Override
    public TaskInterface.TaskOptionsInterface execute(TaskInterface.GetTaskOptionsRpcRequest request, SessionContext context) {
        context.checkPermission(Right.Tasks);
        TaskInterface.TaskOptionsInterface options = new TaskInterface.TaskOptionsInterface();
        options.setCanAdd(context.hasPermission(Right.TaskEdit));
        for (Script s : ScriptDAO.getInstance().findAll()) {
            ScriptInterface script = LoadAllScriptsBackend.load(s, context);
            if (script == null) continue;
            options.addScript(script);
        }
        Collections.sort(options.getScripts());
        TimetableManager manager = TimetableManager.findByExternalId(context.getUser().getExternalUserId());
        if (manager != null) {
            String nameFormat = context.getUser().getProperty(UserProperty.NameFormat);
            EventInterface.ContactInterface contact = new EventInterface.ContactInterface();
            contact.setAcademicTitle(manager.getAcademicTitle());
            contact.setEmail(manager.getEmailAddress());
            contact.setExternalId(manager.getExternalUniqueId());
            contact.setFirstName(manager.getFirstName());
            contact.setMiddleName(manager.getMiddleName());
            contact.setLastName(manager.getLastName());
            contact.setFormattedName(manager.getName(nameFormat));
            options.setManager(contact);
        } else {
            options.setCanAdd(false);
        }
        Session session = (Session)SessionDAO.getInstance().get(context.getUser().getCurrentAcademicSessionId());
        if (session != null) {
            options.setSession(new AcademicSessionProvider.AcademicSessionInfo(session.getUniqueId(), session.getAcademicYear(), session.getAcademicTerm(), session.getAcademicInitiative(), session.getLabel()));
            options.setSessionMonth(DateSelectorBackend.listMonths(session, context.hasPermission(Right.EventDateMappings), new SimplePastOrOutside(session), ApplicationProperty.DatePatternNrExessMonth.intValue(), false));
        } else {
            options.setCanAdd(false);
        }
        return options;
    }

    static class SimplePastOrOutside
    implements EventAction.HasPastOrOutside {
        private Date iToday;

        SimplePastOrOutside(Session session) {
            Calendar cal = Calendar.getInstance(Localization.getJavaLocale());
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            this.iToday = cal.getTime();
        }

        public boolean isOutside(Date date) {
            return false;
        }

        public boolean isPast(Date date) {
            return date == null || date.before(this.iToday);
        }

        public boolean isPastOrOutside(Date date) {
            return this.isPast(date) || this.isOutside(date);
        }
    }
}

